/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.framework.CUIDGetterFacadeFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerSaleInfoCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerSaleInfoFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerSaleInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitCollection;
import com.kingdee.eas.basedata.org.SaleOrgUnitFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.InvoiceReasonEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.ISCMBillParam;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.SCMBillParamFactory;
import com.kingdee.eas.scm.common.SCMGroupFacadeFactory;
import com.kingdee.eas.scm.common.loadmass.SCMBizDataVO;
import com.kingdee.eas.scm.common.util.ParamsUtil;
import com.kingdee.eas.scm.common.util.SCMUtil;
import com.kingdee.eas.scm.sd.sale.ISaleOrderEntry;
import com.kingdee.eas.scm.sd.sale.PriceTypeEnum;
import com.kingdee.eas.scm.sd.sale.ReceiveDispatcherTypeEnum;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryCollection;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleReturnsEntryCollection;
import com.kingdee.eas.scm.sd.sale.SaleReturnsEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleReturnsFactory;
import com.kingdee.eas.scm.sd.sale.SaleReturnsInfo;
import com.kingdee.eas.scm.sd.sale.app.AbstractSaleReturnsWebFacadeControllerBean;
import com.kingdee.eas.scm.util.constant.SCMConstant;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SaleReturnsWebFacadeControllerBean
extends AbstractSaleReturnsWebFacadeControllerBean {
    protected static final BigDecimal ZERO = new BigDecimal("0.00");
    private static BigDecimal DEFAULT_TAXRATE = SCMConstant.DefaultTaxRate;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sd.sale.app.SaleReturnsWebFacadeControllerBean");

    protected Map _handleBillByOprtState(Context ctx, String id, String oprtState) throws BOSException, EASBizException {
        return null;
    }

    protected Map _handleBillByCopy(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        return null;
    }

    protected IObjectValue _createModel(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CompanyOrgUnitInfo cou;
        SaleReturnsInfo info = (SaleReturnsInfo)SaleReturnsFactory.getLocalInstance(ctx).createNewData(false);
        info.setId(BOSUuid.read((String)model.get("id").toString()));
        info.setBaseStatus(BillBaseStatusEnum.ADD);
        info.setIsInTax(true);
        UserInfo user = UserFactory.getLocalInstance((Context)ctx).getUserInfo(ctx.getCaller());
        info.setCreator(user);
        info.setReturnsReason(InvoiceReasonEnum.RETURNREJECT);
        SaleOrgUnitInfo sou = ((SaleReturnsInfo)model).getSaleOrgUnit();
        info.setSaleOrgUnit(sou);
        if (sou == null) {
            return info;
        }
        if (sou.getCU() != null) {
            info.setCU(sou.getCU());
        }
        if ((cou = this.getCouBySou(ctx, sou.getId().toString())) != null && cou.getBaseCurrency() != null) {
            info.setCompanyOrgUnit(cou);
            info.setCurrency(this.getBaseCurrencyByCou(ctx, cou));
            info.setExchangeRate(SCMUtil.BIGDECIMAL_ONE);
        }
        SaleReturnsEntryInfo entryInfo = this.createEntryData(ctx, info);
        info.getEntries().clear();
        info.getEntries().add(entryInfo);
        if (entryInfo.isIsBetweenCompanySend()) {
            info.setIsCentralBalance(true);
        }
        return info;
    }

    protected Map _getInitData(Context ctx, IObjectValue model, String oprtState) throws BOSException, EASBizException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        SaleReturnsInfo info = (SaleReturnsInfo)model;
        if (info.getSaleOrgUnit() == null) {
            return map;
        }
        String bizOrgCUID = CUIDGetterFacadeFactory.getLocalInstance((Context)ctx).getCUID(info.getSaleOrgUnit().getId().toString());
        map.put("bizOrgCUID", bizOrgCUID);
        CompanyOrgUnitInfo cou = null;
        cou = this.getCouBySou(ctx, info.getSaleOrgUnit().getId().toString());
        map.put("cou", cou);
        map.put("baseCurrency", this.getBaseCurrencyByCou(ctx, cou));
        map.put("exchangeRateColl", this.getExchangeRateCollByCou(ctx, cou.getId().toString()));
        if (info.getCurrency() != null) {
            map.put("currency", CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(info.getCurrency().getId()), this.getCurrencySelectors()));
        }
        AdminOrgUnitInfo admin = null;
        String enable_sale_admin = this.getParamValue(new ObjectUuidPK(info.getSaleOrgUnit().getId().toString()), "SALEORDER001");
        if (enable_sale_admin != null && !Boolean.valueOf(enable_sale_admin).booleanValue() && info.getSaleOrgUnit().getId().toString() != null) {
            OrgUnitCollection coll = this.getAdminOrgUnitBySou(ctx, info.getSaleOrgUnit().getId().toString());
            if (coll != null && coll.size() > 0) {
                int size = coll.size();
                for (int i = 0; i < size; ++i) {
                    if (coll.get(i) == null || coll.get(i).getId() == null || !coll.get(i).getId().toString().equals(info.getSaleOrgUnit().getId().toString())) continue;
                    admin = (AdminOrgUnitInfo)coll.get(i);
                    break;
                }
                if (admin == null && coll.get(0) != null) {
                    admin = (AdminOrgUnitInfo)coll.get(0);
                }
            }
            map.put("adminOrg", admin);
        } else {
            map.put("adminOrg", null);
        }
        SaleReturnsEntryInfo entry = null;
        SaleReturnsEntryCollection entryColl = info.getEntries();
        for (int i = 0; i < entryColl.size(); ++i) {
            entry = entryColl.get(i);
            if (info.getBaseStatus() != BillBaseStatusEnum.ADD || info.getSourceBillType() == null || entry.getMaterial() == null) continue;
            MaterialInfo material = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(entry.getMaterial().getId()));
            entry.setMaterial(material);
        }
        Map paramMap = this.batchGetParamValue(ctx, info.getSaleOrgUnit().getId().toString());
        String saleOrdId = info.getSaleOrgUnit().getId().toString();
        String billType = info.getBillType().getId().toString();
        ISCMBillParam iSCMBillParam = SCMBillParamFactory.getLocalInstance((Context)ctx);
        String botpBillAddEntry = iSCMBillParam.getParamByBillTypeID("botpBillAddEntry", 2, saleOrdId, billType);
        paramMap.put("botpBillAddEntry", "1".equals(botpBillAddEntry));
        map.put("params", paramMap);
        if (!"VIEW".equalsIgnoreCase(oprtState)) {
            String saleOrgFilter = "id in " + this.getSaleOrgFilter(ctx);
            map.put("saleOrgFilter", saleOrgFilter);
            this.handleEntryDefaultValue(ctx, info, map);
            info.setCU(info.getSaleOrgUnit().getCU());
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            CodingRuleInfo ruleInfo = iCodingRuleManager.getCodingRule((IObjectValue)new SaleReturnsInfo(), info.getSaleOrgUnit().getId().toString());
            if (ruleInfo != null) {
                map.put("numberIsEdit", ruleInfo.isIsModifiable());
                if (info.getSourceBillType() != null && info.getNumber() == null && info.getBaseStatus().equals((Object)BillBaseStatusEnum.ADD) && ruleInfo.isIsAddView()) {
                    map.put("addNewNumber", iCodingRuleManager.getNumber(model, info.getSaleOrgUnit().getId().toString()));
                }
            }
            if (info.getEntries() != null && info.getEntries().size() > 0) {
                map.put("defaultStorageOrgUnit", info.getEntries().get(0).getStorageOrgUnit());
                map.put("defaultReturnsDate", info.getEntries().get(0).getReturnsDate());
                map.put("entry_companyOrgUnit", info.getEntries().get(0).getCompanyOrgUnit());
                map.put("entry_isBetweenCompanySend", info.getEntries().get(0).isIsBetweenCompanySend());
            }
            map.put("storageF7Filter", this.getStorageOrgFilter(ctx, info.getSaleOrgUnit().getId().toString()));
            map.put("projectF7Filter", this.getProjectF7Filter(ctx, info.getSaleOrgUnit().getId().toString()));
            map.put("trackNumberF7Filter", this.getTrackNumberF7Filter(ctx, info.getSaleOrgUnit().getId().toString()));
            map.put("adminF7Filter", this.getAdminF7Filter(ctx, info.getSaleOrgUnit().getId().toString()));
            map.put("priceSourceType", this.getPriceSourceType());
            map.put("botpQtyMap", this.cacheBotpQty(ctx, info));
        }
        return map;
    }

    protected Map<String, Object> cacheBotpQty(Context ctx, SaleReturnsInfo info) throws BOSException {
        HashMap<String, BigDecimal> botpQty = null;
        if (info.getSourceBillType() != null && "310".equals(info.getSourceBillType().getNumber())) {
            botpQty = new HashMap<String, BigDecimal>();
            ISaleOrderEntry iSaleOrderEntry = SaleOrderEntryFactory.getLocalInstance(ctx);
            SaleReturnsEntryCollection s = info.getEntries();
            HashSet<String> entryBillSet = new HashSet<String>();
            for (int i = 0; i < s.size(); ++i) {
                if (s.get(i).getSourceBillEntryId() == null) continue;
                entryBillSet.add(s.get(i).getSourceBillEntryId());
            }
            if (entryBillSet.size() > 0) {
                BigDecimal baseQty = null;
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", entryBillSet, CompareType.INCLUDE));
                viewInfo.setFilter(filter);
                SaleOrderEntryCollection orderEntryCol = iSaleOrderEntry.getSaleOrderEntryCollection(viewInfo);
                for (int i = 0; i < orderEntryCol.size(); ++i) {
                    SaleOrderEntryInfo orderEntryInfo = orderEntryCol.get(i);
                    baseQty = orderEntryInfo.getTotalReBaseQty() == null ? orderEntryInfo.getBaseQty() : orderEntryInfo.getTotalIssueBaseQty().subtract(orderEntryInfo.getTotalReBaseQty());
                    if (baseQty == null) continue;
                    botpQty.put(orderEntryInfo.getId().toString(), baseQty);
                }
            }
        }
        return botpQty;
    }

    protected Map _handleMainOrgChange(Context ctx, String mainOrgId) throws BOSException, EASBizException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String orgId = mainOrgId;
        String bizOrgCUID = CUIDGetterFacadeFactory.getLocalInstance((Context)ctx).getCUID(orgId);
        map.put("bizOrgCUID", bizOrgCUID);
        CompanyOrgUnitInfo cou = null;
        cou = this.getCouBySou(ctx, orgId);
        map.put("cou", cou);
        map.put("baseCurrency", this.getBaseCurrencyByCou(ctx, cou));
        map.put("exchangeRateColl", this.getExchangeRateCollByCou(ctx, cou.getId().toString()));
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        CodingRuleInfo ruleInfo = iCodingRuleManager.getCodingRule((IObjectValue)new SaleReturnsInfo(), orgId);
        if (ruleInfo != null) {
            map.put("numberIsEdit", ruleInfo.isIsModifiable());
            if (ruleInfo.isIsAddView()) {
                map.put("addNewNumber", iCodingRuleManager.getNumber((IObjectValue)new SaleReturnsInfo(), orgId));
            }
        }
        Map paramMap = this.batchGetParamValue(ctx, orgId);
        map.put("params", paramMap);
        AdminOrgUnitInfo admin = null;
        String enable_sale_admin = this.getParamValue(new ObjectUuidPK(mainOrgId), "SALEORDER001");
        if (enable_sale_admin != null && !Boolean.valueOf(enable_sale_admin).booleanValue() && mainOrgId != null) {
            OrgUnitCollection coll = this.getAdminOrgUnitBySou(ctx, mainOrgId);
            if (coll != null && coll.size() > 0) {
                int size = coll.size();
                for (int i = 0; i < size; ++i) {
                    if (coll.get(i) == null || coll.get(i).getId() == null || !coll.get(i).getId().toString().equals(mainOrgId)) continue;
                    admin = (AdminOrgUnitInfo)coll.get(i);
                    break;
                }
                if (admin == null && coll.get(0) != null) {
                    admin = (AdminOrgUnitInfo)coll.get(0);
                }
            }
            map.put("adminOrg", admin);
        } else {
            map.put("adminOrg", null);
        }
        StorageOrgUnitInfo storage = this.getStorageOrgUnitBySou(ctx, orgId);
        map.put("storageOrg", storage);
        if (storage != null) {
            map.put("entry_companyOrgUnit", this.getCouByStorageOrg(ctx, storage.getId().toString()));
        }
        map.put("storageF7Filter", this.getStorageOrgFilter(ctx, orgId));
        map.put("projectF7Filter", this.getProjectF7Filter(ctx, orgId));
        map.put("trackNumberF7Filter", this.getTrackNumberF7Filter(ctx, orgId));
        map.put("adminF7Filter", this.getAdminF7Filter(ctx, orgId));
        return map;
    }

    private SaleReturnsEntryInfo createEntryData(Context ctx, SaleReturnsInfo info) throws BOSException, EASBizException {
        SaleReturnsEntryInfo entry = new SaleReturnsEntryInfo();
        entry.setTaxRate(new BigDecimal(0));
        entry.setBaseStatus(EntryBaseStatusEnum.ADD);
        entry.setReturnsDate(new Date());
        entry.setTaxRate(ZERO);
        entry.setReceiveDispatcherType(ReceiveDispatcherTypeEnum.returnInWarehs);
        entry.setQty(ZERO);
        entry.setAssistQty(ZERO);
        entry.setReturnsQty(ZERO);
        entry.setReturnsBaseQty(ZERO);
        entry.setRemainingBaseQty(ZERO);
        entry.setRemainingQty(ZERO);
        entry.setInvoicedBaseQty(ZERO);
        entry.setInvoicedQty(ZERO);
        entry.setPrice(ZERO);
        entry.setAmount(ZERO);
        entry.setLocalAmount(ZERO);
        entry.setTax(ZERO);
        entry.setLocalTax(ZERO);
        entry.setTaxAmount(ZERO);
        entry.setLocalTaxAmount(ZERO);
        entry.setTotalReturnAmt(ZERO);
        entry.setTotalInvoicedAmt(ZERO);
        entry.setInvoicePrice(ZERO);
        entry.setQuantityUnCtrl(false);
        entry.setPriceSourceType(PriceTypeEnum.NULL);
        entry.setTaxRate(DEFAULT_TAXRATE);
        entry.setStorageOrgUnit(this.getStorageOrgUnitBySou(ctx, info.getSaleOrgUnit().getId().toString()));
        if (entry.getStorageOrgUnit() != null) {
            entry.setCompanyOrgUnit(this.getCouByStorageOrg(ctx, entry.getStorageOrgUnit().getId().toString()));
        }
        if (null != info.getSaleOrgUnit() && null != info.getSaleOrgUnit().getId() && null != entry.getStorageOrgUnit() && null != entry.getStorageOrgUnit().getId()) {
            IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
            OrgUnitCollection pcoll = iOrgUnitRelation.getToUnit(info.getSaleOrgUnit().getId().toString(), 2, 1);
            OrgUnitCollection scoll = iOrgUnitRelation.getToUnit(entry.getStorageOrgUnit().getId().toString(), 4, 1);
            if (pcoll != null && pcoll.size() != 0 && scoll != null && scoll.size() != 0) {
                if (!pcoll.get(0).getId().toString().equals(scoll.get(0).getId().toString())) {
                    entry.setIsBetweenCompanySend(true);
                } else {
                    entry.setIsBetweenCompanySend(false);
                }
            }
        }
        if (info.getBaseStatus().equals((Object)BillBaseStatusEnum.ADD)) {
            if (entry.isIsBetweenCompanySend()) {
                info.setIsCentralBalance(true);
            } else {
                info.setIsCentralBalance(false);
            }
        }
        if (null != info.getSaleOrgUnit() && null != info.getSaleOrgUnit().getId().toString()) {
            String QuantityUnCtrl = this.getParamValue(new ObjectUuidPK(info.getSaleOrgUnit().getId()), "SALEORDER004");
            entry.setQuantityUnCtrl(Boolean.valueOf(QuantityUnCtrl));
        }
        return entry;
    }

    private void handleEntryDefaultValue(Context ctx, SaleReturnsInfo info, Map map) throws EASBizException, BOSException {
        map.put("defaultStorageOrgUnit", this.getStorageOrgUnitBySou(ctx, info.getSaleOrgUnit().getId().toString()));
        if (this.getStorageOrgUnitBySou(ctx, info.getSaleOrgUnit().getId().toString()) != null) {
            map.put("defaultCompanyOrgUnit", this.getCouByStorageOrg(ctx, this.getStorageOrgUnitBySou(ctx, info.getSaleOrgUnit().getId().toString()).getId().toString()));
        } else {
            map.put("defaultCompanyOrgUnit", null);
        }
        map.put("defaultBaseStatus", EntryBaseStatusEnum.ADD);
        CustomerInfo defaultPaymentCustomer = null;
        CustomerInfo defaultReceiveCustomer = null;
        CustomerInfo defaultDeliveryCustomer = null;
        BigDecimal defaultTaxRate = DEFAULT_TAXRATE;
        if (null != info && null != info.getReturnsCustomer()) {
            String saleOrgId = info.getSaleOrgUnit().getId().toString();
            SelectorItemCollection siCol = this.getCustomerSaleSelector(true);
            CustomerSaleInfoInfo csInfo = this.getCustomerSaleInfo(ctx, info.getReturnsCustomer().getId().toString(), saleOrgId, siCol);
            if (csInfo == null) {
                return;
            }
            HashSet<String> customerIds = new HashSet<String>();
            customerIds.add(csInfo.getSettlementOrgUnit().getId().toString());
            customerIds.add(csInfo.getBillingOrgUnit().getId().toString());
            customerIds.add(csInfo.getDeliverOrgUnit().getId().toString());
            CustomerSaleInfoCollection col = this.getCustomerSaleInfo2(ctx, customerIds, saleOrgId);
            for (int i = 0; i < col.size(); ++i) {
                CustomerSaleInfoInfo customerSaleInfo = col.get(i);
                if (customerSaleInfo.getCustomer().getId().equals((Object)csInfo.getSettlementOrgUnit().getId())) {
                    defaultPaymentCustomer = csInfo.getSettlementOrgUnit();
                }
                if (customerSaleInfo.getCustomer().getId().equals((Object)csInfo.getBillingOrgUnit().getId())) {
                    defaultReceiveCustomer = csInfo.getBillingOrgUnit();
                }
                if (!customerSaleInfo.getCustomer().getId().equals((Object)csInfo.getDeliverOrgUnit().getId())) continue;
                defaultDeliveryCustomer = csInfo.getDeliverOrgUnit();
            }
            String SALEBILL001 = this.getParamValue(new ObjectUuidPK(info.getSaleOrgUnit().getId()), "SALEBILL001");
            if (SALEBILL001 != null && Boolean.valueOf(SALEBILL001).booleanValue() && null != csInfo.getCustomer()) {
                defaultTaxRate = csInfo.getCustomer().getTaxRate();
            }
        }
        map.put("defaultPaymentCustomer", defaultPaymentCustomer);
        map.put("defaultDeliveryCustomer", defaultDeliveryCustomer);
        map.put("defaultReceiveCustomer", defaultReceiveCustomer);
        map.put("defaultEntryTaxRate", defaultTaxRate);
    }

    private CustomerSaleInfoInfo getCustomerSaleInfo(Context ctx, String customerId, String saleOrgId, SelectorItemCollection siCol) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().addObjectCollection((IObjectCollection)siCol);
        FilterInfo filter = new FilterInfo();
        if (customerId != null) {
            filter.appendFilterItem("customer.id", (Object)customerId);
        }
        if (saleOrgId != null) {
            filter.appendFilterItem("saleOrgUnit.id", (Object)saleOrgId);
        }
        viewInfo.setFilter(filter);
        CustomerSaleInfoCollection csInfoCol = CustomerSaleInfoFactory.getLocalInstance((Context)ctx).getCustomerSaleInfoCollection(viewInfo);
        CustomerSaleInfoInfo csInfo = null;
        if (csInfoCol.size() > 0) {
            csInfo = csInfoCol.get(0);
        }
        return csInfo;
    }

    private CustomerSaleInfoCollection getCustomerSaleInfo2(Context ctx, Set customerIds, String saleOrgId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(this.getCustomerSaleSelector(false));
        FilterInfo filter = new FilterInfo();
        if (customerIds == null) {
            filter.getFilterItems().add(new FilterItemInfo("customer.id", (Object)"xxxx-xxx", CompareType.INCLUDE));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("customer.id", (Object)customerIds, CompareType.INCLUDE));
        }
        filter.getFilterItems().add(new FilterItemInfo("saleOrgUnit.id", (Object)saleOrgId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("usingStatus", (Object)0, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("customer.usedStatus", (Object)1, CompareType.EQUALS));
        view.setFilter(filter);
        CustomerSaleInfoCollection col = CustomerSaleInfoFactory.getLocalInstance((Context)ctx).getCustomerSaleInfoCollection(view);
        return col;
    }

    protected SelectorItemCollection getCustomerSaleSelector(boolean isNeedCustomerInfo) {
        SelectorItemCollection siCol = new SelectorItemCollection();
        if (isNeedCustomerInfo) {
            siCol.add(new SelectorItemInfo("settlementOrgUnit.id"));
            siCol.add(new SelectorItemInfo("settlementOrgUnit.name"));
            siCol.add(new SelectorItemInfo("billingOrgUnit.id"));
            siCol.add(new SelectorItemInfo("billingOrgUnit.name"));
            siCol.add(new SelectorItemInfo("deliverOrgUnit.id"));
            siCol.add(new SelectorItemInfo("deliverOrgUnit.name"));
            siCol.add(new SelectorItemInfo("customer.id"));
            siCol.add(new SelectorItemInfo("customer.name"));
            siCol.add(new SelectorItemInfo("customer.number"));
            siCol.add(new SelectorItemInfo("customer.taxRate"));
            siCol.add(new SelectorItemInfo("customerSaler.id"));
            siCol.add(new SelectorItemInfo("customerSaler.name"));
            siCol.add(new SelectorItemInfo("customerSaler.person.id"));
            siCol.add(new SelectorItemInfo("customerSaler.person.name"));
        } else {
            siCol.add(new SelectorItemInfo("usingStatus"));
            siCol.add(new SelectorItemInfo("customer.usedStatus"));
            siCol.add(new SelectorItemInfo("customer.id"));
        }
        return siCol;
    }

    public CompanyOrgUnitInfo getCouBySou(Context ctx, String souId) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = null;
        IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection coll = iOrgUnitRelation.getToUnit(souId, 2, 1);
        if (coll != null && coll.size() > 0) {
            company = (CompanyOrgUnitInfo)coll.get(0);
        }
        return company;
    }

    private CompanyOrgUnitInfo getCouByStorageOrg(Context ctx, String souId) throws BOSException, EASBizException {
        return SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getCompanyInfo(BOSUuid.read((String)souId));
    }

    private StorageOrgUnitInfo getStorageOrgUnitBySou(Context ctx, String souId) throws BOSException, EASBizException {
        StorageOrgUnitInfo pou = null;
        OrgUnitCollection coll = this.getStorageOrgUnitBySaleOrg(ctx, souId);
        if (coll != null && coll.size() > 0) {
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                if (coll.get(i) == null || coll.get(i).getId() == null || !coll.get(i).getId().toString().equals(souId)) continue;
                pou = (StorageOrgUnitInfo)coll.get(i);
                break;
            }
            if (pou == null && coll.get(0) != null) {
                pou = (StorageOrgUnitInfo)coll.get(0);
            }
        }
        return pou;
    }

    private OrgUnitCollection getAdminOrgUnitBySou(Context ctx, String souId) throws BOSException, EASBizException {
        IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection coll = iOrgUnitRelation.getToUnit(souId, 2, 0);
        return coll;
    }

    private OrgUnitCollection getStorageOrgUnitBySaleOrg(Context ctx, String souId) throws BOSException, EASBizException {
        IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection coll = iOrgUnitRelation.getFromUnit(souId, 2, 4);
        return coll;
    }

    private String getAdminF7Filter(Context ctx, String orgId) throws EASBizException, BOSException {
        StringBuffer filter = new StringBuffer();
        String enable_sale_admin = this.getParamValue(new ObjectUuidPK(orgId), "SALEORDER001");
        if (enable_sale_admin != null && Boolean.valueOf(enable_sale_admin).booleanValue()) {
            filter.append("id = 'xxxx-xxx'");
        } else {
            String orgFilter = this.getOrgFilterStr(ctx, this.getAdminOrgUnitBySou(ctx, orgId));
            filter.append("id in").append(orgFilter);
        }
        return filter.toString();
    }

    private String getSaleOrgFilter(Context ctx) throws BOSException, EASBizException {
        IPermission iPerm = PermissionFactory.getLocalInstance((Context)ctx);
        FullOrgUnitCollection fullCompanyColl = iPerm.getAuthorizedOrg(ctx.getCaller(), OrgType.Sale, null, "saleReturns_addnew");
        OrgUnitCollection saleOrgColl = new OrgUnitCollection();
        HashSet<String> iSet = new HashSet<String>();
        for (int i = 0; i < fullCompanyColl.size(); ++i) {
            iSet.add(fullCompanyColl.get(i).getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", iSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)new Boolean(true), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isSealup", (Object)new Boolean(false), CompareType.EQUALS));
        view.setFilter(filter);
        SaleOrgUnitCollection stoOrgColl = SaleOrgUnitFactory.getLocalInstance((Context)ctx).getSaleOrgUnitCollection(view);
        for (int i = 0; i < stoOrgColl.size(); ++i) {
            saleOrgColl.add((OrgUnitInfo)stoOrgColl.get(i));
        }
        return this.getOrgFilterStr(ctx, saleOrgColl);
    }

    private String getStorageOrgFilter(Context ctx, String orgId) throws BOSException, EASBizException {
        StringBuffer filter = new StringBuffer();
        String orgFilter = this.getOrgFilterStr(ctx, this.getStorageOrgUnitBySaleOrg(ctx, orgId));
        filter.append("id in").append(orgFilter);
        return filter.toString();
    }

    public String getParamValue(ObjectUuidPK orgUnitID, String paramNumber) throws EASBizException, BOSException {
        return ParamsUtil.getParamsValue((ObjectUuidPK)orgUnitID, (String)paramNumber);
    }

    private Map batchGetParamValue(Context ctx, String orgId) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)orgId)) {
            return null;
        }
        SaleOrgUnitInfo sale = new SaleOrgUnitInfo();
        sale.setId(BOSUuid.read((String)orgId));
        SCMBizDataVO vo = new SCMBizDataVO(OrgType.Sale, (OrgUnitInfo)sale, 19, UserFactory.getLocalInstance((Context)ctx).getUserInfo(ctx.getCaller()), null);
        vo.setParameters(new String[]{"SALEBILL001", "SALEORDER001", "SALEORDER100", "SALEORDER101", "DISCOUNTRATEPRECISION", "SALEORDERSEL001", "SALEORDER008", "SALEORDER007", "SALE001", "SALEORDER004"});
        vo.setBOSType("546F192F");
        vo.setFirstLoading(true);
        SCMBizDataVO bizDataVO = SCMGroupFacadeFactory.getRemoteInstance().loadSCMBizDataVO(vo);
        HashMap paramMap = bizDataVO.getParametersMap();
        paramMap.putAll(bizDataVO.getSalePriceParamInfo().getParamItems());
        return paramMap;
    }

    public String getProjectF7Filter(Context ctx, String orgid) throws EASBizException, BOSException {
        FilterInfo filterInfo = null;
        FullOrgUnitInfo orgInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgid));
        String cuid = orgInfo.getCU().getId().toString();
        filterInfo = ProjectFactory.getLocalInstance((Context)ctx).getDatabaseDFilter((IObjectPK)new ObjectUuidPK(cuid), "id", "CU.id");
        if (filterInfo == null) {
            filterInfo = new FilterInfo();
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)4, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("isTemplate", (Object)false, CompareType.EQUALS));
        return filterInfo.toString();
    }

    public String getTrackNumberF7Filter(Context ctx, String orgid) throws EASBizException, BOSException {
        FilterInfo filterInfo = null;
        FullOrgUnitInfo orgInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgid));
        String cuid = orgInfo.getCU().getId().toString();
        filterInfo = TrackNumberFactory.getLocalInstance((Context)ctx).getDatabaseDFilter((IObjectPK)new ObjectUuidPK(cuid), "id", "CU.id");
        if (filterInfo == null) {
            filterInfo = new FilterInfo();
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)10, CompareType.EQUALS));
        return filterInfo.toString();
    }

    private Map<String, Object> getPriceSourceType() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("isNull", (Object)PriceTypeEnum.NULL);
        map.put("pricePolicy", (Object)PriceTypeEnum.PRICEPOLICY);
        map.put("basePrice", (Object)PriceTypeEnum.BASEPRICE);
        map.put("materialSaleInfo", (Object)PriceTypeEnum.SALEPRICE);
        return map;
    }

    public OrgType getMainOrgType() {
        return OrgType.Sale;
    }

    public String getPermissionItem() {
        return "saleReturns_addnew";
    }
}

