/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.scm.common.ExpenseItemCollection;
import com.kingdee.eas.basedata.scm.common.ExpenseItemFactory;
import com.kingdee.eas.basedata.scm.common.ExpenseItemInfo;
import com.kingdee.eas.basedata.scm.common.IExpenseItem;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.common.SettlementStateEnum;
import com.kingdee.eas.scm.sd.sale.ISalesExpenseInvoice;
import com.kingdee.eas.scm.sd.sale.SalesExpenseInvoiceCollection;
import com.kingdee.eas.scm.sd.sale.SalesExpenseInvoiceEntryCollection;
import com.kingdee.eas.scm.sd.sale.SalesExpenseInvoiceEntryFactory;
import com.kingdee.eas.scm.sd.sale.SalesExpenseInvoiceEntryInfo;
import com.kingdee.eas.scm.sd.sale.SalesExpenseInvoiceFactory;
import com.kingdee.eas.scm.sd.sale.SalesExpenseInvoiceInfo;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import java.math.BigDecimal;
import java.util.Hashtable;
import java.util.List;

public class SalesExpenseInvoiceEntryDataImport
extends AbstractDataTransmission {
    String[] BIGDECIMAL_FIELDS = new String[]{"FQty", "FPrice", "FAmount", "FLocalAmount", "FTaxRate", "FTax", "FLocalTax", "FNonTaxAmount", "FLocalNonTaxAmount"};
    String[] BIGDECIMAL_OBJ = new String[]{"qty", "price", "amount", "localAmount", "taxRate", "tax", "localTax", "nonTaxAmount", "localNonTaxAmount"};
    String[] STRING_FIELDS = new String[]{"FRemark"};
    String[] STRING_OBJS = new String[]{"remark"};

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return SalesExpenseInvoiceEntryFactory.getLocalInstance(ctx);
        }
        catch (BOSException bex) {
            throw new TaskExternalException("", (Throwable)bex);
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        ICoreBase isalesExpenseInvoiceEntry = this.getController(ctx);
        try {
            if (coreBaseInfo.getId() == null || !isalesExpenseInvoiceEntry.exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
                isalesExpenseInvoiceEntry.addnew(coreBaseInfo);
            } else {
                isalesExpenseInvoiceEntry.update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        Object value;
        Object o;
        int i;
        SalesExpenseInvoiceEntryInfo entryInfo;
        block16: {
            entryInfo = new SalesExpenseInvoiceEntryInfo();
            try {
                Object data = ((DataToken)hsData.get((Object)"FSalesExpenseInvoiceID")).data;
                if (data != null) {
                    String str = data.toString();
                    if (str != null && str.trim().length() > 0) {
                        ISalesExpenseInvoice isalesExpenseInvoice = SalesExpenseInvoiceFactory.getLocalInstance(ctx);
                        SalesExpenseInvoiceCollection collection = isalesExpenseInvoice.getSalesExpenseInvoiceCollection("where number ='" + str + "'");
                        if (collection == null || collection.size() == 0) {
                            throw new TaskExternalException("the SalesExpenseInvoice  not found in database!!!!");
                        }
                        SalesExpenseInvoiceInfo salesExpenseInvoiceInfo = collection.get(0);
                        SalesExpenseInvoiceEntryCollection entryCollection = salesExpenseInvoiceInfo.getEntries();
                        entryInfo.setParent(salesExpenseInvoiceInfo);
                        if (entryCollection != null && entryCollection.size() > 0) {
                            entryInfo.setSeq(this.getMaxRowNum(entryCollection));
                        } else {
                            entryInfo.setSeq(1);
                        }
                    }
                    break block16;
                }
                throw new TaskExternalException("FSalesExpenseInvoiceID  not found!");
            }
            catch (BOSException bex) {
                Logger.error((Throwable)bex);
                throw new TaskExternalException("process FSalesExpenseInvoiceID  error!");
            }
        }
        for (i = 0; i < this.BIGDECIMAL_FIELDS.length; ++i) {
            try {
                o = ((DataToken)hsData.get((Object)this.BIGDECIMAL_FIELDS[i])).data;
                if (o == null || o.toString().trim().length() <= 0 || (value = new BigDecimal(o.toString())) == null) continue;
                entryInfo.setBigDecimal(this.BIGDECIMAL_OBJ[i], (BigDecimal)value);
                continue;
            }
            catch (NumberFormatException nex) {
                Logger.error((Throwable)nex);
                throw new TaskExternalException(this.BIGDECIMAL_OBJ[i] + " format error, it must be a number!!!");
            }
        }
        for (i = 0; i < this.STRING_FIELDS.length; ++i) {
            o = ((DataToken)hsData.get((Object)this.STRING_FIELDS[i])).data;
            if (o == null) continue;
            value = o.toString();
            entryInfo.setString(this.STRING_OBJS[i], (String)value);
        }
        Object data = ((DataToken)hsData.get((Object)"FSettlementStatus")).data;
        String value2 = null;
        if (data != null && (value2 = data.toString()) != null) {
            entryInfo.setSettlementStatus(this.getSettlementStateValue(value2));
        }
        try {
            IMeasureUnit iunit;
            ExpenseItemInfo info;
            IExpenseItem iExpenseItem;
            ExpenseItemCollection collection;
            data = ((DataToken)hsData.get((Object)"FReasonCodeID")).data;
            String str = null;
            data = ((DataToken)hsData.get((Object)"FExpenseItemID")).data;
            if (data != null && (str = data.toString()) != null && str.length() > 0 && (collection = (iExpenseItem = ExpenseItemFactory.getLocalInstance((Context)ctx)).getExpenseItemCollection("where number='" + str + "'")) != null && collection.size() > 0 && (info = collection.get(0)) != null) {
                entryInfo.setExpenseItem(info);
            }
            if ((data = ((DataToken)hsData.get((Object)"FMeasureUnitID")).data) != null && (str = data.toString()) != null && str.trim().length() > 0 && (collection = (iunit = MeasureUnitFactory.getLocalInstance((Context)ctx)).getMeasureUnitCollection("where number='" + str + "'")) != null && collection.size() > 0 && (info = collection.get(0)) != null) {
                entryInfo.setMeasureUnit((MeasureUnitInfo)info);
            }
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
        return entryInfo;
    }

    private int getMaxRowNum(SalesExpenseInvoiceEntryCollection entryCollection) {
        int max = 0;
        int temp = 0;
        int num = entryCollection.size();
        for (int i = 0; i < num; ++i) {
            SalesExpenseInvoiceEntryInfo info = entryCollection.get(i);
            if (info == null || (temp = info.getSeq()) <= max) continue;
            max = temp;
        }
        return max;
    }

    private SettlementStateEnum getSettlementStateValue(String value) {
        SettlementStateEnum unsettled = SettlementStateEnum.UNSETTLED;
        if (value != null) {
            value = value.trim();
            List EnumList = SettlementStateEnum.getEnumList();
            int num = EnumList.size();
            for (int i = 0; i < num; ++i) {
                SettlementStateEnum enums = (SettlementStateEnum)EnumList.get(i);
                String enumValue = String.valueOf(enums.getValue());
                String enumName = enums.getName();
                String enumAlias = enums.getAlias();
                if (!enumValue.equalsIgnoreCase(value) && !enumName.equalsIgnoreCase(value) && !enumAlias.equalsIgnoreCase(value)) continue;
                unsettled = enums;
                break;
            }
        }
        return unsettled;
    }
}

