/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.scm.common.DiscountConditionEnum;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.customize.sd.IWSSaleOrderExtendFacade;
import com.kingdee.eas.scm.customize.sd.WSSaleOrderExtendFacadeFactory;
import com.kingdee.eas.scm.im.inv.ws.util.XMLUtil;
import com.kingdee.eas.scm.sd.sale.ISaleOrder;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import com.kingdee.eas.scm.sd.sale.app.AbstractWSSaleOrderFacadeControllerBean;
import com.kingdee.eas.scm.sm.pur.constant.UIConstant;
import com.kingdee.eas.scm.sm.pur.util.DataImportUtils;
import com.kingdee.eas.scm.sm.pur.util.InfoUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class WSSaleOrderFacadeControllerBean
extends AbstractWSSaleOrderFacadeControllerBean {
    private static final long serialVersionUID = -9141240389261020525L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sd.sale.app.WSSaleOrderFacadeControllerBean");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String[] _ImportData(Context ctx, String xmlData) throws BOSException {
        String[] msg = new String[2];
        try {
            Document doc = XMLUtil.builderDocument((String)xmlData);
            if (doc != null) {
                SaleOrderInfo saleOrderInfo = new SaleOrderInfo();
                HashMap billHeadMap = XMLUtil.getBillHead((Document)doc);
                if (billHeadMap == null) {
                    msg[0] = "3000";
                    msg[1] = UIConstant.BILLHEAD_ERROR;
                    throw new BOSException(UIConstant.BILLHEAD_ERROR);
                }
                ArrayList billEntriesList = XMLUtil.getBillEntries((Document)doc);
                if (billEntriesList == null) {
                    msg[0] = "4000";
                    msg[1] = UIConstant.BILLENTRIES_ERROR;
                    throw new BOSException(UIConstant.BILLENTRIES_ERROR);
                }
                this.validateProperty(billHeadMap, billEntriesList);
                this.buildBillHead(ctx, saleOrderInfo, billHeadMap);
                this.builBillEntries(ctx, saleOrderInfo, billEntriesList);
                IWSSaleOrderExtendFacade extendFacage = WSSaleOrderExtendFacadeFactory.getLocalInstance((Context)ctx);
                extendFacage.extendField((IObjectValue)saleOrderInfo, xmlData);
                ctx.put((Object)"disablePermissionForKScript", (Object)Boolean.TRUE);
                ISaleOrder iSaleOrder = SaleOrderFactory.getLocalInstance(ctx);
                iSaleOrder.save((CoreBaseInfo)saleOrderInfo);
                msg[0] = "0000";
                msg[1] = UIConstant.SUCCESS;
            }
        }
        catch (Exception exc) {
            msg[0] = "1111";
            msg[1] = "\nexc.getMessage():" + exc.getMessage() + "\nexc.toString():" + exc.toString();
            logger.error((Object)exc);
        }
        finally {
            ctx.put((Object)"disablePermissionForKScript", (Object)Boolean.FALSE);
        }
        return msg;
    }

    private void buildBillHead(Context ctx, SaleOrderInfo info, HashMap billHeadMap) throws BOSException, ParseException {
        String[] string_Fields = new String[]{"sourcefunction", "sourcebillid", "description", "number", "sendaddress", "customerordernumber"};
        String[] boolean_Fields = new String[]{"haseffected", "issysbill", "isinnersale", "isInTax"};
        String[] bigDecimal_Fields = new String[]{"localtotaltaxamount", "localtotalamount", "unprereceivedamount", "prereceived", "totaltaxamount", "totaltax", "totalamount", "prepaymentrate", "prepayment", "exchangerate"};
        String[] int_Fields = new String[]{"period", "year", "transleadtime"};
        if (billHeadMap != null) {
            this.dealWithStringFields((CoreBaseInfo)info, billHeadMap, string_Fields);
            this.dealWithBooleanFields((CoreBaseInfo)info, billHeadMap, boolean_Fields);
            this.dealWithBigDecimalFields((CoreBaseInfo)info, billHeadMap, bigDecimal_Fields);
            this.dealWithIntFields((CoreBaseInfo)info, billHeadMap, int_Fields);
            this.dealwithOtherFields_Head(ctx, info, billHeadMap);
        }
    }

    private void builBillEntries(Context ctx, SaleOrderInfo info, ArrayList entriesList) throws BOSException, ParseException {
        String[] string_Fields = new String[]{"remark", "sourcebillentryid", "sourcebillnumber", "sourcebillid", "reason"};
        String[] boolean_Fields = new String[]{"timeunctrl", "quantityunctrl", "isbysaleorder", "islocked", "ispresent"};
        String[] bigDecimal_Fields = new String[]{"associateqty", "asscoefficient", "totalaramount", "totalinvoicedamt", "unprereceivedamount", "prereceived", "prepayment", "prepaymentrate", "unorderedqty", "orderedqty", "localtaxamount", "localtax", "lockbaseqty", "lockqty", "totalunissueqty", "totalunshipbaseqty", "totalunissuebaseqty", "totalunreturnbaseqty", "totalshipbaseqty", "tolinvoidbaseqty", "totalrebaseqty", "totalissuebaseqty", "totalreceivedamount", "totalshippingqty", "totalinvoicedqty", "totalreturnedqty", "totalissueqty", "senddeferralday", "sendadvanceday", "sendowingrate", "sendoverrate", "taxamount", "tax", "taxrate", "actualtaxprice", "actualprice", "localamount", "amount", "discountamount", "discount", "taxprice", "price", "assistqty", "qty", "baseqty"};
        String[] int_Fields = new String[]{"seq", "sourcebillentryseq", "deliverydateqty"};
        if (entriesList != null) {
            for (int i = 0; i < entriesList.size(); ++i) {
                HashMap entryMap = (HashMap)entriesList.get(i);
                SaleOrderEntryInfo saleOrderEntryInfo = new SaleOrderEntryInfo();
                this.dealWithStringFields((CoreBaseInfo)saleOrderEntryInfo, entryMap, string_Fields);
                this.dealWithBooleanFields((CoreBaseInfo)saleOrderEntryInfo, entryMap, boolean_Fields);
                this.dealWithBigDecimalFields((CoreBaseInfo)saleOrderEntryInfo, entryMap, bigDecimal_Fields);
                this.dealWithIntFields((CoreBaseInfo)saleOrderEntryInfo, entryMap, int_Fields);
                this.dealwithOtherFields_Entry(ctx, entryMap, saleOrderEntryInfo);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("*"));
                sic.add(new SelectorItemInfo("assistUnit.id"));
                sic.add(new SelectorItemInfo("assistUnit.name"));
                sic.add(new SelectorItemInfo("assistUnit.number"));
                MaterialInfo materilInfo = null;
                try {
                    materilInfo = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(saleOrderEntryInfo.getMaterial().getId().toString()), sic);
                }
                catch (EASBizException e) {
                    logger.error((Object)e);
                }
                if (materilInfo != null && materilInfo.getAssistUnit() == null) {
                    saleOrderEntryInfo.setAssistUnit(null);
                    saleOrderEntryInfo.setAssistQty(new BigDecimal("0.00"));
                }
                info.getEntries().add(saleOrderEntryInfo);
            }
        }
    }

    private void dealwithOtherFields_Entry(Context ctx, HashMap entryMap, SaleOrderEntryInfo saleOrderEntryInfo) throws BOSException, ParseException {
        DiscountModeEnum enumeration;
        Date bizDate;
        String strNumber = (String)entryMap.get("material");
        if (strNumber != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            saleOrderEntryInfo.setMaterial(DataImportUtils.getMaterialInfoFromNumber((Context)ctx, (String)strNumber));
        }
        if ((strNumber = (String)entryMap.get("assistproperty")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            saleOrderEntryInfo.setAssistProperty(DataImportUtils.getAsstAttrValueInfoFromNumber((Context)ctx, (String)strNumber));
        }
        if ((strNumber = (String)entryMap.get("unit")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            saleOrderEntryInfo.setUnit(DataImportUtils.getMeasureUnitInfoFromNumber((Context)ctx, (String)strNumber));
        }
        if ((strNumber = (String)entryMap.get("basestatus")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            EntryBaseStatusEnum enums = EntryBaseStatusEnum.getEnum((String)strNumber);
            saleOrderEntryInfo.setBaseStatus(enums);
        }
        if ((strNumber = (String)entryMap.get("sourcebilltype")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            saleOrderEntryInfo.setSourceBillType(DataImportUtils.getBillTypeInfoFromNumber((Context)ctx, (String)strNumber));
        }
        if ((strNumber = (String)entryMap.get("baseunit")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            saleOrderEntryInfo.setBaseUnit(DataImportUtils.getMeasureUnitInfoFromNumber((Context)ctx, (String)strNumber));
        }
        if ((strNumber = (String)entryMap.get("assistunit")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            saleOrderEntryInfo.setAssistUnit(DataImportUtils.getMeasureUnitInfoFromNumber((Context)ctx, (String)strNumber));
        }
        if ((strNumber = (String)entryMap.get("reasoncode")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            saleOrderEntryInfo.setReasonCode(DataImportUtils.getReasonCodeInfoFromNumber((Context)ctx, (String)strNumber));
        }
        if ((strNumber = (String)entryMap.get("warehouse")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            saleOrderEntryInfo.setWarehouse(DataImportUtils.getWarehouseInfoFromNumber((Context)ctx, (String)strNumber));
        }
        if ((strNumber = (String)entryMap.get("companyorgunit")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            saleOrderEntryInfo.setCompanyOrgUnit(DataImportUtils.getCompanyOrgUnitInfoFromNumber((Context)ctx, (String)strNumber));
        }
        if ((strNumber = (String)entryMap.get("storageorgunit")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            saleOrderEntryInfo.setStorageOrgUnit(DataImportUtils.getStorageOrgUnitInfoFromNumber((Context)ctx, (String)strNumber));
        }
        if ((strNumber = (String)entryMap.get("deliverydate")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            bizDate = XMLUtil.convertStrToDate((String)strNumber, (String)"yyyy-MM-dd");
            saleOrderEntryInfo.setDeliveryDate(bizDate);
        }
        if ((strNumber = (String)entryMap.get("senddate")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            bizDate = XMLUtil.convertStrToDate((String)strNumber, (String)"yyyy-MM-dd");
            saleOrderEntryInfo.setSendDate(bizDate);
        }
        if ((strNumber = (String)entryMap.get("discounttype")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            enumeration = DiscountModeEnum.getEnum((String)strNumber);
            saleOrderEntryInfo.setDiscountType(enumeration);
        }
        if ((strNumber = (String)entryMap.get("discountcondition")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            enumeration = DiscountConditionEnum.getEnum((String)strNumber);
            saleOrderEntryInfo.setDiscountCondition((DiscountConditionEnum)enumeration);
        }
        if ((strNumber = (String)entryMap.get("deliveryCustomer")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            saleOrderEntryInfo.setDeliveryCustomer(DataImportUtils.getCustomerInfoFromNumber((Context)ctx, (String)strNumber));
        }
        if ((strNumber = (String)entryMap.get("paymentCustomer")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            saleOrderEntryInfo.setPaymentCustomer(DataImportUtils.getCustomerInfoFromNumber((Context)ctx, (String)strNumber));
        }
        if ((strNumber = (String)entryMap.get("receiveCustomer")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            saleOrderEntryInfo.setReceiveCustomer(DataImportUtils.getCustomerInfoFromNumber((Context)ctx, (String)strNumber));
        }
    }

    private void dealwithOtherFields_Head(Context ctx, SaleOrderInfo info, HashMap billHeadMap) throws BOSException, ParseException {
        String strNumber = null;
        strNumber = (String)billHeadMap.get("id");
        if (strNumber != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            info.setId(BOSUuid.read((String)strNumber));
        }
        if ((strNumber = (String)billHeadMap.get("cu")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            info.setCU(DataImportUtils.getCtrlUnitInfoFromNumber((Context)ctx, (String)strNumber));
        }
        if ((strNumber = (String)billHeadMap.get("creator")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            info.setCreator(DataImportUtils.getUserInfoFromNumber((Context)ctx, (String)strNumber));
        }
        if ((strNumber = (String)billHeadMap.get("createtime")) != null && strNumber.trim().length() > 0) {
            try {
                strNumber = strNumber.trim();
                Timestamp ts = Timestamp.valueOf(strNumber);
                info.setCreateTime(ts);
            }
            catch (IllegalArgumentException exc) {
                info.setNull("createtime");
            }
        }
        if ((strNumber = (String)billHeadMap.get("lastupdateuser")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            info.setLastUpdateUser(DataImportUtils.getUserInfoFromNumber((Context)ctx, (String)strNumber));
        }
        if ((strNumber = (String)billHeadMap.get("lastupdatetime")) != null && strNumber.trim().length() > 0) {
            try {
                strNumber = strNumber.trim();
                Timestamp lats = Timestamp.valueOf(strNumber);
                info.setCreateTime(lats);
            }
            catch (IllegalArgumentException exc) {
                info.setNull("lastupdatetime");
            }
        }
        if ((strNumber = (String)billHeadMap.get("bizdate")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            Date bizDate = XMLUtil.convertStrToDate((String)strNumber, (String)"yyyy-MM-dd");
            info.setBizDate(bizDate);
        }
        if ((strNumber = (String)billHeadMap.get("handler")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            info.setHandler(DataImportUtils.getUserInfoFromNumber((Context)ctx, (String)strNumber));
        }
        if ((strNumber = (String)billHeadMap.get("auditor")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            info.setAuditor(DataImportUtils.getUserInfoFromNumber((Context)ctx, (String)strNumber));
        }
        if ((strNumber = (String)billHeadMap.get("audittime")) != null && strNumber.trim().length() > 0) {
            try {
                strNumber = strNumber.trim();
                Timestamp atts = Timestamp.valueOf(strNumber);
                info.setAuditTime(atts);
            }
            catch (IllegalArgumentException exc) {
                info.setNull("audittime");
            }
        }
        if ((strNumber = (String)billHeadMap.get("basestatus")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            BillBaseStatusEnum bbse = BillBaseStatusEnum.getEnum((String)strNumber);
            info.setBaseStatus(bbse);
        }
        if ((strNumber = (String)billHeadMap.get("biztype")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            info.setBizType(DataImportUtils.getBizTypeInfoFromNumber((Context)ctx, (String)strNumber));
        }
        if ((strNumber = (String)billHeadMap.get("sourcebilltype")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            info.setSourceBillType(DataImportUtils.getBillTypeInfoFromNumber((Context)ctx, (String)strNumber));
        }
        if ((strNumber = (String)billHeadMap.get("billtype")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            info.setBillType(DataImportUtils.getBillTypeInfoFromNumber((Context)ctx, (String)strNumber));
        }
        if ((strNumber = (String)billHeadMap.get("modifier")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            info.setModifier(DataImportUtils.getUserInfoFromNumber((Context)ctx, (String)strNumber));
        }
        if ((strNumber = (String)billHeadMap.get("modificationtime")) != null && strNumber.trim().length() > 0) {
            try {
                strNumber = strNumber.trim();
                Timestamp mots = Timestamp.valueOf(strNumber);
                info.setModificationTime(mots);
            }
            catch (IllegalArgumentException exc) {
                info.setNull("modificationtime");
            }
        }
        if ((strNumber = (String)billHeadMap.get("companyorgunit")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            info.setCompanyOrgUnit(DataImportUtils.getCompanyOrgUnitInfoFromNumber((Context)ctx, (String)strNumber));
        }
        if ((strNumber = (String)billHeadMap.get("convertmode")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            ConvertModeEnum cmem = ConvertModeEnum.getEnum((String)strNumber);
            info.setConvertMode(cmem);
        }
        if ((strNumber = (String)billHeadMap.get("adminorgunit")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            info.setAdminOrgUnit(DataImportUtils.getAdminOrgUnitInfoFromNumber((Context)ctx, (String)strNumber));
        }
        if ((strNumber = (String)billHeadMap.get("saleperson")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            info.setSalePerson(DataImportUtils.getPersonInfoFromNumber((Context)ctx, (String)strNumber));
        }
        if ((strNumber = (String)billHeadMap.get("salegroup")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            info.setSaleGroup(DataImportUtils.getSaleGroupInfoFromNumber((Context)ctx, (String)strNumber));
        }
        if ((strNumber = (String)billHeadMap.get("saleorgunit")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            info.setSaleOrgUnit(DataImportUtils.getSaleOrgUnitInfoFromNumber((Context)ctx, (String)strNumber));
        }
        if ((strNumber = (String)billHeadMap.get("settlementtype")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            info.setSettlementType(DataImportUtils.getSettlementTypeInfoFromNumber((Context)ctx, (String)strNumber));
        }
        if ((strNumber = (String)billHeadMap.get("cashdiscount")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            info.setCashDiscount(DataImportUtils.getCashDiscountInfoByNumber((Context)ctx, (String)strNumber));
        }
        if ((strNumber = (String)billHeadMap.get("paymenttype")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            info.setPaymentType(DataImportUtils.getPaymentTypeInfoFromNumber((Context)ctx, (String)strNumber));
        }
        if ((strNumber = (String)billHeadMap.get("currency")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            info.setCurrency(DataImportUtils.getCurrencyInfoFromNumber((Context)ctx, (String)strNumber));
        }
        if ((strNumber = (String)billHeadMap.get("deliverytype")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            info.setDeliveryType(DataImportUtils.getDeliveryTypeInfoFromNumber((Context)ctx, (String)strNumber));
        }
        if ((strNumber = (String)billHeadMap.get("purchaseorgunit")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            info.setPurchaseOrgUnit(DataImportUtils.getPurchaseUnitInfoFromNumber((Context)ctx, (String)strNumber));
        }
        if ((strNumber = (String)billHeadMap.get("directsupplier")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            info.setDirectSupplier(DataImportUtils.getSupplierInfoFromNumber((Context)ctx, (String)strNumber));
        }
        if ((strNumber = (String)billHeadMap.get("ordercustomer")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            info.setOrderCustomer(DataImportUtils.getCustomerInfoFromNumber((Context)ctx, (String)strNumber));
        }
    }

    private void dealWithStringFields(CoreBaseInfo info, HashMap billHeadMap, String[] string_Fields) {
        int c = string_Fields.length;
        for (int i = 0; i < c; ++i) {
            if (billHeadMap.get(string_Fields[i]) == null) {
                info.setNull(string_Fields[i].toLowerCase().trim());
                continue;
            }
            String value = (String)billHeadMap.get(string_Fields[i]);
            info.setString(string_Fields[i].toLowerCase().trim(), value);
        }
    }

    private void dealWithBooleanFields(CoreBaseInfo info, HashMap billHeadMap, String[] boolean_Fields) {
        try {
            int c = boolean_Fields.length;
            for (int i = 0; i < c; ++i) {
                String fieldName = boolean_Fields[i].toLowerCase().trim();
                String fieldValue = (String)billHeadMap.get(boolean_Fields[i]);
                if (!(fieldValue != null && !fieldValue.trim().equals("") && fieldValue.trim().equals("true") && fieldValue.trim().equals("false") && fieldValue.trim().equals("1") && fieldValue.trim().equals("0"))) {
                    info.setNull(fieldName);
                    continue;
                }
                if (fieldValue.equals("1")) {
                    info.setBoolean(fieldName, true);
                    continue;
                }
                if (fieldValue.equals("0")) {
                    info.setBoolean(fieldName, false);
                    continue;
                }
                info.setBoolean(fieldName, Boolean.parseBoolean(fieldValue.trim()));
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    private void dealWithBigDecimalFields(CoreBaseInfo info, HashMap billHeadMap, String[] bigDecimal_Fields) {
        int c = bigDecimal_Fields.length;
        for (int i = 0; i < c; ++i) {
            String fieldName = bigDecimal_Fields[i].toLowerCase().trim();
            String fieldValue = (String)billHeadMap.get(bigDecimal_Fields[i]);
            try {
                if (fieldValue == null || fieldValue.trim().equals("")) {
                    info.setNull(fieldName);
                    continue;
                }
                info.setBigDecimal(fieldName, new BigDecimal(fieldValue.trim()));
                continue;
            }
            catch (NumberFormatException ne) {
                info.setNull(fieldName);
            }
        }
    }

    private void dealWithIntFields(CoreBaseInfo info, HashMap billHeadMap, String[] int_Fields) {
        int c = int_Fields.length;
        for (int i = 0; i < c; ++i) {
            String fieldName = int_Fields[i].toLowerCase().trim();
            String fieldValue = (String)billHeadMap.get(int_Fields[i]);
            try {
                if (fieldValue == null || fieldValue.trim().equals("")) {
                    info.setNull(fieldName);
                    continue;
                }
                info.setInt(fieldName, Integer.parseInt(fieldValue.trim()));
                continue;
            }
            catch (NumberFormatException ne) {
                info.setNull(fieldName);
            }
        }
    }

    private void validateProperty(HashMap billHeadMap, ArrayList billEntriesList) throws EASBizException {
        String[] bilHeadProps = this.getValidateBillHeadProps();
        for (int i = 0; i < bilHeadProps.length; ++i) {
            if (InfoUtil.validateProperty((HashMap)billHeadMap, (String)bilHeadProps[i])) continue;
            throw new EASBizException(new NumericExceptionSubItem("1000", bilHeadProps[i] + UIConstant.PROPNOTEMPT));
        }
        String[] bilEntriesProps = this.getValidateBillEntriesProps();
        HashMap entryMap = null;
        for (int i = 0; i < billEntriesList.size(); ++i) {
            entryMap = (HashMap)billEntriesList.get(i);
            for (int j = 0; j < bilEntriesProps.length; ++j) {
                if (InfoUtil.validateProperty((HashMap)entryMap, (String)bilEntriesProps[i])) continue;
                throw new EASBizException(new NumericExceptionSubItem("2000", bilEntriesProps[i] + UIConstant.PROPNOTEMPT));
            }
        }
    }

    private String[] getValidateBillHeadProps() {
        String[] props = new String[]{"number", "cu"};
        return props;
    }

    private String[] getValidateBillEntriesProps() {
        String[] props = new String[]{};
        return props;
    }
}

