/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.ITableManagerFacade;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sd.sale.report.app.AbstractConsignVerificationAccountFacadeControllerBean;
import com.kingdee.eas.scm.util.constant.RecIssueTypeConstant;
import com.kingdee.eas.util.app.DbUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class ConsignVerificationAccountFacadeControllerBean
extends AbstractConsignVerificationAccountFacadeControllerBean {
    private String companyOrg = null;
    private String saleOrg = null;
    private String storageOrg = null;
    private String materialFrom = null;
    private String materialTo = null;
    private String materialIn = null;
    private String customerFrom = null;
    private String customerTo = null;
    private String customerIn = null;
    private String dateFrom = null;
    private String dateTo = null;
    private String onlyDisplaySumLine = "false";
    private String noDisplaySendZero = "false";
    private String noDisplayStockZero = "false";
    private String tempTableName = null;
    private String sumLabel = null;
    private static final String ResClassName = "com.kingdee.eas.scm.sd.sale.report.SDReportResource";
    private static final String sp = "\r\n";
    private Context ctx = null;
    private String locLan = "L2";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sd.sale.report.app.ConsignVerificationAccountFacadeControllerBean");

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        this.locLan = this.getLoc(ctx);
        try {
            this.init(ctx, params);
            this.tempTableName = ConsignVerificationAccountFacadeControllerBean.createTemptable(ctx);
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)params.getObject("companyOrg");
            String companyId = company.getId().toString();
            Boolean flag = SCMServerUtils.getAuthorizedOrgUnit((Context)ctx, (String)companyId, (String)"ConsignVerificationOfAccount_view");
            this.sumLabel = SCMUtils.getResource((String)ResClassName, (String)"SUB_STRING", (Context)ctx);
            if (flag.booleanValue()) {
                this.processData();
            }
            int rowCount = this.totalRowCount(ctx);
            params.setString("tempTableName", this.tempTableName);
            params.setInt("rowCount", rowCount);
        }
        catch (BOSException e) {
            if (this.tempTableName != null) {
                try {
                    ITableManagerFacade iTableManager = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
                    iTableManager.releaseTemporaryTableName(this.tempTableName);
                    iTableManager.dropReleasedTable();
                }
                catch (Exception ee) {
                    logger.error((Object)ee);
                }
            }
            throw e;
        }
        catch (EASBizException e) {
            if (this.tempTableName != null) {
                try {
                    ITableManagerFacade iTableManager = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
                    iTableManager.releaseTemporaryTableName(this.tempTableName);
                    iTableManager.dropReleasedTable();
                }
                catch (Exception ee) {
                    logger.error((Object)ee);
                }
            }
            throw e;
        }
        return params;
    }

    private int totalRowCount(Context ctx) throws BOSException, EASBizException {
        String countSql = "SELECT count(1) cc FROM " + this.tempTableName;
        RptRowSet rs = this.executeQuery(countSql, null, ctx);
        rs.next();
        int count = 0;
        if (rs.getObject(0) != null) {
            count = rs.getInt(0);
        }
        return count;
    }

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        this.locLan = this.getLoc(ctx);
        String tempTable = params.getString("tempTableName");
        StringBuffer sql = new StringBuffer(800);
        sql.append("SELECT ");
        sql.append(" FCustomerNum,FCustomerName,FMaterialNum,FMaterialName,FModel,FassistPropertyName,FBaseUnitName,");
        sql.append(" case when startPeriodQty = 0 then 0 else to_decimal(startPeriodAmount/startPeriodQty,21,8) end startPeriodPrice,");
        sql.append(" startPeriodQty,startPeriodAmount,");
        sql.append(" case when periodSendQty = 0 then 0 else to_decimal(periodSendAmount/periodSendQty,21,8) end periodSendPrice,");
        sql.append(" periodSendQty,periodSendAmount,");
        sql.append(" case when thisPeriodQty = 0 then 0 else to_decimal(thisPeriodAmount/thisPeriodQty,21,8) end thisPeriodPrice,");
        sql.append(" thisPeriodQty,thisPeriodAmount,");
        sql.append(" case when periodStockQty = 0 then 0 else to_decimal(periodStockAmount/periodStockQty,21,8) end periodStockPrice,");
        sql.append(" periodStockQty, periodStockAmount");
        sql.append(" FROM ").append(tempTable);
        sql.append(" ORDER BY FCustomerName,FMaterialNum ");
        try {
            RptRowSet rs = this.executeQuery(sql.toString(), null, from, len, ctx);
            RptParams pp = new RptParams();
            pp.setObject("rowset", (Object)rs);
            return pp;
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    public void processData() throws BOSException, EASBizException {
        this.getRptBaseColumn();
        this.getRptStartPeriod();
        this.getRptInnerDateQtyAndAmount();
        this.getRptThisPeriod();
        this.getRptTotalRow();
        this.deleteRptByZero();
    }

    private void getRptBaseColumn() throws BOSException {
        StringBuffer sql = new StringBuffer(800);
        sql.append(" INSERT INTO ").append(this.tempTableName);
        sql.append(" (");
        sql.append(" FCUSTOMERID,FCUSTOMERNUM,FCUSTOMERNAME,");
        sql.append(" FMATERIALID,FMATERIALNUM,FMATERIALNAME,FMODEL,");
        sql.append(" FBASEUNITID,FBASEUNITNAME,FASSISTPROPERTYID,FASSISTPROPERTYNAME,");
        sql.append(" FCOMPANYORGUNITID,FSALEORGUNITID,FSTORAGEORGUNITID, ");
        sql.append(" FBIZTYPEID,FTRANSACTIONTYPEID,FRITypeID,");
        sql.append(" startPeriodPrice,startPeriodQty,startPeriodAmount,");
        sql.append(" periodSendPrice,periodSendQty,periodSendAmount,");
        sql.append(" thisPeriodPrice,thisPeriodQty,thisPeriodAmount,");
        sql.append(" periodStockPrice,periodStockQty,periodStockAmount");
        sql.append(" )").append(sp);
        sql.append(" SELECT ");
        sql.append(" customer.FID customerId, customer.FNumber customerNum, customer.FName_").append(this.locLan).append(" customerName,").append(sp);
        sql.append(" material.FID materialId, material.FNumber materialNum, material.FName_").append(this.locLan).append(" materialName, material.FModel,").append(sp);
        sql.append(" baseUnit.FID baseUnitId, baseUnit.FName_").append(this.locLan).append(" baseUnitName,").append(sp);
        sql.append(" ISNULL(assistProperty.FID,'1') assistPropertyId, assistProperty.FName_").append(this.locLan).append(" assistPropertyName,").append(sp);
        sql.append(" entries.FCompanyOrgUnitId, entries.FSaleOrgUnitId,entries.FStorageOrgUnitId, ").append(sp);
        sql.append(" head.FBizTypeID, head.FTransActionTypeID, transType.FRITypeID, ").append(sp);
        sql.append(" 0 startPeriodPrice,0 startPeriodQty,0 startPeriodAmount,");
        sql.append(" 0 periodSendPrice,0 periodSendQty,0 periodSendAmount,");
        sql.append(" 0 thisPeriodPrice,0 thisPeriodQty,0 thisPeriodAmount,");
        sql.append(" 0 periodStockPrice,0 periodStockQty,0 periodStockAmount");
        sql.append(" FROM ").append(sp);
        sql.append(" T_IM_SALEISSUEENTRY entries ").append(sp);
        sql.append(" LEFT OUTER JOIN T_IM_SALEISSUEBILL head ON head.FID = entries.FPARENTID ").append(sp);
        sql.append(" LEFT OUTER JOIN T_BD_MATERIAL material ON material.FID = entries.FMaterialID ").append(sp);
        sql.append(" LEFT OUTER JOIN T_BD_CUSTOMER customer ON customer.FID = entries.FOrderCustomerID ").append(sp);
        sql.append(" LEFT OUTER JOIN T_BD_MEASUREUNIT baseUnit ON baseUnit.FID = entries.FBaseUnitID ").append(sp);
        sql.append(" LEFT OUTER JOIN T_BD_AsstAttrValue assistProperty ON assistProperty.FID = entries.FAssistPropertyID").append(sp);
        sql.append(" LEFT OUTER JOIN T_SCM_TransactionType transType ON head.FTransactionTypeID = transType.FID").append(sp);
        sql.append(" WHERE 1 = 1 ").append(sp);
        sql.append(" AND entries.FCompanyOrgUnitID = '").append(this.companyOrg).append("' ").append(sp);
        sql.append(" AND head.FBizDate <= ").append(this.dateTo).append(sp);
        sql.append(" AND head.FBizTypeID in('").append("d8e80652-0113-1000-e000-04c5c0a812202407435C").append("','").append("d8e80652-0114-1000-e000-04c5c0a812202407435C").append("')").append(sp);
        if (this.saleOrg != null) {
            sql.append(" AND entries.FSaleOrgUnitID IN (").append(this.saleOrg).append(")").append(sp);
        }
        if (this.storageOrg != null) {
            sql.append(" AND entries.FStorageOrgUnitID IN (").append(this.storageOrg).append(")").append(sp);
        }
        if (this.materialFrom != null) {
            sql.append(" AND material.FNumber >= '").append(this.materialFrom).append("'").append(sp);
        }
        if (this.materialTo != null) {
            sql.append(" AND material.FNumber <= '").append(this.materialTo).append("'").append(sp);
        }
        if (this.materialIn != null) {
            sql.append(" AND material.FNumber in (").append(this.materialIn).append(")").append(sp);
        }
        if (this.customerFrom != null) {
            sql.append(" AND customer.FNumber >= '").append(this.customerFrom).append("'").append(sp);
        }
        if (this.customerTo != null) {
            sql.append(" AND customer.FNumber <= '").append(this.customerTo).append("'").append(sp);
        }
        if (this.customerIn != null) {
            sql.append(" AND customer.FNumber in (").append(this.customerIn).append(")").append(sp);
        }
        sql.append(" GROUP BY ");
        sql.append(" customer.FID, customer.FNumber, customer.FName_").append(this.locLan).append(",");
        sql.append(" material.FID, material.FNumber, material.FName_").append(this.locLan).append(", material.FModel,");
        sql.append(" baseUnit.FID, baseUnit.FName_").append(this.locLan).append(",");
        sql.append(" assistProperty.FID, assistProperty.FName_").append(this.locLan).append(",");
        sql.append(" entries.FCompanyOrgUnitId, entries.FSaleOrgUnitId,entries.FStorageOrgUnitId,");
        sql.append(" head.FBizTypeID, head.FTransActionTypeID,transType.FRITypeID ");
        DbUtil.execute((Context)this.ctx, (String)sql.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getRptStartPeriod() throws BOSException {
        StringBuffer sql = new StringBuffer(1000);
        String tempTable = null;
        try {
            tempTable = ConsignVerificationAccountFacadeControllerBean.createTemptable(this.ctx);
            sql.append(" INSERT INTO ").append(tempTable).append(sp);
            sql.append(" (FCompanyOrgUnitId,FMaterialId,FCustomerId,FStorageOrgUnitId,");
            sql.append(" FSaleOrgUnitId, ftransactiontypeid, FAssistPropertyId,");
            sql.append(" startPeriodQty,startPeriodAmount)");
            sql.append(" SELECT ");
            sql.append(" entries.FCompanyOrgUnitId,entries.FMaterialId,entries.FOrderCustomerId,entries.FStorageOrgUnitId,");
            sql.append(" entries.FSaleOrgUnitId,head.ftransactiontypeid,ISNULL(entries.FAssistPropertyId,'1'),");
            sql.append(" SUM(CASE WHEN transType.FRITypeID = '").append(RecIssueTypeConstant.CONSIGNOUT_RITYPEID).append("'");
            sql.append("    OR transType.FRITypeID = '").append(RecIssueTypeConstant.CONSIGNRT_RITYPEID).append("'");
            sql.append("  THEN entries.FBaseQty ELSE 0 END)");
            sql.append(" - ");
            sql.append(" SUM(CASE WHEN transType.FRITypeID = '").append(RecIssueTypeConstant.SALEOUT_RITYPEID).append("'");
            sql.append(" AND riType.FBizDirection = 1 ").append("");
            sql.append(" THEN entries.FBaseQty ELSE 0 END) startPeriodQty, ").append(sp);
            sql.append(" SUM(CASE WHEN transType.FRITypeID = '").append(RecIssueTypeConstant.CONSIGNOUT_RITYPEID).append("'");
            sql.append("    OR transType.FRITypeID = '").append(RecIssueTypeConstant.CONSIGNRT_RITYPEID).append("'");
            sql.append("  THEN entries.FLocalAmount ELSE 0 END)");
            sql.append(" - ");
            sql.append(" SUM(CASE WHEN transType.FRITypeID = '").append(RecIssueTypeConstant.SALEOUT_RITYPEID).append("'");
            sql.append(" AND riType.FBizDirection = 1 ").append("");
            sql.append(" THEN entries.FLocalAmount ELSE 0 END) startPeriodAmount ").append(sp);
            sql.append(" FROM T_IM_SALEISSUEBILL head ");
            sql.append(" LEFT OUTER JOIN T_IM_SALEISSUEENTRY entries ON head.FID = entries.FParentID ").append(sp);
            sql.append(" INNER JOIN T_SCM_TransactionType transType ON head.FTransactionTypeID = transType.FID").append(sp);
            sql.append(" INNER JOIN T_IM_RecIssueType riType ON transType.FritypeID = riType.fid ").append(sp);
            sql.append(" WHERE 1=1 ");
            sql.append(" AND head.FBizTypeId in('").append("d8e80652-0113-1000-e000-04c5c0a812202407435C").append("','").append("d8e80652-0114-1000-e000-04c5c0a812202407435C").append("')").append(sp);
            sql.append(" AND head.FBizDate < ").append(this.dateFrom).append(" ").append(sp);
            sql.append(" AND entries.FCompanyOrgUnitId = '").append(this.companyOrg).append("'").append(sp);
            sql.append(" GROUP BY ");
            sql.append(" entries.FCompanyorgunitid, entries.FMaterialid, entries.FOrdercustomerid, ");
            sql.append(" entries.FAssistPropertyID, entries.FSaleorgunitid,entries.FStorageorgunitid,");
            sql.append(" head.ftransactiontypeid");
            DbUtil.execute((Context)this.ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append(" UPDATE ").append(this.tempTableName).append(" AS tt ");
            sql.append(" SET (startPeriodQty,startPeriodAmount) = (").append(sp);
            sql.append(" SELECT startPeriodQty,startPeriodAmount ");
            sql.append(" FROM ").append(tempTable).append(" entries ");
            sql.append(" WHERE 1=1 ");
            sql.append(" AND tt.FCompanyOrgUnitId = entries.FCompanyOrgUnitId ").append(sp);
            sql.append(" AND tt.FMaterialId = entries.FMaterialId ").append(sp);
            sql.append(" AND tt.FCustomerId = entries.FCustomerId ").append(sp);
            sql.append(" AND tt.FStorageOrgUnitId = entries.FStorageOrgUnitId ").append(sp);
            sql.append(" AND isnull(tt.FSaleOrgUnitId,'xxxx') = isnull(entries.FSaleOrgUnitId,'xxxx') ").append(sp);
            sql.append(" AND tt.ftransactiontypeid = entries.ftransactiontypeid ").append(sp);
            sql.append(" AND isnull(tt.FAssistPropertyID,'1') = isnull(entries.FAssistPropertyId,'1') ").append(sp);
            sql.append(" )");
            DbUtil.execute((Context)this.ctx, (String)sql.toString());
        }
        finally {
            if (tempTable != null) {
                try {
                    ITableManagerFacade iTableManager = TableManagerFacadeFactory.getLocalInstance((Context)this.ctx);
                    iTableManager.releaseTemporaryTableName(tempTable);
                    iTableManager.dropReleasedTable();
                }
                catch (Exception ee) {
                    logger.error((Object)ee);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getRptInnerDateQtyAndAmount() throws BOSException {
        StringBuffer sql = new StringBuffer(1000);
        String tempTable = null;
        try {
            tempTable = ConsignVerificationAccountFacadeControllerBean.createTemptable(this.ctx);
            sql.append(" INSERT INTO ").append(tempTable).append(sp);
            sql.append(" (FCompanyOrgUnitId,FMaterialId,FCustomerId,FStorageOrgUnitId,");
            sql.append(" FSaleOrgUnitId, ftransactiontypeid, FAssistPropertyId,");
            sql.append(" periodSendQty,periodSendAmount)");
            sql.append(" SELECT ");
            sql.append(" entries.FCompanyOrgUnitId,entries.FMaterialId,entries.FOrderCustomerId,entries.FStorageOrgUnitId,");
            sql.append(" entries.FSaleOrgUnitId,head.ftransactiontypeid,entries.ISNULL(entries.FAssistPropertyId,'1'),");
            sql.append(" SUM(CASE WHEN transType.FRITypeID = '").append(RecIssueTypeConstant.CONSIGNOUT_RITYPEID).append("' ");
            sql.append("     OR transType.FRITypeID = '").append(RecIssueTypeConstant.CONSIGNRT_RITYPEID).append("'");
            sql.append("   THEN entries.FBaseQty ELSE 0 END) periodSendQty, ");
            sql.append(" SUM(CASE WHEN transType.FRITypeID = '").append(RecIssueTypeConstant.CONSIGNOUT_RITYPEID).append("' ");
            sql.append("     OR transType.FRITypeID = '").append(RecIssueTypeConstant.CONSIGNRT_RITYPEID).append("' ");
            sql.append("   THEN entries.FLocalAmount ELSE 0 END) periodSendAmount ");
            sql.append(" FROM T_IM_SALEISSUEBILL head ");
            sql.append(" LEFT OUTER JOIN T_IM_SALEISSUEENTRY entries ON head.FID = entries.FParentID ").append(sp);
            sql.append(" INNER JOIN T_SCM_TransactionType transType ON head.FTransactionTypeID = transType.FID").append(sp);
            sql.append(" WHERE 1=1 ");
            sql.append(" AND head.FBizTypeId in('").append("d8e80652-0113-1000-e000-04c5c0a812202407435C").append("','").append("d8e80652-0114-1000-e000-04c5c0a812202407435C").append("')").append(sp);
            sql.append(" AND head.FBizDate >= ").append(this.dateFrom).append(" ").append(sp);
            sql.append(" AND head.FBizDate <= ").append(this.dateTo).append(" ").append(sp);
            sql.append(" AND entries.FCompanyOrgUnitId = '").append(this.companyOrg).append("'").append(sp);
            sql.append(" GROUP BY ");
            sql.append(" entries.FCompanyorgunitid, entries.FMaterialid, entries.FOrdercustomerid, ");
            sql.append(" entries.FAssistpropertyid, entries.FSaleorgunitid,entries.FStorageorgunitid,");
            sql.append(" head.ftransactiontypeid");
            DbUtil.execute((Context)this.ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append(" UPDATE ").append(this.tempTableName).append(" AS tt ");
            sql.append(" SET (periodSendQty,periodSendAmount) = (").append(sp);
            sql.append(" SELECT periodSendQty,periodSendAmount ");
            sql.append(" FROM ").append(tempTable).append(" entries ");
            sql.append(" WHERE 1=1 ");
            sql.append(" AND tt.FCompanyOrgUnitId = entries.FCompanyOrgUnitId ").append(sp);
            sql.append(" AND tt.FMaterialId = entries.FMaterialId ").append(sp);
            sql.append(" AND tt.FCustomerId = entries.FCustomerId ").append(sp);
            sql.append(" AND tt.FStorageOrgUnitId = entries.FStorageOrgUnitId ").append(sp);
            sql.append(" AND isnull(tt.FSaleOrgUnitId,'xxxx') = isnull(entries.FSaleOrgUnitId,'xxxx') ").append(sp);
            sql.append(" AND tt.ftransactiontypeid = entries.ftransactiontypeid ").append(sp);
            sql.append(" AND tt.FBizTypeID in('").append("d8e80652-0113-1000-e000-04c5c0a812202407435C").append("','").append("d8e80652-0114-1000-e000-04c5c0a812202407435C").append("')").append(sp);
            sql.append(" AND (tt.FRITypeID = '").append(RecIssueTypeConstant.CONSIGNOUT_RITYPEID).append("' OR tt.FRITypeID = '").append(RecIssueTypeConstant.CONSIGNRT_RITYPEID).append("')").append(sp);
            sql.append(" AND isnull(tt.FAssistPropertyID,'1') = isnull(entries.FAssistPropertyId,'1') ").append(sp);
            sql.append(" )");
            DbUtil.execute((Context)this.ctx, (String)sql.toString());
        }
        finally {
            if (tempTable != null) {
                try {
                    ITableManagerFacade iTableManager = TableManagerFacadeFactory.getLocalInstance((Context)this.ctx);
                    iTableManager.releaseTemporaryTableName(tempTable);
                    iTableManager.dropReleasedTable();
                }
                catch (Exception ee) {
                    logger.error((Object)ee);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getRptThisPeriod() throws BOSException {
        StringBuffer sql = new StringBuffer(1000);
        String tempTable = null;
        try {
            tempTable = ConsignVerificationAccountFacadeControllerBean.createTemptable(this.ctx);
            sql.append(" INSERT INTO ").append(tempTable).append(sp);
            sql.append(" (FCompanyOrgUnitId,FMaterialId,FCustomerId,FStorageOrgUnitId,");
            sql.append(" FSaleOrgUnitId, ftransactiontypeid, FAssistPropertyId,");
            sql.append(" thisPeriodQty,thisPeriodAmount)");
            sql.append(" SELECT ");
            sql.append(" entries.FCompanyOrgUnitId,entries.FMaterialId,entries.FOrderCustomerId,entries.FStorageOrgUnitId,");
            sql.append(" entries.FSaleOrgUnitId,head.ftransactiontypeid,ISNULL(entries.FAssistPropertyId,'1'),");
            sql.append(" SUM(CASE WHEN transType.FRITypeID = '").append(RecIssueTypeConstant.SALEOUT_RITYPEID).append("' ");
            sql.append("   THEN entries.FBaseQty ELSE 0 END) thisPeriodQty, ").append(sp);
            sql.append(" SUM(CASE WHEN transType.FRITypeID = '").append(RecIssueTypeConstant.SALEOUT_RITYPEID).append("' ");
            sql.append("   THEN entries.FLocalAmount ELSE 0 END) thisPeriodAmount ").append(sp);
            sql.append(" FROM T_IM_SALEISSUEBILL head ");
            sql.append(" LEFT OUTER JOIN T_IM_SALEISSUEENTRY entries ON head.FID = entries.FParentID ").append(sp);
            sql.append(" INNER JOIN T_SCM_TransactionType transType ON head.FTransactionTypeID = transType.FID").append(sp);
            sql.append(" INNER JOIN T_IM_RecIssueType riType ON transType.fritypeid = ritype.fid ").append(sp);
            sql.append(" WHERE 1=1 ");
            sql.append(" AND head.FBizTypeId = '").append("d8e80652-0113-1000-e000-04c5c0a812202407435C").append("' ").append(sp);
            sql.append(" AND head.FBizDate >= ").append(this.dateFrom).append(" ").append(sp);
            sql.append(" AND head.FBizDate <= ").append(this.dateTo).append(" ").append(sp);
            sql.append(" AND entries.FCompanyOrgUnitId = '").append(this.companyOrg).append("'").append(sp);
            sql.append(" GROUP BY ");
            sql.append(" entries.FCompanyorgunitid, entries.FMaterialid, entries.FOrdercustomerid, ");
            sql.append(" entries.FAssistpropertyid, entries.FSaleorgunitid,entries.FStorageorgunitid,");
            sql.append(" head.ftransactiontypeid");
            DbUtil.execute((Context)this.ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append(" UPDATE ").append(this.tempTableName).append(" AS tt ");
            sql.append(" SET (thisPeriodQty,thisPeriodAmount) = (").append(sp);
            sql.append(" SELECT thisPeriodQty,thisPeriodAmount ");
            sql.append(" FROM ").append(tempTable).append(" entries ");
            sql.append(" WHERE 1=1 ");
            sql.append(" AND tt.FCompanyOrgUnitId = entries.FCompanyOrgUnitId ").append(sp);
            sql.append(" AND tt.FMaterialId = entries.FMaterialId ").append(sp);
            sql.append(" AND tt.FCustomerId = entries.FCustomerId ").append(sp);
            sql.append(" AND tt.FStorageOrgUnitId = entries.FStorageOrgUnitId ").append(sp);
            sql.append(" AND isnull(tt.FSaleOrgUnitId,'xxxx') = isnull(entries.FSaleOrgUnitId,'xxxx') ").append(sp);
            sql.append(" AND tt.ftransactiontypeid = entries.ftransactiontypeid ").append(sp);
            sql.append(" AND tt.FBizTypeID = '").append("d8e80652-0113-1000-e000-04c5c0a812202407435C").append("'").append(sp);
            sql.append(" AND tt.FRITypeID = '").append(RecIssueTypeConstant.SALEOUT_RITYPEID).append("'").append(sp);
            sql.append(" AND isnull(tt.FAssistPropertyID,'1') = isnull(entries.FAssistPropertyId,'1') ").append(sp);
            sql.append(" )");
            DbUtil.execute((Context)this.ctx, (String)sql.toString());
        }
        finally {
            if (tempTable != null) {
                try {
                    ITableManagerFacade iTableManager = TableManagerFacadeFactory.getLocalInstance((Context)this.ctx);
                    iTableManager.releaseTemporaryTableName(tempTable);
                    iTableManager.dropReleasedTable();
                }
                catch (Exception ee) {
                    logger.error((Object)ee);
                }
            }
        }
    }

    private void getRptTotalRow() throws BOSException {
        String tempTable = null;
        String tempTableTotal = null;
        try {
            tempTable = ConsignVerificationAccountFacadeControllerBean.createTemptable(this.ctx);
            tempTableTotal = ConsignVerificationAccountFacadeControllerBean.createTemptable(this.ctx);
            StringBuffer sql = new StringBuffer(1000);
            sql.append(" DELETE FROM ").append(this.tempTableName).append(" WHERE FCustomerID IS NULL");
            DbUtil.execute((Context)this.ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append(" INSERT INTO ").append(tempTable);
            sql.append(" (");
            sql.append(" FCUSTOMERID,FCUSTOMERNUM,FCUSTOMERNAME,");
            sql.append(" FMATERIALID,FMATERIALNUM,FMATERIALNAME,FMODEL,");
            sql.append(" FBASEUNITID,FBASEUNITNAME,FASSISTPROPERTYID,FASSISTPROPERTYNAME,");
            sql.append(" startPeriodPrice,startPeriodQty,startPeriodAmount,");
            sql.append(" periodSendPrice,periodSendQty,periodSendAmount,");
            sql.append(" thisPeriodPrice,thisPeriodQty,thisPeriodAmount,");
            sql.append(" periodStockPrice,periodStockQty,periodStockAmount");
            sql.append(" )").append(sp);
            sql.append(" SELECT ");
            sql.append(" FCUSTOMERID,FCUSTOMERNUM,FCUSTOMERNAME,");
            sql.append(" FMATERIALID,FMATERIALNUM,FMATERIALNAME,FMODEL,");
            sql.append(" FBASEUNITID,FBASEUNITNAME,FASSISTPROPERTYID,FASSISTPROPERTYNAME,");
            sql.append(" 0 startPeriodPrice,sum(startPeriodQty),sum(startPeriodAmount),");
            sql.append(" 0 periodSendPrice,sum(periodSendQty),sum(periodSendAmount),");
            sql.append(" 0 thisPeriodPrice,sum(thisPeriodQty),sum(thisPeriodAmount),");
            sql.append(" 0 periodStockPrice,");
            sql.append(" sum(ISNULL(startPeriodQty,0))+sum(ISNULL(periodSendQty,0))-sum(ISNULL(thisPeriodQty,0)) periodStockQty,");
            sql.append(" sum(ISNULL(startPeriodAmount,0))+sum(ISNULL(periodSendAmount,0))-sum(ISNULL(thisPeriodAmount,0)) periodStockAmount");
            sql.append(" FROM ").append(this.tempTableName).append(sp);
            sql.append(" GROUP BY ");
            sql.append(" FCustomerID, fCustomernum, FCustomerName,");
            sql.append(" FMaterialId,FMaterialNum,FMaterialName,FModel,");
            sql.append(" FBaseUnitID,FBaseUnitName,FAssistPropertyID,FAssistPropertyName");
            DbUtil.execute((Context)this.ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append(" INSERT INTO ").append(tempTableTotal);
            sql.append(" (");
            sql.append(" FCUSTOMERNUM,FCUSTOMERNAME,");
            sql.append(" startPeriodPrice,startPeriodQty,startPeriodAmount,");
            sql.append(" periodSendPrice,periodSendQty,periodSendAmount,");
            sql.append(" thisPeriodPrice,thisPeriodQty,thisPeriodAmount,");
            sql.append(" periodStockPrice,periodStockQty,periodStockAmount");
            sql.append(" )").append(sp);
            sql.append(" SELECT ");
            sql.append(" FCUSTOMERNUM,CONCAT(FCustomerName,'(").append(this.sumLabel).append(")') customerName,").append(sp);
            sql.append(" 0 startPeriodPrice,sum(startPeriodQty),sum(startPeriodAmount),");
            sql.append(" 0 periodSendPrice,sum(periodSendQty),sum(periodSendAmount),");
            sql.append(" 0 thisPeriodPrice,sum(thisPeriodQty),sum(thisPeriodAmount),");
            sql.append(" 0 periodStockPrice,");
            sql.append(" sum(ISNULL(startPeriodQty,0))+sum(ISNULL(periodSendQty,0))-sum(ISNULL(thisPeriodQty,0)) periodStockQty,");
            sql.append(" sum(ISNULL(startPeriodAmount,0))+sum(ISNULL(periodSendAmount,0))-sum(ISNULL(thisPeriodAmount,0)) periodStockAmount");
            sql.append(" FROM ").append(tempTable).append(sp);
            sql.append(" GROUP BY FCUSTOMERNUM,FCustomerName");
            DbUtil.execute((Context)this.ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append(" INSERT INTO ").append(tempTable);
            sql.append(" (");
            sql.append(" FCUSTOMERNUM,FCUSTOMERNAME,");
            sql.append(" startPeriodPrice,startPeriodQty,startPeriodAmount,");
            sql.append(" periodSendPrice,periodSendQty,periodSendAmount,");
            sql.append(" thisPeriodPrice,thisPeriodQty,thisPeriodAmount,");
            sql.append(" periodStockPrice,periodStockQty,periodStockAmount");
            sql.append(" )").append(sp);
            sql.append(" SELECT ");
            sql.append(" FCUSTOMERNUM,FCustomerName customerName,").append(sp);
            sql.append(" startPeriodPrice,startPeriodQty,startPeriodAmount,");
            sql.append(" periodSendPrice,periodSendQty,periodSendAmount,");
            sql.append(" thisPeriodPrice,thisPeriodQty,thisPeriodAmount,");
            sql.append(" periodStockPrice,periodStockQty,periodStockAmount");
            sql.append(" FROM ").append(tempTableTotal).append(sp);
            DbUtil.execute((Context)this.ctx, (String)sql.toString());
        }
        catch (BOSException e) {
            logger.info((Object)e);
            throw e;
        }
        finally {
            ITableManagerFacade iTableManager;
            if (this.tempTableName != null) {
                try {
                    iTableManager = TableManagerFacadeFactory.getLocalInstance((Context)this.ctx);
                    iTableManager.releaseTemporaryTableName(this.tempTableName);
                    iTableManager.dropReleasedTable();
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
            if (tempTableTotal != null) {
                try {
                    iTableManager = TableManagerFacadeFactory.getLocalInstance((Context)this.ctx);
                    iTableManager.releaseTemporaryTableName(tempTableTotal);
                    iTableManager.dropReleasedTable();
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
            this.tempTableName = tempTable;
        }
    }

    private void deleteRptByZero() throws BOSException {
        if (this.noDisplaySendZero.equals("false") && this.noDisplayStockZero.equals("false") && this.onlyDisplaySumLine.equals("false")) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" DELETE FROM ").append(this.tempTableName);
        sql.append(" WHERE 1 = 1 ");
        if (this.noDisplaySendZero.equals("true") && this.noDisplayStockZero.equals("true")) {
            sql.append(" AND (periodSendQty = 0 OR periodStockQty = 0)");
        } else if (this.noDisplaySendZero.equals("false") && this.noDisplayStockZero.equals("true")) {
            sql.append(" AND periodStockQty = 0 ");
        } else if (this.noDisplaySendZero.equals("true") && this.noDisplayStockZero.equals("false")) {
            sql.append(" AND periodSendQty = 0 ");
        } else {
            sql.append(" AND 1 <> 1 ");
        }
        DbUtil.execute((Context)this.ctx, (String)sql.toString());
        if (this.onlyDisplaySumLine.equals("true")) {
            sql.setLength(0);
            sql.append(" DELETE FROM ").append(this.tempTableName);
            sql.append(" WHERE FCUSTOMERID IS NOT NULL ");
            DbUtil.execute((Context)this.ctx, (String)sql.toString());
        }
    }

    public RptParams init(Context ctx, RptParams params) {
        int i;
        Object tempObject;
        int i2;
        int length;
        this.ctx = ctx;
        Object tempObj = params.getObject("companyOrg");
        if (tempObj != null && tempObj instanceof Object[]) {
            Object[] objects = (Object[])tempObj;
            this.companyOrg = ((OrgUnitInfo)objects[0]).getId().toString();
        } else if (tempObj != null && tempObj instanceof Object) {
            this.companyOrg = ((OrgUnitInfo)tempObj).getId().toString();
        }
        tempObj = params.getObject("saleOrg");
        StringBuffer orgsBuf = new StringBuffer();
        if (tempObj != null && tempObj instanceof Object[]) {
            Object[] saleOrgUnitInfos = (Object[])tempObj;
            length = saleOrgUnitInfos.length;
            for (i2 = 0; i2 < length; ++i2) {
                if (saleOrgUnitInfos[i2] == null) continue;
                if (orgsBuf.length() > 0) {
                    orgsBuf.append(",");
                }
                orgsBuf.append("'").append(((OrgUnitInfo)saleOrgUnitInfos[i2]).getId().toString()).append("'");
            }
            this.saleOrg = orgsBuf.length() == 0 ? null : orgsBuf.toString();
        } else if (tempObj != null && tempObj instanceof Object) {
            OrgUnitInfo saleOrgUnitInfo = (OrgUnitInfo)tempObj;
            this.saleOrg = saleOrgUnitInfo.getId().toString();
        }
        orgsBuf.setLength(0);
        tempObj = params.getObject("storageOrg");
        if (tempObj != null && tempObj instanceof Object[]) {
            Object[] storageOrgUnitInfos = (Object[])tempObj;
            length = storageOrgUnitInfos.length;
            for (i2 = 0; i2 < length; ++i2) {
                if (storageOrgUnitInfos[i2] == null) continue;
                if (orgsBuf.length() > 0) {
                    orgsBuf.append(",");
                }
                orgsBuf.append("'").append(((OrgUnitInfo)storageOrgUnitInfos[i2]).getId().toString()).append("'");
            }
            this.storageOrg = orgsBuf.length() == 0 ? null : orgsBuf.toString();
        } else if (tempObj != null && tempObj instanceof OrgUnitInfo) {
            OrgUnitInfo storageOrgUnitInfo = (OrgUnitInfo)tempObj;
            this.storageOrg = storageOrgUnitInfo.getId().toString();
        }
        if (params.getObject("materialFrom") != null) {
            tempObject = params.getObject("materialFrom");
            if (tempObject instanceof String) {
                this.materialFrom = params.getObject("materialFrom").toString();
            } else if (tempObject instanceof MaterialInfo) {
                this.materialFrom = ((MaterialInfo)params.getObject("materialFrom")).getNumber();
            } else if (tempObject instanceof Object[]) {
                Object[] materials = (Object[])tempObject;
                if (materials.length == 1) {
                    this.materialFrom = ((MaterialInfo)materials[0]).getNumber();
                } else {
                    StringBuffer materialNum = new StringBuffer();
                    for (i = 0; i < materials.length; ++i) {
                        materialNum.append("'").append(((MaterialInfo)materials[i]).getNumber()).append("',");
                    }
                    this.materialIn = materialNum.substring(0, materialNum.length() - 1);
                }
            }
        }
        if (params.getObject("materialTo") != null) {
            tempObject = params.getObject("materialTo");
            if (tempObject instanceof String) {
                this.materialTo = params.getObject("materialTo").toString();
            } else if (tempObject instanceof MaterialInfo) {
                this.materialTo = ((MaterialInfo)params.getObject("materialTo")).getNumber();
            }
        }
        if (params.getObject("customerFrom") != null) {
            tempObject = params.getObject("customerFrom");
            if (tempObject instanceof String) {
                this.customerFrom = params.getObject("customerFrom").toString();
            } else if (tempObject instanceof CustomerInfo) {
                this.customerFrom = ((CustomerInfo)params.getObject("customerFrom")).getNumber();
            } else if (tempObject instanceof Object[]) {
                Object[] customers = (Object[])tempObject;
                if (customers.length == 1) {
                    this.customerFrom = ((CustomerInfo)customers[0]).getNumber();
                } else {
                    StringBuffer customerNum = new StringBuffer();
                    for (i = 0; i < customers.length; ++i) {
                        customerNum.append("'").append(((CustomerInfo)customers[i]).getNumber()).append("',");
                    }
                    this.customerIn = customerNum.substring(0, customerNum.length() - 1);
                }
            }
        }
        if (params.getObject("customerTo") != null) {
            tempObject = params.getObject("customerTo");
            if (tempObject instanceof String) {
                this.customerTo = params.getObject("customerTo").toString();
            } else if (tempObject instanceof CustomerInfo) {
                this.customerTo = ((CustomerInfo)params.getObject("customerTo")).getNumber();
            }
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String dateFromStr = sdf.format((Date)params.getObject("dateFrom"));
        String dateToStr = sdf.format((Date)params.getObject("dateTo"));
        this.dateFrom = dateFromStr != null ? "to_date('" + dateFromStr + "')" : null;
        this.dateTo = dateToStr != null ? "to_date('" + dateToStr + "')" : null;
        this.onlyDisplaySumLine = Boolean.toString(params.getBoolean("onlyDisplaySumLine"));
        this.noDisplaySendZero = Boolean.toString(params.getBoolean("noDisplaySendZero"));
        this.noDisplayStockZero = Boolean.toString(params.getBoolean("noDisplayStockZero"));
        return params;
    }

    private static String createTemptable(Context ctx) throws BOSException {
        ITableManagerFacade iTableManager = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
        String tablename = iTableManager.getTableName("com.kingdee.eas.scm.sd.sale.report.app.ConsignVerificationAccountFacadeControllerBean");
        iTableManager.createTempTable(ConsignVerificationAccountFacadeControllerBean.createTableSQL(tablename));
        return tablename;
    }

    private static String createTableSQL(String tablename) {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE ");
        sql.append(tablename);
        sql.append("(");
        sql.append("FBiztypeid VARCHAR(44),");
        sql.append("FTransactiontypeid VARCHAR(44),");
        sql.append("FRITypeID VARCHAR(44),");
        sql.append("FCustomerid VARCHAR(44),");
        sql.append("FCustomerNum NVARCHAR(80),");
        sql.append("FCustomerName NVARCHAR(255),");
        sql.append("FMaterialid VARCHAR(44),");
        sql.append("FMaterialNum NVARCHAR(80),");
        sql.append("FMaterialName NVARCHAR(255),");
        sql.append("Fmodel NVARCHAR(255),");
        sql.append("FAssistPropertyID VARCHAR(44),");
        sql.append("FassistPropertyName NVARCHAR(1000),");
        sql.append("FQtyPrecision NUMERIC(2),");
        sql.append("FBaseUnitID VARCHAR(44),");
        sql.append("FBaseUnitName NVARCHAR(255),");
        sql.append("startPeriodPrice NUMERIC(28,10),");
        sql.append("startPeriodQty NUMERIC(28,10),");
        sql.append("startPeriodAmount NUMERIC(28,10),");
        sql.append("periodSendPrice NUMERIC(28,10),");
        sql.append("periodSendQty NUMERIC(28,10),");
        sql.append("periodSendAmount NUMERIC(28,10),");
        sql.append("thisPeriodPrice NUMERIC(28,10),");
        sql.append("thisPeriodQty NUMERIC(28,10),");
        sql.append("thisPeriodAmount NUMERIC(28,10),");
        sql.append("periodStockPrice NUMERIC(28,10),");
        sql.append("periodStockQty NUMERIC(28,10),");
        sql.append("periodStockAmount NUMERIC(28,10),");
        sql.append("FCompanyOrgUnitId VARCHAR(44),");
        sql.append("FStorageOrgUnitId VARCHAR(44),");
        sql.append("FSaleOrgUnitId VARCHAR(44)");
        sql.append(")");
        return sql.toString();
    }
}

