/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.basedata.assistant.Currency;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.ITableManagerFacade;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.framework.report.util.RptCellFormatter;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.util.KsqlUtil;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sd.sale.report.app.AbstractSaleContractTrackRptFacadeControllerBean;
import com.kingdee.eas.scm.sd.sale.util.SaleUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public class SaleContractTrackRptFacadeControllerBean
extends AbstractSaleContractTrackRptFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sd.sale.report.app.SaleContractTrackRptFacadeControllerBean");
    private String CR = "\r\n";
    public static final String RPTPARAM_STARTDATE = "dateStart";
    public static final String RPTPARAM_ENDDATE = "dateEnd";
    public static final String RPTPARAM_MATERIAL1 = "materialFrom";
    public static final String RPTPARAM_MATERIAL2 = "materialTo";
    public static final String RPTPARAM_CUSTOMER1 = "customerFrom";
    public static final String RPTPARAM_CUSTOMER2 = "customerTo";
    public static final String RPTPARAM_BIZTYPE1 = "bizTypeFrom";
    public static final String RPTPARAM_BIZTYPE2 = "bizTypeTo";
    public static final String RPTPARAM_CONTRACT1 = "contractFrom";
    public static final String RPTPARAM_CONTRACT2 = "contractTo";
    public static final String RPTPARAM_SALEORG1 = "saleOrgFrom";
    public static final String RPTPARAM_SALEORG2 = "saleOrgTo";
    public static final String RPTPARAM_DELIVERYDATE1 = "deliveryDateStart";
    public static final String RPTPARAM_DELIVERYDATE2 = "deliveryDateEnd";
    public static final String RPTPARAM_BASESTATUS = "baseStatus";
    public static final String RPTPARAM_BASESTATUSSC = "baseStatusSC";
    public static final String RPTPARAM_BASESTATUSSCE = "baseStatusSCE";
    public static final String RPTPARAM_SALESPERSON1 = "salesPersonFrom";
    public static final String RPTPARAM_SALESPERSON2 = "salesPersonTo";
    private static final Currency currency = null;
    private String orgUnitTempTableStr = "OrgTempTable";
    private String leafPurChaseOrgUnitStr = "leafPurChaseOrgUnit";
    private String maxLevelStr = "maxLevelStr";
    private static final String resClassName = "com.kingdee.eas.scm.sd.sale.report.SDReportResource";
    private String locLan = "L2";
    private Connection conn = null;

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        this.locLan = this.getLoc(ctx);
        this.dropTable(params.getString("tempTable"), ctx);
        this.dropTable(params.getString("OrgTempTable"), ctx);
        String tempTable = this.getTempTableName(this.getServerResource("RPTTempTable", ctx), ctx);
        String orgUnitTempTable = this.getTempTableName(this.getServerResource("ORGUintTempTable", ctx), ctx);
        params.setString("tempTable", tempTable);
        params.setString("OrgTempTable", orgUnitTempTable);
        this.buildOrgTempTable(ctx, orgUnitTempTable, params);
        DBUtil.createTempTableIndex((Context)ctx, (String)orgUnitTempTable, (String)"fid", (boolean)false);
        try {
            this.conn = EJBFactory.getConnection((Context)ctx);
            DBUtil.AnalyseTable((Context)ctx, (Connection)this.conn, (String)orgUnitTempTable);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Connection)this.conn);
        }
        this.createTempTableAndInsertData(ctx, tempTable, params);
        DBUtil.createTempTableIndex((Context)ctx, (String)tempTable, (String)"fid", (boolean)false);
        try {
            this.conn = EJBFactory.getConnection((Context)ctx);
            DBUtil.AnalyseTable((Context)ctx, (Connection)this.conn, (String)tempTable);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Connection)this.conn);
        }
        String countSql = "select count(FID) cc from " + tempTable;
        RptRowSet rs = this.executeQuery(countSql, null, ctx);
        rs.next();
        int count = rs.getInt(0);
        RptTableHeader header = new RptTableHeader();
        this.setSaleContractRptHead(header, params, ctx);
        RptParams result = new RptParams();
        result.setString("tempTable", tempTable);
        result.setObject("header", (Object)header);
        result.setInt("verticalCount", count);
        result.setString(this.orgUnitTempTableStr, orgUnitTempTable);
        return result;
    }

    private void buildOrgTempTable(Context ctx, String orgTempTable, RptParams params) throws BOSException {
        StringBuffer sqlbf = new StringBuffer();
        sqlbf.append("create table " + orgTempTable + " (");
        sqlbf.append("fid varchar(44),");
        sqlbf.append("fname_");
        sqlbf.append(this.locLan);
        sqlbf.append(" varchar(100),");
        sqlbf.append("fparentid varchar(44),");
        sqlbf.append("flevel int,");
        sqlbf.append("fisleaf int");
        sqlbf.append(")");
        this.executeSQL(ctx, sqlbf.toString());
        Vector<String> v = new Vector<String>();
        int maxLevel = 0;
        Object[] orgs = (Object[])params.getObject(RPTPARAM_SALEORG1);
        String[] sql = new String[orgs.length];
        int n = orgs.length;
        for (int i = 0; i < n; ++i) {
            sqlbf.delete(0, sqlbf.length());
            String fid = ((FullOrgUnitInfo)orgs[i]).get("id").toString();
            Integer flevel = (Integer)((FullOrgUnitInfo)orgs[i]).get("level");
            String fname = (String)((FullOrgUnitInfo)orgs[i]).get("name");
            FullOrgUnitInfo parent = (FullOrgUnitInfo)((FullOrgUnitInfo)orgs[i]).get("parent");
            Boolean isleaf = (Boolean)((FullOrgUnitInfo)orgs[i]).get("isleaf");
            int fisleaf = isleaf != false ? 1 : 0;
            if (fisleaf == 1) {
                v.add(fid);
            }
            if (flevel > maxLevel) {
                maxLevel = flevel;
            }
            sqlbf.append("insert into " + orgTempTable + "(");
            sqlbf.append("fid,fname_");
            sqlbf.append(this.locLan);
            sqlbf.append(",fparentid,flevel,fisleaf) ");
            sqlbf.append("values(");
            sqlbf.append("'" + fid + "',");
            if (fname != null) {
                sqlbf.append("'" + fname + "',");
            } else {
                sqlbf.append("null,");
            }
            if (parent != null) {
                sqlbf.append("'" + parent.getId().toString() + "',");
            } else {
                sqlbf.append("null,");
            }
            sqlbf.append(flevel + ",");
            sqlbf.append(fisleaf + ") ");
            sql[i] = sqlbf.toString();
        }
        this.executeBatchUpdate(ctx, sql);
        params.setObject(this.leafPurChaseOrgUnitStr, (Object)v.toArray());
        params.setObject(this.maxLevelStr, (Object)new Integer(maxLevel));
    }

    private void createTempTableAndInsertData(Context ctx, String tempTable, RptParams params) throws BOSException, EASBizException {
        String sql = this.getCreateTempTable(tempTable, params);
        this.executeSQL(ctx, sql);
        SqlParams sqlParams = new SqlParams();
        String sumTempTable = this.getTempTableName(this.getServerResource("RPTTempTable", ctx), ctx);
        StringBuffer sbLink = new StringBuffer();
        String whereCls = this.getWhereCls(params, sbLink, false);
        String link = sbLink.toString();
        sql = this.getSumTempTableSql(sumTempTable);
        this.executeUpdate(sql, null, ctx);
        String sumTempSql = this.getSumDataSql(params, sumTempTable, whereCls, link);
        this.executeUpdate(sumTempSql, sqlParams, ctx);
        DBUtil.createTempTableIndex((Context)ctx, (String)sumTempTable, (String)"fid", (boolean)false);
        try {
            this.conn = EJBFactory.getConnection((Context)ctx);
            DBUtil.AnalyseTable((Context)ctx, (Connection)this.conn, (String)sumTempTable);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Connection)this.conn);
        }
        sql = this.getAllSQL(params, tempTable, sumTempTable);
        this.executeUpdate(sql, sqlParams, ctx);
        StringBuffer strSql = new StringBuffer();
        strSql.append(" update ").append(tempTable).append(" as TA set (FOrderQty,FOrderTaxAmount) = ").append(" (select FOrderQty, FOrderTaxAmount from (select fseq,FContractNumber,FOrderNumber, sum(FOrderQty) as FOrderQty, sum(FOrderTaxAmount) as FOrderTaxAmount from ").append(tempTable).append(" group by fseq,FContractNumber,FOrderNumber) as TB where TA.fseq=TB.fseq and TA.FContractNumber=TB.FContractNumber and TA.FOrderNumber=TB.FOrderNumber)");
        this.executeUpdate(strSql.toString(), null, ctx);
        strSql.setLength(0);
        strSql.append(" delete from ").append(tempTable).append(" where FID not in (select max(FID) from ").append(tempTable).append(" group by fseq,FContractNumber,FOrderNumber)");
        this.executeUpdate(strSql.toString(), null, ctx);
        sql = this.getTotalRow(tempTable, ctx);
    }

    private String getCreateTempTable(String tempTable, RptParams params) {
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table " + tempTable + "(\r\n");
        sql.append("FID Varchar(44) \r\n");
        sql.append(",FContractNumber Varchar(80) \r\n");
        sql.append(",FSeq INT \r\n");
        sql.append(",FDeliveryDate DateTime \r\n");
        sql.append(",FBaseStatus int \r\n");
        sql.append(",FBIZTYPEID Varchar(44)\r\n");
        sql.append(",FCustomerID Varchar(44)\r\n");
        sql.append(",FSaleOrgUnitID Varchar(44)\r\n");
        sql.append(",FSalePersonID Varchar(44)\r\n");
        sql.append(",FCurrencyID Varchar(44)\r\n");
        sql.append(",FExchangeRate  Decimal(28,10)\r\n");
        sql.append(",FMaterialID Varchar(44)\r\n");
        sql.append(",FUnitID Varchar(44)\r\n");
        sql.append(",FContractQty  Decimal(28,10)\r\n");
        sql.append(",FContractTaxAmount  Decimal(17,4)\r\n");
        sql.append(",FOrderNumber Varchar(80) \r\n");
        sql.append(",FOrderStatus int \r\n");
        sql.append(",FOrderUnitID Varchar(44)\r\n");
        sql.append(",FTotalOrderQty  Decimal(28,10)\r\n");
        sql.append(",FTotalOrderTaxAmount  Decimal(17,4)\r\n");
        sql.append(",FOrderQty  Decimal(28,10)\r\n");
        sql.append(",FOrderTaxAmount  Decimal(17,4)\r\n");
        sql.append(",FNoorderQty  Decimal(17,4)\r\n");
        sql.append(",FNoorderEntryTaxAmount  Decimal(17,4)\r\n");
        sql.append(",FPostTotalQty  Decimal(28,10)\r\n");
        sql.append(",FIssueTotalQty  Decimal(28,10)\r\n");
        sql.append(",FIssueTotalTaxAmount  Decimal(17,4)\r\n");
        sql.append(",FNototalQty  Decimal(28,10)\r\n");
        sql.append(",FUnVcAmount  Decimal(28,10)\r\n");
        sql.append(",FARTotalQty  Decimal(17,4)\r\n");
        sql.append(",FReceivingTotalAmt  Decimal(17,4)\r\n");
        sql.append(",FNototalRecieveAmount  Decimal(17,4)\r\n");
        sql.append(",FArTotalAmt  Decimal(17,4)\r\n");
        sql.append(",FNovoiceQty  Decimal(17,4)\r\n");
        sql.append(",FNovoiceAmount  Decimal(17,4)\r\n");
        sql.append(");\r\n");
        return sql.toString();
    }

    public String splitByComma(String[] status) {
        if (status == null) {
            return "99";
        }
        if (status.length > 0) {
            StringBuffer sb = new StringBuffer();
            sb.append(status[0]);
            for (int i = 1; i < status.length; ++i) {
                sb.append(",");
                sb.append(status[i]);
            }
            return sb.toString();
        }
        return null;
    }

    public String transformByComma(String[] status) {
        if (status == null) {
            return "99";
        }
        if (status.length > 0) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < status.length; ++i) {
                if (i > 0 && i < status.length) {
                    sb.append(",");
                }
                if (status[i].equals("1")) {
                    sb.append(" 10 ");
                    continue;
                }
                if (status[i].equals("2")) {
                    sb.append(" 11 ");
                    continue;
                }
                if (!status[i].equals("4")) continue;
                sb.append(" 12,14");
            }
            return sb.toString();
        }
        return null;
    }

    public String transformByComma2(String[] status) {
        if (status == null) {
            return "99";
        }
        if (status.length > 0) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < status.length; ++i) {
                if (i > 0 && i < status.length) {
                    sb.append(",");
                }
                if (status[i].equals("1")) {
                    sb.append(" 1 ");
                    continue;
                }
                if (status[i].equals("2")) {
                    sb.append(" 2 ");
                    continue;
                }
                if (!status[i].equals("4")) continue;
                sb.append(" 3 ");
            }
            return sb.toString();
        }
        return null;
    }

    private RptTableHeader setSaleContractRptHead(RptTableHeader header, RptParams params, Context ctx) {
        String billNum = this.getServerResource("ContractNumber", ctx);
        String seq = this.getServerResource("Seq", ctx);
        String deliverydate = this.getServerResource("ContractDeliveryDate", ctx);
        String billStatus = this.getServerResource("BillStatus", ctx);
        String customerName = this.getServerResource("CustomerName", ctx);
        String customerNumber = this.getServerResource("CUSTOMERNUMBER", ctx);
        String SaleOrgName = this.getServerResource("SaleOrg", ctx);
        String salePerson = this.getServerResource("SalePerson", ctx);
        String currency = this.getServerResource("Currency", ctx);
        String exchangeRate = this.getServerResource("ExchangRate", ctx);
        String materialNum = this.getServerResource("MaterialNum", ctx);
        String materialName = this.getServerResource("MaterialNam", ctx);
        String materialModel = this.getServerResource("MaterialMod", ctx);
        String baseUnit = this.getServerResource("Unit", ctx);
        String qty = this.getServerResource("ContractQty", ctx);
        String contractEntryTaxAmount = this.getServerResource("ContractEntryTaxAmount", ctx);
        String orderNumber = this.getServerResource("OrderNumber", ctx);
        String orderBillStatus = this.getServerResource("OrderBillStatus", ctx);
        String orderQtyUnit = this.getServerResource("OrderEntryQtyUnit", ctx);
        String totalOrderQty = this.getServerResource("totalOrderEntryQty", ctx);
        String totalOrderEntryTaxAmount = this.getServerResource("totalOrderEntryTaxAmount", ctx);
        String orderQty = this.getServerResource("OrderEntryQty", ctx);
        String orderEntryTaxAmount = this.getServerResource("OrderEntryTaxAmount", ctx);
        String noorderQty = this.getServerResource("NoorderQty", ctx);
        String noorderEntryTaxAmount = this.getServerResource("NoorderEntryTaxAmount", ctx);
        String totalShippingQty = this.getServerResource("TotalShippingQty", ctx);
        String totalPostRequisitionQty = this.getServerResource("TotalPostRequisitionQty", ctx);
        String totalAmout = this.getServerResource("TotalAmout", ctx);
        String nototalQty = this.getServerResource("NototalQty", ctx);
        String unVcAmount = this.getServerResource("UnVcAmount", ctx);
        String totalRecieveQty = this.getServerResource("TotalReceiveQty", ctx);
        String totalRecieveAmount = this.getServerResource("TotalReceiveAmount", ctx);
        String nototalRecieveAmount = this.getServerResource("NototalRecieveAmount", ctx);
        String totalArAmount = this.getServerResource("TotalARAmount", ctx);
        String novoiceQty = this.getServerResource("NovoiceQty", ctx);
        String novoiceAmount = this.getServerResource("NovoiceAmount", ctx);
        String[] cols = new String[]{"ContractNumber", "Seq", "ContractDeliveryDate", "BillStatus", "CustomerName", "CustomerNumber", "SaleOrg", "SalePerson", "Currency", "ExchangRate", "MaterialNum", "MaterialNam", "MaterialMod", "Unit", "ContractQty", "ContractEntryTaxAmount", "totalOrderEntryQty", "totalOrderEntryTaxAmount", "NoorderQty", "NoorderEntryTaxAmount", "TotalShippingQty", "TotalPostRequisitionQty", "TotalAmout", "NototalQty", "unVcAmount", "TotalReceiveAmount", "NototalRecieveAmount", "TotalReceiveQty", "TotalARAmount", "NovoiceQty", "NovoiceAmount", "OrderNumber", "orderBillStatus", "orderEntryQty", "OrderEntryQtyUnit", "OrderEntryTaxAmount", "fid"};
        this.setHeaderColumns(header, cols, params);
        Object[][] labels = new Object[1][cols.length];
        labels[0][this.getIndexForArray((String[])cols, (String)"ContractNumber")] = billNum;
        labels[0][this.getIndexForArray((String[])cols, (String)"Seq")] = seq;
        labels[0][this.getIndexForArray((String[])cols, (String)"ContractDeliveryDate")] = deliverydate;
        labels[0][this.getIndexForArray((String[])cols, (String)"BillStatus")] = billStatus;
        labels[0][this.getIndexForArray((String[])cols, (String)"CustomerName")] = customerName;
        labels[0][this.getIndexForArray((String[])cols, (String)"CustomerNumber")] = customerNumber;
        labels[0][this.getIndexForArray((String[])cols, (String)"SaleOrg")] = SaleOrgName;
        labels[0][this.getIndexForArray((String[])cols, (String)"Currency")] = currency;
        labels[0][this.getIndexForArray((String[])cols, (String)"ExchangRate")] = exchangeRate;
        labels[0][this.getIndexForArray((String[])cols, (String)"MaterialNum")] = materialNum;
        labels[0][this.getIndexForArray((String[])cols, (String)"MaterialNam")] = materialName;
        labels[0][this.getIndexForArray((String[])cols, (String)"MaterialMod")] = materialModel;
        labels[0][this.getIndexForArray((String[])cols, (String)"Unit")] = baseUnit;
        labels[0][this.getIndexForArray((String[])cols, (String)"ContractQty")] = qty;
        labels[0][this.getIndexForArray((String[])cols, (String)"ContractEntryTaxAmount")] = contractEntryTaxAmount;
        labels[0][this.getIndexForArray((String[])cols, (String)"totalOrderEntryQty")] = totalOrderQty;
        labels[0][this.getIndexForArray((String[])cols, (String)"totalOrderEntryTaxAmount")] = totalOrderEntryTaxAmount;
        labels[0][this.getIndexForArray((String[])cols, (String)"NoorderQty")] = noorderQty;
        labels[0][this.getIndexForArray((String[])cols, (String)"NoorderEntryTaxAmount")] = noorderEntryTaxAmount;
        labels[0][this.getIndexForArray((String[])cols, (String)"TotalShippingQty")] = totalShippingQty;
        labels[0][this.getIndexForArray((String[])cols, (String)"TotalPostRequisitionQty")] = totalPostRequisitionQty;
        labels[0][this.getIndexForArray((String[])cols, (String)"NototalQty")] = nototalQty;
        labels[0][this.getIndexForArray((String[])cols, (String)"unVcAmount")] = unVcAmount;
        labels[0][this.getIndexForArray((String[])cols, (String)"TotalReceiveAmount")] = totalRecieveAmount;
        labels[0][this.getIndexForArray((String[])cols, (String)"NototalRecieveAmount")] = nototalRecieveAmount;
        labels[0][this.getIndexForArray((String[])cols, (String)"TotalReceiveQty")] = totalRecieveQty;
        labels[0][this.getIndexForArray((String[])cols, (String)"TotalARAmount")] = totalArAmount;
        labels[0][this.getIndexForArray((String[])cols, (String)"NovoiceQty")] = novoiceQty;
        labels[0][this.getIndexForArray((String[])cols, (String)"NovoiceAmount")] = novoiceAmount;
        labels[0][this.getIndexForArray((String[])cols, (String)"OrderNumber")] = orderNumber;
        labels[0][this.getIndexForArray((String[])cols, (String)"orderBillStatus")] = orderBillStatus;
        labels[0][this.getIndexForArray((String[])cols, (String)"orderEntryQty")] = orderQty;
        labels[0][this.getIndexForArray((String[])cols, (String)"OrderEntryQtyUnit")] = orderQtyUnit;
        labels[0][this.getIndexForArray((String[])cols, (String)"OrderEntryTaxAmount")] = orderEntryTaxAmount;
        labels[0][this.getIndexForArray((String[])cols, (String)"fid")] = "ID";
        labels[0][this.getIndexForArray((String[])cols, (String)"SalePerson")] = salePerson;
        labels[0][this.getIndexForArray((String[])cols, (String)"TotalAmout")] = totalAmout;
        header.setLabels(labels, true);
        return header;
    }

    private void setHeaderColumns(RptTableHeader header, String[] columns, RptParams params) {
        String dateFormat = RptCellFormatter.getDateFormat((String)"yyyy-MM-dd");
        String prcFormat = SaleUtil.getFormatPattern(4, true);
        String rateFormat = SaleUtil.getFormatPattern(4, true);
        RptTableColumn col = null;
        int c = columns.length;
        for (int i = 0; i < c; ++i) {
            col = new RptTableColumn(columns[i]);
            col.setWidth(-1);
            if (i == this.getIndexForArray(columns, "ContractDeliveryDate")) {
                col.setFormatPattern(dateFormat);
            } else if (i == this.getIndexForArray(columns, "BillStatus") || i == this.getIndexForArray(columns, "orderBillStatus")) {
                col.setAligment(1);
            } else if (i == this.getIndexForArray(columns, "ExchangRate")) {
                col.setWidth(120);
                col.setAligment(2);
                col.setFormatPattern(rateFormat);
            } else if (i >= this.getIndexForArray(columns, "ContractQty") && i <= this.getIndexForArray(columns, "NovoiceAmount") || i == this.getIndexForArray(columns, "orderEntryQty") || i == this.getIndexForArray(columns, "OrderEntryTaxAmount")) {
                col.setWidth(120);
                col.setAligment(2);
                col.setFormatPattern(prcFormat);
            } else if (i == this.getIndexForArray(columns, "fid")) {
                col.setHided(true);
            }
            header.addColumn(col);
        }
    }

    private void executeSQL(Context ctx, String sql) throws BOSException {
        if (sql != null && sql.trim().length() > 0) {
            this.executeUpdate(sql, null, ctx);
        }
    }

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException {
        this.locLan = this.getLoc(ctx);
        RptRowSet rs = null;
        rs = KsqlUtil.isSQLServer((Context)ctx) ? this.executeQuery(this.querySql(params, ctx) + " order by FContractNumber desc,FSeq,CUSTOMER_NAME,MATERIAL_NAME,QTY,ForderNumber", null, from, len, ctx) : this.executeQuery(this.querySql(params, ctx) + " order by FContractNumber,FSeq,CUSTOMER_NAME,MATERIAL_NAME,QTY,ForderNumber", null, from, len, ctx);
        RptParams pp = new RptParams();
        pp.setObject("rowset", (Object)rs);
        return pp;
    }

    private String querySql(RptParams params, Context ctx) {
        StringBuffer sql = new StringBuffer();
        String tempTable = params.getString("tempTable");
        String orgUnitTempTable = params.getString("OrgTempTable");
        sql.append("SELECT ");
        sql.append(" FcontractNumber,FSeq, FDeliveryDate, FBaseStatus");
        sql.append(",CUSTOMER_NAME,CUSTOMER_NUMBER, SALEORG_NAME, SALEPERSON_NAME, CURRENCY_NAME, FExchangeRate");
        sql.append(",MATERIAL_NUMBER, MATERIAL_NAME,MATERIAL_MODEL, UNIT_NAME");
        sql.append(",ISNULL(QTY,0) QTY, ISNULL(TaxAmount,0) TaxAmount, ISNULL(totalOrderQty,0) totalOrderQty, ISNULL(totalOrderTaxAmount,0) totalOrderTaxAmount ");
        sql.append(",ISNULL(FNoorderQty,0) FNoorderQty,ISNULL(FNoorderEntryTaxAmount,0) FNoorderEntryTaxAmount, ISNULL(FpostTotalQty,0) FpostTotalQty, ISNULL(FissueTotalQty,0) FissueTotalQty,ISNULL(FIssueTotalTaxAmount,0) FIssueTotalTaxAmount ");
        sql.append(",ISNULL(FNototalQty,0) FNototalQty,ISNULL(FUnVcAmount,0) FUnVcAmount, ISNULL(FReceivingTotalAmt,0) FReceivingTotalAmt, ISNULL(FNototalRecieveAmount,0) FNototalRecieveAmount, ISNULL(FarTotalQty,0) FarTotalQty ");
        sql.append(",ISNULL(FArTotalAmt,0) FArTotalAmt,ISNULL(FNovoiceQty,0) FNovoiceQty, ISNULL(FNovoiceAmount,0) FNovoiceAmount ");
        sql.append(",ForderNumber,FOrderStatus,ISNULL(orderQTY,0) orderQTY ");
        sql.append(",FName_").append(this.locLan).append(",ISNULL(ForderTaxAmount,0) ForderTaxAmount,FID");
        sql.append(" FROM (");
        sql.append(" SELECT temp1.FcontractNumber,temp1.FSeq,temp1.FDeliveryDate,temp1.FBaseStatus");
        sql.append(", CUSTOMER.FName_").append(this.locLan).append(" AS CUSTOMER_NAME, CUSTOMER.FNUMBER AS CUSTOMER_NUMBER ");
        sql.append("\r\n ,org.fname_").append(this.locLan);
        sql.append(" AS SALEORG_NAME");
        sql.append("\r\n ,person.fname_").append(this.locLan);
        sql.append(" AS SALEPERSON_NAME");
        sql.append(", CURRENCY.FName_").append(this.locLan).append(" AS CURRENCY_NAME");
        sql.append(",temp1.FExchangeRate");
        sql.append(",mat.FNumber AS MATERIAL_NUMBER");
        sql.append(",mat.FName_").append(this.locLan);
        sql.append(" AS MATERIAL_NAME,mat.FModel AS MATERIAL_MODEL");
        sql.append("\r\n ,UNIT.FName_").append(this.locLan);
        sql.append(" AS UNIT_NAME");
        sql.append("\r\n ,temp1.FcontractQty QTY,temp1.FcontractTaxAmount TaxAmount");
        sql.append(",temp1.FTotalOrderQty totalOrderQty,temp1.FTotalOrderTaxAmount totalOrderTaxAmount");
        sql.append(",temp1.FNoorderQty,temp1.FNoorderEntryTaxAmount,temp1.FpostTotalQty,temp1.FissueTotalQty,temp1.FIssueTotalTaxAmount,temp1.FNototalQty,temp1.FUnVcAmount");
        sql.append(",temp1.FReceivingTotalAmt,temp1.FNototalRecieveAmount,temp1.FarTotalQty,temp1.FArTotalAmt,temp1.FNovoiceQty,temp1.FNovoiceAmount");
        sql.append(",temp1.ForderNumber,temp1.FOrderStatus,temp1.ForderQty orderQTY");
        sql.append(",UNIT2.FName_").append(this.locLan).append(",temp1.ForderTaxAmount");
        sql.append(",temp1.FID ");
        sql.append(" FROM  " + tempTable + " temp1 \r\n INNER JOIN ");
        sql.append(orgUnitTempTable).append(" org ON temp1.FSaleOrgUnitID = org.FID ");
        sql.append("\r\n INNER JOIN T_BD_Person person on temp1.FSalePersonID = person.FID ");
        sql.append("\r\n INNER JOIN T_BD_Currency CURRENCY on temp1.FCurrencyID = CURRENCY.FID ");
        sql.append("\r\n LEFT OUTER JOIN T_BD_Material mat on temp1.FMaterialID = mat.FID ");
        sql.append(" \r\n INNER JOIN T_BD_Customer AS CUSTOMER ON temp1.FCustomerID = CUSTOMER.FID ");
        sql.append("\r\n LEFT OUTER JOIN T_BD_MeasureUnit AS UNIT ON temp1.FUnitID = UNIT.FID ");
        sql.append("\r\n LEFT OUTER JOIN T_BD_MeasureUnit AS UNIT2 ON temp1.ForderUnitID = UNIT2.FID ");
        sql.append("  UNION ALL  ");
        sql.append(" SELECT  ").append(this.CR);
        sql.append("'\u3000\u3000").append(this.getServerResource("SUB_STRING", ctx)).append("' AS  FcontractNumber,");
        sql.append(" -1 AS FSeq,null AS FDeliveryDate,-9 AS FBaseStatus,");
        sql.append(" null AS CUSTOMER_NAME, null as CUSTOMER_NUMBER, null AS  SALEORG_NAME,null AS  SALEPERSON_NAME, null AS CURRENCY_NAME,-1 AS FExchangeRate,");
        sql.append(" null AS MATERIAL_NUMBER,");
        sql.append(" null AS MATERIAL_NAME,null AS MATERIAL_MODEL,");
        sql.append(" null AS UNIT_NAME,");
        sql.append("sum(temp2.FcontractQty) QTY,sum(temp2.FcontractTaxAmount) TaxAmount");
        sql.append(",sum(temp2.FTotalOrderQty) totalOrderQty,sum(temp2.FTotalOrderTaxAmount) totalOrderTaxAmount");
        sql.append(",sum(temp2.FNoorderQty) FNoorderQty,sum(temp2.FNoorderEntryTaxAmount) as FNoorderEntryTaxAmount");
        sql.append(",sum(temp2.FpostTotalQty) AS FpostTotalQty,sum(temp2.FissueTotalQty) AS FissueTotalQty,sum(temp2.FIssueTotalTaxAmount) AS FIssueTotalTaxAmount");
        sql.append(",sum(temp2.FNototalQty) AS FNototalQty,sum(temp2.FUnVcAmount) AS FUnVcAmount");
        sql.append(",sum(temp2.FReceivingTotalAmt) AS FReceivingTotalAmt,sum(temp2.FNototalRecieveAmount) AS FNototalRecieveAmount");
        sql.append(",sum(temp2.FarTotalQty) AS FarTotalQty ,sum(temp2.FArTotalAmt) AS FArTotalAmt");
        sql.append(",sum(temp2.FNovoiceQty) AS FNovoiceQty,sum(temp2.FNovoiceAmount) AS FNovoiceAmount");
        sql.append(",null AS ForderNumber,-9 AS FOrderStatus,sum(temp2.ForderQty) AS orderQTY");
        sql.append(",null AS FName_").append(this.locLan).append(",sum(temp2.ForderTaxAmount) AS ForderTaxAmount");
        sql.append(",MAX(FID) AS FID ");
        sql.append(" FROM  " + tempTable + " temp2 WHERE temp2.FSALEORGUNITID IS NULL ");
        sql.append(") temp ");
        return sql.toString();
    }

    protected IRowSet _getIdList(Context ctx, RptParams param) throws BOSException {
        StringBuffer rsList = new StringBuffer();
        rsList.append("select fid from (");
        rsList.append(" select s.fid,s.FContractNumber,s.FSeq,s.FCustomerID,s.FSaleOrgUnitID,s.FMaterialID from ");
        rsList.append(param.getString("tempTable"));
        rsList.append(" s inner join T_BD_Material m on s.FMaterialID=m.FID ");
        rsList.append(" inner join ").append(param.getString("OrgTempTable"));
        rsList.append(" org ").append(" on s.FSaleOrgUnitID = org.FID ");
        rsList.append(" union all ");
        rsList.append(" select  s1.fid ,s1.FContractNumber,s1.FSeq,s1.FCustomerID,s1.FSaleOrgUnitID,s1.FMaterialID from ").append(param.getString("tempTable"));
        rsList.append(" s1  where s1.fsaleorgunitid is null) temp ");
        if (KsqlUtil.isSQLServer((Context)ctx)) {
            rsList.append(" order by temp.FContractNumber desc,temp.FSeq,temp.FCustomerID,temp.FSaleOrgUnitID,temp.FMaterialID ");
        } else {
            rsList.append(" order by temp.FContractNumber ,temp.FSeq,temp.FCustomerID,temp.FSaleOrgUnitID,temp.FMaterialID ");
        }
        return DbUtil.executeQuery((Context)ctx, (String)rsList.toString());
    }

    public RptParams getDataForIdList(Context ctx, List idList, RptParams params) throws BOSException, EASBizException {
        return this.getDatas(ctx, params, idList, false);
    }

    private RptParams getDatas(Context ctx, RptParams params, List idList, boolean first) throws BOSException {
        String subWhere;
        if (first) {
            subWhere = " ";
        } else {
            StringBuffer fid = new StringBuffer(" where temp.FId IN (  '").append(idList.get(0).toString()).append("'");
            int n = idList.size();
            for (int i = 1; i < n; ++i) {
                fid.append(", '").append(idList.get(i).toString()).append("'");
            }
            fid.append(" )  order by FContractNumber desc,FSeq,CUSTOMER_NAME,MATERIAL_NAME ");
            subWhere = fid.toString();
        }
        StringBuffer sql = new StringBuffer();
        sql.append(this.querySql(params, ctx));
        sql.append(subWhere);
        RptRowSet rs = this.executeQuery(sql.toString(), null, ctx);
        RptParams pp = new RptParams();
        pp.setObject("rowset", (Object)rs);
        return pp;
    }

    public String getServerResource(String key, Context ctx) {
        return SCMUtils.getResource((String)resClassName, (String)key, (Context)ctx);
    }

    private String getAllSQL(RptParams params, String tempTable, String sumTempTable) throws EASBizException, BOSException {
        StringBuffer sb = new StringBuffer();
        StringBuffer sbLink = new StringBuffer();
        String whereCls = this.getWhereCls(params, sbLink, true);
        String link = sbLink.toString();
        sb.append("INSERT INTO ").append(tempTable).append(this.CR).append(" SELECT Newbosid('88888888'),").append(this.CR).append("   sc.fnumber,").append(this.CR).append("   sce.fseq,").append(this.CR).append("   sce.fdeliverydate,").append(this.CR).append("   sc.fbasestatus,").append(this.CR).append("   sc.fbiztypeid,").append(this.CR).append("   sc.fcustomerid,").append(this.CR).append("   org.fid,").append(this.CR).append("   person.fid,").append(this.CR).append("   sc.fcurrencyid,").append(this.CR).append("   sc.fexchangerate,").append(this.CR).append("   sce.fmaterialid,").append(this.CR).append("   sce.funitid,").append(this.CR).append("   sce.fqty,").append(this.CR).append("   round(sce.ftaxamount,cc.FPrecision) famount,").append(this.CR).append("   so.fnumber,").append(this.CR).append("   so.fbasestatus,").append(this.CR).append("   soe.funitid,").append(this.CR).append("   datafrom.ftotalorderqty ftotalorderqty,").append(this.CR).append("   datafrom.ftotalorderamount ftotalorderamount,").append(this.CR).append("   soe.fqty ftotalqty,").append(this.CR).append("   soe.ftaxamount ftaxamount,").append(this.CR).append("   (sce.fqty-ISNULL(datafrom.ftotalorderqty,0)) fnoqty,").append(this.CR).append("   (round(sce.ftaxamount,cc.FPrecision)-ISNULL(datafrom.ftotalorderamount,0)) fnotaxamount,").append(this.CR).append("   datafrom.ftotalsaleqty,").append(this.CR).append("   datafrom.ftotalissueqty,").append(this.CR).append("   datafrom.FIssueTotalTaxAmount,").append(this.CR).append("   (sce.fqty-ISNULL(datafrom.ftotalissueqty,0)) fnototalissueqty,").append(this.CR).append("   datafrom.funvcamount funvcamount,").append(this.CR).append("   datafrom.ftotalotherqty,").append(this.CR).append("   datafrom.ftotalamount, ").append(this.CR).append("   (round(sce.ftaxamount,cc.FPrecision)-ISNULL(datafrom.ftotalamount,0)-ISNULL(datafrom.funvcamount,0)) fnototalamount, ").append(this.CR).append("   datafrom.FArTotalAmt ,").append(this.CR).append("   (sce.fqty-ISNULL(datafrom.ftotalotherqty,0)) fnototalotherqty ,").append(this.CR).append("   (round(sce.ftaxamount,cc.FPrecision)-ISNULL(datafrom.FArTotalAmt,0)) fnoArToalAmt ").append(this.CR).append("FROM  t_sd_salecontract sc ").append(this.CR).append("   INNER JOIN t_sd_salecontractentry sce ").append(this.CR).append("       ON sc.fid = sce.fparentid ").append(this.CR).append("  INNER JOIN T_BD_Person person ON person.FID = sc.fsalepersonId ").append(this.CR).append("   INNER JOIN T_BD_Currency cc ON cc.FID = sc.fcurrencyid ").append(this.CR).append("   INNER JOIN ").append(params.getString("OrgTempTable")).append("   org ").append(this.CR).append("       ON sc.fsaleorgunitid = org.fid ").append(this.CR).append("   LEFT OUTER JOIN t_sd_saleorderentry soe ").append(this.CR).append("       ON (soe.fsourcebillid = sc.fid ").append(this.CR).append("       AND soe.fsourcebillentryid = sce.fid) ").append(this.CR).append("   LEFT OUTER JOIN t_sd_saleorder so ").append(this.CR).append("       ON soe.fparentid = so.fid ").append(this.CR).append(link).append(this.CR).append("   LEFT OUTER JOIN ").append(sumTempTable).append(" datafrom ").append(this.CR).append("   ON datafrom.fid = sc.fid ").append(this.CR).append("   AND datafrom.fentryid = sce.fid ").append(this.CR).append("WHERE ").append(whereCls);
        sb.append(" and (so.FBaseStatus in(2,1,4,6,7,-2) ");
        sb.append(" or so.FBaseStatus is null) ");
        return sb.toString();
    }

    private String getTotalRow(String tempTable, Context ctx) throws EASBizException, BOSException {
        String temptablename = SaleContractTrackRptFacadeControllerBean.createTemptable(ctx);
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ");
        sql.append(temptablename).append(this.CR);
        sql.append(" (FSEQ,FContractNumber");
        sql.append(",FContractQty");
        sql.append(",FContractTaxAmount ");
        sql.append(",FTotalOrderQty");
        sql.append(",FTotalOrderTaxAmount");
        sql.append(",FNoorderQty ");
        sql.append(",FNoorderEntryTaxAmount");
        sql.append(",FPostTotalQty");
        sql.append(",FIssueTotalQty ");
        sql.append(",FIssueTotalTaxAmount ");
        sql.append(",FNototalQty  ");
        sql.append(",FUnVcAmount");
        sql.append(",FARTotalQty ");
        sql.append(",FReceivingTotalAmt ");
        sql.append(",FNototalRecieveAmount");
        sql.append(",FArTotalAmt ");
        sql.append(",FNovoiceQty ");
        sql.append(",FNovoiceAmount ");
        sql.append(",FOrderQty ");
        sql.append(",FOrderTaxAmount) ");
        sql.append(" SELECT ").append(this.CR);
        sql.append(" FSEQ,FContractNumber");
        sql.append(",FContractQty");
        sql.append(",FContractTaxAmount ");
        sql.append(",FTotalOrderQty");
        sql.append(",FTotalOrderTaxAmount");
        sql.append(",FNoorderQty ");
        sql.append(",FNoorderEntryTaxAmount");
        sql.append(",FPostTotalQty");
        sql.append(",FIssueTotalQty ");
        sql.append(",FIssueTotalTaxAmount ");
        sql.append(",FNototalQty  ");
        sql.append(",FUnVcAmount");
        sql.append(",FARTotalQty ");
        sql.append(",FReceivingTotalAmt ");
        sql.append(",FNototalRecieveAmount");
        sql.append(",FArTotalAmt ");
        sql.append(",FNovoiceQty ");
        sql.append(",FNovoiceAmount ");
        sql.append(",sum(FOrderQty) ");
        sql.append(",sum(FOrderTaxAmount) ");
        sql.append(" FROM ").append(tempTable).append(this.CR);
        sql.append(" group by fseq,FContractNumber");
        sql.append(",FContractQty");
        sql.append(",FContractTaxAmount ");
        sql.append(",FTotalOrderQty");
        sql.append(",FTotalOrderTaxAmount");
        sql.append(",FNoorderQty ");
        sql.append(",FNoorderEntryTaxAmount");
        sql.append(",FPostTotalQty");
        sql.append(",FIssueTotalQty ");
        sql.append(",FIssueTotalTaxAmount ");
        sql.append(",FNototalQty  ");
        sql.append(",FUnVcAmount");
        sql.append(",FARTotalQty ");
        sql.append(",FReceivingTotalAmt ");
        sql.append(",FNototalRecieveAmount");
        sql.append(",FArTotalAmt ");
        sql.append(",FNovoiceQty ");
        sql.append(",FNovoiceAmount");
        this.executeUpdate(sql.toString(), null, ctx);
        sql.setLength(0);
        sql.append("INSERT INTO ");
        sql.append(temptablename).append(this.CR);
        sql.append(" (FID,FContractNumber");
        sql.append(",FContractQty");
        sql.append(",FContractTaxAmount ");
        sql.append(",FTotalOrderQty");
        sql.append(",FTotalOrderTaxAmount");
        sql.append(",FNoorderQty ");
        sql.append(",FNoorderEntryTaxAmount");
        sql.append(",FPostTotalQty");
        sql.append(",FIssueTotalQty ");
        sql.append(",FIssueTotalTaxAmount ");
        sql.append(",FNototalQty  ");
        sql.append(",FUnVcAmount");
        sql.append(",FARTotalQty ");
        sql.append(",FReceivingTotalAmt ");
        sql.append(",FNototalRecieveAmount");
        sql.append(",FArTotalAmt ");
        sql.append(",FNovoiceQty ");
        sql.append(",FNovoiceAmount ");
        sql.append(",FOrderQty ");
        sql.append(",FOrderTaxAmount) ");
        sql.append(" SELECT '-1',").append(this.CR);
        sql.append("'\u3000\u3000").append(this.getServerResource("SUB_STRING", ctx)).append("'");
        sql.append(",sum(FContractQty)");
        sql.append(",sum(FContractTaxAmount) ");
        sql.append(",sum(FTotalOrderQty) ");
        sql.append(",sum(FTotalOrderTaxAmount)");
        sql.append(",sum(FNoorderQty) ");
        sql.append(",sum(FNoorderEntryTaxAmount)");
        sql.append(",sum(FPostTotalQty) ");
        sql.append(",sum(FIssueTotalQty) ");
        sql.append(",sum(FIssueTotalTaxAmount) ");
        sql.append(",sum(FNototalQty)  ");
        sql.append(",sum(FUnVcAmount)");
        sql.append(",sum(FARTotalQty) ");
        sql.append(",sum(FReceivingTotalAmt) ");
        sql.append(",sum(FNototalRecieveAmount)");
        sql.append(",sum(FArTotalAmt) ");
        sql.append(",sum(FNovoiceQty) ");
        sql.append(",sum(FNovoiceAmount)");
        sql.append(",sum(FOrderQty) ");
        sql.append(",sum(FOrderTaxAmount) ");
        sql.append(" FROM ").append(temptablename).append(this.CR);
        sql.append(" group by fseq,FContractNumber");
        this.executeUpdate(sql.toString(), null, ctx);
        sql.setLength(0);
        sql.append("INSERT INTO ");
        sql.append(tempTable).append(this.CR);
        sql.append(" (FID,FContractNumber");
        sql.append(",FContractQty");
        sql.append(",FContractTaxAmount ");
        sql.append(",FTotalOrderQty");
        sql.append(",FTotalOrderTaxAmount");
        sql.append(",FNoorderQty ");
        sql.append(",FNoorderEntryTaxAmount");
        sql.append(",FPostTotalQty");
        sql.append(",FIssueTotalQty ");
        sql.append(",FIssueTotalTaxAmount ");
        sql.append(",FNototalQty  ");
        sql.append(",FUnVcAmount");
        sql.append(",FARTotalQty ");
        sql.append(",FReceivingTotalAmt ");
        sql.append(",FNototalRecieveAmount");
        sql.append(",FArTotalAmt ");
        sql.append(",FNovoiceQty ");
        sql.append(",FNovoiceAmount ");
        sql.append(",FOrderQty ");
        sql.append(",FOrderTaxAmount) ");
        sql.append(" SELECT '-1' AS FID ").append(this.CR);
        sql.append(",'\u3000\u3000").append(this.getServerResource("SUB_STRING", ctx)).append("' AS FContractNumber");
        sql.append(",sum(temp.FcontractQty) QTY,sum(temp.FcontractTaxAmount) TaxAmount");
        sql.append(",sum(temp.FTotalOrderQty) totalOrderQty,sum(temp.FTotalOrderTaxAmount) totalOrderTaxAmount");
        sql.append(",sum(temp.FNoorderQty) FNoorderQty,sum(temp.FNoorderEntryTaxAmount) as FNoorderEntryTaxAmount");
        sql.append(",sum(temp.FpostTotalQty) AS FpostTotalQty,sum(temp.FissueTotalQty) AS FissueTotalQty,sum(temp.FIssueTotalTaxAmount) AS FIssueTotalTaxAmount");
        sql.append(",sum(temp.FNototalQty) AS FNototalQty,sum(temp.FUnVcAmount) AS FUnVcAmount");
        sql.append(",sum(temp.FarTotalQty) AS FarTotalQty,sum(temp.FReceivingTotalAmt) AS FReceivingTotalAmt ");
        sql.append(",sum(temp.FNototalRecieveAmount) AS FNototalRecieveAmount,sum(temp.FArTotalAmt) AS FArTotalAmt");
        sql.append(",sum(temp.FNovoiceQty) AS FNovoiceQty,sum(temp.FNovoiceAmount) AS FNovoiceAmount");
        sql.append(",sum(temp.ForderQty) AS orderQTY");
        sql.append(",sum(temp.ForderTaxAmount) AS ForderTaxAmount");
        sql.append(" FROM  " + temptablename + " temp WHERE temp.FID = '-1' ");
        this.executeUpdate(sql.toString(), null, ctx);
        return null;
    }

    private static String createTemptable(Context ctx) throws BOSException {
        ITableManagerFacade iTableManager = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
        String tablename = iTableManager.getTableName("com.kingdee.eas.scm.sd.sale.report.app.SaleContractTrackRptFacadeControllerBean");
        iTableManager.createTempTable(SaleContractTrackRptFacadeControllerBean.createTableSQL(tablename));
        return tablename;
    }

    private static String createTableSQL(String tablename) {
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table " + tablename + "(\r\n");
        sql.append("FID Varchar(44) \r\n");
        sql.append(",FContractNumber Varchar(80) \r\n");
        sql.append(",FSeq INT \r\n");
        sql.append(",FDeliveryDate DateTime \r\n");
        sql.append(",FBaseStatus int \r\n");
        sql.append(",FBIZTYPEID Varchar(44)\r\n");
        sql.append(",FCustomerID Varchar(44)\r\n");
        sql.append(",FSaleOrgUnitID Varchar(44)\r\n");
        sql.append(",FSalePersonID Varchar(44)\r\n");
        sql.append(",FCurrencyID Varchar(44)\r\n");
        sql.append(",FExchangeRate  Decimal(28,10)\r\n");
        sql.append(",FMaterialID Varchar(44)\r\n");
        sql.append(",FUnitID Varchar(44)\r\n");
        sql.append(",FContractQty  Decimal(28,10)\r\n");
        sql.append(",FContractTaxAmount  Decimal(17,4)\r\n");
        sql.append(",FOrderNumber Varchar(80) \r\n");
        sql.append(",FOrderStatus int \r\n");
        sql.append(",FOrderUnitID Varchar(44)\r\n");
        sql.append(",FTotalOrderQty  Decimal(28,10)\r\n");
        sql.append(",FTotalOrderTaxAmount  Decimal(17,4)\r\n");
        sql.append(",FOrderQty  Decimal(28,10)\r\n");
        sql.append(",FOrderTaxAmount  Decimal(17,4)\r\n");
        sql.append(",FNoorderQty  Decimal(17,4)\r\n");
        sql.append(",FNoorderEntryTaxAmount  Decimal(17,4)\r\n");
        sql.append(",FPostTotalQty  Decimal(28,10)\r\n");
        sql.append(",FIssueTotalQty  Decimal(28,10)\r\n");
        sql.append(",FIssueTotalTaxAmount  Decimal(28,10)\r\n");
        sql.append(",FNototalQty  Decimal(28,10)\r\n");
        sql.append(",FUnVcAmount  Decimal(28,10)\r\n");
        sql.append(",FARTotalQty  Decimal(17,4)\r\n");
        sql.append(",FReceivingTotalAmt  Decimal(17,4)\r\n");
        sql.append(",FNototalRecieveAmount  Decimal(17,4)\r\n");
        sql.append(",FArTotalAmt  Decimal(17,4)\r\n");
        sql.append(",FNovoiceQty  Decimal(17,4)\r\n");
        sql.append(",FNovoiceAmount  Decimal(17,4)\r\n");
        sql.append(");\r\n");
        return sql.toString();
    }

    private String getSumDataSql(RptParams params, String tempTable, String whereCls, String link) throws EASBizException, BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO ").append(tempTable).append(this.CR).append(" SELECT fid,fentryid,").append(this.CR).append("        Sum(ftotalorderqty) ftotalorderqty,").append(this.CR).append("        Sum(ftotalorderamount) ftotalorderamount,").append(this.CR).append("        Sum(funvcamount) funvcamount,").append(this.CR).append("        Sum(ftotalsaleqty) ftotalsaleqty,").append(this.CR).append("        Sum(ftotalissueqty) ftotalissueqty,").append(this.CR).append("        Sum(ftotalotherqty) ftotalotherqty,").append(this.CR).append("        Sum(ftotalamount) ftotalamount,").append(this.CR).append("        Sum(FIssueTotalTaxAmount) FIssueTotalTaxAmount,").append(this.CR).append("        Sum(FArTotalAmt) FArTotalAmt").append(this.CR).append("FROM (").append(this.CR).append(this.getSQLOnShiping(params, whereCls, link)).append(this.CR).append(" UNION ALL ").append(this.CR).append(this.getSQLOnIssuing(params, whereCls, link)).append(this.CR).append(" UNION ALL ").append(this.CR).append(this.getSQLOnReceiving(params, whereCls, link)).append(this.CR).append(" UNION ALL ").append(this.CR).append(this.getSQLOnReceivingBill(params, whereCls, link)).append(this.CR).append(" ) src ").append("GROUP BY fid,").append(this.CR).append("         fentryid");
        return sb.toString();
    }

    private String getSQLOnShiping(RptParams params, String whereCls, String link) {
        StringBuffer sb = new StringBuffer();
        String[] baseStatus = (String[])params.getObject(RPTPARAM_BASESTATUS);
        String closeStatus = "";
        if (baseStatus != null) {
            int length = baseStatus.length;
            for (int i = 0; i < length; ++i) {
                if (baseStatus[i].indexOf("4") == -1) continue;
                closeStatus = ",6,7";
                break;
            }
        }
        sb.append("               SELECT   sc.fid,").append(this.CR).append("                        sce.fid fentryid,").append(this.CR).append("                        0 ftotalorderqty,").append(this.CR).append("                        0 ftotalorderamount,").append(this.CR).append("                        0 funvcamount,").append(this.CR).append("                        sum(ISNULL(CASE ").append(this.CR).append("                              WHEN sce.funitid = pqe.funitid or sce.funitid is null THEN pqe.fqty ").append(this.CR).append("                              ELSE (pqe.fbaseqty / unit.fbaseconvsrate) ").append(this.CR).append("                            END,0)) ftotalsaleqty,").append(this.CR).append("                        0 ftotalissueqty,").append(this.CR).append("                        0 ftotalotherqty,").append(this.CR).append("                        0 ftotalamount,0 FIssueTotalTaxAmount,0 FArTotalAmt ").append(this.CR).append("               FROM     t_sd_salecontractentry sce ").append(this.CR).append("                        INNER JOIN t_sd_salecontract sc ").append(this.CR).append("                                ON sc.fid = sce.fparentid ").append(this.CR).append("                        INNER JOIN ").append(params.getString("OrgTempTable")).append("                        org ").append(this.CR).append("                                ON sc.fsaleorgunitid = org.fid ").append(this.CR).append("                        INNER JOIN t_sd_saleorderentry soe ").append(this.CR).append("                                ON (soe.fsourcebillid = sc.fid ").append(this.CR).append("                                    AND soe.fsourcebillentryid = sce.fid) ").append(this.CR).append("                        INNER JOIN t_sd_saleorder so ").append(this.CR).append("                                ON soe.fparentid = so.fid ").append(this.CR).append("                        INNER JOIN t_sd_postrequisitionentry pqe ").append(this.CR).append("                                ON (soe.fparentid = pqe.fsaleorderid ").append(this.CR).append("                                    AND pqe.fsaleorderentryid = soe.fid) ").append(this.CR).append("                        INNER JOIN t_sd_postrequisition pq ").append(this.CR).append("                                ON pq.fid = pqe.fparentid ").append(this.CR).append("                        LEFT OUTER JOIN t_bd_multimeasureunit unit ").append(this.CR).append("                                ON (sce.fmaterialid = unit.fmaterialid ").append(this.CR).append("                                    AND sce.funitid = unit.fmeasureunitid) ").append(this.CR).append(link).append(this.CR).append("               WHERE    pq.fbasestatus IN (").append(this.splitByComma((String[])params.getObject(RPTPARAM_BASESTATUS))).append(closeStatus).append(") AND ").append(this.CR).append(whereCls).append("               group by sc.fid,sce.fid ");
        return sb.toString();
    }

    private String getSumTempTableSql(String tempTable) {
        StringBuffer sb = new StringBuffer();
        sb.append("create table ").append(tempTable).append(" (fid varchar(44),").append("fentryid varchar(44),").append("ftotalorderqty decimal (28, 10),").append("ftotalorderamount decimal (28, 10),").append("funvcamount decimal (28, 10),").append(this.CR).append("ftotalsaleqty decimal (28, 10),").append("ftotalissueqty decimal (28, 10),").append("ftotalotherqty decimal (28, 10),").append("ftotalamount decimal (28, 10),").append("FIssueTotalTaxAmount decimal (28, 10),").append("FArTotalAmt decimal (28, 10))");
        return sb.toString();
    }

    private String getSQLOnIssuing(RptParams params, String whereCls, String link) {
        StringBuffer sb = new StringBuffer();
        sb.append("               SELECT   sc.fid,").append(this.CR).append("                        sce.fid fentryid,").append(this.CR).append("                        0 ftotalorderqty,").append(this.CR).append("                        0 ftotalorderamount,").append(this.CR).append("                        0 funvcamount,").append(this.CR).append("                        0 ftotalsaleqty,").append(this.CR).append("                        sum(ISNULL(CASE ").append(this.CR).append("                              WHEN sce.funitid = sie.funitid or sce.funitid is null THEN sie.fqty ").append(this.CR).append("                              ELSE (sie.fbaseqty / unit.fbaseconvsrate) ").append(this.CR).append("                            END,0)) ftotalissueqty,").append(this.CR).append("                        0 ftotalotherqty,").append(this.CR).append("                        0 ftotalamount,").append(this.CR).append("                        sum(ISNULL(sie.famount,0)) FIssueTotalTaxAmount,").append(this.CR).append("                        0 FArTotalAmt ").append(this.CR).append("               FROM     t_sd_salecontractentry sce").append(this.CR).append("                        INNER JOIN t_sd_salecontract sc").append(this.CR).append("                                ON sc.fid = sce.fparentid").append(this.CR).append("                        INNER JOIN ").append(params.getString("OrgTempTable")).append("                        org ").append(this.CR).append("                                ON sc.fsaleorgunitid = org.fid").append(this.CR).append("                        INNER JOIN t_sd_saleorderentry soe").append(this.CR).append("                                ON (soe.fsourcebillid = sc.fid").append(this.CR).append("                                    AND soe.fsourcebillentryid = sce.fid)").append(this.CR).append("                        INNER JOIN t_sd_saleorder so").append(this.CR).append("                                ON soe.fparentid = so.fid").append(this.CR).append("                        INNER JOIN t_im_saleissueentry sie").append(this.CR).append("                                ON (soe.fparentid = sie.fsaleorderid").append(this.CR).append("                                    AND sie.fsaleorderentryid = soe.fid)").append(this.CR).append("                        INNER JOIN t_im_saleissuebill si").append(this.CR).append("                                ON si.fid = sie.fparentid").append(this.CR).append("                        INNER JOIN T_SCM_TransactionType tt").append(this.CR).append("                                ON si.FtransactiontypeID = tt.fid").append("                        LEFT OUTER JOIN t_bd_multimeasureunit unit").append(this.CR).append("                                ON (sce.fmaterialid = unit.fmaterialid").append(this.CR).append("                                    AND sce.funitid = unit.fmeasureunitid)").append(this.CR).append(link).append(this.CR).append("               WHERE    si.fnumber not like '*%' AND si.fbasestatus IN (").append(this.splitByComma((String[])params.getObject(RPTPARAM_BASESTATUS))).append(") AND ").append(this.CR).append(" ((si.FBizTypeID = 'd8e80652-0113-1000-e000-04c5c0a812202407435C' AND  tt.FRITypeID <> 'iIk8aAqr6kWIIJfpelAR0a9Nlzg=') AND ").append(this.CR).append(" (si.FBizTypeID = 'd8e80652-0113-1000-e000-04c5c0a812202407435C' AND  tt.FRITypeID <> 'PeDitkhckkedSIWV11rm969Nlzg=') OR ").append(this.CR).append(" si.FBizTypeID <> 'd8e80652-0113-1000-e000-04c5c0a812202407435C') AND ").append(this.CR).append(whereCls).append("               group by sc.fid,sce.fid ");
        return sb.toString();
    }

    private String getSQLOnReceivingBill(RptParams params, String whereCls, String link) {
        StringBuffer sb = new StringBuffer();
        sb.append("               SELECT   sc.fid,").append(this.CR).append("                        sce.fid fentryid,").append(this.CR).append("                        0 ftotalorderqty,").append(this.CR).append("                        0 ftotalorderamount,").append(this.CR).append("                        SUM(ISNULL(funvcamount,0)) funvcamount,").append(this.CR).append("                        0 ftotalsaleqty,").append(this.CR).append("                        0 ftotalissueqty,").append(this.CR).append("                        0 ftotalotherqty,").append(this.CR).append("                        0 FIssueTotalTaxAmount,").append(this.CR).append("                        0 ftotalamount,0 FArTotalAmt ").append(this.CR).append("               FROM     t_sd_salecontractentry sce ").append(this.CR).append("                        INNER JOIN t_sd_salecontract sc ").append(this.CR).append("                                ON sc.fid = sce.fparentid ").append(this.CR).append("                        INNER JOIN ").append(params.getString("OrgTempTable")).append("                        org ").append(this.CR).append("                                ON sc.fsaleorgunitid = org.fid ").append(this.CR).append("                        INNER JOIN T_CAS_ReceivingBillEntry crbe ").append(this.CR).append("                                ON (crbe.fsourcebillid = sc.fid ").append(this.CR).append("                                    AND crbe.fsourcebillentryid = sce.fid) ").append(this.CR).append("                        INNER JOIN T_CAS_ReceivingBill crb ").append(this.CR).append("                                ON (crbe.FReceivingBillID = crb.fid ").append(this.CR).append("\t\t\t\t\t\t\t\t\t   AND crb.Fbillstatus = 14) ").append(this.CR).append("               group by sc.fid,sce.fid ").append(" UNION ALL ").append(this.CR).append("               SELECT   sc.fid,").append(this.CR).append("                        sce.fid fentryid,").append(this.CR).append("                        0 ftotalorderqty,").append(this.CR).append("                        0 ftotalorderamount,").append(this.CR).append("                        SUM(ISNULL(funvcamount,0)) funvcamount,").append(this.CR).append("                        0 ftotalsaleqty,").append(this.CR).append("                        0 ftotalissueqty,").append(this.CR).append("                        0 ftotalotherqty,").append(this.CR).append("                        0 FIssueTotalTaxAmount,").append(this.CR).append("                        0 ftotalamount,0 FArTotalAmt ").append(this.CR).append("               FROM     t_sd_salecontractentry sce ").append(this.CR).append("                        INNER JOIN t_sd_salecontract sc ").append(this.CR).append("                                ON sc.fid = sce.fparentid ").append(this.CR).append("                         INNER JOIN t_sd_saleorderentry soe ").append(this.CR).append("                                ON soe.fsourcebillentryid = sce.fid ").append(this.CR).append("                        INNER JOIN t_sd_saleorder so ").append(this.CR).append("                                ON soe.fparentid = so.fid ").append(this.CR).append("                        INNER JOIN ").append(params.getString("OrgTempTable")).append("                        org ").append(this.CR).append("                                ON sc.fsaleorgunitid = org.fid ").append(this.CR).append("                        INNER JOIN T_CAS_ReceivingBillEntry crbe ").append(this.CR).append("                                ON (crbe.fsourcebillid = so.fid ").append(this.CR).append("                                    AND crbe.fsourcebillentryid = soe.fid) ").append(this.CR).append("                        INNER JOIN T_CAS_ReceivingBill crb ").append(this.CR).append("                                ON (crbe.FReceivingBillID = crb.fid ").append(this.CR).append("\t\t\t\t\t\t\t\t\t   AND crb.Fbillstatus = 14 )").append(this.CR).append("               group by sc.fid,sce.fid ");
        return sb.toString();
    }

    private String getSQLOnReceiving(RptParams params, String whereCls, String link) {
        StringBuffer sb = new StringBuffer();
        String[] baseStatus = (String[])params.getObject(RPTPARAM_BASESTATUS);
        String otherStatus = "";
        if (baseStatus != null) {
            int length = baseStatus.length;
            for (int i = 0; i < length; ++i) {
                if (baseStatus[i] == null || !"4".equals(baseStatus[i])) continue;
                otherStatus = ",6,7,-2";
                break;
            }
        }
        sb.append("               SELECT   sc.fid,").append(this.CR).append("                        sce.fid fentryid,").append(this.CR).append("                        sum(ISNULL(CASE ").append(this.CR).append("                              WHEN sce.funitid = soe.funitid or sce.funitid is null THEN soe.fqty ").append(this.CR).append("                              ELSE (soe.fbaseqty / unit.fbaseconvsrate) ").append(this.CR).append("                            END,0)) ftotalorderqty,").append(this.CR).append("                        sum(soe.ftaxamount) ftotalorderamount,").append(this.CR).append("                        0 funvcamount,").append(this.CR).append("                        0 ftotalsaleqty,").append(this.CR).append("                        0 ftotalissueqty,").append(this.CR).append("                        sum(ISNULL(soe.FTotalInvoicedQty,0)) ftotalotherqty,").append(this.CR).append("                        sum(ISNULL(soe.FtotalReceivedAmount,0)) ftotalamount,").append(this.CR).append("                        0 FIssueTotalTaxAmount,").append(this.CR).append("                        sum(ISNULL(soe.FTotalArAmount,0)) FArTotalAmt").append(this.CR).append("               FROM     t_sd_salecontractentry sce").append(this.CR).append("                        INNER JOIN t_sd_salecontract sc").append(this.CR).append("                                ON sc.fid = sce.fparentid").append(this.CR).append("                        INNER JOIN ").append(params.getString("OrgTempTable")).append("                        org ").append(this.CR).append("                                ON sc.fsaleorgunitid = org.fid").append(this.CR).append("                        INNER JOIN t_sd_saleorderentry soe").append(this.CR).append("                                ON (soe.fsourcebillid = sc.fid").append(this.CR).append("                                    AND soe.fsourcebillentryid = sce.fid)").append(this.CR).append("                        INNER JOIN t_sd_saleorder so").append(this.CR).append("                                ON soe.fparentid = so.fid").append(this.CR).append("                        LEFT OUTER JOIN t_bd_multimeasureunit unit").append(this.CR).append("                                ON (sce.fmaterialid = unit.fmaterialid").append(this.CR).append("                                    AND sce.funitid = unit.fmeasureunitid)").append(this.CR).append(link).append(this.CR).append("               WHERE    ").append("  so.FBaseStatus in(").append(this.splitByComma(baseStatus)).append(otherStatus).append(")  and ").append(whereCls).append("               group by sc.fid,sce.fid ");
        return sb.toString();
    }

    private String getWhereCls(RptParams params, StringBuffer purBuffer, boolean isSumData) throws EASBizException, BOSException {
        int i;
        StringBuffer queryStr = new StringBuffer();
        String bd = null;
        String ed = null;
        bd = (String)params.getObject(RPTPARAM_STARTDATE);
        ed = (String)params.getObject(RPTPARAM_ENDDATE);
        queryStr.append("sc.FBizDate").append("  >= {").append(bd).append("} and ").append("sc.FBizDate").append(" <= {").append(ed).append("}");
        String deliveryDate1 = (String)params.getObject(RPTPARAM_DELIVERYDATE1);
        String deliveryDate2 = (String)params.getObject(RPTPARAM_DELIVERYDATE2);
        if (deliveryDate1 != null) {
            queryStr.append("\r\n and ");
            queryStr.append("sce.FDeliveryDate  >= {" + deliveryDate1 + "} ");
        }
        if (deliveryDate2 != null) {
            queryStr.append(" and sce.FDeliveryDate <= {" + deliveryDate2 + " }");
        }
        String baseStatusSCE = (String)params.getObject(RPTPARAM_BASESTATUSSCE);
        int entryStatus = -1;
        if (baseStatusSCE != null) {
            entryStatus = new Integer(baseStatusSCE);
        }
        if (entryStatus == -1) {
            queryStr.append(" and sce.FBaseStatus in (4,6,7,0,-2) ");
        } else {
            queryStr.append(" and sce.FBaseStatus = " + entryStatus);
        }
        String baseStatusSC = (String)params.getObject(RPTPARAM_BASESTATUSSC);
        int status = -1;
        if (baseStatusSC != null) {
            status = new Integer(baseStatusSC);
        }
        if (status == -1) {
            queryStr.append(" and sc.FBaseStatus in (4,6,7,0,-2) ");
        } else {
            queryStr.append(" and sc.FBaseStatus = " + status);
        }
        if (params.getObject(RPTPARAM_CONTRACT1) != null) {
            queryStr.append(" and sc.FNumber >= '");
            queryStr.append(params.getObject(RPTPARAM_CONTRACT1));
            queryStr.append("'");
        }
        if (params.getObject(RPTPARAM_CONTRACT2) != null) {
            queryStr.append(" and sc.FNumber <= '");
            queryStr.append(params.getObject(RPTPARAM_CONTRACT2));
            queryStr.append("'");
        }
        if (params.getObject(RPTPARAM_CUSTOMER1) != null) {
            if (params.getObject(RPTPARAM_CUSTOMER1) instanceof Object[]) {
                Object[] customers = (Object[])params.getObject(RPTPARAM_CUSTOMER1);
                if (customers.length == 1) {
                    queryStr.append(" and Customer.FNumber >= '");
                    queryStr.append(((CustomerInfo)customers[0]).getNumber());
                    queryStr.append("'");
                } else {
                    queryStr.append(" and Customer.FNumber in (");
                    for (i = 0; i < customers.length; ++i) {
                        if (i > 0) {
                            queryStr.append(",");
                        }
                        queryStr.append("'").append(((CustomerInfo)customers[i]).getNumber()).append("'");
                    }
                    queryStr.append(")");
                }
            } else if (params.getObject(RPTPARAM_CUSTOMER1) instanceof CustomerInfo) {
                queryStr.append(" and Customer.FNumber >= '");
                queryStr.append(((CustomerInfo)params.getObject(RPTPARAM_CUSTOMER1)).getNumber());
                queryStr.append("'");
            } else {
                queryStr.append(" and Customer.FNumber >= '");
                queryStr.append(params.getObject(RPTPARAM_CUSTOMER1));
                queryStr.append("'");
            }
            if (purBuffer.toString().indexOf("T_BD_Customer") == -1) {
                purBuffer.append("\r\n inner join T_BD_Customer Customer ");
                purBuffer.append(" on Customer.fid = sc.FCustomerID ");
            }
        }
        if (params.getObject(RPTPARAM_CUSTOMER2) != null) {
            queryStr.append(" and Customer.FNumber <= '");
            queryStr.append(params.getObject(RPTPARAM_CUSTOMER2));
            queryStr.append("'");
            if (purBuffer.toString().indexOf("T_BD_Customer") == -1) {
                purBuffer.append("\r\n inner join T_BD_Customer Customer ");
                purBuffer.append(" on Customer.fid = sc.FCustomerID ");
            }
        }
        if (params.getObject(RPTPARAM_SALESPERSON1) != null) {
            if (params.getObject(RPTPARAM_SALESPERSON1) instanceof Object[]) {
                Object[] salePerons = (Object[])params.getObject(RPTPARAM_SALESPERSON1);
                if (salePerons.length == 1) {
                    queryStr.append(" and SalePerson.FNumber >= '");
                    queryStr.append(((PersonInfo)salePerons[0]).getNumber());
                    queryStr.append("'");
                } else {
                    queryStr.append(" and SalePerson.FNumber in (");
                    for (i = 0; i < salePerons.length; ++i) {
                        if (i > 0) {
                            queryStr.append(",");
                        }
                        queryStr.append("'").append(((PersonInfo)salePerons[i]).getNumber()).append("'");
                    }
                    queryStr.append(")");
                }
            } else {
                queryStr.append(" and SalePerson.FNumber >= '");
                queryStr.append(params.getObject(RPTPARAM_SALESPERSON1));
                queryStr.append("'");
            }
            if (purBuffer.toString().indexOf("T_BD_Person") == -1) {
                purBuffer.append("\r\n inner join T_BD_Person SalePerson ");
                purBuffer.append(" on SalePerson.fid = sc.FSalePersonID ");
            }
        }
        if (params.getObject(RPTPARAM_SALESPERSON2) != null) {
            queryStr.append(" and SalePerson.FNumber <= '");
            queryStr.append(params.getObject(RPTPARAM_SALESPERSON2));
            queryStr.append("'");
            if (purBuffer.toString().indexOf("T_BD_Person") == -1) {
                purBuffer.append("\r\n inner join T_BD_Person SalePerson ");
                purBuffer.append(" on SalePerson.fid = sc.FSalePersonID ");
            }
        }
        if (params.getObject(RPTPARAM_MATERIAL1) != null) {
            if (params.getObject(RPTPARAM_MATERIAL1) instanceof Object[]) {
                Object[] materials = (Object[])params.getObject(RPTPARAM_MATERIAL1);
                if (materials.length == 1) {
                    queryStr.append(" and material.FNumber >= '");
                    queryStr.append(((MaterialInfo)materials[0]).getNumber());
                    queryStr.append("'");
                } else {
                    queryStr.append(" and material.FNumber in (");
                    for (i = 0; i < materials.length; ++i) {
                        if (i > 0) {
                            queryStr.append(",");
                        }
                        queryStr.append("'").append(((MaterialInfo)materials[i]).getNumber()).append("'");
                    }
                    queryStr.append(")");
                }
            } else {
                queryStr.append(" and material.FNumber >= '");
                queryStr.append(params.getObject(RPTPARAM_MATERIAL1));
                queryStr.append("'");
            }
            if (purBuffer.toString().indexOf("T_BD_Material") == -1) {
                purBuffer.append("\r\n inner join T_BD_Material material ");
                purBuffer.append(" on material.fid = sce.FMaterialID ");
            }
        }
        if (params.getObject(RPTPARAM_MATERIAL2) != null) {
            queryStr.append(" and material.FNumber <= '");
            queryStr.append(params.getObject(RPTPARAM_MATERIAL2));
            queryStr.append("'");
            if (purBuffer.toString().indexOf("T_BD_Material") == -1) {
                purBuffer.append("\r\n inner join T_BD_Material material ");
                purBuffer.append(" on material.fid = sce.FMaterialID ");
            }
        }
        if (params.getObject(RPTPARAM_BIZTYPE1) != null) {
            queryStr.append(" and BIZTYPE.FNumber >= '");
            queryStr.append(params.getObject(RPTPARAM_BIZTYPE1));
            queryStr.append("'");
            if (purBuffer.toString().indexOf("T_SCM_BizType") == -1) {
                purBuffer.append("\r\n LEFT OUTER JOIN T_SCM_BizType AS BIZTYPE ");
                purBuffer.append(" ON sc.FBizTypeID = BIZTYPE.FID ");
            }
        }
        if (params.getObject(RPTPARAM_BIZTYPE2) != null) {
            queryStr.append(" and BIZTYPE.FNumber <= '");
            queryStr.append(params.getObject(RPTPARAM_BIZTYPE2));
            queryStr.append("'");
            if (purBuffer.toString().indexOf("T_SCM_BizType") == -1) {
                purBuffer.append("\r\n LEFT OUTER JOIN T_SCM_BizType AS BIZTYPE ");
                purBuffer.append(" ON sc.FBizTypeID = BIZTYPE.FID ");
            }
        }
        return queryStr.toString();
    }

    private int getIndexForArray(String[] array, String key) {
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equals(key)) continue;
            return i;
        }
        return -1;
    }
}

