/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptCellFormatter;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.util.KsqlUtil;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.sd.sale.SaleReportBillStatusEnum;
import com.kingdee.eas.scm.sd.sale.report.app.AbstractSaleCostDetailFacadeControllerBean;
import com.kingdee.eas.scm.sd.sale.util.SaleUtil;
import com.kingdee.eas.scm.util.PermissionUtil;
import com.kingdee.eas.scm.util.constant.RecIssueTypeConstant;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Set;

public class SaleCostDetailFacadeControllerBean
extends AbstractSaleCostDetailFacadeControllerBean {
    private static final String resClassName = "com.kingdee.eas.scm.sd.sale.report.SDReportResource";
    private int groupBy;
    private Object[] companyOrg = null;

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        this.dropTable(params.getString("TempTableName"), ctx);
        String tempTable = this.getTempTableName(this.getServerResource("SaleORGUintTempTable", ctx), ctx);
        params.setString("TempTableName", tempTable);
        this.groupBy = new Integer(params.getString("CombOrderCol"));
        this.createTempTableAndinsertSQLData(ctx, tempTable, params);
        DBUtil.createTempTableIndex((Context)ctx, (String)tempTable, (String)"fid", (boolean)false);
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            DBUtil.AnalyseTable((Context)ctx, (Connection)conn, (String)tempTable);
            DBUtil.AnalyseTable((Context)ctx, (Connection)conn, (String)tempTable);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        String countSql = "select count(FID) cc from " + tempTable;
        RptRowSet rs = this.executeQuery(countSql, null, ctx);
        rs.next();
        int count = rs.getInt(0);
        RptTableHeader header = new RptTableHeader();
        this.setTableHead(header, params, ctx);
        RptParams result = new RptParams();
        result.setString("TempTableName", tempTable);
        result.setObject("header", (Object)header);
        result.setInt("verticalCount", count);
        result.setString("TempTableObject", tempTable);
        return result;
    }

    private void createTempTableAndinsertSQLData(Context ctx, String tempTable, RptParams params) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer(this.getCreateTempTable(tempTable, params));
        this.executeSQL(ctx, sql.toString());
        SqlParams sqlParams = new SqlParams();
        this.setRPTData(sqlParams, params);
        sql.setLength(0);
        sql.append(this.getRptSql(params, tempTable, ctx));
        if (sql.length() != 0) {
            this.executeUpdate(sql.toString(), sqlParams, ctx);
        }
        if (params.getObject("SaleGroupFrom") == null && params.getObject("SaleGroupTo") == null && params.getObject("SalePersonFrom") == null && params.getObject("SalePersonTo") == null) {
            sql.setLength(0);
            sql.append(this.getRptSqlForCostAdjustBill(params, tempTable, ctx));
            if (sql.length() != 0) {
                this.executeUpdate(sql.toString(), sqlParams, ctx);
            }
        }
        sql.setLength(0);
        if (params.getString("IsTotal").equals("true")) {
            sql.append(this.getRptTotalSql(params, tempTable, ctx));
            this.executeUpdate(sql.toString(), null, ctx);
        }
        if (params.getString("IsSum").equals("true")) {
            sql.setLength(0);
            sql.append(this.getRptSumSql(params, tempTable, ctx));
            this.executeUpdate(sql.toString(), null, ctx);
        }
    }

    private String getCreateTempTable(String tempTable, RptParams params) {
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table " + tempTable + "(\r\n");
        sql.append("FID Varchar(44)\r\n");
        sql.append(",FBizDate DateTime\r\n");
        sql.append(",FNumber Varchar(200)\r\n");
        sql.append(",FBizTypeID Varchar(44)\r\n");
        sql.append(",FCompanyOrgUnitID Varchar(44)\r\n");
        sql.append(",FStorageOrgUnitID Varchar(44)\r\n");
        sql.append(",FSaleOrgUnitID Varchar(44)\r\n");
        sql.append(",FSaleGroupID Varchar(44) \r\n");
        sql.append(",FCustomerID Varchar(44)\r\n");
        sql.append(",FPersonID Varchar(44)\r\n");
        sql.append(",FWarehouseID Varchar(44)\r\n");
        sql.append(",FMaterialID Varchar(44)\r\n");
        if (params.getBoolean("AuxiliaryProperties")) {
            sql.append(",FAssistPropertyID Varchar(44)\r\n");
        }
        sql.append(",FBaseUnitID Varchar(44)\r\n");
        sql.append(",FBaseQty Decimal(28,10)\r\n");
        sql.append(",FPrice Decimal(28,10)\r\n");
        sql.append(",FActualCost Decimal(28,10)\r\n");
        sql.append(",FUnitStandardCost Decimal(28,10)\r\n");
        sql.append(",FStandardCost  Decimal(28,10)\r\n");
        sql.append(",FTotalFlag Varchar(44)\r\n");
        sql.append(");\r\n");
        return sql.toString();
    }

    private String getRptSql(RptParams params, String tableName, Context ctx) throws BOSException, EASBizException {
        StringBuffer insertSQL = new StringBuffer();
        CompanyOrgUnitCollection companyColl = (CompanyOrgUnitCollection)params.getObject("fullCompanyOrgUnit");
        if (companyColl != null && companyColl.size() > 0) {
            Set cuUnitSets = PermissionUtil.getAuthorizedf7Orgs((Context)ctx, (IObjectPK)ctx.getCaller(), (String)"SaleCostDetailUI_view");
            Set havePermOrgUnitSet = InvServerUtils.getSelAuthorUnit((Set)cuUnitSets, (Object[])companyColl.toArray());
            this.companyOrg = havePermOrgUnitSet.toArray();
        }
        String companyOrgIDlist = this.getCompanyOrgListId(this.companyOrg);
        StorageOrgUnitCollection storageColl = (StorageOrgUnitCollection)params.getObject("fullStorageOrgUnit");
        String storageIDlist = this.getStorageOrgListId(storageColl);
        SaleOrgUnitCollection saleColl = (SaleOrgUnitCollection)params.getObject("fullSaleOrgUnit");
        String orgIDlist = this.getSaleOrgListId(saleColl);
        SaleReportBillStatusEnum billStatus = SaleReportBillStatusEnum.getEnum(new Integer(params.getString("billStatus")));
        if (this.companyOrg.length != 0) {
            insertSQL.append("insert into " + tableName);
            insertSQL.append(" \r\n SELECT ");
            insertSQL.append(" \r\n SaleIssueBill.FID");
            insertSQL.append(" \r\n ,SaleIssueBill.FBIZDate");
            insertSQL.append(" \r\n ,SaleIssueBill.FNumber");
            insertSQL.append(" \r\n ,SaleIssueBill.FBizTypeID");
            insertSQL.append(" \r\n ,ENTRY.FCompanyOrgUnitID");
            insertSQL.append(" \r\n ,ENTRY.FStorageOrgUnitID");
            insertSQL.append(" \r\n ,ENTRY.FSaleOrgUnitID");
            insertSQL.append(" \r\n ,ISNULL(ENTRY.FSaleGroupID,'zzzz')");
            insertSQL.append(" \r\n ,SaleIssueBill.FCustomerID");
            insertSQL.append(" \r\n ,ISNULL(ENTRY.FSalePersonID,'zzzz')");
            insertSQL.append(" \r\n ,ISNULL(ENTRY.FWarehouseID,'zzzz')");
            insertSQL.append(" \r\n ,ENTRY.FMaterialID");
            if (params.getBoolean("AuxiliaryProperties")) {
                insertSQL.append(" \r\n ,ENTRY.FAssistPropertyID");
            }
            insertSQL.append(" \r\n ,ENTRY.FBaseUnitID");
            if (billStatus == SaleReportBillStatusEnum.cal) {
                insertSQL.append(" \r\n ,wf.fcurrwrittenoffqty");
                insertSQL.append(" \r\n ,ENTRY.FUnitActualCost");
                insertSQL.append(" \r\n ,wf.fcurrwrittenoffamount");
            } else {
                insertSQL.append(" \r\n ,ENTRY.FBaseQty");
                insertSQL.append(" \r\n ,ENTRY.FUnitActualCost");
                insertSQL.append(" \r\n ,ENTRY.FActualCost");
            }
            insertSQL.append(" \r\n ,ENTRY.FUnitStandardCost");
            insertSQL.append(" \r\n ,ENTRY.FStandardCost");
            insertSQL.append(" \r\n ,'AAA'");
            insertSQL.append(" \r\n  from T_IM_SaleIssueBill SaleIssueBill ");
            insertSQL.append(" \r\n  inner join  T_IM_SaleIssueEntry entry");
            insertSQL.append(" \r\n  on (SaleIssueBill.FID = entry.FParentID and entry.FINVUPDATETYPEID != 'CeUAAAAIdBvC73rf')");
            if (billStatus == SaleReportBillStatusEnum.cal) {
                int periodYear = new Integer(params.getString("periodYear"));
                int periodYearTo = new Integer(params.getString("periodYearTo"));
                int periodMonth = new Integer(params.getString("periodMonth"));
                int periodMonthTo = new Integer(params.getString("periodMonthTo"));
                insertSQL.append("\r\n inner join");
                insertSQL.append("\r\n (select clw.fbillentryid,sum(clw.fcurrwrittenoffqty) as fcurrwrittenoffqty,");
                insertSQL.append("\r\n  sum(clw.fcurrwrittenoffamount) as fcurrwrittenoffamount from T_CL_WriteOffRecord clw");
                insertSQL.append("\r\n where clw.fbilltypenumber = '102'");
                insertSQL.append("\r\n and (clw.fwriteoffyear * 100 + fwriteoffperiod) >= (" + periodYear + " * 100 + " + periodMonth + ")");
                insertSQL.append("\r\n and (clw.fwriteoffyear * 100 + fwriteoffperiod) <= (" + periodYearTo + " * 100 + " + periodMonthTo + ")");
                insertSQL.append("\r\n and clw.fcompanyorgunitid in (" + companyOrgIDlist + ")");
                insertSQL.append("\r\n group by clw.fbillentryid");
                insertSQL.append("\r\n )wf on wf.fbillentryid = entry.fid");
            }
            insertSQL.append(" \r\n INNER JOIN T_ORG_Company AS COMPANYORGUNIT");
            insertSQL.append(" \r\n ON ENTRY.FCompanyOrgUnitID = COMPANYORGUNIT.FID");
            insertSQL.append(" \r\n  and  ENTRY.FCompanyOrgUnitID in ");
            insertSQL.append(" \r\n  (" + companyOrgIDlist + ")");
            insertSQL.append(" \r\n INNER JOIN T_ORG_Storage AS STORAGEORGUNIT");
            insertSQL.append(" \r\n ON ENTRY.FStorageOrgUnitID = STORAGEORGUNIT.FID");
            insertSQL.append(" \r\n  and  ENTRY.FStorageOrgUnitID in ");
            insertSQL.append(" \r\n  (" + storageIDlist + ")");
            insertSQL.append(" \r\n INNER JOIN T_ORG_Sale org");
            insertSQL.append(" \r\n on ENTRY.FSaleOrgUnitID = org.FID ");
            insertSQL.append(" \r\n  and  ENTRY.FSaleOrgUnitID in ");
            insertSQL.append(" \r\n  (" + orgIDlist + ")");
            String saleOrderStr = this.getQueryStr(params, "SaleIssueBill", insertSQL, ctx);
            insertSQL.append(saleOrderStr);
        }
        return insertSQL.toString();
    }

    private String getRptSqlForCostAdjustBill(RptParams params, String tableName, Context ctx) throws BOSException, EASBizException {
        StringBuffer insertSQL = new StringBuffer();
        CompanyOrgUnitCollection companyColl = (CompanyOrgUnitCollection)params.getObject("fullCompanyOrgUnit");
        String companyOrgIDlist = this.getCompanyOrgListId(this.companyOrg);
        StorageOrgUnitCollection storageColl = (StorageOrgUnitCollection)params.getObject("fullStorageOrgUnit");
        String storageIDlist = this.getStorageOrgListId(storageColl);
        if (companyOrgIDlist.length() != 0) {
            insertSQL.append("insert into " + tableName);
            insertSQL.append(" \r\n SELECT ");
            insertSQL.append(" \r\n costAdjustBill.FID");
            insertSQL.append(" \r\n ,costAdjustBill.FBIZDate");
            insertSQL.append(" \r\n ,costAdjustBill.FNumber");
            insertSQL.append(" \r\n ,costAdjustBill.FBizTypeID");
            insertSQL.append(" \r\n ,ENTRY.FCompanyOrgUnitID");
            insertSQL.append(" \r\n ,ENTRY.FStorageOrgUnitID");
            insertSQL.append(" \r\n ,null");
            insertSQL.append(" \r\n ,'zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz'");
            insertSQL.append(" \r\n ,costAdjustBill.FCustomerID");
            insertSQL.append(" \r\n ,'zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz'");
            insertSQL.append(" \r\n ,ISNULL(ENTRY.FWarehouseID,'zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz')");
            insertSQL.append(" \r\n ,ENTRY.FMaterialID");
            if (params.getBoolean("AuxiliaryProperties")) {
                insertSQL.append(" \r\n ,ENTRY.FAssistPropertyID");
            }
            insertSQL.append(" \r\n ,ENTRY.FBaseUnitID");
            insertSQL.append(" \r\n ,ENTRY.FBaseQty");
            insertSQL.append(" \r\n ,ENTRY.FUnitActualCost");
            insertSQL.append(" \r\n ,ENTRY.FActualCost");
            insertSQL.append(" \r\n ,ENTRY.FUnitStandardCost");
            insertSQL.append(" \r\n ,ENTRY.FStandardCost");
            insertSQL.append(" \r\n ,'AAA'");
            insertSQL.append(" \r\n  from T_CL_CostAdjustBill costAdjustBill ");
            insertSQL.append(" \r\n  inner join T_CL_CostAdjustBillEntry entry");
            insertSQL.append(" \r\n  on costAdjustBill.FID = entry.FParentID ");
            insertSQL.append(" \r\n INNER JOIN T_ORG_Company AS COMPANYORGUNIT");
            insertSQL.append(" \r\n ON ENTRY.FCompanyOrgUnitID = COMPANYORGUNIT.FID");
            insertSQL.append(" \r\n  and  ENTRY.FCompanyOrgUnitID in ");
            insertSQL.append(" \r\n  (" + companyOrgIDlist + ")");
            insertSQL.append(" \r\n INNER JOIN T_ORG_Storage AS STORAGEORGUNIT");
            insertSQL.append(" \r\n ON ENTRY.FStorageOrgUnitID = STORAGEORGUNIT.FID");
            insertSQL.append(" \r\n  and  ENTRY.FStorageOrgUnitID in ");
            insertSQL.append(" \r\n  (" + storageIDlist + ")");
            String saleOrderStr = this.getQuery(params, "costAdjustBill", insertSQL, ctx);
            insertSQL.append(saleOrderStr);
        }
        return insertSQL.toString();
    }

    private String getRptTotalSql(RptParams params, String tableName, Context ctx) throws BOSException, EASBizException {
        StringBuffer groupSQL = new StringBuffer();
        this.groupBy = new Integer(params.getString("CombOrderCol"));
        switch (this.groupBy) {
            case 1: {
                groupSQL.append("INSERT INTO " + tableName);
                groupSQL.append(" \r\n (FID,FBizDate");
                groupSQL.append(" \r\n ,FBaseQty");
                groupSQL.append(",FActualCost");
                groupSQL.append(",FUnitStandardCost");
                groupSQL.append(",FStandardCost");
                groupSQL.append(",FTotalFlag)");
                groupSQL.append(" \r\n SELECT ");
                groupSQL.append(" \r\n newbosid('88888888')");
                groupSQL.append(" \r\n ,MAX(FBizDate)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FBaseQty),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FActualCost),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FUnitStandardCost),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FStandardCost),31,7)");
                groupSQL.append(" \r\n ,'Total'");
                groupSQL.append(" \r\n  from " + tableName);
                groupSQL.append(" \r\n  GROUP BY SUBSTRING(TO_CHAR(FBizDate),1,10)");
                break;
            }
            case 2: {
                groupSQL.append("INSERT INTO " + tableName);
                groupSQL.append(" \r\n (FID,FNumber");
                groupSQL.append(" \r\n ,FBaseQty");
                groupSQL.append(",FActualCost");
                groupSQL.append(",FUnitStandardCost");
                groupSQL.append(",FStandardCost");
                groupSQL.append(",FTotalFlag)");
                groupSQL.append(" \r\n SELECT ");
                groupSQL.append(" \r\n newbosid('88888888')");
                groupSQL.append(" \r\n ,MAX(FNumber)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FBaseQty),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FActualCost),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FUnitStandardCost),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FStandardCost),31,7)");
                groupSQL.append(" \r\n ,'Total'");
                groupSQL.append(" \r\n  from " + tableName);
                groupSQL.append(" \r\n  GROUP BY FNumber");
                break;
            }
            case 3: {
                groupSQL.append("INSERT INTO " + tableName);
                groupSQL.append(" \r\n (FID,FBizTypeID");
                groupSQL.append(" \r\n ,FBaseQty");
                groupSQL.append(",FActualCost");
                groupSQL.append(",FUnitStandardCost");
                groupSQL.append(",FStandardCost");
                groupSQL.append(",FTotalFlag)");
                groupSQL.append(" \r\n SELECT ");
                groupSQL.append(" \r\n newbosid('88888888')");
                groupSQL.append(" \r\n ,MAX(FBizTypeID)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FBaseQty),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FActualCost),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FUnitStandardCost),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FStandardCost),31,7)");
                groupSQL.append(" \r\n ,'Total'");
                groupSQL.append(" \r\n  from " + tableName);
                groupSQL.append(" \r\n  GROUP BY FBizTypeID");
                break;
            }
            case 4: {
                groupSQL.append("INSERT INTO " + tableName);
                groupSQL.append(" \r\n (FID,FSaleOrgUnitID");
                groupSQL.append(" \r\n ,FBaseQty");
                groupSQL.append(",FActualCost");
                groupSQL.append(",FUnitStandardCost");
                groupSQL.append(",FStandardCost");
                groupSQL.append(",FTotalFlag)");
                groupSQL.append(" \r\n SELECT ");
                groupSQL.append(" \r\n newbosid('88888888')");
                groupSQL.append(" \r\n ,MAX(FSaleOrgUnitID)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FBaseQty),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FActualCost),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FUnitStandardCost),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FStandardCost),31,7)");
                groupSQL.append(" \r\n ,'Total'");
                groupSQL.append(" \r\n  from " + tableName);
                groupSQL.append(" \r\n  GROUP BY FSaleOrgUnitID");
                break;
            }
            case 5: {
                groupSQL.append("INSERT INTO " + tableName);
                groupSQL.append(" \r\n (FID,FSaleGroupID");
                groupSQL.append(" \r\n ,FBaseQty");
                groupSQL.append(",FActualCost");
                groupSQL.append(",FUnitStandardCost");
                groupSQL.append(",FStandardCost");
                groupSQL.append(",FTotalFlag)");
                groupSQL.append(" \r\n SELECT ");
                groupSQL.append(" \r\n newbosid('88888888')");
                groupSQL.append(" \r\n ,MAX(FSaleGroupID)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FBaseQty),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FActualCost),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FUnitStandardCost),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FStandardCost),31,7)");
                groupSQL.append(" \r\n ,'Total'");
                groupSQL.append(" \r\n  from " + tableName);
                groupSQL.append(" \r\n  GROUP BY FSaleGroupID");
                break;
            }
            case 6: {
                groupSQL.append("INSERT INTO " + tableName);
                groupSQL.append(" \r\n (FID,FCustomerID");
                groupSQL.append(" \r\n ,FBaseQty");
                groupSQL.append(",FActualCost");
                groupSQL.append(",FUnitStandardCost");
                groupSQL.append(",FStandardCost");
                groupSQL.append(",FTotalFlag)");
                groupSQL.append(" \r\n SELECT ");
                groupSQL.append(" \r\n newbosid('88888888')");
                groupSQL.append(" \r\n ,MAX(FCustomerID)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FBaseQty),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FActualCost),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FUnitStandardCost),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FStandardCost),31,7)");
                groupSQL.append(" \r\n ,'Total'");
                groupSQL.append(" \r\n  from " + tableName);
                groupSQL.append(" \r\n  GROUP BY FCustomerID");
                break;
            }
            case 7: {
                groupSQL.append("INSERT INTO " + tableName);
                groupSQL.append(" \r\n (FID,FPersonID");
                groupSQL.append(" \r\n ,FBaseQty");
                groupSQL.append(",FActualCost");
                groupSQL.append(",FUnitStandardCost");
                groupSQL.append(",FStandardCost");
                groupSQL.append(",FTotalFlag)");
                groupSQL.append(" \r\n SELECT ");
                groupSQL.append(" \r\n newbosid('88888888')");
                groupSQL.append(" \r\n ,MAX(FPersonID)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FBaseQty),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FActualCost),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FUnitStandardCost),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FStandardCost),31,7)");
                groupSQL.append(" \r\n ,'Total'");
                groupSQL.append(" \r\n  from " + tableName);
                groupSQL.append(" \r\n  GROUP BY FPersonID");
                break;
            }
            case 8: {
                groupSQL.append("INSERT INTO " + tableName);
                if (params.getBoolean("AuxiliaryProperties")) {
                    groupSQL.append(" \r\n (FID,FMaterialID,FAssistPropertyID");
                } else {
                    groupSQL.append(" \r\n (FID,FMaterialID");
                }
                groupSQL.append(" \r\n ,FBaseQty");
                groupSQL.append(",FActualCost");
                groupSQL.append(",FUnitStandardCost");
                groupSQL.append(",FStandardCost");
                groupSQL.append(",FTotalFlag)");
                groupSQL.append(" \r\n SELECT ");
                groupSQL.append(" \r\n newbosid('88888888')");
                if (params.getBoolean("AuxiliaryProperties")) {
                    groupSQL.append(" \r\n ,MAX(FMaterialID),MAX(FAssistPropertyID)");
                } else {
                    groupSQL.append(" \r\n ,MAX(FMaterialID)");
                }
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FBaseQty),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FActualCost),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FUnitStandardCost),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FStandardCost),31,7)");
                groupSQL.append(" \r\n ,'Total'");
                groupSQL.append(" \r\n  from " + tableName);
                groupSQL.append(" \r\n  GROUP BY FMaterialID");
                if (!params.getBoolean("AuxiliaryProperties")) break;
                groupSQL.append(",FAssistPropertyID");
                break;
            }
            case 9: {
                groupSQL.append("INSERT INTO " + tableName);
                groupSQL.append(" \r\n (FID,FCompanyOrgUnitID");
                groupSQL.append(" \r\n ,FBaseQty");
                groupSQL.append(",FActualCost");
                groupSQL.append(",FUnitStandardCost");
                groupSQL.append(",FStandardCost");
                groupSQL.append(",FTotalFlag)");
                groupSQL.append(" \r\n SELECT ");
                groupSQL.append(" \r\n newbosid('88888888')");
                groupSQL.append(" \r\n ,MAX(FCompanyOrgUnitID)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FBaseQty),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FActualCost),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FUnitStandardCost),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FStandardCost),31,7)");
                groupSQL.append(" \r\n ,'Total'");
                groupSQL.append(" \r\n  from " + tableName);
                groupSQL.append(" \r\n  GROUP BY FCompanyOrgUnitID");
                break;
            }
            case 10: {
                groupSQL.append("INSERT INTO " + tableName);
                groupSQL.append(" \r\n (FID,FStorageOrgUnitID");
                groupSQL.append(" \r\n ,FBaseQty");
                groupSQL.append(",FActualCost");
                groupSQL.append(",FUnitStandardCost");
                groupSQL.append(",FStandardCost");
                groupSQL.append(",FTotalFlag)");
                groupSQL.append(" \r\n SELECT ");
                groupSQL.append(" \r\n newbosid('88888888')");
                groupSQL.append(" \r\n ,MAX(FStorageOrgUnitID)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FBaseQty),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FActualCost),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FUnitStandardCost),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FStandardCost),31,7)");
                groupSQL.append(" \r\n ,'Total'");
                groupSQL.append(" \r\n  from " + tableName);
                groupSQL.append(" \r\n  GROUP BY FStorageOrgUnitID");
                break;
            }
            case 11: {
                groupSQL.append("INSERT INTO " + tableName);
                groupSQL.append(" \r\n (FID,FWarehouseID");
                groupSQL.append(" \r\n ,FBaseQty");
                groupSQL.append(",FActualCost");
                groupSQL.append(",FUnitStandardCost");
                groupSQL.append(",FStandardCost");
                groupSQL.append(",FTotalFlag)");
                groupSQL.append(" \r\n SELECT ");
                groupSQL.append(" \r\n newbosid('88888888')");
                groupSQL.append(" \r\n ,MAX(FWarehouseID)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FBaseQty),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FActualCost),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FUnitStandardCost),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FStandardCost),31,7)");
                groupSQL.append(" \r\n ,'Total'");
                groupSQL.append(" \r\n  from " + tableName);
                groupSQL.append(" \r\n  GROUP BY FWarehouseID");
            }
        }
        return groupSQL.toString();
    }

    private String getRptSumSql(RptParams params, String tableName, Context ctx) throws BOSException, EASBizException {
        StringBuffer groupSQL = new StringBuffer();
        this.groupBy = new Integer(params.getString("CombOrderCol"));
        switch (this.groupBy) {
            case 1: {
                groupSQL.append("INSERT INTO " + tableName);
                groupSQL.append(" \r\n (FID,FBizDate");
                groupSQL.append(" \r\n ,FBaseQty");
                groupSQL.append(",FActualCost");
                groupSQL.append(",FUnitStandardCost");
                groupSQL.append(",FStandardCost");
                groupSQL.append(",FTotalFlag)");
                groupSQL.append(" \r\n SELECT ");
                groupSQL.append(" \r\n newbosid('88888888')");
                groupSQL.append(" \r\n ,MAX(FBizDate)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FBaseQty),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FActualCost),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FUnitStandardCost),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FStandardCost),31,7)");
                groupSQL.append(" \r\n ,'TotalAll'");
                groupSQL.append(" \r\n  from " + tableName);
                groupSQL.append(" \r\n  where FTotalFlag<>'Total'");
                break;
            }
            case 2: {
                groupSQL.append("INSERT INTO " + tableName);
                groupSQL.append(" \r\n (FID,FNumber");
                groupSQL.append(" \r\n ,FBaseQty");
                groupSQL.append(",FActualCost");
                groupSQL.append(",FUnitStandardCost");
                groupSQL.append(",FStandardCost");
                groupSQL.append(",FTotalFlag)");
                groupSQL.append(" \r\n SELECT ");
                groupSQL.append(" \r\n newbosid('88888888')");
                groupSQL.append(" \r\n ,MAX(FNumber)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FBaseQty),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FActualCost),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FUnitStandardCost),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FStandardCost),31,7)");
                groupSQL.append(" \r\n ,'TotalAll'");
                groupSQL.append(" \r\n  from " + tableName);
                groupSQL.append(" \r\n  where FTotalFlag<>'Total'");
                break;
            }
            case 3: {
                groupSQL.append("INSERT INTO " + tableName);
                groupSQL.append(" \r\n (FID,FBizTypeID");
                groupSQL.append(" \r\n ,FBaseQty");
                groupSQL.append(",FActualCost");
                groupSQL.append(",FUnitStandardCost");
                groupSQL.append(",FStandardCost");
                groupSQL.append(",FTotalFlag)");
                groupSQL.append(" \r\n SELECT ");
                groupSQL.append(" \r\n newbosid('88888888')");
                groupSQL.append(" \r\n ,'zzzzzzzz' ");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FBaseQty),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FActualCost),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FUnitStandardCost),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FStandardCost),31,7)");
                groupSQL.append(" \r\n ,'TotalAll'");
                groupSQL.append(" \r\n  from " + tableName);
                groupSQL.append(" \r\n  where FTotalFlag<>'Total'");
                break;
            }
            case 4: {
                groupSQL.append("INSERT INTO " + tableName);
                groupSQL.append(" \r\n (FID,FSaleOrgUnitID");
                groupSQL.append(" \r\n ,FBaseQty");
                groupSQL.append(",FActualCost");
                groupSQL.append(",FUnitStandardCost");
                groupSQL.append(",FStandardCost");
                groupSQL.append(",FTotalFlag)");
                groupSQL.append(" \r\n SELECT ");
                groupSQL.append(" \r\n newbosid('88888888')");
                groupSQL.append(" \r\n ,'zzzzzzzz' ");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FBaseQty),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FActualCost),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FUnitStandardCost),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FStandardCost),31,7)");
                groupSQL.append(" \r\n ,'TotalAll'");
                groupSQL.append(" \r\n  from " + tableName);
                groupSQL.append(" \r\n  where FTotalFlag<>'Total'");
                break;
            }
            case 5: {
                groupSQL.append("INSERT INTO " + tableName);
                groupSQL.append(" \r\n (FID,FSaleGroupID");
                groupSQL.append(" \r\n ,FBaseQty");
                groupSQL.append(",FActualCost");
                groupSQL.append(",FUnitStandardCost");
                groupSQL.append(",FStandardCost");
                groupSQL.append(",FTotalFlag)");
                groupSQL.append(" \r\n SELECT ");
                groupSQL.append(" \r\n newbosid('88888888')");
                groupSQL.append(" \r\n ,'zzzzzzzz' ");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FBaseQty),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FActualCost),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FUnitStandardCost),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FStandardCost),31,7)");
                groupSQL.append(" \r\n ,'TotalAll'");
                groupSQL.append(" \r\n  from " + tableName);
                groupSQL.append(" \r\n  where FTotalFlag<>'Total'");
                break;
            }
            case 6: {
                groupSQL.append("INSERT INTO " + tableName);
                groupSQL.append(" \r\n (FID,FCustomerID");
                groupSQL.append(" \r\n ,FBaseQty");
                groupSQL.append(",FActualCost");
                groupSQL.append(",FUnitStandardCost");
                groupSQL.append(",FStandardCost");
                groupSQL.append(",FTotalFlag)");
                groupSQL.append(" \r\n SELECT ");
                groupSQL.append(" \r\n newbosid('88888888')");
                groupSQL.append(" \r\n ,'zzzzzzzz' ");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FBaseQty),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FActualCost),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FUnitStandardCost),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FStandardCost),31,7)");
                groupSQL.append(" \r\n ,'TotalAll'");
                groupSQL.append(" \r\n  from " + tableName);
                groupSQL.append(" \r\n  where FTotalFlag<>'Total'");
                break;
            }
            case 7: {
                groupSQL.append("INSERT INTO " + tableName);
                groupSQL.append(" \r\n (FID,FPersonID");
                groupSQL.append(" \r\n ,FBaseQty");
                groupSQL.append(",FActualCost");
                groupSQL.append(",FUnitStandardCost");
                groupSQL.append(",FStandardCost");
                groupSQL.append(",FTotalFlag)");
                groupSQL.append(" \r\n SELECT ");
                groupSQL.append(" \r\n newbosid('88888888')");
                groupSQL.append(" \r\n ,'zzzzzzzzz' ");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FBaseQty),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FActualCost),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FUnitStandardCost),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FStandardCost),31,7)");
                groupSQL.append(" \r\n ,'TotalAll'");
                groupSQL.append(" \r\n  from " + tableName);
                groupSQL.append(" \r\n  where FTotalFlag<>'Total'");
                break;
            }
            case 8: {
                groupSQL.append("INSERT INTO " + tableName);
                groupSQL.append(" \r\n (FID,FMaterialID");
                groupSQL.append(" \r\n ,FBaseQty");
                groupSQL.append(",FActualCost");
                groupSQL.append(",FUnitStandardCost");
                groupSQL.append(",FStandardCost");
                groupSQL.append(",FTotalFlag)");
                groupSQL.append(" \r\n SELECT ");
                groupSQL.append(" \r\n newbosid('88888888')");
                groupSQL.append(" \r\n ,'zzzzzzzz' ");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FBaseQty),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FActualCost),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FUnitStandardCost),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FStandardCost),31,7)");
                groupSQL.append(" \r\n ,'TotalAll'");
                groupSQL.append(" \r\n  from " + tableName);
                groupSQL.append(" \r\n  where FTotalFlag<>'Total'");
                break;
            }
            case 9: {
                groupSQL.append("INSERT INTO " + tableName);
                groupSQL.append(" \r\n (FID,FCompanyOrgUnitID");
                groupSQL.append(" \r\n ,FBaseQty");
                groupSQL.append(",FActualCost");
                groupSQL.append(",FUnitStandardCost");
                groupSQL.append(",FStandardCost");
                groupSQL.append(",FTotalFlag)");
                groupSQL.append(" \r\n SELECT ");
                groupSQL.append(" \r\n newbosid('88888888')");
                groupSQL.append(" \r\n ,'zzzzzzzz' ");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FBaseQty),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FActualCost),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FUnitStandardCost),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FStandardCost),31,7)");
                groupSQL.append(" \r\n ,'TotalAll'");
                groupSQL.append(" \r\n  from " + tableName);
                groupSQL.append(" \r\n  where FTotalFlag<>'Total'");
                break;
            }
            case 10: {
                groupSQL.append("INSERT INTO " + tableName);
                groupSQL.append(" \r\n (FID,FStorageOrgUnitID");
                groupSQL.append(" \r\n ,FBaseQty");
                groupSQL.append(",FActualCost");
                groupSQL.append(",FUnitStandardCost");
                groupSQL.append(",FStandardCost");
                groupSQL.append(",FTotalFlag)");
                groupSQL.append(" \r\n SELECT ");
                groupSQL.append(" \r\n newbosid('88888888')");
                groupSQL.append(" \r\n ,'zzzzzzzz' ");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FBaseQty),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FActualCost),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FUnitStandardCost),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FStandardCost),31,7)");
                groupSQL.append(" \r\n ,'TotalAll'");
                groupSQL.append(" \r\n  from " + tableName);
                groupSQL.append(" \r\n  where FTotalFlag<>'Total'");
                break;
            }
            case 11: {
                groupSQL.append("INSERT INTO " + tableName);
                groupSQL.append(" \r\n (FID,FWarehouseID");
                groupSQL.append(" \r\n ,FBaseQty");
                groupSQL.append(",FActualCost");
                groupSQL.append(",FUnitStandardCost");
                groupSQL.append(",FStandardCost");
                groupSQL.append(",FTotalFlag)");
                groupSQL.append(" \r\n SELECT ");
                groupSQL.append(" \r\n newbosid('88888888')");
                groupSQL.append(" \r\n ,'zzzzzzzz' ");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FBaseQty),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FActualCost),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FUnitStandardCost),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FStandardCost),31,7)");
                groupSQL.append(" \r\n ,'TotalAll'");
                groupSQL.append(" \r\n  from " + tableName);
                groupSQL.append(" \r\n  where FTotalFlag<>'Total'");
            }
        }
        return groupSQL.toString();
    }

    private void setRPTData(SqlParams sqlParams, RptParams params) {
        int i;
        int count = sqlParams.size() + 1;
        if (params.getObject("materialFrom") != null) {
            if (params.getObject("materialFrom") instanceof Object[]) {
                Object[] materials = (Object[])params.getObject("materialFrom");
                if (materials.length == 1) {
                    sqlParams.setString(count++, ((MaterialInfo)materials[0]).getNumber());
                } else {
                    for (i = 0; i < materials.length; ++i) {
                        sqlParams.setString(count++, ((MaterialInfo)materials[i]).getNumber());
                    }
                }
            } else {
                sqlParams.setString(count++, params.getObject("materialFrom").toString());
            }
        }
        if (params.getObject("materialTo") != null) {
            sqlParams.setString(count++, params.getString("materialTo"));
        }
        if (params.getObject("CustomerFrom") != null) {
            if (params.getObject("CustomerFrom") instanceof Object[]) {
                Object[] customers = (Object[])params.getObject("CustomerFrom");
                if (customers.length == 1) {
                    sqlParams.setString(count++, ((CustomerInfo)customers[0]).getNumber());
                } else {
                    for (i = 0; i < customers.length; ++i) {
                        sqlParams.setString(count++, ((CustomerInfo)customers[i]).getNumber());
                    }
                }
            } else if (params.getObject("CustomerFrom") instanceof CustomerInfo) {
                sqlParams.setString(count++, ((CustomerInfo)params.getObject("CustomerFrom")).getNumber());
            } else {
                sqlParams.setString(count++, params.getObject("CustomerFrom").toString());
            }
        }
        if (params.getString("CustomerTo") != null) {
            sqlParams.setString(count++, params.getString("CustomerTo"));
        }
        if (params.getString("SaleGroupFrom") != null) {
            sqlParams.setString(count++, params.getString("SaleGroupFrom"));
        }
        if (params.getString("SaleGroupTo") != null) {
            sqlParams.setString(count++, params.getString("SaleGroupTo"));
        }
        if (params.getObject("SalePersonFrom") != null) {
            if (params.getObject("SalePersonFrom") instanceof Object[]) {
                Object[] salePersons = (Object[])params.getObject("SalePersonFrom");
                if (salePersons.length == 1) {
                    sqlParams.setString(count++, ((PersonInfo)salePersons[0]).getNumber());
                } else {
                    for (i = 0; i < salePersons.length; ++i) {
                        sqlParams.setString(count++, ((PersonInfo)salePersons[i]).getNumber());
                    }
                }
            } else {
                sqlParams.setString(count++, params.getObject("SalePersonFrom").toString());
            }
        }
        if (params.getString("SalePersonTo") != null) {
            sqlParams.setString(count++, params.getString("SalePersonTo"));
        }
        if (params.getString("DeptFrom") != null) {
            sqlParams.setString(count++, params.getString("DeptFrom"));
        }
        if (params.getString("DeptTo") != null) {
            sqlParams.setString(count++, params.getString("DeptTo"));
        }
        if (params.getString("WarehouseFrom") != null) {
            sqlParams.setString(count++, params.getString("WarehouseFrom"));
        }
        if (params.getString("WarehouseTo") != null) {
            sqlParams.setString(count++, params.getString("WarehouseTo"));
        }
    }

    private String getQueryStr(RptParams params, String aliasName, StringBuffer purBuffer, Context ctx) throws EASBizException, BOSException {
        int i;
        Object[] obj;
        StringBuffer queryStr = new StringBuffer();
        String bd = null;
        String ed = null;
        bd = params.getString("dateStart");
        ed = params.getString("dateEnd");
        SaleReportBillStatusEnum billStatus = SaleReportBillStatusEnum.getEnum(new Integer(params.getString("billStatus")));
        queryStr.append("\r\n where 1 = 1 ");
        if (billStatus != SaleReportBillStatusEnum.cal) {
            queryStr.append(" and ");
            queryStr.append(aliasName + ".FBizDate  >= {" + bd + "} and " + aliasName + ".FBizDate <= {" + ed.substring(0, 10) + " 23:59:59}");
        }
        queryStr.append(" and (");
        queryStr.append(aliasName + ".FBaseStatus =4 or " + aliasName + ".FBaseStatus =2 ) ");
        queryStr.append(" and (");
        queryStr.append(aliasName + ".FTransactionTypeID not in ( ");
        queryStr.append(" SELECT transType.FID FROM T_SCM_TransactionType transType WHERE");
        queryStr.append(" transType.FRITypeID = '").append(RecIssueTypeConstant.CONSIGNRT_RITYPEID).append("'");
        queryStr.append(" or transType.FRITypeID = '").append(RecIssueTypeConstant.CONSIGNOUT_RITYPEID).append("')) ");
        if (params.getObject("materialFrom") != null) {
            if (params.getObject("materialFrom") instanceof Object[]) {
                obj = (Object[])params.getObject("materialFrom");
                if (obj.length == 1) {
                    queryStr.append(" and material.FNumber >= ? ");
                } else {
                    queryStr.append(" and material.FNumber in (?");
                    for (i = 1; i < obj.length; ++i) {
                        queryStr.append(",?");
                    }
                    queryStr.append(")");
                }
            } else {
                queryStr.append(" and material.FNumber >= ? ");
            }
            if (purBuffer.toString().indexOf("T_BD_Material") == -1) {
                purBuffer.append("\r\n inner join T_BD_Material material ");
                purBuffer.append(" on material.fid = ENTRY.FMaterialID ");
            }
        }
        if (params.getString("materialTo") != null) {
            queryStr.append(" and material.FNumber <= ? ");
            if (purBuffer.toString().indexOf("T_BD_Material") == -1) {
                purBuffer.append("\r\n inner join T_BD_Material material ");
                purBuffer.append(" on material.fid = ENTRY.FMaterialID ");
            }
        }
        if (params.getObject("CustomerFrom") != null) {
            if (params.getObject("CustomerFrom") instanceof Object[]) {
                obj = (Object[])params.getObject("CustomerFrom");
                if (obj.length == 1) {
                    queryStr.append(" and Customer.FNumber >= ? ");
                } else {
                    queryStr.append(" and Customer.FNumber in (?");
                    for (i = 1; i < obj.length; ++i) {
                        queryStr.append(",?");
                    }
                    queryStr.append(")");
                }
            } else {
                queryStr.append(" and Customer.FNumber >= ? ");
            }
            if (purBuffer.toString().indexOf("T_BD_Customer") == -1) {
                purBuffer.append("\r\n INNER join T_BD_Customer Customer ");
                purBuffer.append(" on Customer.fid = SaleIssueBill.FCustomerID");
            }
        }
        if (params.getString("CustomerTo") != null) {
            queryStr.append(" and Customer.FNumber <= ? ");
            if (purBuffer.toString().indexOf("T_BD_Customer") == -1) {
                purBuffer.append("\r\n inner join T_BD_Customer Customer ");
                purBuffer.append(" on Customer.fid = SaleIssueBill.FCustomerID");
            }
        }
        if (params.getString("SaleGroupFrom") != null) {
            queryStr.append(" and SALEGROUP.FNumber >= ? ");
            if (purBuffer.toString().indexOf("T_BD_SaleGroup") == -1) {
                purBuffer.append("\r\n INNER JOIN T_BD_SaleGroup AS SALEGROUP ");
                purBuffer.append(" ON ENTRY.FSaleGroupID = SALEGROUP.FID ");
            }
        }
        if (params.getString("SaleGroupTo") != null) {
            queryStr.append(" and SALEGROUP.FNumber <= ? ");
            if (purBuffer.toString().indexOf("T_BD_SaleGroup") == -1) {
                purBuffer.append("\r\n INNER JOIN T_BD_SaleGroup AS SALEGROUP  ");
                purBuffer.append(" ON ENTRY.FSaleGroupID = SALEGROUP.FID ");
            }
        }
        if (params.getObject("SalePersonFrom") != null) {
            if (params.getObject("SalePersonFrom") instanceof Object[]) {
                obj = (Object[])params.getObject("SalePersonFrom");
                if (obj.length == 1) {
                    queryStr.append(" and PERSON.FNumber >= ? ");
                } else {
                    queryStr.append(" and PERSON.FNumber in (?");
                    for (i = 1; i < obj.length; ++i) {
                        queryStr.append(",?");
                    }
                    queryStr.append(")");
                }
            } else {
                queryStr.append(" and PERSON.FNumber >= ? ");
            }
            if (purBuffer.toString().indexOf("T_BD_Person") == -1) {
                purBuffer.append("\r\n INNER JOIN T_BD_Person AS PERSON ");
                purBuffer.append(" ON ENTRY.FSalePersonID = PERSON.FID ");
            }
        }
        if (params.getString("SalePersonTo") != null) {
            queryStr.append(" and PERSON.FNumber <= ? ");
            if (purBuffer.toString().indexOf("T_BD_Person") == -1) {
                purBuffer.append("\r\n INNER JOIN T_BD_Person AS PERSON ");
                purBuffer.append(" ON ENTRY.FSalePersonID = PERSON.FID ");
            }
        }
        if (params.getString("DeptFrom") != null) {
            queryStr.append(" and adminOrg.FNumber >= ? ");
            if (purBuffer.toString().indexOf("T_ORG_Admin") == -1) {
                purBuffer.append("\r\n INNER JOIN T_ORG_Admin AS adminOrg ");
                purBuffer.append(" ON SaleIssueBill.FAdminOrgUnitID = adminOrg.FID ");
            }
        }
        if (params.getString("DeptTo") != null) {
            queryStr.append(" and adminOrg.FNumber <= ? ");
            if (purBuffer.toString().indexOf("T_ORG_Admin") == -1) {
                purBuffer.append("\r\n INNER JOIN T_ORG_Admin AS adminOrg ");
                purBuffer.append(" ON SaleIssueBill.FAdminOrgUnitID = adminOrg.FID ");
            }
        }
        if (params.getString("WarehouseFrom") != null) {
            queryStr.append(" and Warehouse.FNumber >= ? ");
            if (purBuffer.toString().indexOf("T_DB_WAREHOUSE") == -1) {
                purBuffer.append("\r\n INNER JOIN T_DB_WAREHOUSE AS Warehouse ");
                purBuffer.append(" ON ENTRY.FWarehouseID = Warehouse.FID ");
            }
        }
        if (params.getString("WarehouseTo") != null) {
            queryStr.append(" and Warehouse.FNumber <= ? ");
            if (purBuffer.toString().indexOf("T_DB_WAREHOUSE") == -1) {
                purBuffer.append("\r\n INNER JOIN T_DB_WAREHOUSE AS Warehouse ");
                purBuffer.append(" ON ENTRY.FWarehouseID = Warehouse.FID ");
            }
        }
        if (params.getBoolean("AuxiliaryProperties") && purBuffer.toString().indexOf("T_BD_AsstAttrValue") == -1) {
            purBuffer.append("\r\n LEFT OUTER JOIN T_BD_AsstAttrValue AS assistProperty");
            purBuffer.append(" ON ENTRY.FAssistPropertyID = assistProperty.FID ");
        }
        if (params.getBoolean("ckBxShowMShortName")) {
            String shortNameTo;
            String shortNameFrom = params.getString("shortNameFrom");
            if (!StringUtil.isEmpty((String)shortNameFrom)) {
                if (shortNameFrom.indexOf("'") != -1) {
                    shortNameFrom = shortNameFrom.replaceAll("'", "''");
                }
                queryStr.append(" and material.FShortName >= '").append(shortNameFrom.trim()).append("' ");
            }
            if (!StringUtil.isEmpty((String)(shortNameTo = params.getString("shortNameTo")))) {
                if (shortNameTo.indexOf("'") != -1) {
                    shortNameTo = shortNameTo.replaceAll("'", "''");
                }
                queryStr.append(" and material.FShortName <= '").append(shortNameTo.trim()).append("' ");
            }
            if (!(StringUtil.isEmpty((String)shortNameFrom) && StringUtil.isEmpty((String)shortNameTo) || purBuffer.toString().indexOf("T_BD_Material") != -1)) {
                purBuffer.append("\r\n inner join T_BD_Material material ");
                purBuffer.append(" on material.fid = ENTRY.FMaterialID ");
            }
        }
        return queryStr.toString();
    }

    private String getQuery(RptParams params, String aliasName, StringBuffer purBuffer, Context ctx) throws EASBizException, BOSException {
        int i;
        Object[] obj;
        StringBuffer queryStr = new StringBuffer();
        String bd = null;
        String ed = null;
        bd = params.getString("dateStart");
        ed = params.getString("dateEnd");
        queryStr.append("\r\n where ");
        queryStr.append(" costAdjustBill.FIssueType=0 and ");
        queryStr.append("costAdjustBill.FCalculateKind=1 and ");
        queryStr.append(aliasName + ".FBizDate  >= {" + bd + "} and " + aliasName + ".FBizDate <= {" + ed.substring(0, 10) + " 23:59:59}");
        queryStr.append(" and (");
        queryStr.append(aliasName + ".FBaseStatus =4 or " + aliasName + ".FBaseStatus =2 ) ");
        if (params.getObject("materialFrom") != null) {
            if (params.getObject("materialFrom") instanceof Object[]) {
                obj = (Object[])params.getObject("materialFrom");
                if (obj.length == 1) {
                    queryStr.append(" and material.FNumber >= ? ");
                } else {
                    queryStr.append(" and material.FNumber in (?");
                    for (i = 1; i < obj.length; ++i) {
                        queryStr.append(",?");
                    }
                    queryStr.append(")");
                }
            } else {
                queryStr.append(" and material.FNumber >= ? ");
            }
            if (purBuffer.toString().indexOf("T_BD_Material") == -1) {
                purBuffer.append("\r\n inner join T_BD_Material material ");
                purBuffer.append(" on material.fid = ENTRY.FMaterialID ");
            }
        }
        if (params.getString("materialTo") != null) {
            queryStr.append(" and material.FNumber <= ? ");
            if (purBuffer.toString().indexOf("T_BD_Material") == -1) {
                purBuffer.append("\r\n inner join T_BD_Material material ");
                purBuffer.append(" on material.fid = ENTRY.FMaterialID ");
            }
        }
        if (params.getObject("CustomerFrom") != null) {
            if (params.getObject("CustomerFrom") instanceof Object[]) {
                obj = (Object[])params.getObject("CustomerFrom");
                if (obj.length == 1) {
                    queryStr.append(" and Customer.FNumber >= ? ");
                } else {
                    queryStr.append(" and Customer.FNumber in (?");
                    for (i = 1; i < obj.length; ++i) {
                        queryStr.append(",?");
                    }
                    queryStr.append(")");
                }
            } else {
                queryStr.append(" and Customer.FNumber >= ? ");
            }
            if (purBuffer.toString().indexOf("T_BD_Customer") == -1) {
                purBuffer.append("\r\n INNER join T_BD_Customer Customer ");
                purBuffer.append(" on Customer.fid = costAdjustBill.FCustomerID");
            }
        }
        if (params.getString("CustomerTo") != null) {
            queryStr.append(" and Customer.FNumber <= ? ");
            if (purBuffer.toString().indexOf("T_BD_Customer") == -1) {
                purBuffer.append("\r\n inner join T_BD_Customer Customer ");
                purBuffer.append(" on Customer.fid = costAdjustBill.FCustomerID");
            }
        }
        if (params.getString("SaleGroupFrom") != null) {
            queryStr.append(" and SALEGROUP.FNumber >= ? ");
            if (purBuffer.toString().indexOf("T_BD_SaleGroup") == -1) {
                purBuffer.append("\r\n INNER JOIN T_BD_SaleGroup AS SALEGROUP ");
                purBuffer.append(" ON ENTRY.FSaleGroupID = SALEGROUP.FID ");
            }
        }
        if (params.getString("SaleGroupTo") != null) {
            queryStr.append(" and SALEGROUP.FNumber <= ? ");
            if (purBuffer.toString().indexOf("T_BD_SaleGroup") == -1) {
                purBuffer.append("\r\n INNER JOIN T_BD_SaleGroup AS SALEGROUP  ");
                purBuffer.append(" ON ENTRY.FSaleGroupID = SALEGROUP.FID ");
            }
        }
        if (params.getString("SalePersonFrom") != null) {
            queryStr.append(" and PERSON.FNumber >= ? ");
            if (purBuffer.toString().indexOf("T_BD_Person") == -1) {
                purBuffer.append("\r\n INNER JOIN T_BD_Person AS PERSON ");
                purBuffer.append(" ON ENTRY.FSalePersonID = PERSON.FID ");
            }
        }
        if (params.getString("SalePersonTo") != null) {
            queryStr.append(" and PERSON.FNumber <= ? ");
            if (purBuffer.toString().indexOf("T_BD_Person") == -1) {
                purBuffer.append("\r\n INNER JOIN T_BD_Person AS PERSON ");
                purBuffer.append(" ON ENTRY.FSalePersonID = PERSON.FID ");
            }
        }
        if (params.getString("DeptFrom") != null) {
            queryStr.append(" and adminOrg.FNumber >= ? ");
            if (purBuffer.toString().indexOf("T_ORG_Admin") == -1) {
                purBuffer.append("\r\n INNER JOIN T_ORG_Admin AS adminOrg ");
                purBuffer.append(" ON costAdjustBill.FAdminOrgUnitID = adminOrg.FID ");
            }
        }
        if (params.getString("DeptTo") != null) {
            queryStr.append(" and adminOrg.FNumber <= ? ");
            if (purBuffer.toString().indexOf("T_ORG_Admin") == -1) {
                purBuffer.append("\r\n INNER JOIN T_ORG_Admin AS adminOrg ");
                purBuffer.append(" ON costAdjustBill.FAdminOrgUnitID = adminOrg.FID ");
            }
        }
        if (params.getString("WarehouseFrom") != null) {
            queryStr.append(" and Warehouse.FNumber >= ? ");
            if (purBuffer.toString().indexOf("T_DB_WAREHOUSE") == -1) {
                purBuffer.append("\r\n INNER JOIN T_DB_WAREHOUSE AS Warehouse ");
                purBuffer.append(" ON ENTRY.FWarehouseID = Warehouse.FID ");
            }
        }
        if (params.getString("WarehouseTo") != null) {
            queryStr.append(" and Warehouse.FNumber <= ? ");
            if (purBuffer.toString().indexOf("T_DB_WAREHOUSE") == -1) {
                purBuffer.append("\r\n INNER JOIN T_DB_WAREHOUSE AS Warehouse ");
                purBuffer.append(" ON ENTRY.FWarehouseID = Warehouse.FID ");
            }
        }
        if (params.getBoolean("AuxiliaryProperties") && purBuffer.toString().indexOf("T_BD_AsstAttrValue") == -1) {
            purBuffer.append("\r\n LEFT OUTER JOIN T_BD_AsstAttrValue AS assistProperty");
            purBuffer.append(" ON ENTRY.FAssistPropertyID = assistProperty.FID ");
        }
        if (params.getBoolean("ckBxShowMShortName")) {
            String shortNameTo;
            String shortNameFrom = params.getString("shortNameFrom");
            if (!StringUtil.isEmpty((String)shortNameFrom)) {
                if (shortNameFrom.indexOf("'") != -1) {
                    shortNameFrom = shortNameFrom.replaceAll("'", "''");
                }
                queryStr.append(" and material.FShortName >= '").append(shortNameFrom.trim()).append("' ");
            }
            if (!StringUtil.isEmpty((String)(shortNameTo = params.getString("shortNameTo")))) {
                if (shortNameTo.indexOf("'") != -1) {
                    shortNameTo = shortNameTo.replaceAll("'", "''");
                }
                queryStr.append(" and material.FShortName <= '").append(shortNameTo.trim()).append("' ");
            }
            if (!(StringUtil.isEmpty((String)shortNameFrom) && StringUtil.isEmpty((String)shortNameTo) || purBuffer.toString().indexOf("T_BD_Material") != -1)) {
                purBuffer.append("\r\n inner join T_BD_Material material ");
                purBuffer.append(" on material.fid = ENTRY.FMaterialID ");
            }
        }
        return queryStr.toString();
    }

    private RptTableHeader setTableHead(RptTableHeader header, RptParams params, Context ctx) {
        String bizDate = this.getServerResource("BillDate", ctx);
        String billNumber = this.getServerResource("BillNumber", ctx);
        String billType = this.getServerResource("BizType", ctx);
        String saleOrgUnitName = this.getServerResource("SaleOrg", ctx);
        String companyOrgUnitName = this.getServerResource("CompanyOrg", ctx);
        String storageOrgUnitName = this.getServerResource("StorageOrg", ctx);
        String saleGroupName = this.getServerResource("SaleGroup", ctx);
        String customerName = this.getServerResource("CustomerName", ctx);
        String customerNumber = this.getServerResource("CUSTOMERNUMBER", ctx);
        String personName = this.getServerResource("SalePerson", ctx);
        String warehouseName = this.getServerResource("WarehouseName", ctx);
        String materialNum = this.getServerResource("MaterialNum", ctx);
        String materialName = this.getServerResource("MaterialNam", ctx);
        String materialModel = this.getServerResource("MaterialMod", ctx);
        String AuxiliaryPropertiesName = this.getServerResource("AUXILIARYPROPERTIES", ctx);
        String baseUnitName = this.getServerResource("Unit", ctx);
        String qty = this.getServerResource("Qty", ctx);
        String Price = this.getServerResource("costPrice", ctx);
        String amount = this.getServerResource("costAmount", ctx);
        String unitStanderCost = this.getServerResource("UnitStander_Cost", ctx);
        String standerCost = this.getServerResource("Stander_Cost", ctx);
        String materilShortName = this.getServerResource("MaterialShortName", ctx);
        boolean ckBxShowMShortName = params.getBoolean("ckBxShowMShortName");
        boolean AuxiliaryProperties = params.getBoolean("AuxiliaryProperties");
        Object[][] labels = new Object[1][22];
        String[] cols = new String[22];
        if (ckBxShowMShortName) {
            labels = new Object[1][23];
            cols = new String[23];
            if (AuxiliaryProperties) {
                labels = new Object[1][24];
                cols = new String[24];
            }
        } else if (AuxiliaryProperties) {
            labels = new Object[1][23];
            cols = new String[23];
        }
        int m = 13;
        cols[0] = "FNUMBER";
        cols[1] = "BIZDATE";
        cols[2] = "BILLTYPE";
        cols[3] = "COMPANY_ORGUNIT";
        cols[4] = "STORAGE_ORGUNIT";
        cols[5] = "SALE_ORGUNIT";
        cols[6] = "SALEGROUP_NAME";
        cols[7] = "CUSTOMER_NAME";
        cols[8] = "CUSTOMER_NUMBER";
        cols[9] = "PERSON_NAME";
        cols[10] = "WAREHOSE_NAME";
        cols[11] = "MATERIAL_NUMBER";
        cols[12] = "MATERIAL_NAME";
        if (ckBxShowMShortName) {
            cols[m] = "MATERIAL_SHORTNAME";
            ++m;
        }
        cols[m] = "MATERIAL_MODEL";
        ++m;
        if (AuxiliaryProperties) {
            cols[m] = "AuxiliaryProperties_NAME";
            ++m;
        }
        cols[m] = "BASEUNIT_NAME";
        cols[++m] = "QTY";
        cols[++m] = "PRICE";
        cols[++m] = "AMOUNT";
        cols[++m] = "UNITSTANDARCOST";
        cols[++m] = "STANDARCOST";
        cols[++m] = "TOTALFLAG";
        cols[++m] = "FID";
        m = 13;
        this.setHeaderColumns(header, cols, params);
        labels[0][0] = billNumber;
        labels[0][1] = bizDate;
        labels[0][2] = billType;
        labels[0][3] = companyOrgUnitName;
        labels[0][4] = storageOrgUnitName;
        labels[0][5] = saleOrgUnitName;
        labels[0][6] = saleGroupName;
        labels[0][7] = customerName;
        labels[0][8] = customerNumber;
        labels[0][9] = personName;
        labels[0][10] = warehouseName;
        labels[0][11] = materialNum;
        labels[0][12] = materialName;
        if (ckBxShowMShortName) {
            labels[0][m] = materilShortName;
            ++m;
        }
        labels[0][m] = materialModel;
        ++m;
        if (AuxiliaryProperties) {
            labels[0][m] = AuxiliaryPropertiesName;
            ++m;
        }
        labels[0][m] = baseUnitName;
        labels[0][++m] = qty;
        labels[0][++m] = Price;
        labels[0][++m] = amount;
        labels[0][++m] = unitStanderCost;
        labels[0][++m] = standerCost;
        labels[0][++m] = "TotalFlag";
        labels[0][++m] = "FID";
        header.setLabels(labels, true);
        return header;
    }

    private void setHeaderColumns(RptTableHeader header, String[] columns, RptParams params) {
        String prcFormat = SaleUtil.getFormatPattern(4, true);
        String dateFormat = RptCellFormatter.getDateFormat((String)"yyyy-MM-dd");
        RptTableColumn col = null;
        for (int i = 0; i < columns.length; ++i) {
            col = new RptTableColumn(columns[i]);
            if (i == 1) {
                col.setFormatPattern(dateFormat);
            }
            if (params.getBoolean("ckBxShowMShortName")) {
                if (i >= 16 || i == 20) {
                    col.setWidth(-1);
                    col.setWidth(120);
                    col.setAligment(2);
                    col.setFormatPattern(prcFormat);
                }
                if (i == 21 || i == 22) {
                    col.setWidth(-1);
                    col.setHided(true);
                }
            } else {
                if (i >= 15 || i == 19) {
                    col.setWidth(-1);
                    col.setWidth(120);
                    col.setAligment(2);
                    col.setFormatPattern(prcFormat);
                }
                if (i == 20 || i == 21) {
                    col.setWidth(-1);
                    col.setHided(true);
                }
            }
            header.addColumn(col);
        }
    }

    protected String getOrgListId(Object[] infos) {
        StringBuffer OrgunitId = new StringBuffer();
        if (null == infos) {
            OrgunitId.setLength(0);
            return OrgunitId.toString();
        }
        int n = infos.length;
        for (int i = 0; i < n; ++i) {
            if (n > 0) {
                OrgunitId.append(",");
            }
            OrgunitId.append("'").append(((FullOrgUnitInfo)infos[i]).getId().toString()).append("'");
        }
        if (OrgunitId.length() <= 0) {
            return "'xxx_xxx'";
        }
        String orgunitListId = OrgunitId.toString().substring(1, OrgunitId.toString().length());
        return orgunitListId;
    }

    protected String getCompanyOrgListId(Object[] companyColl) {
        StringBuffer companyOrgunitId = new StringBuffer();
        if (null == companyColl || companyColl.length == 0) {
            companyOrgunitId.setLength(0);
            return companyOrgunitId.toString();
        }
        int n = companyColl.length;
        for (int i = 0; i < n; ++i) {
            if (companyColl[i] == null) continue;
            companyOrgunitId.append("'").append(((CompanyOrgUnitInfo)companyColl[i]).getId().toString()).append("',");
        }
        if (companyOrgunitId.length() <= 0) {
            return "'xxx_xxx'";
        }
        String orgunitListId = companyOrgunitId.deleteCharAt(companyOrgunitId.toString().length() - 1).toString();
        return orgunitListId;
    }

    protected String getStorageOrgListId(StorageOrgUnitCollection storageColl) {
        StringBuffer storageOrgunitId = new StringBuffer();
        if (null == storageColl || storageColl.size() == 0) {
            storageOrgunitId.setLength(0);
            return storageOrgunitId.toString();
        }
        int n = storageColl.size();
        for (int i = 0; i < n; ++i) {
            if (storageColl.get(i) == null) continue;
            storageOrgunitId.append("'").append(storageColl.get(i).getId().toString()).append("',");
        }
        if (storageOrgunitId.length() <= 0) {
            return "'xxx_xxx'";
        }
        String orgunitListId = storageOrgunitId.deleteCharAt(storageOrgunitId.toString().length() - 1).toString();
        return orgunitListId;
    }

    protected String getSaleOrgListId(SaleOrgUnitCollection saleColl) {
        StringBuffer saleOrgunitId = new StringBuffer();
        if (null == saleColl || saleColl.size() == 0) {
            saleOrgunitId.setLength(0);
            return saleOrgunitId.toString();
        }
        int n = saleColl.size();
        for (int i = 0; i < n; ++i) {
            if (saleColl.get(i) == null) continue;
            saleOrgunitId.append("'").append(saleColl.get(i).getId().toString()).append("',");
        }
        if (saleOrgunitId.length() <= 0) {
            return "'xxx_xxx'";
        }
        String orgunitListId = saleOrgunitId.deleteCharAt(saleOrgunitId.toString().length() - 1).toString();
        return orgunitListId;
    }

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        String local_lan = ctx.getLocale().getLanguage();
        StringBuffer sqlbf = new StringBuffer();
        boolean ckBxShowMShortName = params.getBoolean("ckBxShowMShortName");
        String shortNameFrom = (String)params.getObject("shortNameFrom");
        String shortNameTo = (String)params.getObject("shortNameTo");
        String tempTable = params.getString("TempTableName");
        sqlbf.append(" select TEMP.FNUMBER BILLNUMBER,TEMP.FBIZDATE BIZDATE");
        sqlbf.append(" \r\n ,BizType.FNAME_" + local_lan + " BIZTYPENAME");
        sqlbf.append(" \r\n ,COMPANYORGUNIT.FNAME_" + local_lan + " COMPANYORGNAME");
        sqlbf.append(" \r\n ,STORAGEORGUNIT.FNAME_" + local_lan + " STORAGEORGNAME");
        sqlbf.append(" \r\n ,org.FNAME_" + local_lan + " SALEORGNAME");
        sqlbf.append(" \r\n ,SaleGroup.FNAME_" + local_lan + " SALEGROUPNAME");
        sqlbf.append("  \r\n ,Customer.FNAME_" + local_lan + " CUSTOMERNAME, Customer.FNUMBER CUSTOMERNUMBER ");
        sqlbf.append(" \r\n ,Person.FNAME_" + local_lan + " PERSONNAME");
        sqlbf.append(" \r\n ,Warehouse.FNAME_" + local_lan + " WAREHOUSENAME");
        sqlbf.append(" \r\n ,MAT.FNUMBER MATNUMBER,MAT.FNAME_");
        sqlbf.append(local_lan + " MATNAME,");
        sqlbf.append(ckBxShowMShortName ? "MAT.FSHORTNAME SHORTNAME," : " ");
        sqlbf.append("MAT.FMODEL MATMODEL");
        if (params.getBoolean("AuxiliaryProperties")) {
            sqlbf.append("\r\n,assistProperty.FName_" + local_lan + " AuxiliaryProperties");
        }
        sqlbf.append(" \r\n ,Unit.FNAME_" + local_lan + " UNITNAME");
        sqlbf.append(" \r\n ,Temp.FBaseQty QTY");
        sqlbf.append(" \r\n ,TEMP.FPrice RPRICE");
        sqlbf.append(" \r\n ,TEMP.FActualCost AMOUNNT");
        sqlbf.append(" \r\n ,TEMP.FUnitStandardCost UNITSTANDERCOST");
        sqlbf.append(" \r\n ,TEMP.FStandardCost STANDERCOST");
        sqlbf.append(" \r\n ,TEMP.FTotalFlag TOTALFLAG");
        sqlbf.append(" \r\n ,TEMP.FID FID");
        sqlbf.append(" \r\n FROM  " + tempTable + " AS TEMP ");
        sqlbf.append(" \r\n LEFT OUTER JOIN T_BD_MATERIAL MAT ");
        sqlbf.append(" ON TEMP.FMATERIALID = MAT.FID ");
        sqlbf.append(" \r\n LEFT OUTER JOIN T_ORG_Company AS COMPANYORGUNIT");
        sqlbf.append(" ON TEMP.FCompanyOrgUnitID = COMPANYORGUNIT.FID ");
        sqlbf.append(" \r\n LEFT OUTER JOIN T_ORG_Storage AS STORAGEORGUNIT");
        sqlbf.append(" ON TEMP.FStorageOrgUnitID = STORAGEORGUNIT.FID ");
        sqlbf.append(" \r\n LEFT OUTER JOIN T_ORG_Sale AS org ");
        sqlbf.append(" ON TEMP.FSaleOrgUnitID = org.FID ");
        sqlbf.append(" \r\n LEFT OUTER JOIN T_BD_Customer AS CUSTOMER");
        sqlbf.append(" ON TEMP.FCustomerID = CUSTOMER.FID ");
        sqlbf.append(" \r\n LEFT OUTER JOIN T_BD_SaleGroup AS SaleGroup");
        sqlbf.append(" ON TEMP.FSaleGroupID = SaleGroup.FID ");
        sqlbf.append(" \r\n LEFT OUTER JOIN T_BD_Person AS PERSON");
        sqlbf.append(" ON TEMP.FPersonId = PERSON.FID ");
        if (params.getBoolean("AuxiliaryProperties")) {
            sqlbf.append("\r\n LEFT OUTER JOIN T_BD_AsstAttrValue as assistProperty");
            sqlbf.append(" ON TEMP.FAssistPropertyID=assistProperty.FID");
        }
        sqlbf.append(" \r\n LEFT OUTER JOIN T_BD_MeasureUnit AS UNIT");
        sqlbf.append(" ON TEMP.FBaseUnitID = UNIT.FID ");
        sqlbf.append(" \r\n LEFT OUTER JOIN T_DB_WAREHOUSE AS WAREHOUSE");
        sqlbf.append(" ON TEMP.FWarehouseID = WAREHOUSE.FID ");
        sqlbf.append(" \r\n LEFT OUTER JOIN T_SCM_BizType AS BizType");
        sqlbf.append(" ON TEMP.FBizTypeID = BizType.FID ");
        this.groupBy = new Integer(params.getString("CombOrderCol"));
        boolean isSQLServer = false;
        isSQLServer = KsqlUtil.isSQLServer((Context)ctx);
        switch (this.groupBy) {
            case 1: {
                sqlbf.append(" order by TEMP.FBizDate, TEMP.FTotalFlag,temp.fnumber, MAT.FNUMBER, Temp.FBaseQty");
                break;
            }
            case 2: {
                sqlbf.append(" order by TEMP.FNUMBER,TEMP.FTotalFlag,MAT.FNUMBER,Temp.FBaseQty");
                break;
            }
            case 3: {
                sqlbf.append(" order by TEMP.FBizTypeID,TEMP.FTotalFlag,temp.fnumber,MAT.FNUMBER,Temp.FBaseQty");
                break;
            }
            case 4: {
                sqlbf.append(" order by TEMP.FSaleOrgUnitID,TEMP.FTotalFlag,temp.fnumber,MAT.FNUMBER,Temp.FBaseQty");
                break;
            }
            case 5: {
                sqlbf.append(" order by TEMP.FSaleGroupID,TEMP.FTotalFlag,temp.fnumber,MAT.FNUMBER,Temp.FBaseQty");
                break;
            }
            case 6: {
                sqlbf.append(" order by TEMP.FCustomerID,TEMP.FTotalFlag,temp.fnumber,MAT.FNUMBER,Temp.FBaseQty");
                break;
            }
            case 7: {
                sqlbf.append(" order by TEMP.FPersonId,TEMP.FTotalFlag,temp.fnumber,MAT.FNUMBER,Temp.FBaseQty");
                break;
            }
            case 8: {
                if (params.getBoolean("AuxiliaryProperties")) {
                    sqlbf.append(" order by TEMP.FMATERIALID,MAT.FName_").append(local_lan).append(",TEMP.FTotalFlag,TEMP.FAssistPropertyID,temp.fnumber,Temp.FBaseQty");
                    break;
                }
                sqlbf.append(" order by TEMP.FMATERIALID,MAT.FName_").append(local_lan).append(",TEMP.FTotalFlag,temp.fnumber,Temp.FBaseQty");
                break;
            }
            case 9: {
                sqlbf.append(" order by TEMP.FCompanyOrgUnitID,TEMP.FTotalFlag,temp.fnumber,MAT.FNUMBER,Temp.FBaseQty");
                break;
            }
            case 10: {
                sqlbf.append(" order by TEMP.FStorageOrgUnitID,TEMP.FTotalFlag,temp.fnumber,MAT.FNUMBER,Temp.FBaseQty");
                break;
            }
            case 11: {
                sqlbf.append(" order by TEMP.FWarehouseID,TEMP.FTotalFlag,temp.fnumber,MAT.FNUMBER,Temp.FBaseQty");
            }
        }
        RptRowSet rs = this.executeQuery(sqlbf.toString(), null, from, len, ctx);
        RptParams pp = new RptParams();
        pp.setObject("rowset", (Object)rs);
        return pp;
    }

    private void executeSQL(Context ctx, String sql) throws BOSException {
        if (sql != null && sql.trim().length() > 0) {
            this.executeUpdate(sql, null, ctx);
        }
    }

    public String getServerResource(String key, Context ctx) {
        return SCMUtils.getResource((String)resClassName, (String)key, (Context)ctx);
    }
}

