/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sd.sale.report.app.AbstractSaleDiscountTotalRptFacadeControllerBean;
import com.kingdee.eas.scm.sd.sale.util.SaleUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import org.apache.log4j.Logger;

public class SaleDiscountTotalRptFacadeControllerBean
extends AbstractSaleDiscountTotalRptFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sd.sale.report.app.SaleDiscountTotalRptFacadeControllerBean");
    private String orgUnitTempTableStr = "OrgTempTable";
    private String leafOrgUnitStr = "leafOrgUnit";
    private String maxLevelStr = "maxLevelStr";
    private int minLevel = 1;
    private static final String resClassName = "com.kingdee.eas.scm.sd.sale.report.SDReportResource";
    private static final String locLan = SysContext.getSysContext().getLocale().getLanguage();
    private static final String sp = "\r\n";
    private int groupBy;

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        this.dropTable(params.getString("tempTable"), ctx);
        this.dropTable(params.getString("OrgTempTable"), ctx);
        this.groupBy = new Integer(params.getString("Classification"));
        String tempTable = this.getTempTableName(this.getServerResource("RPTTempTable", ctx), ctx);
        String orgUnitTempTable = this.getTempTableName(this.getServerResource("ORGUintTempTable", ctx), ctx);
        params.setString("tempTable", tempTable);
        params.setString("OrgTempTable", orgUnitTempTable);
        this.buildOrgTable(ctx, orgUnitTempTable, params);
        this.createTempTableAndInsertData(ctx, tempTable, params);
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            DBUtil.AnalyseTable((Context)ctx, (Connection)conn, (String)tempTable);
            DBUtil.AnalyseTable((Context)ctx, (Connection)conn, (String)orgUnitTempTable);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        this.updateTotal(ctx, tempTable, orgUnitTempTable, params);
        String countSql = "select count(1) cc from " + tempTable;
        RptRowSet rs = this.executeQuery(countSql, null, ctx);
        rs.next();
        int count = rs.getInt(0);
        RptTableHeader header = new RptTableHeader();
        this.setRptHead(header, params, ctx);
        RptParams result = new RptParams();
        result.setString("tempTable", tempTable);
        result.setObject("header", (Object)header);
        result.setInt("verticalCount", count);
        result.setString(this.orgUnitTempTableStr, orgUnitTempTable);
        return result;
    }

    private void buildOrgTable(Context ctx, String orgTempTable, RptParams params) throws BOSException {
        StringBuffer sqlbf = new StringBuffer();
        sqlbf.append("create table " + orgTempTable + " (");
        sqlbf.append("fid varchar(44),");
        sqlbf.append("fname_");
        sqlbf.append(locLan);
        sqlbf.append(" varchar(100),");
        sqlbf.append("fparentid varchar(44),");
        sqlbf.append("flevel int,");
        sqlbf.append("fisleaf int");
        sqlbf.append(")");
        this.executeSQL(ctx, sqlbf.toString());
        Vector<String> v = new Vector<String>();
        int maxLevel = 0;
        Object[] purChaseOrg = (Object[])params.getObject("fullOrgUnit");
        String[] sql = new String[purChaseOrg.length];
        int n = purChaseOrg.length;
        for (int i = 0; i < n; ++i) {
            sqlbf.delete(0, sqlbf.length());
            String fid = ((FullOrgUnitInfo)purChaseOrg[i]).get("id").toString();
            Integer flevel = (Integer)((FullOrgUnitInfo)purChaseOrg[i]).get("level");
            String fname = (String)((FullOrgUnitInfo)purChaseOrg[i]).get("name");
            FullOrgUnitInfo parent = (FullOrgUnitInfo)((FullOrgUnitInfo)purChaseOrg[i]).get("parent");
            Boolean isleaf = (Boolean)((FullOrgUnitInfo)purChaseOrg[i]).get("isleaf");
            int fisleaf = isleaf != false ? 1 : 0;
            if (fisleaf == 1) {
                v.add(fid);
            }
            if (flevel > maxLevel) {
                maxLevel = flevel;
            }
            sqlbf.append("insert into " + orgTempTable + "(");
            sqlbf.append("fid,fname_");
            sqlbf.append(locLan);
            sqlbf.append(",fparentid,flevel,fisleaf) ");
            sqlbf.append("values(");
            sqlbf.append("'" + fid + "',");
            if (fname != null) {
                sqlbf.append("'" + fname + "',");
            } else {
                sqlbf.append("null,");
            }
            if (parent != null) {
                sqlbf.append("'" + parent.getId().toString() + "',");
            } else {
                sqlbf.append("null,");
            }
            sqlbf.append(flevel + ",");
            sqlbf.append(fisleaf + ") ");
            sql[i] = sqlbf.toString();
        }
        this.executeBatchUpdate(ctx, sql);
        params.setObject(this.leafOrgUnitStr, (Object)v.toArray());
        params.setObject(this.maxLevelStr, (Object)new Integer(maxLevel));
    }

    private void createTempTableAndInsertData(Context ctx, String tempTable, RptParams params) throws BOSException, EASBizException {
        String sql = this.getCreateTempTable(ctx, tempTable, params);
        this.executeSQL(ctx, sql);
        SqlParams sqlParams = new SqlParams();
        this.setRPTData(sqlParams, params);
        this.inSertData(params, tempTable, sqlParams, ctx);
    }

    private String getCreateTempTable(Context ctx, String tempTable, RptParams params) {
        StringBuffer createTempTalbeSQL = new StringBuffer();
        this.groupBy = new Integer(params.getString("Classification"));
        switch (this.groupBy) {
            case 1: {
                createTempTalbeSQL.append("CREATE TABLE " + tempTable + "(\r\n");
                createTempTalbeSQL.append("FID Varchar(44) \r\n");
                createTempTalbeSQL.append(",FMaterialID Varchar(44) \r\n");
                createTempTalbeSQL.append(",FSaleOrgID Varchar(44) \r\n");
                createTempTalbeSQL.append(",FBaseUnitID Varchar(44)\r\n");
                createTempTalbeSQL.append(",FBaseQty  Decimal(28,10)\r\n");
                createTempTalbeSQL.append(",FActualPrice  Decimal(28,10)\r\n");
                createTempTalbeSQL.append(",FAmount  Decimal(28,10)\r\n");
                createTempTalbeSQL.append(",FReceiveAmount  Decimal(28,10)\r\n");
                createTempTalbeSQL.append(",FDiscountAmount  Decimal(28,10)\r\n");
                createTempTalbeSQL.append(",FAllSaleAmount  Decimal(28,10)\r\n");
                createTempTalbeSQL.append(",FFlag varchar(44)\r\n");
                createTempTalbeSQL.append(",FLevel int");
                createTempTalbeSQL.append(",FOrderSeq int");
                createTempTalbeSQL.append(");\r\n");
                break;
            }
            case 2: {
                createTempTalbeSQL.append("CREATE TABLE " + tempTable + "(\r\n");
                createTempTalbeSQL.append("FID Varchar(44) \r\n");
                createTempTalbeSQL.append(",FAsstActID Varchar(44) \r\n");
                createTempTalbeSQL.append(",FSaleOrgID Varchar(44) \r\n");
                createTempTalbeSQL.append(",FAmount  Decimal(28,10)\r\n");
                createTempTalbeSQL.append(",FReceiveAmount  Decimal(28,10)\r\n");
                createTempTalbeSQL.append(",FDiscountAmount  Decimal(28,10)\r\n");
                createTempTalbeSQL.append(",FAllSaleAmount  Decimal(28,10)\r\n");
                createTempTalbeSQL.append(",FFlag varchar(44)\r\n");
                createTempTalbeSQL.append(",FLevel int");
                createTempTalbeSQL.append(",FOrderSeq int");
                createTempTalbeSQL.append(");\r\n");
                break;
            }
            case 3: {
                createTempTalbeSQL.append("CREATE TABLE " + tempTable + "(\r\n");
                createTempTalbeSQL.append("FID Varchar(44) \r\n");
                createTempTalbeSQL.append(",FPersonId Varchar(44) \r\n");
                createTempTalbeSQL.append(",FSaleOrgID Varchar(44) \r\n");
                createTempTalbeSQL.append(",FAmount  Decimal(28,10)\r\n");
                createTempTalbeSQL.append(",FReceiveAmount  Decimal(28,10)\r\n");
                createTempTalbeSQL.append(",FDiscountAmount  Decimal(28,10)\r\n");
                createTempTalbeSQL.append(",FAllSaleAmount  Decimal(28,10)\r\n");
                createTempTalbeSQL.append(",FFlag varchar(44)\r\n");
                createTempTalbeSQL.append(",FLevel int");
                createTempTalbeSQL.append(",FOrderSeq int");
                createTempTalbeSQL.append(");\r\n");
                break;
            }
            case 4: {
                createTempTalbeSQL.append("CREATE TABLE " + tempTable + "(\r\n");
                createTempTalbeSQL.append("FID Varchar(44) \r\n");
                createTempTalbeSQL.append(",FSaleGroupID Varchar(44) \r\n");
                createTempTalbeSQL.append(",FSaleOrgID Varchar(44) \r\n");
                createTempTalbeSQL.append(",FAmount  Decimal(28,10)\r\n");
                createTempTalbeSQL.append(",FReceiveAmount  Decimal(28,10)\r\n");
                createTempTalbeSQL.append(",FDiscountAmount  Decimal(28,10)\r\n");
                createTempTalbeSQL.append(",FAllSaleAmount  Decimal(28,10)\r\n");
                createTempTalbeSQL.append(",FFlag varchar(44)\r\n");
                createTempTalbeSQL.append(",FLevel int");
                createTempTalbeSQL.append(",FOrderSeq int");
                createTempTalbeSQL.append(");\r\n");
                break;
            }
            case 5: {
                createTempTalbeSQL.append("CREATE TABLE " + tempTable + "(\r\n");
                createTempTalbeSQL.append("FID Varchar(44) \r\n");
                createTempTalbeSQL.append(",FMaterialID Varchar(44) \r\n");
                createTempTalbeSQL.append(",FMaterialGroupID Varchar(44) \r\n");
                createTempTalbeSQL.append(",FMatGroupLevel int \r\n");
                createTempTalbeSQL.append(",FSaleOrgID Varchar(44) \r\n");
                createTempTalbeSQL.append(",FAmount  Decimal(28,10)\r\n");
                createTempTalbeSQL.append(",FReceiveAmount  Decimal(28,10)\r\n");
                createTempTalbeSQL.append(",FDiscountAmount  Decimal(28,10)\r\n");
                createTempTalbeSQL.append(",FAllSaleAmount  Decimal(28,10)\r\n");
                createTempTalbeSQL.append(",FFlag varchar(44)\r\n");
                createTempTalbeSQL.append(",FLevel int");
                createTempTalbeSQL.append(",FOrderSeq int");
                createTempTalbeSQL.append(");\r\n");
                break;
            }
            case 6: {
                createTempTalbeSQL.append("CREATE TABLE " + tempTable + "(\r\n");
                createTempTalbeSQL.append("FID Varchar(44) \r\n");
                createTempTalbeSQL.append(",FMaterialID Varchar(44) \r\n");
                createTempTalbeSQL.append(",FAsstActID Varchar(44) \r\n");
                createTempTalbeSQL.append(",FSaleOrgID Varchar(44) \r\n");
                createTempTalbeSQL.append(",FAmount  Decimal(28,10)\r\n");
                createTempTalbeSQL.append(",FReceiveAmount  Decimal(28,10)\r\n");
                createTempTalbeSQL.append(",FDiscountAmount  Decimal(28,10)\r\n");
                createTempTalbeSQL.append(",FAllSaleAmount  Decimal(28,10)\r\n");
                createTempTalbeSQL.append(",FFlag varchar(44)\r\n");
                createTempTalbeSQL.append(",FLevel int");
                createTempTalbeSQL.append(",FOrderSeq int");
                createTempTalbeSQL.append(");\r\n");
                break;
            }
            case 7: {
                createTempTalbeSQL.append("CREATE TABLE " + tempTable + "(\r\n");
                createTempTalbeSQL.append("FID Varchar(44) \r\n");
                createTempTalbeSQL.append(",FAsstActID Varchar(44) \r\n");
                createTempTalbeSQL.append(",FMaterialID Varchar(44) \r\n");
                createTempTalbeSQL.append(",FSaleOrgID Varchar(44) \r\n");
                createTempTalbeSQL.append(",FBaseUnitID Varchar(44)\r\n");
                createTempTalbeSQL.append(",FBaseQty  Decimal(28,10)\r\n");
                createTempTalbeSQL.append(",FActualPrice  Decimal(28,10)\r\n");
                createTempTalbeSQL.append(",FAmount  Decimal(28,10)\r\n");
                createTempTalbeSQL.append(",FReceiveAmount  Decimal(28,10)\r\n");
                createTempTalbeSQL.append(",FDiscountAmount  Decimal(28,10)\r\n");
                createTempTalbeSQL.append(",FAllSaleAmount  Decimal(28,10)\r\n");
                createTempTalbeSQL.append(",FFlag varchar(44)\r\n");
                createTempTalbeSQL.append(",FLevel int");
                createTempTalbeSQL.append(",FOrderSeq int");
                createTempTalbeSQL.append(");\r\n");
                break;
            }
            case 8: {
                createTempTalbeSQL.append("CREATE TABLE " + tempTable + "(\r\n");
                createTempTalbeSQL.append("FID Varchar(44) \r\n");
                createTempTalbeSQL.append(",FSaleGroupID Varchar(44) \r\n");
                createTempTalbeSQL.append(",FPersonId Varchar(44) \r\n");
                createTempTalbeSQL.append(",FMaterialID Varchar(44) \r\n");
                createTempTalbeSQL.append(",FSaleOrgID Varchar(44) \r\n");
                createTempTalbeSQL.append(",FBaseUnitID Varchar(44)\r\n");
                createTempTalbeSQL.append(",FBaseQty  Decimal(28,10)\r\n");
                createTempTalbeSQL.append(",FActualPrice  Decimal(28,10)\r\n");
                createTempTalbeSQL.append(",FAmount  Decimal(28,10)\r\n");
                createTempTalbeSQL.append(",FReceiveAmount  Decimal(28,10)\r\n");
                createTempTalbeSQL.append(",FDiscountAmount  Decimal(28,10)\r\n");
                createTempTalbeSQL.append(",FAllSaleAmount  Decimal(28,10)\r\n");
                createTempTalbeSQL.append(",FFlag varchar(44)\r\n");
                createTempTalbeSQL.append(",FLevel int");
                createTempTalbeSQL.append(",FOrderSeq int");
                createTempTalbeSQL.append(");\r\n");
                break;
            }
            case 9: {
                createTempTalbeSQL.append("CREATE TABLE " + tempTable + "(\r\n");
                createTempTalbeSQL.append("FID Varchar(44) \r\n");
                createTempTalbeSQL.append(",FSaleGroupID Varchar(44) \r\n");
                createTempTalbeSQL.append(",FMaterialID Varchar(44) \r\n");
                createTempTalbeSQL.append(",FSaleOrgID Varchar(44) \r\n");
                createTempTalbeSQL.append(",FBaseUnitID Varchar(44)\r\n");
                createTempTalbeSQL.append(",FBaseQty  Decimal(28,10)\r\n");
                createTempTalbeSQL.append(",FActualPrice  Decimal(28,10)\r\n");
                createTempTalbeSQL.append(",FAmount  Decimal(28,10)\r\n");
                createTempTalbeSQL.append(",FReceiveAmount  Decimal(28,10)\r\n");
                createTempTalbeSQL.append(",FDiscountAmount  Decimal(28,10)\r\n");
                createTempTalbeSQL.append(",FAllSaleAmount  Decimal(28,10)\r\n");
                createTempTalbeSQL.append(",FFlag varchar(44)\r\n");
                createTempTalbeSQL.append(",FLevel int");
                createTempTalbeSQL.append(",FOrderSeq int");
                createTempTalbeSQL.append(");\r\n");
                break;
            }
            case 10: {
                createTempTalbeSQL.append("CREATE TABLE " + tempTable + "(\r\n");
                createTempTalbeSQL.append("FID Varchar(44) \r\n");
                createTempTalbeSQL.append(",FSaleGroupID Varchar(44) \r\n");
                createTempTalbeSQL.append(",FMaterialID Varchar(44) \r\n");
                createTempTalbeSQL.append(",FMaterialGroupID Varchar(44) \r\n");
                createTempTalbeSQL.append(",FMatGroupLevel int \r\n");
                createTempTalbeSQL.append(",FSaleOrgID Varchar(44) \r\n");
                createTempTalbeSQL.append(",FAmount  Decimal(28,10)\r\n");
                createTempTalbeSQL.append(",FReceiveAmount  Decimal(28,10)\r\n");
                createTempTalbeSQL.append(",FDiscountAmount  Decimal(28,10)\r\n");
                createTempTalbeSQL.append(",FAllSaleAmount  Decimal(28,10)\r\n");
                createTempTalbeSQL.append(",FFlag varchar(44)\r\n");
                createTempTalbeSQL.append(",FLevel int");
                createTempTalbeSQL.append(",FOrderSeq int");
                createTempTalbeSQL.append(");\r\n");
                break;
            }
            case 11: {
                createTempTalbeSQL.append("CREATE TABLE " + tempTable + "(\r\n");
                createTempTalbeSQL.append("FID Varchar(44) \r\n");
                createTempTalbeSQL.append(",FPersonId Varchar(44) \r\n");
                createTempTalbeSQL.append(",FAsstActID Varchar(44) \r\n");
                createTempTalbeSQL.append(",FMaterialID Varchar(44) \r\n");
                createTempTalbeSQL.append(",FSaleOrgID Varchar(44) \r\n");
                createTempTalbeSQL.append(",FBaseUnitID Varchar(44)\r\n");
                createTempTalbeSQL.append(",FBaseQty  Decimal(28,10)\r\n");
                createTempTalbeSQL.append(",FActualPrice  Decimal(28,10)\r\n");
                createTempTalbeSQL.append(",FAmount  Decimal(28,10)\r\n");
                createTempTalbeSQL.append(",FReceiveAmount  Decimal(28,10)\r\n");
                createTempTalbeSQL.append(",FDiscountAmount  Decimal(28,10)\r\n");
                createTempTalbeSQL.append(",FAllSaleAmount  Decimal(28,10)\r\n");
                createTempTalbeSQL.append(",FFlag varchar(44)\r\n");
                createTempTalbeSQL.append(",FLevel int");
                createTempTalbeSQL.append(",FOrderSeq int");
                createTempTalbeSQL.append(");\r\n");
                break;
            }
            case 12: {
                createTempTalbeSQL.append("CREATE TABLE " + tempTable + "(\r\n");
                createTempTalbeSQL.append("FID Varchar(44) \r\n");
                createTempTalbeSQL.append(",FCustomerGroupID Varchar(44) \r\n");
                createTempTalbeSQL.append(",FSaleOrgID Varchar(44) \r\n");
                createTempTalbeSQL.append(",FAmount  Decimal(28,10)\r\n");
                createTempTalbeSQL.append(",FReceiveAmount  Decimal(28,10)\r\n");
                createTempTalbeSQL.append(",FDiscountAmount  Decimal(28,10)\r\n");
                createTempTalbeSQL.append(",FAllSaleAmount  Decimal(28,10)\r\n");
                createTempTalbeSQL.append(",FFlag varchar(44)\r\n");
                createTempTalbeSQL.append(",FLevel int");
                createTempTalbeSQL.append(",FOrderSeq int");
                createTempTalbeSQL.append(");\r\n");
                break;
            }
            case 13: {
                createTempTalbeSQL.append("CREATE TABLE " + tempTable + "(\r\n");
                createTempTalbeSQL.append("FID Varchar(44) \r\n");
                createTempTalbeSQL.append(",FCustomerGroupID Varchar(44) \r\n");
                createTempTalbeSQL.append(",FMaterialID Varchar(44) \r\n");
                createTempTalbeSQL.append(",FSaleOrgID Varchar(44) \r\n");
                createTempTalbeSQL.append(",FBaseUnitID Varchar(44)\r\n");
                createTempTalbeSQL.append(",FBaseQty  Decimal(28,10)\r\n");
                createTempTalbeSQL.append(",FActualPrice  Decimal(28,10)\r\n");
                createTempTalbeSQL.append(",FAmount  Decimal(28,10)\r\n");
                createTempTalbeSQL.append(",FReceiveAmount  Decimal(28,10)\r\n");
                createTempTalbeSQL.append(",FDiscountAmount  Decimal(28,10)\r\n");
                createTempTalbeSQL.append(",FAllSaleAmount  Decimal(28,10)\r\n");
                createTempTalbeSQL.append(",FFlag varchar(44)\r\n");
                createTempTalbeSQL.append(",FLevel int");
                createTempTalbeSQL.append(",FOrderSeq int");
                createTempTalbeSQL.append(");\r\n");
            }
        }
        return createTempTalbeSQL.toString();
    }

    private String addLevelCols2Table(int level, String tempTable) {
        StringBuffer cols = new StringBuffer();
        cols.append("alter table ").append(tempTable).append(" add ");
        for (int i = 1; i < level; ++i) {
            cols.append("FNumber_" + String.valueOf(i) + " varchar(100) null, ").append("FNumber_" + String.valueOf(i) + "Name varchar(160), ");
        }
        cols.append("FNumber_" + String.valueOf(level) + " varchar(100) null, ").append("FNumber_" + String.valueOf(level) + "Name varchar(160)  ");
        return cols.toString();
    }

    private String[] splitLongNumber(int level, RptParams params, String tempTable) {
        StringBuffer sql;
        int i;
        String locString = "L2";
        ArrayList<String> sqlList = new ArrayList<String>();
        for (i = 1; i <= level; ++i) {
            sql = new StringBuffer();
            sql.append("update ").append(tempTable).append(" set FNumber_" + String.valueOf(i)).append(" = FGNumber WHERE Flevel = ").append(String.valueOf(i));
            sqlList.add(sql.toString());
            if (i > level) continue;
            StringBuffer lenBuffer = new StringBuffer();
            for (int j = 1; j < i; ++j) {
                lenBuffer.append("len(FNumber_").append(String.valueOf(j)).append(") + ");
            }
            StringBuffer sql2 = new StringBuffer();
            sql2.append("update ").append(tempTable).append(" set FNumber_" + String.valueOf(i)).append("= substring(FLongNumber,").append(lenBuffer).append(String.valueOf(i)).append(",charindex('!',FLongNumber,").append(lenBuffer).append(String.valueOf(i)).append(") - (").append(lenBuffer).append(String.valueOf(i)).append(")) WHERE FLevel > ").append(String.valueOf(i));
            sqlList.add(sql2.toString());
        }
        for (i = 1; i <= level; ++i) {
            sql = new StringBuffer();
            sql.append("update ").append(tempTable).append(" set FNumber_" + String.valueOf(i)).append("Name = (SELECT bb.FName_").append(locString).append(" FROM t_bd_materialgroup as bb ").append(" WHERE ").append(tempTable).append(".FNumber_").append(String.valueOf(i)).append(" = bb.FNumber AND bb.FLevel = ").append(String.valueOf(i)).append(" AND ").append(tempTable).append(".FNumber_" + String.valueOf(i) + "Name IS NULL ").append(") ");
            sqlList.add(sql.toString());
        }
        String[] sqls = sqlList.toArray(new String[sqlList.size()]);
        return sqls;
    }

    private String[] subTotal(String prefixFlds, String suffix, int level, String tempTable) {
        ArrayList<String> sqlList = new ArrayList<String>();
        for (int i = 1; i <= level; ++i) {
            int j;
            StringBuffer totalSql = new StringBuffer();
            totalSql.append("insert into ").append(tempTable).append(" (");
            if (prefixFlds != null) {
                totalSql.append(prefixFlds).append(",");
            }
            for (int i1 = 1; i1 <= i; ++i1) {
                totalSql.append("FNumber_").append(String.valueOf(i1)).append(",").append("FNumber_").append(String.valueOf(i1)).append("Name,");
            }
            totalSql.append("saleQty,outQty,saleCost,saleAmount) ");
            totalSql.append(" SELECT ");
            if (prefixFlds != null) {
                totalSql.append(prefixFlds).append(",");
            }
            for (j = 1; j <= i; ++j) {
                totalSql.append("FNumber_").append(String.valueOf(j)).append(",").append("FNumber_").append(String.valueOf(j)).append("Name,");
            }
            totalSql.append("sum(saleQty),sum(outQty),sum(saleCost),sum(saleAmount) ");
            totalSql.append(" FROM ").append(tempTable).append(" WHERE FNumber_").append(String.valueOf(i)).append(" is not null ").append(" group by ");
            if (prefixFlds != null) {
                totalSql.append(prefixFlds).append(",");
            }
            for (j = 1; j < i; ++j) {
                totalSql.append("FNumber_").append(String.valueOf(j)).append(",").append("FNumber_").append(String.valueOf(j)).append("Name, ");
            }
            totalSql.append("FNumber_").append(String.valueOf(i)).append(",").append("FNumber_").append(String.valueOf(i)).append("Name ");
            sqlList.add(totalSql.toString());
        }
        if (suffix != null) {
            int j;
            StringBuffer totalSql = new StringBuffer();
            totalSql.append("insert into ").append(tempTable).append(" (");
            for (int i1 = 1; i1 <= level; ++i1) {
                totalSql.append("FNumber_").append(String.valueOf(i1)).append(",").append("FNumber_").append(String.valueOf(i1)).append("Name,");
            }
            totalSql.append(suffix).append(",");
            totalSql.append("saleQty,outQty,saleCost,saleAmount) ");
            totalSql.append(" SELECT ");
            for (j = 1; j <= level; ++j) {
                totalSql.append("FNumber_").append(String.valueOf(j)).append(",").append("FNumber_").append(String.valueOf(j)).append("Name,");
            }
            totalSql.append(suffix).append(",");
            totalSql.append("sum(saleQty),sum(outQty),sum(saleCost),sum(saleAmount) ");
            totalSql.append(" FROM ").append(tempTable).append(" WHERE FNumber_").append(String.valueOf(level)).append(" is not null ");
            totalSql.append(" group by ");
            for (j = 1; j <= level; ++j) {
                totalSql.append("FNumber_").append(String.valueOf(j)).append(",").append("FNumber_").append(String.valueOf(j)).append("Name, ");
            }
            totalSql.append(suffix);
            sqlList.add(totalSql.toString());
        }
        String[] sqlSubtotals = sqlList.toArray(new String[sqlList.size()]);
        return sqlSubtotals;
    }

    private int minLevel(Context ctx, RptParams params, String tempTable) throws BOSException, EASBizException {
        int minLevel = 0;
        String countSql = "SELECT max(FMatGroupLevel) FMatGroupLevel FROM " + tempTable;
        RptRowSet rs = this.executeQuery(countSql, null, ctx);
        rs.next();
        if (rs.getObject(0) == null) {
            return 1;
        }
        int resultLevel = rs.getInt(0);
        int reqLevel = (Integer)params.getObject("Classification");
        minLevel = Math.min(resultLevel, reqLevel);
        return minLevel;
    }

    private void setRPTData(SqlParams sqlParams, RptParams params) {
        int i;
        int count = sqlParams.size() + 1;
        if (params.getString("SaleGroupFrom") != null) {
            sqlParams.setString(count++, params.getString("SaleGroupFrom"));
        }
        if (params.getString("SaleGroupTo") != null) {
            sqlParams.setString(count++, params.getString("SaleGroupTo"));
        }
        if (params.getObject("SalePersonFrom") != null) {
            if (params.getObject("SalePersonFrom") instanceof Object[]) {
                Object[] salePersons = (Object[])params.getObject("SalePersonFrom");
                for (i = 0; i < salePersons.length; ++i) {
                    sqlParams.setString(count++, ((PersonInfo)salePersons[i]).getNumber());
                }
            } else {
                sqlParams.setString(count++, params.getObject("SalePersonFrom").toString());
            }
        }
        if (params.getString("SalePersonTo") != null) {
            sqlParams.setString(count++, params.getString("SalePersonTo"));
        }
        if (params.getObject("CustomerFrom") != null) {
            if (params.getObject("CustomerFrom") instanceof Object[]) {
                Object[] customers = (Object[])params.getObject("CustomerFrom");
                for (i = 0; i < customers.length; ++i) {
                    sqlParams.setString(count++, ((CustomerInfo)customers[i]).getNumber());
                }
            } else if (params.getObject("CustomerFrom") instanceof CustomerInfo) {
                sqlParams.setString(count++, ((CustomerInfo)params.getObject("CustomerFrom")).getNumber());
            } else {
                sqlParams.setString(count++, params.getObject("CustomerFrom").toString());
            }
        }
        if (params.getString("CustomerTo") != null) {
            sqlParams.setString(count++, params.getString("CustomerTo"));
        }
        if (params.getObject("materialFrom") != null) {
            if (params.getObject("materialFrom") instanceof Object[]) {
                Object[] materials = (Object[])params.getObject("materialFrom");
                for (i = 0; i < materials.length; ++i) {
                    sqlParams.setString(count++, ((MaterialInfo)materials[i]).getNumber());
                }
            } else {
                sqlParams.setString(count++, params.getObject("materialFrom").toString());
            }
        }
        if (params.getObject("materialTo") != null) {
            sqlParams.setString(count++, params.getString("materialTo"));
        }
    }

    private String inSertData(RptParams params, String tableName, SqlParams sqlParams, Context ctx) throws BOSException, EASBizException {
        StringBuffer insertSQL = new StringBuffer();
        this.groupBy = new Integer(params.getString("Classification"));
        switch (this.groupBy) {
            case 1: {
                insertSQL.append("insert into " + tableName);
                insertSQL.append("\r\n SELECT newbosid('88888888')");
                insertSQL.append(",ENTRY.FMaterialID");
                insertSQL.append("\r\n ,OTHERBILL.FSaleOrgID AS SaleOrgID");
                insertSQL.append("\r\n ,ENTRY.FBaseUnitID AS FBaseUnitID");
                insertSQL.append(",sum(ENTRY.FBaseQty) AS FBaseQty");
                insertSQL.append("\r\n ,case when  sum(ENTRY.FBaseQty)= 0 then 0 ");
                insertSQL.append(" else decimal(decimal(sum(ENTRY.FRecievePayAmount),17,4)/sum(ENTRY.FBaseQty),17,4) end");
                insertSQL.append(",sum(ENTRY.FAmount) AS FAmount");
                insertSQL.append("\r\n ,sum(ENTRY.FRecievePayAmount) AS FTaxAmount");
                insertSQL.append("\r\n ,sum(ENTRY.FDiscountAmount) AS FDiscountAmount");
                insertSQL.append(",sum(ENTRY.FRecievePayAmount)");
                insertSQL.append("+ sum(ENTRY.FDiscountAmount) ");
                insertSQL.append(",'DEL',Org.Flevel");
                insertSQL.append(",111");
                insertSQL.append("\r\n  FROM T_AR_OtherBill AS OTHERBILL");
                insertSQL.append("\r\n  INNER JOIN T_AR_OtherBillentry AS ENTRY");
                insertSQL.append(" ON OTHERBILL.FID = ENTRY.FParentID");
                insertSQL.append("\r\n  INNER JOIN ");
                insertSQL.append(params.getString("OrgTempTable"));
                insertSQL.append(" ORG");
                insertSQL.append(" ON OTHERBILL.FSaleOrgID = ORG.FID");
                String saleOrderStr = this.getQueryStr(params, "OTHERBILL", insertSQL, ctx);
                insertSQL.append(saleOrderStr);
                insertSQL.append(" group by ");
                insertSQL.append("ENTRY.FMaterialID");
                insertSQL.append(",OTHERBILL.FSaleOrgID");
                insertSQL.append(",ENTRY.FBaseUnitID");
                insertSQL.append(",OTHERBILL.FSaleOrgID,org.flevel");
                this.executeUpdate(insertSQL.toString(), sqlParams, ctx);
                break;
            }
            case 2: {
                insertSQL.append("insert into " + tableName);
                insertSQL.append("\r\n SELECT newbosid('88888888')");
                insertSQL.append(",OTHERBILL.FAsstActID");
                insertSQL.append("\r\n ,OTHERBILL.FSaleOrgID AS SaleOrgID");
                insertSQL.append(",sum(ENTRY.FAmount) AS FAmount");
                insertSQL.append("\r\n ,sum(ENTRY.FRecievePayAmount) AS FTaxAmount");
                insertSQL.append("\r\n ,sum(ENTRY.FDiscountAmount) AS FDiscountAmount");
                insertSQL.append(",sum(ENTRY.FRecievePayAmount)");
                insertSQL.append("+ sum(ENTRY.FDiscountAmount) ");
                insertSQL.append(",'DEL',Org.Flevel");
                insertSQL.append(",111");
                insertSQL.append("\r\n  FROM T_AR_OtherBill AS OTHERBILL");
                insertSQL.append("\r\n  INNER JOIN T_AR_OtherBillentry AS ENTRY");
                insertSQL.append(" ON OTHERBILL.FID = ENTRY.FParentID");
                insertSQL.append("\r\n  INNER JOIN ");
                insertSQL.append(params.getString("OrgTempTable"));
                insertSQL.append(" ORG");
                insertSQL.append(" ON OTHERBILL.FSaleOrgID = ORG.FID");
                String saleOrderStr = this.getQueryStr(params, "OTHERBILL", insertSQL, ctx);
                insertSQL.append(saleOrderStr);
                insertSQL.append(" group by ");
                insertSQL.append("OTHERBILL.FAsstActID");
                insertSQL.append(",OTHERBILL.FSaleOrgID");
                insertSQL.append(",OTHERBILL.FSaleOrgID,org.flevel");
                this.executeUpdate(insertSQL.toString(), sqlParams, ctx);
                break;
            }
            case 3: {
                insertSQL.append("insert into " + tableName);
                insertSQL.append("\r\n SELECT newbosid('88888888')");
                insertSQL.append(",ISNULL(OTHERBILL.FPersonId,'zzzz')");
                insertSQL.append("\r\n ,OTHERBILL.FSaleOrgID AS SaleOrgID");
                insertSQL.append(",sum(ENTRY.FAmount) AS FAmount");
                insertSQL.append("\r\n ,sum(ENTRY.FRecievePayAmount) AS FTaxAmount");
                insertSQL.append("\r\n ,sum(ENTRY.FDiscountAmount) AS FDiscountAmount");
                insertSQL.append(",sum(ENTRY.FRecievePayAmount)");
                insertSQL.append("+ sum(ENTRY.FDiscountAmount) ");
                insertSQL.append(",'DEL',Org.Flevel");
                insertSQL.append(",111");
                insertSQL.append("\r\n  FROM T_AR_OtherBill AS OTHERBILL");
                insertSQL.append("\r\n  INNER JOIN T_AR_OtherBillentry AS ENTRY");
                insertSQL.append(" ON OTHERBILL.FID = ENTRY.FParentID");
                insertSQL.append("\r\n  INNER JOIN ");
                insertSQL.append(params.getString("OrgTempTable"));
                insertSQL.append(" ORG");
                insertSQL.append(" ON OTHERBILL.FSaleOrgID = ORG.FID");
                String saleOrderStr = this.getQueryStr(params, "OTHERBILL", insertSQL, ctx);
                insertSQL.append(saleOrderStr);
                insertSQL.append(" group by ");
                insertSQL.append("OTHERBILL.FPersonId");
                insertSQL.append(",OTHERBILL.FSaleOrgID");
                insertSQL.append(",OTHERBILL.FSaleOrgID,org.flevel");
                this.executeUpdate(insertSQL.toString(), sqlParams, ctx);
                break;
            }
            case 4: {
                insertSQL.append("insert into " + tableName);
                insertSQL.append("\r\n SELECT newbosid('88888888')");
                insertSQL.append(",ISNULL(OTHERBILL.FSaleGroupID,'zzzz')");
                insertSQL.append("\r\n ,OTHERBILL.FSaleOrgID AS SaleOrgID");
                insertSQL.append(",sum(ENTRY.FAmount) AS FAmount");
                insertSQL.append("\r\n ,sum(ENTRY.FRecievePayAmount) AS FTaxAmount");
                insertSQL.append("\r\n ,sum(ENTRY.FDiscountAmount) AS FDiscountAmount");
                insertSQL.append(",sum(ENTRY.FRecievePayAmount)");
                insertSQL.append("+ sum(ENTRY.FDiscountAmount) ");
                insertSQL.append(",'DEL',Org.Flevel");
                insertSQL.append(",111");
                insertSQL.append("\r\n  FROM T_AR_OtherBill AS OTHERBILL");
                insertSQL.append("\r\n  INNER JOIN T_AR_OtherBillentry AS ENTRY");
                insertSQL.append(" ON OTHERBILL.FID = ENTRY.FParentID");
                insertSQL.append("\r\n  INNER JOIN ");
                insertSQL.append(params.getString("OrgTempTable"));
                insertSQL.append(" ORG");
                insertSQL.append(" ON OTHERBILL.FSaleOrgID = ORG.FID");
                String saleOrderStr = this.getQueryStr(params, "OTHERBILL", insertSQL, ctx);
                insertSQL.append(saleOrderStr);
                insertSQL.append(" group by ");
                insertSQL.append("OTHERBILL.FSaleGroupID");
                insertSQL.append(",OTHERBILL.FSaleOrgID");
                insertSQL.append(",OTHERBILL.FSaleOrgID,org.flevel");
                this.executeUpdate(insertSQL.toString(), sqlParams, ctx);
                break;
            }
            case 5: {
                insertSQL.append("insert into " + tableName);
                insertSQL.append("\r\n SELECT newbosid('88888888')");
                insertSQL.append(",ENTRY.FMaterialID");
                insertSQL.append(",material.FMaterialGroupID");
                insertSQL.append(",mg.FLevel");
                insertSQL.append("\r\n ,OTHERBILL.FSaleOrgID AS SaleOrgID");
                insertSQL.append(",sum(ENTRY.FAmount) AS FAmount");
                insertSQL.append("\r\n ,sum(ENTRY.FRecievePayAmount) AS FTaxAmount");
                insertSQL.append("\r\n ,sum(ENTRY.FDiscountAmount) AS FDiscountAmount");
                insertSQL.append(",sum(ENTRY.FRecievePayAmount)");
                insertSQL.append("+ sum(ENTRY.FDiscountAmount) ");
                insertSQL.append(",'DEL',Org.Flevel");
                insertSQL.append(",111");
                insertSQL.append("\r\n  FROM T_AR_OtherBill AS OTHERBILL");
                insertSQL.append("\r\n  INNER JOIN T_AR_OtherBillentry AS ENTRY");
                insertSQL.append(" ON OTHERBILL.FID = ENTRY.FParentID");
                insertSQL.append("\r\n  INNER JOIN ");
                insertSQL.append(params.getString("OrgTempTable"));
                insertSQL.append(" ORG");
                insertSQL.append(" ON OTHERBILL.FSaleOrgID = ORG.FID");
                insertSQL.append("\r\n inner join T_BD_Material material ");
                insertSQL.append(" on material.fid = ENTRY.FMaterialID ");
                insertSQL.append("\r\n inner join T_BD_MaterialGroup mg ");
                insertSQL.append(" on material.FMaterialGroupID = mg.FID ");
                String saleOrderStr = this.getQueryStr(params, "OTHERBILL", insertSQL, ctx);
                insertSQL.append(saleOrderStr);
                insertSQL.append(" group by ");
                insertSQL.append("ENTRY.FMaterialID");
                insertSQL.append(",material.FMaterialGroupID");
                insertSQL.append(",mg.FLevel");
                insertSQL.append(",OTHERBILL.FSaleOrgID,org.flevel");
                this.executeUpdate(insertSQL.toString(), sqlParams, ctx);
                break;
            }
            case 6: {
                insertSQL.append("insert into " + tableName);
                insertSQL.append("\r\n SELECT newbosid('88888888')");
                insertSQL.append(",ENTRY.FMaterialID");
                insertSQL.append(",OTHERBILL.FAsstActID");
                insertSQL.append("\r\n ,OTHERBILL.FSaleOrgID AS SaleOrgID");
                insertSQL.append(",sum(ENTRY.FAmount) AS FAmount");
                insertSQL.append("\r\n ,sum(ENTRY.FRecievePayAmount) AS FTaxAmount");
                insertSQL.append("\r\n ,sum(ENTRY.FDiscountAmount) AS FDiscountAmount");
                insertSQL.append(",sum(ENTRY.FRecievePayAmount)");
                insertSQL.append("+ sum(ENTRY.FDiscountAmount) ");
                insertSQL.append(",'DEL',Org.Flevel");
                insertSQL.append(",111");
                insertSQL.append("\r\n  FROM T_AR_OtherBill AS OTHERBILL");
                insertSQL.append("\r\n  INNER JOIN T_AR_OtherBillentry AS ENTRY");
                insertSQL.append(" ON OTHERBILL.FID = ENTRY.FParentID");
                insertSQL.append("\r\n  INNER JOIN ");
                insertSQL.append(params.getString("OrgTempTable"));
                insertSQL.append(" ORG");
                insertSQL.append(" ON OTHERBILL.FSaleOrgID = ORG.FID");
                String saleOrderStr = this.getQueryStr(params, "OTHERBILL", insertSQL, ctx);
                insertSQL.append(saleOrderStr);
                insertSQL.append(" group by ");
                insertSQL.append("ENTRY.FMaterialID");
                insertSQL.append(",OTHERBILL.FAsstActID");
                insertSQL.append(",OTHERBILL.FSaleOrgID");
                insertSQL.append(",OTHERBILL.FSaleOrgID,org.flevel");
                this.executeUpdate(insertSQL.toString(), sqlParams, ctx);
                break;
            }
            case 7: {
                insertSQL.append("insert into " + tableName);
                insertSQL.append("\r\n SELECT newbosid('88888888')");
                insertSQL.append(",OTHERBILL.FAsstActID");
                insertSQL.append(",ENTRY.FMaterialID");
                insertSQL.append("\r\n ,OTHERBILL.FSaleOrgID AS SaleOrgID");
                insertSQL.append("\r\n ,ENTRY.FBaseUnitID AS FBaseUnitID");
                insertSQL.append(",sum(ENTRY.FBaseQty) AS FBaseQty");
                insertSQL.append("\r\n ,case when  sum(ENTRY.FBaseQty)= 0 then 0 ");
                insertSQL.append(" else decimal(decimal((sum(ENTRY.FAmount) ");
                insertSQL.append("+ sum(FRecievePayAmount)),17,4)/sum(ENTRY.FBaseQty),17,4) end");
                insertSQL.append(",sum(ENTRY.FAmount) AS FAmount");
                insertSQL.append("\r\n ,sum(ENTRY.FRecievePayAmount) AS FTaxAmount");
                insertSQL.append("\r\n ,sum(ENTRY.FDiscountAmount) AS FDiscountAmount");
                insertSQL.append(",sum(ENTRY.FRecievePayAmount)");
                insertSQL.append("+ sum(ENTRY.FDiscountAmount) ");
                insertSQL.append(",'DEL',Org.Flevel");
                insertSQL.append(",111");
                insertSQL.append("\r\n  FROM T_AR_OtherBill AS OTHERBILL");
                insertSQL.append("\r\n  INNER JOIN T_AR_OtherBillentry AS ENTRY");
                insertSQL.append(" ON OTHERBILL.FID = ENTRY.FParentID");
                insertSQL.append("\r\n  INNER JOIN ");
                insertSQL.append(params.getString("OrgTempTable"));
                insertSQL.append(" ORG");
                insertSQL.append(" ON OTHERBILL.FSaleOrgID = ORG.FID");
                String saleOrderStr = this.getQueryStr(params, "OTHERBILL", insertSQL, ctx);
                insertSQL.append(saleOrderStr);
                insertSQL.append(" group by ");
                insertSQL.append("OTHERBILL.FAsstActID");
                insertSQL.append(",ENTRY.FMaterialID");
                insertSQL.append(",OTHERBILL.FSaleOrgID");
                insertSQL.append(",ENTRY.FBaseUnitID");
                insertSQL.append(",OTHERBILL.FSaleOrgID,org.flevel");
                this.executeUpdate(insertSQL.toString(), sqlParams, ctx);
                break;
            }
            case 8: {
                insertSQL.append("insert into " + tableName);
                insertSQL.append("\r\n SELECT newbosid('88888888')");
                insertSQL.append(",ISNULL(OTHERBILL.FSaleGroupID,'zzzz')");
                insertSQL.append(",ISNULL(OTHERBILL.FPersonId,'zzzz')");
                insertSQL.append(",ENTRY.FMaterialID");
                insertSQL.append("\r\n ,OTHERBILL.FSaleOrgID AS SaleOrgID");
                insertSQL.append("\r\n ,ENTRY.FBaseUnitID AS FBaseUnitID");
                insertSQL.append(",sum(ENTRY.FBaseQty) AS FBaseQty");
                insertSQL.append("\r\n ,case when  sum(ENTRY.FBaseQty)= 0 then 0 ");
                insertSQL.append(" else decimal(decimal((sum(ENTRY.FAmount) ");
                insertSQL.append("+ sum(FRecievePayAmount)),17,4)/sum(ENTRY.FBaseQty),17,4) end");
                insertSQL.append(",sum(ENTRY.FAmount) AS FAmount");
                insertSQL.append("\r\n ,sum(ENTRY.FRecievePayAmount) AS FTaxAmount");
                insertSQL.append("\r\n ,sum(ENTRY.FDiscountAmount) AS FDiscountAmount");
                insertSQL.append(",sum(ENTRY.FRecievePayAmount)");
                insertSQL.append("+ sum(ENTRY.FDiscountAmount) ");
                insertSQL.append(",'DEL',Org.Flevel");
                insertSQL.append(",111");
                insertSQL.append("\r\n  FROM T_AR_OtherBill AS OTHERBILL");
                insertSQL.append("\r\n  INNER JOIN T_AR_OtherBillentry AS ENTRY");
                insertSQL.append(" ON OTHERBILL.FID = ENTRY.FParentID");
                insertSQL.append("\r\n  INNER JOIN ");
                insertSQL.append(params.getString("OrgTempTable"));
                insertSQL.append(" ORG");
                insertSQL.append(" ON OTHERBILL.FSaleOrgID = ORG.FID");
                String saleOrderStr = this.getQueryStr(params, "OTHERBILL", insertSQL, ctx);
                insertSQL.append(saleOrderStr);
                insertSQL.append(" group by ");
                insertSQL.append("OTHERBILL.FSaleGroupID");
                insertSQL.append(",OTHERBILL.FPersonId");
                insertSQL.append(",ENTRY.FMaterialID");
                insertSQL.append(",OTHERBILL.FSaleOrgID");
                insertSQL.append(",ENTRY.FBaseUnitID");
                insertSQL.append(",OTHERBILL.FSaleOrgID,org.flevel");
                this.executeUpdate(insertSQL.toString(), sqlParams, ctx);
                break;
            }
            case 9: {
                insertSQL.append("insert into " + tableName);
                insertSQL.append("\r\n SELECT newbosid('88888888')");
                insertSQL.append(",ISNULL(OTHERBILL.FSaleGroupID,'zzzz')");
                insertSQL.append(",ENTRY.FMaterialID");
                insertSQL.append("\r\n ,OTHERBILL.FSaleOrgID AS SaleOrgID");
                insertSQL.append("\r\n ,ENTRY.FBaseUnitID AS FBaseUnitID");
                insertSQL.append(",sum(ENTRY.FBaseQty) AS FBaseQty");
                insertSQL.append("\r\n ,case when  sum(ENTRY.FBaseQty)= 0 then 0 ");
                insertSQL.append(" else decimal(decimal((sum(ENTRY.FAmount) ");
                insertSQL.append("+ sum(FRecievePayAmount)),17,4)/sum(ENTRY.FBaseQty),17,4) end");
                insertSQL.append(",sum(ENTRY.FAmount) AS FAmount");
                insertSQL.append("\r\n ,sum(ENTRY.FRecievePayAmount) AS FTaxAmount");
                insertSQL.append("\r\n ,sum(ENTRY.FDiscountAmount) AS FDiscountAmount");
                insertSQL.append(",sum(ENTRY.FRecievePayAmount)");
                insertSQL.append("+ sum(ENTRY.FDiscountAmount) ");
                insertSQL.append(",'DEL',Org.Flevel");
                insertSQL.append(",111");
                insertSQL.append("\r\n  FROM T_AR_OtherBill AS OTHERBILL");
                insertSQL.append("\r\n  INNER JOIN T_AR_OtherBillentry AS ENTRY");
                insertSQL.append(" ON OTHERBILL.FID = ENTRY.FParentID");
                insertSQL.append("\r\n  INNER JOIN ");
                insertSQL.append(params.getString("OrgTempTable"));
                insertSQL.append(" ORG");
                insertSQL.append(" ON OTHERBILL.FSaleOrgID = ORG.FID");
                String saleOrderStr = this.getQueryStr(params, "OTHERBILL", insertSQL, ctx);
                insertSQL.append(saleOrderStr);
                insertSQL.append(" group by ");
                insertSQL.append("OTHERBILL.FSaleGroupID");
                insertSQL.append(",ENTRY.FMaterialID");
                insertSQL.append(",OTHERBILL.FSaleOrgID");
                insertSQL.append(",ENTRY.FBaseUnitID");
                insertSQL.append(",OTHERBILL.FSaleOrgID,org.flevel");
                this.executeUpdate(insertSQL.toString(), sqlParams, ctx);
                break;
            }
            case 10: {
                insertSQL.append("insert into " + tableName);
                insertSQL.append("\r\n SELECT newbosid('88888888')");
                insertSQL.append(",ISNULL(OTHERBILL.FSaleGroupID,'zzzz')");
                insertSQL.append(",ENTRY.FMaterialID");
                insertSQL.append(",material.FMaterialGroupID");
                insertSQL.append(",mg.FLevel");
                insertSQL.append("\r\n ,OTHERBILL.FSaleOrgID AS SaleOrgID");
                insertSQL.append(",sum(ENTRY.FAmount) AS FAmount");
                insertSQL.append("\r\n ,sum(ENTRY.FRecievePayAmount) AS FTaxAmount");
                insertSQL.append("\r\n ,sum(ENTRY.FDiscountAmount) AS FDiscountAmount");
                insertSQL.append(",sum(ENTRY.FRecievePayAmount)");
                insertSQL.append("+ sum(ENTRY.FDiscountAmount) ");
                insertSQL.append(",'DEL',Org.Flevel");
                insertSQL.append(",111");
                insertSQL.append("\r\n  FROM T_AR_OtherBill AS OTHERBILL");
                insertSQL.append("\r\n  INNER JOIN T_AR_OtherBillentry AS ENTRY");
                insertSQL.append(" ON OTHERBILL.FID = ENTRY.FParentID");
                insertSQL.append("\r\n  INNER JOIN ");
                insertSQL.append(params.getString("OrgTempTable"));
                insertSQL.append(" ORG");
                insertSQL.append(" ON OTHERBILL.FSaleOrgID = ORG.FID");
                insertSQL.append("\r\n inner join T_BD_Material material ");
                insertSQL.append(" on material.fid = ENTRY.FMaterialID ");
                insertSQL.append("\r\n inner join T_BD_MaterialGroup mg ");
                insertSQL.append(" on material.FMaterialGroupID = mg.FID ");
                String saleOrderStr = this.getQueryStr(params, "OTHERBILL", insertSQL, ctx);
                insertSQL.append(saleOrderStr);
                insertSQL.append(" group by ");
                insertSQL.append("OTHERBILL.FSaleGroupID");
                insertSQL.append(",ENTRY.FMaterialID");
                insertSQL.append(",material.FMaterialGroupID");
                insertSQL.append(",mg.FLevel");
                insertSQL.append(",OTHERBILL.FSaleOrgID,org.flevel");
                this.executeUpdate(insertSQL.toString(), sqlParams, ctx);
                break;
            }
            case 11: {
                insertSQL.append("insert into " + tableName);
                insertSQL.append("\r\n SELECT newbosid('88888888')");
                insertSQL.append(",ISNULL(OTHERBILL.FPersonId,'zzzz')");
                insertSQL.append(",OTHERBILL.FAsstActID");
                insertSQL.append(",ENTRY.FMaterialID");
                insertSQL.append("\r\n ,OTHERBILL.FSaleOrgID AS SaleOrgID");
                insertSQL.append("\r\n ,ENTRY.FBaseUnitID AS FBaseUnitID");
                insertSQL.append(",sum(ENTRY.FBaseQty) AS FBaseQty");
                insertSQL.append("\r\n ,case when  sum(ENTRY.FBaseQty)= 0 then 0 ");
                insertSQL.append(" else decimal(decimal((sum(ENTRY.FAmount) ");
                insertSQL.append("+ sum(FRecievePayAmount)),17,4)/sum(ENTRY.FBaseQty),17,4) end");
                insertSQL.append(",sum(ENTRY.FAmount) AS FAmount");
                insertSQL.append("\r\n ,sum(ENTRY.FRecievePayAmount) AS FTaxAmount");
                insertSQL.append("\r\n ,sum(ENTRY.FDiscountAmount) AS FDiscountAmount");
                insertSQL.append(",sum(ENTRY.FRecievePayAmount)");
                insertSQL.append("+ sum(ENTRY.FDiscountAmount) ");
                insertSQL.append(",'DEL',Org.Flevel");
                insertSQL.append(",111");
                insertSQL.append("\r\n  FROM T_AR_OtherBill AS OTHERBILL");
                insertSQL.append("\r\n  INNER JOIN T_AR_OtherBillentry AS ENTRY");
                insertSQL.append(" ON OTHERBILL.FID = ENTRY.FParentID");
                insertSQL.append("\r\n  INNER JOIN ");
                insertSQL.append(params.getString("OrgTempTable"));
                insertSQL.append(" ORG");
                insertSQL.append(" ON OTHERBILL.FSaleOrgID = ORG.FID");
                String saleOrderStr = this.getQueryStr(params, "OTHERBILL", insertSQL, ctx);
                insertSQL.append(saleOrderStr);
                insertSQL.append(" group by ");
                insertSQL.append("OTHERBILL.FPersonId");
                insertSQL.append(",OTHERBILL.FAsstActID");
                insertSQL.append(",ENTRY.FMaterialID");
                insertSQL.append(",OTHERBILL.FSaleOrgID");
                insertSQL.append(",ENTRY.FBaseUnitID");
                insertSQL.append(",OTHERBILL.FSaleOrgID,org.flevel");
                this.executeUpdate(insertSQL.toString(), sqlParams, ctx);
                break;
            }
            case 12: {
                insertSQL.append("insert into " + tableName);
                insertSQL.append("\r\n SELECT newbosid('88888888')");
                insertSQL.append(",customerDetail.FCustomerGroupID");
                insertSQL.append("\r\n ,OTHERBILL.FSaleOrgID AS SaleOrgID");
                insertSQL.append(",sum(ENTRY.FAmount) AS FAmount");
                insertSQL.append("\r\n ,sum(ENTRY.FRecievePayAmount) AS FTaxAmount");
                insertSQL.append("\r\n ,sum(ENTRY.FDiscountAmount) AS FDiscountAmount");
                insertSQL.append(",sum(ENTRY.FRecievePayAmount)");
                insertSQL.append("+ sum(ENTRY.FDiscountAmount) ");
                insertSQL.append(",'DEL',Org.Flevel");
                insertSQL.append(",111");
                insertSQL.append("\r\n  FROM T_AR_OtherBill AS OTHERBILL");
                insertSQL.append("\r\n  INNER JOIN T_AR_OtherBillentry AS ENTRY");
                insertSQL.append(" ON OTHERBILL.FID = ENTRY.FParentID");
                insertSQL.append("\r\n  INNER JOIN ");
                insertSQL.append(params.getString("OrgTempTable"));
                insertSQL.append(" ORG");
                insertSQL.append(" ON OTHERBILL.FSaleOrgID = ORG.FID");
                insertSQL.append("\r\n inner join T_BD_CustomerGroupDetail customerDetail");
                insertSQL.append(" on customerDetail.FCustomerID = OTHERBILL.FAsstActID");
                String saleOrderStr = this.getQueryStr(params, "OTHERBILL", insertSQL, ctx);
                insertSQL.append(saleOrderStr);
                insertSQL.append(" group by ");
                insertSQL.append("customerDetail.FCustomerGroupID");
                insertSQL.append(",OTHERBILL.FSaleOrgID");
                insertSQL.append(",OTHERBILL.FSaleOrgID,org.flevel");
                this.executeUpdate(insertSQL.toString(), sqlParams, ctx);
                break;
            }
            case 13: {
                insertSQL.append("insert into " + tableName);
                insertSQL.append("\r\n SELECT newbosid('88888888')");
                insertSQL.append(",customerDetail.FCustomerGroupID");
                insertSQL.append(",ENTRY.FMaterialID");
                insertSQL.append("\r\n ,OTHERBILL.FSaleOrgID AS SaleOrgID");
                insertSQL.append("\r\n ,ENTRY.FBaseUnitID AS FBaseUnitID");
                insertSQL.append(",sum(ENTRY.FBaseQty) AS FBaseQty");
                insertSQL.append("\r\n ,case when  sum(ENTRY.FBaseQty)= 0 then 0 ");
                insertSQL.append(" else decimal(decimal((sum(ENTRY.FAmount) ");
                insertSQL.append("+ sum(FRecievePayAmount)),17,4)/sum(ENTRY.FBaseQty),17,4) end");
                insertSQL.append(",sum(ENTRY.FAmount) AS FAmount");
                insertSQL.append("\r\n ,sum(ENTRY.FRecievePayAmount) AS FTaxAmount");
                insertSQL.append("\r\n ,sum(ENTRY.FDiscountAmount) AS FDiscountAmount");
                insertSQL.append(",sum(ENTRY.FRecievePayAmount)");
                insertSQL.append("+ sum(ENTRY.FDiscountAmount) ");
                insertSQL.append(",'DEL',Org.Flevel");
                insertSQL.append(",111");
                insertSQL.append("\r\n  FROM T_AR_OtherBill AS OTHERBILL");
                insertSQL.append("\r\n  INNER JOIN T_AR_OtherBillentry AS ENTRY");
                insertSQL.append(" ON OTHERBILL.FID = ENTRY.FParentID");
                insertSQL.append("\r\n  INNER JOIN ");
                insertSQL.append(params.getString("OrgTempTable"));
                insertSQL.append(" ORG");
                insertSQL.append(" ON OTHERBILL.FSaleOrgID = ORG.FID");
                insertSQL.append("\r\n inner join T_BD_CustomerGroupDetail customerDetail");
                insertSQL.append(" on customerDetail.FCustomerID = OTHERBILL.FAsstActID");
                String saleOrderStr = this.getQueryStr(params, "OTHERBILL", insertSQL, ctx);
                insertSQL.append(saleOrderStr);
                insertSQL.append(" group by ");
                insertSQL.append("customerDetail.FCustomerGroupID");
                insertSQL.append(",ENTRY.FMaterialID");
                insertSQL.append(",OTHERBILL.FSaleOrgID");
                insertSQL.append(",ENTRY.FBaseUnitID");
                insertSQL.append(",OTHERBILL.FSaleOrgID,org.flevel");
                this.executeUpdate(insertSQL.toString(), sqlParams, ctx);
                break;
            }
        }
        return insertSQL.toString();
    }

    private String getQueryStr(RptParams params, String purName, StringBuffer purBuffer, Context ctx) throws EASBizException, BOSException {
        int i;
        StringBuffer queryStr = new StringBuffer();
        String bd = null;
        String ed = null;
        bd = params.getString("dateStart");
        ed = params.getString("dateEnd");
        queryStr.append("\r\n where ");
        switch (new Integer(params.getString("baseStatus"))) {
            case 1: {
                queryStr.append(purName).append(".FBillStatus<> 1 and ");
                break;
            }
            case 2: {
                queryStr.append(purName).append(".FBillStatus<> 3 and ");
                queryStr.append(purName).append(".FBillStatus<> 4 and ");
                queryStr.append(purName).append(".FBillStatus<> 1 and ");
                break;
            }
            case 3: {
                queryStr.append(purName + ".FBillStatus= 3 and ");
            }
        }
        queryStr.append(purName).append(".FBizDate").append("  >= {").append(bd).append("}");
        queryStr.append(" and ").append(purName).append(".FBizDate").append(" <= {").append(ed).append("}");
        queryStr.append(" and ").append(purName).append(".FIsBizBill").append(" = 0 ");
        queryStr.append(" and Currency.FNumber='" + params.getString("Currency") + "'");
        purBuffer.append("\r\n INNER JOIN T_BD_Currency AS Currency ");
        purBuffer.append(" ON OTHERBILL.FCurrencyID = Currency.FID ");
        if (params.getString("SaleGroupFrom") != null) {
            queryStr.append(" and SALEGROUP.FNumber >= ? ");
            if (purBuffer.toString().indexOf("T_BD_SaleGroup") == -1) {
                purBuffer.append("\r\n LEFT OUTER JOIN T_BD_SaleGroup AS SALEGROUP ");
                purBuffer.append(" ON OTHERBILL.FSaleGroupID = SALEGROUP.FID ");
            }
        }
        if (params.getString("SaleGroupTo") != null) {
            queryStr.append(" and SALEGROUP.FNumber <= ? ");
            if (purBuffer.toString().indexOf("T_BD_SaleGroup") == -1) {
                purBuffer.append("\r\n LEFT OUTER JOIN T_BD_SaleGroup AS SALEGROUP  ");
                purBuffer.append(" ON OTHERBILL.FSaleGroupID = SALEGROUP.FID ");
            }
        }
        if (params.getObject("SalePersonFrom") != null) {
            if (params.getObject("SalePersonFrom") instanceof Object[]) {
                Object[] salePersons = (Object[])params.getObject("SalePersonFrom");
                if (salePersons.length == 1) {
                    queryStr.append(" and PERSON.FNumber >= ? ");
                } else {
                    queryStr.append(" and PERSON.FNumber in (?");
                    for (i = 1; i < salePersons.length; ++i) {
                        queryStr.append(",?");
                    }
                    queryStr.append(")");
                }
            } else {
                queryStr.append(" and PERSON.FNumber >= ? ");
            }
            if (purBuffer.toString().indexOf("T_BD_Person") == -1) {
                purBuffer.append("\r\n LEFT OUTER JOIN T_BD_Person AS PERSON ");
                purBuffer.append(" ON OTHERBILL.FPersonId = PERSON.FID ");
            }
        }
        if (params.getString("SalePersonTo") != null) {
            queryStr.append(" and PERSON.FNumber <= ? ");
            if (purBuffer.toString().indexOf("T_BD_Person") == -1) {
                purBuffer.append("\r\n LEFT OUTER JOIN T_BD_Person AS PERSON ");
                purBuffer.append(" ON OTHERBILL.FPersonId = PERSON.FID ");
            }
        }
        if (params.getObject("CustomerFrom") != null) {
            if (params.getObject("CustomerFrom") instanceof Object[]) {
                Object[] customers = (Object[])params.getObject("CustomerFrom");
                if (customers.length == 1) {
                    queryStr.append(" and Customer.FNumber >= ? ");
                } else {
                    queryStr.append(" and Customer.FNumber in (?");
                    for (i = 1; i < customers.length; ++i) {
                        queryStr.append(",?");
                    }
                    queryStr.append(")");
                }
            } else {
                queryStr.append(" and Customer.FNumber >= ? ");
            }
            if (purBuffer.toString().indexOf(" T_BD_Customer ") == -1) {
                purBuffer.append("\r\n INNER join T_BD_Customer Customer ");
                purBuffer.append(" on Customer.fid = OTHERBILL.FAsstActID ");
            }
        }
        if (params.getString("CustomerTo") != null) {
            queryStr.append(" and Customer.FNumber <= ? ");
            if (purBuffer.toString().indexOf(" T_BD_Customer ") == -1) {
                purBuffer.append("\r\n inner join T_BD_Customer Customer ");
                purBuffer.append(" on Customer.fid = OTHERBILL.FAsstActID ");
            }
        }
        purBuffer.append("\r\n inner join T_BD_Material material on material.fid = ENTRY.FMaterialID ");
        if (params.getObject("materialFrom") != null) {
            if (params.getObject("materialFrom") instanceof Object[]) {
                Object[] materials = (Object[])params.getObject("materialFrom");
                if (materials.length == 1) {
                    queryStr.append(" and material.FNumber >= ? ");
                } else {
                    queryStr.append(" and material.FNumber in (?");
                    for (i = 1; i < materials.length; ++i) {
                        queryStr.append(",?");
                    }
                    queryStr.append(")");
                }
            } else {
                queryStr.append(" and material.FNumber >= ? ");
            }
        }
        if (params.getString("materialTo") != null) {
            queryStr.append(" and material.FNumber <= ? ");
        }
        queryStr.append(this.getWhereSql(params, false));
        return queryStr.toString();
    }

    private void updateTotal(Context ctx, String tempTable, String orgTable, RptParams params) throws BOSException, EASBizException {
        StringBuffer updateSQL = new StringBuffer();
        this.groupBy = new Integer(params.getString("Classification"));
        switch (this.groupBy) {
            case 1: {
                updateSQL.append("insert into " + tempTable);
                updateSQL.append("(FID,FOrderSeq,FMaterialID");
                updateSQL.append(",FSaleOrgID,FBaseUnitID,FBaseQty,FActualPrice");
                updateSQL.append(",FAmount,FReceiveAmount");
                updateSQL.append(",FDiscountAmount,FAllSaleAmount");
                updateSQL.append(")");
                updateSQL.append("\r\n SELECT newbosid('88888888'),222");
                updateSQL.append(",temp.FMaterialID");
                updateSQL.append(",'Total',temp.FBaseUnitID");
                updateSQL.append(",sum(temp.FBaseQty) AS FBaseQty");
                updateSQL.append("\r\n ,case when  sum(temp.FBaseQty)= 0 then 0 ");
                updateSQL.append(" else decimal(sum(temp.FReceiveAmount) ");
                updateSQL.append(",17,4)/decimal(sum(temp.FBaseQty),17,4) end");
                updateSQL.append(",sum(temp.FAmount) AS FAmount");
                updateSQL.append("\r\n ,sum(temp.FReceiveAmount) AS FReceiveAmount");
                updateSQL.append("\r\n ,sum(temp.FDiscountAmount) AS FDiscountAmount");
                updateSQL.append(",sum(temp.FAllSaleAmount) AS FAllSaleAmount");
                updateSQL.append("\r\n  FROM " + tempTable + " AS temp");
                updateSQL.append(" group by ");
                updateSQL.append("temp.FMaterialID,temp.FBaseUnitID");
                this.executeUpdate(updateSQL.toString(), null, ctx);
                break;
            }
            case 2: {
                updateSQL.append("insert into " + tempTable);
                updateSQL.append("(FID,FOrderSeq,FAsstActID");
                updateSQL.append(",FSaleOrgID,FAmount,FReceiveAmount");
                updateSQL.append(",FDiscountAmount,FAllSaleAmount");
                updateSQL.append(")");
                updateSQL.append("\r\n SELECT newbosid('88888888'),222");
                updateSQL.append(",temp.FAsstActID");
                updateSQL.append(",'Total'");
                updateSQL.append(",sum(temp.FAmount) AS FAmount");
                updateSQL.append("\r\n ,sum(temp.FReceiveAmount) AS FReceiveAmount");
                updateSQL.append("\r\n ,sum(temp.FDiscountAmount) AS FDiscountAmount");
                updateSQL.append(",sum(temp.FAllSaleAmount) AS FAllSaleAmount");
                updateSQL.append("\r\n  FROM " + tempTable + " AS temp");
                updateSQL.append(" group by ");
                updateSQL.append("temp.FAsstActID");
                this.executeUpdate(updateSQL.toString(), null, ctx);
                break;
            }
            case 3: {
                updateSQL.append("insert into " + tempTable);
                updateSQL.append("(FID,FOrderSeq,FPersonId");
                updateSQL.append(",FSaleOrgID,FAmount,FReceiveAmount");
                updateSQL.append(",FDiscountAmount,FAllSaleAmount");
                updateSQL.append(")");
                updateSQL.append("\r\n SELECT newbosid('88888888'),222");
                updateSQL.append(",temp.FPersonId");
                updateSQL.append(",'Total'");
                updateSQL.append(",sum(temp.FAmount) AS FAmount");
                updateSQL.append("\r\n ,sum(temp.FReceiveAmount) AS FReceiveAmount");
                updateSQL.append("\r\n ,sum(temp.FDiscountAmount) AS FDiscountAmount");
                updateSQL.append(",sum(temp.FAllSaleAmount) AS FAllSaleAmount");
                updateSQL.append("\r\n  FROM " + tempTable + " AS temp");
                updateSQL.append(" group by ");
                updateSQL.append("temp.FPersonId");
                this.executeUpdate(updateSQL.toString(), null, ctx);
                break;
            }
            case 4: {
                updateSQL.append("insert into " + tempTable);
                updateSQL.append("(FID,FOrderSeq,FSaleGroupID");
                updateSQL.append(",FSaleOrgID,FAmount,FReceiveAmount");
                updateSQL.append(",FDiscountAmount,FAllSaleAmount");
                updateSQL.append(")");
                updateSQL.append("\r\n SELECT newbosid('88888888'),222");
                updateSQL.append(",temp.FSaleGroupID");
                updateSQL.append(",'Total'");
                updateSQL.append(",sum(temp.FAmount) AS FAmount");
                updateSQL.append("\r\n ,sum(temp.FReceiveAmount) AS FReceiveAmount");
                updateSQL.append("\r\n ,sum(temp.FDiscountAmount) AS FDiscountAmount");
                updateSQL.append(",sum(temp.FAllSaleAmount) AS FAllSaleAmount");
                updateSQL.append("\r\n  FROM " + tempTable + " AS temp");
                updateSQL.append(" group by ");
                updateSQL.append("temp.FSaleGroupID");
                this.executeUpdate(updateSQL.toString(), null, ctx);
                break;
            }
            case 5: {
                this.classficationGroup(ctx, tempTable, params, null, null);
                break;
            }
            case 6: {
                updateSQL.append("insert into " + tempTable);
                updateSQL.append("(FID,FOrderSeq,FMaterialID,FAsstActID");
                updateSQL.append(",FSaleOrgID,FAmount,FReceiveAmount");
                updateSQL.append(",FDiscountAmount,FAllSaleAmount");
                updateSQL.append(")");
                updateSQL.append("\r\n SELECT newbosid('88888888'),222");
                updateSQL.append(",temp.FMaterialID,temp.FAsstActID");
                updateSQL.append(",'zzzzz'");
                updateSQL.append(",sum(temp.FAmount) AS FAmount");
                updateSQL.append("\r\n ,sum(temp.FReceiveAmount) AS FReceiveAmount");
                updateSQL.append("\r\n ,sum(temp.FDiscountAmount) AS FDiscountAmount");
                updateSQL.append(",sum(temp.FAllSaleAmount) AS FAllSaleAmount");
                updateSQL.append("\r\n  FROM " + tempTable + " AS temp");
                updateSQL.append(" group by ");
                updateSQL.append("temp.FMaterialID,temp.FAsstActID");
                this.executeUpdate(updateSQL.toString(), null, ctx);
                updateSQL.setLength(0);
                updateSQL.append("insert into " + tempTable);
                updateSQL.append("(FID,FOrderSeq,FMaterialID,FAsstActID");
                updateSQL.append(",FSaleOrgID,FAmount,FReceiveAmount");
                updateSQL.append(",FDiscountAmount,FAllSaleAmount");
                updateSQL.append(")");
                updateSQL.append("\r\n SELECT newbosid('88888888'),333");
                updateSQL.append(",temp.FMaterialID,'zzzzz'");
                updateSQL.append(",'zzzzz'");
                updateSQL.append(",sum(temp.FAmount) AS FAmount");
                updateSQL.append("\r\n ,sum(temp.FReceiveAmount) AS FReceiveAmount");
                updateSQL.append("\r\n ,sum(temp.FDiscountAmount) AS FDiscountAmount");
                updateSQL.append(",sum(temp.FAllSaleAmount) AS FAllSaleAmount");
                updateSQL.append("\r\n  FROM " + tempTable + " AS temp");
                updateSQL.append("\r\n  where FSaleOrgID<>'zzzzz'");
                updateSQL.append(" group by ");
                updateSQL.append("temp.FMaterialID ");
                this.executeUpdate(updateSQL.toString(), null, ctx);
                break;
            }
            case 7: {
                updateSQL.append("insert into " + tempTable);
                updateSQL.append("(FID,FOrderSeq,FAsstActID,FMaterialID");
                updateSQL.append(",FSaleOrgID,FBaseUnitID,FBaseQty,FActualPrice");
                updateSQL.append(",FAmount,FReceiveAmount");
                updateSQL.append(",FDiscountAmount,FAllSaleAmount");
                updateSQL.append(")");
                updateSQL.append("\r\n SELECT newbosid('88888888'),222");
                updateSQL.append(",temp.FAsstActID,temp.FMaterialID");
                updateSQL.append(",'zzzzz',temp.FBaseUnitID");
                updateSQL.append(",sum(temp.FBaseQty) AS FBaseQty");
                updateSQL.append("\r\n ,case when  sum(temp.FBaseQty)= 0 then 0 ");
                updateSQL.append(" else decimal(sum(temp.FReceiveAmount) ");
                updateSQL.append(",17,4)/decimal(sum(temp.FBaseQty),17,4) end");
                updateSQL.append(",sum(temp.FAmount) AS FAmount");
                updateSQL.append("\r\n ,sum(temp.FReceiveAmount) AS FReceiveAmount");
                updateSQL.append("\r\n ,sum(temp.FDiscountAmount) AS FDiscountAmount");
                updateSQL.append(",sum(temp.FAllSaleAmount) AS FAllSaleAmount");
                updateSQL.append("\r\n  FROM " + tempTable + " AS temp");
                updateSQL.append(" group by ");
                updateSQL.append("temp.FAsstActID,temp.FMaterialID,temp.FBaseUnitID");
                this.executeUpdate(updateSQL.toString(), null, ctx);
                updateSQL.setLength(0);
                updateSQL.append("insert into " + tempTable);
                updateSQL.append("(FID,FOrderSeq,FAsstActID,FMaterialID");
                updateSQL.append(",FSaleOrgID,FBaseQty,FActualPrice");
                updateSQL.append(",FAmount,FReceiveAmount");
                updateSQL.append(",FDiscountAmount,FAllSaleAmount");
                updateSQL.append(")");
                updateSQL.append("\r\n SELECT newbosid('88888888'),333");
                updateSQL.append(",temp.FAsstActID,'zzzzz'");
                updateSQL.append(",'zzzzz'");
                updateSQL.append(",sum(temp.FBaseQty) AS FBaseQty");
                updateSQL.append("\r\n ,case when  sum(temp.FBaseQty)= 0 then 0 ");
                updateSQL.append(" else decimal(sum(temp.FReceiveAmount) ");
                updateSQL.append(",17,4)/decimal(sum(temp.FBaseQty),17,4) end");
                updateSQL.append(",sum(temp.FAmount) AS FAmount");
                updateSQL.append("\r\n ,sum(temp.FReceiveAmount) AS FReceiveAmount");
                updateSQL.append("\r\n ,sum(temp.FDiscountAmount) AS FDiscountAmount");
                updateSQL.append(",sum(temp.FAllSaleAmount) AS FAllSaleAmount");
                updateSQL.append("\r\n  FROM " + tempTable + " AS temp");
                updateSQL.append("\r\n  where FSaleOrgID<>'zzzzz'");
                updateSQL.append(" group by ");
                updateSQL.append("temp.FAsstActID");
                this.executeUpdate(updateSQL.toString(), null, ctx);
                break;
            }
            case 8: {
                updateSQL.append("insert into " + tempTable);
                updateSQL.append("(FID,FOrderSeq,FSaleGroupID,FPersonId,FMaterialID");
                updateSQL.append(",FSaleOrgID,FBaseUnitID,FBaseQty,FActualPrice");
                updateSQL.append(",FAmount,FReceiveAmount");
                updateSQL.append(",FDiscountAmount,FAllSaleAmount");
                updateSQL.append(")");
                updateSQL.append("\r\n SELECT newbosid('88888888'),222");
                updateSQL.append(",temp.FSaleGroupID,temp.FPersonId,temp.FMaterialID");
                updateSQL.append(",'zzzzz',temp.FBaseUnitID");
                updateSQL.append(",sum(temp.FBaseQty) AS FBaseQty");
                updateSQL.append("\r\n ,case when  sum(temp.FBaseQty)= 0 then 0 ");
                updateSQL.append(" else decimal(sum(temp.FReceiveAmount) ");
                updateSQL.append(",17,4)/decimal(sum(temp.FBaseQty),17,4) end");
                updateSQL.append(",sum(temp.FAmount) AS FAmount");
                updateSQL.append("\r\n ,sum(temp.FReceiveAmount) AS FReceiveAmount");
                updateSQL.append("\r\n ,sum(temp.FDiscountAmount) AS FDiscountAmount");
                updateSQL.append(",sum(temp.FAllSaleAmount) AS FAllSaleAmount");
                updateSQL.append("\r\n  FROM " + tempTable + " AS temp");
                updateSQL.append(" group by ");
                updateSQL.append("temp.FSaleGroupID,temp.FPersonId,temp.FMaterialID,temp.FBaseUnitID");
                this.executeUpdate(updateSQL.toString(), null, ctx);
                updateSQL.setLength(0);
                updateSQL.append("insert into " + tempTable);
                updateSQL.append("(FID,FOrderSeq,FSaleGroupID,FPersonId,FMaterialID");
                updateSQL.append(",FSaleOrgID,FBaseQty,FActualPrice");
                updateSQL.append(",FAmount,FReceiveAmount");
                updateSQL.append(",FDiscountAmount,FAllSaleAmount");
                updateSQL.append(")");
                updateSQL.append("\r\n SELECT newbosid('88888888'),333");
                updateSQL.append(",temp.FSaleGroupID,temp.FPersonId,'zzzzz'");
                updateSQL.append(",'zzzzz'");
                updateSQL.append(",sum(temp.FBaseQty) AS FBaseQty");
                updateSQL.append("\r\n ,case when  sum(temp.FBaseQty)= 0 then 0 ");
                updateSQL.append(" else decimal(sum(temp.FReceiveAmount) ");
                updateSQL.append(",17,4)/decimal(sum(temp.FBaseQty),17,4) end");
                updateSQL.append(",sum(temp.FAmount) AS FAmount");
                updateSQL.append("\r\n ,sum(temp.FReceiveAmount) AS FReceiveAmount");
                updateSQL.append("\r\n ,sum(temp.FDiscountAmount) AS FDiscountAmount");
                updateSQL.append(",sum(temp.FAllSaleAmount) AS FAllSaleAmount");
                updateSQL.append("\r\n  FROM " + tempTable + " AS temp");
                updateSQL.append("\r\n  where FSaleOrgID<>'zzzzz'");
                updateSQL.append(" group by ");
                updateSQL.append("temp.FSaleGroupID,temp.FPersonId");
                this.executeUpdate(updateSQL.toString(), null, ctx);
                updateSQL.setLength(0);
                updateSQL.append("insert into " + tempTable);
                updateSQL.append("(FID,FOrderSeq,FSaleGroupID,FPersonId,FMaterialID");
                updateSQL.append(",FSaleOrgID,FBaseQty,FActualPrice");
                updateSQL.append(",FAmount,FReceiveAmount");
                updateSQL.append(",FDiscountAmount,FAllSaleAmount");
                updateSQL.append(")");
                updateSQL.append("\r\n SELECT newbosid('88888888'),444");
                updateSQL.append(",temp.FSaleGroupID,'zzzzz','zzzzz'");
                updateSQL.append(",'zzzzz'");
                updateSQL.append(",sum(temp.FBaseQty) AS FBaseQty");
                updateSQL.append("\r\n ,case when  sum(temp.FBaseQty)= 0 then 0 ");
                updateSQL.append(" else decimal(sum(temp.FReceiveAmount) ");
                updateSQL.append(",17,4)/decimal(sum(temp.FBaseQty),17,4) end");
                updateSQL.append(",sum(temp.FAmount) AS FAmount");
                updateSQL.append("\r\n ,sum(temp.FReceiveAmount) AS FReceiveAmount");
                updateSQL.append("\r\n ,sum(temp.FDiscountAmount) AS FDiscountAmount");
                updateSQL.append(",sum(temp.FAllSaleAmount) AS FAllSaleAmount");
                updateSQL.append("\r\n  FROM " + tempTable + " AS temp");
                updateSQL.append("\r\n  where FSaleOrgID<>'zzzzz' and FMaterialID<>'zzzzz'");
                updateSQL.append(" group by ");
                updateSQL.append("temp.FSaleGroupID");
                this.executeUpdate(updateSQL.toString(), null, ctx);
                break;
            }
            case 9: {
                updateSQL.append("insert into " + tempTable);
                updateSQL.append("(FID,FOrderSeq,FSaleGroupID,FMaterialID");
                updateSQL.append(",FSaleOrgID,FBaseQty,FActualPrice");
                updateSQL.append(",FAmount,FReceiveAmount");
                updateSQL.append(",FDiscountAmount,FAllSaleAmount");
                updateSQL.append(")");
                updateSQL.append("\r\n SELECT newbosid('88888888'),222");
                updateSQL.append(",temp.FSaleGroupID,temp.FMaterialID");
                updateSQL.append(",'zzzzz'");
                updateSQL.append(",sum(temp.FBaseQty) AS FBaseQty");
                updateSQL.append("\r\n ,case when  sum(temp.FBaseQty)= 0 then 0 ");
                updateSQL.append(" else decimal(sum(temp.FReceiveAmount) ");
                updateSQL.append(",17,4)/decimal(sum(temp.FBaseQty),17,4) end");
                updateSQL.append(",sum(temp.FAmount) AS FAmount");
                updateSQL.append("\r\n ,sum(temp.FReceiveAmount) AS FReceiveAmount");
                updateSQL.append("\r\n ,sum(temp.FDiscountAmount) AS FDiscountAmount");
                updateSQL.append(",sum(temp.FAllSaleAmount) AS FAllSaleAmount");
                updateSQL.append("\r\n  FROM " + tempTable + " AS temp");
                updateSQL.append(" group by ");
                updateSQL.append("temp.FSaleGroupID,temp.FMaterialID,temp.FBaseUnitID");
                this.executeUpdate(updateSQL.toString(), null, ctx);
                updateSQL.setLength(0);
                updateSQL.append("insert into " + tempTable);
                updateSQL.append("(FID,FOrderSeq,FSaleGroupID,FMaterialID");
                updateSQL.append(",FSaleOrgID,FBaseQty,FActualPrice");
                updateSQL.append(",FAmount,FReceiveAmount");
                updateSQL.append(",FDiscountAmount,FAllSaleAmount");
                updateSQL.append(")");
                updateSQL.append("\r\n SELECT newbosid('88888888'),333");
                updateSQL.append(",temp.FSaleGroupID,'zzzzz'");
                updateSQL.append(",'zzzzz'");
                updateSQL.append(",sum(temp.FBaseQty) AS FBaseQty");
                updateSQL.append("\r\n ,case when  sum(temp.FBaseQty)= 0 then 0 ");
                updateSQL.append(" else decimal(sum(temp.FReceiveAmount) ");
                updateSQL.append(",17,4)/decimal(sum(temp.FBaseQty),17,4) end");
                updateSQL.append(",sum(temp.FAmount) AS FAmount");
                updateSQL.append("\r\n ,sum(temp.FReceiveAmount) AS FReceiveAmount");
                updateSQL.append("\r\n ,sum(temp.FDiscountAmount) AS FDiscountAmount");
                updateSQL.append(",sum(temp.FAllSaleAmount) AS FAllSaleAmount");
                updateSQL.append("\r\n  FROM " + tempTable + " AS temp");
                updateSQL.append("\r\n  where FSaleOrgID<>'zzzzz'");
                updateSQL.append(" group by ");
                updateSQL.append("temp.FSaleGroupID");
                this.executeUpdate(updateSQL.toString(), null, ctx);
                break;
            }
            case 10: {
                String groupByMaterial = "temp.FMaterialGroupID ";
                this.classficationGroup(ctx, tempTable, params, groupByMaterial, null);
                break;
            }
            case 11: {
                updateSQL.append("insert into " + tempTable);
                updateSQL.append("(FID,FOrderSeq,FPersonId,FAsstActID,FMaterialID");
                updateSQL.append(",FSaleOrgID,FBaseUnitID,FBaseQty,FActualPrice");
                updateSQL.append(",FAmount,FReceiveAmount");
                updateSQL.append(",FDiscountAmount,FAllSaleAmount");
                updateSQL.append(")");
                updateSQL.append("\r\n SELECT newbosid('88888888'),222");
                updateSQL.append(",temp.FPersonId,temp.FAsstActID,temp.FMaterialID");
                updateSQL.append(",'zzzzz',temp.FBaseUnitID");
                updateSQL.append(",sum(temp.FBaseQty) AS FBaseQty");
                updateSQL.append("\r\n ,case when  sum(temp.FBaseQty)= 0 then 0 ");
                updateSQL.append(" else decimal(sum(temp.FReceiveAmount) ");
                updateSQL.append(",17,4)/decimal(sum(temp.FBaseQty),17,4) end");
                updateSQL.append(",sum(temp.FAmount) AS FAmount");
                updateSQL.append("\r\n ,sum(temp.FReceiveAmount) AS FReceiveAmount");
                updateSQL.append("\r\n ,sum(temp.FDiscountAmount) AS FDiscountAmount");
                updateSQL.append(",sum(temp.FAllSaleAmount) AS FAllSaleAmount");
                updateSQL.append("\r\n  FROM " + tempTable + " AS temp");
                updateSQL.append(" group by ");
                updateSQL.append("temp.FPersonId,temp.FAsstActID,temp.FMaterialID,temp.FBaseUnitID");
                this.executeUpdate(updateSQL.toString(), null, ctx);
                updateSQL.setLength(0);
                updateSQL.append("insert into " + tempTable);
                updateSQL.append("(FID,FOrderSeq,FPersonId,FAsstActID,FMaterialID");
                updateSQL.append(",FSaleOrgID,FBaseQty,FActualPrice");
                updateSQL.append(",FAmount,FReceiveAmount");
                updateSQL.append(",FDiscountAmount,FAllSaleAmount");
                updateSQL.append(")");
                updateSQL.append("\r\n SELECT newbosid('88888888'),333");
                updateSQL.append(",temp.FPersonId,temp.FAsstActID,'zzzzz'");
                updateSQL.append(",'zzzzz'");
                updateSQL.append(",sum(temp.FBaseQty) AS FBaseQty");
                updateSQL.append("\r\n ,case when  sum(temp.FBaseQty)= 0 then 0 ");
                updateSQL.append(" else decimal(sum(temp.FReceiveAmount) ");
                updateSQL.append(",17,4)/decimal(sum(temp.FBaseQty),17,4) end");
                updateSQL.append(",sum(temp.FAmount) AS FAmount");
                updateSQL.append("\r\n ,sum(temp.FReceiveAmount) AS FReceiveAmount");
                updateSQL.append("\r\n ,sum(temp.FDiscountAmount) AS FDiscountAmount");
                updateSQL.append(",sum(temp.FAllSaleAmount) AS FAllSaleAmount");
                updateSQL.append("\r\n  FROM " + tempTable + " AS temp");
                updateSQL.append("\r\n  where FSaleOrgID<>'zzzzz'");
                updateSQL.append(" group by ");
                updateSQL.append("temp.FPersonId,temp.FAsstActID");
                this.executeUpdate(updateSQL.toString(), null, ctx);
                updateSQL.setLength(0);
                updateSQL.append("insert into " + tempTable);
                updateSQL.append("(FID,FOrderSeq,FPersonId,FAsstActID,FMaterialID");
                updateSQL.append(",FSaleOrgID,FBaseQty,FActualPrice");
                updateSQL.append(",FAmount,FReceiveAmount");
                updateSQL.append(",FDiscountAmount,FAllSaleAmount");
                updateSQL.append(")");
                updateSQL.append("\r\n SELECT newbosid('88888888'),444");
                updateSQL.append(",temp.FPersonId,'zzzzz','zzzzz'");
                updateSQL.append(",'zzzzz'");
                updateSQL.append(",sum(temp.FBaseQty) AS FBaseQty");
                updateSQL.append("\r\n ,case when  sum(temp.FBaseQty)= 0 then 0 ");
                updateSQL.append(" else decimal(sum(temp.FReceiveAmount) ");
                updateSQL.append(",17,4)/decimal(sum(temp.FBaseQty),17,4) end");
                updateSQL.append(",sum(temp.FAmount) AS FAmount");
                updateSQL.append("\r\n ,sum(temp.FReceiveAmount) AS FReceiveAmount");
                updateSQL.append("\r\n ,sum(temp.FDiscountAmount) AS FDiscountAmount");
                updateSQL.append(",sum(temp.FAllSaleAmount) AS FAllSaleAmount");
                updateSQL.append("\r\n  FROM " + tempTable + " AS temp");
                updateSQL.append("\r\n  where FSaleOrgID<>'zzzzz' and FMaterialID<>'zzzzz'");
                updateSQL.append(" group by ");
                updateSQL.append("temp.FPersonId");
                this.executeUpdate(updateSQL.toString(), null, ctx);
                break;
            }
            case 12: {
                updateSQL.append("insert into " + tempTable);
                updateSQL.append("(FID,FOrderSeq,FCustomerGroupID");
                updateSQL.append(",FSaleOrgID,FAmount,FReceiveAmount");
                updateSQL.append(",FDiscountAmount,FAllSaleAmount");
                updateSQL.append(")");
                updateSQL.append("\r\n SELECT newbosid('88888888'),222");
                updateSQL.append(",temp.FCustomerGroupID");
                updateSQL.append(",'Total'");
                updateSQL.append(",sum(temp.FAmount) AS FAmount");
                updateSQL.append("\r\n ,sum(temp.FReceiveAmount) AS FReceiveAmount");
                updateSQL.append("\r\n ,sum(temp.FDiscountAmount) AS FDiscountAmount");
                updateSQL.append(",sum(temp.FAllSaleAmount) AS FAllSaleAmount");
                updateSQL.append("\r\n  FROM " + tempTable + " AS temp");
                updateSQL.append(" group by ");
                updateSQL.append("temp.FCustomerGroupID");
                this.executeUpdate(updateSQL.toString(), null, ctx);
                break;
            }
            case 13: {
                updateSQL.append("insert into " + tempTable);
                updateSQL.append("(FID,FOrderSeq,FCustomerGroupID,FMaterialID");
                updateSQL.append(",FSaleOrgID,FBaseQty,FActualPrice");
                updateSQL.append(",FAmount,FReceiveAmount");
                updateSQL.append(",FDiscountAmount,FAllSaleAmount");
                updateSQL.append(")");
                updateSQL.append("\r\n SELECT newbosid('88888888'),222");
                updateSQL.append(",temp.FCustomerGroupID,temp.FMaterialID");
                updateSQL.append(",'zzzzz'");
                updateSQL.append(",sum(temp.FBaseQty) AS FBaseQty");
                updateSQL.append("\r\n ,case when  sum(temp.FBaseQty)= 0 then 0 ");
                updateSQL.append(" else decimal(sum(temp.FReceiveAmount) ");
                updateSQL.append(",17,4)/decimal(sum(temp.FBaseQty),17,4) end");
                updateSQL.append(",sum(temp.FAmount) AS FAmount");
                updateSQL.append("\r\n ,sum(temp.FReceiveAmount) AS FReceiveAmount");
                updateSQL.append("\r\n ,sum(temp.FDiscountAmount) AS FDiscountAmount");
                updateSQL.append(",sum(temp.FAllSaleAmount) AS FAllSaleAmount");
                updateSQL.append("\r\n  FROM " + tempTable + " AS temp");
                updateSQL.append(" group by ");
                updateSQL.append("temp.FCustomerGroupID,temp.FMaterialID,temp.FBaseUnitID");
                this.executeUpdate(updateSQL.toString(), null, ctx);
                updateSQL.setLength(0);
                updateSQL.append("insert into " + tempTable);
                updateSQL.append("(FID,FOrderSeq,FCustomerGroupID,FMaterialID");
                updateSQL.append(",FSaleOrgID,FBaseQty,FActualPrice");
                updateSQL.append(",FAmount,FReceiveAmount");
                updateSQL.append(",FDiscountAmount,FAllSaleAmount");
                updateSQL.append(")");
                updateSQL.append("\r\n SELECT newbosid('88888888'),333");
                updateSQL.append(",temp.FCustomerGroupID,'zzzzz'");
                updateSQL.append(",'zzzzz'");
                updateSQL.append(",sum(temp.FBaseQty) AS FBaseQty");
                updateSQL.append("\r\n ,case when  sum(temp.FBaseQty)= 0 then 0 ");
                updateSQL.append(" else decimal(sum(temp.FReceiveAmount) ");
                updateSQL.append(",17,4)/decimal(sum(temp.FBaseQty),17,4) end");
                updateSQL.append(",sum(temp.FAmount) AS FAmount");
                updateSQL.append("\r\n ,sum(temp.FReceiveAmount) AS FReceiveAmount");
                updateSQL.append("\r\n ,sum(temp.FDiscountAmount) AS FDiscountAmount");
                updateSQL.append(",sum(temp.FAllSaleAmount) AS FAllSaleAmount");
                updateSQL.append("\r\n  FROM " + tempTable + " AS temp");
                updateSQL.append("\r\n  where FSaleOrgID<>'zzzzz'");
                updateSQL.append(" group by ");
                updateSQL.append("temp.FCustomerGroupID");
                this.executeUpdate(updateSQL.toString(), null, ctx);
            }
        }
    }

    private void classficationGroup(Context ctx, String tempTable, RptParams params, String prefixFlds, String suffix) throws BOSException, EASBizException {
        this.minLevel = this.minLevel(ctx, params, tempTable);
        String sqlAddCol = this.addLevelCols2Table(this.minLevel, tempTable);
        String[] splitSqls = this.splitLongNumber(this.minLevel, params, tempTable);
        String[] sbuTotalSqls = this.subTotal(prefixFlds, suffix, this.minLevel, tempTable);
        String deleteSql = "DELETE FROM " + tempTable + " WHERE FGID IS NOT NULL";
        String SubLabel = "heji";
        String totalSql = null;
        if (this.minLevel > 1) {
            StringBuffer totalBuff = new StringBuffer();
            totalBuff.append("insert into ").append(tempTable).append(" (");
            if (prefixFlds != null) {
                totalBuff.append(prefixFlds).append(",");
            }
            totalBuff.append("FNumber_1,FNumber_1Name,saleQty,outQty,saleCost,saleAmount) ").append(" SELECT ");
            if (prefixFlds != null) {
                totalBuff.append(prefixFlds).append(",");
            }
            totalBuff.append("'").append(SubLabel).append("','").append(SubLabel).append("',sum(saleQty),sum(outQty),sum(saleCost),sum(saleAmount) ").append(" FROM ").append(tempTable).append(sp).append(" WHERE FGID is not null ").append(sp);
            if (prefixFlds != null) {
                totalBuff.append(" GROUP BY ").append(prefixFlds).append(sp);
            }
            totalSql = totalBuff.toString();
        }
        this.executeUpdate(sqlAddCol, null, ctx);
        this.executeBatchUpdate(ctx, splitSqls);
        this.executeBatchUpdate(ctx, sbuTotalSqls);
        if (totalSql != null) {
            this.executeUpdate(totalSql, null, ctx);
        }
        this.executeUpdate(deleteSql, null, ctx);
    }

    private RptTableHeader setRptHead(RptTableHeader header, RptParams params, Context ctx) {
        Object[][] labels = new Object[1][];
        boolean ckBxShowMShortName = params.getBoolean("ckBxShowMShortName");
        String[] temp_cols = new String[5];
        String[][] temp_labels = new String[1][5];
        String[] temp_hideCols = new String[3];
        String[][] temp_hideLabels = new String[1][3];
        if (ckBxShowMShortName) {
            temp_cols = new String[6];
            temp_labels = new String[1][6];
        }
        int iCols = 0;
        int iHideCols = 0;
        this.groupBy = new Integer(params.getString("Classification"));
        switch (this.groupBy) {
            case 1: {
                String materialNum = this.getServerResource("MaterialNum", ctx);
                String materialName = this.getServerResource("MaterialNam", ctx);
                String materialModel = this.getServerResource("MaterialMod", ctx);
                String materilShortName = this.getServerResource("MaterialShortName", ctx);
                temp_labels[0][iCols] = materialNum;
                temp_cols[iCols] = "MATERIAL_NUMBER";
                temp_labels[0][++iCols] = materialName;
                temp_cols[iCols] = "MATERIAL_NAME";
                ++iCols;
                if (ckBxShowMShortName) {
                    temp_labels[0][iCols] = materilShortName;
                    temp_cols[iCols] = "MATERIAL_SHORTNAME";
                    ++iCols;
                }
                temp_labels[0][iCols] = materialModel;
                temp_cols[iCols] = "MATERIAL_MODEL";
                ++iCols;
                temp_hideCols[iHideCols] = "MATERIAL_ID";
                temp_hideLabels[0][iHideCols] = "MATERIAL_ID";
                ++iHideCols;
                break;
            }
            case 2: {
                String customerName;
                temp_labels[0][iCols] = customerName = this.getServerResource("CustomerName", ctx);
                temp_cols[iCols] = "CUSTOMER_NAME";
                ++iCols;
                temp_hideCols[iHideCols] = "CUSTOMER_ID";
                temp_hideLabels[0][iHideCols] = "CUSTOMER_ID";
                ++iHideCols;
                break;
            }
            case 3: {
                String salePerson;
                temp_labels[0][iCols] = salePerson = ResourceBase.getString((String)"com.kingdee.eas.scm.sd.sale.SALEAutoGenerateResource", (String)"24_SaleDiscountTotalRptFacadeControllerBean", (Locale)ctx.getLocale());
                temp_cols[iCols] = "SALE_PERSON";
                ++iCols;
                temp_hideCols[iHideCols] = "SALE_PERSONID";
                temp_hideLabels[0][iHideCols] = "SALE_PERSONID";
                ++iHideCols;
                break;
            }
            case 4: {
                String saleGroup;
                temp_labels[0][iCols] = saleGroup = ResourceBase.getString((String)"com.kingdee.eas.scm.sd.sale.SALEAutoGenerateResource", (String)"25_SaleDiscountTotalRptFacadeControllerBean", (Locale)ctx.getLocale());
                temp_cols[iCols] = "SALE_GROUP";
                ++iCols;
                temp_hideCols[iHideCols] = "SALE_GROUPID";
                temp_hideLabels[0][iHideCols] = "SALE_GROUPID";
                ++iHideCols;
                break;
            }
            case 5: {
                String matGroupName;
                temp_labels[0][iCols] = matGroupName = ResourceBase.getString((String)"com.kingdee.eas.scm.sd.sale.SALEAutoGenerateResource", (String)"26_SaleDiscountTotalRptFacadeControllerBean", (Locale)ctx.getLocale());
                temp_cols[iCols] = "MATGROUP_NAME";
                ++iCols;
                temp_hideCols[iHideCols] = "MATGROUP_ID";
                temp_hideLabels[0][iHideCols] = "MATGROUP_ID";
                ++iHideCols;
                break;
            }
            case 6: {
                String materialNum = this.getServerResource("MaterialNum", ctx);
                String materialName = this.getServerResource("MaterialNam", ctx);
                String materialModel = this.getServerResource("MaterialMod", ctx);
                String customerName = this.getServerResource("CustomerName", ctx);
                String materilShortName = this.getServerResource("MaterialShortName", ctx);
                temp_labels[0][iCols] = materialNum;
                temp_cols[iCols] = "MATERIAL_NUMBER";
                temp_labels[0][++iCols] = materialName;
                temp_cols[iCols] = "MATERIAL_NAME";
                ++iCols;
                if (ckBxShowMShortName) {
                    temp_labels[0][iCols] = materilShortName;
                    temp_cols[iCols] = "MATERIAL_SHORTNAME";
                    ++iCols;
                }
                temp_labels[0][iCols] = materialModel;
                temp_cols[iCols] = "MATERIAL_MODEL";
                temp_labels[0][++iCols] = customerName;
                temp_cols[iCols] = "CUSTOMER_NAME";
                ++iCols;
                temp_hideCols[iHideCols] = "MATERIAL_ID";
                temp_hideLabels[0][iHideCols] = "MATERIAL_ID";
                temp_hideCols[++iHideCols] = "CUSTOMER_ID";
                temp_hideLabels[0][iHideCols] = "CUSTOMER_ID";
                ++iHideCols;
                break;
            }
            case 7: {
                String materialNum = this.getServerResource("MaterialNum", ctx);
                String materialName = this.getServerResource("MaterialNam", ctx);
                String materialModel = this.getServerResource("MaterialMod", ctx);
                String customerName = this.getServerResource("CustomerName", ctx);
                String materilShortName = this.getServerResource("MaterialShortName", ctx);
                temp_labels[0][iCols] = customerName;
                temp_cols[iCols] = "CUSTOMER_NAME";
                temp_labels[0][++iCols] = materialNum;
                temp_cols[iCols] = "MATERIAL_NUMBER";
                temp_labels[0][++iCols] = materialName;
                temp_cols[iCols] = "MATERIAL_NAME";
                ++iCols;
                if (ckBxShowMShortName) {
                    temp_labels[0][iCols] = materilShortName;
                    temp_cols[iCols] = "MATERIAL_SHORTNAME";
                    ++iCols;
                }
                temp_labels[0][iCols] = materialModel;
                temp_cols[iCols] = "MATERIAL_MODEL";
                ++iCols;
                temp_hideCols[iHideCols] = "CUSTOMER_ID";
                temp_hideLabels[0][iHideCols] = "CUSTOMER_ID";
                temp_hideCols[++iHideCols] = "MATERIAL_ID";
                temp_hideLabels[0][iHideCols] = "MATERIAL_ID";
                ++iHideCols;
                break;
            }
            case 8: {
                String materialNum = this.getServerResource("MaterialNum", ctx);
                String materialName = this.getServerResource("MaterialNam", ctx);
                String materialModel = this.getServerResource("MaterialMod", ctx);
                String materilShortName = this.getServerResource("MaterialShortName", ctx);
                String saleGroup = ResourceBase.getString((String)"com.kingdee.eas.scm.sd.sale.SALEAutoGenerateResource", (String)"25_SaleDiscountTotalRptFacadeControllerBean", (Locale)ctx.getLocale());
                String salePerson = ResourceBase.getString((String)"com.kingdee.eas.scm.sd.sale.SALEAutoGenerateResource", (String)"24_SaleDiscountTotalRptFacadeControllerBean", (Locale)ctx.getLocale());
                temp_labels[0][iCols] = saleGroup;
                temp_cols[iCols] = "SALE_GROUP";
                temp_labels[0][++iCols] = salePerson;
                temp_cols[iCols] = "SALE_PERSON";
                temp_labels[0][++iCols] = materialNum;
                temp_cols[iCols] = "MATERIAL_NUMBER";
                temp_labels[0][++iCols] = materialName;
                temp_cols[iCols] = "MATERIAL_NAME";
                ++iCols;
                if (ckBxShowMShortName) {
                    temp_labels[0][iCols] = materilShortName;
                    temp_cols[iCols] = "MATERIAL_SHORTNAME";
                    ++iCols;
                }
                temp_labels[0][iCols] = materialModel;
                temp_cols[iCols] = "MATERIAL_MODEL";
                ++iCols;
                temp_hideCols[iHideCols] = "SALE_GROUPID";
                temp_hideLabels[0][iHideCols] = "SALE_GROUPID";
                temp_hideCols[++iHideCols] = "SALE_PERSONID";
                temp_hideLabels[0][iHideCols] = "SALE_PERSONID";
                temp_hideCols[++iHideCols] = "MATERIAL_ID";
                temp_hideLabels[0][iHideCols] = "MATERIAL_ID";
                ++iHideCols;
                break;
            }
            case 9: {
                String saleGroup;
                String materialNum = this.getServerResource("MaterialNum", ctx);
                String materialName = this.getServerResource("MaterialNam", ctx);
                String materialModel = this.getServerResource("MaterialMod", ctx);
                String materilShortName = this.getServerResource("MaterialShortName", ctx);
                temp_labels[0][iCols] = saleGroup = ResourceBase.getString((String)"com.kingdee.eas.scm.sd.sale.SALEAutoGenerateResource", (String)"25_SaleDiscountTotalRptFacadeControllerBean", (Locale)ctx.getLocale());
                temp_cols[iCols] = "SALE_GROUP";
                temp_labels[0][++iCols] = materialNum;
                temp_cols[iCols] = "MATERIAL_NUMBER";
                temp_labels[0][++iCols] = materialName;
                temp_cols[iCols] = "MATERIAL_NAME";
                ++iCols;
                if (ckBxShowMShortName) {
                    temp_labels[0][iCols] = materilShortName;
                    temp_cols[iCols] = "MATERIAL_SHORTNAME";
                    ++iCols;
                }
                temp_labels[0][iCols] = materialModel;
                temp_cols[iCols] = "MATERIAL_MODEL";
                ++iCols;
                temp_hideCols[iHideCols] = "SALE_GROUPID";
                temp_hideLabels[0][iHideCols] = "SALE_GROUPID";
                temp_hideCols[++iHideCols] = "MATERIAL_ID";
                temp_hideLabels[0][iHideCols] = "MATERIAL_ID";
                ++iHideCols;
                break;
            }
            case 10: {
                String saleGroup;
                String matGroupName = ResourceBase.getString((String)"com.kingdee.eas.scm.sd.sale.SALEAutoGenerateResource", (String)"26_SaleDiscountTotalRptFacadeControllerBean", (Locale)ctx.getLocale());
                temp_labels[0][iCols] = saleGroup = ResourceBase.getString((String)"com.kingdee.eas.scm.sd.sale.SALEAutoGenerateResource", (String)"25_SaleDiscountTotalRptFacadeControllerBean", (Locale)ctx.getLocale());
                temp_cols[iCols] = "SALE_GROUP";
                temp_labels[0][++iCols] = matGroupName;
                temp_cols[iCols] = "MATGROUP_NAME";
                ++iCols;
                temp_hideCols[iHideCols] = "SALE_GROUPID";
                temp_hideLabels[0][iHideCols] = "SALE_GROUPID";
                temp_hideCols[++iHideCols] = "MATGROUP_ID";
                temp_hideLabels[0][iHideCols] = "MATGROUP_ID";
                ++iHideCols;
                break;
            }
            case 11: {
                String salePerson;
                String materialNum = this.getServerResource("MaterialNum", ctx);
                String materialName = this.getServerResource("MaterialNam", ctx);
                String materialModel = this.getServerResource("MaterialMod", ctx);
                String materilShortName = this.getServerResource("MaterialShortName", ctx);
                String customerName = this.getServerResource("CustomerName", ctx);
                temp_labels[0][iCols] = salePerson = ResourceBase.getString((String)"com.kingdee.eas.scm.sd.sale.SALEAutoGenerateResource", (String)"24_SaleDiscountTotalRptFacadeControllerBean", (Locale)ctx.getLocale());
                temp_cols[iCols] = "SALE_PERSON";
                temp_labels[0][++iCols] = customerName;
                temp_cols[iCols] = "CUSTOMER_NAME";
                temp_labels[0][++iCols] = materialNum;
                temp_cols[iCols] = "MATERIAL_NUMBER";
                temp_labels[0][++iCols] = materialName;
                temp_cols[iCols] = "MATERIAL_NAME";
                ++iCols;
                if (ckBxShowMShortName) {
                    temp_labels[0][iCols] = materilShortName;
                    temp_cols[iCols] = "MATERIAL_SHORTNAME";
                    ++iCols;
                }
                temp_labels[0][iCols] = materialModel;
                temp_cols[iCols] = "MATERIAL_MODEL";
                ++iCols;
                temp_hideCols[iHideCols] = "SALE_PERSONID";
                temp_hideLabels[0][iHideCols] = "SALE_PERSONID";
                temp_hideCols[++iHideCols] = "CUSTOMER_ID";
                temp_hideLabels[0][iHideCols] = "CUSTOMER_ID";
                temp_hideCols[++iHideCols] = "MATERIAL_ID";
                temp_hideLabels[0][iHideCols] = "MATERIAL_ID";
                ++iHideCols;
                break;
            }
            case 12: {
                String customerGroup;
                temp_labels[0][iCols] = customerGroup = ResourceBase.getString((String)"com.kingdee.eas.scm.sd.sale.SALEAutoGenerateResource", (String)"27_SaleDiscountTotalRptFacadeControllerBean", (Locale)ctx.getLocale());
                temp_cols[iCols] = "CUSTOMER_GROUP";
                ++iCols;
                temp_hideCols[iHideCols] = "CUSTOMER_GROUPID";
                temp_hideLabels[0][iHideCols] = "CUSTOMER_GROUPID";
                ++iHideCols;
                break;
            }
            case 13: {
                String customerGroup;
                String materialNum = this.getServerResource("MaterialNum", ctx);
                String materialName = this.getServerResource("MaterialNam", ctx);
                String materialModel = this.getServerResource("MaterialMod", ctx);
                String materilShortName = this.getServerResource("MaterialShortName", ctx);
                temp_labels[0][iCols] = customerGroup = ResourceBase.getString((String)"com.kingdee.eas.scm.sd.sale.SALEAutoGenerateResource", (String)"27_SaleDiscountTotalRptFacadeControllerBean", (Locale)ctx.getLocale());
                temp_cols[iCols] = "CUSTOMER_GROUP";
                temp_labels[0][++iCols] = materialNum;
                temp_cols[iCols] = "MATERIAL_NUMBER";
                temp_labels[0][++iCols] = materialName;
                temp_cols[iCols] = "MATERIAL_NAME";
                ++iCols;
                if (ckBxShowMShortName) {
                    temp_labels[0][iCols] = materilShortName;
                    temp_cols[iCols] = "MATERIAL_SHORTNAME";
                    ++iCols;
                }
                temp_labels[0][iCols] = materialModel;
                temp_cols[iCols] = "MATERIAL_MODEL";
                ++iCols;
                temp_hideCols[iHideCols] = "CUSTOMER_GROUPID";
                temp_hideLabels[0][iHideCols] = "CUSTOMER_GROUPID";
                temp_hideCols[++iHideCols] = "MATERIAL_ID";
                temp_hideLabels[0][iHideCols] = "MATERIAL_ID";
                ++iHideCols;
                break;
            }
        }
        String saleOrgName = this.getServerResource("SaleOrg", ctx);
        String Unit = this.getServerResource("Unit", ctx);
        String qty = this.getServerResource("Qty", ctx);
        String actualPrice = this.getServerResource("ActualTaxPrice", ctx);
        String amount = this.getServerResource("Amount", ctx);
        String taxAmount = this.getServerResource("SingleSaleAmount", ctx);
        String discountAmount = this.getServerResource("DiscountRate", ctx);
        String saleAmount = this.getServerResource("AllSaleAmount", ctx);
        int ii = 0;
        ii = this.groupBy == 1 || this.groupBy == 7 || this.groupBy == 8 || this.groupBy == 9 || this.groupBy == 11 || this.groupBy == 13 ? (ckBxShowMShortName ? 12 + iCols + iHideCols : 11 + iCols + iHideCols) : (ckBxShowMShortName ? 9 + iCols + iHideCols : 8 + iCols + iHideCols);
        String[] cols = new String[ii];
        labels = new String[1][ii];
        for (int r = 0; r < iCols; ++r) {
            cols[r] = temp_cols[r];
            labels[0][r] = temp_labels[0][r];
        }
        int a = 0;
        cols[iCols + a] = "SALEORG_NAME";
        labels[0][iCols + a] = saleOrgName;
        ++a;
        if (this.groupBy == 1 || this.groupBy == 7 || this.groupBy == 8 || this.groupBy == 9 || this.groupBy == 11 || this.groupBy == 13) {
            cols[iCols + a] = "UNIT_NAME";
            labels[0][iCols + a] = Unit;
            cols[iCols + ++a] = "ORDER_QTY";
            labels[0][iCols + a] = qty;
            cols[iCols + ++a] = "TAXPRICE";
            labels[0][iCols + a] = actualPrice;
            ++a;
        }
        cols[iCols + a] = "AMOUNT";
        labels[0][iCols + a] = amount;
        labels[0][iCols + ++a] = taxAmount;
        cols[iCols + a] = "TAXAMOUNT";
        labels[0][iCols + ++a] = discountAmount;
        cols[iCols + a] = "DISCOUNTRATE";
        labels[0][iCols + ++a] = saleAmount;
        cols[iCols + a] = "SALE_AMOUNT";
        cols[iCols + ++a] = "SALEORG_ID";
        labels[0][iCols + a] = "SALEORG_ID";
        cols[iCols + ++a] = "SALEORG_ISLEAF";
        labels[0][iCols + a] = "SALEORG_ISLEAF";
        cols[iCols + ++a] = "SALEORG_LEVEL";
        labels[0][iCols + a] = "SALEORG_LEVEL";
        ++a;
        for (int r = 0; r < iHideCols; ++r) {
            labels[0][iCols + a] = temp_hideLabels[0][r];
            cols[iCols + a] = temp_hideCols[r];
            ++a;
        }
        this.setHeaderColumns(header, cols, params);
        header.setLabels(labels, true);
        return header;
    }

    private void setHeaderColumns(RptTableHeader header, String[] columns, RptParams params) {
        String qtyFormat = SaleUtil.getFormatPattern(4, true);
        RptTableColumn col = null;
        this.groupBy = new Integer(params.getString("Classification"));
        int c = columns.length;
        for (int i = 0; i < c; ++i) {
            col = new RptTableColumn(columns[i]);
            col.setWidth(-1);
            if (this.groupBy == 1) {
                if (params.getBoolean("ckBxShowMShortName")) {
                    if (i >= 6 && i <= 11) {
                        col.setWidth(120);
                        col.setAligment(2);
                        col.setFormatPattern(qtyFormat);
                    }
                    if (i > 11) {
                        col.setHided(true);
                    }
                } else {
                    if (i >= 5 && i <= 10) {
                        col.setWidth(120);
                        col.setAligment(2);
                        col.setFormatPattern(qtyFormat);
                    }
                    if (i > 10) {
                        col.setHided(true);
                    }
                }
            }
            if (this.groupBy == 2 || this.groupBy == 3 || this.groupBy == 4 || this.groupBy == 5 || this.groupBy == 12) {
                if (i >= 2 && i <= 5) {
                    col.setWidth(120);
                    col.setAligment(2);
                    col.setFormatPattern(qtyFormat);
                }
                if (i > 5) {
                    col.setHided(true);
                }
            }
            if (this.groupBy == 6) {
                if (params.getBoolean("ckBxShowMShortName")) {
                    if (i >= 6 && i <= 9) {
                        col.setWidth(120);
                        col.setAligment(2);
                        col.setFormatPattern(qtyFormat);
                    }
                    if (i > 9) {
                        col.setHided(true);
                    }
                } else {
                    if (i >= 5 && i <= 8) {
                        col.setWidth(120);
                        col.setAligment(2);
                        col.setFormatPattern(qtyFormat);
                    }
                    if (i > 8) {
                        col.setHided(true);
                    }
                }
            }
            if (this.groupBy == 7 || this.groupBy == 9 || this.groupBy == 13) {
                if (params.getBoolean("ckBxShowMShortName")) {
                    if (i >= 7 && i <= 12) {
                        col.setWidth(120);
                        col.setAligment(2);
                        col.setFormatPattern(qtyFormat);
                    }
                    if (i > 12) {
                        col.setHided(true);
                    }
                } else {
                    if (i >= 6 && i <= 11) {
                        col.setWidth(120);
                        col.setAligment(2);
                        col.setFormatPattern(qtyFormat);
                    }
                    if (i > 11) {
                        col.setHided(true);
                    }
                }
            }
            if (this.groupBy == 8) {
                if (params.getBoolean("ckBxShowMShortName")) {
                    if (i >= 8 && i <= 13) {
                        col.setWidth(120);
                        col.setAligment(2);
                        col.setFormatPattern(qtyFormat);
                    }
                    if (i > 13) {
                        col.setHided(true);
                    }
                } else {
                    if (i >= 7 && i <= 12) {
                        col.setWidth(120);
                        col.setAligment(2);
                        col.setFormatPattern(qtyFormat);
                    }
                    if (i > 12) {
                        col.setHided(true);
                    }
                }
            }
            if (this.groupBy == 10) {
                if (i >= 3 && i <= 6) {
                    col.setWidth(120);
                    col.setAligment(2);
                    col.setFormatPattern(qtyFormat);
                }
                if (i > 6) {
                    col.setHided(true);
                }
            }
            if (this.groupBy == 11) {
                if (params.getBoolean("ckBxShowMShortName")) {
                    if (i >= 8 && i <= 13) {
                        col.setWidth(120);
                        col.setAligment(2);
                        col.setFormatPattern(qtyFormat);
                    }
                    if (i > 13) {
                        col.setHided(true);
                    }
                } else {
                    if (i >= 7 && i <= 12) {
                        col.setWidth(120);
                        col.setAligment(2);
                        col.setFormatPattern(qtyFormat);
                    }
                    if (i > 12) {
                        col.setHided(true);
                    }
                }
            }
            header.addColumn(col);
        }
    }

    private String getWhereSql(RptParams params, boolean isFirstQuery) {
        StringBuffer sqlStr = new StringBuffer(" ");
        boolean ckBxShowMShortName = params.getBoolean("ckBxShowMShortName");
        String shortNameFrom = (String)params.getObject("shortNameFrom");
        String shortNameTo = (String)params.getObject("shortNameTo");
        if (ckBxShowMShortName) {
            if (shortNameFrom != null && shortNameFrom.trim().length() > 0) {
                if (shortNameFrom.indexOf("'") != -1) {
                    shortNameFrom = shortNameFrom.replaceAll("'", "''");
                }
                if (sqlStr.toString().indexOf("where") == -1 && isFirstQuery) {
                    sqlStr.append("\r\n where ");
                    sqlStr.append(" material.FShortName >= '").append(shortNameFrom.trim()).append("' ");
                } else {
                    sqlStr.append(" and material.FShortName >= '").append(shortNameFrom.trim()).append("' ");
                }
            }
            if (shortNameTo != null && shortNameTo.trim().length() > 0) {
                if (shortNameTo.indexOf("'") != -1) {
                    shortNameTo = shortNameTo.replaceAll("'", "''");
                }
                if (sqlStr.toString().indexOf("where") == -1 && isFirstQuery) {
                    sqlStr.append("\r\n where ");
                    sqlStr.append(" material.FShortName <= '").append(shortNameTo.trim()).append("' ");
                } else {
                    sqlStr.append(" and material.FShortName <= '").append(shortNameTo.trim()).append("' ");
                }
            }
        }
        return sqlStr.toString();
    }

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        String tempTable = params.getString("tempTable");
        String orgUnitTempTable = params.getString("OrgTempTable");
        StringBuffer displayCol = new StringBuffer();
        boolean ckBxShowMShortName = params.getBoolean("ckBxShowMShortName");
        this.groupBy = new Integer(params.getString("Classification"));
        switch (this.groupBy) {
            case 1: {
                displayCol.append(" SELECT ");
                displayCol.append(" material.FNumber AS MATERIAL_NUMBER");
                displayCol.append(",material.FName_");
                displayCol.append(locLan);
                displayCol.append(" AS MATERIAL_NAME,");
                displayCol.append(ckBxShowMShortName ? "material.FShortName AS MATERIAL_SHORTNAME," : " ");
                displayCol.append("material.FModel AS MATERIAL_MODEL");
                displayCol.append("\r\n ,ORG.FName_").append(locLan);
                displayCol.append(" AS SALEORG_NAME");
                displayCol.append("\r\n ,UNIT.FName_").append(locLan);
                displayCol.append(" AS UNIT_NAME");
                displayCol.append("\r\n ,temp.FBaseQty AS FBaseQty");
                displayCol.append(",case when temp.FBaseQty = 0 then 0 else ");
                displayCol.append(" TO_DECIMAL(temp.FReceiveAmount/temp.FBaseQty,19,4) end AS FActualPrice");
                displayCol.append("\r\n ,temp.FAmount AS FAmount");
                displayCol.append("\r\n ,temp.FReceiveAmount AS FReceiveAmount");
                displayCol.append(",temp.FDiscountAmount AS FDiscountAmount");
                displayCol.append("\r\n ,temp.FAllSaleAmount AS FAllSaleAmount");
                displayCol.append(",temp.FSaleOrgID AS FSALEORG_ID");
                displayCol.append(",org.FIsleaf AS FSALEORG_ISLEAF");
                displayCol.append(",org.FLevel AS FSALEORG_LEVEL");
                displayCol.append(",temp.FMaterialID FMaterialID ");
                displayCol.append("\r\n from  " + tempTable + " temp \r\n LEFT OUTER JOIN ");
                displayCol.append(orgUnitTempTable).append(" org ON temp.FSaleOrgID = org.FID ");
                displayCol.append("\r\n LEFT OUTER JOIN T_BD_Material material on temp.FMaterialID = material.FID ");
                displayCol.append("\r\n LEFT OUTER JOIN T_BD_MeasureUnit AS UNIT ON temp.FBaseUnitID = UNIT.FID");
                displayCol.append("\r\n order by temp.FMaterialID,temp.FBaseUnitID,temp.FOrderSeq,temp.FSaleOrgID");
                displayCol.append(" asc ");
                break;
            }
            case 2: {
                displayCol.append(" SELECT ");
                displayCol.append(" CUSTOMER.FName_");
                displayCol.append(locLan);
                displayCol.append(" AS CUSTOMER_NAME");
                displayCol.append("\r\n ,ORG.FName_").append(locLan);
                displayCol.append(" AS SALEORG_NAME");
                displayCol.append("\r\n ,temp.FAmount AS FAmount");
                displayCol.append("\r\n ,temp.FReceiveAmount AS FReceiveAmount");
                displayCol.append(",temp.FDiscountAmount AS FDiscountAmount");
                displayCol.append("\r\n ,temp.FAllSaleAmount AS FAllSaleAmount");
                displayCol.append(",temp.FSaleOrgID AS FSALEORG_ID");
                displayCol.append(",org.FIsleaf AS FSALEORG_ISLEAF");
                displayCol.append(",org.FLevel AS FSALEORG_LEVEL");
                displayCol.append(",temp.FAsstActID  FAsstActID ");
                displayCol.append("\r\n from  " + tempTable + " temp \r\n LEFT OUTER JOIN ");
                displayCol.append(orgUnitTempTable);
                displayCol.append(" org ON temp.FSaleOrgID = org.FID ");
                displayCol.append(" \r\n LEFT OUTER JOIN T_BD_Customer AS CUSTOMER ");
                displayCol.append(" ON temp.FAsstActID = CUSTOMER.FID ");
                displayCol.append(" \r\n order by temp.FAsstActID,temp.FOrderSeq,temp.FSaleOrgID ");
                displayCol.append(" asc ");
                break;
            }
            case 3: {
                displayCol.append(" SELECT ");
                displayCol.append(" PERSON.FName_");
                displayCol.append(locLan);
                displayCol.append(" AS PERSON_NAME");
                displayCol.append("\r\n ,ORG.FName_").append(locLan);
                displayCol.append(" AS SALEORG_NAME");
                displayCol.append("\r\n ,temp.FAmount AS FAmount");
                displayCol.append("\r\n ,temp.FReceiveAmount AS FReceiveAmount");
                displayCol.append(",temp.FDiscountAmount AS FDiscountAmount");
                displayCol.append("\r\n ,temp.FAllSaleAmount AS FAllSaleAmount");
                displayCol.append(",temp.FSaleOrgID AS FSALEORG_ID");
                displayCol.append(",org.FIsleaf AS FSALEORG_ISLEAF");
                displayCol.append(",org.FLevel AS FSALEORG_LEVEL");
                displayCol.append(",temp.FPersonId FPersonId");
                displayCol.append("\r\n from  " + tempTable + " temp \r\n LEFT OUTER JOIN ");
                displayCol.append(orgUnitTempTable);
                displayCol.append(" org ON temp.FSaleOrgID = org.FID ");
                displayCol.append(" \r\n LEFT OUTER JOIN T_BD_Person AS PERSON ");
                displayCol.append(" ON temp.FPersonId = PERSON.FID");
                displayCol.append(" \r\n order by temp.FPersonId,temp.FOrderSeq,temp.FSaleOrgID asc ");
                break;
            }
            case 4: {
                displayCol.append(" SELECT ");
                displayCol.append(" SALEGROUP.FName_");
                displayCol.append(locLan);
                displayCol.append(" AS SALEGROUP_NAME");
                displayCol.append("\r\n ,ORG.FName_").append(locLan);
                displayCol.append(" AS SALEORG_NAME");
                displayCol.append("\r\n ,temp.FAmount AS FAmount");
                displayCol.append("\r\n ,temp.FReceiveAmount AS FReceiveAmount");
                displayCol.append(",temp.FDiscountAmount AS FDiscountAmount");
                displayCol.append("\r\n ,temp.FAllSaleAmount AS FAllSaleAmount");
                displayCol.append(",temp.FSaleOrgID AS FSALEORG_ID");
                displayCol.append(",org.FIsleaf AS FSALEORG_ISLEAF");
                displayCol.append(",org.FLevel AS FSALEORG_LEVEL");
                displayCol.append(",temp.FSaleGroupID FSaleGroupID");
                displayCol.append("\r\n from  " + tempTable + " temp \r\n LEFT OUTER JOIN ");
                displayCol.append(orgUnitTempTable).append(" org ON temp.FSaleOrgID = org.FID ");
                displayCol.append(" \r\n LEFT OUTER JOIN T_BD_SaleGroup AS SALEGROUP ON temp.FSaleGroupID = SALEGROUP.FID");
                displayCol.append(" \r\n order by temp.FSaleGroupID,temp.FOrderSeq,temp.FSaleOrgID asc ");
                break;
            }
            case 5: {
                displayCol.append(" SELECT ");
                displayCol.append(" MaterialGroup.FName_");
                displayCol.append(locLan);
                displayCol.append(" AS MATGROUP_NAME");
                displayCol.append("\r\n ,ORG.FName_").append(locLan);
                displayCol.append(" AS SALEORG_NAME");
                displayCol.append("\r\n ,temp.FAmount AS FAmount");
                displayCol.append("\r\n ,temp.FReceiveAmount AS FReceiveAmount");
                displayCol.append(",temp.FDiscountAmount AS FDiscountAmount");
                displayCol.append("\r\n ,temp.FAllSaleAmount AS FAllSaleAmount");
                displayCol.append(",temp.FSaleOrgID AS FSALEORG_ID");
                displayCol.append(",org.FIsleaf AS FSALEORG_ISLEAF");
                displayCol.append(",org.FLevel AS FSALEORG_LEVEL");
                displayCol.append(",material.FMaterialGroupID FMaterialGroupID");
                displayCol.append("\r\n from  " + tempTable + " temp \r\n LEFT OUTER JOIN ");
                displayCol.append(orgUnitTempTable);
                displayCol.append(" org ON temp.FSaleOrgID = org.FID ");
                displayCol.append("\r\n LEFT OUTER JOIN T_BD_Material material ");
                displayCol.append(" on temp.FMaterialID = material.FID ");
                displayCol.append(" \r\n LEFT OUTER JOIN T_BD_MaterialGroup AS MaterialGroup ");
                displayCol.append(" ON material.FMaterialGroupID = MaterialGroup.FID");
                displayCol.append("\r\n order by temp.FMaterialGroupID,temp.FOrderSeq,temp.FSaleOrgID ");
                displayCol.append(" asc ");
                break;
            }
            case 6: {
                displayCol.append(" SELECT ");
                displayCol.append(" material.FNumber AS MATERIAL_NUMBER");
                displayCol.append(",material.FName_");
                displayCol.append(locLan);
                displayCol.append(" AS MATERIAL_NAME,");
                displayCol.append(ckBxShowMShortName ? "material.FShortName AS MATERIAL_SHORTNAME," : " ");
                displayCol.append("material.FModel AS MATERIAL_MODEL");
                displayCol.append(",CUSTOMER.FName_");
                displayCol.append(locLan);
                displayCol.append(" AS CUSTOMER_NAME");
                displayCol.append("\r\n ,ORG.FName_").append(locLan);
                displayCol.append(" AS SALEORG_NAME");
                displayCol.append("\r\n ,temp.FAmount AS FAmount");
                displayCol.append("\r\n ,temp.FReceiveAmount AS FReceiveAmount");
                displayCol.append(",temp.FDiscountAmount AS FDiscountAmount");
                displayCol.append("\r\n ,temp.FAllSaleAmount AS FAllSaleAmount");
                displayCol.append(",temp.FSaleOrgID AS FSALEORG_ID");
                displayCol.append(",org.FIsleaf AS FSALEORG_ISLEAF");
                displayCol.append(",org.FLevel AS FSALEORG_LEVEL");
                displayCol.append(",temp.FMaterialID FMaterialID ");
                displayCol.append(",temp.FAsstActID  FAsstActID ");
                displayCol.append("\r\n from  " + tempTable + " temp \r\n LEFT OUTER JOIN ");
                displayCol.append(orgUnitTempTable);
                displayCol.append(" org ON temp.FSaleOrgID = org.FID ");
                displayCol.append("\r\n LEFT OUTER JOIN T_BD_Material material ");
                displayCol.append(" on temp.FMaterialID = material.FID ");
                displayCol.append(" \r\n LEFT OUTER JOIN T_BD_Customer AS CUSTOMER ");
                displayCol.append(" ON temp.FAsstActID = CUSTOMER.FID ");
                displayCol.append("\r\n order by temp.FMaterialID,temp.FAsstActID,temp.FOrderSeq,temp.FSaleOrgID");
                displayCol.append(" asc ");
                break;
            }
            case 7: {
                displayCol.append(" SELECT ");
                displayCol.append(" CUSTOMER.FName_");
                displayCol.append(locLan);
                displayCol.append(" AS CUSTOMER_NAME");
                displayCol.append(",material.FNumber AS MATERIAL_NUMBER");
                displayCol.append(",material.FName_");
                displayCol.append(locLan);
                displayCol.append(" AS MATERIAL_NAME,");
                displayCol.append(ckBxShowMShortName ? "material.FShortName AS MATERIAL_SHORTNAME," : " ");
                displayCol.append("material.FModel AS MATERIAL_MODEL");
                displayCol.append("\r\n ,ORG.FName_").append(locLan);
                displayCol.append(" AS SALEORG_NAME");
                displayCol.append("\r\n ,UNIT.FName_").append(locLan);
                displayCol.append(" AS UNIT_NAME");
                displayCol.append("\r\n ,temp.FBaseQty AS FBaseQty");
                displayCol.append(",case when temp.FBaseQty = 0 then 0 else ");
                displayCol.append(" TO_DECIMAL(temp.FReceiveAmount/temp.FBaseQty,19,4) end AS FActualPrice");
                displayCol.append("\r\n ,temp.FAmount AS FAmount");
                displayCol.append("\r\n ,temp.FReceiveAmount AS FReceiveAmount");
                displayCol.append(",temp.FDiscountAmount AS FDiscountAmount");
                displayCol.append("\r\n ,temp.FAllSaleAmount AS FAllSaleAmount");
                displayCol.append(",temp.FSaleOrgID AS FSALEORG_ID");
                displayCol.append(",org.FIsleaf AS FSALEORG_ISLEAF");
                displayCol.append(",org.FLevel AS FSALEORG_LEVEL");
                displayCol.append(",temp.FAsstActID  FAsstActID ");
                displayCol.append(",temp.FMaterialID FMaterialID ");
                displayCol.append("\r\n from  " + tempTable + " temp \r\n LEFT OUTER JOIN ");
                displayCol.append(orgUnitTempTable);
                displayCol.append(" org ON temp.FSaleOrgID = org.FID ");
                displayCol.append(" \r\n LEFT OUTER JOIN T_BD_Customer AS CUSTOMER ");
                displayCol.append(" ON temp.FAsstActID = CUSTOMER.FID ");
                displayCol.append("\r\n LEFT OUTER JOIN T_BD_Material material ");
                displayCol.append(" on temp.FMaterialID = material.FID ");
                displayCol.append(" \r\n LEFT OUTER JOIN T_BD_MeasureUnit AS UNIT ");
                displayCol.append(" ON temp.FBaseUnitID = UNIT.FID");
                displayCol.append("\r\n order by temp.FAsstActID,temp.FMaterialID,temp.FBaseUnitID,temp.FOrderSeq,temp.FSaleOrgID");
                displayCol.append(" asc ");
                break;
            }
            case 8: {
                displayCol.append(" SELECT ");
                displayCol.append(" SALEGROUP.FName_");
                displayCol.append(locLan);
                displayCol.append(" AS SALEGROUP_NAME");
                displayCol.append(",PERSON.FName_");
                displayCol.append(locLan);
                displayCol.append(" AS PERSON_NAME");
                displayCol.append(",material.FNumber AS MATERIAL_NUMBER");
                displayCol.append(",material.FName_");
                displayCol.append(locLan);
                displayCol.append(" AS MATERIAL_NAME,");
                displayCol.append(ckBxShowMShortName ? "material.FShortName AS MATERIAL_SHORTNAME," : " ");
                displayCol.append("material.FModel AS MATERIAL_MODEL");
                displayCol.append("\r\n ,ORG.FName_").append(locLan);
                displayCol.append(" AS SALEORG_NAME");
                displayCol.append("\r\n ,UNIT.FName_").append(locLan);
                displayCol.append(" AS UNIT_NAME");
                displayCol.append("\r\n ,temp.FBaseQty AS FBaseQty");
                displayCol.append(",case when temp.FBaseQty = 0 then 0 else ");
                displayCol.append(" TO_DECIMAL(temp.FReceiveAmount/temp.FBaseQty,19,4) end AS FActualPrice");
                displayCol.append("\r\n ,temp.FAmount AS FAmount");
                displayCol.append("\r\n ,temp.FReceiveAmount AS FReceiveAmount");
                displayCol.append(",temp.FDiscountAmount AS FDiscountAmount");
                displayCol.append("\r\n ,temp.FAllSaleAmount AS FAllSaleAmount");
                displayCol.append(",temp.FSaleOrgID AS FSALEORG_ID");
                displayCol.append(",org.FIsleaf AS FSALEORG_ISLEAF");
                displayCol.append(",org.FLevel AS FSALEORG_LEVEL");
                displayCol.append(",temp.FSaleGroupID FSaleGroupID");
                displayCol.append(",temp.FPersonId FPersonId");
                displayCol.append(",temp.FMaterialID FMaterialID ");
                displayCol.append("\r\n from  " + tempTable + " temp \r\n LEFT OUTER JOIN ");
                displayCol.append(orgUnitTempTable);
                displayCol.append(" org ON temp.FSaleOrgID = org.FID ");
                displayCol.append(" \r\n LEFT OUTER JOIN T_BD_SaleGroup AS SALEGROUP ON temp.FSaleGroupID = SALEGROUP.FID");
                displayCol.append(" \r\n LEFT OUTER JOIN T_BD_Person AS PERSON ON temp.FPersonId = PERSON.FID");
                displayCol.append("\r\n LEFT OUTER JOIN T_BD_Material material on temp.FMaterialID = material.FID ");
                displayCol.append(" \r\n LEFT OUTER JOIN T_BD_MeasureUnit AS UNIT ON temp.FBaseUnitID = UNIT.FID");
                displayCol.append("\r\n order by temp.FSaleGroupID,temp.FPersonId,temp.FMaterialID,temp.FBaseUnitID,temp.FOrderSeq,temp.FSaleOrgID");
                displayCol.append(" asc ");
                break;
            }
            case 9: {
                displayCol.append(" SELECT ");
                displayCol.append(" SALEGROUP.FName_");
                displayCol.append(locLan);
                displayCol.append(" AS SALEGROUP_NAME");
                displayCol.append(",material.FNumber AS MATERIAL_NUMBER");
                displayCol.append(",material.FName_");
                displayCol.append(locLan);
                displayCol.append(" AS MATERIAL_NAME,");
                displayCol.append(ckBxShowMShortName ? "material.FShortName AS MATERIAL_SHORTNAME," : " ");
                displayCol.append("material.FModel AS MATERIAL_MODEL");
                displayCol.append("\r\n ,ORG.FName_").append(locLan);
                displayCol.append(" AS SALEORG_NAME");
                displayCol.append("\r\n ,UNIT.FName_").append(locLan);
                displayCol.append(" AS UNIT_NAME");
                displayCol.append("\r\n ,temp.FBaseQty AS FBaseQty");
                displayCol.append(",case when temp.FBaseQty = 0 then 0 else ");
                displayCol.append(" TO_DECIMAL(temp.FReceiveAmount/temp.FBaseQty,19,4) end AS FActualPrice");
                displayCol.append("\r\n ,temp.FAmount AS FAmount");
                displayCol.append("\r\n ,temp.FReceiveAmount AS FReceiveAmount");
                displayCol.append(",temp.FDiscountAmount AS FDiscountAmount");
                displayCol.append("\r\n ,temp.FAllSaleAmount AS FAllSaleAmount");
                displayCol.append(",temp.FSaleOrgID AS FSALEORG_ID");
                displayCol.append(",org.FIsleaf AS FSALEORG_ISLEAF");
                displayCol.append(",org.FLevel AS FSALEORG_LEVEL");
                displayCol.append(",temp.FSaleGroupID FSaleGroupID");
                displayCol.append(",temp.FMaterialID FMaterialID ");
                displayCol.append("\r\n from  " + tempTable + " temp \r\n LEFT OUTER JOIN ");
                displayCol.append(orgUnitTempTable);
                displayCol.append(" org ON temp.FSaleOrgID = org.FID ");
                displayCol.append(" \r\n LEFT OUTER JOIN T_BD_SaleGroup AS SALEGROUP ");
                displayCol.append(" ON temp.FSaleGroupID = SALEGROUP.FID");
                displayCol.append("\r\n LEFT OUTER JOIN T_BD_Material material ");
                displayCol.append(" on temp.FMaterialID = material.FID ");
                displayCol.append(" \r\n LEFT OUTER JOIN T_BD_MeasureUnit AS UNIT ");
                displayCol.append(" ON temp.FBaseUnitID = UNIT.FID");
                displayCol.append("\r\n order by temp.FSaleGroupID,temp.FMaterialID,temp.FBaseUnitID,temp.FOrderSeq,temp.FSaleOrgID");
                displayCol.append(" asc ");
                break;
            }
            case 10: {
                displayCol.append(" SELECT ");
                displayCol.append(" CUSTOMER.FName_");
                displayCol.append(locLan);
                displayCol.append(" AS SALEGROUP_NAME");
                displayCol.append(",MaterialGroup.FName_");
                displayCol.append(locLan);
                displayCol.append(" AS MATGROUP_NAME");
                displayCol.append("\r\n ,ORG.FName_").append(locLan);
                displayCol.append(" AS SALEORG_NAME");
                displayCol.append("\r\n ,temp.FAmount AS FAmount");
                displayCol.append("\r\n ,temp.FReceiveAmount AS FReceiveAmount");
                displayCol.append(",temp.FDiscountAmount AS FDiscountAmount");
                displayCol.append("\r\n ,temp.FAllSaleAmount AS FAllSaleAmount");
                displayCol.append(",temp.FSaleOrgID AS FSALEORG_ID");
                displayCol.append(",org.FIsleaf AS FSALEORG_ISLEAF");
                displayCol.append(",org.FLevel AS FSALEORG_LEVEL");
                displayCol.append(",temp.FSaleGroupID FSaleGroupID");
                displayCol.append(",material.FMaterialGroupID FMaterialGroupID");
                displayCol.append("\r\n from  " + tempTable + " temp \r\n LEFT OUTER JOIN ");
                displayCol.append(orgUnitTempTable);
                displayCol.append(" org ON temp.FSaleOrgID = org.FID ");
                displayCol.append(" \r\n LEFT OUTER JOIN T_BD_SaleGroup AS SALEGROUP ");
                displayCol.append(" ON temp.FSaleGroupID = SALEGROUP.FID");
                displayCol.append("\r\n LEFT OUTER JOIN T_BD_Material material ");
                displayCol.append(" on temp.FMaterialID = material.FID ");
                displayCol.append(" \r\n LEFT OUTER JOIN T_BD_MaterialGroup AS MaterialGroup ");
                displayCol.append(" ON material.FMaterialGroupID = MaterialGroup.FID");
                displayCol.append("\r\n order by temp.FSaleGroupID,material.FMaterialGroupID,temp.FOrderSeq,temp.FSaleOrgID");
                displayCol.append(" asc ");
                break;
            }
            case 11: {
                displayCol.append(" SELECT ");
                displayCol.append("PERSON.FName_");
                displayCol.append(locLan);
                displayCol.append(" AS PERSON_NAME");
                displayCol.append(",CUSTOMER.FName_");
                displayCol.append(locLan);
                displayCol.append(" AS CUSTOMER_NAME");
                displayCol.append(",material.FNumber AS MATERIAL_NUMBER");
                displayCol.append(",material.FName_");
                displayCol.append(locLan);
                displayCol.append(" AS MATERIAL_NAME,");
                displayCol.append(ckBxShowMShortName ? "material.FShortName AS MATERIAL_SHORTNAME," : " ");
                displayCol.append("material.FModel AS MATERIAL_MODEL");
                displayCol.append("\r\n ,ORG.FName_").append(locLan);
                displayCol.append(" AS SALEORG_NAME");
                displayCol.append("\r\n ,UNIT.FName_").append(locLan);
                displayCol.append(" AS UNIT_NAME");
                displayCol.append("\r\n ,temp.FBaseQty AS FBaseQty");
                displayCol.append(",case when temp.FBaseQty = 0 then 0 else ");
                displayCol.append(" TO_DECIMAL(temp.FReceiveAmount/temp.FBaseQty,19,4) end AS FActualPrice");
                displayCol.append("\r\n ,temp.FAmount AS FAmount");
                displayCol.append("\r\n ,temp.FReceiveAmount AS FReceiveAmount");
                displayCol.append(",temp.FDiscountAmount AS FDiscountAmount");
                displayCol.append("\r\n ,temp.FAllSaleAmount AS FAllSaleAmount");
                displayCol.append(",temp.FSaleOrgID AS FSALEORG_ID");
                displayCol.append(",org.FIsleaf AS FSALEORG_ISLEAF");
                displayCol.append(",org.FLevel AS FSALEORG_LEVEL");
                displayCol.append(",temp.FPersonId FPersonId");
                displayCol.append(",temp.FAsstActID  FAsstActID ");
                displayCol.append(",temp.FMaterialID FMaterialID ");
                displayCol.append("\r\n from  " + tempTable + " temp \r\n LEFT OUTER JOIN ");
                displayCol.append(orgUnitTempTable);
                displayCol.append(" org ON temp.FSaleOrgID = org.FID ");
                displayCol.append(" \r\n LEFT OUTER JOIN T_BD_Customer AS CUSTOMER ");
                displayCol.append(" ON temp.FAsstActID = CUSTOMER.FID ");
                displayCol.append(" \r\n LEFT OUTER JOIN T_BD_Person AS PERSON ");
                displayCol.append(" ON temp.FPersonId = PERSON.FID");
                displayCol.append("\r\n LEFT OUTER JOIN T_BD_Material material ");
                displayCol.append(" on temp.FMaterialID = material.FID ");
                displayCol.append(" \r\n LEFT OUTER JOIN T_BD_MeasureUnit AS UNIT ");
                displayCol.append(" ON temp.FBaseUnitID = UNIT.FID");
                displayCol.append("\r\n order by temp.FPersonId,temp.FAsstActID,temp.FMaterialID,temp.FBaseUnitID,temp.FOrderSeq,temp.FSaleOrgID");
                displayCol.append(" asc ");
                break;
            }
            case 12: {
                displayCol.append(" SELECT ");
                displayCol.append(" customerBrowseGroup.FName_");
                displayCol.append(locLan);
                displayCol.append(" AS CUSTOMERGROUP_NAME");
                displayCol.append("\r\n ,ORG.FName_").append(locLan);
                displayCol.append(" AS SALEORG_NAME");
                displayCol.append("\r\n ,temp.FAmount AS FAmount");
                displayCol.append("\r\n ,temp.FReceiveAmount AS FReceiveAmount");
                displayCol.append(",temp.FDiscountAmount AS FDiscountAmount");
                displayCol.append("\r\n ,temp.FAllSaleAmount AS FAllSaleAmount");
                displayCol.append(",temp.FSaleOrgID AS FSALEORG_ID");
                displayCol.append(",org.FIsleaf AS FSALEORG_ISLEAF");
                displayCol.append(",org.FLevel AS FSALEORG_LEVEL");
                displayCol.append(",temp.FCustomerGroupID FCustomerGroupID");
                displayCol.append("\r\n from  " + tempTable + " temp \r\n LEFT OUTER JOIN ");
                displayCol.append(orgUnitTempTable);
                displayCol.append(" org ON temp.FSaleOrgID = org.FID ");
                displayCol.append("\r\n LEFT OUTER JOIN T_BD_CSSPGroup customerBrowseGroup");
                displayCol.append(" on temp.FCustomerGroupID = customerBrowseGroup.fid");
                displayCol.append(" \r\n order by temp.FCustomerGroupID,temp.FOrderSeq,temp.FSaleOrgID ");
                displayCol.append(" asc ");
                break;
            }
            case 13: {
                displayCol.append(" SELECT ");
                displayCol.append(" customerBrowseGroup.FName_");
                displayCol.append(locLan);
                displayCol.append(" AS CUSTOMERGROUP_NAME");
                displayCol.append(",material.FNumber AS MATERIAL_NUMBER");
                displayCol.append(",material.FName_");
                displayCol.append(locLan);
                displayCol.append(" AS MATERIAL_NAME,");
                displayCol.append(ckBxShowMShortName ? "material.FShortName AS MATERIAL_SHORTNAME," : " ");
                displayCol.append("material.FModel AS MATERIAL_MODEL");
                displayCol.append("\r\n ,ORG.FName_").append(locLan);
                displayCol.append(" AS SALEORG_NAME");
                displayCol.append("\r\n ,UNIT.FName_").append(locLan);
                displayCol.append(" AS UNIT_NAME");
                displayCol.append("\r\n ,temp.FBaseQty AS FBaseQty");
                displayCol.append(",case when temp.FBaseQty = 0 then 0 else ");
                displayCol.append(" TO_DECIMAL(temp.FReceiveAmount/temp.FBaseQty,19,4) end AS FActualPrice");
                displayCol.append("\r\n ,temp.FAmount AS FAmount");
                displayCol.append("\r\n ,temp.FReceiveAmount AS FReceiveAmount");
                displayCol.append(",temp.FDiscountAmount AS FDiscountAmount");
                displayCol.append("\r\n ,temp.FAllSaleAmount AS FAllSaleAmount");
                displayCol.append(",temp.FSaleOrgID AS FSALEORG_ID");
                displayCol.append(",org.FIsleaf AS FSALEORG_ISLEAF");
                displayCol.append(",org.FLevel AS FSALEORG_LEVEL");
                displayCol.append(",temp.FCustomerGroupID FCustomerGroupID");
                displayCol.append(",temp.FMaterialID FMaterialID ");
                displayCol.append("\r\n from  " + tempTable + " temp \r\n LEFT OUTER JOIN ");
                displayCol.append(orgUnitTempTable);
                displayCol.append(" org ON temp.FSaleOrgID = org.FID ");
                displayCol.append("\r\n LEFT OUTER JOIN T_BD_CSSPGroup customerBrowseGroup");
                displayCol.append(" on temp.FCustomerGroupID = customerBrowseGroup.fid");
                displayCol.append("\r\n LEFT OUTER JOIN T_BD_Material material ");
                displayCol.append(" on temp.FMaterialID = material.FID ");
                displayCol.append(" \r\n LEFT OUTER JOIN T_BD_MeasureUnit AS UNIT ");
                displayCol.append(" ON temp.FBaseUnitID = UNIT.FID");
                displayCol.append("\r\n order by temp.FCustomerGroupID,temp.FMaterialID,temp.FBaseUnitID,temp.FOrderSeq,temp.FSaleOrgID");
                displayCol.append(" asc ");
            }
        }
        RptRowSet rs = this.executeQuery(displayCol.toString(), null, from, len, ctx);
        RptParams pp = new RptParams();
        this.setBlockId(pp);
        pp.setObject("rowset", (Object)rs);
        return pp;
    }

    protected IRowSet _getIdList(Context ctx, RptParams param) throws BOSException {
        StringBuffer rsList = new StringBuffer();
        rsList.append("select  temp.fid from " + param.getString("tempTable"));
        rsList.append(" temp LEFT OUTER JOIN " + param.getString("OrgTempTable"));
        rsList.append(" org ON temp.FSaleOrgID = org.FID  ");
        this.groupBy = new Integer(param.getString("Classification"));
        switch (this.groupBy) {
            case 1: {
                rsList.append("\r\n order by temp.FMaterialID,temp.FBaseUnitID,temp.FOrderSeq,temp.FSaleOrgID");
                break;
            }
            case 2: {
                rsList.append(" \r\n order by temp.FAsstActID,temp.FOrderSeq,temp.FSaleOrgID ");
                break;
            }
            case 3: {
                rsList.append(" \r\n order by temp.FPersonId,temp.FOrderSeq,temp.FSaleOrgID ");
                break;
            }
            case 4: {
                rsList.append(" \r\n order by temp.FSaleGroupID,temp.FOrderSeq,temp.FSaleOrgID ");
                break;
            }
            case 5: {
                rsList.append("\r\n order by temp.FMaterialGroupID,temp.FOrderSeq,temp.FSaleOrgID ");
                break;
            }
            case 6: {
                rsList.append("\r\n order by temp.FMaterialID,temp.FAsstActID,temp.FOrderSeq,temp.FSaleOrgID");
                break;
            }
            case 7: {
                rsList.append("\r\n order by temp.FAsstActID,temp.FMaterialID,temp.FBaseUnitID,temp.FOrderSeq,temp.FSaleOrgID");
                break;
            }
            case 8: {
                rsList.append("\r\n order by temp.FSaleGroupID,temp.FPersonId,temp.FMaterialID,temp.FBaseUnitID,temp.FOrderSeq,temp.FSaleOrgID");
                break;
            }
            case 9: {
                rsList.append("\r\n order by temp.FSaleGroupID,temp.FMaterialID,temp.FBaseUnitID,temp.FOrderSeq,temp.FSaleOrgID");
                break;
            }
            case 10: {
                rsList.append("\r\n order by temp.FSaleGroupID,material.FMaterialGroupID,temp.FOrderSeq,temp.FSaleOrgID");
                break;
            }
            case 11: {
                rsList.append("\r\n order by temp.FPersonId,temp.FAsstActID,temp.FMaterialID,temp.FBaseUnitID,temp.FOrderSeq,temp.FSaleOrgID");
                break;
            }
            case 12: {
                rsList.append(" \r\n order by temp.FCustomerGroupID,temp.FOrderSeq,temp.FSaleOrgID ");
                break;
            }
            case 13: {
                rsList.append("\r\n order by temp.FCustomerGroupID,temp.FMaterialID,temp.FBaseUnitID,temp.FOrderSeq,temp.FSaleOrgID");
            }
        }
        rsList.append(" asc ");
        return DbUtil.executeQuery((Context)ctx, (String)rsList.toString());
    }

    public RptParams getDataForIdList(Context ctx, List idList, RptParams params) throws BOSException, EASBizException {
        return this.getDatas(ctx, params, idList, false);
    }

    private RptParams getDatas(Context ctx, RptParams params, List idList, boolean first) throws BOSException {
        String subWhere;
        String orgTempTable = params.getString("OrgTempTable");
        String tempTable = params.getString("tempTable");
        boolean ckBxShowMShortName = params.getBoolean("ckBxShowMShortName");
        if (first) {
            subWhere = " org.flevel = 1 ";
        } else {
            StringBuffer fid = new StringBuffer(" where temp.FId IN ('").append(idList.get(0).toString()).append("'");
            int n = idList.size();
            for (int i = 1; i < n; ++i) {
                fid.append(", '").append(idList.get(i).toString()).append("'");
            }
            fid.append(" ) ");
            subWhere = fid.toString();
        }
        StringBuffer displayCol = new StringBuffer();
        this.groupBy = new Integer(params.getString("Classification"));
        switch (this.groupBy) {
            case 1: {
                displayCol.append(" SELECT ");
                displayCol.append(" material.FNumber AS MATERIAL_NUMBER");
                displayCol.append(",material.FName_");
                displayCol.append(locLan);
                displayCol.append(" AS MATERIAL_NAME,");
                displayCol.append(ckBxShowMShortName ? "material.FShortName AS MATERIAL_SHORTNAME," : " ");
                displayCol.append("material.FModel AS MATERIAL_MODEL");
                displayCol.append("\r\n ,ORG.FName_").append(locLan);
                displayCol.append(" AS SALEORG_NAME");
                displayCol.append("\r\n ,UNIT.FName_").append(locLan);
                displayCol.append(" AS UNIT_NAME");
                displayCol.append("\r\n ,temp.FBaseQty AS FBaseQty");
                displayCol.append(",case when temp.FBaseQty = 0 then 0 else ");
                displayCol.append(" TO_DECIMAL(temp.FReceiveAmount/temp.FBaseQty,19,4) end AS FActualPrice");
                displayCol.append("\r\n ,temp.FAmount AS FAmount");
                displayCol.append("\r\n ,temp.FReceiveAmount AS FReceiveAmount");
                displayCol.append(",temp.FDiscountAmount AS FDiscountAmount");
                displayCol.append("\r\n ,temp.FAllSaleAmount AS FAllSaleAmount");
                displayCol.append(",temp.FSaleOrgID AS FSALEORG_ID");
                displayCol.append(",org.FIsleaf AS FSALEORG_ISLEAF");
                displayCol.append(",org.FLevel AS FSALEORG_LEVEL");
                displayCol.append(",temp.FMaterialID FMaterialID ");
                displayCol.append("\r\n from  " + tempTable + " temp \r\n LEFT OUTER JOIN ");
                displayCol.append(orgTempTable);
                displayCol.append(" org ON temp.FSaleOrgID = org.FID ");
                displayCol.append("\r\n LEFT OUTER JOIN T_BD_Material material ");
                displayCol.append(" on temp.FMaterialID = material.FID ");
                displayCol.append(" \r\n LEFT OUTER JOIN T_BD_MeasureUnit AS UNIT ");
                displayCol.append(" ON temp.FBaseUnitID = UNIT.FID");
                displayCol.append(" \r\n " + subWhere);
                displayCol.append("\r\n order by material.FNumber,temp.FBaseUnitID,temp.FOrderSeq,temp.FSaleOrgID");
                displayCol.append(" asc ");
                break;
            }
            case 2: {
                displayCol.append(" SELECT ");
                displayCol.append(" CUSTOMER.FName_");
                displayCol.append(locLan);
                displayCol.append(" AS CUSTOMER_NAME");
                displayCol.append("\r\n ,ORG.FName_").append(locLan);
                displayCol.append(" AS SALEORG_NAME");
                displayCol.append("\r\n ,temp.FAmount AS FAmount");
                displayCol.append("\r\n ,temp.FReceiveAmount AS FReceiveAmount");
                displayCol.append(",temp.FDiscountAmount AS FDiscountAmount");
                displayCol.append("\r\n ,temp.FAllSaleAmount AS FAllSaleAmount");
                displayCol.append(",temp.FSaleOrgID AS FSALEORG_ID");
                displayCol.append(",org.FIsleaf AS FSALEORG_ISLEAF");
                displayCol.append(",org.FLevel AS FSALEORG_LEVEL");
                displayCol.append(",temp.FAsstActID  FAsstActID ");
                displayCol.append("\r\n from  " + tempTable + " temp \r\n LEFT OUTER JOIN ");
                displayCol.append(orgTempTable);
                displayCol.append(" org ON temp.FSaleOrgID = org.FID ");
                displayCol.append(" \r\n LEFT OUTER JOIN T_BD_Customer AS CUSTOMER ");
                displayCol.append(" ON temp.FAsstActID = CUSTOMER.FID ");
                displayCol.append(" \r\n " + subWhere);
                displayCol.append(" \r\n order by  CUSTOMER.FName_").append(locLan);
                displayCol.append(",temp.FOrderSeq,temp.FSaleOrgID ");
                displayCol.append(" asc ");
                break;
            }
            case 3: {
                displayCol.append(" SELECT ");
                displayCol.append(" PERSON.FName_");
                displayCol.append(locLan);
                displayCol.append(" AS PERSON_NAME");
                displayCol.append("\r\n ,ORG.FName_").append(locLan);
                displayCol.append(" AS SALEORG_NAME");
                displayCol.append("\r\n ,temp.FAmount AS FAmount");
                displayCol.append("\r\n ,temp.FReceiveAmount AS FReceiveAmount");
                displayCol.append(",temp.FDiscountAmount AS FDiscountAmount");
                displayCol.append("\r\n ,temp.FAllSaleAmount AS FAllSaleAmount");
                displayCol.append(",temp.FSaleOrgID AS FSALEORG_ID");
                displayCol.append(",org.FIsleaf AS FSALEORG_ISLEAF");
                displayCol.append(",org.FLevel AS FSALEORG_LEVEL");
                displayCol.append(",temp.FPersonId FPersonId");
                displayCol.append("\r\n from  " + tempTable + " temp \r\n LEFT OUTER JOIN ");
                displayCol.append(orgTempTable);
                displayCol.append(" org ON temp.FSaleOrgID = org.FID ");
                displayCol.append(" \r\n INNER JOIN T_BD_Person AS PERSON ");
                displayCol.append(" ON temp.FPersonId = PERSON.FID");
                displayCol.append(" \r\n " + subWhere);
                displayCol.append(" \r\n order by PERSON.FName_").append(locLan).append(",temp.FOrderSeq,temp.FSaleOrgID ");
                displayCol.append(" asc ");
                break;
            }
            case 4: {
                displayCol.append(" SELECT ");
                displayCol.append(" SALEGROUP.FName_");
                displayCol.append(locLan);
                displayCol.append(" AS SALEGROUP_NAME");
                displayCol.append("\r\n ,ORG.FName_").append(locLan);
                displayCol.append(" AS SALEORG_NAME");
                displayCol.append("\r\n ,temp.FAmount AS FAmount");
                displayCol.append("\r\n ,temp.FReceiveAmount AS FReceiveAmount");
                displayCol.append(",temp.FDiscountAmount AS FDiscountAmount");
                displayCol.append("\r\n ,temp.FAllSaleAmount AS FAllSaleAmount");
                displayCol.append(",temp.FSaleOrgID AS FSALEORG_ID");
                displayCol.append(",org.FIsleaf AS FSALEORG_ISLEAF");
                displayCol.append(",org.FLevel AS FSALEORG_LEVEL");
                displayCol.append(",temp.FSaleGroupID FSaleGroupID");
                displayCol.append("\r\n from  " + tempTable + " temp \r\n LEFT OUTER JOIN ");
                displayCol.append(orgTempTable);
                displayCol.append(" org ON temp.FSaleOrgID = org.FID ");
                displayCol.append(" \r\n LEFT OUTER JOIN T_BD_SaleGroup AS SALEGROUP ");
                displayCol.append(" ON temp.FSaleGroupID = SALEGROUP.FID");
                displayCol.append(" \r\n " + subWhere);
                displayCol.append(" \r\n order by temp.FSaleGroupID,temp.FOrderSeq,temp.FSaleOrgID ");
                displayCol.append(" asc ");
                break;
            }
            case 5: {
                displayCol.append(" SELECT ");
                displayCol.append(" MaterialGroup.FName_");
                displayCol.append(locLan);
                displayCol.append(" AS MATGROUP_NAME");
                displayCol.append("\r\n ,ORG.FName_").append(locLan);
                displayCol.append(" AS SALEORG_NAME");
                displayCol.append("\r\n ,temp.FAmount AS FAmount");
                displayCol.append("\r\n ,temp.FReceiveAmount AS FReceiveAmount");
                displayCol.append(",temp.FDiscountAmount AS FDiscountAmount");
                displayCol.append("\r\n ,temp.FAllSaleAmount AS FAllSaleAmount");
                displayCol.append(",temp.FSaleOrgID AS FSALEORG_ID");
                displayCol.append(",org.FIsleaf AS FSALEORG_ISLEAF");
                displayCol.append(",org.FLevel AS FSALEORG_LEVEL");
                displayCol.append(",material.FMaterialGroupID FMaterialGroupID");
                displayCol.append("\r\n from  " + tempTable + " temp \r\n LEFT OUTER JOIN ");
                displayCol.append(orgTempTable);
                displayCol.append(" org ON temp.FSaleOrgID = org.FID ");
                displayCol.append("\r\n LEFT OUTER JOIN T_BD_Material material ");
                displayCol.append(" on temp.FMaterialID = material.FID ");
                displayCol.append(" \r\n LEFT OUTER JOIN T_BD_MaterialGroup AS MaterialGroup ");
                displayCol.append(" ON material.FMaterialGroupID = MaterialGroup.FID");
                displayCol.append(" \r\n " + subWhere);
                displayCol.append("\r\n order by temp.FMaterialGroupID,temp.FOrderSeq,temp.FSaleOrgID ");
                displayCol.append(" asc ");
                break;
            }
            case 6: {
                displayCol.append(" SELECT ");
                displayCol.append(" material.FNumber AS MATERIAL_NUMBER");
                displayCol.append(",material.FName_");
                displayCol.append(locLan);
                displayCol.append(" AS MATERIAL_NAME,");
                displayCol.append(ckBxShowMShortName ? "material.FShortName AS MATERIAL_SHORTNAME," : " ");
                displayCol.append("material.FModel AS MATERIAL_MODEL");
                displayCol.append(",CUSTOMER.FName_");
                displayCol.append(locLan);
                displayCol.append(" AS CUSTOMER_NAME");
                displayCol.append("\r\n ,ORG.FName_").append(locLan);
                displayCol.append(" AS SALEORG_NAME");
                displayCol.append("\r\n ,temp.FAmount AS FAmount");
                displayCol.append("\r\n ,temp.FReceiveAmount AS FReceiveAmount");
                displayCol.append(",temp.FDiscountAmount AS FDiscountAmount");
                displayCol.append("\r\n ,temp.FAllSaleAmount AS FAllSaleAmount");
                displayCol.append(",temp.FSaleOrgID AS FSALEORG_ID");
                displayCol.append(",org.FIsleaf AS FSALEORG_ISLEAF");
                displayCol.append(",org.FLevel AS FSALEORG_LEVEL");
                displayCol.append(",temp.FMaterialID FMaterialID ");
                displayCol.append(",temp.FAsstActID  FAsstActID ");
                displayCol.append("\r\n from  " + tempTable + " temp \r\n LEFT OUTER JOIN ");
                displayCol.append(orgTempTable);
                displayCol.append(" org ON temp.FSaleOrgID = org.FID ");
                displayCol.append("\r\n LEFT OUTER JOIN T_BD_Material material ");
                displayCol.append(" on temp.FMaterialID = material.FID ");
                displayCol.append(" \r\n LEFT OUTER JOIN T_BD_Customer AS CUSTOMER ");
                displayCol.append(" ON temp.FAsstActID = CUSTOMER.FID ");
                displayCol.append(" \r\n " + subWhere);
                displayCol.append(" \r\n order by temp.FMaterialID,temp.FAsstActID,temp.FOrderSeq,temp.FSaleOrgID");
                displayCol.append(" asc ");
                break;
            }
            case 7: {
                displayCol.append(" SELECT ");
                displayCol.append(" CUSTOMER.FName_");
                displayCol.append(locLan);
                displayCol.append(" AS CUSTOMER_NAME");
                displayCol.append(",material.FNumber AS MATERIAL_NUMBER");
                displayCol.append(",material.FName_");
                displayCol.append(locLan);
                displayCol.append(" AS MATERIAL_NAME,");
                displayCol.append(ckBxShowMShortName ? "material.FShortName AS MATERIAL_SHORTNAME," : " ");
                displayCol.append("material.FModel AS MATERIAL_MODEL");
                displayCol.append("\r\n ,ORG.FName_").append(locLan);
                displayCol.append(" AS SALEORG_NAME");
                displayCol.append("\r\n ,UNIT.FName_").append(locLan);
                displayCol.append(" AS UNIT_NAME");
                displayCol.append("\r\n ,temp.FBaseQty AS FBaseQty");
                displayCol.append(",case when temp.FBaseQty = 0 then 0 else ");
                displayCol.append(" TO_DECIMAL(temp.FReceiveAmount/temp.FBaseQty,19,4) end AS FActualPrice");
                displayCol.append("\r\n ,temp.FAmount AS FAmount");
                displayCol.append("\r\n ,temp.FReceiveAmount AS FReceiveAmount");
                displayCol.append(",temp.FDiscountAmount AS FDiscountAmount");
                displayCol.append("\r\n ,temp.FAllSaleAmount AS FAllSaleAmount");
                displayCol.append(",temp.FSaleOrgID AS FSALEORG_ID");
                displayCol.append(",org.FIsleaf AS FSALEORG_ISLEAF");
                displayCol.append(",org.FLevel AS FSALEORG_LEVEL");
                displayCol.append(",temp.FAsstActID  FAsstActID ");
                displayCol.append(",temp.FMaterialID FMaterialID ");
                displayCol.append("\r\n from  " + tempTable + " temp \r\n LEFT OUTER JOIN ");
                displayCol.append(orgTempTable);
                displayCol.append(" org ON temp.FSaleOrgID = org.FID ");
                displayCol.append(" \r\n LEFT OUTER JOIN T_BD_Customer AS CUSTOMER ");
                displayCol.append(" ON temp.FAsstActID = CUSTOMER.FID ");
                displayCol.append("\r\n LEFT OUTER JOIN T_BD_Material material ");
                displayCol.append(" on temp.FMaterialID = material.FID ");
                displayCol.append(" \r\n LEFT OUTER JOIN T_BD_MeasureUnit AS UNIT ");
                displayCol.append(" ON temp.FBaseUnitID = UNIT.FID");
                displayCol.append(" \r\n " + subWhere);
                displayCol.append("\r\n order by temp.FAsstActID,temp.FMaterialID,temp.FBaseUnitID,temp.FOrderSeq,temp.FSaleOrgID");
                displayCol.append(" asc ");
                break;
            }
            case 8: {
                displayCol.append(" SELECT ");
                displayCol.append(" SALEGROUP.FName_");
                displayCol.append(locLan);
                displayCol.append(" AS SALEGROUP_NAME");
                displayCol.append(",PERSON.FName_");
                displayCol.append(locLan);
                displayCol.append(" AS PERSON_NAME");
                displayCol.append(",material.FNumber AS MATERIAL_NUMBER");
                displayCol.append(",material.FName_");
                displayCol.append(locLan);
                displayCol.append(" AS MATERIAL_NAME,");
                displayCol.append(ckBxShowMShortName ? "material.FShortName AS MATERIAL_SHORTNAME," : " ");
                displayCol.append("material.FModel AS MATERIAL_MODEL");
                displayCol.append("\r\n ,ORG.FName_").append(locLan);
                displayCol.append(" AS SALEORG_NAME");
                displayCol.append("\r\n ,UNIT.FName_").append(locLan);
                displayCol.append(" AS UNIT_NAME");
                displayCol.append("\r\n ,temp.FBaseQty AS FBaseQty");
                displayCol.append(",case when temp.FBaseQty = 0 then 0 else ");
                displayCol.append(" TO_DECIMAL(temp.FReceiveAmount/temp.FBaseQty,19,4) end AS FActualPrice");
                displayCol.append("\r\n ,temp.FAmount AS FAmount");
                displayCol.append("\r\n ,temp.FReceiveAmount AS FReceiveAmount");
                displayCol.append(",temp.FDiscountAmount AS FDiscountAmount");
                displayCol.append("\r\n ,temp.FAllSaleAmount AS FAllSaleAmount");
                displayCol.append(",temp.FSaleOrgID AS FSALEORG_ID");
                displayCol.append(",org.FIsleaf AS FSALEORG_ISLEAF");
                displayCol.append(",org.FLevel AS FSALEORG_LEVEL");
                displayCol.append(",temp.FSaleGroupID FSaleGroupID");
                displayCol.append(",temp.FPersonId FPersonId");
                displayCol.append(",temp.FMaterialID FMaterialID ");
                displayCol.append("\r\n from  " + tempTable + " temp \r\n LEFT OUTER JOIN ");
                displayCol.append(orgTempTable);
                displayCol.append(" org ON temp.FSaleOrgID = org.FID ");
                displayCol.append(" \r\n LEFT OUTER JOIN T_BD_SaleGroup AS SALEGROUP ");
                displayCol.append(" ON temp.FSaleGroupID = SALEGROUP.FID");
                displayCol.append(" \r\n LEFT OUTER JOIN T_BD_Person AS PERSON ");
                displayCol.append(" ON temp.FPersonId = PERSON.FID");
                displayCol.append("\r\n LEFT OUTER JOIN T_BD_Material material ");
                displayCol.append(" on temp.FMaterialID = material.FID ");
                displayCol.append(" \r\n LEFT OUTER JOIN T_BD_MeasureUnit AS UNIT ");
                displayCol.append(" ON temp.FBaseUnitID = UNIT.FID");
                displayCol.append(" \r\n " + subWhere);
                displayCol.append("\r\n order by temp.FSaleGroupID,temp.FPersonId,temp.FMaterialID,temp.FBaseUnitID,temp.FOrderSeq,temp.FSaleOrgID");
                displayCol.append(" asc ");
                break;
            }
            case 9: {
                displayCol.append(" SELECT ");
                displayCol.append(" SALEGROUP.FName_");
                displayCol.append(locLan);
                displayCol.append(" AS SALEGROUP_NAME");
                displayCol.append(",material.FNumber AS MATERIAL_NUMBER");
                displayCol.append(",material.FName_");
                displayCol.append(locLan);
                displayCol.append(" AS MATERIAL_NAME,");
                displayCol.append(ckBxShowMShortName ? "material.FShortName AS MATERIAL_SHORTNAME," : " ");
                displayCol.append("material.FModel AS MATERIAL_MODEL");
                displayCol.append("\r\n ,ORG.FName_").append(locLan);
                displayCol.append(" AS SALEORG_NAME");
                displayCol.append("\r\n ,UNIT.FName_").append(locLan);
                displayCol.append(" AS UNIT_NAME");
                displayCol.append("\r\n ,temp.FBaseQty AS FBaseQty");
                displayCol.append(",case when temp.FBaseQty = 0 then 0 else ");
                displayCol.append(" TO_DECIMAL(temp.FReceiveAmount/temp.FBaseQty,19,4) end AS FActualPrice");
                displayCol.append("\r\n ,temp.FAmount AS FAmount");
                displayCol.append("\r\n ,temp.FReceiveAmount AS FReceiveAmount");
                displayCol.append(",temp.FDiscountAmount AS FDiscountAmount");
                displayCol.append("\r\n ,temp.FAllSaleAmount AS FAllSaleAmount");
                displayCol.append(",temp.FSaleOrgID AS FSALEORG_ID");
                displayCol.append(",org.FIsleaf AS FSALEORG_ISLEAF");
                displayCol.append(",org.FLevel AS FSALEORG_LEVEL");
                displayCol.append(",temp.FSaleGroupID FSaleGroupID");
                displayCol.append(",temp.FMaterialID FMaterialID ");
                displayCol.append("\r\n from  " + tempTable + " temp \r\n LEFT OUTER JOIN ");
                displayCol.append(orgTempTable);
                displayCol.append(" org ON temp.FSaleOrgID = org.FID ");
                displayCol.append(" \r\n LEFT OUTER JOIN T_BD_SaleGroup AS SALEGROUP ");
                displayCol.append(" ON temp.FSaleGroupID = SALEGROUP.FID");
                displayCol.append("\r\n LEFT OUTER JOIN T_BD_Material material ");
                displayCol.append(" on temp.FMaterialID = material.FID ");
                displayCol.append(" \r\n LEFT OUTER JOIN T_BD_MeasureUnit AS UNIT ");
                displayCol.append(" ON temp.FBaseUnitID = UNIT.FID");
                displayCol.append(" \r\n " + subWhere);
                displayCol.append("\r\n order by temp.FSaleGroupID,temp.FMaterialID,temp.FBaseUnitID,temp.FOrderSeq,temp.FSaleOrgID");
                displayCol.append(" asc ");
                break;
            }
            case 10: {
                displayCol.append(" SELECT ");
                displayCol.append(" SALEGROUP.FName_");
                displayCol.append(locLan);
                displayCol.append(" AS SALEGROUP_NAME");
                displayCol.append(",MaterialGroup.FName_");
                displayCol.append(locLan);
                displayCol.append(" AS MATGROUP_NAME");
                displayCol.append("\r\n ,ORG.FName_").append(locLan);
                displayCol.append(" AS SALEORG_NAME");
                displayCol.append("\r\n ,temp.FAmount AS FAmount");
                displayCol.append("\r\n ,temp.FReceiveAmount AS FReceiveAmount");
                displayCol.append(",temp.FDiscountAmount AS FDiscountAmount");
                displayCol.append("\r\n ,temp.FAllSaleAmount AS FAllSaleAmount");
                displayCol.append(",temp.FSaleOrgID AS FSALEORG_ID");
                displayCol.append(",org.FIsleaf AS FSALEORG_ISLEAF");
                displayCol.append(",org.FLevel AS FSALEORG_LEVEL");
                displayCol.append(",temp.FSaleGroupID FSaleGroupID");
                displayCol.append(",material.FMaterialGroupID FMaterialGroupID");
                displayCol.append("\r\n from  " + tempTable + " temp \r\n LEFT OUTER JOIN ");
                displayCol.append(orgTempTable);
                displayCol.append(" org ON temp.FSaleOrgID = org.FID ");
                displayCol.append(" \r\n LEFT OUTER JOIN T_BD_SaleGroup AS SALEGROUP ");
                displayCol.append(" ON temp.FSaleGroupID = SALEGROUP.FID");
                displayCol.append("\r\n LEFT OUTER JOIN T_BD_Material material ");
                displayCol.append(" on temp.FMaterialID = material.FID ");
                displayCol.append(" \r\n LEFT OUTER JOIN T_BD_MaterialGroup AS MaterialGroup ");
                displayCol.append(" ON material.FMaterialGroupID = MaterialGroup.FID");
                displayCol.append(" \r\n " + subWhere);
                displayCol.append("\r\n order by temp.FSaleGroupID,material.FMaterialGroupID,temp.FOrderSeq,temp.FSaleOrgID");
                displayCol.append(" asc ");
                break;
            }
            case 11: {
                displayCol.append(" SELECT ");
                displayCol.append("PERSON.FName_");
                displayCol.append(locLan);
                displayCol.append(" AS PERSON_NAME");
                displayCol.append(",CUSTOMER.FName_");
                displayCol.append(locLan);
                displayCol.append(" AS CUSTOMER_NAME");
                displayCol.append(",material.FNumber AS MATERIAL_NUMBER");
                displayCol.append(",material.FName_");
                displayCol.append(locLan);
                displayCol.append(" AS MATERIAL_NAME,");
                displayCol.append(ckBxShowMShortName ? "material.FShortName AS MATERIAL_SHORTNAME," : " ");
                displayCol.append("material.FModel AS MATERIAL_MODEL");
                displayCol.append("\r\n ,ORG.FName_").append(locLan);
                displayCol.append(" AS SALEORG_NAME");
                displayCol.append("\r\n ,UNIT.FName_").append(locLan);
                displayCol.append(" AS UNIT_NAME");
                displayCol.append("\r\n ,temp.FBaseQty AS FBaseQty");
                displayCol.append(",case when temp.FBaseQty = 0 then 0 else ");
                displayCol.append(" TO_DECIMAL(temp.FReceiveAmount/temp.FBaseQty,19,4) end AS FActualPrice");
                displayCol.append("\r\n ,temp.FAmount AS FAmount");
                displayCol.append("\r\n ,temp.FReceiveAmount AS FReceiveAmount");
                displayCol.append(",temp.FDiscountAmount AS FDiscountAmount");
                displayCol.append("\r\n ,temp.FAllSaleAmount AS FAllSaleAmount");
                displayCol.append(",temp.FSaleOrgID AS FSALEORG_ID");
                displayCol.append(",org.FIsleaf AS FSALEORG_ISLEAF");
                displayCol.append(",org.FLevel AS FSALEORG_LEVEL");
                displayCol.append(",temp.FPersonId FPersonId");
                displayCol.append(",temp.FAsstActID  FAsstActID ");
                displayCol.append(",temp.FMaterialID FMaterialID ");
                displayCol.append("\r\n from  " + tempTable + " temp \r\n LEFT OUTER JOIN ");
                displayCol.append(orgTempTable);
                displayCol.append(" org ON temp.FSaleOrgID = org.FID ");
                displayCol.append(" \r\n LEFT OUTER JOIN T_BD_Customer AS CUSTOMER ");
                displayCol.append(" ON temp.FAsstActID = CUSTOMER.FID ");
                displayCol.append(" \r\n LEFT OUTER JOIN T_BD_Person AS PERSON ");
                displayCol.append(" ON temp.FPersonId = PERSON.FID");
                displayCol.append("\r\n LEFT OUTER JOIN T_BD_Material material ");
                displayCol.append(" on temp.FMaterialID = material.FID ");
                displayCol.append(" \r\n LEFT OUTER JOIN T_BD_MeasureUnit AS UNIT ");
                displayCol.append(" ON temp.FBaseUnitID = UNIT.FID");
                displayCol.append(" \r\n " + subWhere);
                displayCol.append("\r\n order by temp.FPersonId,temp.FAsstActID,temp.FMaterialID,temp.FBaseUnitID,temp.FOrderSeq,temp.FSaleOrgID");
                displayCol.append(" asc ");
                break;
            }
            case 12: {
                displayCol.append(" SELECT ");
                displayCol.append(" customerBrowseGroup.FName_");
                displayCol.append(locLan);
                displayCol.append(" AS CUSTOMERGROUP_NAME");
                displayCol.append("\r\n ,ORG.FName_").append(locLan);
                displayCol.append(" AS SALEORG_NAME");
                displayCol.append("\r\n ,temp.FAmount AS FAmount");
                displayCol.append("\r\n ,temp.FReceiveAmount AS FReceiveAmount");
                displayCol.append(",temp.FDiscountAmount AS FDiscountAmount");
                displayCol.append("\r\n ,temp.FAllSaleAmount AS FAllSaleAmount");
                displayCol.append(",temp.FSaleOrgID AS FSALEORG_ID");
                displayCol.append(",org.FIsleaf AS FSALEORG_ISLEAF");
                displayCol.append(",org.FLevel AS FSALEORG_LEVEL");
                displayCol.append(",temp.FCustomerGroupID FCustomerGroupID");
                displayCol.append("\r\n from  " + tempTable + " temp \r\n LEFT OUTER JOIN ");
                displayCol.append(orgTempTable);
                displayCol.append(" org ON temp.FSaleOrgID = org.FID ");
                displayCol.append("\r\n LEFT OUTER JOIN T_BD_CSSPGroup customerBrowseGroup");
                displayCol.append(" on temp.FCustomerGroupID = customerBrowseGroup.fid");
                displayCol.append(" \r\n " + subWhere);
                displayCol.append(" \r\n order by temp.FCustomerGroupID,temp.FOrderSeq,temp.FSaleOrgID ");
                displayCol.append(" asc ");
                break;
            }
            case 13: {
                displayCol.append(" SELECT ");
                displayCol.append(" customerBrowseGroup.FName_");
                displayCol.append(locLan);
                displayCol.append(" AS CUSTOMERGROUP_NAME");
                displayCol.append(",material.FNumber AS MATERIAL_NUMBER");
                displayCol.append(",material.FName_");
                displayCol.append(locLan);
                displayCol.append(" AS MATERIAL_NAME,");
                displayCol.append(ckBxShowMShortName ? "material.FShortName AS MATERIAL_SHORTNAME," : " ");
                displayCol.append("material.FModel AS MATERIAL_MODEL");
                displayCol.append("\r\n ,ORG.FName_").append(locLan);
                displayCol.append(" AS SALEORG_NAME");
                displayCol.append("\r\n ,UNIT.FName_").append(locLan);
                displayCol.append(" AS UNIT_NAME");
                displayCol.append("\r\n ,temp.FBaseQty AS FBaseQty");
                displayCol.append(",case when temp.FBaseQty = 0 then 0 else ");
                displayCol.append(" TO_DECIMAL(temp.FReceiveAmount/temp.FBaseQty,19,4) end AS FActualPrice");
                displayCol.append("\r\n ,temp.FAmount AS FAmount");
                displayCol.append("\r\n ,temp.FReceiveAmount AS FReceiveAmount");
                displayCol.append(",temp.FDiscountAmount AS FDiscountAmount");
                displayCol.append("\r\n ,temp.FAllSaleAmount AS FAllSaleAmount");
                displayCol.append(",temp.FSaleOrgID AS FSALEORG_ID");
                displayCol.append(",org.FIsleaf AS FSALEORG_ISLEAF");
                displayCol.append(",org.FLevel AS FSALEORG_LEVEL");
                displayCol.append(",temp.FCustomerGroupID FCustomerGroupID");
                displayCol.append(",temp.FMaterialID FMaterialID ");
                displayCol.append("\r\n from  " + tempTable + " temp \r\n LEFT OUTER JOIN ");
                displayCol.append(orgTempTable);
                displayCol.append(" org ON temp.FSaleOrgID = org.FID ");
                displayCol.append("\r\n LEFT OUTER JOIN T_BD_CSSPGroup customerBrowseGroup");
                displayCol.append(" on temp.FCustomerGroupID = customerBrowseGroup.fid");
                displayCol.append("\r\n LEFT OUTER JOIN T_BD_Material material ");
                displayCol.append(" on temp.FMaterialID = material.FID ");
                displayCol.append(" \r\n LEFT OUTER JOIN T_BD_MeasureUnit AS UNIT ");
                displayCol.append(" ON temp.FBaseUnitID = UNIT.FID");
                displayCol.append(" \r\n " + subWhere);
                displayCol.append("\r\n order by temp.FCustomerGroupID,temp.FMaterialID,temp.FBaseUnitID,temp.FOrderSeq,temp.FSaleOrgID");
                displayCol.append(" asc ");
            }
        }
        RptRowSet rs = this.executeQuery(displayCol.toString(), null, ctx);
        RptParams pp = new RptParams();
        pp.setObject("rowset", (Object)rs);
        return pp;
    }

    private void setBlockId(RptParams pp) {
        switch (this.groupBy) {
            case 1: {
                pp.setString("Material_Name", "MATERIAL_NAME");
                break;
            }
            case 2: {
                pp.setString("Customer_Name", "CUSTOMER_NAME");
                break;
            }
            case 3: {
                pp.setString("Person_Name", "CUSTOMER_NAME");
                break;
            }
            case 4: {
                pp.setString("SaleGroup_Name", "SALEGROUP_NAME");
                break;
            }
            case 5: {
                pp.setString("MatGroup_Name", "CUSTOMER_NAME");
                break;
            }
            case 6: {
                pp.setString("Material_Name", "MATERIAL_NAME");
                pp.setString("Customer_Name", "CUSTOMER_NAME");
                break;
            }
            case 7: {
                pp.setString("Customer_Name", "CUSTOMER_NAME");
                pp.setString("Material_Name", "MATERIAL_NAME");
                break;
            }
            case 8: {
                pp.setString("GroupBy", "Material");
                pp.setString("SaleGroup_Name", "SALEGROUP_NAME");
                pp.setString("Person_Name", "PERSON_NAME");
                pp.setString("Material_Name", "MATERIAL_NAME");
                break;
            }
            case 9: {
                pp.setString("GroupBy", "Material");
                pp.setString("SaleGroup_Name", "SALEGROUP_NAME");
                pp.setString("Material_Name", "MATERIAL_NAME");
                break;
            }
            case 10: {
                pp.setString("GroupBy", "Material");
                pp.setString("SaleGroup_Name", "SALEGROUP_NAME");
                pp.setString("MatGroup_Name", "MATGROUP_NAME");
                break;
            }
            case 11: {
                pp.setString("GroupBy", "Material");
                pp.setString("Person_Name", "PERSON_NAME");
                pp.setString("Customer_Name", "CUSTOMER_NAME");
                pp.setString("Material_Name", "MATERIAL_NAME");
            }
        }
        pp.setInt("GroupBy", this.groupBy);
    }

    private void executeSQL(Context ctx, String sql) throws BOSException {
        if (sql != null && sql.trim().length() > 0) {
            this.executeUpdate(sql, null, ctx);
        }
    }

    public String getServerResource(String key, Context ctx) {
        return SCMUtils.getResource((String)resClassName, (String)key, (Context)ctx);
    }

    @Override
    protected int _getMaxMaterialLevel(Context ctx) throws BOSException {
        String sql = "SELECT max(flevel) cc FROM t_bd_materialgroup ";
        RptRowSet rs = this.executeQuery(sql, null, ctx);
        int max = 1;
        if (rs.next() && rs.getObject(0) != null) {
            max = rs.getInt(0);
        }
        return max;
    }
}

