/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptCellFormatter;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sd.sale.SaleReportBillStatusEnum;
import com.kingdee.eas.scm.sd.sale.report.app.AbstractSaleIncomDetailFacadeControllerBean;
import com.kingdee.eas.scm.sd.sale.util.SaleUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.util.StringTokenizer;

public class SaleIncomDetailFacadeControllerBean
extends AbstractSaleIncomDetailFacadeControllerBean {
    private static final String resClassName = "com.kingdee.eas.scm.sd.sale.report.SDReportResource";
    private int groupBy;

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        this.dropTempTable(params.getString("TempTableName"), ctx);
        String tempTable = null;
        tempTable = this.createTempTable(ctx, this.getCreateTempTable(tempTable, params));
        params.setString("TempTableName", tempTable);
        String newTempTable = this.createTempTable(ctx, this.getCreateTempTable(tempTable, params));
        try {
            TempTablePool.getInstance((Context)ctx).createIndex(newTempTable, "KSQL_SEQ", false, false);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        this.groupBy = new Integer(params.getString("CombOrderCol"));
        this.insertBillData(ctx, tempTable, params);
        this.copyToNewTempTable(ctx, newTempTable, tempTable, params);
        String countSql = "select count(1) cc from " + tempTable;
        RptRowSet rs = this.executeQuery(countSql, null, ctx);
        rs.next();
        int count = rs.getInt(0);
        RptTableHeader header = new RptTableHeader();
        this.setTableHead(header, params, ctx);
        this.dropTempTable(ctx, tempTable);
        RptParams result = new RptParams();
        result.setString("TempTableName", newTempTable);
        result.setObject("header", (Object)header);
        result.setInt("verticalCount", count);
        result.setString("TempTableObject", newTempTable);
        return result;
    }

    private void insertBillData(Context ctx, String tempTable, RptParams params) throws BOSException, EASBizException {
        String sql = null;
        SqlParams sqlParams = new SqlParams();
        sql = this.getRptSql(params, sqlParams, tempTable, ctx);
        this.executeUpdate(sql, sqlParams, ctx);
        if (params.getString("IsTotal").equals("true")) {
            sql = this.getRptTotalSql(params, tempTable, ctx);
            this.executeUpdate(sql, null, ctx);
        }
        if (params.getString("IsSum").equals("true")) {
            sql = this.getRptSumSql(params, tempTable, ctx);
            this.executeUpdate(sql, null, ctx);
        }
    }

    private void copyToNewTempTable(Context ctx, String newTempTable, String tempTable, RptParams params) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO ").append(newTempTable).append("(");
        sb.append(this.getSelects(params, true));
        sb.append(")");
        sb.append(" select ");
        sb.append(this.getSelectsTemp(params, false));
        sb.append(" from ").append(tempTable).append(" AS TEMP ");
        sb.append(" LEFT OUTER JOIN T_BD_MATERIAL MAT  ON TEMP.FMATERIALID = MAT.FID ");
        sb.append(this.getOrderByBySql(ctx, params));
        DbUtil.execute((Context)ctx, (String)sb.toString());
    }

    private String getSelects(RptParams params, boolean hasKsqlSeq) {
        StringBuffer sb = new StringBuffer();
        if (hasKsqlSeq) {
            sb.append("KSQL_SEQ,");
        }
        sb.append("FID,FBILLID,FBizDate,FNumber,FBillType,FIsBizBill,FCompanyOrgUnitID,FSaleOrgUnitID,FSaleGroupID,FCustomerID,FPersonID,FStorageOrgUnitID,");
        sb.append("FMaterialID,FUnitID,FQty,FCurrencyID,FRealPrice,FTaxPrice,FAmount,FTaxAmount,FDiscountAmount,FRecievePayAmount,FRealPriceLocal,FRealTaxPriceLocal,FAmountLocal,");
        sb.append("FTaxAmountLocal,FDiscountAmountLocal,FRecievePayAmountLocal,FTotalFlag,FPricePrecision");
        if (params.containsKey("isCkBxAssistProperty") && params.getBoolean("isCkBxAssistProperty")) {
            sb.append(",FAssistID");
        }
        return sb.toString();
    }

    private String getSelectsTemp(RptParams params, boolean hasKsqlSeq) {
        StringBuffer sb = new StringBuffer();
        if (hasKsqlSeq) {
            sb.append("TEMP.KSQL_SEQ,");
        }
        sb.append("TEMP.FID,TEMP.FBILLID,TEMP.FBizDate,TEMP.FNumber,TEMP.FBillType,TEMP.FIsBizBill,TEMP.FCompanyOrgUnitID,TEMP.FSaleOrgUnitID,TEMP.FSaleGroupID,TEMP.FCustomerID,TEMP.FPersonID,TEMP.FStorageOrgUnitID,");
        sb.append("TEMP.FMaterialID,TEMP.FUnitID,TEMP.FQty,TEMP.FCurrencyID,TEMP.FRealPrice,TEMP.FTaxPrice,TEMP.FAmount,TEMP.FTaxAmount,TEMP.FDiscountAmount,TEMP.FRecievePayAmount,TEMP.FRealPriceLocal,TEMP.FRealTaxPriceLocal,TEMP.FAmountLocal,");
        sb.append("TEMP.FTaxAmountLocal,TEMP.FDiscountAmountLocal,TEMP.FRecievePayAmountLocal,TEMP.FTotalFlag,TEMP.FPricePrecision");
        if (params.containsKey("isCkBxAssistProperty") && params.getBoolean("isCkBxAssistProperty")) {
            sb.append(",TEMP.FAssistID");
        }
        return sb.toString();
    }

    private String getOrderByBySql(Context ctx, RptParams params) throws EASBizException, BOSException {
        String local_lan = ctx.getLocale().getLanguage();
        StringBuffer sqlbf = new StringBuffer();
        switch (this.groupBy) {
            case 1: {
                sqlbf.append(" order by TEMP.FBIZDATE,TEMP.FTotalFlag,TEMP.FNUMBER,MAT.FNUMBER,Temp.FQty,TEMP.FID");
                break;
            }
            case 2: {
                sqlbf.append(" order by TEMP.FNUMBER,TEMP.FTotalFlag,MAT.FNUMBER,Temp.FQty,Temp.FID");
                break;
            }
            case 3: {
                sqlbf.append(" order by TEMP.FBillType,TEMP.FTotalFlag,TEMP.FNUMBER,MAT.FNUMBER,Temp.FQty,TEMP.FID");
                break;
            }
            case 4: {
                sqlbf.append(" LEFT OUTER JOIN T_ORG_Sale AS org  ON TEMP.FSaleOrgUnitID = org.FID ");
                sqlbf.append(" order by TEMP.FSaleOrgUnitID,org.FName_").append(local_lan).append(",TEMP.FTotalFlag,TEMP.FNUMBER,MAT.FNUMBER,Temp.FQty,TEMP.FID");
                break;
            }
            case 5: {
                sqlbf.append(" LEFT OUTER JOIN T_BD_SaleGroup AS SaleGroup ON TEMP.FSaleGroupID = SaleGroup.FID ");
                sqlbf.append(" order by TEMP.FSaleGroupID,SaleGroup.FName_").append(local_lan).append(",TEMP.FTotalFlag,TEMP.FNUMBER,MAT.FNUMBER,Temp.FQty,TEMP.FID");
                break;
            }
            case 6: {
                sqlbf.append(" LEFT OUTER JOIN T_BD_Customer AS CUSTOMER ON TEMP.FCustomerID = CUSTOMER.FID ");
                sqlbf.append(" order by TEMP.FCustomerID,Customer.FName_").append(local_lan).append(",TEMP.FTotalFlag,TEMP.FNUMBER,MAT.FNUMBER,Temp.FQty,TEMP.FID");
                break;
            }
            case 7: {
                sqlbf.append(" LEFT OUTER JOIN T_BD_Person AS PERSON ON TEMP.FPersonId = PERSON.FID ");
                sqlbf.append(" order by TEMP.FPersonID,Person.FName_").append(local_lan).append(",TEMP.FTotalFlag,TEMP.FNUMBER,MAT.FNUMBER,Temp.FQty,TEMP.FID");
                break;
            }
            case 8: {
                if (params.containsKey("isCkBxAssistProperty") && params.getBoolean("isCkBxAssistProperty")) {
                    sqlbf.append(" order by TEMP.FMaterialID,MAT.FName_").append(local_lan).append(",TEMP.FTotalFlag,TEMP.FAssistID,TEMP.FNUMBER,Temp.FQty,TEMP.FID");
                    break;
                }
                sqlbf.append(" order by TEMP.FMaterialID,MAT.FName_").append(local_lan).append(",TEMP.FTotalFlag,TEMP.FNUMBER,Temp.FQty,TEMP.FID");
                break;
            }
            case 9: {
                sqlbf.append(" order by TEMP.FCurrencyID,TEMP.FTotalFlag,TEMP.FNUMBER,MAT.FNUMBER,Temp.FQty,TEMP.FID");
                break;
            }
            case 10: {
                sqlbf.append(" order by TEMP.FCompanyOrgUnitID,TEMP.FTotalFlag,TEMP.FNUMBER,MAT.FNUMBER,Temp.FQty,TEMP.FID");
            }
        }
        return sqlbf.toString();
    }

    private String getCreateTempTable(String tempTable, RptParams params) {
        StringBuffer sql = new StringBuffer(500);
        sql.append("Create Table TempReportTable(");
        sql.append("KSQL_SEQ INT IDENTITY(1,1),");
        sql.append("FID Varchar(44)\r\n");
        sql.append(",FBILLID Varchar(44)\r\n");
        sql.append(",FBizDate DateTime\r\n");
        sql.append(",FNumber Varchar(80)\r\n");
        sql.append(",FBillType Int\r\n");
        sql.append(",FIsBizBill Varchar(20)\r\n");
        sql.append(",FCompanyOrgUnitID Varchar(44)\r\n");
        sql.append(",FSaleOrgUnitID Varchar(44)\r\n");
        sql.append(",FSaleGroupID Varchar(44) \r\n");
        sql.append(",FCustomerID Varchar(44)\r\n");
        sql.append(",FPersonID Varchar(44)\r\n");
        sql.append(",FStorageOrgUnitID Varchar(44)\r\n");
        sql.append(",FMaterialID Varchar(44)\r\n");
        sql.append(",FUnitID Varchar(44)\r\n");
        sql.append(",FQty Decimal(28,10)\r\n");
        sql.append(",FCurrencyID Varchar(44)\r\n");
        sql.append(",FRealPrice Decimal(28,10)\r\n");
        sql.append(",FTaxPrice Decimal(28,10)\r\n");
        sql.append(",FAmount Decimal(28,10)\r\n");
        sql.append(",FTaxAmount Decimal(28,10)\r\n");
        sql.append(",FDiscountAmount  Decimal(28,10)\r\n");
        sql.append(",FRecievePayAmount  Decimal(28,10)\r\n");
        sql.append(",FRealPriceLocal Decimal(28,10)\r\n");
        sql.append(",FRealTaxPriceLocal Decimal(28,10)\r\n");
        sql.append(",FAmountLocal Decimal(28,10)\r\n");
        sql.append(",FTaxAmountLocal Decimal(28,10)\r\n");
        sql.append(",FDiscountAmountLocal  Decimal(28,10)\r\n");
        sql.append(",FRecievePayAmountLocal  Decimal(28,10)\r\n");
        sql.append(",FTotalFlag Varchar(44)\r\n");
        sql.append(",FPricePrecision Int default(4) \r\n");
        if (params.containsKey("isCkBxAssistProperty") && params.getBoolean("isCkBxAssistProperty")) {
            sql.append(",FAssistID Varchar(44)\r\n");
        }
        sql.append(");\r\n");
        return sql.toString();
    }

    private String getRptSql(RptParams params, SqlParams sqlParams, String tableName, Context ctx) throws BOSException, EASBizException {
        Object[] fullOrg = (Object[])params.getObject("fullOrgUnit");
        String orgIDlist = this.getOrgListId(fullOrg);
        if (orgIDlist.length() == 0) {
            MsgBox.showInfo((String)this.getServerResource("NoEntityORG", ctx));
            SysUtil.abort();
        }
        StringBuffer tableSQL = new StringBuffer();
        tableSQL.append(" \r\n   T_AR_OtherBill OtherBill ");
        tableSQL.append(" \r\n  inner join  T_AR_OtherBillEntry entry on OtherBill.FID = entry.FParentID ");
        if (params.containsKey("isCkBxAssistProperty") && params.getBoolean("isCkBxAssistProperty")) {
            tableSQL.append("\r\n  left outer join T_BD_ASSTATTRVALUE assist on assist.FID=entry.FASSISTPROPERTYID ");
        }
        tableSQL.append(" \r\n  inner join T_ORG_Company company on company.fid=OtherBill.FCompanyID ");
        StringBuffer companyOrgNumbers = new StringBuffer();
        if (params.getString("companyOrgUnit.number") != null) {
            StringTokenizer companyToken = new StringTokenizer(params.getString("companyOrgUnit.number"), ";");
            while (companyToken.hasMoreTokens()) {
                if (companyOrgNumbers.length() >= 1) {
                    companyOrgNumbers.append(",");
                }
                companyOrgNumbers.append("'");
                companyOrgNumbers.append(companyToken.nextToken().trim());
                companyOrgNumbers.append("'");
            }
            tableSQL.append(" \r\n  and  company.FNumber in (" + companyOrgNumbers + ")");
        }
        tableSQL.append(" \r\n  inner join T_BD_ExchangeTable tab on company.FBaseExgTableID=tab.fid ");
        tableSQL.append(" \r\n  left join  T_BD_ExchangeAux aux ");
        tableSQL.append(" \r\n  on (aux.FExchangeTableId=tab.fid and company.FBaseCurrencyID=aux.FTargetCurrencyID and OtherBill.FCurrencyID=aux.FSourceCurrencyID) ");
        tableSQL.append(" \r\n  INNER JOIN T_ORG_Sale org  on OTHERBILL.FSaleOrgID = org.FID ");
        tableSQL.append(" \r\n  and  OTHERBILL.FSaleOrgID in (" + orgIDlist + ")");
        SaleReportBillStatusEnum billStatus = SaleReportBillStatusEnum.getEnum(new Integer(params.getString("billStatus")));
        if (billStatus == SaleReportBillStatusEnum.cal) {
            tableSQL.append(" \r\n inner join t_bd_multimeasureunit mm on (mm.fmaterialid = ENTRY.FMaterialID and mm.FMeasureUnitId = ENTRY.FMeasureUnitId)");
        }
        String calSQL = "";
        if (billStatus == SaleReportBillStatusEnum.cal) {
            calSQL = this.getCalSQL(params, companyOrgNumbers);
        }
        StringBuffer storageOrgNumbers = new StringBuffer();
        if (params.getString("storageOrgUnit.number") != null) {
            StringTokenizer storagerToken = new StringTokenizer(params.getString("storageOrgUnit.number"), ";");
            while (storagerToken.hasMoreTokens()) {
                if (storageOrgNumbers.length() >= 1) {
                    storageOrgNumbers.append(",");
                }
                storageOrgNumbers.append("'");
                storageOrgNumbers.append(storagerToken.nextToken().trim());
                storageOrgNumbers.append("'");
            }
        }
        StringBuffer joinIMwithinSaleIssue = new StringBuffer();
        joinIMwithinSaleIssue.append(" \r\n  inner join T_IM_SaleIssueBill Issuebill on Issuebill.fid=entry.FSourceBillID ");
        joinIMwithinSaleIssue.append(" \r\n  inner join T_ORG_Storage storage on storage.fid=Issuebill.FstorageOrgUnitID ");
        joinIMwithinSaleIssue.append(storageOrgNumbers.length() > 0 ? " \r\n  and  storage.FNumber in  (" + storageOrgNumbers + ")" : "");
        StringBuffer joinIMwithinSaleOrder = new StringBuffer();
        joinIMwithinSaleOrder.append(" \r\n  inner join t_sd_saleorderentry soe on soe.fid = entry.fsourcebillentryid ");
        if (params.containsKey("isDirectSale") && params.getBoolean("isDirectSale")) {
            joinIMwithinSaleOrder.append(" \r\n  left outer join T_ORG_Storage storage on storage.fid=soe.FstorageOrgUnitID ");
        } else {
            joinIMwithinSaleOrder.append(" \r\n  inner join T_ORG_Storage storage on storage.fid=soe.FstorageOrgUnitID ");
        }
        StringBuffer joinIMwithSaleOrderAndArbill = new StringBuffer();
        joinIMwithSaleOrderAndArbill.append(" \r\n  inner join T_AR_OtherBillEntry soureEntry on soureEntry.fid = entry.fsourcebillentryid ");
        joinIMwithSaleOrderAndArbill.append(" \r\n  inner join t_sd_saleorderentry soe on soe.fid = soureEntry.fsourcebillentryid ");
        if (params.containsKey("isDirectSale") && params.getBoolean("isDirectSale")) {
            joinIMwithSaleOrderAndArbill.append(" \r\n  left outer join T_ORG_Storage storage on storage.fid=soe.FstorageOrgUnitID ");
        } else {
            joinIMwithSaleOrderAndArbill.append(" \r\n  inner join T_ORG_Storage storage on storage.fid=soe.FstorageOrgUnitID ");
        }
        StringBuffer joinIMwithSaleIssueAndArbill = new StringBuffer();
        joinIMwithSaleIssueAndArbill.append(" \r\n  inner join T_AR_OtherBillEntry soureEntry on soureEntry.fid = entry.fsourcebillentryid ");
        joinIMwithSaleIssueAndArbill.append(" \r\n  inner join T_IM_SaleIssueBill Issuebill on Issuebill.fid=soureEntry.FSourceBillID ");
        joinIMwithSaleIssueAndArbill.append(" \r\n  inner join T_ORG_Storage storage on storage.fid=Issuebill.FstorageOrgUnitID ");
        joinIMwithSaleIssueAndArbill.append(storageOrgNumbers.length() > 0 ? " \r\n  and  storage.FNumber in  (" + storageOrgNumbers + ")" : "");
        StringBuffer insertSQL = new StringBuffer();
        insertSQL.append("insert into " + tableName).append("(");
        insertSQL.append(this.getSelects(params, false));
        insertSQL.append(")");
        String selectSQL = this.getSelectSQL(params, ctx, "storage.fid");
        String whereSQL = this.getQueryStr(params, "OTHERBILL", ctx);
        boolean isIncludeDebit = false;
        if (params.containsKey("isNotIncludeDebit") && !params.getBoolean("isNotIncludeDebit")) {
            isIncludeDebit = true;
        }
        insertSQL.append(selectSQL);
        insertSQL.append(" FROM ");
        insertSQL.append(tableSQL);
        insertSQL.append(joinIMwithinSaleIssue);
        insertSQL.append(calSQL);
        insertSQL.append(whereSQL);
        if (!isIncludeDebit) {
            insertSQL.append(" and OtherBill.FBILLTYPE <> 104");
        }
        this.setRPTData(sqlParams, params);
        insertSQL.append(" UNION ALL ");
        insertSQL.append(selectSQL);
        insertSQL.append(" FROM ");
        insertSQL.append(tableSQL);
        insertSQL.append(joinIMwithSaleOrderAndArbill);
        insertSQL.append(calSQL);
        insertSQL.append(whereSQL);
        insertSQL.append(storageOrgNumbers.length() > 0 ? " \r\n and storage.FNumber in  (" + storageOrgNumbers + ")" : "");
        insertSQL.append("\r\n and OtherBill.FSourceBillType =  ").append(18);
        if (!isIncludeDebit) {
            insertSQL.append("\r\n and OtherBill.FBillType !=  ").append(104);
        }
        insertSQL.append("\r\n and OtherBill.FBillType =  ").append(104);
        this.setRPTData(sqlParams, params);
        insertSQL.append(" UNION ALL ");
        insertSQL.append(selectSQL);
        insertSQL.append(" FROM ");
        insertSQL.append(tableSQL);
        insertSQL.append(joinIMwithSaleIssueAndArbill);
        insertSQL.append(calSQL);
        insertSQL.append(whereSQL);
        insertSQL.append("\r\n and OtherBill.FSourceBillType =  ").append(13);
        insertSQL.append("\r\n and OtherBill.FISREVERSEBILL = 0");
        if (!isIncludeDebit) {
            insertSQL.append("\r\n and OtherBill.FBillType !=  ").append(104);
        }
        this.setRPTData(sqlParams, params);
        insertSQL.append(" UNION ALL ");
        insertSQL.append(selectSQL);
        insertSQL.append(" FROM ");
        insertSQL.append(tableSQL);
        insertSQL.append(joinIMwithSaleOrderAndArbill);
        insertSQL.append(calSQL);
        insertSQL.append(whereSQL);
        insertSQL.append(storageOrgNumbers.length() > 0 ? " \r\n and storage.FNumber in  (" + storageOrgNumbers + ")" : "");
        insertSQL.append("\r\n and OtherBill.FBillType =  ").append(102);
        this.setRPTData(sqlParams, params);
        insertSQL.append(" UNION ALL ");
        insertSQL.append(selectSQL);
        insertSQL.append(" FROM ");
        insertSQL.append(tableSQL);
        insertSQL.append(joinIMwithinSaleOrder);
        insertSQL.append(calSQL);
        insertSQL.append(whereSQL);
        insertSQL.append(storageOrgNumbers.length() > 0 ? " \r\n and storage.FNumber in  (" + storageOrgNumbers + ")" : "");
        if (!isIncludeDebit) {
            insertSQL.append(" and OtherBill.FBILLTYPE <> 104");
        }
        this.setRPTData(sqlParams, params);
        if (storageOrgNumbers.length() <= 0) {
            insertSQL.append(" UNION ALL ");
            insertSQL.append(this.getSelectSQL(params, ctx, "null"));
            insertSQL.append(" FROM ");
            insertSQL.append(tableSQL);
            insertSQL.append(calSQL);
            insertSQL.append(whereSQL);
            this.setRPTData(sqlParams, params);
            if (params.containsKey("isDirectSale") && params.getBoolean("isDirectSale")) {
                insertSQL.append(" and OtherBill.FSourceBillType not in(").append(18).append(",").append(13).append(") ");
            } else {
                insertSQL.append(" and OtherBill.FSourceBillType not in(").append(18).append(",").append(13).append(") ");
                insertSQL.append(" and OtherBill.FBillType <> ").append(103);
                insertSQL.append(" and (OtherBill.FBizTypeID <> '").append("d8e80652-0111-1000-e000-04c5c0a812202407435C").append("'");
                insertSQL.append(" OR OtherBill.FBizTypeID IS NULL)");
            }
            insertSQL.append(" and OtherBill.FBillType <> ").append(101);
            if (!isIncludeDebit) {
                insertSQL.append(" and OtherBill.FBillType <> ").append(104);
            }
            insertSQL.append(" and OtherBill.FBillStatus = 3");
        }
        return insertSQL.toString();
    }

    private String getSelectSQL(RptParams params, Context ctx, String storageField) {
        StringBuffer selectSQL = new StringBuffer();
        selectSQL.append(" \r\n SELECT ");
        selectSQL.append(" \r\n ENTRY.FID");
        selectSQL.append(" \r\n ,OTHERBILL.FID FBILLID");
        selectSQL.append(" \r\n ,OTHERBILL.FBillDate");
        selectSQL.append(" \r\n ,OTHERBILL.FNumber");
        selectSQL.append(" \r\n ,OTHERBILL.FBillType");
        selectSQL.append(" \r\n ,case when OTHERBILL.FIsBizBill = 0 then '" + this.getServerResource("NO", ctx) + "'");
        selectSQL.append(" \r\n  else '" + this.getServerResource("YES", ctx) + "'  end");
        selectSQL.append(" \r\n ,OTHERBILL.FCompanyID");
        selectSQL.append(" \r\n ,OTHERBILL.FSaleOrgID");
        selectSQL.append(" \r\n ,ISNULL(OTHERBILL.FSaleGroupID,'zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz')");
        selectSQL.append(" \r\n ,OTHERBILL.FAsstActID");
        selectSQL.append(" \r\n ,ISNULL(OTHERBILL.FPersonID,'zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz')");
        selectSQL.append(" \r\n ,").append(storageField);
        selectSQL.append(" \r\n ,ISNULL(ENTRY.FMaterialID,ENTRY.FExpenseItemID) ");
        selectSQL.append(" \r\n ,ENTRY.FMeasureUnitID");
        SaleReportBillStatusEnum billStatus = SaleReportBillStatusEnum.getEnum(new Integer(params.getString("billStatus")));
        if (billStatus == SaleReportBillStatusEnum.cal) {
            selectSQL.append(" \r\n ,round(ENTRY.FBaseQty/mm.FBaseConvsRate,mm.FQtyPrecision) as FQuantity");
            selectSQL.append(" \r\n ,OTHERBILL.FCurrencyID");
            selectSQL.append(" \r\n ,ENTRY.FRealPrice");
            selectSQL.append(" \r\n ,ENTRY.FTaxPrice");
            selectSQL.append(" \r\n ,round(ENTRY.FAmount/ENTRY.FBASEQTY*ENTRY.FWrittenoffBaseQty,4) as FAmount");
            selectSQL.append(" \r\n ,round(ENTRY.FTaxAmount/ENTRY.FBASEQTY*ENTRY.FWrittenoffBaseQty,4) as FTaxAmount");
            selectSQL.append(" \r\n ,round(ENTRY.FDiscountAmount/ENTRY.FBASEQTY*ENTRY.FWrittenoffBaseQty,4) as FDiscountAmount");
            selectSQL.append(" \r\n ,round(ENTRY.FRecievePayAmount/ENTRY.FBASEQTY*ENTRY.FWrittenoffBaseQty,4) as FRecievePayAmount");
            selectSQL.append(" \r\n ,case when aux.FConvertMode is null then ENTRY.FRealPrice*1");
            selectSQL.append(" \r\n  else (case aux.FConvertMode when 0 then ENTRY.FRealPrice*OtherBill.FExchangeRate else ENTRY.FRealPrice/OtherBill.FExchangeRate end) end as price");
            selectSQL.append(" \r\n ,case when aux.FConvertMode is null then ENTRY.FTaxPrice*1");
            selectSQL.append(" \r\n  else (case aux.FConvertMode when 0 then ENTRY.FTaxPrice*OtherBill.FExchangeRate else ENTRY.FTaxPrice/OtherBill.FExchangeRate end) end as taxPrice");
            selectSQL.append(" \r\n ,ENTRY.FLocalWrittenoffAmount");
            selectSQL.append(" \r\n ,round(ENTRY.FTaxAmountLocal/ENTRY.FBASEQTY*ENTRY.FWrittenoffBaseQty,4) as FTaxAmountLocal");
            selectSQL.append(" \r\n ,round(ENTRY.FDiscountAmountLocal/ENTRY.FBASEQTY*ENTRY.FWrittenoffBaseQty,4) as FDiscountAmountLocal");
            selectSQL.append(" \r\n ,round(ENTRY.FRecievePayAmountLocal/ENTRY.FBASEQTY*ENTRY.FWrittenoffBaseQty,4) as FRecievePayAmountLocal");
        } else {
            selectSQL.append(" \r\n ,ENTRY.FQuantity");
            selectSQL.append(" \r\n ,OTHERBILL.FCurrencyID");
            selectSQL.append(" \r\n ,ENTRY.FRealPrice");
            selectSQL.append(" \r\n ,ENTRY.FTaxPrice");
            selectSQL.append(" \r\n ,ENTRY.FAmount");
            selectSQL.append(" \r\n ,ENTRY.FTaxAmount");
            selectSQL.append(" \r\n ,ENTRY.FDiscountAmount");
            selectSQL.append(" \r\n ,ENTRY.FRecievePayAmount");
            selectSQL.append(" \r\n ,case when aux.FConvertMode is null then ENTRY.FRealPrice*1");
            selectSQL.append(" \r\n  else (case aux.FConvertMode when 0 then ENTRY.FRealPrice*OtherBill.FExchangeRate else ENTRY.FRealPrice/OtherBill.FExchangeRate end) end as price");
            selectSQL.append(" \r\n ,case when aux.FConvertMode is null then ENTRY.FTaxPrice*1");
            selectSQL.append(" \r\n  else (case aux.FConvertMode when 0 then ENTRY.FTaxPrice*OtherBill.FExchangeRate else ENTRY.FTaxPrice/OtherBill.FExchangeRate end) end as taxPrice");
            selectSQL.append(" \r\n ,ENTRY.FAmountLocal");
            selectSQL.append(" \r\n ,ENTRY.FTaxAmountLocal");
            selectSQL.append(" \r\n ,ENTRY.FDiscountAmountLocal");
            selectSQL.append(" \r\n ,ENTRY.FRecievePayAmountLocal");
        }
        selectSQL.append(" \r\n ,'AAA'");
        selectSQL.append(" \r\n ,4");
        if (params.containsKey("isCkBxAssistProperty") && params.getBoolean("isCkBxAssistProperty")) {
            selectSQL.append(" \r\n ,assist.FID FAssistID");
        }
        return selectSQL.toString();
    }

    private String getRptTotalSql(RptParams params, String tableName, Context ctx) throws BOSException, EASBizException {
        StringBuffer groupSQL = new StringBuffer();
        this.groupBy = new Integer(params.getString("CombOrderCol"));
        switch (this.groupBy) {
            case 1: {
                groupSQL.append("INSERT INTO " + tableName);
                groupSQL.append(" \r\n (FID,FBizDate");
                groupSQL.append(" \r\n ,FAmountLocal");
                groupSQL.append(" ,FQty");
                groupSQL.append(",FTaxAmountLocal ");
                groupSQL.append(",FDiscountAmountLocal");
                groupSQL.append(",FRecievePayAmountLocal");
                groupSQL.append(",FAmount");
                groupSQL.append(",FTaxAmount ");
                groupSQL.append(",FDiscountAmount");
                groupSQL.append(",FRecievePayAmount");
                groupSQL.append(",FTotalFlag)");
                groupSQL.append(" \r\n SELECT ");
                groupSQL.append(" \r\n newbosid('88888888')");
                groupSQL.append(" \r\n ,MAX(FBizDate)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FQty),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FTaxAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FDiscountAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FRecievePayAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FAmount),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FTaxAmount),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FDiscountAmount),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FRecievePayAmount),31,7)");
                groupSQL.append(" \r\n ,'Total'");
                groupSQL.append(" \r\n  from " + tableName);
                groupSQL.append(" \r\n  GROUP BY SUBSTRING(TO_CHAR(FBizDate),1,10)");
                break;
            }
            case 2: {
                groupSQL.append("INSERT INTO " + tableName);
                groupSQL.append(" \r\n (FID,FNumber");
                groupSQL.append(" \r\n ,FAmountLocal");
                groupSQL.append(" ,FQty");
                groupSQL.append(",FTaxAmountLocal ");
                groupSQL.append(",FDiscountAmountLocal");
                groupSQL.append(",FRecievePayAmountLocal");
                groupSQL.append(",FAmount");
                groupSQL.append(",FTaxAmount ");
                groupSQL.append(",FDiscountAmount");
                groupSQL.append(",FRecievePayAmount");
                groupSQL.append(",FTotalFlag)");
                groupSQL.append(" \r\n SELECT ");
                groupSQL.append(" \r\n newbosid('88888888')");
                groupSQL.append(" \r\n ,MAX(FNumber)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FQty),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FTaxAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FDiscountAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FRecievePayAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FAmount),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FTaxAmount),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FDiscountAmount),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FRecievePayAmount),31,7)");
                groupSQL.append(" \r\n ,'Total'");
                groupSQL.append(" \r\n  from " + tableName);
                groupSQL.append(" \r\n  GROUP BY FNumber");
                break;
            }
            case 3: {
                groupSQL.append("INSERT INTO " + tableName);
                groupSQL.append(" \r\n (FID,FBillType");
                groupSQL.append(" \r\n ,FAmountLocal");
                groupSQL.append(" ,FQty");
                groupSQL.append(",FTaxAmountLocal ");
                groupSQL.append(",FDiscountAmountLocal");
                groupSQL.append(",FRecievePayAmountLocal");
                groupSQL.append(",FAmount");
                groupSQL.append(",FTaxAmount ");
                groupSQL.append(",FDiscountAmount");
                groupSQL.append(",FRecievePayAmount");
                groupSQL.append(",FTotalFlag)");
                groupSQL.append(" \r\n SELECT ");
                groupSQL.append(" \r\n newbosid('88888888')");
                groupSQL.append(" \r\n ,MAX(FBillType)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FQty),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FTaxAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FDiscountAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FRecievePayAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FAmount),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FTaxAmount),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FDiscountAmount),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FRecievePayAmount),31,7)");
                groupSQL.append(" \r\n ,'Total'");
                groupSQL.append(" \r\n  from " + tableName);
                groupSQL.append(" \r\n  GROUP BY FBillType");
                break;
            }
            case 4: {
                groupSQL.append("INSERT INTO " + tableName);
                groupSQL.append(" \r\n (FID,FSaleOrgUnitID");
                groupSQL.append(" \r\n ,FAmountLocal");
                groupSQL.append(" ,FQty");
                groupSQL.append(",FTaxAmountLocal ");
                groupSQL.append(",FDiscountAmountLocal");
                groupSQL.append(",FRecievePayAmountLocal");
                groupSQL.append(",FAmount");
                groupSQL.append(",FTaxAmount ");
                groupSQL.append(",FDiscountAmount");
                groupSQL.append(",FRecievePayAmount");
                groupSQL.append(",FTotalFlag)");
                groupSQL.append(" \r\n SELECT ");
                groupSQL.append(" \r\n newbosid('88888888')");
                groupSQL.append(" \r\n ,MAX(FSaleOrgUnitID)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FQty),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FTaxAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FDiscountAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FRecievePayAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FAmount),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FTaxAmount),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FDiscountAmount),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FRecievePayAmount),31,7)");
                groupSQL.append(" \r\n ,'Total'");
                groupSQL.append(" \r\n  from " + tableName);
                groupSQL.append(" \r\n  GROUP BY FSaleOrgUnitID");
                break;
            }
            case 10: {
                groupSQL.append("INSERT INTO " + tableName);
                groupSQL.append(" \r\n (FID,FCompanyOrgUnitID");
                groupSQL.append(" \r\n ,FAmountLocal");
                groupSQL.append(" ,FQty");
                groupSQL.append(",FTaxAmountLocal ");
                groupSQL.append(",FDiscountAmountLocal");
                groupSQL.append(",FRecievePayAmountLocal");
                groupSQL.append(",FAmount");
                groupSQL.append(",FTaxAmount ");
                groupSQL.append(",FDiscountAmount");
                groupSQL.append(",FRecievePayAmount");
                groupSQL.append(",FTotalFlag)");
                groupSQL.append(" \r\n SELECT ");
                groupSQL.append(" \r\n newbosid('88888888')");
                groupSQL.append(" \r\n ,MAX(FCompanyOrgUnitID)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FQty),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FTaxAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FDiscountAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FRecievePayAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FAmount),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FTaxAmount),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FDiscountAmount),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FRecievePayAmount),31,7)");
                groupSQL.append(" \r\n ,'Total'");
                groupSQL.append(" \r\n  from " + tableName);
                groupSQL.append(" \r\n  GROUP BY FCompanyOrgUnitID");
                break;
            }
            case 5: {
                groupSQL.append("INSERT INTO " + tableName);
                groupSQL.append(" \r\n (FID,FSaleGroupID");
                groupSQL.append(" \r\n ,FAmountLocal");
                groupSQL.append(" ,FQty");
                groupSQL.append(",FTaxAmountLocal ");
                groupSQL.append(",FDiscountAmountLocal");
                groupSQL.append(",FRecievePayAmountLocal");
                groupSQL.append(",FAmount");
                groupSQL.append(",FTaxAmount ");
                groupSQL.append(",FDiscountAmount");
                groupSQL.append(",FRecievePayAmount");
                groupSQL.append(",FTotalFlag)");
                groupSQL.append(" \r\n SELECT ");
                groupSQL.append(" \r\n newbosid('88888888')");
                groupSQL.append(" \r\n ,MAX(FSaleGroupID)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FQty),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FTaxAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FDiscountAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FRecievePayAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FAmount),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FTaxAmount),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FDiscountAmount),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FRecievePayAmount),31,7)");
                groupSQL.append(" \r\n ,'Total'");
                groupSQL.append(" \r\n  from " + tableName);
                groupSQL.append(" \r\n  GROUP BY FSaleGroupID");
                break;
            }
            case 6: {
                groupSQL.append("INSERT INTO " + tableName);
                groupSQL.append(" \r\n (FID,FCustomerID");
                groupSQL.append(" \r\n ,FAmountLocal");
                groupSQL.append(" ,FQty");
                groupSQL.append(",FTaxAmountLocal ");
                groupSQL.append(",FDiscountAmountLocal");
                groupSQL.append(",FRecievePayAmountLocal");
                groupSQL.append(",FAmount");
                groupSQL.append(",FTaxAmount ");
                groupSQL.append(",FDiscountAmount");
                groupSQL.append(",FRecievePayAmount");
                groupSQL.append(",FTotalFlag)");
                groupSQL.append(" \r\n SELECT ");
                groupSQL.append(" \r\n newbosid('88888888')");
                groupSQL.append(" \r\n ,MAX(FCustomerID)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FQty),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FTaxAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FDiscountAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FRecievePayAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FAmount),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FTaxAmount),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FDiscountAmount),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FRecievePayAmount),31,7)");
                groupSQL.append(" \r\n ,'Total'");
                groupSQL.append(" \r\n  from " + tableName);
                groupSQL.append(" \r\n  GROUP BY FCustomerID");
                break;
            }
            case 7: {
                groupSQL.append("INSERT INTO " + tableName);
                groupSQL.append(" \r\n (FID,FPersonID");
                groupSQL.append(" \r\n ,FAmountLocal");
                groupSQL.append(" ,FQty");
                groupSQL.append(",FTaxAmountLocal ");
                groupSQL.append(",FDiscountAmountLocal");
                groupSQL.append(",FRecievePayAmountLocal");
                groupSQL.append(",FAmount");
                groupSQL.append(",FTaxAmount ");
                groupSQL.append(",FDiscountAmount");
                groupSQL.append(",FRecievePayAmount");
                groupSQL.append(",FTotalFlag)");
                groupSQL.append(" \r\n SELECT ");
                groupSQL.append(" \r\n newbosid('88888888')");
                groupSQL.append(" \r\n ,MAX(FPersonID)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FQty),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FTaxAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FDiscountAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FRecievePayAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FAmount),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FTaxAmount),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FDiscountAmount),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FRecievePayAmount),31,7)");
                groupSQL.append(" \r\n ,'Total'");
                groupSQL.append(" \r\n  from " + tableName);
                groupSQL.append(" \r\n  GROUP BY FPersonID");
                break;
            }
            case 8: {
                groupSQL.append("INSERT INTO " + tableName);
                groupSQL.append(" \r\n (FID,FMaterialID");
                if (params.containsKey("isCkBxAssistProperty") && params.getBoolean("isCkBxAssistProperty")) {
                    groupSQL.append(" \r\n ,FAssistID");
                }
                groupSQL.append(" \r\n ,FAmountLocal");
                groupSQL.append(" ,FQty");
                groupSQL.append(",FTaxAmountLocal ");
                groupSQL.append(",FDiscountAmountLocal");
                groupSQL.append(",FRecievePayAmountLocal");
                groupSQL.append(",FAmount");
                groupSQL.append(",FTaxAmount ");
                groupSQL.append(",FDiscountAmount");
                groupSQL.append(",FRecievePayAmount");
                groupSQL.append(",FTotalFlag)");
                groupSQL.append(" \r\n SELECT ");
                groupSQL.append(" \r\n newbosid('88888888')");
                groupSQL.append(" \r\n ,MAX(FMaterialID)");
                if (params.containsKey("isCkBxAssistProperty") && params.getBoolean("isCkBxAssistProperty")) {
                    groupSQL.append(" \r\n ,MAX(FAssistID)");
                }
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FQty),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FTaxAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FDiscountAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FRecievePayAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FAmount),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FTaxAmount),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FDiscountAmount),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FRecievePayAmount),31,7)");
                groupSQL.append(" \r\n ,'Total'");
                groupSQL.append(" \r\n  from " + tableName);
                groupSQL.append(" \r\n  GROUP BY FMaterialID ");
                if (!params.containsKey("isCkBxAssistProperty") || !params.getBoolean("isCkBxAssistProperty")) break;
                groupSQL.append(",FAssistID ");
                break;
            }
            case 9: {
                groupSQL.append("INSERT INTO " + tableName);
                groupSQL.append(" \r\n (FID,FCurrencyID");
                groupSQL.append(" \r\n ,FAmountLocal");
                groupSQL.append(" ,FQty");
                groupSQL.append(",FTaxAmountLocal ");
                groupSQL.append(",FDiscountAmountLocal");
                groupSQL.append(",FRecievePayAmountLocal");
                groupSQL.append(",FAmount");
                groupSQL.append(",FTaxAmount ");
                groupSQL.append(",FDiscountAmount");
                groupSQL.append(",FRecievePayAmount");
                groupSQL.append(",FTotalFlag)");
                groupSQL.append(" \r\n SELECT ");
                groupSQL.append(" \r\n newbosid('88888888')");
                groupSQL.append(" \r\n ,MAX(FCurrencyID)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FQty),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FTaxAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FDiscountAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FRecievePayAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FAmount),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FTaxAmount),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FDiscountAmount),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FRecievePayAmount),31,7)");
                groupSQL.append(" \r\n ,'Total'");
                groupSQL.append(" \r\n  from " + tableName);
                groupSQL.append(" \r\n  GROUP BY FCurrencyID");
            }
        }
        return groupSQL.toString();
    }

    private String getRptSumSql(RptParams params, String tableName, Context ctx) throws BOSException, EASBizException {
        StringBuffer groupSQL = new StringBuffer();
        this.groupBy = new Integer(params.getString("CombOrderCol"));
        switch (this.groupBy) {
            case 1: {
                groupSQL.append("INSERT INTO " + tableName);
                groupSQL.append(" \r\n (FID,FBizDate");
                groupSQL.append(" \r\n ,FAmountLocal");
                groupSQL.append(" ,FQty");
                groupSQL.append(",FTaxAmountLocal ");
                groupSQL.append(",FDiscountAmountLocal");
                groupSQL.append(",FRecievePayAmountLocal");
                groupSQL.append(",FAmount");
                groupSQL.append(",FTaxAmount ");
                groupSQL.append(",FDiscountAmount");
                groupSQL.append(",FRecievePayAmount");
                groupSQL.append(",FTotalFlag)");
                groupSQL.append(" \r\n SELECT ");
                groupSQL.append(" \r\n newbosid('88888888')");
                groupSQL.append(" \r\n ,MAX(FBizDate)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FQty),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FTaxAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FDiscountAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FRecievePayAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FAmount),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FTaxAmount),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FDiscountAmount),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FRecievePayAmount),31,7)");
                groupSQL.append(" \r\n ,'TotalAll'");
                groupSQL.append(" \r\n  from " + tableName);
                groupSQL.append(" \r\n  where FTotalFlag<>'Total'");
                break;
            }
            case 2: {
                groupSQL.append("INSERT INTO " + tableName);
                groupSQL.append(" \r\n (FID,FNumber");
                groupSQL.append(" \r\n ,FAmountLocal");
                groupSQL.append(" ,FQty");
                groupSQL.append(",FTaxAmountLocal ");
                groupSQL.append(",FDiscountAmountLocal");
                groupSQL.append(",FRecievePayAmountLocal");
                groupSQL.append(",FAmount");
                groupSQL.append(",FTaxAmount ");
                groupSQL.append(",FDiscountAmount");
                groupSQL.append(",FRecievePayAmount");
                groupSQL.append(",FTotalFlag)");
                groupSQL.append(" \r\n SELECT ");
                groupSQL.append(" \r\n newbosid('88888888')");
                groupSQL.append(" \r\n ,MAX(FNumber)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FQty),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FTaxAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FDiscountAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FRecievePayAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FAmount),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FTaxAmount),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FDiscountAmount),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FRecievePayAmount),31,7)");
                groupSQL.append(" \r\n ,'TotalAll'");
                groupSQL.append(" \r\n  from " + tableName);
                groupSQL.append(" \r\n  where FTotalFlag<>'Total'");
                break;
            }
            case 3: {
                groupSQL.append("INSERT INTO " + tableName);
                groupSQL.append(" \r\n (FID,FBillType");
                groupSQL.append(" \r\n ,FAmountLocal");
                groupSQL.append(" ,FQty");
                groupSQL.append(",FTaxAmountLocal ");
                groupSQL.append(",FDiscountAmountLocal");
                groupSQL.append(",FRecievePayAmountLocal");
                groupSQL.append(",FAmount");
                groupSQL.append(",FTaxAmount ");
                groupSQL.append(",FDiscountAmount");
                groupSQL.append(",FRecievePayAmount");
                groupSQL.append(",FTotalFlag)");
                groupSQL.append(" \r\n SELECT ");
                groupSQL.append(" \r\n newbosid('88888888')");
                groupSQL.append(" \r\n ,MAX(FBillType)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FQty),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FTaxAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FDiscountAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FRecievePayAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FAmount),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FTaxAmount),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FDiscountAmount),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FRecievePayAmount),31,7)");
                groupSQL.append(" \r\n ,'TotalAll'");
                groupSQL.append(" \r\n  from " + tableName);
                groupSQL.append(" \r\n  where FTotalFlag<>'Total'");
                break;
            }
            case 4: {
                groupSQL.append("INSERT INTO " + tableName);
                groupSQL.append(" \r\n (FID,FSaleOrgUnitID");
                groupSQL.append(" \r\n ,FAmountLocal");
                groupSQL.append(" ,FQty");
                groupSQL.append(",FTaxAmountLocal ");
                groupSQL.append(",FDiscountAmountLocal");
                groupSQL.append(",FRecievePayAmountLocal");
                groupSQL.append(",FAmount");
                groupSQL.append(",FTaxAmount ");
                groupSQL.append(",FDiscountAmount");
                groupSQL.append(",FRecievePayAmount");
                groupSQL.append(",FTotalFlag)");
                groupSQL.append(" \r\n SELECT ");
                groupSQL.append(" \r\n newbosid('88888888')");
                groupSQL.append(" \r\n ,MAX(FSaleOrgUnitID)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FQty),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FTaxAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FDiscountAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FRecievePayAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FAmount),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FTaxAmount),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FDiscountAmount),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FRecievePayAmount),31,7)");
                groupSQL.append(" \r\n ,'TotalAll'");
                groupSQL.append(" \r\n  from " + tableName);
                groupSQL.append(" \r\n  where FTotalFlag<>'Total'");
                break;
            }
            case 10: {
                groupSQL.append("INSERT INTO " + tableName);
                groupSQL.append(" \r\n (FID,FCompanyOrgUnitID");
                groupSQL.append(" \r\n ,FAmountLocal");
                groupSQL.append(" ,FQty");
                groupSQL.append(",FTaxAmountLocal ");
                groupSQL.append(",FDiscountAmountLocal");
                groupSQL.append(",FRecievePayAmountLocal");
                groupSQL.append(",FAmount");
                groupSQL.append(",FTaxAmount ");
                groupSQL.append(",FDiscountAmount");
                groupSQL.append(",FRecievePayAmount");
                groupSQL.append(",FTotalFlag)");
                groupSQL.append(" \r\n SELECT ");
                groupSQL.append(" \r\n newbosid('88888888')");
                groupSQL.append(" \r\n ,MAX(FCompanyOrgUnitID)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FQty),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FTaxAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FDiscountAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FRecievePayAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FAmount),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FTaxAmount),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FDiscountAmount),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FRecievePayAmount),31,7)");
                groupSQL.append(" \r\n ,'TotalAll'");
                groupSQL.append(" \r\n  from " + tableName);
                groupSQL.append(" \r\n  where FTotalFlag<>'Total'");
                break;
            }
            case 5: {
                groupSQL.append("INSERT INTO " + tableName);
                groupSQL.append(" \r\n (FID,FSaleGroupID");
                groupSQL.append(" \r\n ,FAmountLocal");
                groupSQL.append(" ,FQty");
                groupSQL.append(",FTaxAmountLocal ");
                groupSQL.append(",FDiscountAmountLocal");
                groupSQL.append(",FRecievePayAmountLocal");
                groupSQL.append(",FAmount");
                groupSQL.append(",FTaxAmount ");
                groupSQL.append(",FDiscountAmount");
                groupSQL.append(",FRecievePayAmount");
                groupSQL.append(",FTotalFlag)");
                groupSQL.append(" \r\n SELECT ");
                groupSQL.append(" \r\n newbosid('88888888')");
                groupSQL.append(" \r\n ,MAX(FSaleGroupID)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FQty),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FTaxAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FDiscountAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FRecievePayAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FAmount),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FTaxAmount),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FDiscountAmount),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FRecievePayAmount),31,7)");
                groupSQL.append(" \r\n ,'TotalAll'");
                groupSQL.append(" \r\n  from " + tableName);
                groupSQL.append(" \r\n  where FTotalFlag<>'Total'");
                break;
            }
            case 6: {
                groupSQL.append("INSERT INTO " + tableName);
                groupSQL.append(" \r\n (FID,FCustomerID");
                groupSQL.append(" \r\n ,FAmountLocal");
                groupSQL.append(" ,FQty");
                groupSQL.append(",FTaxAmountLocal ");
                groupSQL.append(",FDiscountAmountLocal");
                groupSQL.append(",FRecievePayAmountLocal");
                groupSQL.append(",FAmount");
                groupSQL.append(",FTaxAmount ");
                groupSQL.append(",FDiscountAmount");
                groupSQL.append(",FRecievePayAmount");
                groupSQL.append(",FTotalFlag)");
                groupSQL.append(" \r\n SELECT ");
                groupSQL.append(" \r\n newbosid('88888888')");
                groupSQL.append(" \r\n ,MAX(FCustomerID)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FQty),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FTaxAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FDiscountAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FRecievePayAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FAmount),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FTaxAmount),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FDiscountAmount),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FRecievePayAmount),31,7)");
                groupSQL.append(" \r\n ,'TotalAll'");
                groupSQL.append(" \r\n  from " + tableName);
                groupSQL.append(" \r\n  where FTotalFlag<>'Total'");
                break;
            }
            case 7: {
                groupSQL.append("INSERT INTO " + tableName);
                groupSQL.append(" \r\n (FID,FPersonID");
                groupSQL.append(" \r\n ,FAmountLocal");
                groupSQL.append(" ,FQty");
                groupSQL.append(",FTaxAmountLocal ");
                groupSQL.append(",FDiscountAmountLocal");
                groupSQL.append(",FRecievePayAmountLocal");
                groupSQL.append(",FAmount");
                groupSQL.append(",FTaxAmount ");
                groupSQL.append(",FDiscountAmount");
                groupSQL.append(",FRecievePayAmount");
                groupSQL.append(",FTotalFlag)");
                groupSQL.append(" \r\n SELECT ");
                groupSQL.append(" \r\n newbosid('88888888')");
                groupSQL.append(" \r\n ,MAX(FPersonID)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FQty),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FTaxAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FDiscountAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FRecievePayAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FAmount),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FTaxAmount),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FDiscountAmount),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FRecievePayAmount),31,7)");
                groupSQL.append(" \r\n ,'TotalAll'");
                groupSQL.append(" \r\n  from " + tableName);
                groupSQL.append(" \r\n  where FTotalFlag<>'Total'");
                break;
            }
            case 8: {
                groupSQL.append("INSERT INTO " + tableName);
                groupSQL.append(" \r\n (FID,FMaterialID");
                groupSQL.append(" \r\n ,FAmountLocal");
                groupSQL.append(" ,FQty");
                groupSQL.append(",FTaxAmountLocal ");
                groupSQL.append(",FDiscountAmountLocal");
                groupSQL.append(",FRecievePayAmountLocal");
                groupSQL.append(",FAmount");
                groupSQL.append(",FTaxAmount ");
                groupSQL.append(",FDiscountAmount");
                groupSQL.append(",FRecievePayAmount");
                groupSQL.append(",FTotalFlag)");
                groupSQL.append(" \r\n SELECT ");
                groupSQL.append(" \r\n newbosid('88888888')");
                groupSQL.append(" \r\n ,MAX(FMaterialID)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FQty),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FTaxAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FDiscountAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FRecievePayAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FAmount),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FTaxAmount),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FDiscountAmount),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FRecievePayAmount),31,7)");
                groupSQL.append(" \r\n ,'TotalAll'");
                groupSQL.append(" \r\n  from " + tableName);
                groupSQL.append(" \r\n  where FTotalFlag<>'Total'");
                break;
            }
            case 9: {
                groupSQL.append("INSERT INTO " + tableName);
                groupSQL.append(" \r\n (FID,FCurrencyID");
                groupSQL.append(" \r\n ,FAmountLocal");
                groupSQL.append(" ,FQty");
                groupSQL.append(",FTaxAmountLocal ");
                groupSQL.append(",FDiscountAmountLocal");
                groupSQL.append(",FRecievePayAmountLocal");
                groupSQL.append(",FAmount");
                groupSQL.append(",FTaxAmount ");
                groupSQL.append(",FDiscountAmount");
                groupSQL.append(",FRecievePayAmount");
                groupSQL.append(",FTotalFlag)");
                groupSQL.append(" \r\n SELECT ");
                groupSQL.append(" \r\n newbosid('88888888')");
                groupSQL.append(" \r\n ,MAX(FCurrencyID)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FQty),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FTaxAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FDiscountAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FRecievePayAmountLocal),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FAmount),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FTaxAmount),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FDiscountAmount),31,7)");
                groupSQL.append(" \r\n ,TO_DECIMAL(SUM(FRecievePayAmount),31,7)");
                groupSQL.append(" \r\n ,'TotalAll'");
                groupSQL.append(" \r\n  from " + tableName);
                groupSQL.append(" \r\n  where FTotalFlag<>'Total'");
            }
        }
        return groupSQL.toString();
    }

    private void setRPTData(SqlParams sqlParams, RptParams params) {
        int i;
        int count = sqlParams.size() + 1;
        if (params.getObject("materialFrom") != null) {
            if (params.getObject("materialFrom") instanceof Object[]) {
                Object[] materials = (Object[])params.getObject("materialFrom");
                for (i = 0; i < materials.length; ++i) {
                    sqlParams.setString(count++, ((MaterialInfo)materials[i]).getNumber());
                }
            } else {
                sqlParams.setString(count++, params.getObject("materialFrom").toString());
            }
        }
        if (params.getObject("materialTo") != null) {
            sqlParams.setString(count++, params.getString("materialTo"));
        }
        if (params.getString("shortNameFrom") != null) {
            sqlParams.setString(count++, params.getString("shortNameFrom"));
        }
        if (params.getObject("shortNameTo") != null) {
            sqlParams.setString(count++, params.getString("shortNameTo"));
        }
        if (params.getObject("CustomerFrom") != null && params.getObject("CustomerFrom") != null) {
            if (params.getObject("CustomerFrom") instanceof Object[]) {
                Object[] customers = (Object[])params.getObject("CustomerFrom");
                for (i = 0; i < customers.length; ++i) {
                    sqlParams.setString(count++, ((CustomerInfo)customers[i]).getNumber());
                }
            } else if (params.getObject("CustomerFrom") instanceof CustomerInfo) {
                sqlParams.setString(count++, ((CustomerInfo)params.getObject("CustomerFrom")).getNumber());
            } else {
                sqlParams.setString(count++, params.getObject("CustomerFrom").toString());
            }
        }
        if (params.getString("CustomerTo") != null) {
            sqlParams.setString(count++, params.getString("CustomerTo"));
        }
        if (params.getString("SaleGroupFrom") != null) {
            sqlParams.setString(count++, params.getString("SaleGroupFrom"));
        }
        if (params.getString("SaleGroupTo") != null) {
            sqlParams.setString(count++, params.getString("SaleGroupTo"));
        }
        if (params.getObject("SalePersonFrom") != null) {
            if (params.getObject("SalePersonFrom") instanceof Object[]) {
                Object[] salePersons = (Object[])params.getObject("SalePersonFrom");
                for (i = 0; i < salePersons.length; ++i) {
                    sqlParams.setString(count++, ((PersonInfo)salePersons[i]).getNumber());
                }
            } else {
                sqlParams.setString(count++, params.getObject("SalePersonFrom").toString());
            }
        }
        if (params.getString("SalePersonTo") != null) {
            sqlParams.setString(count++, params.getString("SalePersonTo"));
        }
        if (params.getString("DeptFrom") != null) {
            sqlParams.setString(count++, params.getString("DeptFrom"));
        }
        if (params.getString("DeptTo") != null) {
            sqlParams.setString(count++, params.getString("DeptTo"));
        }
    }

    private String getQueryStr(RptParams params, String aliasName, Context ctx) throws EASBizException, BOSException {
        int i;
        Object[] obj;
        StringBuffer queryStr = new StringBuffer();
        StringBuffer joinStr = new StringBuffer();
        String bd = null;
        String ed = null;
        bd = params.getString("dateStart");
        ed = params.getString("dateEnd");
        if (params.containsKey("isBizBill") && params.getBoolean("isBizBill")) {
            queryStr.append("\r\n where  ");
        } else {
            queryStr.append("\r\n where " + aliasName + ".FIsBizBill = 0 and ");
        }
        SaleReportBillStatusEnum billStatus = SaleReportBillStatusEnum.getEnum(new Integer(params.getString("billStatus")));
        if (billStatus != SaleReportBillStatusEnum.cal) {
            if (bd != null && bd.trim().length() > 0) {
                queryStr.append(aliasName).append(".FBillDate >= {");
                queryStr.append(bd.substring(0, 10)).append(" 00:00:00} and ");
            }
            if (ed != null && ed.trim().length() > 0) {
                queryStr.append(aliasName).append(".FBillDate <= {");
                queryStr.append(ed.substring(0, 10)).append(" 23:59:59} and ");
            }
        }
        queryStr.append(aliasName + ".FIstransbill <> 1");
        queryStr.append(" and ");
        queryStr.append(aliasName + ".FBillStatus =3 ");
        if (params.getObject("materialFrom") != null) {
            if (params.getObject("materialFrom") instanceof Object[]) {
                obj = (Object[])params.getObject("materialFrom");
                if (obj.length == 1) {
                    queryStr.append(" and material.FNumber >= ? ");
                } else {
                    queryStr.append(" and material.FNumber in (?");
                    for (i = 1; i < obj.length; ++i) {
                        queryStr.append(",?");
                    }
                    queryStr.append(")");
                }
            } else {
                queryStr.append(" and material.FNumber >= ? ");
            }
            if (joinStr.toString().indexOf("T_BD_Material") == -1) {
                joinStr.append("\r\n inner join T_BD_Material material ");
                joinStr.append(" on material.fid = ENTRY.FMaterialID ");
            }
        }
        if (params.getString("materialTo") != null) {
            queryStr.append(" and material.FNumber <= ? ");
            if (joinStr.toString().indexOf("T_BD_Material") == -1) {
                joinStr.append("\r\n inner join T_BD_Material material ");
                joinStr.append(" on material.fid = ENTRY.FMaterialID ");
            }
        }
        if (params.getString("shortNameFrom") != null) {
            queryStr.append(" and material.FShortName >= ? ");
            if (joinStr.toString().indexOf("T_BD_Material") == -1) {
                joinStr.append("\r\n inner join T_BD_Material material ");
                joinStr.append(" on material.fid = ENTRY.FMaterialID ");
            }
        }
        if (params.getString("shortNameTo") != null) {
            queryStr.append(" and material.FShortName <= ? ");
            if (joinStr.toString().indexOf("T_BD_Material") == -1) {
                joinStr.append("\r\n inner join T_BD_Material material ");
                joinStr.append(" on material.fid = ENTRY.FMaterialID ");
            }
        }
        if (params.getObject("CustomerFrom") != null) {
            if (params.getObject("CustomerFrom") instanceof Object[]) {
                obj = (Object[])params.getObject("CustomerFrom");
                if (obj.length == 1) {
                    queryStr.append(" and Customer.FNumber >= ? ");
                } else {
                    queryStr.append(" and Customer.FNumber in (?");
                    for (i = 1; i < obj.length; ++i) {
                        queryStr.append(",?");
                    }
                    queryStr.append(")");
                }
            } else {
                queryStr.append(" and Customer.FNumber >= ? ");
            }
            if (joinStr.toString().indexOf("T_BD_Customer") == -1) {
                joinStr.append("\r\n INNER join T_BD_Customer Customer ");
                joinStr.append(" on Customer.fid = OTHERBILL.FAsstActID ");
            }
        }
        if (params.getString("CustomerTo") != null) {
            queryStr.append(" and Customer.FNumber <= ? ");
            if (joinStr.toString().indexOf("T_BD_Customer") == -1) {
                joinStr.append("\r\n inner join T_BD_Customer Customer ");
                joinStr.append(" on Customer.fid = OTHERBILL.FAsstActID ");
            }
        }
        if (params.getString("SaleGroupFrom") != null) {
            queryStr.append(" and SALEGROUP.FNumber >= ? ");
            if (joinStr.toString().indexOf("T_BD_SaleGroup") == -1) {
                joinStr.append("\r\n INNER JOIN T_BD_SaleGroup AS SALEGROUP ");
                joinStr.append(" ON OTHERBILL.FSaleGroupID = SALEGROUP.FID ");
            }
        }
        if (params.getString("SaleGroupTo") != null) {
            queryStr.append(" and SALEGROUP.FNumber <= ? ");
            if (joinStr.toString().indexOf("T_BD_SaleGroup") == -1) {
                joinStr.append("\r\n INNER JOIN T_BD_SaleGroup AS SALEGROUP  ");
                joinStr.append(" ON OTHERBILL.FSaleGroupID = SALEGROUP.FID ");
            }
        }
        if (params.getObject("SalePersonFrom") != null) {
            if (params.getObject("SalePersonFrom") instanceof Object[]) {
                obj = (Object[])params.getObject("SalePersonFrom");
                if (obj.length == 1) {
                    queryStr.append(" and PERSON.FNumber >= ? ");
                } else {
                    queryStr.append(" and PERSON.FNumber in (?");
                    for (i = 1; i < obj.length; ++i) {
                        queryStr.append(",?");
                    }
                    queryStr.append(")");
                }
            } else {
                queryStr.append(" and PERSON.FNumber >= ? ");
            }
            if (joinStr.toString().indexOf("T_BD_Person") == -1) {
                joinStr.append("\r\n INNER JOIN T_BD_Person AS PERSON ");
                joinStr.append(" ON OTHERBILL.FPersonId = PERSON.FID ");
            }
        }
        if (params.getString("SalePersonTo") != null) {
            queryStr.append(" and PERSON.FNumber <= ? ");
            if (joinStr.toString().indexOf("T_BD_Person") == -1) {
                joinStr.append("\r\n INNER JOIN T_BD_Person AS PERSON ");
                joinStr.append(" ON OTHERBILL.FPersonId = PERSON.FID ");
            }
        }
        if (params.getString("DeptFrom") != null) {
            queryStr.append(" and Admins.FNumber >= ? ");
            if (joinStr.toString().indexOf("T_ORG_Admin") == -1) {
                joinStr.append("\r\n INNER JOIN T_ORG_Admin AS Admins ");
                joinStr.append(" ON OTHERBILL.FAdminOrgUnitID = Admins.FID ");
            }
        }
        if (params.getString("DeptTo") != null) {
            queryStr.append(" and Admins.FNumber <= ? ");
            if (joinStr.toString().indexOf("T_ORG_Admin") == -1) {
                joinStr.append("\r\n INNER JOIN T_ORG_Admin AS Admins ");
                joinStr.append(" ON OTHERBILL.FAdminOrgUnitID = Admins.FID ");
            }
        }
        return joinStr.append(queryStr).toString();
    }

    private RptTableHeader setTableHead(RptTableHeader header, RptParams params, Context ctx) {
        String bizDate = this.getServerResource("BillDate", ctx);
        String billNumber = this.getServerResource("BillNumber", ctx);
        String billType = this.getServerResource("BillType", ctx);
        String isBizBill = this.getServerResource("IsBizBill", ctx);
        String companyOrgUnitName = this.getServerResource("CompanyOrg", ctx);
        String saleOrgUnitName = this.getServerResource("SaleOrg", ctx);
        String saleGroupName = this.getServerResource("SaleGroup", ctx);
        String customerName = this.getServerResource("CustomerName", ctx);
        String customerNumber = this.getServerResource("CUSTOMERNUMBER", ctx);
        String personName = this.getServerResource("SalePerson", ctx);
        String materialNum = this.getServerResource("MaterialNum", ctx);
        String materialName = this.getServerResource("MaterialNam", ctx);
        String materialModel = this.getServerResource("MaterialMod", ctx);
        String storageName = this.getServerResource("StorageOrg", ctx);
        String unitName = this.getServerResource("Unit", ctx);
        String qty = this.getServerResource("Qty", ctx);
        String currencyName = this.getServerResource("Currency", ctx);
        String Price = this.getServerResource("OriginalPrice", ctx);
        String taxPrice = this.getServerResource("OriginalTaxPrice", ctx);
        String amount = this.getServerResource("OriginalAmount", ctx);
        String taxAmount = this.getServerResource("OriginalTax_Amount", ctx);
        String discountAmount = this.getServerResource("OriginalDiscountRate", ctx);
        String recievePayAmount = this.getServerResource("OriginalTaxAmount", ctx);
        String price_local = this.getServerResource("Price_Local", ctx);
        String taxPrice_local = this.getServerResource("TaxPrice_Local", ctx);
        String amount_local = this.getServerResource("Amount_Local", ctx);
        String taxAmount_local = this.getServerResource("Tax_Amount_Local", ctx);
        String discountAmount_local = this.getServerResource("DiscountAmount_Local", ctx);
        String recievePayAmount_local = this.getServerResource("RecievePayAmount_Local", ctx);
        String assistPropertyName = this.getServerResource("AssistPropertyName", ctx);
        boolean ckBxShowMShortName = params.getBoolean("ckBxShowMShortName");
        String materilShortName = this.getServerResource("MaterialShortName", ctx);
        int dynamicLength = 0;
        if (ckBxShowMShortName) {
            ++dynamicLength;
        }
        if (params.containsKey("isCkBxAssistProperty") && params.getBoolean("isCkBxAssistProperty")) {
            ++dynamicLength;
        }
        Object[][] labels = new Object[1][33 + dynamicLength];
        String[] cols = new String[33 + dynamicLength];
        int m = 13;
        cols[0] = "FNUMBER";
        cols[1] = "BIZDATE";
        cols[2] = "BILLTYPE";
        cols[3] = "ISBIZBILL";
        cols[4] = "COMPANY_ORGUNIT";
        cols[5] = "SALE_ORGUNIT";
        cols[6] = "SALEGROUP_NAME";
        cols[7] = "CUSTOMER_NAME";
        cols[8] = "CUSTOMER_NUMBER";
        cols[9] = "PERSON_NAME";
        cols[10] = "STORAGE_NAME";
        cols[11] = "MATERIAL_NUMBER";
        cols[12] = "MATERIAL_NAME";
        if (ckBxShowMShortName) {
            cols[m++] = "MATERIAL_SHORTNAME";
        }
        cols[m++] = "MATERIAL_MODEL";
        if (params.containsKey("isCkBxAssistProperty") && params.getBoolean("isCkBxAssistProperty")) {
            cols[m++] = "FAssistName";
        }
        cols[m++] = "UNIT_NAME";
        cols[m++] = "QTY";
        cols[m++] = "CURRENCY";
        cols[m++] = "PRICE";
        cols[m++] = "TAXPRICE";
        cols[m++] = "AMOUNT";
        cols[m++] = "TAXAMOUNT";
        cols[m++] = "DISCOUNTAMOUNT";
        cols[m++] = "RECIEVEPAYAMOUNT";
        cols[m++] = "PRICE_LOCAL";
        cols[m++] = "TAXPRICE_LOCAL";
        cols[m++] = "AMOUNT_LOCAL";
        cols[m++] = "TAXAMOUNT_LOCAL";
        cols[m++] = "DISCOUNTAMOUNT_LOCAL";
        cols[m++] = "RECIEVEPAYAMOUNT_LOCAL";
        cols[m++] = "TOTALFLAG";
        cols[m++] = "PRICEPRECISION";
        cols[m++] = "FID";
        cols[m++] = "FBILLID";
        m = 13;
        this.setHeaderColumns(header, cols, params);
        labels[0][0] = billNumber;
        labels[0][1] = bizDate;
        labels[0][2] = billType;
        labels[0][3] = isBizBill;
        labels[0][4] = companyOrgUnitName;
        labels[0][5] = saleOrgUnitName;
        labels[0][6] = saleGroupName;
        labels[0][7] = customerName;
        labels[0][8] = customerNumber;
        labels[0][9] = personName;
        labels[0][10] = storageName;
        labels[0][11] = materialNum;
        labels[0][12] = materialName;
        if (ckBxShowMShortName) {
            labels[0][m++] = materilShortName;
        }
        labels[0][m++] = materialModel;
        if (params.containsKey("isCkBxAssistProperty") && params.getBoolean("isCkBxAssistProperty")) {
            labels[0][m++] = assistPropertyName;
        }
        labels[0][m++] = unitName;
        labels[0][m++] = qty;
        labels[0][m++] = currencyName;
        labels[0][m++] = Price;
        labels[0][m++] = taxPrice;
        labels[0][m++] = amount;
        labels[0][m++] = taxAmount;
        labels[0][m++] = discountAmount;
        labels[0][m++] = recievePayAmount;
        labels[0][m++] = price_local;
        labels[0][m++] = taxPrice_local;
        labels[0][m++] = amount_local;
        labels[0][m++] = taxAmount_local;
        labels[0][m++] = discountAmount_local;
        labels[0][m++] = recievePayAmount_local;
        labels[0][m++] = "TotalFlag";
        labels[0][m++] = "PricePrecision";
        labels[0][m++] = "FID";
        header.setLabels(labels, true);
        return header;
    }

    private void setHeaderColumns(RptTableHeader header, String[] columns, RptParams params) {
        String qtyFormat = SaleUtil.getFormatPattern(4, true);
        String dateFormat = RptCellFormatter.getDateFormat((String)"yyyy-MM-dd");
        RptTableColumn col = null;
        int dynamicLength = 33 - columns.length;
        for (int i = 0; i < columns.length; ++i) {
            col = new RptTableColumn(columns[i]);
            if (i == 1) {
                col.setFormatPattern(dateFormat);
            }
            if (i > 16 - dynamicLength && i < 29 - dynamicLength) {
                col.setWidth(-1);
                col.setWidth(120);
                col.setAligment(2);
                col.setFormatPattern(qtyFormat);
            }
            if (i == 32 - dynamicLength || i == 31 - dynamicLength || i == 30 - dynamicLength) {
                col.setWidth(-1);
                col.setHided(true);
            }
            header.addColumn(col);
        }
    }

    protected String getOrgListId(Object[] infos) {
        StringBuffer OrgunitId = new StringBuffer();
        int n = infos.length;
        for (int i = 0; i < n; ++i) {
            Boolean isleaf = (Boolean)((FullOrgUnitInfo)infos[i]).get("isleaf");
            boolean fisleaf = isleaf != false;
            if (!fisleaf) continue;
            OrgunitId.append(",'");
            OrgunitId.append(((FullOrgUnitInfo)infos[i]).getId().toString());
            OrgunitId.append("'");
        }
        if (OrgunitId.length() <= 0) {
            return "'xxx_xxx'";
        }
        String orgunitListId = OrgunitId.toString().substring(1, OrgunitId.toString().length());
        return orgunitListId;
    }

    private String getCalSQL(RptParams params, StringBuffer companyOrgNumbers) {
        StringBuffer sql = new StringBuffer();
        int periodYear = new Integer(params.getString("periodYear"));
        int periodYearTo = new Integer(params.getString("periodYearTo"));
        int periodMonth = new Integer(params.getString("periodMonth"));
        int periodMonthTo = new Integer(params.getString("periodMonthTo"));
        sql.append("\r\n inner join");
        sql.append("\r\n (select clw.fbillentryid from T_CL_WriteOffRecord clw");
        sql.append("\r\n inner join T_ORG_Company company on company.fid = clw.FCompanyOrgUnitId");
        sql.append("\r\n where clw.fbilltypenumber = '330'");
        sql.append("\r\n and (clw.fwriteoffyear * 100 + fwriteoffperiod) >= (" + periodYear + " * 100 + " + periodMonth + ")");
        sql.append("\r\n and (clw.fwriteoffyear * 100 + fwriteoffperiod) <= (" + periodYearTo + " * 100 + " + periodMonthTo + ")");
        if (companyOrgNumbers != null && companyOrgNumbers.length() > 0) {
            sql.append("\r\n and company.fnumber in (" + companyOrgNumbers + ")");
        }
        sql.append("\r\n group by clw.fbillentryid");
        sql.append("\r\n )wf on wf.fbillentryid = ENTRY.FID");
        return sql.toString();
    }

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        String local_lan = ctx.getLocale().getLanguage();
        StringBuffer sqlbf = new StringBuffer(500);
        boolean ckBxShowMShortName = params.getBoolean("ckBxShowMShortName");
        String shortNameFrom = (String)params.getObject("shortNameFrom");
        String shortNameTo = (String)params.getObject("shortNameTo");
        String tempTable = params.getString("TempTableName");
        sqlbf.append(" select TEMP.FNUMBER BILLNUMBER,TEMP.FBIZDATE BIZDATE");
        sqlbf.append(" \r\n ,TEMP.FBillType BILLTYPE");
        sqlbf.append("   ,TEMP.FIsBizBill ISBIZBILL");
        sqlbf.append(" \r\n ,COMPANYORGUNIT.FNAME_" + local_lan + " COMPANYORGNAME");
        sqlbf.append(" \r\n ,org.FNAME_");
        sqlbf.append(local_lan + " ORGNAME \r\n ,SaleGroup.FNAME_");
        sqlbf.append(local_lan + " SALEGROUPNAME \r\n ,Customer.FNAME_");
        sqlbf.append(local_lan + " CUSTOMERNAME, Customer.FNumber CUSTOMERNUMBER \r\n ,Person.FNAME_");
        sqlbf.append(local_lan + " PERSONNAME");
        sqlbf.append(" \r\n ,Storage.FNAME_");
        sqlbf.append(local_lan);
        sqlbf.append("  STORAGENAME");
        sqlbf.append(", CASE WHEN MAT.FNUMBER IS NULL THEN EXPITEM.FNUMBER ELSE MAT.FNUMBER END AS MATNUMBER, CASE WHEN MAT.FNAME_");
        sqlbf.append(local_lan + " IS NULL THEN EXPITEM.FNAME_" + local_lan + " ELSE  MAT.FNAME_" + local_lan + " END AS MATNAME,");
        sqlbf.append(ckBxShowMShortName ? "MAT.FSHORTNAME MATSHORTNAME," : "");
        sqlbf.append("MAT.FMODEL MATMODEL");
        if (params.containsKey("isCkBxAssistProperty") && params.getBoolean("isCkBxAssistProperty")) {
            sqlbf.append(" \r\n ,assist.FNAME_" + local_lan + " FAssistName ");
        }
        sqlbf.append(" \r\n ,Unit.FNAME_" + local_lan + " UNITNAME");
        sqlbf.append(" \r\n ,Temp.FQty QTY");
        sqlbf.append(" \r\n ,Currency.FName_" + local_lan);
        sqlbf.append(" CURRENCYNAME \r\n ,TEMP.FRealPrice REALPRICE");
        sqlbf.append(" \r\n ,TEMP.FTaxPrice TAXPRICE");
        sqlbf.append(" \r\n ,TEMP.FAmount AMOUNNT");
        sqlbf.append(" \r\n ,TEMP.FTaxAmount TAXAMOUNT");
        sqlbf.append(" \r\n ,TEMP.FDiscountAmount DISCOUNTAMOUNT");
        sqlbf.append(" \r\n ,TEMP.FRecievePayAmount RECIEVEPAYAMOUNT");
        sqlbf.append(" \r\n ,TEMP.FRealPriceLocal REALPRICELOCAL");
        sqlbf.append(" \r\n ,TEMP.FRealTaxPriceLocal REALTAXPRICELOCAL");
        sqlbf.append(" \r\n ,TEMP.FAmountLocal AMOUNTLOCAL");
        sqlbf.append(" \r\n ,TEMP.FTaxAmountLocal TAXAMOUNTLOCAL");
        sqlbf.append(" \r\n ,TEMP.FDiscountAmountLocal DICOUNTAMOUNTLOCAL");
        sqlbf.append(" \r\n ,TEMP.FRecievePayAmountLocal RECIEVEPAYAMOUNTLOCAL");
        sqlbf.append(" \r\n ,TEMP.FTotalFlag TOTALFLAG");
        sqlbf.append(" \r\n ,MAT.FPricePrecision PRICEPRECISION");
        sqlbf.append(" \r\n ,TEMP.FID FID");
        sqlbf.append(" \r\n ,TEMP.FBILLID FBILLID");
        sqlbf.append(" \r\n FROM  " + tempTable + " AS TEMP ");
        sqlbf.append(" \r\n LEFT OUTER JOIN T_BD_MATERIAL MAT ");
        sqlbf.append(" ON TEMP.FMATERIALID = MAT.FID ");
        sqlbf.append(" \r\n LEFT OUTER JOIN T_ORG_Company AS COMPANYORGUNIT");
        sqlbf.append(" ON TEMP.FCompanyOrgUnitID = COMPANYORGUNIT.FID ");
        sqlbf.append(" \r\n LEFT OUTER JOIN T_ORG_Sale AS org ");
        sqlbf.append(" ON TEMP.FSaleOrgUnitID = org.FID ");
        sqlbf.append(" \r\n LEFT OUTER JOIN T_ORG_Storage AS storage ");
        sqlbf.append(" ON TEMP.FStorageOrgUnitID = storage.FID ");
        sqlbf.append(" \r\n LEFT OUTER JOIN T_BD_Customer AS CUSTOMER");
        sqlbf.append(" ON TEMP.FCustomerID = CUSTOMER.FID ");
        sqlbf.append(" \r\n LEFT OUTER JOIN T_BD_SaleGroup AS SaleGroup");
        sqlbf.append(" ON TEMP.FSaleGroupID = SaleGroup.FID ");
        sqlbf.append(" \r\n LEFT OUTER JOIN T_BD_Person AS PERSON");
        sqlbf.append(" ON TEMP.FPersonId = PERSON.FID ");
        sqlbf.append(" \r\n LEFT OUTER JOIN T_BD_Currency AS CURRENCY");
        sqlbf.append(" ON TEMP.FCurrencyID = CURRENCY.FID ");
        if (params.containsKey("isCkBxAssistProperty") && params.getBoolean("isCkBxAssistProperty")) {
            sqlbf.append(" \r\n  LEFT OUTER JOIN  T_BD_ASSTATTRVALUE  assist ON assist.FID = TEMP.FAssistID");
        }
        sqlbf.append(" \r\n LEFT OUTER JOIN T_BD_MeasureUnit AS UNIT");
        sqlbf.append(" ON TEMP.FUnitID = UNIT.FID ");
        sqlbf.append(" \r\n LEFT OUTER JOIN T_SCM_ExpenseItem AS EXPITEM");
        sqlbf.append(" ON TEMP.FMATERIALID = EXPITEM.FID ");
        int start = from + 1;
        int end = from + len;
        if (sqlbf.toString().indexOf("where") == -1) {
            sqlbf.append("\r\n where ");
            sqlbf.append(" TEMP.KSQL_SEQ >= ").append(start).append(" and TEMP.KSQL_SEQ <=").append(end);
        } else {
            sqlbf.append(" and TEMP.KSQL_SEQ >= ").append(start).append(" and TEMP.KSQL_SEQ <=").append(end);
        }
        sqlbf.append(" Order by TEMP.KSQL_SEQ ASC");
        RptRowSet rs = this.executeQuery(sqlbf.toString(), null, ctx);
        RptParams pp = new RptParams();
        pp.setObject("rowset", (Object)rs);
        return pp;
    }

    private void executeSQL(Context ctx, String sql) throws BOSException {
        if (sql != null && sql.trim().length() > 0) {
            this.executeUpdate(sql, null, ctx);
        }
    }

    public String getServerResource(String key, Context ctx) {
        return SCMUtils.getResource((String)resClassName, (String)key, (Context)ctx);
    }
}

