/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptCellFormatter;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sd.sale.report.app.AbstractSaleOrderTrackRptFacadeControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Vector;

public class SaleOrderTrackRptFacadeControllerBean
extends AbstractSaleOrderTrackRptFacadeControllerBean {
    private String orgUnitTempTableStr = "OrgTempTable";
    private String leafPurChaseOrgUnitStr = "leafPurChaseOrgUnit";
    private String maxLevelStr = "maxLevelStr";
    boolean isReceivale = true;
    private String locLan = "l2";
    private static final String resClassName = "com.kingdee.eas.scm.sd.sale.report.SDReportResource";

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        this.dropTable(params.getString("tempTable"), ctx);
        this.dropTable(params.getString("OrgTempTable"), ctx);
        this.locLan = this.getLoc(ctx);
        String tempTable = this.getTempTableName(this.getServerResource("RPTTempTable", ctx), ctx);
        String orgUnitTempTable = this.getTempTableName(this.getServerResource("ORGUintTempTable", ctx), ctx);
        if (params.getBoolean("IsOutWarehs")) {
            this.isReceivale = false;
        }
        params.setString("tempTable", tempTable);
        params.setString("OrgTempTable", orgUnitTempTable);
        this.buildStorageOrgTable(ctx, orgUnitTempTable, params);
        Connection conn = null;
        DBUtil.createTempTableIndex((Context)ctx, (String)orgUnitTempTable, (String)"fid", (boolean)false);
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            DBUtil.AnalyseTable((Context)ctx, (Connection)conn, (String)orgUnitTempTable);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        this.createTempTableAndInsertData(ctx, tempTable, params);
        if (params.getString("isTotal").equals("true")) {
            StringBuffer sql = new StringBuffer();
            sql.setLength(0);
            sql.append(this.getRptSumSql(params, tempTable, ctx));
            this.executeUpdate(sql.toString(), null, ctx);
        }
        DBUtil.createTempTableIndex((Context)ctx, (String)tempTable, (String)"fid", (boolean)false);
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            DBUtil.AnalyseTable((Context)ctx, (Connection)conn, (String)tempTable);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        String countSql = "select count(1) cc from (" + this.querySql(params, ctx) + ") a ";
        RptRowSet rs = this.executeQuery(countSql, null, ctx);
        rs.next();
        int count = rs.getInt(0);
        RptTableHeader header = new RptTableHeader();
        this.setSaleOrderRptHead(header, params, ctx);
        RptParams result = new RptParams();
        result.setString("tempTable", tempTable);
        result.setObject("header", (Object)header);
        result.setInt("verticalCount", count);
        result.setString(this.orgUnitTempTableStr, orgUnitTempTable);
        return result;
    }

    private String getRptSumSql(RptParams params, String tableName, Context ctx) throws BOSException, EASBizException {
        StringBuffer groupSQL = new StringBuffer();
        groupSQL.append("INSERT INTO " + tableName);
        groupSQL.append(" \r\n (FID,FsaleOrderNumber,FBaseStatus,FMaterialID");
        groupSQL.append(" \r\n ,FQty,FTaxAmount,FTotalReceiveQty,FTotalQtyAmount,FNonWarehsQty,FNonAMount");
        groupSQL.append(",FTotalFlag)");
        groupSQL.append(" \r\n SELECT ");
        groupSQL.append(" \r\n newbosid('88888888'), '  '");
        groupSQL.append(" \r\n ,isnull(MAX(FBaseStatus),4)");
        groupSQL.append(" \r\n ,isnull(MAX(FMaterialID),'xxxx')");
        groupSQL.append(" \r\n ,TO_DECIMAL(isnull(SUM(FQty),0),31,7)");
        groupSQL.append(" \r\n ,TO_DECIMAL(isnull(SUM(FTaxAmount),0),31,7)");
        groupSQL.append(" \r\n ,TO_DECIMAL(isnull(SUM(FTotalReceiveQty),0),31,7)");
        groupSQL.append(" \r\n ,TO_DECIMAL(isnull(SUM(FTotalQtyAmount),0),31,7)");
        groupSQL.append(" \r\n ,TO_DECIMAL(isnull(SUM(FNonWarehsQty),0),31,7)");
        groupSQL.append(" \r\n ,TO_DECIMAL(isnull(SUM(FNonAMount),0),31,7)");
        groupSQL.append(" \r\n ,'TotalAll'");
        groupSQL.append(" \r\n  from ").append(tableName).append(" where FNonWarehsQty > 0");
        return groupSQL.toString();
    }

    private void buildStorageOrgTable(Context ctx, String orgTempTable, RptParams params) throws BOSException {
        StringBuffer sqlbf = new StringBuffer();
        sqlbf.append("create table " + orgTempTable + " (");
        sqlbf.append("fid varchar(44),");
        sqlbf.append("fname_");
        sqlbf.append(this.locLan);
        sqlbf.append(" varchar(100),");
        sqlbf.append("fparentid varchar(44),");
        sqlbf.append("flevel int,");
        sqlbf.append("fisleaf int");
        sqlbf.append(")");
        this.executeSQL(ctx, sqlbf.toString());
        Vector<String> v = new Vector<String>();
        int maxLevel = 0;
        Object[] purChaseOrg = (Object[])params.getObject("fullOrgUnit");
        String[] sql = new String[purChaseOrg.length];
        int n = purChaseOrg.length;
        for (int i = 0; i < n; ++i) {
            sqlbf.delete(0, sqlbf.length());
            String fid = ((FullOrgUnitInfo)purChaseOrg[i]).get("id").toString();
            Integer flevel = (Integer)((FullOrgUnitInfo)purChaseOrg[i]).get("level");
            String fname = (String)((FullOrgUnitInfo)purChaseOrg[i]).get("name");
            FullOrgUnitInfo parent = (FullOrgUnitInfo)((FullOrgUnitInfo)purChaseOrg[i]).get("parent");
            Boolean isleaf = (Boolean)((FullOrgUnitInfo)purChaseOrg[i]).get("isleaf");
            int fisleaf = isleaf != false ? 1 : 0;
            if (fisleaf == 1) {
                v.add(fid);
            }
            if (flevel > maxLevel) {
                maxLevel = flevel;
            }
            sqlbf.append("insert into " + orgTempTable + "(");
            sqlbf.append("fid,fname_");
            sqlbf.append(this.locLan);
            sqlbf.append(",fparentid,flevel,fisleaf) ");
            sqlbf.append("values(");
            sqlbf.append("'" + fid + "',");
            if (fname != null) {
                sqlbf.append("'" + fname + "',");
            } else {
                sqlbf.append("null,");
            }
            if (parent != null) {
                sqlbf.append("'" + parent.getId().toString() + "',");
            } else {
                sqlbf.append("null,");
            }
            sqlbf.append(flevel + ",");
            sqlbf.append(fisleaf + ") ");
            sql[i] = sqlbf.toString();
        }
        this.executeBatchUpdate(ctx, sql);
        params.setObject(this.leafPurChaseOrgUnitStr, (Object)v.toArray());
        params.setObject(this.maxLevelStr, (Object)new Integer(maxLevel));
    }

    private void createTempTableAndInsertData(Context ctx, String tempTable, RptParams params) throws BOSException, EASBizException {
        String sql = this.getCreateTempTable(tempTable, params);
        this.executeSQL(ctx, sql);
        SqlParams sqlParams = new SqlParams();
        this.setRPTData(sqlParams, params);
        sql = this.getSaleOrderRptSql(params, tempTable, ctx);
        this.executeUpdate(sql, sqlParams, ctx);
        sql = "delete from " + tempTable + " where FNonWarehsQty <= 0";
        this.executeBatchUpdate(ctx, new String[]{sql});
    }

    private String getCreateTempTable(String tempTable, RptParams params) {
        StringBuffer sql = new StringBuffer(300);
        sql.append("Create Table " + tempTable + "(\r\n");
        sql.append("FID Varchar(44) \r\n");
        sql.append(",FsaleOrderNumber Varchar(80) \r\n");
        sql.append(",FDeliveryDate DateTime \r\n");
        sql.append(",FBaseStatus int \r\n");
        sql.append(",FBIZTYPEID Varchar(44)\r\n");
        sql.append(",FCustomerID Varchar(44)\r\n");
        sql.append(",FSaleOrgUnitID Varchar(44)\r\n");
        sql.append(",FMaterialID Varchar(44)\r\n");
        sql.append(",FUnitID Varchar(44)\r\n");
        sql.append(",FQty  Decimal(28,10)\r\n");
        sql.append(",FTaxAmount  Decimal(28,4)\r\n");
        sql.append(",FTotalReceiveQty  Decimal(28,4)\r\n");
        sql.append(",FTotalQtyAmount  Decimal(28,4)\r\n");
        sql.append(",FNonWarehsQty  Decimal(28,10)\r\n");
        sql.append(",FNonAMount  Decimal(28,4)\r\n");
        sql.append(",FTotalFlag Varchar(44)\r\n");
        sql.append(",FCurrencyID Varchar(44)\r\n");
        sql.append(");\r\n");
        return sql.toString();
    }

    private void setRPTData(SqlParams sqlParams, RptParams params) {
        int i;
        int count = sqlParams.size() + 1;
        if (params.getObject("CustomerFrom") != null) {
            if (params.getObject("CustomerFrom") instanceof Object[]) {
                Object[] customers = (Object[])params.getObject("CustomerFrom");
                for (i = 0; i < customers.length; ++i) {
                    sqlParams.setString(count++, (String)customers[i]);
                }
            } else if (params.getObject("CustomerFrom") instanceof CustomerInfo) {
                sqlParams.setString(count++, ((CustomerInfo)params.getObject("CustomerFrom")).getNumber());
            } else {
                sqlParams.setString(count++, params.getObject("CustomerFrom").toString());
            }
        }
        if (params.getString("CustomerTo") != null) {
            sqlParams.setString(count++, params.getString("CustomerTo"));
        }
        if (params.getObject("materialFrom") != null) {
            if (params.getObject("materialFrom") instanceof Object[]) {
                Object[] materials = (Object[])params.getObject("materialFrom");
                for (i = 0; i < materials.length; ++i) {
                    sqlParams.setString(count++, (String)materials[i]);
                }
            } else {
                sqlParams.setString(count++, params.getObject("materialFrom").toString());
            }
        }
        if (params.getString("materialTo") != null) {
            sqlParams.setString(count++, params.getString("materialTo"));
        }
        if (params.getString("BiztypeFrom") != null) {
            sqlParams.setString(count++, params.getString("BiztypeFrom"));
        }
        if (params.getString("BiztypeTo") != null) {
            sqlParams.setString(count++, params.getString("BiztypeTo"));
        }
        if (params.getBoolean("ckBxShowMShortName")) {
            String txtMShortNameFrom = (String)params.getObject("shortNameFrom");
            String txtMShortNameTo = (String)params.getObject("shortNameTo");
            if (txtMShortNameFrom != null && txtMShortNameFrom.trim().length() > 0) {
                if (txtMShortNameFrom.indexOf("'") != -1) {
                    txtMShortNameFrom = txtMShortNameFrom.replaceAll("'", "''");
                }
                sqlParams.setString(count++, txtMShortNameFrom.trim());
            }
            if (txtMShortNameTo != null && txtMShortNameTo.trim().length() > 0) {
                if (txtMShortNameTo.indexOf("'") != -1) {
                    txtMShortNameTo = txtMShortNameTo.replaceAll("'", "''");
                }
                sqlParams.setString(count++, txtMShortNameTo.trim());
            }
        }
    }

    private String getSaleOrderRptSql(RptParams params, String tableName, Context ctx) throws BOSException, EASBizException {
        String sql = "";
        StringBuffer saleOrderBuffer = new StringBuffer();
        String selectStr = "insert into " + tableName + " SELECT newbosid('88888888'),SALEORDER.FNumber,entries.FDeliveryDate \r\n ,SALEORDER.FBaseStatus,SALEORDER.FBizTypeID,SALEORDER.FOrderCustomerID,ORG.FID \r\n ,ENTRIES.FMaterialID,ENTRIES.FUnitID\r\n ,TO_DECIMAL(ENTRIES.FQty,31,7)\r\n ,TO_DECIMAL(ENTRIES.FLocalTaxAmount,17,4)\r\n ,case when DataFrom.FtotalSaleQty is null then 0 else TO_DECIMAL(DataFrom.FtotalSaleQty,31,7) end";
        selectStr = selectStr + "\r\n ,case when DataFrom.FtotalSaleQty is null OR ENTRIES.FQty = 0 then 0 \r\n else TO_DECIMAL(ENTRIES.FLocalTaxAmount*DataFrom.FtotalSaleQty/ENTRIES.FQty,17,4)end ";
        selectStr = selectStr + "\r\n ,case when DataFrom.FtotalSaleQty is null then TO_DECIMAL(ENTRIES.FQty,17,4) \r\n else TO_DECIMAL(ENTRIES.FQty -  DataFrom.FtotalSaleQty ,17,4) end\r\n ,case when ENTRIES.FQty=0 then 0 when DataFrom.FtotalSaleQty is null and ENTRIES.FQty!=0 then TO_DECIMAL(ENTRIES.FLocalTaxAmount, 17, 4) \r\n else TO_DECIMAL(ENTRIES.FLocalTaxAmount*(ENTRIES.FQty-ISNULL(DataFrom.FtotalSaleQty,0))/ENTRIES.FQty,17,4)end \r\n ,'AAA'\r\n ,SALEORDER.FCurrencyID";
        saleOrderBuffer.append(selectStr);
        saleOrderBuffer.append("\r\n FROM T_SD_SaleOrder AS SALEORDER");
        saleOrderBuffer.append("\r\n  INNER JOIN T_SD_SaleOrderentry AS ENTRIES");
        saleOrderBuffer.append(" ON SALEORDER.FID = ENTRIES.FParentID");
        saleOrderBuffer.append("\r\n  INNER JOIN ");
        saleOrderBuffer.append(params.getString("OrgTempTable"));
        saleOrderBuffer.append(" ORG");
        saleOrderBuffer.append("  ON SALEORDER.FSaleOrgUnitID = ORG.FID");
        if (this.isReceivale) {
            saleOrderBuffer.append(this.getQueryFromPostRequisition(params));
        } else {
            saleOrderBuffer.append(this.getQueryFromSaleIssue(params));
        }
        String saleOrderStr = this.getQueryStr(params, "saleOrder", saleOrderBuffer, ctx);
        sql = saleOrderBuffer + saleOrderStr;
        return sql;
    }

    private String getQueryFromPostRequisition(RptParams params) throws EASBizException, BOSException {
        StringBuffer tatolFromReceivale = new StringBuffer();
        tatolFromReceivale.append("\r\n left outer join (");
        tatolFromReceivale.append("\r\n  select PostRequisition.FsaleOrderID FsaleOrderID");
        tatolFromReceivale.append(",PostRequisition.FsaleOrderEntrySeq FsaleOrderEntrySeq");
        tatolFromReceivale.append("\r\n  ,sum(case when o.funitid = PostRequisition.funitid then ");
        tatolFromReceivale.append("\r\n PostRequisition.FQty else PostRequisition.fbaseqty/FBaseConvsRate end ");
        tatolFromReceivale.append("\r\n ) FtotalSaleQty ");
        tatolFromReceivale.append("\r\n from T_SD_PostRequisition xx ");
        tatolFromReceivale.append("\r\n inner join T_SD_PostRequisitionEntry PostRequisition on xx.FID = PostRequisition.FParentID ");
        tatolFromReceivale.append("\r\n inner join T_SD_SaleOrderentry o on o.fparentid=PostRequisition.fsaleorderid ");
        tatolFromReceivale.append(" and PostRequisition.FsaleOrderEntrySeq=o.fseq");
        tatolFromReceivale.append("\r\n left outer join T_BD_MultiMeasureUnit unit ");
        tatolFromReceivale.append("\r\n on PostRequisition.FMaterialID = unit.FmaterialID and o.funitid=unit.FMeasureUnitID");
        tatolFromReceivale.append("\r\n where (xx.Fbasestatus =4 or xx.Fbasestatus =2 or xx.Fbasestatus =1 or xx.Fbasestatus =6 or xx.Fbasestatus =7) ");
        tatolFromReceivale.append("\r\n group by PostRequisition.FsaleOrderID,PostRequisition.FSaleOrderEntrySeq ");
        tatolFromReceivale.append("\r\n )  DataFrom on SALEORDER.FID = DataFrom.FsaleOrderID and ENTRIES.FSeq= DataFrom.FSaleOrderEntrySeq");
        return tatolFromReceivale.toString();
    }

    private String getQueryFromSaleIssue(RptParams params) throws EASBizException, BOSException {
        StringBuffer tatolFromSaleIssue = new StringBuffer(800);
        tatolFromSaleIssue.append("\r\n left outer join (");
        tatolFromSaleIssue.append("\r\n  select SaleIssue.FsaleOrderID FsaleOrderID");
        tatolFromSaleIssue.append(",SaleIssue.FsaleOrderEntrySeq FsaleOrderEntrySeq");
        tatolFromSaleIssue.append("\r\n  ,sum(case when o.funitid = SaleIssue.funitid then ");
        tatolFromSaleIssue.append("\r\n SaleIssue.FQty else SaleIssue.fbaseqty/FBaseConvsRate end ");
        tatolFromSaleIssue.append("\r\n ) FtotalSaleQty ");
        tatolFromSaleIssue.append("\r\n from T_IM_SaleIssueBill xx ");
        tatolFromSaleIssue.append("\r\n inner join T_IM_SaleIssueEntry SaleIssue on xx.FID = SaleIssue.FParentID ");
        tatolFromSaleIssue.append("\r\n inner join T_SD_SaleOrderentry o on o.fparentid=SaleIssue.fsaleorderid ");
        tatolFromSaleIssue.append(" and SaleIssue.FsaleOrderEntrySeq=o.fseq and o.FSaleOrgUnitID=SaleIssue.Fsaleorgunitid ");
        tatolFromSaleIssue.append("\r\n left outer join T_BD_MultiMeasureUnit unit ");
        tatolFromSaleIssue.append("\r\n on SaleIssue.FMaterialID = unit.FmaterialID and o.funitid=unit.FMeasureUnitID");
        tatolFromSaleIssue.append("\r\n where (xx.Fbasestatus =4 or xx.Fbasestatus =2 or xx.Fbasestatus =1 ) ");
        tatolFromSaleIssue.append("\r\n group by SaleIssue.FsaleOrderID,SaleIssue.FSaleOrderEntrySeq ");
        tatolFromSaleIssue.append("\r\n )  DataFrom on SALEORDER.FID = DataFrom.FsaleOrderID and ENTRIES.FSeq= DataFrom.FSaleOrderEntrySeq");
        return tatolFromSaleIssue.toString();
    }

    private String getQueryStr(RptParams params, String purName, StringBuffer purBuffer, Context ctx) throws EASBizException, BOSException {
        int i;
        StringBuffer queryStr = new StringBuffer();
        String bd = null;
        String ed = null;
        bd = params.getString("dateStart");
        ed = params.getString("dateEnd");
        queryStr.append("\r\n where ");
        queryStr.append(" (SALEORDER.Fbasestatus =4 or SALEORDER.Fbasestatus =6) and ").append("ENTRIES.Fbasestatus <> 7 and ").append("ENTRIES.FDeliveryDate  >= {" + bd + "} and ENTRIES.FDeliveryDate <= {" + ed + "}");
        if (params.getObject("CustomerFrom") != null) {
            if (params.getObject("CustomerFrom") instanceof Object[]) {
                Object[] customers = (Object[])params.getObject("CustomerFrom");
                if (customers.length == 1) {
                    queryStr.append(" and Customer.FNumber >= ? ");
                } else {
                    queryStr.append(" and Customer.FNumber in (?");
                    for (i = 1; i < customers.length; ++i) {
                        queryStr.append(",?");
                    }
                    queryStr.append(")");
                }
            } else {
                queryStr.append(" and Customer.FNumber >= ? ");
            }
            if (purBuffer.toString().indexOf("T_BD_Customer") == -1) {
                purBuffer.append("\r\n INNER join T_BD_Customer Customer ");
                purBuffer.append(" on Customer.fid = SALEORDER.FOrderCustomerID ");
            }
        }
        if (params.getString("CustomerTo") != null) {
            queryStr.append(" and Customer.FNumber <= ? ");
            if (purBuffer.toString().indexOf("T_BD_Customer") == -1) {
                purBuffer.append("\r\n inner join T_BD_Customer Customer ");
                purBuffer.append(" on Customer.fid = SALEORDER.FOrderCustomerID ");
            }
        }
        if (params.getObject("materialFrom") != null) {
            if (params.getObject("materialFrom") instanceof Object[]) {
                Object[] materials = (Object[])params.getObject("materialFrom");
                if (materials.length == 1) {
                    queryStr.append(" and material.FNumber >= ? ");
                } else {
                    queryStr.append(" and material.FNumber in (?");
                    for (i = 1; i < materials.length; ++i) {
                        queryStr.append(",?");
                    }
                    queryStr.append(")");
                }
            } else {
                queryStr.append(" and material.FNumber >= ? ");
            }
            if (purBuffer.toString().indexOf("T_BD_Material") == -1) {
                purBuffer.append("\r\n inner join T_BD_Material material ");
                purBuffer.append(" on material.fid = ENTRIES.FMaterialID ");
            }
        }
        if (params.getString("materialTo") != null) {
            queryStr.append(" and material.FNumber <= ? ");
            if (purBuffer.toString().indexOf("T_BD_Material") == -1) {
                purBuffer.append("\r\n inner join T_BD_Material material ");
                purBuffer.append(" on material.fid = ENTRIES.FMaterialID ");
            }
        }
        if (params.getString("BiztypeFrom") != null) {
            queryStr.append(" and BIZTYPE.FNumber >= ? ");
            if (purBuffer.toString().indexOf("T_SCM_BizType") == -1) {
                purBuffer.append("\r\n LEFT OUTER JOIN T_SCM_BizType AS BIZTYPE ");
                purBuffer.append(" ON SALEORDER.FBizTypeID = BIZTYPE.FID ");
            }
        }
        if (params.getString("BiztypeTo") != null) {
            queryStr.append(" and BIZTYPE.FNumber <= ? ");
            if (purBuffer.toString().indexOf("T_SCM_BizType") == -1) {
                purBuffer.append("\r\n LEFT OUTER JOIN T_SCM_BizType AS BIZTYPE ");
                purBuffer.append(" ON SALEORDER.FBizTypeID = BIZTYPE.FID ");
            }
        }
        if (params.getBoolean("ckBxShowMShortName")) {
            String txtMShortNameFrom = (String)params.getObject("shortNameFrom");
            String txtMShortNameTo = (String)params.getObject("shortNameTo");
            if (txtMShortNameFrom != null && txtMShortNameFrom.trim().length() > 0) {
                queryStr.append(" and material.FShortName >= ? ");
                if (purBuffer.toString().indexOf("T_BD_Material") == -1) {
                    purBuffer.append("\r\n inner join T_BD_Material material ");
                    purBuffer.append(" on material.fid = ENTRIES.FMaterialID ");
                }
            }
            if (txtMShortNameTo != null && txtMShortNameTo.trim().length() > 0) {
                queryStr.append(" and material.FShortName <= ? ");
                if (purBuffer.toString().indexOf("T_BD_Material") == -1) {
                    purBuffer.append("\r\n inner join T_BD_Material material ");
                    purBuffer.append(" on material.fid = ENTRIES.FMaterialID ");
                }
            }
        }
        return queryStr.toString();
    }

    private RptTableHeader setSaleOrderRptHead(RptTableHeader header, RptParams params, Context ctx) {
        String billNum = this.getServerResource("BillNumber", ctx);
        String deliverydate = this.getServerResource("FDeliveryDate", ctx);
        String billStatus = this.getServerResource("BillStatus", ctx);
        String bizType = this.getServerResource("BizType", ctx);
        String customerName = this.getServerResource("CustomerName", ctx);
        String customerNumber = this.getServerResource("CUSTOMERNUMBER", ctx);
        String SaleOrgName = this.getServerResource("SaleOrg", ctx);
        String materialNum = this.getServerResource("MaterialNum", ctx);
        String materialName = this.getServerResource("MaterialNam", ctx);
        String materialModel = this.getServerResource("MaterialMod", ctx);
        String baseUnit = this.getServerResource("Unit", ctx);
        String quatity = this.getServerResource("Qty", ctx);
        String totalShipQty = this.getServerResource("TotalShippingQty", ctx);
        String totalPostRequisitionQty = this.getServerResource("TotalPostRequisitionQty", ctx);
        String totalUnShipQty = this.getServerResource("totalUnShipQty", ctx);
        String shortName = this.getServerResource("MaterialShortName", ctx);
        String AmountT = this.getServerResource("AmountT", ctx);
        String TotalAmout = this.getServerResource("TotalAmout", ctx);
        String NonAmount = this.getServerResource("NonAmount", ctx);
        String TotalNoticeAmount = this.getServerResource("TotalNoticeAmount", ctx);
        Object[][] labels = new Object[1][22];
        String[] cols = new String[22];
        if (params.getBoolean("ckBxShowMShortName")) {
            labels = new Object[1][23];
            cols = new String[23];
        }
        int m = 9;
        cols[0] = "ORDER_NUM";
        cols[1] = "DELIVERYDATE";
        cols[2] = "BASESTATUS";
        cols[3] = "BIZTYPE";
        cols[4] = "CUSTOMER_NAME";
        cols[5] = "CUSTOMER_NUMBER";
        cols[6] = "SALEORG_NAME";
        cols[7] = "MATERIAL_NUMBER";
        cols[8] = "MATERIAL_NAME";
        boolean ckBxShowShortName = params.getBoolean("ckBxShowMShortName");
        if (ckBxShowShortName) {
            cols[m] = "MATERIAL_SHORTNAME";
            ++m;
        }
        cols[m] = "MATERIAL_MODEL";
        cols[++m] = "UNIT_NAME";
        cols[++m] = "ORDER_QTY";
        cols[++m] = "ORDER_AMOUT";
        cols[++m] = "TOTALRECEIVE_QTY";
        ++m;
        if (params.getBoolean("IsOutWarehs")) {
            cols[m] = "TOTAL_AMOUNT";
            ++m;
        } else {
            cols[m] = "TOTALNOTICE_QTY";
            ++m;
        }
        cols[m] = "NOINWAREHS_QTY";
        cols[++m] = "NOINWAREHS_AMOUNT";
        cols[++m] = "SALEORG_FID";
        cols[++m] = "MATERIAL_FID";
        cols[++m] = "TOTALFLAG";
        cols[++m] = "AMOUNT_PRECISION";
        cols[++m] = "QTY_PRECISION";
        this.setHeaderColumns(header, cols, params);
        labels[0][0] = billNum;
        labels[0][1] = deliverydate;
        labels[0][2] = billStatus;
        labels[0][3] = bizType;
        labels[0][4] = customerName;
        labels[0][5] = customerNumber;
        labels[0][6] = SaleOrgName;
        labels[0][7] = materialNum;
        labels[0][8] = materialName;
        m = 9;
        if (ckBxShowShortName) {
            labels[0][m] = shortName;
            ++m;
        }
        labels[0][m] = materialModel;
        labels[0][++m] = baseUnit;
        labels[0][++m] = quatity;
        labels[0][++m] = AmountT;
        ++m;
        if (this.isReceivale) {
            labels[0][m] = totalShipQty;
            labels[0][++m] = TotalNoticeAmount;
            ++m;
        } else {
            labels[0][m] = totalPostRequisitionQty;
            labels[0][++m] = TotalAmout;
            ++m;
        }
        labels[0][m] = totalUnShipQty;
        labels[0][++m] = NonAmount;
        labels[0][++m] = "SALEORG_FID";
        labels[0][++m] = "MATERIAL_FID";
        labels[0][++m] = "TOTALFLAG";
        labels[0][++m] = "AMOUNT_PRECISION";
        labels[0][++m] = "QTY_PRECISION";
        header.setLabels(labels, true);
        return header;
    }

    private void setHeaderColumns(RptTableHeader header, String[] columns, RptParams params) {
        String dateFormat = RptCellFormatter.getDateFormat((String)"yyyy-MM-dd");
        RptTableColumn col = null;
        int c = columns.length;
        for (int i = 0; i < c; ++i) {
            col = new RptTableColumn(columns[i]);
            col.setWidth(-1);
            if (i == 1) {
                col.setFormatPattern(dateFormat);
            }
            if (params.getBoolean("ckBxShowMShortName")) {
                if (i == 12 || i == 13 || i == 14 || i == 15 || i == 16 || i == 17) {
                    col.setWidth(120);
                    col.setAligment(2);
                }
            } else if (i == 11 || i == 12 || i == 13 || i == 14 || i == 15 || i == 16) {
                col.setWidth(120);
                col.setAligment(2);
            }
            header.addColumn(col);
        }
    }

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        this.locLan = this.getLoc(ctx);
        RptRowSet rs = this.executeQuery(this.querySql(params, ctx) + " order by temp.FsaleOrderNumber desc,temp.FCustomerID,temp.Fsaleorgunitid,temp.FMaterialID", null, from, len, ctx);
        RptParams pp = new RptParams();
        pp.setObject("rowset", (Object)rs);
        return pp;
    }

    private void executeSQL(Context ctx, String sql) throws BOSException {
        if (sql != null && sql.trim().length() > 0) {
            this.executeUpdate(sql, null, ctx);
        }
    }

    private String querySql(RptParams params, Context ctx) {
        StringBuffer sql = new StringBuffer(800);
        String tempTable = params.getString("tempTable");
        String orgUnitTempTable = params.getString("OrgTempTable");
        sql.append(" SELECT temp.FsaleOrderNumber BILLNUMBER,temp.FDeliveryDate,temp.FBaseStatus");
        sql.append(",BIZTYPE.FName_").append(this.locLan).append(" AS BIZTYPE_NAME,CUSTOMER.FName_").append(this.locLan).append(" AS CUSTOMER_NAME, CUSTOMER.FNUMBER AS CUSTOMER_NUMBER ");
        sql.append("\r\n ,org.fname_").append(this.locLan).append(" AS SALEORG_NAME");
        sql.append(",mat.FNumber AS MATERIAL_NUMBER").append(",mat.FName_").append(this.locLan).append(" AS MATERIAL_NAME,").append(params.getBoolean("ckBxShowMShortName") ? "case temp.FTotalFlag when 'TotalAll' then ' ' else mat.FShortName end AS MATERIAL_SHORTNAME," : " ").append("mat.FModel AS MATERIAL_MODEL");
        sql.append("\r\n ,UNIT.FName_").append(this.locLan).append(" AS UNIT_NAME").append("\r\n ,temp.FQty QTY,temp.FTaxAmount TAXMOUNT,temp.FTotalReceiveQty TOTALRECEIVE_QTY,").append("temp.FTotalQtyAmount FTOTAL_AMOUNT,temp.FNonWarehsQty NONWAREHS_QTY,temp.FNonAMount NONAMOUNT").append(",temp.FSaleOrgUnitID as SALEORG_FID").append(",temp.FMaterialID AS MATERIAL_FID").append(",temp.FTotalFlag AS TOTALFLAG").append(",Currency.FPrecision AS AMOUNT_PRECISION").append(",UNIT.FQtyPrecision AS QTY_PRECISION").append(" from  " + tempTable + " temp \r\n LEFT OUTER JOIN ").append(orgUnitTempTable).append(" org ON temp.FSaleOrgUnitID = org.FID ").append("\r\n LEFT OUTER JOIN T_BD_Material mat on temp.FMaterialID = mat.FID ").append(" \r\n LEFT OUTER JOIN T_BD_Customer AS CUSTOMER ON temp.FCustomerID = CUSTOMER.FID ").append(" \r\n LEFT OUTER JOIN T_SCM_BizType AS BIZTYPE\tON temp.FBIZTYPEID = BIZTYPE.FID ").append("\r\n LEFT OUTER JOIN T_BD_MeasureUnit AS UNIT ON temp.FUnitID = UNIT.FID ").append("\r\n LEFT OUTER JOIN T_BD_Currency AS Currency ON temp.FCurrencyID = Currency.FID ");
        return sql.toString();
    }

    protected IRowSet _getIdList(Context ctx, RptParams param) throws BOSException {
        String rsList = "select  s.fid from " + param.getString("tempTable") + " s left outer join T_BD_Material m on s.FMaterialID=m.FID  left outer join " + param.getString("OrgTempTable") + " org  on s.Fsaleorgunitid = org.FID  where s.FNonWarehsQty > 0  order by s.FsaleOrderNumber desc,s.FCustomerID,s.Fsaleorgunitid,s.FMaterialID";
        return DbUtil.executeQuery((Context)ctx, (String)rsList);
    }

    public RptParams getDataForIdList(Context ctx, List idList, RptParams params) throws BOSException, EASBizException {
        return this.getDatas(ctx, params, idList, false);
    }

    private RptParams getDatas(Context ctx, RptParams params, List idList, boolean first) throws BOSException {
        String subWhere;
        String orgTempTable = params.getString("OrgTempTable");
        String tempTable = params.getString("tempTable");
        if (first) {
            subWhere = " ";
        } else {
            StringBuffer fid = new StringBuffer("where temp.FId IN (  '").append(idList.get(0).toString()).append("'");
            int n = idList.size();
            for (int i = 1; i < n; ++i) {
                fid.append(", '").append(idList.get(i).toString()).append("'");
            }
            fid.append(" ) ");
            subWhere = fid.toString();
        }
        StringBuffer sql = new StringBuffer(800);
        sql.append(" SELECT temp.FsaleOrderNumber BILLNUMBER,temp.FDeliveryDate,temp.FBaseStatus");
        sql.append(",BIZTYPE.FName_").append(this.locLan).append(" AS BIZTYPE_NAME,CUSTOMER.FName_").append(this.locLan).append(" AS CUSTOMER_NAME");
        sql.append("\r\n ,org.fname_").append(this.locLan).append(" AS SALEORG_NAME");
        sql.append(",mat.FNumber AS MATERIAL_NUMBER").append(",mat.FName_").append(this.locLan).append(" AS MATERIAL_NAME,").append(params.getBoolean("ckBxShowMShortName") ? "mat.fshortname AS material_shortname," : " ").append("mat.FModel AS MATERIAL_MODEL");
        sql.append("\r\n ,UNIT.FName_").append(this.locLan).append(" AS UNIT_NAME").append("\r\n ,temp.FQty QTY,temp.FTaxAmount TAXMOUNT,temp.FTotalReceiveQty TOTALRECEIVE_QTY").append(",temp.FTotalQtyAmount FTOTAL_AMOUNT,temp.FNonWarehsQty NONWAREHS_QTY,temp.FNonAMount NONAMOUNT").append(",temp.FSaleOrgUnitID as SALEORG_FID").append(",temp.FMaterialID AS MATERIAL_FID").append(",temp.FTotalFlag AS TOTALFLAG").append(" from  " + tempTable + " temp \r\n LEFT OUTER JOIN ").append(orgTempTable).append(" org ON temp.FSaleOrgUnitID = org.FID ").append("\r\n LEFT OUTER JOIN T_BD_Material mat on temp.FMaterialID = mat.FID ").append(" \r\n LEFT OUTER JOIN T_BD_Customer AS CUSTOMER ON temp.FCustomerID = CUSTOMER.FID ").append(" \r\n LEFT OUTER JOIN T_SCM_BizType AS BIZTYPE\tON temp.FBIZTYPEID = BIZTYPE.FID ").append("\r\n LEFT OUTER JOIN T_BD_MeasureUnit AS UNIT ON temp.FUnitID = UNIT.FID ").append(subWhere).append(" order by temp.FsaleOrderNumber desc,temp.FCustomerID,temp.FSaleOrgUnitID,temp.FMaterialID");
        RptRowSet rs = this.executeQuery(sql.toString(), null, ctx);
        RptParams pp = new RptParams();
        pp.setObject("rowset", (Object)rs);
        return pp;
    }

    public String getServerResource(String key, Context ctx) {
        return SCMUtils.getResource((String)resClassName, (String)key, (Context)ctx);
    }
}

