/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptCellFormatter;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sd.sale.report.app.AbstractSalePriceRecordFacadeControllerBean;
import com.kingdee.eas.scm.sd.sale.util.SaleUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Locale;

public class SalePriceRecordFacadeControllerBean
extends AbstractSalePriceRecordFacadeControllerBean {
    private static final String resClassName = "com.kingdee.eas.scm.sd.sale.report.SDReportResource";

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        this.dropTable(params.getString("TempTableName"), ctx);
        String tempTable = this.getTempTableName(this.getServerResource("SaleORGUintTempTable", ctx), ctx);
        params.setString("TempTableName", tempTable);
        this.createTempTableAndInsertData(ctx, tempTable, params);
        DBUtil.createTempTableIndex((Context)ctx, (String)tempTable, (String)"fid", (boolean)false);
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            DBUtil.AnalyseTable((Context)ctx, (Connection)conn, (String)tempTable);
            DBUtil.AnalyseTable((Context)ctx, (Connection)conn, (String)tempTable);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        boolean ckBxShowMShortName = params.getBoolean("ckBxShowMShortName");
        String shortNameFrom = (String)params.getObject("shortNameFrom");
        String shortNameTo = (String)params.getObject("shortNameTo");
        StringBuffer sqlbf = new StringBuffer();
        sqlbf.append(" select count(t0.FID) cc ");
        sqlbf.append("FROM  " + tempTable + "  t0 ");
        sqlbf.append(" INNER JOIN T_BD_MATERIAL  t7 ON t0.FMATERIALID = t7.FID ");
        sqlbf.append(" INNER JOIN T_ORG_Sale t1 ON t0.FSaleOrgUnitID = t1.FID ");
        sqlbf.append(" INNER JOIN T_BD_Customer t2 ON t0.FCustomerID = t2.FID ");
        sqlbf.append(" LEFT OUTER JOIN T_ORG_Admin t3 ON t0.FAdminOrgUnitID = t3.FID ");
        sqlbf.append(" LEFT OUTER JOIN T_BD_Person t4 ON t0.FPersonId = t4.FID ");
        sqlbf.append(" LEFT OUTER JOIN T_BD_Currency t5 ON t0.FCurrencyID = t5.FID ");
        sqlbf.append(" INNER JOIN T_BD_MeasureUnit t6 ON t0.FUnitID = t6.FID ");
        if (ckBxShowMShortName) {
            if (shortNameFrom != null && shortNameFrom.trim().length() > 0) {
                if (shortNameFrom.indexOf("'") != -1) {
                    shortNameFrom = shortNameFrom.replaceAll("'", "''");
                }
                if (sqlbf.toString().indexOf("where") == -1) {
                    sqlbf.append("\r\n where ");
                    sqlbf.append(" t7.FShortName >= '").append(shortNameFrom.trim()).append("' ");
                } else {
                    sqlbf.append(" and t7.FShortName >= '").append(shortNameFrom.trim()).append("' ");
                }
            }
            if (shortNameTo != null && shortNameTo.trim().length() > 0) {
                if (shortNameTo.indexOf("'") != -1) {
                    shortNameTo = shortNameTo.replaceAll("'", "''");
                }
                if (sqlbf.toString().indexOf("where") == -1) {
                    sqlbf.append("\r\n where ");
                    sqlbf.append(" t7.FShortName <= '").append(shortNameTo.trim()).append("' ");
                } else {
                    sqlbf.append(" and t7.FShortName <= '").append(shortNameTo.trim()).append("' ");
                }
            }
        }
        RptRowSet rs = this.executeQuery(sqlbf.toString(), null, ctx);
        rs.next();
        int count = rs.getInt(0);
        RptTableHeader header = new RptTableHeader();
        this.setTableHead(header, params, ctx);
        RptParams result = new RptParams();
        result.setString("TempTableName", tempTable);
        result.setObject("header", (Object)header);
        result.setInt("verticalCount", count);
        result.setString("TempTableObject", tempTable);
        return result;
    }

    private void createTempTableAndInsertData(Context ctx, String tempTable, RptParams params) throws BOSException, EASBizException {
        String sql = this.getCreateTempTable(tempTable, params);
        this.executeSQL(ctx, sql);
        SqlParams sqlParams = new SqlParams();
        String orderSelect = params.getString("OrderSelectedItem");
        if (orderSelect.equals("10")) {
            this.setRPTData(sqlParams, params);
            sql = this.getRptSqlFromOrder(params, tempTable, ctx);
        } else {
            this.setRPTData(sqlParams, params);
            sql = this.getRptSqlFromOtherOrder(params, tempTable, ctx);
        }
        this.executeUpdate(sql, sqlParams, ctx);
    }

    private String getCreateTempTable(String tempTable, RptParams params) {
        StringBuffer sql = new StringBuffer(800);
        sql.append("Create Table " + tempTable + "(\r\n");
        sql.append("FID Varchar(44)\r\n");
        sql.append(",FMaterialID Varchar(44)\r\n");
        sql.append(",FSaleOrgUnitID Varchar(44)\r\n");
        sql.append(",FCustomerID Varchar(44)\r\n");
        sql.append(",FAdminOrgUnitID Varchar(44)\r\n");
        sql.append(",FPersonID Varchar(44)\r\n");
        sql.append(",FBizDate DateTime\r\n");
        sql.append(",FNumber Varchar(88)\r\n");
        sql.append(",FCurrencyID Varchar(44)\r\n");
        sql.append(",FExchangeRate Decimal(28,10)\r\n");
        sql.append(",FUnitID Varchar(44)\r\n");
        sql.append(",FQty Decimal(28,10)\r\n");
        sql.append(",FTaxPrice Decimal(28,10)\r\n");
        sql.append(",FDiscountRate Decimal(28,10)\r\n");
        sql.append(",FActualPrice Decimal(28,10)\r\n");
        sql.append(",FAmount Decimal(28,10)\r\n");
        sql.append(",FTaxAmount Decimal(28,10)\r\n");
        sql.append(",FCompare varchar(44)\r\n");
        sql.append(",localPrice Decimal(28,10)\r\n");
        sql.append(",FMaxPrice Decimal(28,10)\r\n");
        sql.append(",FMinPrice Decimal(28,10)\r\n");
        sql.append(",FBaseQty Decimal(28,10)\r\n");
        sql.append(");\r\n");
        return sql.toString();
    }

    private void setRPTData(SqlParams sqlParams, RptParams params) {
        int count = sqlParams.size() + 1;
        for (int k = 0; k < 2; ++k) {
            int i;
            if (params.getObject("CustomerFrom") != null) {
                if (params.getObject("CustomerFrom") instanceof Object[]) {
                    Object[] customers = (Object[])params.getObject("CustomerFrom");
                    for (i = 0; i < customers.length; ++i) {
                        sqlParams.setString(count++, ((CustomerInfo)customers[i]).getNumber());
                    }
                } else if (params.getObject("CustomerFrom") instanceof CustomerInfo) {
                    sqlParams.setString(count++, ((CustomerInfo)params.getObject("CustomerFrom")).getNumber());
                } else {
                    sqlParams.setString(count++, params.getObject("CustomerFrom").toString());
                }
            }
            if (params.getString("CustomerTo") != null) {
                sqlParams.setString(count++, params.getString("CustomerTo"));
            }
            if (params.getObject("materialFrom") != null) {
                if (params.getObject("materialFrom") instanceof Object[]) {
                    Object[] materials = (Object[])params.getObject("materialFrom");
                    for (i = 0; i < materials.length; ++i) {
                        sqlParams.setString(count++, ((MaterialInfo)materials[i]).getNumber());
                    }
                } else {
                    sqlParams.setString(count++, params.getObject("materialFrom").toString());
                }
            }
            if (params.getString("materialTo") != null) {
                sqlParams.setString(count++, params.getString("materialTo"));
            }
            if (params.getString("SalePersonFrom") != null) {
                sqlParams.setString(count++, params.getString("SalePersonFrom"));
            }
            if (params.getString("SalePersonTo") == null) continue;
            sqlParams.setString(count++, params.getString("SalePersonTo"));
        }
    }

    private String getRptSqlFromOrder(RptParams params, String tableName, Context ctx) throws BOSException, EASBizException {
        int i;
        String orgIDlist;
        boolean isCustomerFr = false;
        boolean isCustomerTo = false;
        boolean isCustomerIn = false;
        boolean isMatFr = false;
        boolean isMatTo = false;
        boolean isMatIn = false;
        boolean isSalePersonFr = false;
        boolean isSalePersonTo = false;
        int customerInNum = 0;
        int matInNum = 0;
        Object[] fullOrg = (Object[])params.getObject("fullSaleOrgUnit");
        String beginDate = params.getString("dateStart");
        String endDate = params.getString("dateEnd");
        if (params.getObject("CustomerFrom") != null) {
            if (params.getObject("CustomerFrom") instanceof Object[]) {
                Object[] customers = (Object[])params.getObject("CustomerFrom");
                if (customers.length == 1) {
                    isCustomerFr = true;
                } else {
                    isCustomerIn = true;
                    customerInNum = customers.length;
                }
            } else {
                isCustomerFr = true;
            }
        }
        if (params.getString("CustomerTo") != null) {
            isCustomerTo = true;
        }
        if (params.getObject("materialFrom") != null) {
            if (params.getObject("materialFrom") instanceof Object[]) {
                Object[] materials = (Object[])params.getObject("materialFrom");
                if (materials.length == 1) {
                    isMatFr = true;
                } else {
                    isMatIn = true;
                    matInNum = materials.length;
                }
            } else {
                isMatFr = true;
            }
        }
        if (params.getString("materialTo") != null) {
            isMatTo = true;
        }
        if (params.getString("SalePersonFrom") != null) {
            isSalePersonFr = true;
        }
        if (params.getString("SalePersonTo") != null) {
            isSalePersonTo = true;
        }
        if ((orgIDlist = this.getOrgListId(fullOrg, ctx)).length() <= 0) {
            MsgBox.showInfo((String)this.getServerResource("NoEntityORG", ctx));
            SysUtil.abort();
        }
        StringBuffer selectPart1 = new StringBuffer(800);
        selectPart1.append(" \r\n SELECT ");
        selectPart1.append(" \r\n newbosid('88888888') fid,entry.FMaterialID");
        selectPart1.append(" \r\n ,saleOrder.FSaleOrgUnitID");
        selectPart1.append(" \r\n ,saleOrder.FOrderCustomerID,saleOrder.FAdminOrgUnitID");
        selectPart1.append(" \r\n ,saleOrder.FSalePersonID,saleOrder.FBizDate,saleOrder.FNumber");
        selectPart1.append(" \r\n ,saleOrder.FCurrencyID,saleOrder.FExchangeRate");
        selectPart1.append(" \r\n ,entry.FUnitID,entry.FQty");
        selectPart1.append(" \r\n ,entry.FTaxPrice,entry.FDiscount");
        selectPart1.append(" \r\n ,entry.FActualPrice,entry.FAmount");
        selectPart1.append(" \r\n ,entry.FTaxAmount,entry.FBaseQty,");
        selectPart1.append(" case when entry.FBaseQty=0 then 0 else TO_DECIMAL((entry.FAmount/entry.FBaseQty)*saleOrder.FExchangeRate,31,7) end  localPrice ");
        StringBuffer sbWherePart = new StringBuffer();
        sbWherePart.append(" \r\n  from T_SD_SaleOrder saleOrder ").append(" \r\n  inner join  T_SD_SaleOrderentry entry on saleOrder.FID = entry.FParentID ");
        if (isCustomerFr || isCustomerTo || isCustomerIn) {
            sbWherePart.append(" \r\n  inner join  T_BD_Customer customer on saleOrder.FOrderCustomerID = customer.FID ");
            if (isCustomerFr) {
                sbWherePart.append(" \r\n  and customer.FNumber >= ?");
            }
            if (isCustomerTo) {
                sbWherePart.append(" \r\n  and customer.FNumber <= ?");
            }
            if (isCustomerIn) {
                sbWherePart.append(" \r\n  and customer.FNumber in (");
                for (i = 0; i < customerInNum; ++i) {
                    if (i > 0) {
                        sbWherePart.append(",");
                    }
                    sbWherePart.append("?");
                }
                sbWherePart.append(")");
            }
        }
        if (isMatFr || isMatTo || isMatIn) {
            sbWherePart.append(" \r\n  inner join  T_BD_Material mat on entry.FMaterialID = mat.FID ");
            if (isMatFr) {
                sbWherePart.append(" \r\n  and mat.FNumber >= ?");
            }
            if (isMatTo) {
                sbWherePart.append(" \r\n  and mat.FNumber <= ?");
            }
            if (isMatIn) {
                sbWherePart.append(" \r\n  and mat.FNumber in (");
                for (i = 0; i < matInNum; ++i) {
                    if (i > 0) {
                        sbWherePart.append(",");
                    }
                    sbWherePart.append("?");
                }
                sbWherePart.append(")");
            }
        }
        if (isSalePersonFr || isSalePersonTo) {
            sbWherePart.append(" \r\n  inner join  T_BD_Person person on saleOrder.FSalePersonID = person.FID ");
            if (isSalePersonFr) {
                sbWherePart.append(" \r\n  and person.FNumber >= ?");
            }
            if (isSalePersonTo) {
                sbWherePart.append(" \r\n  and person.FNumber <= ?");
            }
        }
        sbWherePart.append(" \r\n  where ");
        sbWherePart.append(" \r\n  (saleOrder.Fbasestatus =4 or saleOrder.Fbasestatus = 5 ");
        sbWherePart.append(" \r\n   or saleOrder.Fbasestatus = 6 or saleOrder.Fbasestatus = 7)");
        sbWherePart.append(" \r\n and saleOrder.FSaleORGUnitID in (" + orgIDlist);
        sbWherePart.append(")");
        sbWherePart.append(" \r\n  and saleOrder.FBizDate >= {" + beginDate + "}");
        sbWherePart.append(" \r\n  and saleOrder.FBizDate <= {" + endDate + "}");
        sbWherePart.append(" \r\n AND entry.FQty > 0 ");
        StringBuffer insertPart = new StringBuffer();
        insertPart.append("insert into " + tableName);
        insertPart.append(" (FID,FMaterialID,FSaleOrgUnitID,FCustomerID,FAdminOrgUnitID,");
        insertPart.append("FPersonID ,FBizDate,FNumber,FCurrencyID,FExchangeRate,FUnitID,FQty,");
        insertPart.append("FTaxPrice,FDiscountRate,FActualPrice,FAmount,FTaxAmount,FBaseQty,localPrice,FMaxPrice,FMinPrice )");
        insertPart.append(" SELECT t1.FID,t1.FMaterialID,t1.FSaleOrgUnitID,");
        insertPart.append(" t1.FOrderCustomerID,t1.FAdminOrgUnitID,t1.FSalePersonID,t1.FBizDate,t1.FNumber,");
        insertPart.append(" t1.FCurrencyID,t1.FExchangeRate,t1.FUnitID,t1.FQty,");
        insertPart.append(" t1.FTaxPrice,t1.FDiscount,t1.FActualPrice,t1.FAmount,t1.FTaxAmount,t1.FBaseQty,t1.localPrice,t2.FMaxPrice,t2.FMinPrice");
        insertPart.append(" from ");
        insertPart.append("(").append(selectPart1).append(sbWherePart).append(") t1,");
        insertPart.append("(select entry.FMaterialID,").append("Max(case when entry.FBaseQty=0 then 0 else TO_DECIMAL((entry.FAmount/entry.FBaseQty)*saleOrder.FExchangeRate,31,7) end ) FMaxPrice,").append("Min(case when entry.FBaseQty=0 then 0 else TO_DECIMAL((entry.FAmount/entry.FBaseQty)*saleOrder.FExchangeRate,31,7) end ) FMinPrice ").append(sbWherePart).append(" group by entry.FMaterialID) t2 ").append("WHERE t1.FMaterialID = t2.FMaterialID ");
        return insertPart.toString();
    }

    private String getRptSqlFromOtherOrder(RptParams params, String tableName, Context ctx) throws BOSException, EASBizException {
        String orgIDlist;
        boolean isCustomerFr = false;
        boolean isCustomerTo = false;
        boolean isMatFr = false;
        boolean isMatTo = false;
        boolean isSalePersonFr = false;
        boolean isSalePersonTo = false;
        Object[] fullOrg = (Object[])params.getObject("fullSaleOrgUnit");
        String beginDate = params.getString("dateStart");
        String endDate = params.getString("dateEnd");
        if (params.getString("CustomerFrom") != null) {
            isCustomerFr = true;
        }
        if (params.getString("CustomerTo") != null) {
            isCustomerTo = true;
        }
        if (params.getString("materialFrom") != null) {
            isMatFr = true;
        }
        if (params.getString("materialTo") != null) {
            isMatTo = true;
        }
        if (params.getString("SalePersonFrom") != null) {
            isSalePersonFr = true;
        }
        if (params.getString("SalePersonTo") != null) {
            isSalePersonTo = true;
        }
        if ((orgIDlist = this.getOrgListId(fullOrg, ctx)).length() <= 0) {
            MsgBox.showInfo((String)this.getServerResource("NoEntityORG", ctx));
            SysUtil.abort();
        }
        StringBuffer selectPart1 = new StringBuffer();
        selectPart1.append(" \r\n SELECT ");
        selectPart1.append(" \r\n newbosid('88888888') FID,entry.FMaterialID");
        selectPart1.append(" \r\n ,Bill.FSaleOrgID");
        selectPart1.append(" \r\n ,Bill.FAsstActID,Bill.FAdminOrgUnitID");
        selectPart1.append(" \r\n ,Bill.FPersonID,Bill.FBizDate,Bill.FNumber");
        selectPart1.append(" \r\n ,Bill.FCurrencyID,Bill.FExchangeRate");
        selectPart1.append(" \r\n ,entry.FMeasureUnitID,entry.FQuantity");
        selectPart1.append(" \r\n ,entry.FTaxPrice,entry.FDiscountRate as FDiscount");
        selectPart1.append(" \r\n ,entry.FRealPrice as FActualPrice,entry.FAmount");
        selectPart1.append(" \r\n ,entry.FRecievePayAmount as FTaxAmount,entry.FBaseQty, ");
        selectPart1.append(" case when entry.FBaseQty=0 then 0 else TO_DECIMAL((entry.FAmount/entry.FBaseQty)*BIll.FExchangeRate,31,7) end localPrice ");
        StringBuffer sbWherePart = new StringBuffer();
        sbWherePart.append(" \r\n  from T_AR_OtherBill Bill ");
        sbWherePart.append(" \r\n  inner join  T_AR_OtherBillEntry entry on bill.FID = entry.FParentID ");
        if (isCustomerFr || isCustomerTo) {
            sbWherePart.append(" \r\n  inner join  T_BD_Customer customer on Bill.FAsstActID = customer.FID ");
            if (isCustomerFr) {
                sbWherePart.append(" \r\n  and customer.FNumber >= ?");
            }
            if (isCustomerTo) {
                sbWherePart.append(" \r\n  and customer.FNumber <= ?");
            }
        }
        if (isMatFr || isMatTo) {
            sbWherePart.append(" \r\n  inner join  T_BD_Material mat on entry.FMaterialID = mat.FID ");
            if (isMatFr) {
                sbWherePart.append(" \r\n  and mat.FNumber >= ?");
            }
            if (isMatTo) {
                sbWherePart.append(" \r\n  and mat.FNumber <= ?");
            }
        }
        if (isSalePersonFr || isSalePersonTo) {
            sbWherePart.append(" \r\n  inner join  T_BD_Person person on Bill.FPersonID = person.FID ");
            if (isSalePersonFr) {
                sbWherePart.append(" \r\n  and person.FNumber >= ?");
            }
            if (isSalePersonTo) {
                sbWherePart.append(" \r\n  and person.FNumber <= ?");
            }
        }
        sbWherePart.append(" \r\n  where ");
        sbWherePart.append(" \r\n  Bill.FBillstatus = 3 and (BIll.FBillType =102 or BIll.FBillType= 103 ) ");
        sbWherePart.append(" \r\n  and Bill.FSaleOrgID in (" + orgIDlist);
        sbWherePart.append(" \r\n  )");
        sbWherePart.append(" \r\n  and Bill.FBizDate >= {" + beginDate + "}");
        sbWherePart.append(" \r\n  and Bill.FBizDate <= {" + endDate + "}");
        StringBuffer insertPart = new StringBuffer();
        insertPart.append("insert into " + tableName);
        insertPart.append(" (FID,FMaterialID,FSaleOrgUnitID,FCustomerID,FAdminOrgUnitID,");
        insertPart.append("FPersonID ,FBizDate,FNumber,FCurrencyID,FExchangeRate,FUnitID,FQty,");
        insertPart.append("FTaxPrice,FDiscountRate,FActualPrice,FAmount,FTaxAmount,FBaseQty,localPrice,FMaxPrice,FMinPrice )");
        insertPart.append(" SELECT t1.FID,t1.FMaterialID,t1.FSaleOrgID,");
        insertPart.append(" t1.FAsstActID,t1.FAdminOrgUnitID,t1.FPersonID,t1.FBizDate,t1.FNumber,");
        insertPart.append(" t1.FCurrencyID,t1.FExchangeRate,t1.FMeasureUnitID,t1.FQuantity,");
        insertPart.append(" t1.FTaxPrice,t1.FDiscount,t1.FActualPrice,t1.FAmount,t1.FTaxAmount,t1.FBaseQty,t1.localPrice,t2.FMaxPrice,t2.FMinPrice");
        insertPart.append(" from ");
        insertPart.append("(").append(selectPart1).append(sbWherePart).append(") t1,");
        insertPart.append("(select entry.FMaterialID,").append("Max(case when entry.FBaseQty=0 then 0 else TO_DECIMAL((entry.FAmount/entry.FBaseQty)*BIll.FExchangeRate,31,7) end ) FMaxPrice,").append("Min(case when entry.FBaseQty=0 then 0 else TO_DECIMAL((entry.FAmount/entry.FBaseQty)*BIll.FExchangeRate,31,7) end ) FMinPrice ").append(sbWherePart).append(" group by entry.FMaterialID) t2 ").append("WHERE t1.FMaterialID = t2.FMaterialID ");
        return insertPart.toString();
    }

    private RptTableHeader setTableHead(RptTableHeader header, RptParams params, Context ctx) {
        boolean ckBxShowMShortName = params.getBoolean("ckBxShowMShortName");
        String materialNum = this.getServerResource("MaterialNum", ctx);
        String materialName = this.getServerResource("MaterialNam", ctx);
        String materilShortName = this.getServerResource("MaterialShortName", ctx);
        String materialModel = this.getServerResource("MaterialMod", ctx);
        String purchaseUnitName = this.getServerResource("SaleOrg", ctx);
        String customerName = this.getServerResource("CustomerName", ctx);
        String customerNumber = this.getServerResource("CUSTOMERNUMBER", ctx);
        String deptName = this.getServerResource("DeptName", ctx);
        String personName = this.getServerResource("Person", ctx);
        String bizDate = this.getServerResource("BillDate", ctx);
        String billNumber = this.getServerResource("BillNumber", ctx);
        String currencyName = this.getServerResource("Currency", ctx);
        String exchangRate = this.getServerResource("ExchangRate", ctx);
        String unitName = this.getServerResource("Unit", ctx);
        String qty = this.getServerResource("Qty", ctx);
        String taxprice = this.getServerResource("Taxprice", ctx);
        String discountRate = this.getServerResource("DiscountPercent", ctx);
        String actualPrice = this.getServerResource("ActualPrice", ctx);
        String amount = this.getServerResource("Amount", ctx);
        String taxAmount = this.getServerResource("TaxAmount", ctx);
        String compare = this.getServerResource("Compare", ctx);
        String maxPrice = this.getServerResource("MaxPrice", ctx);
        String minPrice = this.getServerResource("MinPrice", ctx);
        String baseQty = "BaseQty";
        Object[][] labels = new Object[1][23];
        String[] cols = new String[23];
        if (ckBxShowMShortName) {
            labels = new Object[1][24];
            cols = new String[24];
        }
        int m = 2;
        cols[0] = "MATERIAL_NUMBER";
        cols[1] = "MATERIAL_NAME";
        if (ckBxShowMShortName) {
            cols[m++] = "MATERIAL_SHORTNAME";
        }
        cols[m++] = "MATERIAL_MODEL";
        cols[m++] = "PURCHASEORG_NAME";
        cols[m++] = "CUSTOMER_NAME";
        cols[m++] = "CUSTOMER_NUMBER";
        cols[m++] = "DEPT_TNAME";
        cols[m++] = "PERSON_NAME";
        cols[m++] = "BIZDATE";
        cols[m++] = "FNUMBER";
        cols[m++] = "CURRENCY";
        cols[m++] = "EXCHANGRATE";
        cols[m++] = "UNIT_NAME";
        cols[m++] = "QTY";
        cols[m++] = "TAXPRICE";
        cols[m++] = "DISCOUNTRATE";
        cols[m++] = "ACTUALPRICE";
        cols[m++] = "AMOUNT";
        cols[m++] = "TAXAMOUNT";
        cols[m++] = "COMPARE";
        cols[m++] = "MAXPRICE";
        cols[m++] = "MINPRICE";
        cols[m++] = "BASEQTY";
        m = 2;
        this.setHeaderColumns(header, cols, params);
        labels[0][0] = materialNum;
        labels[0][1] = materialName;
        labels[0][2] = materialModel;
        if (ckBxShowMShortName) {
            labels[0][m++] = materilShortName;
        }
        labels[0][m++] = materialModel;
        labels[0][m++] = purchaseUnitName;
        labels[0][m++] = customerName;
        labels[0][m++] = customerNumber;
        labels[0][m++] = deptName;
        labels[0][m++] = personName;
        labels[0][m++] = bizDate;
        labels[0][m++] = billNumber;
        labels[0][m++] = currencyName;
        labels[0][m++] = exchangRate;
        labels[0][m++] = unitName;
        labels[0][m++] = qty;
        labels[0][m++] = taxprice;
        labels[0][m++] = discountRate;
        labels[0][m++] = actualPrice;
        labels[0][m++] = amount;
        labels[0][m++] = taxAmount;
        labels[0][m++] = compare;
        labels[0][m++] = maxPrice;
        labels[0][m++] = minPrice;
        labels[0][m++] = baseQty;
        header.setLabels(labels, true);
        return header;
    }

    private void setHeaderColumns(RptTableHeader header, String[] columns, RptParams params) {
        String prcFormat = SaleUtil.getFormatPattern(4, true);
        String rateFormat = SaleUtil.getFormatPattern(8, true);
        String dateFormat = RptCellFormatter.getDateFormat((String)"yyyy-MM-dd");
        RptTableColumn col = null;
        int length = columns.length;
        for (int i = 0; i < length; ++i) {
            if (params.getBoolean("ckBxShowMShortName")) {
                if (i == 10) {
                    col.setFormatPattern(dateFormat);
                }
                col = new RptTableColumn(columns[i]);
                if (i >= 14 && i != 20 || i == 12) {
                    col.setWidth(-1);
                    col.setWidth(120);
                    col.setAligment(2);
                    if (i == 11) {
                        col.setFormatPattern(rateFormat);
                    } else {
                        col.setFormatPattern(prcFormat);
                    }
                    if (i >= 21) {
                        col.setHided(true);
                    }
                }
            } else {
                if (i == 9) {
                    col.setFormatPattern(dateFormat);
                }
                col = new RptTableColumn(columns[i]);
                if (i >= 13 && i != 19 || i == 11) {
                    col.setWidth(-1);
                    col.setWidth(120);
                    col.setAligment(2);
                    if (i == 10) {
                        col.setFormatPattern(rateFormat);
                    } else {
                        col.setFormatPattern(prcFormat);
                    }
                    if (i >= 20) {
                        col.setHided(true);
                    }
                }
            }
            header.addColumn(col);
        }
    }

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        boolean ckBxShowMShortName = params.getBoolean("ckBxShowMShortName");
        String shortNameFrom = (String)params.getObject("shortNameFrom");
        String shortNameTo = (String)params.getObject("shortNameTo");
        String local_lan = ctx.getLocale().getLanguage();
        StringBuffer sqlbf = new StringBuffer();
        String tempTable = params.getString("TempTableName");
        sqlbf.append(" select t7.FNUMBER matNum,t7.FNAME_" + local_lan + " matName,");
        sqlbf.append(ckBxShowMShortName ? "t7.FShortName MATERIAL_SHORTNAME," : "");
        sqlbf.append("t7.FMODEL");
        sqlbf.append(",t1.FNAME_" + local_lan + " orgName,t2.FNAME_" + local_lan);
        sqlbf.append(" custName,t2.FNUMBER custNumber, t3.FNAME_" + local_lan + " admName,t4.FNAME_" + local_lan);
        sqlbf.append(" perName,t0.FBIZDATE,t0.FNUMBER ");
        sqlbf.append(",t5.FNAME_" + local_lan + " curName,t0.FEXCHANGERATE");
        sqlbf.append(",t6.FNAME_" + local_lan + " unitName,t0.FQTY");
        sqlbf.append(",t0.FTAXPRICE,t0.FDISCOUNTRATE");
        sqlbf.append(",t0.FACTUALPRICE");
        sqlbf.append(",t0.FAMOUNT");
        sqlbf.append(",t0.FTAXAMOUNT,");
        String zjj = ResourceBase.getString((String)"com.kingdee.eas.scm.sd.sale.SALEAutoGenerateResource", (String)"30_SalePriceRecordFacadeControllerBean", (Locale)ctx.getLocale());
        String pjj = ResourceBase.getString((String)"com.kingdee.eas.scm.sd.sale.SALEAutoGenerateResource", (String)"31_SalePriceRecordFacadeControllerBean", (Locale)ctx.getLocale());
        String zgj = ResourceBase.getString((String)"com.kingdee.eas.scm.sd.sale.SALEAutoGenerateResource", (String)"32_SalePriceRecordFacadeControllerBean", (Locale)ctx.getLocale());
        String zdj = ResourceBase.getString((String)"com.kingdee.eas.scm.sd.sale.SALEAutoGenerateResource", (String)"33_SalePriceRecordFacadeControllerBean", (Locale)ctx.getLocale());
        sqlbf.append("case when (t0.localPrice < t0.FMAXPRICE and t0.localPrice  > t0.FMINPRICE) Then N'").append(zjj).append("' ");
        sqlbf.append(" when (t0.localPrice = t0.FMAXPRICE and t0.localPrice =t0.FMINPRICE) Then N'").append(pjj).append("' ");
        sqlbf.append(" WHEN t0.localPrice  = t0.FMAXPRICE Then N'").append(zgj).append("' ");
        sqlbf.append(" when t0.localPrice = t0.FMINPRICE Then N'").append(zdj).append("' ");
        sqlbf.append("  END compareResult,t0.FMAXPRICE,t0.FMINPRICE,0 ");
        sqlbf.append("FROM  " + tempTable + "  t0 ");
        sqlbf.append(" INNER JOIN T_BD_MATERIAL  t7 ON t0.FMATERIALID = t7.FID ");
        sqlbf.append(" INNER JOIN T_ORG_Sale t1 ON t0.FSaleOrgUnitID = t1.FID ");
        sqlbf.append(" INNER JOIN T_BD_Customer t2 ON t0.FCustomerID = t2.FID ");
        sqlbf.append(" LEFT OUTER JOIN T_ORG_Admin t3 ON t0.FAdminOrgUnitID = t3.FID ");
        sqlbf.append(" LEFT OUTER JOIN T_BD_Person t4 ON t0.FPersonId = t4.FID ");
        sqlbf.append(" LEFT OUTER JOIN T_BD_Currency t5 ON t0.FCurrencyID = t5.FID ");
        sqlbf.append(" INNER JOIN T_BD_MeasureUnit t6 ON t0.FUnitID = t6.FID ");
        if (ckBxShowMShortName) {
            if (shortNameFrom != null && shortNameFrom.trim().length() > 0) {
                if (shortNameFrom.indexOf("'") != -1) {
                    shortNameFrom = shortNameFrom.replaceAll("'", "''");
                }
                if (sqlbf.toString().indexOf("where") == -1) {
                    sqlbf.append("\r\n where ");
                    sqlbf.append(" t7.FShortName >= '").append(shortNameFrom.trim()).append("' ");
                } else {
                    sqlbf.append(" and t7.FShortName >= '").append(shortNameFrom.trim()).append("' ");
                }
            }
            if (shortNameTo != null && shortNameTo.trim().length() > 0) {
                if (shortNameTo.indexOf("'") != -1) {
                    shortNameTo = shortNameTo.replaceAll("'", "''");
                }
                if (sqlbf.toString().indexOf("where") == -1) {
                    sqlbf.append("\r\n where ");
                    sqlbf.append(" t7.FShortName <= '").append(shortNameTo.trim()).append("' ");
                } else {
                    sqlbf.append(" and t7.FShortName <= '").append(shortNameTo.trim()).append("' ");
                }
            }
        }
        sqlbf.append(" order by t7.FNUMBER");
        String selectSql = sqlbf.toString();
        RptRowSet rs = this.executeQuery(selectSql, null, from, len, ctx);
        RptParams pp = new RptParams();
        pp.setObject("rowset", (Object)rs);
        return pp;
    }

    private void executeSQL(Context ctx, String sql) throws BOSException {
        if (sql != null && sql.trim().length() > 0) {
            this.executeUpdate(sql, null, ctx);
        }
    }

    public String getServerResource(String key, Context ctx) {
        return SCMUtils.getResource((String)resClassName, (String)key, (Context)ctx);
    }

    protected String getOrgListId(Object[] infos, Context ctx) throws EASBizException {
        StringBuffer OrgunitId = new StringBuffer();
        int n = infos.length;
        for (int i = 0; i < n; ++i) {
            Boolean isleaf = (Boolean)((FullOrgUnitInfo)infos[i]).get("isleaf");
            boolean fisleaf = isleaf != false;
            if (!fisleaf) continue;
            OrgunitId.append(",'" + ((FullOrgUnitInfo)infos[i]).getId().toString() + "'");
        }
        if (OrgunitId.length() <= 0) {
            return "'xxx_xxx'";
        }
        String orgunitListId = new String();
        orgunitListId = OrgunitId.toString().substring(1, OrgunitId.toString().length());
        return orgunitListId;
    }

    @Override
    protected void _updateProperty(Context ctx, String UserNumber, String orderResource, int month) throws BOSException, EASBizException {
        StringBuffer sql_update = new StringBuffer();
        sql_update.append(" update T_sd_salepriceRecProperty");
        sql_update.append(" \r\n set (FOrderResource,FDateRange,FLastUpdateTime)");
        sql_update.append(" \r\n =(select '" + orderResource + "','" + month);
        sql_update.append("',getDate())");
        sql_update.append(" \r\n where FUserNumber='" + UserNumber + "'");
        this.executeUpdate(sql_update.toString(), null, ctx);
    }

    @Override
    protected void _insertProperty(Context ctx, String UserNumber, String orderResource, int month) throws BOSException, EASBizException {
        String createTime = "2007-05-14 23:59:59";
        String updateTime = "2007-05-14 23:59:59";
        StringBuffer sql_insert = new StringBuffer();
        sql_insert.append(" insert into T_sd_salepriceRecProperty");
        sql_insert.append(" \r\n values('" + UserNumber);
        sql_insert.append("','" + orderResource + "','" + month);
        sql_insert.append("',{" + createTime + "},{" + updateTime + "})");
        this.executeUpdate(sql_insert.toString(), null, ctx);
    }

    @Override
    protected int _queryProperty(Context ctx, String unserName) throws BOSException, EASBizException {
        StringBuffer sql_select = new StringBuffer();
        sql_select.append(" select top 1 * from T_sd_salepriceRecProperty");
        sql_select.append(" \r\n where FUserNumber=");
        sql_select.append("'" + unserName + "' order by FLastUpdateTime");
        RptRowSet rs = this.executeQuery(sql_select.toString(), null, ctx);
        return rs.getRowCount();
    }

    @Override
    protected RptRowSet _selectProperty(Context ctx, String unserName) throws BOSException, EASBizException {
        StringBuffer sql_select = new StringBuffer();
        sql_select.append(" select top 1 * from T_sd_salepriceRecProperty");
        sql_select.append(" \r\n where FUserNumber=");
        sql_select.append("'" + unserName + "' order by FLastUpdateTime");
        RptRowSet rs = this.executeQuery(sql_select.toString(), null, ctx);
        return rs;
    }
}

