/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class DBUtil {
    private static final int MAX_STATMENT = 200;
    private static final String NEWLINE = "\t\n";

    public static void execute(Context ctx, String[] sql) throws BOSException {
        Connection conn = null;
        Statement statement = null;
        StringBuffer sqlstr = new StringBuffer();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.createStatement();
            if (sql != null) {
                for (int i = 0; i < sql.length; ++i) {
                    statement.addBatch(sql[i]);
                    sqlstr.append(sql[i]).append(NEWLINE);
                }
            }
            statement.executeBatch();
            statement.clearBatch();
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql execute exception : " + sqlstr, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)conn);
    }

    public static Object takeValue(Context ctx, String sql) throws BOSException {
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        block6: {
            Object object;
            block5: {
                conn = null;
                stmt = null;
                rs = null;
                conn = EJBFactory.getConnection((Context)ctx);
                stmt = conn.prepareStatement(sql);
                rs = stmt.executeQuery();
                if (rs != null) break block5;
                Object var5_5 = null;
                SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
                return var5_5;
            }
            try {
                if (!rs.next()) break block6;
                object = rs.getObject(1);
            }
            catch (SQLException ex) {
                try {
                    throw new BOSException("Sql execute exception : " + sql, (Throwable)ex);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, stmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
            return object;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return null;
    }

    public static void dropTempTable(Context ctx, String tempTableName) throws BOSException, EASBizException {
        if (tempTableName != null) {
            TableManagerFacadeFactory.getLocalInstance((Context)ctx).releaseTemporaryTableName(tempTableName);
        }
    }

    public static void releaseTempTable(Context ctx, String tempTableName) throws BOSException, EASBizException {
        if (tempTableName != null) {
            Connection con = null;
            try {
                con = EJBFactory.getConnection((Context)ctx);
                TempTablePool tmpPool = TempTablePool.getInstance((Context)ctx);
                tmpPool.releaseTable(tempTableName);
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (SQLException e) {
                        Logger.error((Throwable)e);
                    }
                }
            }
        }
    }

    public static String createTempTable(Context ctx, String serial, String[][] tableFields) throws BOSException {
        String tempTableName = "tempTableName";
        String sqlcreatetable = DBUtil.transCreateTable(ctx, DBUtil.getCreateTableSQl(tempTableName, tableFields).toString());
        try {
            TempTablePool tmpPool = TempTablePool.getInstance((Context)ctx);
            tempTableName = tmpPool.createTempTable(sqlcreatetable);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTableName;
    }

    public static String transCreateTable(Context ctx, String sql) {
        if (ctx.get((Object)"dbType") != null) {
            String dbType = (String)ctx.get((Object)"dbType");
            if ((dbType = dbType.toLowerCase()).indexOf("db2") > -1) {
                sql = sql.toLowerCase();
                sql = sql.replaceAll("numeric\\(28,16\\)", "numeric(21,8)");
                sql = sql.replaceAll("numeric\\(19,4\\)", "numeric(17,4)");
            }
        }
        return sql;
    }

    public static StringBuffer getCreateTableSQl(String tempTableName, String[][] fields) {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE ");
        sql.append(tempTableName);
        sql.append("(");
        for (int i = 0; i < fields.length; ++i) {
            if (i != 0) {
                sql.append(",");
            }
            sql.append(fields[i][0]);
            sql.append(" ");
            sql.append(fields[i][1]);
        }
        sql.append(")");
        return sql;
    }

    public static void close(Connection conn, PreparedStatement[] pm, ResultSet[] rs) throws BOSException {
        try {
            int i;
            for (i = 0; null != rs && i < rs.length; ++i) {
                if (null == rs[i]) continue;
                rs[i].close();
            }
            for (i = 0; null != pm && i < pm.length; ++i) {
                if (null == pm[i]) continue;
                pm[i].close();
            }
            if (null != conn) {
                conn.close();
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void close(Connection conn, Statement stm) throws BOSException {
        try {
            if (null != conn) {
                conn.close();
            }
            if (null != stm) {
                stm.close();
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void execBatchSql(Context ctx, ArrayList sqlList, boolean isUpdateBill) throws BOSException {
        if (isUpdateBill || sqlList.size() >= 200) {
            DBUtil.execute(ctx, sqlList.toArray(new String[sqlList.size()]));
            sqlList.clear();
        }
    }

    public static void execBatchSql(Connection conn, ArrayList sqlList, boolean isUpdateBill) throws BOSException, SQLException {
        if (isUpdateBill || sqlList.size() >= 200) {
            DBUtil.execute(conn, sqlList.toArray(new String[sqlList.size()]));
            sqlList.clear();
        }
    }

    public static void execute(Connection conn, String[] sql) throws BOSException, SQLException {
        Statement statement = null;
        StringBuffer sqlstr = new StringBuffer();
        try {
            statement = conn.createStatement();
            if (sql != null) {
                for (int i = 0; i < sql.length; ++i) {
                    statement.addBatch(sql[i]);
                    sqlstr.append(sql[i]).append(NEWLINE);
                }
            }
            statement.executeBatch();
        }
        catch (SQLException e) {
            throw new SQLException(e + EASResource.getString((String)"com.kingdee.eas.scm.sd.sale.SALEAutoGenerateResource", (String)"59_DBUtil") + sqlstr.toString());
        }
        finally {
            if (statement != null) {
                statement.clearBatch();
                statement.close();
            }
        }
    }

    public static void createTempTableIndex(Context ctx, String tableName, String columns, boolean isUnique) throws BOSException {
        DBUtil.createTempTableIndex(ctx, tableName, columns, isUnique, false);
    }

    public static void createTempTableIndex(Context ctx, String tableName, String columns, boolean isUnique, boolean isClustered) throws BOSException {
        try {
            TempTablePool tmpPool = TempTablePool.getInstance((Context)ctx);
            tmpPool.createIndex(tableName, columns, isUnique, isClustered);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void execute(Connection conn, String sql) throws BOSException, SQLException {
        Statement statement = null;
        StringBuffer sqlstr = new StringBuffer();
        try {
            statement = conn.createStatement();
            statement.execute(sql);
        }
        catch (SQLException e) {
            throw new SQLException(e + "SQL:" + sqlstr.toString());
        }
        finally {
            if (statement != null) {
                statement.clearBatch();
                statement.close();
            }
        }
    }

    public static Object takeValue(Connection conn, String sql) throws BOSException {
        ResultSet rs;
        PreparedStatement stmt;
        block6: {
            Object object;
            block5: {
                stmt = null;
                rs = null;
                stmt = conn.prepareStatement(sql);
                rs = stmt.executeQuery();
                if (rs != null) break block5;
                Object var4_4 = null;
                SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
                return var4_4;
            }
            try {
                if (!rs.next()) break block6;
                object = rs.getObject(1);
            }
            catch (SQLException ex) {
                try {
                    throw new BOSException("Sql execute exception : " + sql, (Throwable)ex);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, (Statement)stmt);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            return object;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        return null;
    }

    public static String createTempTable(Context ctx, String sql) throws BOSException {
        TempTablePool tmpPool = TempTablePool.getInstance((Context)ctx);
        try {
            return tmpPool.createTempTable(sql);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void AnalyseTable(Context ctx, Connection con, String table) throws SQLException {
        TempTablePool.getInstance((Context)ctx).analyzeTable(con, table);
    }
}

