/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupFactory;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupInfo;
import com.kingdee.eas.basedata.master.cssp.ICSSPGroup;
import com.kingdee.eas.basedata.master.material.IMaterialGroup;
import com.kingdee.eas.basedata.master.material.MaterialGroupFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.PriceCompDetailEnum;
import com.kingdee.eas.basedata.scm.sd.sale.IPricePolicyEntry;
import com.kingdee.eas.basedata.scm.sd.sale.PriceCompositionInfo;
import com.kingdee.eas.basedata.scm.sd.sale.PricePolicyEntryCollection;
import com.kingdee.eas.basedata.scm.sd.sale.PricePolicyEntryFactory;
import com.kingdee.eas.basedata.scm.sd.sale.PricePolicyEntryInfo;
import com.kingdee.eas.basedata.scm.sd.sale.PricePolicyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.sd.sale.IPricePolicyAdjust;
import com.kingdee.eas.scm.sd.sale.PricePolicyAdjustFactory;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;

public class PricePolicyAdjustUtil {
    public static final String KEY_STARTDATE = "startDate";
    public static final String KEY_ENDDATE = "endDate";
    private static final String true_str = "1";

    public boolean checkBusiEntryOnlyOne(Context ctx, PricePolicyInfo info, PricePolicyEntryInfo entryInfo) throws BOSException, EASBizException {
        boolean isExistEntryInfo = false;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItemInfo = null;
        if (info.getId() != null) {
            filterItemInfo = new FilterItemInfo("parent", (Object)info.getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItemInfo);
        }
        String customer = null;
        String material = null;
        String customerGroup = null;
        String materialGroup = null;
        String priceType = null;
        String measureUnit = null;
        String asistProperty = null;
        String currency = null;
        int discountCondition = -1;
        int discountMode = -1;
        BigDecimal qtyMin = null;
        BigDecimal qtyMax = null;
        BigDecimal amtMin = null;
        BigDecimal amtMax = null;
        Date effectiveDate = null;
        Date expireDate = null;
        if (entryInfo.getCustomer() != null) {
            customer = entryInfo.getCustomer().getId().toString();
        }
        if (entryInfo.getMaterial() != null) {
            material = entryInfo.getMaterial().getId().toString();
        }
        if (entryInfo.getCustomerGroup() != null) {
            customerGroup = entryInfo.getCustomerGroup().getId().toString();
        }
        if (entryInfo.getMaterialGroup() != null) {
            materialGroup = entryInfo.getMaterialGroup().getId().toString();
        }
        if (entryInfo.getPriceType() != null) {
            priceType = entryInfo.getPriceType().getId().toString();
        }
        if (entryInfo.getDiscountCondition() != null) {
            discountCondition = entryInfo.getDiscountCondition().getValue();
        }
        if (entryInfo.getDiscountMode() != null) {
            discountMode = entryInfo.getDiscountMode().getValue();
        }
        if (entryInfo.getMeasureUnit() != null) {
            measureUnit = entryInfo.getMeasureUnit().getId().toString();
        }
        if (entryInfo.getAsistProperty() != null) {
            asistProperty = entryInfo.getAsistProperty().getId().toString();
        }
        if (entryInfo.getCurrency() != null) {
            currency = entryInfo.getCurrency().getId().toString();
        }
        if (entryInfo.getQtyMin() != null) {
            qtyMin = entryInfo.getQtyMin();
        }
        if (entryInfo.getQtyMax() != null) {
            qtyMax = entryInfo.getQtyMax();
        }
        if (entryInfo.getAmtMin() != null) {
            amtMin = entryInfo.getAmtMin();
        }
        if (entryInfo.getAmtMax() != null) {
            amtMax = entryInfo.getAmtMax();
        }
        if (entryInfo.getEffectiveDate() != null) {
            effectiveDate = entryInfo.getEffectiveDate();
        }
        if (entryInfo.getExpireDate() != null) {
            expireDate = entryInfo.getExpireDate();
        }
        switch (info.getPriceComposition().getValue()) {
            case 1: {
                filterItemInfo = new FilterItemInfo("customerGroup.id", (Object)customerGroup, CompareType.EQUALS);
                filter.getFilterItems().add(filterItemInfo);
                filterItemInfo = new FilterItemInfo("material.id", (Object)material, CompareType.EQUALS);
                filter.getFilterItems().add(filterItemInfo);
                filterItemInfo = new FilterItemInfo("measureUnit.id", (Object)measureUnit, CompareType.EQUALS);
                filter.getFilterItems().add(filterItemInfo);
                filterItemInfo = new FilterItemInfo("asistProperty.id", (Object)asistProperty, CompareType.EQUALS);
                filter.getFilterItems().add(filterItemInfo);
                break;
            }
            case 9: {
                filterItemInfo = new FilterItemInfo("material.id", (Object)material, CompareType.EQUALS);
                filter.getFilterItems().add(filterItemInfo);
                filterItemInfo = new FilterItemInfo("customerGroup.id", (Object)customerGroup, CompareType.EQUALS);
                filter.getFilterItems().add(filterItemInfo);
                filterItemInfo = new FilterItemInfo("measureUnit.id", (Object)measureUnit, CompareType.EQUALS);
                filter.getFilterItems().add(filterItemInfo);
                filterItemInfo = new FilterItemInfo("asistProperty.id", (Object)asistProperty, CompareType.EQUALS);
                filter.getFilterItems().add(filterItemInfo);
                break;
            }
            case 2: {
                filterItemInfo = new FilterItemInfo("material.id", (Object)material, CompareType.EQUALS);
                filter.getFilterItems().add(filterItemInfo);
                filterItemInfo = new FilterItemInfo("customer.id", (Object)customer, CompareType.EQUALS);
                filter.getFilterItems().add(filterItemInfo);
                filterItemInfo = new FilterItemInfo("measureUnit.id", (Object)measureUnit, CompareType.EQUALS);
                filter.getFilterItems().add(filterItemInfo);
                filterItemInfo = new FilterItemInfo("asistProperty.id", (Object)asistProperty, CompareType.EQUALS);
                filter.getFilterItems().add(filterItemInfo);
                break;
            }
            case 7: {
                filterItemInfo = new FilterItemInfo("material.id", (Object)material, CompareType.EQUALS);
                filter.getFilterItems().add(filterItemInfo);
                filterItemInfo = new FilterItemInfo("customer.id", (Object)customer, CompareType.EQUALS);
                filter.getFilterItems().add(filterItemInfo);
                filterItemInfo = new FilterItemInfo("measureUnit.id", (Object)measureUnit, CompareType.EQUALS);
                filter.getFilterItems().add(filterItemInfo);
                filterItemInfo = new FilterItemInfo("asistProperty.id", (Object)asistProperty, CompareType.EQUALS);
                filter.getFilterItems().add(filterItemInfo);
                break;
            }
            case 5: {
                filterItemInfo = new FilterItemInfo("customer.id", (Object)customer, CompareType.EQUALS);
                filter.getFilterItems().add(filterItemInfo);
                filterItemInfo = new FilterItemInfo("materialGroup.id", (Object)materialGroup, CompareType.EQUALS);
                filter.getFilterItems().add(filterItemInfo);
                break;
            }
            case 8: {
                filterItemInfo = new FilterItemInfo("materialGroup.id", (Object)materialGroup, CompareType.EQUALS);
                filter.getFilterItems().add(filterItemInfo);
                filterItemInfo = new FilterItemInfo("customer.id", (Object)customer, CompareType.EQUALS);
                filter.getFilterItems().add(filterItemInfo);
                break;
            }
            case 6: {
                filterItemInfo = new FilterItemInfo("customerGroup.id", (Object)customerGroup, CompareType.EQUALS);
                filter.getFilterItems().add(filterItemInfo);
                filterItemInfo = new FilterItemInfo("materialGroup.id", (Object)materialGroup, CompareType.EQUALS);
                filter.getFilterItems().add(filterItemInfo);
                break;
            }
            case 10: {
                filterItemInfo = new FilterItemInfo("customerGroup.id", (Object)customerGroup, CompareType.EQUALS);
                filter.getFilterItems().add(filterItemInfo);
                filterItemInfo = new FilterItemInfo("materialGroup.id", (Object)materialGroup, CompareType.EQUALS);
                filter.getFilterItems().add(filterItemInfo);
            }
        }
        filterItemInfo = new FilterItemInfo("priceType", (Object)priceType, CompareType.EQUALS);
        filter.getFilterItems().add(filterItemInfo);
        filterItemInfo = new FilterItemInfo("currency.id", (Object)currency, CompareType.EQUALS);
        filter.getFilterItems().add(filterItemInfo);
        filterItemInfo = new FilterItemInfo("discountCondition", (Object)new Integer(discountCondition), CompareType.EQUALS);
        filter.getFilterItems().add(filterItemInfo);
        filterItemInfo = new FilterItemInfo("discountMode", (Object)new Integer(discountMode), CompareType.EQUALS);
        filter.getFilterItems().add(filterItemInfo);
        filterItemInfo = new FilterItemInfo("qtyMin", (Object)qtyMin, CompareType.EQUALS);
        filter.getFilterItems().add(filterItemInfo);
        filterItemInfo = new FilterItemInfo("qtyMax", (Object)qtyMax, CompareType.EQUALS);
        filter.getFilterItems().add(filterItemInfo);
        filterItemInfo = new FilterItemInfo("amtMin", (Object)amtMin, CompareType.EQUALS);
        filter.getFilterItems().add(filterItemInfo);
        filterItemInfo = new FilterItemInfo("amtMax", (Object)amtMax, CompareType.EQUALS);
        filter.getFilterItems().add(filterItemInfo);
        if (effectiveDate != null) {
            filterItemInfo = new FilterItemInfo("effectiveDate", (Object)this.getFilterDate(effectiveDate, KEY_STARTDATE), CompareType.GREATER_EQUALS);
            filter.getFilterItems().add(filterItemInfo);
            filterItemInfo = new FilterItemInfo("effectiveDate", (Object)this.getFilterDate(effectiveDate, KEY_ENDDATE), CompareType.LESS_EQUALS);
            filter.getFilterItems().add(filterItemInfo);
        }
        if (expireDate != null) {
            filterItemInfo = new FilterItemInfo("expireDate", (Object)this.getFilterDate(expireDate, KEY_STARTDATE), CompareType.GREATER_EQUALS);
            filter.getFilterItems().add(filterItemInfo);
            filterItemInfo = new FilterItemInfo("expireDate", (Object)this.getFilterDate(expireDate, KEY_ENDDATE), CompareType.LESS_EQUALS);
            filter.getFilterItems().add(filterItemInfo);
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filter);
        PricePolicyEntryCollection collection = PricePolicyEntryFactory.getLocalInstance((Context)ctx).getPricePolicyEntryCollection(entityViewInfo);
        if (collection != null && collection.size() > 0) {
            PricePolicyEntryInfo tempInfo = collection.get(0);
            if (tempInfo != null) {
                isExistEntryInfo = true;
                entryInfo.setId(tempInfo.getId());
            } else {
                isExistEntryInfo = false;
            }
        } else {
            isExistEntryInfo = false;
        }
        return !isExistEntryInfo;
    }

    public String getFilterDate(Date d, String s) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(d);
        if (s.equalsIgnoreCase(KEY_STARTDATE)) {
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        } else if (s.equalsIgnoreCase(KEY_ENDDATE)) {
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5) + 1, 0, 0, 0);
        }
        return DateTimeUtils.format((Date)calendar.getTime(), (String)"yyyy-MM-dd HH:mm:ss");
    }

    public PricePolicyEntryCollection getPriceEntrys(Context ctx, PriceCompDetailEnum priceCompDetail, PriceCompositionInfo priceCompositionInfo, Map params) throws BOSException, EASBizException {
        PriceCompDetailEnum detailEnumInfo;
        SorterItemInfo sort;
        FilterInfo tmpFilter;
        PricePolicyEntryCollection collection = null;
        ICSSPGroup icsspgroup = CSSPGroupFactory.getRemoteInstance();
        IPricePolicyAdjust ippa = PricePolicyAdjustFactory.getRemoteInstance();
        IMaterialGroup imaterialgroup = MaterialGroupFactory.getRemoteInstance();
        IPricePolicyEntry ipriceentry = PricePolicyEntryFactory.getRemoteInstance();
        String databaseid = null;
        boolean isIncluded = (Boolean)params.get("isincluded");
        String csspgroupstandardid = params.get("customergroupStandardId").toString();
        EntityViewInfo view = new EntityViewInfo();
        if (isIncluded) {
            databaseid = priceCompositionInfo.getId();
            if (PriceCompDetailEnum.CUSTOMER.equals((Object)priceCompDetail)) {
                tmpFilter = new FilterInfo();
                boolean isgroup = priceCompositionInfo.isCustomerGroup();
                if (params.get("saleorgid") instanceof SaleOrgUnitInfo) {
                    if (isgroup) {
                        String customerids = ippa.getCustomerIds(databaseid, csspgroupstandardid, (SaleOrgUnitInfo)params.get("saleorgid"));
                        if (!customerids.equals("")) {
                            tmpFilter.getFilterItems().add(new FilterItemInfo("customer.id", (Object)customerids, CompareType.INNER));
                        } else {
                            tmpFilter.getFilterItems().add(new FilterItemInfo("id", null, CompareType.EQUALS));
                        }
                    } else {
                        tmpFilter.getFilterItems().add(new FilterItemInfo("customer.id", (Object)databaseid, CompareType.EQUALS));
                    }
                    view.setFilter(tmpFilter);
                }
            } else if (PriceCompDetailEnum.CUSTOMERGROUP.equals((Object)priceCompDetail)) {
                tmpFilter = new FilterInfo();
                if (databaseid != null) {
                    CSSPGroupInfo groupInfo = icsspgroup.getCSSPGroupInfo((IObjectPK)new ObjectStringPK(databaseid));
                    tmpFilter.getFilterItems().add(new FilterItemInfo("customerGroup.longnumber", (Object)(groupInfo.getLongNumber() + "%"), CompareType.LIKE));
                } else {
                    tmpFilter.getFilterItems().add(new FilterItemInfo("customerGroup.longnumber", (Object)"%", CompareType.LIKE));
                }
                view.setFilter(tmpFilter);
            } else if (PriceCompDetailEnum.MATERIAL.equals((Object)priceCompDetail)) {
                tmpFilter = new FilterInfo();
                boolean isgroup = priceCompositionInfo.isCustomerGroup();
                if (params.get("saleorgid") instanceof SaleOrgUnitInfo) {
                    if (isgroup) {
                        String materialids = ippa.getMaterialIds(databaseid, null, (SaleOrgUnitInfo)params.get("saleorgid"));
                        if (!materialids.equals("")) {
                            tmpFilter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialids, CompareType.INNER));
                        } else {
                            tmpFilter.getFilterItems().add(new FilterItemInfo("id", null, CompareType.EQUALS));
                        }
                    } else {
                        tmpFilter.getFilterItems().add(new FilterItemInfo("material.id", (Object)databaseid, CompareType.EQUALS));
                    }
                    view.setFilter(tmpFilter);
                }
            } else if (PriceCompDetailEnum.MATERIALGROUP.equals((Object)priceCompDetail)) {
                tmpFilter = new FilterInfo();
                if (databaseid != null) {
                    MaterialGroupInfo groupInfo = imaterialgroup.getMaterialGroupInfo((IObjectPK)new ObjectStringPK(databaseid));
                    tmpFilter.getFilterItems().add(new FilterItemInfo("materialGroup.longnumber", (Object)(groupInfo.getLongNumber() + "%"), CompareType.LIKE));
                } else {
                    tmpFilter.getFilterItems().add(new FilterItemInfo("materialGroup.longnumber", (Object)"%", CompareType.LIKE));
                }
                view.setFilter(tmpFilter);
            }
        } else {
            databaseid = priceCompositionInfo.getId();
            if (PriceCompDetailEnum.CUSTOMER.equals((Object)priceCompDetail)) {
                tmpFilter = new FilterInfo();
                tmpFilter.getFilterItems().add(new FilterItemInfo("customer.id", (Object)databaseid, CompareType.EQUALS));
                view.setFilter(tmpFilter);
            } else if (PriceCompDetailEnum.CUSTOMERGROUP.equals((Object)priceCompDetail)) {
                tmpFilter = new FilterInfo();
                tmpFilter.getFilterItems().add(new FilterItemInfo("customerGroup.id", (Object)databaseid, CompareType.EQUALS));
                view.setFilter(tmpFilter);
            } else if (PriceCompDetailEnum.MATERIAL.equals((Object)priceCompDetail)) {
                tmpFilter = new FilterInfo();
                tmpFilter.getFilterItems().add(new FilterItemInfo("material.id", (Object)databaseid, CompareType.EQUALS));
                view.setFilter(tmpFilter);
            } else if (PriceCompDetailEnum.MATERIALGROUP.equals((Object)priceCompDetail)) {
                tmpFilter = new FilterInfo();
                tmpFilter.getFilterItems().add(new FilterItemInfo("materialGroup.id", (Object)databaseid, CompareType.EQUALS));
                view.setFilter(tmpFilter);
            }
        }
        String pricepolicyid = null;
        if (params.get("pricepolicyid") != null) {
            pricepolicyid = params.get("pricepolicyid").toString();
        }
        view.getFilter().getFilterItems().add(new FilterItemInfo("parent.id", (Object)pricepolicyid, CompareType.EQUALS));
        if (params.get("pricepolicy_customercomp") instanceof PriceCompDetailEnum && (sort = this.getSortItemInfo(detailEnumInfo = (PriceCompDetailEnum)params.get("pricepolicy_customercomp"))) != null) {
            view.getSorter().add(sort);
        }
        if (params.get("pricepolicy_materialcomp") instanceof PriceCompDetailEnum && (sort = this.getSortItemInfo(detailEnumInfo = (PriceCompDetailEnum)params.get("pricepolicy_materialcomp"))) != null) {
            view.getSorter().add(sort);
        }
        collection = this.getPricePolicyEntryCollection(ipriceentry, view);
        return collection;
    }

    private PricePolicyEntryCollection getPricePolicyEntryCollection(IPricePolicyEntry ipriceentry, EntityViewInfo view) throws BOSException, EASBizException {
        PricePolicyEntryCollection collection = null;
        view.getSelector().add(new SelectorItemInfo("*"));
        view.getSelector().add(new SelectorItemInfo("priceType.number"));
        view.getSelector().add(new SelectorItemInfo("priceType.name"));
        view.getSelector().add(new SelectorItemInfo("material.*"));
        view.getSelector().add(new SelectorItemInfo("currency.*"));
        view.getSelector().add(new SelectorItemInfo("measureUnit.number"));
        view.getSelector().add(new SelectorItemInfo("measureUnit.name"));
        view.getSelector().add(new SelectorItemInfo("customerGroup.number"));
        view.getSelector().add(new SelectorItemInfo("customerGroup.name"));
        view.getSelector().add(new SelectorItemInfo("customer.number"));
        view.getSelector().add(new SelectorItemInfo("customer.name"));
        view.getSelector().add(new SelectorItemInfo("materialGroup.number"));
        view.getSelector().add(new SelectorItemInfo("materialGroup.name"));
        view.getSelector().add(new SelectorItemInfo("asistProperty.number"));
        view.getSelector().add(new SelectorItemInfo("asistProperty.name"));
        collection = ipriceentry.getPricePolicyEntryCollection(view);
        return collection;
    }

    private SorterItemInfo getSortItemInfo(PriceCompDetailEnum detailEnumInfo) {
        SorterItemInfo sort = null;
        switch (detailEnumInfo.getValue()) {
            case 1: {
                sort = new SorterItemInfo("customer.number");
                sort.setSortType(SortType.ASCEND);
                break;
            }
            case 2: {
                sort = new SorterItemInfo("customerGroup.number");
                sort.setSortType(SortType.ASCEND);
                break;
            }
            case 4: {
                sort = new SorterItemInfo("materialGroup.number");
                sort.setSortType(SortType.ASCEND);
                break;
            }
            case 3: {
                sort = new SorterItemInfo("material.number");
                sort.setSortType(SortType.ASCEND);
            }
        }
        return sort;
    }
}

