/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.vrule.app.postreq;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.credit.app.processor.CreditUpdateHelper;
import com.kingdee.eas.scm.framework.dataloader.IDataCache;
import com.kingdee.eas.scm.framework.validator.IVRule;
import com.kingdee.eas.scm.sd.sale.PostRequisitionException;
import com.kingdee.eas.scm.sd.sale.PostRequisitionInfo;
import com.kingdee.jdbc.rowset.IRowSet;

public class CheckPostRequisitionValidVRule
implements IVRule {
    Context ctx = null;

    public CheckPostRequisitionValidVRule(Context ctx) {
        this.ctx = ctx;
    }

    public void setInjectData(IDataCache dataCache) {
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return PostRequisitionInfo.class.isAssignableFrom(clazz);
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        assert (bean != null);
        PostRequisitionInfo postRequisitionInfo = (PostRequisitionInfo)bean;
        this.checkPostRequisitionValid(postRequisitionInfo);
        IRowSet rs = null;
        if (postRequisitionInfo.getId() != null) {
            ObjectUuidPK pk = new ObjectUuidPK(postRequisitionInfo.getId().toString());
            rs = CreditUpdateHelper.getPreUpdateData((Context)this.ctx, (Object[])new Object[]{pk});
        }
        postRequisitionInfo.put("CreditUpdateData", rs);
    }

    private void checkPostRequisitionValid(PostRequisitionInfo postRequisitionInfo) throws PostRequisitionException {
        StringBuffer errorStr = new StringBuffer();
        boolean isError = false;
        if (postRequisitionInfo.getBizType() == null) {
            errorStr.append(SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"POST_FIELD_BIZTYPE", (Context)this.ctx));
            isError = true;
        }
        if (postRequisitionInfo.getStorageOrgUnit() == null) {
            if (isError) {
                errorStr.append(",");
            }
            errorStr.append(SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"POST_FIELD_DELIVERYORG", (Context)this.ctx));
            isError = true;
        }
        if (postRequisitionInfo.getSaleOrgUnit() == null) {
            if (isError) {
                errorStr.append(",");
            }
            errorStr.append(SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"POST_FIELD_SALEORG", (Context)this.ctx));
            isError = true;
        }
        if (isError) {
            throw new PostRequisitionException(PostRequisitionException.FIELD_NOTEMPTY, new String[]{errorStr.toString()});
        }
    }
}

