/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.vrule.app.postreq;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.dataloader.IDataCache;
import com.kingdee.eas.scm.framework.validator.IVRule;
import com.kingdee.eas.scm.sd.sale.PostRequisitionException;
import com.kingdee.eas.scm.sd.sale.PostRequisitionInfo;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class CheckReverseBillUnAuditVRule
implements IVRule {
    Context ctx = null;

    public CheckReverseBillUnAuditVRule(Context ctx) {
        this.ctx = ctx;
    }

    public void setInjectData(IDataCache dataCache) {
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return PostRequisitionInfo.class.isAssignableFrom(clazz);
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        assert (bean != null);
        PostRequisitionInfo postRequisitionInfo = (PostRequisitionInfo)bean;
        this.isReverseBillUnAudit((IObjectValue)postRequisitionInfo);
    }

    private void isReverseBillUnAudit(IObjectValue model) throws BOSException, EASBizException {
        PostRequisitionInfo info = (PostRequisitionInfo)model;
        String id = info.getId().toString();
        Connection con = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection(this.ctx);
            stmt = con.createStatement();
            String selectSql = new StringBuffer().append("select pre.FID, pre.FSeq, pr.FNumber ").append(" from T_SD_PostRequisitionEntry pre ").append(" inner join T_SD_PostRequisition pr on pr.FID = pre.FParentID ").append(" inner join T_SD_PostRequisitionEntry pre2 on pre2.FID = pre.FSourceBillEntryId ").append(" inner join T_SD_SaleOrderEntry soe on soe.FID = pre2.FSourceBillEntryId ").append(" where pre.FParentID in('").append(id).append("') ").append(" and pr.FIsReverse = 1 and soe.FQuantityUnCtrl = 0 and (soe.FQty - soe.FTotalReversedQty) * decimal(100.00+ISNULL(soe.FSendOverRate,0))/100.00 - soe.FTotalShippingQty < (0 - pre.FQty) ").toString();
            rs = stmt.executeQuery(selectSql);
            if (rs.next() && rs.getString("FID") != null) {
                throw new PostRequisitionException(PostRequisitionException.QTYNOTENOUGH_UNAUDIT, new String[]{rs.getString("FNumber"), String.valueOf(rs.getInt("FSeq"))});
            }
        }
        catch (SQLException er) {
            try {
                throw new BOSException("sql Execute Error :", (Throwable)er);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
    }

    protected Connection getConnection(Context ctx) throws SQLDataException {
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
    }
}

