/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.vrule.app.salereturns;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.framework.dataloader.IDataCache;
import com.kingdee.eas.scm.framework.validator.IVRule;
import com.kingdee.eas.scm.sd.sale.SaleReturnsEntryCollection;
import com.kingdee.eas.scm.sd.sale.SaleReturnsEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleReturnsInfo;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class CheckProjectTrack4SubmitVRule
implements IVRule {
    Context ctx;

    public CheckProjectTrack4SubmitVRule(Context ctx) {
        this.ctx = ctx;
    }

    public void setInjectData(IDataCache dataCache) {
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return SaleReturnsInfo.class.isAssignableFrom(clazz);
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        assert (bean != null);
        SaleReturnsInfo info = (SaleReturnsInfo)bean;
        SaleReturnsEntryCollection collection = info.getEntries();
        this.checkPT(collection, info);
    }

    private void checkPT(SaleReturnsEntryCollection collection, SaleReturnsInfo info) throws BOSException, EASBizException {
        HashSet<String> storageIDs = new HashSet<String>();
        HashSet<String> materialIDs = new HashSet<String>();
        SaleReturnsEntryInfo entryInfo = null;
        boolean isBotp = false;
        if (info.getSourceBillType() != null) {
            isBotp = true;
        }
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = collection.get(i);
            if (entryInfo != null && entryInfo.getMaterial() != null && entryInfo.getMaterial().getId() != null) {
                materialIDs.add(entryInfo.getMaterial().getId().toString());
            }
            if (entryInfo == null || entryInfo.getStorageOrgUnit() == null || entryInfo.getStorageOrgUnit().getId() == null) continue;
            storageIDs.add(entryInfo.getStorageOrgUnit().getId().toString());
        }
        Map materialPlanMap = new HashMap();
        materialPlanMap = SCMServerUtils.getMaterialPlanCollec((Context)this.ctx, materialIDs, storageIDs);
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            MaterialPlanInfo mpInfo;
            entryInfo = collection.get(i);
            if (entryInfo == null || entryInfo.getStorageOrgUnit() == null || entryInfo.getStorageOrgUnit().getId() == null || entryInfo.getMaterial() == null || entryInfo.getMaterial().getId() == null || (mpInfo = (MaterialPlanInfo)materialPlanMap.get(entryInfo.getMaterial().getId().toString() + entryInfo.getStorageOrgUnit().getId().toString())) == null) continue;
            SCMServerUtils.checkProjectTrackIsNotNull((Context)this.ctx, (boolean)isBotp, (int)(i + 1), (MaterialPlanInfo)mpInfo, (ProjectInfo)entryInfo.getProject(), (TrackNumberInfo)entryInfo.getTrackNumber());
        }
    }
}

