/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.vrule.app.so;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.framework.dataloader.IDataCache;
import com.kingdee.eas.scm.framework.validator.IVRule;
import com.kingdee.eas.scm.sd.sale.OrderException;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import com.kingdee.eas.util.app.ContextUtil;

public class CheckIsSamePerson4UnAuditVRule
implements IVRule {
    Context ctx = null;

    public CheckIsSamePerson4UnAuditVRule(Context ctx) {
        this.ctx = ctx;
    }

    public void setInjectData(IDataCache dataCache) {
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return SaleOrderInfo.class.isAssignableFrom(clazz);
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        assert (bean != null);
        SaleOrderInfo saleInfo = (SaleOrderInfo)bean;
        SCMServerUtils.checkUnAuditDetailWithoutCheckDownriver((Context)this.ctx, (SCMBillBaseInfo)saleInfo);
        this.checkDownriver(this.ctx, saleInfo);
        this.isSamePerson4UnAudit(this.ctx, saleInfo);
    }

    public void isSamePerson4UnAudit(Context ctx, SCMBillBaseInfo model) throws EASBizException, BOSException {
        String paramValue;
        UserInfo userInfo;
        String auditorID = null;
        String currentUserId = null;
        if (model.getAuditor() != null) {
            auditorID = model.getAuditor().getId().toString();
        }
        if ((userInfo = ContextUtil.getCurrentUserInfo((Context)ctx)) != null) {
            currentUserId = userInfo.getId().toString();
        }
        if ((paramValue = this.getAuditParam(ctx, model, BatchActionEnum.UNAUDIT)) != null && "true".equals(paramValue.trim()) && auditorID != null && !auditorID.equals(currentUserId)) {
            throw new SCMBillException(SCMBillException.AUDITOR_UNAUDITOR_NOTSAME);
        }
        if (paramValue != null && "1".equals(paramValue.trim()) && auditorID != null && !auditorID.equals(currentUserId)) {
            throw new SCMBillException(SCMBillException.AUDITOR_UNAUDITOR_NOTSAME);
        }
    }

    private String getAuditParam(Context ctx, SCMBillBaseInfo model, BatchActionEnum action) throws EASBizException, BOSException {
        OrgUnitInfo orgUnitInfo = this.getMainBizOrgUnit(ctx, (CoreBillBaseInfo)model);
        String paramName = action == BatchActionEnum.AUDIT ? this.getParamCon4Audit() : this.getParamCon4UnAudit();
        IParamControl ipc = ParamControlFactory.getLocalInstance((Context)ctx);
        String paramValue = null;
        if (paramName != null && orgUnitInfo != null) {
            paramValue = ipc.getParamValue((IObjectPK)new ObjectUuidPK(orgUnitInfo.getId().toString()), paramName);
        }
        return paramValue;
    }

    private OrgUnitInfo getMainBizOrgUnit(Context ctx, CoreBillBaseInfo model) {
        if (model.get(model.getBizOrgPropertyName()) != null) {
            return (OrgUnitInfo)model.get(model.getBizOrgPropertyName());
        }
        return (OrgUnitInfo)ctx.get((Object)this.getMainBizOrgType());
    }

    private String getParamCon4Audit() {
        return "SALEBILL002";
    }

    private String getParamCon4UnAudit() {
        return "SALEBILL003";
    }

    private OrgType getMainBizOrgType() {
        return OrgType.Sale;
    }

    private void checkDownriver(Context ctx, SaleOrderInfo saleInfo) throws BOSException, EASBizException {
        if (this.hasDestBill(ctx, saleInfo.getId().toString())) {
            throw new OrderException(OrderException.HAS_DOWN_BILL_INVOICE_NOT_ALL_DISCARD);
        }
    }

    private boolean hasDestBill(Context ctx, String srcId) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)srcId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)"99", CompareType.NOTEQUALS));
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        BOTRelationCollection collection = BOTRelationFactory.getLocalInstance((Context)ctx).getCollection(viewInfo);
        return collection != null && collection.size() > 0;
    }
}

