/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.vrule.app.so;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.basedata.master.material.IMaterialInventory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.dataloader.DataTypeEnum;
import com.kingdee.eas.scm.framework.validator.bizrule.app.AbstractServerVRule;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.im.inv.PurReceivalEntryInfo;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckLotAndExpiryDateVRule
extends AbstractServerVRule {
    private static final Logger logger = LoggerFactory.getLogger(CheckLotAndExpiryDateVRule.class);

    public CheckLotAndExpiryDateVRule(Context ctx) {
        super(ctx);
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return InvBillBaseInfo.class.isAssignableFrom(clazz);
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        InvBillBaseInfo invBillInfo = (InvBillBaseInfo)bean;
        if (invBillInfo == null || invBillInfo.getStorageOrgUnit() == null) {
            return;
        }
        IObjectCollection entrys = invBillInfo.getEntries();
        ArrayList<InvBillBaseEntryInfo> entryList = new ArrayList<InvBillBaseEntryInfo>();
        boolean isUpdateInv = this.isUpdateInv(invBillInfo);
        int len = entrys.size();
        for (int j = 0; j < len; ++j) {
            MaterialInventoryInfo materilInvInfo;
            InvBillBaseEntryInfo entry = (InvBillBaseEntryInfo)entrys.getObject(j);
            if (entry.getMaterial() == null || null == (materilInvInfo = this.getMaterialInventoryInfo(entry.getMaterial().getId().toString(), invBillInfo.getStorageOrgUnit().getId().toString()))) continue;
            if (isUpdateInv && materilInvInfo.isIsLotNumber() && StringUtils.isEmpty((String)entry.getLot())) {
                throw new InvBizException(InvBizException.BATCHISNULL, (Object[])new String[]{String.valueOf(j + 1)});
            }
            if (!isUpdateInv || !materilInvInfo.isIsPeriodValid()) continue;
            if (entry.getMfg() == null || entry.getExp() == null) {
                throw new InvBizException(InvBizException.MATERIAL_IS_PERIODVALID, (Object[])new String[]{String.valueOf(j + 1)});
            }
            entryList.add(entry);
        }
        int count = entryList.size();
        for (int k = 0; k < count; ++k) {
            InvBillBaseEntryInfo billEntry = (InvBillBaseEntryInfo)entryList.get(k);
            for (int z = k; z < entryList.size() - 1; ++z) {
                if (!billEntry.getLot().equals(((InvBillBaseEntryInfo)entryList.get(z)).getLot()) || !billEntry.getMaterial().getId().toString().equals(((InvBillBaseEntryInfo)entryList.get(z)).getMaterial().getId().toString()) || billEntry.getMfg().equals(((InvBillBaseEntryInfo)entryList.get(z)).getMfg()) && billEntry.getExp().equals(((InvBillBaseEntryInfo)entryList.get(z)).getExp())) continue;
                throw new InvBizException(InvBizException.DUPLICATELOTSALL, (Object[])new String[]{String.valueOf(z + 1)});
            }
        }
    }

    private MaterialInventoryInfo getMaterialInventoryInfo(String materialId, String souId) throws BOSException {
        if (this.getDataCache().contain(materialId + souId, DataTypeEnum.MATERIAL_INVENTORY)) {
            return (MaterialInventoryInfo)this.getDataCache().get(materialId + souId, DataTypeEnum.MATERIAL_INVENTORY);
        }
        if (logger.isWarnEnabled()) {
            logger.warn("\u6027\u80fd\u9690\u60a3\uff1a\u83b7\u53d6\u7269\u6599\u5e93\u5b58\u6570\u636e\u65f6\uff0c\u6ca1\u6709\u547d\u4e2d\u4e1a\u52a1\u94fe\u7f13\u5b58\u6570\u636e\u3002class.method\uff1acom.kingdee.eas.scm.im.inv.vrule.CheckLotAndExpiryDateVRule.getMaterialInventoryInfo(String, String)");
        }
        IMaterialInventory iMaterialInventory = MaterialInventoryFactory.getLocalInstance((Context)this.getCtx());
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialId));
        filter.getFilterItems().add(new FilterItemInfo("OrgUnit.id", (Object)souId));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("isLotNumber");
        selector.add("isPeriodValid");
        view.setSelector(selector);
        MaterialInventoryCollection col = iMaterialInventory.getMaterialInventoryCollection(view);
        if (null != col && col.size() > 0) {
            return col.get(0);
        }
        return null;
    }

    private boolean isUpdateInv(InvBillBaseInfo invBillInfo) {
        String billTypeID = invBillInfo.getBillType().getId().toString();
        if (!"50957179-0105-1000-e000-0157c0a812fd463ED552".equals(billTypeID)) {
            return true;
        }
        TransactionTypeInfo tti = invBillInfo.getTransactionType();
        if (tti == null) {
            return true;
        }
        PurReceivalEntryInfo entryInfo = (PurReceivalEntryInfo)invBillInfo.getEntries().getObject(0);
        return !entryInfo.getInvUpdateType().isIsNotUpdateInv();
    }
}

