/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.vrule.app.so;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.basedata.master.material.IMaterialCompanyInfo;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.dataloader.DataTypeEnum;
import com.kingdee.eas.scm.framework.validator.bizrule.app.AbstractServerVRule;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryCollection;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckMaterialCompanyVRule
extends AbstractServerVRule {
    private static final Logger logger = LoggerFactory.getLogger(CheckMaterialCompanyVRule.class);

    public CheckMaterialCompanyVRule(Context ctx) {
        super(ctx);
    }

    public CheckMaterialCompanyVRule() {
        this(null);
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return SaleOrderInfo.class.isAssignableFrom(clazz);
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        SaleOrderInfo info = (SaleOrderInfo)bean;
        SaleOrderEntryCollection entrys = info.getEntries();
        int len = entrys.size();
        for (int j = 0; j < len; ++j) {
            MaterialCompanyInfoInfo matCompany;
            SaleOrderEntryInfo entry = (SaleOrderEntryInfo)entrys.getObject(j);
            if (entry.getMaterial() == null || entry.getCompanyOrgUnit() == null || null != (matCompany = this.getMaterialCompanyInfo(entry.getMaterial().getId().toString(), entry.getCompanyOrgUnit().getId().toString()))) continue;
            throw new InvBizException(InvBizException.MATERIALNOTFI, new Object[]{entry.getMaterial().getNumber()});
        }
    }

    private MaterialCompanyInfoInfo getMaterialCompanyInfo(String materialId, String couId) throws BOSException {
        if (this.getDataCache().contain(materialId + couId, DataTypeEnum.MATERIAL_COMPANY)) {
            return (MaterialCompanyInfoInfo)this.getDataCache().get(materialId + couId, DataTypeEnum.MATERIAL_COMPANY);
        }
        if (logger.isWarnEnabled()) {
            logger.warn("\u6027\u80fd\u9690\u60a3\uff1a\u83b7\u53d6\u7269\u6599\u7684\u8d22\u52a1\u9875\u7b7e\u6ca1\u6709\u547d\u4e2d\u4e1a\u52a1\u94fe\u7f13\u5b58\u3002class.method:com.kingdee.eas.scm.im.inv.vrule.CheckMaterialCompanyVRule.getMaterialCompanyInfo(String, String)");
        }
        IMaterialCompanyInfo iMaterialCompany = MaterialCompanyInfoFactory.getLocalInstance((Context)this.getCtx());
        EntityViewInfo entityView = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("mateial.id", (Object)materialId));
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)couId));
        entityView.setFilter(filterInfo);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("*");
        entityView.setSelector(selector);
        MaterialCompanyInfoCollection col = iMaterialCompany.getMaterialCompanyInfoCollection(entityView);
        MaterialCompanyInfoInfo info = null;
        if (col != null && col.size() > 0) {
            info = col.get(0);
        }
        this.getDataCache().put(materialId + couId, (Object)info, DataTypeEnum.MATERIAL_COMPANY);
        return info;
    }
}

