/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.vrule.app.so;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.scm.framework.dataloader.IDataCache;
import com.kingdee.eas.scm.framework.validator.IVRule;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryCollection;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;

public class CheckQtyAndBaseqtyVRule
implements IVRule {
    public boolean supports(Class<? extends IObjectValue> clazz) {
        return SaleOrderInfo.class.isAssignableFrom(clazz);
    }

    public void setInjectData(IDataCache dataCache) {
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        SaleOrderInfo info = (SaleOrderInfo)bean;
        SaleOrderEntryCollection entrys = info.getEntries();
        int len = entrys.size();
        for (int j = 0; j < len; ++j) {
            SaleOrderEntryInfo entry = (SaleOrderEntryInfo)entrys.getObject(j);
            if (entry == null || entry.getUnit() == null || entry.getBaseUnit() == null) continue;
            if (entry.getUnit().getId().toString().equals(entry.getBaseUnit().getId().toString()) && entry.getQty().compareTo(entry.getBaseQty()) != 0) {
                throw new InvBizException(InvBizException.BASEQTYNOTMATCH, new Object[]{"", String.valueOf(j + 1)});
            }
            if (entry.getQty() == null || SysConstant.BIGZERO.compareTo(entry.getQty()) == 0 || entry.getBaseQty() != null && entry.getBaseQty().compareTo(SysConstant.BIGZERO) != 0) continue;
            throw new InvBizException(InvBizException.BASEQTYNULL, new Object[]{String.valueOf(j + 1)});
        }
    }
}

