/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.app.bizprocess.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.master.material.IMaterialSales;
import com.kingdee.eas.basedata.master.material.MaterialSalesCollection;
import com.kingdee.eas.basedata.master.material.MaterialSalesFactory;
import com.kingdee.eas.basedata.master.material.MaterialSalesInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.ProcessorExecutionModeEnum;
import com.kingdee.eas.dynbusiness.TransactionModeEnum;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.app.bizprocess.processor.SCMCommonDataLoadorProcessor;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryCollection;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SaleCommonDataLoadorProcessor
extends SCMCommonDataLoadorProcessor {
    private static final String[] params = new String[]{"SALEORDER001", "SALEORDER002", "SALEORDER004", "SALEORDER100", "SALEORDER006", "SALEORDER007", "SALEBILL001", "SALEORDER008", "SCM_SD_CHECK_RECEIVED_WHILE_POST_ORDER", "SALEORDERSEL001"};

    public SaleCommonDataLoadorProcessor(ExecuteContext executeContext, ProcessorExecutionModeEnum executeMode, Conditions conditions, TransactionModeEnum transactionMode) {
        super(executeContext, executeMode, conditions, transactionMode);
    }

    public SaleCommonDataLoadorProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        super.doProcessing(batchResults);
        if (batchResults == null) {
            return;
        }
        IObjectCollection collection = batchResults.getObjCollection();
        if (collection == null || collection.size() <= 0) {
            return;
        }
        int size = collection.size();
        SaleOrderInfo saleOrderInfo = null;
        HashMap<String, String> saleOrgMap = new HashMap<String, String>();
        HashMap<String, HashMap> saleOrgParamsMap = new HashMap<String, HashMap>();
        HashSet<String> saleOrgIdSet = new HashSet<String>();
        HashSet<String> materialIdSet = new HashSet<String>();
        for (int i = 0; i < size; ++i) {
            IObjectValue vo = collection.getObject(i);
            saleOrderInfo = (SaleOrderInfo)vo;
            if (saleOrderInfo.getSaleOrgUnit() != null && saleOrderInfo.getSaleOrgUnit().getId() != null) {
                String saleOrgUnitId = saleOrderInfo.getSaleOrgUnit().getId().toString();
                saleOrgMap.put(saleOrgUnitId, saleOrgUnitId);
                saleOrgIdSet.add(saleOrgUnitId);
            }
            SaleOrderEntryCollection entryCol = saleOrderInfo.getEntries();
            int entrySize = entryCol.size();
            for (int j = 0; j < entrySize; ++j) {
                SaleOrderEntryInfo entryInfo = entryCol.get(0);
                if (entryInfo.getMaterial() == null || entryInfo.getMaterial().getId() == null) continue;
                materialIdSet.add(entryInfo.getMaterial().getId().toString());
            }
        }
        Map materialSalesMap = this.getMaterialSaleInfos(materialIdSet, saleOrgIdSet);
        for (String key : saleOrgMap.keySet()) {
            HashMap paramsMap = ParamControlFactory.getLocalInstance((Context)this.ctx).getParamHashMap(params, key);
            saleOrgParamsMap.put(key, paramsMap);
        }
        ExecuteContext executeContext = this.getExecuteContext();
        if (executeContext != null) {
            Context context = executeContext.getContext();
            context.put((Object)"saleOrgParamsMap", saleOrgParamsMap);
            context.put((Object)"materialSalesMap", (Object)materialSalesMap);
        }
    }

    public Map getMaterialSaleInfos(Set mateiralIDs, Set orgIds) throws BOSException {
        if (mateiralIDs.size() < 1 || orgIds.size() < 1) {
            return null;
        }
        HashMap<String, MaterialSalesInfo> map = new HashMap<String, MaterialSalesInfo>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)mateiralIDs, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgIds, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.isSaleOrgUnit", (Object)new Integer(1), CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2");
        view.setFilter(filter);
        IMaterialSales ie = MaterialSalesFactory.getLocalInstance((Context)this.ctx);
        MaterialSalesCollection coll = ie.getMaterialSalesCollection(view);
        MaterialSalesInfo ms = null;
        for (int i = 0; i < coll.size(); ++i) {
            ms = coll.get(i);
            if (ms == null || ms.getMaterial() == null || ms.getOrgUnit() == null) continue;
            map.put(ms.getMaterial().getId().toString() + ms.getOrgUnit().getId().toString(), ms);
        }
        return map;
    }

    protected String getEntryName() {
        return "entries";
    }
}

