/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.app.bizprocess.processor.postrequisition;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.dynbusiness.ProcessorExecutionModeEnum;
import com.kingdee.eas.dynbusiness.TransactionModeEnum;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.app.bizprocess.processor.SCMDefaultValueProcessor;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sd.sale.PostRequisitionEntryCollection;
import com.kingdee.eas.scm.sd.sale.PostRequisitionEntryInfo;
import com.kingdee.eas.scm.sd.sale.PostRequisitionInfo;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class PRDefaultValueProcessor
extends SCMDefaultValueProcessor {
    private static final long serialVersionUID = -6770990682654095348L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sd.sale.app.bizprocess.processor.postrequisition.PRDefaultValueProcessor");

    public PRDefaultValueProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public PRDefaultValueProcessor(ExecuteContext executeContext, ProcessorExecutionModeEnum executeMode, Conditions conditions, TransactionModeEnum transactionMode) {
        super(executeContext, executeMode, conditions, transactionMode);
    }

    public PRDefaultValueProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    protected BillTypeInfo getBillType() {
        BillTypeInfo info = new BillTypeInfo();
        info.setId(BOSUuid.read((String)"510b6503-0105-1000-e000-011bc0a812fd463ED552"));
        info.setNumber("320");
        return info;
    }

    protected CompanyOrgUnitInfo getCompanyOrgUnit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            return null;
        }
        PostRequisitionInfo info = (PostRequisitionInfo)model;
        return info.getCompanyOrgUnit();
    }

    protected String getEntryName() {
        return "entries";
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        super.doProcessing(batchResults);
        if (BatchActionEnum.SAVE.equals((Object)this.batchAction)) {
            this.setDefaultValue4Save(batchResults);
        } else if (BatchActionEnum.SUBMIT.equals((Object)this.batchAction)) {
            this.setDefaultValue4Submit(batchResults);
        }
    }

    private void setDefaultValue4Save(BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectCollection objCol = batchResults.getObjCollection();
        int size = objCol.size();
        for (int i = 0; i < size; ++i) {
            IObjectValue objVal = objCol.getObject(i);
            this.setDefaultValue4Save(objVal);
        }
    }

    private void setDefaultValue4Save(IObjectValue model) throws EASBizException {
        PostRequisitionEntryCollection entries;
        PostRequisitionInfo postRequisitionInfo = (PostRequisitionInfo)model;
        if (postRequisitionInfo.getBillType() == null) {
            BillTypeInfo aBillTypeInfo = new BillTypeInfo();
            aBillTypeInfo.setId(BOSUuid.read((String)"510b6503-0105-1000-e000-011bc0a812fd463ED552"));
            postRequisitionInfo.setBillType(aBillTypeInfo);
        }
        if ((entries = postRequisitionInfo.getEntries()).size() == 0) {
            throw new SCMBillException(SCMBillException.ENTRY_IS_NULL, new Object[]{postRequisitionInfo.getNumber()});
        }
        if (postRequisitionInfo != null && entries != null) {
            int n = entries.size();
            for (int i = 0; i < n; ++i) {
                PostRequisitionEntryInfo postRequisitionEntryInfo = entries.get(i);
                postRequisitionEntryInfo.setBaseStatus(EntryBaseStatusEnum.TEMPORARILYSAVED);
                this.setZero(postRequisitionEntryInfo);
            }
        }
    }

    private void setZero(PostRequisitionEntryInfo entry) {
        String[] fields = new String[]{"price", "qty", "baseQty", "associateQty", "isPresent", "amount", "localAmount", "shippedQty", "totalShippingQty", "planDeliveryQty", "totalReversedBaseQty", "totalReversedQty", "shippedBaseQty", "unShippedQty"};
        this.setBigDecimalZeros(entry, fields);
    }

    private void setBigDecimalZeros(PostRequisitionEntryInfo entry, String[] fields) {
        Object[] zeros = new BigDecimal[]{SCMConstant.BIGDECIMAL_ZERO};
        try {
            int length = fields.length;
            for (int i = 0; i < length; ++i) {
                String getMethodName = "get" + fields[i].substring(0, 1).toUpperCase() + fields[i].substring(1);
                String setMethodName = "set" + fields[i].substring(0, 1).toUpperCase() + fields[i].substring(1);
                Method getMethod = PostRequisitionEntryInfo.class.getMethod(getMethodName, null);
                Method setMethod = PostRequisitionEntryInfo.class.getMethod(setMethodName, BigDecimal.class);
                if (getMethod == null || getMethod.invoke((Object)entry, null) != null) continue;
                setMethod.invoke((Object)entry, zeros);
            }
        }
        catch (SecurityException e) {
            logger.error((Object)e);
        }
        catch (NoSuchMethodException e) {
            logger.error((Object)e);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    private void setDefaultValue4Submit(BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectCollection objCol = batchResults.getObjCollection();
        int size = objCol.size();
        for (int i = 0; i < size; ++i) {
            IObjectValue objVal = objCol.getObject(i);
            this.setDefaultValue4Submit(objVal);
        }
    }

    private void setDefaultValue4Submit(IObjectValue model) throws BOSException, EASBizException {
        PostRequisitionInfo postRequisitionInfo = (PostRequisitionInfo)model;
        if (postRequisitionInfo.getBillType() == null) {
            BillTypeInfo aBillTypeInfo = new BillTypeInfo();
            aBillTypeInfo.setId(BOSUuid.read((String)"510b6503-0105-1000-e000-011bc0a812fd463ED552"));
            postRequisitionInfo.setBillType(aBillTypeInfo);
        }
        PostRequisitionEntryCollection collection = postRequisitionInfo.getEntries();
        PostRequisitionEntryInfo entryInfo = null;
        int num = collection.size();
        for (int i = 0; i < num; ++i) {
            entryInfo = collection.get(i);
            entryInfo.setBaseStatus(EntryBaseStatusEnum.SUBMITED);
            if (!postRequisitionInfo.isIsReverse()) {
                BigDecimal baseQty = SCMUtils.effectualNumeric((BigDecimal)entryInfo.getBaseQty());
                BigDecimal qty = SCMUtils.effectualNumeric((BigDecimal)entryInfo.getQty());
                entryInfo.setAssociateQty(baseQty);
                entryInfo.setUnShippedQty(qty);
                entryInfo.setTotalReversedQty(SysConstant.BIGZERO);
                entryInfo.setTotalReversedBaseQty(SysConstant.BIGZERO);
            } else {
                entryInfo.setAssociateQty(SysConstant.BIGZERO);
                entryInfo.setShippedQty(SysConstant.BIGZERO);
                entryInfo.setShippedBaseQty(SysConstant.BIGZERO);
                entryInfo.setUnShippedQty(SysConstant.BIGZERO);
                entryInfo.setTotalReversedQty(SysConstant.BIGZERO);
                entryInfo.setTotalReversedBaseQty(SysConstant.BIGZERO);
            }
            this.setZero(entryInfo);
        }
        if (postRequisitionInfo.getPaymentType() == null) {
            PaymentTypeInfo paymentTypeInfo = new PaymentTypeInfo();
            paymentTypeInfo.setId(BOSUuid.read((String)"91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5"));
            postRequisitionInfo.setPaymentType(paymentTypeInfo);
        }
    }
}

