/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.app.bizprocess.processor.postrequisition;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.sd.sale.PostRequisitionInfo;
import com.kingdee.eas.scm.sd.sale.app.bizprocess.processor.postrequisition.BizUtil;

public class PRTraceUpAndDown4SubmitProcessor
extends AbstractBusinessProcessor {
    private static final long serialVersionUID = -726644000224914310L;

    public PRTraceUpAndDown4SubmitProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public PRTraceUpAndDown4SubmitProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public PRTraceUpAndDown4SubmitProcessor(ProcessorConstructParam param) {
        super(param);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectCollection objCol = batchResults.getObjCollection();
        int size = objCol.size();
        for (int i = 0; i < size; ++i) {
            IObjectValue objVal = objCol.getObject(i);
            this.traceUpAndDown(objVal);
        }
    }

    private void traceUpAndDown(IObjectValue model) throws BOSException, EASBizException {
        PostRequisitionInfo postRequisitionInfo = (PostRequisitionInfo)model;
        boolean isAddNew = BizUtil.isAddNew(this.ctx, model);
        ObjectUuidPK pk = null;
        if (!BizUtil.isAddNew(this.ctx, (IObjectValue)postRequisitionInfo)) {
            pk = new ObjectUuidPK(postRequisitionInfo.getId());
        }
        if (postRequisitionInfo.isIsReverse() && isAddNew) {
            String srcId = postRequisitionInfo.getSourceBillId();
            ObjectUuidPK srcPk = new ObjectUuidPK(srcId);
            String bosType = srcPk.getObjectType().toString();
            SCMServerUtils.traceUpAndDown((Context)this.ctx, (String)srcId, (String)pk.toString(), (String)bosType, (String)bosType);
        }
    }
}

