/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.app.bizprocess.processor.postrequisition;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sd.sale.IPostRequisition;
import com.kingdee.eas.scm.sd.sale.PostRequisitionFactory;
import com.kingdee.eas.scm.sd.sale.PostRequisitionInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderCollection;
import com.kingdee.eas.scm.sd.sale.SaleOrderFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PRWriteBackSourceBill4UnAuditProcessor
extends AbstractBusinessProcessor {
    private static final long serialVersionUID = 1473559404165454204L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sd.sale.app.bizprocess.processor.postrequisition.PRWriteBackSourceBill4UnAuditProcessor");

    public PRWriteBackSourceBill4UnAuditProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public PRWriteBackSourceBill4UnAuditProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public PRWriteBackSourceBill4UnAuditProcessor(ProcessorConstructParam param) {
        super(param);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectValue objVal = null;
        IObjectCollection objCol = batchResults.getObjCollection();
        IObjectPK[] pks = batchResults.getToDoPkArray();
        if (pks == null || pks.length == 0) {
            return;
        }
        Set flowSet = SCMServerUtils.getHasBizFlowValueBillID((Context)this.ctx, (String)"T_SD_PostRequisitionEntry", (IObjectPK[])pks);
        int size = objCol.size();
        for (int i = 0; i < size; ++i) {
            objVal = objCol.getObject(i);
            if (flowSet != null && flowSet.contains(objVal.get("id").toString())) continue;
            this.writeBack(objVal);
        }
    }

    private void writeBack(IObjectValue model) throws BOSException, EASBizException {
        PostRequisitionInfo info = (PostRequisitionInfo)model;
        String id = info.getId().toString();
        HashMap<String, PostRequisitionInfo> prMap = new HashMap<String, PostRequisitionInfo>();
        ObjectUuidPK[] pks = new ObjectUuidPK[]{new ObjectUuidPK(id)};
        prMap.put(id, info);
        Connection con = null;
        Statement statement = null;
        Statement batchStatement = null;
        try {
            con = this.getConnection(this.ctx);
            statement = con.createStatement();
            batchStatement = con.createStatement();
            StringBuffer params = new StringBuffer();
            params.append("'");
            params.append(id);
            params.append("'");
            String updateSql = "update T_SD_PostRequisition set FBaseStatus = 1,FAuditorId=null,FAuditTime =null where fid in(" + params.toString() + ")";
            String updateEntrySql = "update T_SD_PostRequisitionEntry set FBaseStatus = 1 where FParentID in(" + params.toString() + ")";
            DbUtil.execute((Context)this.ctx, (String)updateSql);
            DbUtil.execute((Context)this.ctx, (String)updateEntrySql);
            ArrayList<ObjectUuidPK> arrayList1 = new ArrayList<ObjectUuidPK>();
            ArrayList<ObjectUuidPK> arrayList2 = new ArrayList<ObjectUuidPK>();
            ArrayList<ObjectUuidPK> fsourcebillidList = new ArrayList<ObjectUuidPK>();
            IRowSet rset = DbUtil.executeQuery((Context)this.ctx, (String)("select FID, FISREVERSE,FSOURCEBILLID from T_SD_PostRequisition where fid in(" + params.toString() + ")"));
            while (rset.next()) {
                String fid = rset.getString("FID");
                String fsourcebillid = rset.getString("FSOURCEBILLID");
                boolean fisreverse = rset.getBoolean("FISREVERSE");
                if (!fisreverse) {
                    arrayList1.add(new ObjectUuidPK(fid));
                    continue;
                }
                arrayList2.add(new ObjectUuidPK(fid));
                fsourcebillidList.add(new ObjectUuidPK(fsourcebillid));
            }
            IObjectPK[] pks1 = arrayList1.toArray(new IObjectPK[arrayList1.size()]);
            Object[] pks2 = arrayList2.toArray(new IObjectPK[arrayList2.size()]);
            IObjectPK[] pks3 = fsourcebillidList.toArray(new IObjectPK[fsourcebillidList.size()]);
            if (pks1.length > 0) {
                this.updateSourceBillState(this.ctx, pks1);
                Set hasBizFlowValueIDs = SCMServerUtils.getHasBizFlowValueBillID((Context)this.ctx, (String)"t_sd_postrequisitionentry", (IObjectPK[])pks);
                this._writeSourceBill(this.ctx, pks1, "-", prMap, hasBizFlowValueIDs);
            }
            if (pks2.length > 0) {
                this.writeSourceBillByReverseBillUnAudit(this.ctx, this.convertToString(pks2));
                this.updateSourceBillStatusWhenUnAudit(this.ctx, pks3);
            }
        }
        catch (SQLException er) {
            try {
                throw new BOSException("sql Execute Error :", (Throwable)er);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)con);
                SQLUtils.cleanup(batchStatement, (Connection)con);
                SQLUtils.cleanup((Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)con);
        SQLUtils.cleanup((Statement)batchStatement, (Connection)con);
        SQLUtils.cleanup((Connection)con);
    }

    protected Connection getConnection(Context ctx) throws SQLDataException {
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
    }

    private void updateSourceBillState(Context ctx, IObjectPK[] pks) throws EASBizException, BOSException {
        IPostRequisition ip = PostRequisitionFactory.getLocalInstance((Context)ctx);
        int cont = pks.length;
        for (int i = 0; i < cont; ++i) {
            PostRequisitionInfo info = ip.getPostRequisitionInfo("select id,number,entries.sourceBillId,sourceBillType.id where id='" + pks[i].toString() + "'");
            if (info.getSourceBillType() == null || !info.getSourceBillType().getId().toString().equals("510b6503-0105-1000-e000-0113c0a812fd463ED552")) continue;
            HashSet<String> srcBotpBillIDSet = new HashSet<String>();
            int size = info.getEntries().size();
            for (int j = 0; j < size; ++j) {
                if (info.getEntries().get(j).getSourceBillId() == null) continue;
                srcBotpBillIDSet.add(info.getEntries().get(j).getSourceBillId());
            }
            SaleOrderInfo srcInfo = null;
            if (srcBotpBillIDSet.size() <= 0) continue;
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("baseStatus"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", srcBotpBillIDSet, CompareType.INCLUDE));
            view.setFilter(filter);
            SaleOrderCollection saleOrderColl = SaleOrderFactory.getLocalInstance((Context)ctx).getSaleOrderCollection(view);
            int size2 = saleOrderColl.size();
            for (int j = 0; j < size2; ++j) {
                srcInfo = saleOrderColl.get(j);
                if (!srcInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.BLOCKED)) continue;
                throw new SCMBillException(SCMBillException.HASBLOCKED_CANNOTUNAUDIT, new Object[]{info.getNumber()});
            }
        }
    }

    private String convertToString(Object[] objs) {
        if (objs == null || objs.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int count = objs.length;
        for (int i = 0; i < count; ++i) {
            if (objs[i] == null) continue;
            if (i > 0) {
                sb.append(",");
            }
            sb.append("'");
            sb.append(objs[i].toString());
            sb.append("'");
        }
        return sb.toString();
    }

    protected void _writeSourceBill(Context ctx, IObjectPK[] pks, String operator, Map<String, PostRequisitionInfo> prMap, Set hasBizFlowValueIDs) throws EASBizException, BOSException {
        PostRequisitionInfo saleInfo = null;
        BatchActionEnum action = "-".equals(operator) ? BatchActionEnum.UNAUDIT : BatchActionEnum.AUDIT;
        HashSet<IObjectPK> pkSet = new HashSet<IObjectPK>();
        int len = pks.length;
        for (int i = 0; i < len; ++i) {
            if (hasBizFlowValueIDs.contains(pks[i].toString())) {
                saleInfo = prMap.get(pks[i].toString());
                SCMServerUtils.executeBizFlow((Context)ctx, (IObjectValue)saleInfo, (BatchActionEnum)action);
                continue;
            }
            pkSet.add(pks[i]);
        }
        if (pkSet.size() > 0) {
            String pkString = SCMServerUtils.getInStringFromSet(pkSet);
            this._writeSourceBill(ctx, pkString, operator);
            if (action == BatchActionEnum.AUDIT) {
                this.writeTransferOrderBill(ctx, pkString);
            } else {
                this.writeSourceBillForTransferOrderByReverseBillUnAudit(ctx, pkString);
            }
        }
    }

    private void writeTransferOrderBill(Context ctx, String params) throws BOSException {
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("UPDATE T_IM_TransferOrderBillEntry AS T1 SET (FunIssueBaseQty,FtotalIssueQty) = ");
            sb.append("(SELECT ste.FunIssueBaseQty - are.areBaseQty AS IUNBQ , ste.FtotalIssueQty + are.areFQty AS Qty  FROM T_IM_TransferOrderBillEntry ste ");
            sb.append("INNER JOIN (SELECT FParentID,FsourceBillEntryId,FSourceBillTypeId,sum(FQty) as areFQty,sum(FBaseQty) as areBaseQty  FROM T_SD_PostRequisitionEntry WHERE FParentID=");
            sb.append(params);
            sb.append(" and FSourceBillTypeId  = '");
            sb.append("Eg5BUQEVEADgAAABwKgOEEY+1VI=");
            sb.append("' GROUP BY FParentID,FsourceBillEntryId,FSourceBillTypeId) are ");
            sb.append("ON are.FsourceBillEntryId = ste.Fid WHERE are.FParentID in(");
            sb.append(params);
            sb.append(") AND T1.FID=ste.FID)");
            DbUtil.execute((Context)ctx, (String)sb.toString());
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
    }

    protected void _writeSourceBill(Context ctx, String params, String operator) throws BOSException, EASBizException {
        try {
            StringBuffer valueBuffer = new StringBuffer();
            valueBuffer.append(" select entry.FSourceBillEntryId,entry.FQty,entry.FBaseQty").append(" from T_SD_PostRequisitionEntry entry").append(" where entry.FSourceBillTypeId = '").append("510b6503-0105-1000-e000-0113c0a812fd463ED552").append("'").append(" and entry.FParentID in(").append(params).append(")");
            IRowSet result = DbUtil.executeQuery((Context)ctx, (String)valueBuffer.toString());
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
            Object[] dbParams = null;
            if (result.next() && result.getString(1) != null) {
                StringBuffer updateOrderSql = new StringBuffer();
                updateOrderSql.append("update T_SD_SaleOrderEntry ").append(" set FTotalUnIssueQty = (FTotalUnIssueQty - ?)").append(" ,FTotalUnIssueBaseQty = (FTotalUnIssueBaseQty - ?)").append(" ,FTotalShippingQty = FTotalShippingQty + ? ").append(" ,FTotalShipBaseQty = FTotalShipBaseQty +? ").append(",ftotalunshipbaseqty = ftotalunshipbaseqty - ?").append(" where fid = ? ");
                if (operator.equals("-")) {
                    dbParams = new Object[]{result.getBigDecimal(2).negate(), result.getBigDecimal(3).negate(), result.getBigDecimal(2).negate(), result.getBigDecimal(3).negate(), result.getBigDecimal(3).negate(), result.getString(1)};
                    paramsList.add(dbParams);
                } else {
                    dbParams = new Object[]{result.getBigDecimal(2), result.getBigDecimal(3), result.getBigDecimal(2), result.getBigDecimal(3), result.getBigDecimal(3), result.getString(1)};
                    paramsList.add(dbParams);
                }
                while (result.next()) {
                    if (operator.equals("-")) {
                        dbParams = new Object[]{result.getBigDecimal(2).negate(), result.getBigDecimal(3).negate(), result.getBigDecimal(2).negate(), result.getBigDecimal(3).negate(), result.getBigDecimal(3).negate(), result.getString(1)};
                        paramsList.add(dbParams);
                        continue;
                    }
                    dbParams = new Object[]{result.getBigDecimal(2), result.getBigDecimal(3), result.getBigDecimal(2), result.getBigDecimal(3), result.getBigDecimal(3), result.getString(1)};
                    paramsList.add(dbParams);
                }
                DbUtil.executeBatch((Context)ctx, (String)updateOrderSql.toString(), paramsList);
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void writeSourceBillByReverseBillUnAudit(Context ctx, String params) throws BOSException, EASBizException {
        Connection con = null;
        Statement selectStmt = null;
        PreparedStatement updatePstmt = null;
        ResultSet rs = null;
        String selectSql = new StringBuffer().append("select pre.FUnitID, pre.FQty, pre.FBaseQty, pre2.FID, pre2.FUnitID as FUnitID2, pre2.FTotalReversedQty, pre2.FTotalReversedBaseQty, ").append(" pre2.FUnShippedQty, pre2.FAssociateQty, mu.FBaseConvsRate ").append(" from T_SD_PostRequisitionEntry pre ").append(" inner join T_SD_PostRequisitionEntry pre2 on pre2.FID = pre.FSourceBillEntryId ").append(" left outer join T_BD_MultiMeasureUnit mu on mu.FMaterialID = pre2.FMaterialID and mu.FMeasureUnitID = pre2.FUnitID ").append(" where pre.FParentID in(").append(params).append(")").toString();
        String updateSql = new StringBuffer().append("update T_SD_PostRequisitionEntry set FTotalReversedQty = ?, FTotalReversedBaseQty = ?, FUnShippedQty = ?, FAssociateQty = ? where FID = ?").toString();
        ArrayList<String> arrList = new ArrayList<String>();
        try {
            con = this.getConnection(ctx);
            selectStmt = con.createStatement();
            updatePstmt = con.prepareStatement(updateSql);
            rs = selectStmt.executeQuery(selectSql);
            if (rs.next()) {
                do {
                    String currUnitID = rs.getString("FUnitID");
                    BigDecimal currQty = SCMUtils.effectualNumeric((BigDecimal)rs.getBigDecimal("FQty")).abs();
                    BigDecimal currBaseQty = SCMUtils.effectualNumeric((BigDecimal)rs.getBigDecimal("FBaseQty")).abs();
                    String fid = rs.getString("FID");
                    arrList.add(fid);
                    String unitID = rs.getString("FUnitID2");
                    BigDecimal totalReversedQty = rs.getBigDecimal("FTotalReversedQty");
                    BigDecimal totalReversedBaseQty = rs.getBigDecimal("FTotalReversedBaseQty");
                    BigDecimal unShippedQty = rs.getBigDecimal("FUnShippedQty");
                    BigDecimal associateQty = rs.getBigDecimal("FAssociateQty");
                    BigDecimal baseConvsRate = rs.getBigDecimal("FBaseConvsRate");
                    if (baseConvsRate == null) {
                        baseConvsRate = new BigDecimal("1.00");
                    }
                    if (currUnitID != null && !currUnitID.equals(unitID)) {
                        currQty = currBaseQty.divide(baseConvsRate, currQty.scale(), 4);
                    }
                    totalReversedQty = SCMUtils.effectualNumeric((BigDecimal)totalReversedQty).subtract(currQty);
                    totalReversedBaseQty = SCMUtils.effectualNumeric((BigDecimal)totalReversedBaseQty).subtract(currBaseQty);
                    unShippedQty = SCMUtils.effectualNumeric((BigDecimal)unShippedQty).add(currQty);
                    associateQty = SCMUtils.effectualNumeric((BigDecimal)associateQty).add(currBaseQty);
                    updatePstmt.setBigDecimal(1, totalReversedQty);
                    updatePstmt.setBigDecimal(2, totalReversedBaseQty);
                    updatePstmt.setBigDecimal(3, unShippedQty);
                    updatePstmt.setBigDecimal(4, associateQty);
                    updatePstmt.setString(5, fid);
                    updatePstmt.addBatch();
                } while (rs.next());
                updatePstmt.executeBatch();
                this.writeSourceBillForSaleOrderByReverseBillUnAudit(ctx, params);
                this.writeSourceBillForTransferOrderByReverseBillUnAudit(ctx, params);
            }
        }
        catch (EASBizException e) {
            try {
                logger.error((Object)e);
                throw e;
                catch (BOSException e2) {
                    logger.error((Object)e2);
                    throw e2;
                }
                catch (SQLException e3) {
                    logger.error((Object)e3);
                    throw new BOSException(e3.getMessage());
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, selectStmt);
                SQLUtils.cleanup(updatePstmt);
                SQLUtils.cleanup((Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)selectStmt);
        SQLUtils.cleanup((Statement)updatePstmt);
        SQLUtils.cleanup((Connection)con);
    }

    private void updateSourceBillStatusWhenUnAudit(Context ctx, IObjectPK[] pks) throws SQLException, BOSException {
        Connection con = null;
        Statement statement = null;
        try {
            con = this.getConnection(ctx);
            statement = con.createStatement();
            String updateEntrySql = "update T_SD_PostRequisitionEntry set FBaseStatus = 4 where FParentID in(" + this.convertToString(pks).toString() + ") and fbaseqty - FTotalReversedBaseQty > 0 and fbasestatus = 7 ";
            statement.executeUpdate(updateEntrySql);
            String updateSql = " update T_SD_PostRequisition set FBaseStatus = 4 where fid in ( " + this.convertToString(pks).toString() + ") and  exists(select * from t_sd_postrequisitionentry where fbasestatus = 4 and fparentid =T_SD_PostRequisition.fid ) ";
            statement.executeUpdate(updateSql);
        }
        catch (SQLException er) {
            try {
                throw new BOSException("sql Execute Error :", (Throwable)er);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)con);
    }

    private void writeSourceBillForTransferOrderByReverseBillUnAudit(Context ctx, String params) throws BOSException, EASBizException {
        Connection con = null;
        Statement selectStmt = null;
        PreparedStatement updatePstmt = null;
        PreparedStatement updatePstmtBySplit = null;
        ResultSet rs = null;
        String selectSql = new StringBuffer().append("select pre.FUnitID, pre.FQty, pre.FBaseQty, soe.FID, soe.FParentID, soe.FUnitID as FUnitID2,  ").append(" soe.FunIssueBaseQty,soe.FtotalIssueQty, soe.FIssueBaseQty, mu.FBaseConvsRate, mu2.FBaseConvsRate as FBaseConvsRate2").append(" from T_SD_PostRequisitionEntry pre ").append(" inner join T_IM_TransferOrderBillEntry soe on soe.FID = pre.FSourceBillEntryId ").append(" left outer join T_BD_MultiMeasureUnit mu on mu.FMaterialID = soe.FMaterialID and mu.FMeasureUnitID = soe.FUnitID ").append(" left outer join T_BD_MultiMeasureUnit mu2 on mu2.FMaterialID = soe.FMaterialID and mu2.FMeasureUnitID = soe.FAssistUnitID ").append(" where pre.FParentID in(").append(params).append(") order by soe.FID ").toString();
        String updateSql = new StringBuffer().append("update T_IM_TransferOrderBillEntry set FunIssueBaseQty = ?, FtotalIssueQty = ?  where FID = ?").toString();
        String updateSqlBySplit = "update T_IM_TransferOrderBillEntry set FunIssueBaseQty = FunIssueBaseQty+?, FtotalIssueQty = FtotalIssueQty-?  where FID = ? ";
        try {
            con = this.getConnection(ctx);
            selectStmt = con.createStatement();
            updatePstmt = con.prepareStatement(updateSql);
            updatePstmtBySplit = con.prepareStatement(updateSqlBySplit);
            rs = selectStmt.executeQuery(selectSql);
            String tempTansferOrderEntryID = null;
            if (rs.next()) {
                do {
                    boolean isNeedExcuteSplit = false;
                    String currUnitID = rs.getString("FUnitID");
                    BigDecimal currQty = SCMUtils.effectualNumeric((BigDecimal)rs.getBigDecimal("FQty")).abs();
                    BigDecimal currBaseQty = SCMUtils.effectualNumeric((BigDecimal)rs.getBigDecimal("FBaseQty")).abs();
                    String fentryid = rs.getString("FID");
                    String unitID = rs.getString("FUnitID2");
                    if (tempTansferOrderEntryID != null && tempTansferOrderEntryID.equals(fentryid)) {
                        isNeedExcuteSplit = true;
                    }
                    BigDecimal unIssueBaseQty = rs.getBigDecimal("FunIssueBaseQty");
                    BigDecimal totalIssueQty = rs.getBigDecimal("FtotalIssueQty");
                    BigDecimal baseConvsRate = rs.getBigDecimal("FBaseConvsRate");
                    if (baseConvsRate == null) {
                        baseConvsRate = new BigDecimal("1.00");
                    }
                    if (currUnitID != null && !currUnitID.equals(unitID)) {
                        currQty = currBaseQty.divide(baseConvsRate, currQty.scale(), 4);
                    }
                    if (isNeedExcuteSplit) {
                        unIssueBaseQty = currBaseQty;
                        totalIssueQty = currQty;
                        updatePstmtBySplit.setBigDecimal(1, unIssueBaseQty);
                        updatePstmtBySplit.setBigDecimal(2, totalIssueQty);
                        updatePstmtBySplit.setString(3, fentryid);
                        updatePstmtBySplit.addBatch();
                    } else {
                        unIssueBaseQty = SCMUtils.effectualNumeric((BigDecimal)unIssueBaseQty).add(currBaseQty);
                        totalIssueQty = SCMUtils.effectualNumeric((BigDecimal)totalIssueQty).subtract(currQty);
                        updatePstmt.setBigDecimal(1, unIssueBaseQty);
                        updatePstmt.setBigDecimal(2, totalIssueQty);
                        updatePstmt.setString(3, fentryid);
                        updatePstmt.addBatch();
                    }
                    tempTansferOrderEntryID = rs.getString("FID");
                } while (rs.next());
                updatePstmt.executeBatch();
                updatePstmtBySplit.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.getMessage());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup(selectStmt);
                SQLUtils.cleanup(updatePstmt);
                SQLUtils.cleanup(updatePstmtBySplit);
                SQLUtils.cleanup((Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((Statement)selectStmt);
        SQLUtils.cleanup((Statement)updatePstmt);
        SQLUtils.cleanup((Statement)updatePstmtBySplit);
        SQLUtils.cleanup((Connection)con);
    }

    protected void writeSourceBillForSaleOrderByReverseBillUnAudit(Context ctx, String params) throws BOSException, EASBizException {
        Connection con = null;
        Statement selectStmt = null;
        PreparedStatement updatePstmt = null;
        ResultSet rs = null;
        String selectSql = new StringBuffer().append("select pre.FUnitID, pre.FQty, pre.FBaseQty, soe.FID, soe.FParentID, soe.FUnitID as FUnitID2, soe.FTotalShippingQty,soe.FTotalShipBaseQty, soe.FTotalUnShipBaseQty, ").append(" soe.FTotalUnIssueQty, soe.FTotalUnIssueBaseQty, mu.FBaseConvsRate, mu2.FBaseConvsRate as FBaseConvsRate2").append(" from T_SD_PostRequisitionEntry pre ").append(" inner join T_SD_PostRequisitionEntry pre2 on pre2.FID = pre.FSourceBillEntryId ").append(" inner join T_SD_SaleOrderEntry soe on soe.FID = pre2.FSourceBillEntryId ").append(" left outer join T_BD_MultiMeasureUnit mu on mu.FMaterialID = soe.FMaterialID and mu.FMeasureUnitID = soe.FUnitID ").append(" left outer join T_BD_MultiMeasureUnit mu2 on mu2.FMaterialID = soe.FMaterialID and mu2.FMeasureUnitID = soe.FAssistUnitID ").append(" where pre.FParentID in(").append(params).append(") order by soe.FID").toString();
        String updateSql = new StringBuffer().append("update T_SD_SaleOrderEntry set FTotalShippingQty = ?, FTotalShipBaseQty = ?, FTotalUnShipBaseQty = ?, FTotalUnIssueQty = ?, FTotalUnIssueBaseQty = ? where FID = ?").toString();
        try {
            con = this.getConnection(ctx);
            selectStmt = con.createStatement();
            updatePstmt = con.prepareStatement(updateSql);
            rs = selectStmt.executeQuery(selectSql);
            if (rs.next()) {
                do {
                    String currUnitID = rs.getString("FUnitID");
                    BigDecimal currQty = SCMUtils.effectualNumeric((BigDecimal)rs.getBigDecimal("FQty")).abs();
                    BigDecimal currBaseQty = SCMUtils.effectualNumeric((BigDecimal)rs.getBigDecimal("FBaseQty")).abs();
                    String fentryid = rs.getString("FID");
                    String unitID = rs.getString("FUnitID2");
                    BigDecimal totalShippingQty = rs.getBigDecimal("FTotalShippingQty");
                    BigDecimal totalShipBaseQty = rs.getBigDecimal("FTotalShipBaseQty");
                    BigDecimal totalUnShipBaseQty = rs.getBigDecimal("FTotalUnShipBaseQty");
                    BigDecimal totalUnIssueQty = rs.getBigDecimal("FTotalUnIssueQty");
                    BigDecimal totalUnIssueBaseQty = rs.getBigDecimal("FTotalUnIssueBaseQty");
                    BigDecimal baseConvsRate = rs.getBigDecimal("FBaseConvsRate");
                    if (baseConvsRate == null) {
                        baseConvsRate = new BigDecimal("1.00");
                    }
                    if (currUnitID != null && !currUnitID.equals(unitID)) {
                        currQty = currBaseQty.divide(baseConvsRate, currQty.scale(), 4);
                    }
                    totalShippingQty = SCMUtils.effectualNumeric((BigDecimal)totalShippingQty).add(currQty);
                    totalShipBaseQty = SCMUtils.effectualNumeric((BigDecimal)totalShipBaseQty).add(currBaseQty);
                    totalUnShipBaseQty = SCMUtils.effectualNumeric((BigDecimal)totalUnShipBaseQty).subtract(currBaseQty);
                    totalUnIssueQty = SCMUtils.effectualNumeric((BigDecimal)totalUnIssueQty).subtract(currQty);
                    totalUnIssueBaseQty = SCMUtils.effectualNumeric((BigDecimal)totalUnIssueBaseQty).subtract(currBaseQty);
                    updatePstmt.setBigDecimal(1, totalShippingQty);
                    updatePstmt.setBigDecimal(2, totalShipBaseQty);
                    updatePstmt.setBigDecimal(3, totalUnShipBaseQty);
                    updatePstmt.setBigDecimal(4, totalUnIssueQty);
                    updatePstmt.setBigDecimal(5, totalUnIssueBaseQty);
                    updatePstmt.setString(6, fentryid);
                    updatePstmt.addBatch();
                } while (rs.next());
                updatePstmt.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.getMessage());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup((Connection)con);
                SQLUtils.cleanup(selectStmt);
                SQLUtils.cleanup(updatePstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)con);
        SQLUtils.cleanup((Statement)selectStmt);
        SQLUtils.cleanup((Statement)updatePstmt);
    }
}

