/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.app.bizprocess.processor.saleorder;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.scm.sd.sale.ISaleOrder;
import com.kingdee.eas.scm.sd.sale.SaleOrderArClosedStatusEnum;
import com.kingdee.eas.scm.sd.sale.SaleOrderCollection;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryCollection;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import com.kingdee.eas.util.app.DbUtil;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Set;

public class SOSetBillStatus4AuditProcessor
extends AbstractBusinessProcessor {
    private static final long serialVersionUID = -4197175549592587169L;

    public SOSetBillStatus4AuditProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public SOSetBillStatus4AuditProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public SOSetBillStatus4AuditProcessor(ProcessorConstructParam param) {
        super(param);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        this.setBillStatus(batchResults);
    }

    private void setBillStatus(BatchActionResults batchResults) throws BOSException, EASBizException {
        Object[] orderIDs = batchResults.getToDoIdsArray();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("oldID"));
        selector.add(new SelectorItemInfo("billType.id"));
        selector.add(new SelectorItemInfo("saleOrgUnit.id"));
        selector.add(new SelectorItemInfo("baseStatus"));
        selector.add(new SelectorItemInfo("sourceBillType.id"));
        selector.add(new SelectorItemInfo("isReverse"));
        selector.add(new SelectorItemInfo("bizType"));
        selector.add(new SelectorItemInfo("creator.id"));
        selector.add(new SelectorItemInfo("entries.id"));
        selector.add(new SelectorItemInfo("entries.totalIssueQty"));
        selector.add(new SelectorItemInfo("entries.qty"));
        selector.add(new SelectorItemInfo("entries.sendOwingRate"));
        selector.add(new SelectorItemInfo("entries.sendOverRate"));
        selector.add(new SelectorItemInfo("entries.baseStatus"));
        selector.add(new SelectorItemInfo("entries.isLocked"));
        selector.add(new SelectorItemInfo("entries.sourceBillEntryId"));
        selector.add(new SelectorItemInfo("entries.baseQty"));
        selector.add(new SelectorItemInfo("entries.taxAmount"));
        selector.add(new SelectorItemInfo("entries.sourceBillId"));
        selector.add(new SelectorItemInfo("entries.totalInvoicedQty"));
        selector.add(new SelectorItemInfo("entries.arClosedStatus"));
        selector.add(new SelectorItemInfo("entries.totalIssueBaseQty"));
        selector.add(new SelectorItemInfo("entries.totalReversedBaseQty"));
        selector.add(new SelectorItemInfo("entries.totalSupplyStockQty"));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        Set idSet = batchResults.getToDoIdsSet();
        if (idSet.size() < 1) {
            return;
        }
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(selector);
        ISaleOrder iSaleOrder = SaleOrderFactory.getLocalInstance((Context)this.ctx);
        SaleOrderCollection updateSaleOrderCollection = iSaleOrder.getSaleOrderCollection(view);
        int size = updateSaleOrderCollection.size();
        for (int i = 0; i < size; ++i) {
            SaleOrderInfo updateSaleOrderInfo = updateSaleOrderCollection.get(i);
            ObjectUuidPK pk = new ObjectUuidPK(updateSaleOrderInfo.getId().toString());
            if (updateSaleOrderInfo == null) continue;
            SaleOrderEntryInfo entryInfo = null;
            updateSaleOrderInfo.setBaseStatus(updateSaleOrderInfo.getBaseStatus());
            StringBuffer updateSoECloseIDs = new StringBuffer("");
            StringBuffer updateSoEArCloseIDs = new StringBuffer("");
            StringBuffer updateSoEUnArCloseIDs = new StringBuffer("");
            int pcCount = updateSaleOrderInfo.getEntries().size();
            for (int pc = 0; pc < pcCount; ++pc) {
                entryInfo = updateSaleOrderInfo.getEntries().get(pc);
                BigDecimal qty = entryInfo.getQty();
                if (entryInfo.getArClosedStatus() == null || entryInfo.getArClosedStatus() == SaleOrderArClosedStatusEnum.NONE) {
                    BigDecimal receiveQty = entryInfo.getTotalInvoicedQty();
                    if (receiveQty != null && qty.compareTo(receiveQty) <= 0) {
                        updateSoEArCloseIDs.append("'").append(entryInfo.getId().toString()).append("',");
                    } else {
                        updateSoEUnArCloseIDs.append("'").append(entryInfo.getId().toString()).append("',");
                    }
                }
                BigDecimal rate = SCMConstant.BIGDECIMAL_ONE.subtract(entryInfo.getSendOwingRate().divide(SCMConstant.BIGDECIMAL_ONEHUNDRED));
                BigDecimal baseQty = entryInfo.getBaseQty().multiply(rate);
                BigDecimal totalReverseBaseQty = entryInfo.getTotalReversedBaseQty().multiply(rate);
                BigDecimal unTotalIssueBaseQty = baseQty.subtract(totalReverseBaseQty).add(entryInfo.getTotalSupplyStockQty());
                BigDecimal totalIssueBaseQty = entryInfo.getTotalIssueBaseQty();
                if (!updateSaleOrderInfo.isIsReverse() && entryInfo.getBaseStatus() == EntryBaseStatusEnum.AUDITED && unTotalIssueBaseQty.compareTo(totalIssueBaseQty) <= 0) {
                    entryInfo.setBaseStatus(EntryBaseStatusEnum.CLOSED);
                    updateSoECloseIDs.append("'").append(entryInfo.getId().toString()).append("',");
                }
                if (qty.compareTo(new BigDecimal("0.00")) != 0) continue;
                entryInfo.setBaseStatus(EntryBaseStatusEnum.CLOSED);
                updateSoECloseIDs.append("'").append(entryInfo.getId().toString()).append("',");
            }
            if (this.checkAllEntryStatus(this.ctx, (IObjectPK)pk, (IObjectValue)updateSaleOrderInfo, EntryBaseStatusEnum.CLOSED)) {
                String updateEntrySql = "update T_SD_SaleOrder set FBaseStatus = 7 where fid in('" + pk.toString() + "')";
                DbUtil.execute((Context)this.ctx, (String)updateEntrySql);
            }
            if (updateSoECloseIDs.length() > 0) {
                updateSoECloseIDs = updateSoECloseIDs.deleteCharAt(updateSoECloseIDs.length() - 1);
                String updateEntrySql = "update T_SD_SaleOrderEntry set FBaseStatus = 7 where fid in(" + updateSoECloseIDs.toString() + ")";
                DbUtil.execute((Context)this.ctx, (String)updateEntrySql);
            }
            if (updateSoEArCloseIDs.length() > 0) {
                updateSoEArCloseIDs = updateSoEArCloseIDs.deleteCharAt(updateSoEArCloseIDs.length() - 1);
                String updateEntrySql = "update T_SD_SaleOrderEntry set FarClosedStatus = 1 where fid in(" + updateSoEArCloseIDs.toString() + ")";
                DbUtil.execute((Context)this.ctx, (String)updateEntrySql);
            }
            if (updateSoEUnArCloseIDs.length() <= 0) continue;
            updateSoEUnArCloseIDs = updateSoEUnArCloseIDs.deleteCharAt(updateSoEUnArCloseIDs.length() - 1);
            String updateEntrySql = "update T_SD_SaleOrderEntry set FarClosedStatus = 0 where fid in(" + updateSoEUnArCloseIDs.toString() + ")";
            DbUtil.execute((Context)this.ctx, (String)updateEntrySql);
        }
        DbUtil.execute((Context)this.ctx, (String)("update T_SD_SaleOrder set faudittime = ? where fid in (" + StringUtil.getKeyIdList((Object[])orderIDs) + ")"), (Object[])new Object[]{new Timestamp(System.currentTimeMillis())});
    }

    private boolean checkAllEntryStatus(Context ctx, IObjectPK pk, IObjectValue model, EntryBaseStatusEnum targeStatus) throws EASBizException, BOSException {
        SaleOrderInfo saleOrderInfo = (SaleOrderInfo)model;
        SaleOrderEntryCollection saleOrderCollenction = saleOrderInfo.getEntries();
        int num = saleOrderCollenction.size();
        for (int i = 0; i < num; ++i) {
            if (saleOrderCollenction.get(i).getBaseStatus().getValue() == targeStatus.getValue()) continue;
            return false;
        }
        return true;
    }
}

