/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.app.bizprocess.processor.saleorder;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.app.bizprocess.processor.UpdateBillStatusProcess;
import com.kingdee.eas.scm.sd.sale.ISaleOrder;
import com.kingdee.eas.scm.sd.sale.SaleOrderCollection;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryCollection;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.util.app.DbUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class SOUpdateBillStatusProcessor
extends UpdateBillStatusProcess {
    private static final long serialVersionUID = -7465442115770284959L;

    public SOUpdateBillStatusProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public SOUpdateBillStatusProcessor(ProcessorConstructParam param) {
        super(param);
    }

    public SOUpdateBillStatusProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    protected void updateAuditStatus(Context ctx, IObjectCollection billCol) throws EASBizException, BOSException {
        try {
            this.dataPrepare(billCol);
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.updateAuditStatus(ctx, billCol);
        SaleOrderInfo so = null;
        SaleOrderEntryCollection entries = null;
        SaleOrderEntryInfo entry = null;
        ArrayList<String> idList = new ArrayList<String>();
        int size = billCol.size();
        for (int i = 0; i < size; ++i) {
            so = (SaleOrderInfo)billCol.getObject(i);
            entries = so.getEntries();
            int nsize = entries.size();
            for (int n = 0; n < nsize; ++n) {
                entry = entries.get(n);
                entry.setBaseStatus(EntryBaseStatusEnum.AUDITED);
                idList.add(entry.getId().toString());
            }
        }
        int status = 4;
        String ids = CollectionUtil.convertList2String(idList);
        StringBuilder sb = new StringBuilder();
        sb.append("UPDATE T_SD_SaleOrderEntry").append(" SET FBaseStatus = ").append(status).append(" WHERE FID IN (").append(ids).append(") ");
        DbUtil.execute((Context)ctx, (String)sb.toString());
    }

    protected void updateUnAuditStatus(Context ctx, IObjectCollection billCol) throws EASBizException, BOSException {
        super.updateUnAuditStatus(ctx, billCol);
        SaleOrderInfo so = null;
        SaleOrderEntryCollection entries = null;
        SaleOrderEntryInfo entry = null;
        ArrayList<String> idList = new ArrayList<String>();
        int size = billCol.size();
        for (int i = 0; i < size; ++i) {
            so = (SaleOrderInfo)billCol.getObject(i);
            entries = so.getEntries();
            int nsize = entries.size();
            for (int n = 0; n < nsize; ++n) {
                entry = entries.get(n);
                entry.setBaseStatus(EntryBaseStatusEnum.TEMPORARILYSAVED);
                idList.add(entry.getId().toString());
            }
        }
        int status = 1;
        String ids = CollectionUtil.convertList2String(idList);
        StringBuilder sb = new StringBuilder();
        sb.append("UPDATE T_SD_SaleOrderEntry").append(" SET FBaseStatus = ").append(status).append(" WHERE FID IN (").append(ids).append(") ");
        DbUtil.execute((Context)ctx, (String)sb.toString());
    }

    private void dataPrepare(IObjectCollection col) throws BOSException, EASBizException {
        PurOrderInfo info = null;
        HashSet<String> idsSet = new HashSet<String>();
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            info = (PurOrderInfo)col.getObject(i);
            if (info == null) continue;
            idsSet.add(info.getId().toString());
        }
        ISaleOrder iSaleOrder = SaleOrderFactory.getLocalInstance((Context)this.ctx);
        SaleOrderInfo saleOrder = null;
        SaleOrderCollection coll = null;
        ArrayList list = new ArrayList();
        HashMap<String, BillBaseStatusEnum> statusAlterMap = new HashMap<String, BillBaseStatusEnum>();
        if (idsSet != null && idsSet.size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", idsSet, CompareType.INCLUDE));
            view.setFilter(filter);
            SelectorItemCollection selectColl = new SelectorItemCollection();
            selectColl.add(new SelectorItemInfo("id"));
            selectColl.add(new SelectorItemInfo("baseStatus"));
            view.setSelector(selectColl);
            coll = iSaleOrder.getSaleOrderCollection(view);
            if (coll != null && coll.size() > 0) {
                int count = coll.size();
                for (int i = 0; i < count; ++i) {
                    saleOrder = coll.get(i);
                    if (saleOrder == null || saleOrder.getBaseStatus() != BillBaseStatusEnum.ALTERING) continue;
                    statusAlterMap.put(saleOrder.getId().toString(), BillBaseStatusEnum.ALTERING);
                }
            }
            this.ctx.put((Object)"statusAlterMap", statusAlterMap);
        }
    }
}

