/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.app.bizprocess.processor.saleorder;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.ITableManagerFacade;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.planning.IReqPlanSaleOrderFacade;
import com.kingdee.eas.mm.planning.ReqPlanSaleOrderFacadeFactory;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.app.bizprocess.util.SCMBizProcessorUtil;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.InvUpdateException;
import com.kingdee.eas.scm.im.inv.StockReqFacadeFactory;
import com.kingdee.eas.scm.sd.channel.app.WriteBackNetOrderHandleFactory;
import com.kingdee.eas.scm.sd.sale.ISaleContractEntry;
import com.kingdee.eas.scm.sd.sale.ISaleOrderEntry;
import com.kingdee.eas.scm.sd.sale.OrderException;
import com.kingdee.eas.scm.sd.sale.SaleContractEntryCollection;
import com.kingdee.eas.scm.sd.sale.SaleContractEntryFactory;
import com.kingdee.eas.scm.sd.sale.SaleContractEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryCollection;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import com.kingdee.eas.scm.sd.sale.app.bizprocess.processor.saleorder.SOrderWriteBackSContract;
import com.kingdee.eas.scm.util.array.ArrayUtil;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SOWriteBack4AuditProcessor
extends AbstractBusinessProcessor {
    private static final long serialVersionUID = -1117288714612940577L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sd.sale.app.bizprocess.processor.saleorder.SOWriteBack4AuditProcessor");

    public SOWriteBack4AuditProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public SOWriteBack4AuditProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public SOWriteBack4AuditProcessor(ProcessorConstructParam param) {
        super(param);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        this.batchCheck(batchResults);
        IObjectPK[] pks = batchResults.getToDoPkArray();
        if (pks.length == 0) {
            return;
        }
        String[] ids = batchResults.getToDoIdsArray();
        for (int i = 0; i < ids.length; ++i) {
            try {
                SOrderWriteBackSContract.writeSourceBillForSaleContract(this.ctx, "'" + ids[i] + "'", "+");
                continue;
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        this.writeBackNetOrder(batchResults);
    }

    private void writeBackNetOrder(BatchActionResults batchResults) throws BOSException, EASBizException {
        int i;
        int size;
        IObjectPK[] pks = batchResults.getToDoPkArray();
        if (pks.length == 0) {
            return;
        }
        String[] ids = batchResults.getToDoIdsArray();
        Set flowSet = SCMServerUtils.getHasBizFlowValueBillID((Context)this.ctx, (String)"T_SD_SaleOrderEntry", (IObjectPK[])pks);
        ArrayList<String> idList = new ArrayList<String>();
        if (flowSet != null && flowSet.size() > 0) {
            size = pks.length;
            for (i = 0; i < size; ++i) {
                if (flowSet.contains(pks[i].toString())) continue;
                idList.add(pks[i].toString());
            }
        }
        if (idList.size() > 0) {
            pks = null;
            ids = null;
            pks = new IObjectPK[idList.size()];
            ids = new String[idList.size()];
            size = idList.size();
            for (i = 0; i < size; ++i) {
                pks[i] = new ObjectUuidPK(idList.get(i).toString());
                ids[i] = idList.get(i).toString();
            }
        }
        if (pks != null && pks.length > 0) {
            if (this.isNeedToReWriteNetOrder(this.ctx, pks)) {
                WriteBackNetOrderHandleFactory.headHandle((Context)this.ctx, (String)this.getBOSType().toString(), (BizActionEnum)BizActionEnum.AUDIT, (IObjectPK[])pks);
            }
            WriteBackNetOrderHandleFactory.headHandleB2C((Context)this.ctx, (String)this.getBOSType().toString(), (BizActionEnum)BizActionEnum.AUDIT, (IObjectPK[])pks);
        }
        if (ids != null && ids.length != 0) {
            ArrayList<String> list = new ArrayList<String>();
            StringBuffer sql = new StringBuffer();
            sql.append("select FID from T_SD_SaleOrder where fid in ");
            sql.append(ArrayUtil.getInStringFromArray((String[])ids));
            sql.append(" and FBaseStatus = 4 and FVersion > 1 and FSourceBillTypeID='").append("MmEE6VBsR0KaUDQmebwhP0Y+1VI=").append("' ");
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
            try {
                while (rs.next()) {
                    list.add(rs.getString("FID"));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            int count = list.size();
            if (count > 0) {
                String[] saoIds = new String[count];
                for (int i2 = 0; i2 < count; ++i2) {
                    saoIds[i2] = (String)list.get(i2);
                }
                StockReqFacadeFactory.getLocalInstance((Context)this.ctx).batchCheckSrcBillStockReqAudit(saoIds);
            }
        }
    }

    protected BOSObjectType getBOSType() {
        return new BOSObjectType("C48A423A");
    }

    private boolean isNeedToReWriteNetOrder(Context ctx, IObjectPK[] pks) throws BOSException {
        if (pks == null || pks.length == 0) {
            return false;
        }
        boolean flag = false;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT head.FID FROM T_SD_SALEORDER head LEFT OUTER JOIN T_SD_SALEORDERENTRY entries ");
        sql.append(" ON head.FID = entries.FPARENTID ");
        sql.append(" WHERE head.FID IN (");
        int length = pks.length;
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                sql.append(",");
            }
            sql.append("'").append(pks[i].toString()).append("'");
        }
        sql.append(")");
        sql.append(" AND entries.FNETORDERBILLID IS NOT NULL");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rowSet != null && rowSet.next()) {
                flag = true;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            flag = false;
        }
        return flag;
    }

    private void batchCheck(BatchActionResults batchResults) throws BOSException, EASBizException {
        if (BatchActionEnum.AUDIT.equals((Object)this.batchAction)) {
            IObjectPK[] pks = batchResults.getToDoPkArray();
            String[] ids = batchResults.getToDoIdsArray();
            if (ids.length != 0) {
                ArrayList<String> list = new ArrayList<String>();
                StringBuffer sql = new StringBuffer();
                sql.append("select FID from T_SD_SaleOrder where fid in ");
                sql.append(ArrayUtil.getInStringFromArray((String[])ids));
                sql.append(" and fbasestatus = 2 and FSourceBillTypeID='").append("MmEE6VBsR0KaUDQmebwhP0Y+1VI=").append("' ");
                IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
                try {
                    while (rs.next()) {
                        list.add(rs.getString("FID"));
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
                int count = list.size();
                if (count > 0) {
                    String[] saoIds = new String[count];
                    for (int i = 0; i < count; ++i) {
                        saoIds[i] = (String)list.get(i);
                    }
                    StockReqFacadeFactory.getLocalInstance((Context)this.ctx).batchCheckSrcBillStockReqAudit(saoIds);
                }
            }
            this.checkQty(this.ctx, pks, batchResults);
            this.checkReverse(batchResults);
        }
        this.handleReqPlan(batchResults);
    }

    private boolean checkReverse(BatchActionResults batchResults) throws BOSException, EASBizException {
        if (batchResults == null) {
            return false;
        }
        IObjectCollection col = batchResults.getObjCollection();
        if (CollectionUtil.isEmpty((IObjectCollection)col)) {
            return false;
        }
        boolean result = true;
        SaleOrderInfo saleOrderInfo = null;
        int size = col.size();
        for (int i = 0; i < size && (!(saleOrderInfo = (SaleOrderInfo)col.getObject(i)).isIsReverse() || (result = this.checkReverse((IObjectValue)saleOrderInfo))); ++i) {
        }
        return result;
    }

    private boolean checkReverse(IObjectValue model) throws BOSException, EASBizException {
        SaleOrderInfo saleOrderInfo = (SaleOrderInfo)model;
        SaleOrderInfo srcSaleOrderInfo = null;
        if (saleOrderInfo.getSourceBillType() != null && saleOrderInfo.getSourceBillType().getId().toString().equals("510b6503-0105-1000-e000-0113c0a812fd463ED552") && saleOrderInfo.getSourceBillId() != null && (srcSaleOrderInfo = SaleOrderFactory.getLocalInstance((Context)this.ctx).getSaleOrderInfo("select baseStatus where id = '" + saleOrderInfo.getSourceBillId() + "'")).getBaseStatus() != null && srcSaleOrderInfo.getBaseStatus().getValue() != 4) {
            throw new OrderException(OrderException.ORDER_CANNOT_REVERSE);
        }
        SaleOrderEntryCollection soeCollection = saleOrderInfo.getEntries();
        SaleOrderEntryInfo soEntryInfo = null;
        HashSet<String> soEntryIDSet = new HashSet<String>();
        int num = soeCollection.size();
        for (int i = 0; i < num; ++i) {
            soEntryInfo = soeCollection.get(i);
            if (soEntryInfo.getSourceBillType() == null || !soEntryInfo.getSourceBillType().getId().toString().equals("510b6503-0105-1000-e000-0113c0a812fd463ED552") || soEntryInfo.getSourceBillEntryId() == null) continue;
            soEntryIDSet.add(soEntryInfo.getSourceBillEntryId());
        }
        if (soEntryIDSet.size() > 0) {
            SaleOrderEntryInfo srcSOEntryInfo = null;
            HashSet<String> saleContractEntryIDSet = new HashSet<String>();
            ISaleOrderEntry iSaleOrderEntry = SaleOrderEntryFactory.getLocalInstance((Context)this.ctx);
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection selectorColl = view.getSelector();
            selectorColl.add(new SelectorItemInfo("baseStatus"));
            selectorColl.add(new SelectorItemInfo("isLocked"));
            selectorColl.add(new SelectorItemInfo("sourceBillType"));
            selectorColl.add(new SelectorItemInfo("sourceBillEntryId"));
            selectorColl.add(new SelectorItemInfo("qty"));
            selectorColl.add(new SelectorItemInfo("totalReversedQty"));
            selectorColl.add(new SelectorItemInfo("totalShippingQty"));
            selectorColl.add(new SelectorItemInfo("totalIssueQty"));
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", soEntryIDSet, CompareType.INCLUDE));
            view.setFilter(filterInfo);
            SaleOrderEntryCollection saleOrderColl = iSaleOrderEntry.getSaleOrderEntryCollection(view);
            int size = saleOrderColl.size();
            for (int i = 0; i < size; ++i) {
                BigDecimal totalIssueQty;
                srcSOEntryInfo = saleOrderColl.get(i);
                if (srcSOEntryInfo.getBaseStatus() != null && srcSOEntryInfo.getBaseStatus().getValue() != 4) {
                    throw new OrderException(OrderException.ORDER_SRC_ENTRY_CANNOT_REVERSE, (Object[])new String[]{String.valueOf(i + 1)});
                }
                if (srcSOEntryInfo.isIsLocked()) {
                    throw new OrderException(OrderException.ORDER_SRC_ENTRY_LOCKED_CANNOT_REVERSE, (Object[])new String[]{String.valueOf(i + 1)});
                }
                if (srcSOEntryInfo.getSourceBillType() != null && srcSOEntryInfo.getSourceBillType().getId().toString().equals("DEZBNUYZRM6ieHZ5GGlRc0Y+1VI=") && srcSOEntryInfo.getSourceBillEntryId() != null) {
                    saleContractEntryIDSet.add(srcSOEntryInfo.getSourceBillEntryId());
                }
                BigDecimal reverseQty = SCMUtils.effectualNumeric((BigDecimal)soEntryInfo.getQty()).abs();
                BigDecimal qty = SCMUtils.effectualNumeric((BigDecimal)srcSOEntryInfo.getQty());
                BigDecimal totalReversedQty = SCMUtils.effectualNumeric((BigDecimal)srcSOEntryInfo.getTotalReversedQty());
                BigDecimal totalShippingQty = SCMUtils.effectualNumeric((BigDecimal)srcSOEntryInfo.getTotalShippingQty());
                BigDecimal availReverseQty = totalShippingQty;
                availReverseQty = availReverseQty.compareTo(totalIssueQty = SCMUtils.effectualNumeric((BigDecimal)srcSOEntryInfo.getTotalIssueQty())) > 0 ? availReverseQty : totalIssueQty;
                availReverseQty = qty.subtract(totalReversedQty).subtract(availReverseQty);
            }
            if (saleContractEntryIDSet.size() > 0) {
                SaleContractEntryInfo srcSCEntryInfo = null;
                ISaleContractEntry iSaleContractEntry = SaleContractEntryFactory.getLocalInstance((Context)this.ctx);
                view = new EntityViewInfo();
                view.getSelector().add(new SelectorItemInfo("baseStatus"));
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", saleContractEntryIDSet, CompareType.INCLUDE));
                view.setFilter(filter);
                SaleContractEntryCollection saleContractEntryColl = iSaleContractEntry.getSaleContractEntryCollection(view);
                int size2 = saleContractEntryColl.size();
                for (int j = 0; j < size2; ++j) {
                    srcSCEntryInfo = saleContractEntryColl.get(j);
                    EntryBaseStatusEnum srcSCEntryBaseStatus = srcSCEntryInfo.getBaseStatus();
                    if (srcSCEntryBaseStatus == null || srcSCEntryBaseStatus.getValue() == 4 || srcSCEntryBaseStatus.getValue() == 7) continue;
                    throw new OrderException(OrderException.CANTRACT_SRC_ENTRY_CANNOT_REVERSE, (Object[])new String[]{String.valueOf(j + 1)});
                }
            }
        }
        return true;
    }

    private void checkQty(Context ctx, IObjectPK[] pks, BatchActionResults batchResults) throws BOSException, EASBizException {
        String idsStr = SCMBizProcessorUtil.convertToString((Object[])pks);
        String tmpTableName = null;
        StringBuffer sb = new StringBuffer();
        sb.append(" select (ce.fbaseqty*(1+ce.FsendOverRate/100) - isnull(ce.FTotalOrderedQty*mul.fbaseconvsrate,0) -(tt.FBaseQty-isnull(tt.FBeforeAlterQty,0))) as FLeftQty,");
        sb.append(" tt.FBaseQty as FBaseQty,ce.fbaseQty as cebaseQty,ce.fqty ceQty,");
        sb.append(" ce.FTotalOrderedQty*mul.fbaseconvsrate as FTotalOrderedQty, tt.FSOURCEBILLENTRYID as FSourceBillEntryID,isnull(tt.FBeforeAlterQty,0) as FBeforeAlterQty  ");
        sb.append(" from t_sd_salecontractentry ce ");
        sb.append(" INNER JOIN( ");
        sb.append(" select orderE.FSOURCEBILLENTRYID,orderE.fbaseunitid,orderE.FBaseQty AS FBaseQty, orderE.FQty AS FQty,historyOrder.FHistoryQty as FBeforeAlterQty ");
        sb.append(" FROM (select saleOrderE.FSOURCEBILLENTRYID,saleOrderE.fbaseunitid,sum(saleOrderE.FBaseQty) as FBaseQty,sum(saleOrderE.FQty) as FQty from T_SD_SaleOrderEntry saleOrderE");
        sb.append("   WHERE saleOrderE.FParentID IN (").append(idsStr).append(")  GROUP BY saleOrderE.FSourceBillEntryID,saleOrderE.fbaseunitid ) orderE");
        sb.append(" left outer join (select sum(sorderE.FBaseQty) as FHistoryQty,sorderE.FSourceBillEntryID as FSourceBillEntryID from t_sd_saleOrderEntry sorderE ");
        sb.append(" inner join t_sd_saleorder sorder on sorder.Fid=sorderE.Fparentid where sorder.FVersion in ");
        sb.append(" (select t2.FVersion-1 from t_sd_saleorder t2 where t2.fID in (").append(idsStr).append(") and t2.FVersion>0)");
        sb.append(" and sorder.foldID in (").append(idsStr).append(") group by sorderE.FSourceBillEntryID,sorderE.FBaseunitID) historyOrder ");
        sb.append(" on historyOrder.FSourceBillEntryID=orderE.FSourceBillEntryID");
        sb.append(" )tt  on tt.FSOURCEBILLENTRYID = ce.fid  ");
        sb.append(" left outer join t_bd_multimeasureUnit mul ");
        sb.append(" on mul.fmaterialid = ce.fmaterialid and mul.fmeasureunitid = ce.funitid ");
        sb.append(" where ce.fquantityunctrl = 0 and ce.fbaseQty <> 0 ");
        Connection con = null;
        Statement statement = null;
        ResultSet rs = null;
        HashMap hs = new HashMap();
        int errors = 0;
        String sceID = "";
        try {
            con = SCMBizProcessorUtil.getConnection((Context)ctx);
            statement = con.createStatement();
            rs = statement.executeQuery(sb.toString());
            while (rs.next()) {
                if (rs.getBigDecimal("FLeftQty").signum() == -1) {
                    sceID = rs.getString("FSourceBillEntryId");
                    HashMap<String, Object> errMap = new HashMap<String, Object>();
                    errMap.put("FSourceBillEntryId", rs.getString("FSourceBillEntryId"));
                    errMap.put("cebaseQty", rs.getBigDecimal("cebaseQty"));
                    errMap.put("FTotalOrderedQty", rs.getBigDecimal("FTotalOrderedQty"));
                    errMap.put("FBaseQty", rs.getBigDecimal("FBaseQty"));
                    errMap.put("FBeforeAlterQty", rs.getBigDecimal("FBeforeAlterQty"));
                    errMap.put("FLeftQty", rs.getBigDecimal("FLeftQty"));
                    hs.put(sceID, errMap);
                    ++errors;
                }
                if (errors < 5) continue;
            }
            if (errors > 0) {
                tmpTableName = this.getSOTmpTable(ctx, SCMBizProcessorUtil.convertToString((Object[])pks));
                this.showQtyRefCheckError(ctx, hs, tmpTableName, batchResults);
            }
        }
        catch (SQLException er) {
            try {
                throw new BOSException("sql Execute Error :", (Throwable)er);
            }
            catch (Throwable throwable) {
                DBUtil.releaseTempTable((Context)ctx, tmpTableName);
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup((Statement)statement, (Connection)con);
                SQLUtils.cleanup((Connection)con);
                throw throwable;
            }
        }
        DBUtil.releaseTempTable((Context)ctx, tmpTableName);
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((Statement)statement, (Connection)con);
        SQLUtils.cleanup((Connection)con);
    }

    private String getLocName(Context ctx) throws BOSException {
        return "FName_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale());
    }

    private void showQtyRefCheckError(Context ctx, HashMap errorHs, String tempTable, BatchActionResults batchResults) throws InvUpdateException, BOSException {
        Connection conn = null;
        Statement stmt = null;
        IRowSet rs = null;
        String locName = this.getLocName(ctx);
        StringBuffer sb = new StringBuffer();
        String qty_check_order = SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"QTY_CHECK_ORDER", (Context)ctx);
        String qty_check_2 = SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"QTY_CHECK_2", (Context)ctx);
        String qty_check_3 = SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"QTY_CHECK_3", (Context)ctx);
        String qty_check_4 = SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"QTY_CHECK_4", (Context)ctx);
        String row = SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"Row", (Context)ctx);
        Set keyset = errorHs.keySet();
        Iterator it = keyset.iterator();
        String sqlin = "";
        while (it.hasNext()) {
            sqlin = sqlin + ",'" + (String)it.next() + "'";
        }
        sqlin = sqlin.substring(1);
        try {
            conn = SCMBizProcessorUtil.getConnection((Context)ctx);
            sb.append(" select sc.fnumber as saleContractNumber, d.fparentid as fSaleOrderID,d.fseq as fseq,sce.fseq as fsseq,");
            sb.append(" d.fsourcebillentryid as fsourcebillentryid,a.").append(locName);
            sb.append(" as fmaterialname,c.").append(locName).append(" as fbaseunitname , ");
            sb.append(" b.FBaseConvsRate as FBaseConvsRate,b.FQtyPrecision as FQtyPrecision ");
            sb.append(" from  ").append(tempTable).append(" as d ");
            sb.append(" inner join t_bd_material a on a.fid = d.fmaterialid ");
            sb.append(" inner join t_bd_multimeasureunit b on b.fmaterialid = d.fmaterialid and b.fmeasureunitid = d.fbaseunitid ");
            sb.append(" inner join t_bd_measureunit c on c.fid = d.fbaseunitid ");
            sb.append(" inner join t_sd_salecontractentry sce on sce.fid = d.fsourcebillentryid ");
            sb.append(" inner join t_sd_salecontract sc on sce.fparentid = sc.fid ");
            sb.append(" where d.fsourcebillentryid in (").append(sqlin).append(") order by d.fseq");
            rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            String fSaleOrderID = "";
            String fsourcebillentryid = "";
            String fmaterialname = "";
            String fbaseunitname = "";
            Map map = null;
            int fseq = 0;
            while (rs.next()) {
                fsourcebillentryid = rs.getString("fsourcebillentryid");
                if (!errorHs.containsKey(fsourcebillentryid)) continue;
                map = (Map)errorHs.get(fsourcebillentryid);
                BigDecimal cebaseQty = (BigDecimal)map.get("cebaseQty");
                BigDecimal totalOrderedBaseQty = (BigDecimal)map.get("FTotalOrderedQty");
                BigDecimal baseQty = (BigDecimal)map.get("FBaseQty");
                BigDecimal beforeAlterQty = (BigDecimal)map.get("FBeforeAlterQty");
                baseQty = baseQty.subtract(beforeAlterQty).add(totalOrderedBaseQty);
                BigDecimal leftQty = (BigDecimal)map.get("FLeftQty");
                cebaseQty = cebaseQty.setScale(rs.getInt("FQtyPrecision"), 4);
                baseQty = baseQty.setScale(rs.getInt("FQtyPrecision"), 4);
                leftQty = leftQty.abs().setScale(rs.getInt("FQtyPrecision"), 4);
                fSaleOrderID = rs.getString("fSaleOrderID");
                fseq = rs.getInt("fseq");
                fmaterialname = rs.getString("fmaterialname");
                fbaseunitname = rs.getString("fbaseunitname");
                if (batchResults == null) {
                    throw new BOSException(qty_check_order + fseq + row + fmaterialname + qty_check_2 + cebaseQty + fbaseunitname + qty_check_3 + baseQty + fbaseunitname + qty_check_4 + leftQty + fbaseunitname);
                }
                batchResults.addError(fSaleOrderID, qty_check_order + fseq + row + fmaterialname + qty_check_2 + cebaseQty + fbaseunitname + qty_check_3 + baseQty + fbaseunitname + qty_check_4 + leftQty + fbaseunitname);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException("Sql execute exception : " + sb.toString(), (Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, stmt, (Connection)conn);
    }

    private String getSOTmpTable(Context ctx, String idsStr) throws BOSException, EASBizException {
        ITableManagerFacade iTableManager = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
        String tablename = iTableManager.getTableName("com.kingdee.eas.scm.sd.sale.app.SaleOrderControllerBean2");
        String createStr = this.getSO2SCTempTableSQL(tablename);
        iTableManager.createTempTable(createStr);
        String insertStr = this.getSO2SCInsertTempSQL(idsStr, tablename);
        Connection con = null;
        Statement stmt = null;
        try {
            con = SCMBizProcessorUtil.getConnection((Context)ctx);
            stmt = con.createStatement();
            stmt.executeUpdate(insertStr);
        }
        catch (SQLException e) {
            try {
                throw new BOSException("sql Execute Error :", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt);
                SQLUtils.cleanup((Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt);
        SQLUtils.cleanup((Connection)con);
        return tablename;
    }

    private void handleReqPlan(BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectPK[] pks = batchResults.getToDoPkArray();
        IReqPlanSaleOrderFacade iReqPlanSaleOrderFacade = ReqPlanSaleOrderFacadeFactory.getLocalInstance((Context)this.ctx);
        if (BatchActionEnum.AUDIT.equals((Object)this.batchAction)) {
            Object info = null;
            ArrayList<String> listAduit = new ArrayList<String>();
            ArrayList<String> listAlter = new ArrayList<String>();
            Map statusAlterMap = new HashMap();
            if (this.ctx.get((Object)"statusAlterMap") != null) {
                statusAlterMap = (Map)this.ctx.get((Object)"statusAlterMap");
            }
            String id = "";
            BillBaseStatusEnum baseStatus = null;
            for (int i = 0; i < pks.length; ++i) {
                id = pks[i].toString();
                if (statusAlterMap != null) {
                    baseStatus = (BillBaseStatusEnum)statusAlterMap.get(id);
                }
                if (baseStatus != null && BillBaseStatusEnum.ALTERING.equals((Object)baseStatus)) {
                    listAlter.add(id);
                    continue;
                }
                listAduit.add(id);
            }
            if (listAduit != null && listAduit.size() > 0) {
                iReqPlanSaleOrderFacade.requireFromSaleOrder(listAduit, BizActionEnum.AUDIT);
            }
            if (listAlter != null && listAlter.size() > 0) {
                iReqPlanSaleOrderFacade.requireFromSaleOrder(listAlter, BizActionEnum.ALTER);
            }
            this.ctx.put((Object)"statusAlterMap", null);
        } else if (BatchActionEnum.UNAUDIT.equals((Object)this.batchAction)) {
            Object info = null;
            ArrayList<String> listUnAduit = new ArrayList<String>();
            for (int i = 0; i < pks.length; ++i) {
                listUnAduit.add(pks[i].toString());
            }
            if (listUnAduit != null && listUnAduit.size() > 0) {
                iReqPlanSaleOrderFacade.requireFromSaleOrder(listUnAduit, BizActionEnum.UNAUDIT);
            }
        }
    }

    private String getSO2SCTempTableSQL(String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE ");
        sql.append(temptable);
        sql.append("(FParentID VARCHAR(44),");
        sql.append("FSourceBillEntryID VARCHAR(44),");
        sql.append("FUnitID VARCHAR(44),");
        sql.append("fbaseunitid VARCHAR(44),");
        sql.append("FBaseQty DECIMAL(21,8),");
        sql.append("FQty DECIMAL(21,8),");
        sql.append("FSeq int,");
        sql.append("FMaterialID varchar(44))");
        return sql.toString();
    }

    private String getSO2SCInsertTempSQL(String idList, String temptable) {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ");
        sql.append(temptable);
        sql.append(" SELECT FParentID,FSourceBillEntryID,FUnitID,fbaseunitid,SUM(FBaseQty) AS FBaseQty, SUM(FQty) AS FQty,FSeq, FMaterialID ");
        sql.append("FROM T_SD_SaleOrderEntry WHERE FParentID IN (");
        sql.append(idList);
        sql.append(") GROUP BY FParentID,FSourceBillEntryID,FUnitID,fbaseunitid,FSeq,FMaterialID");
        return sql.toString();
    }
}

