/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.app.bizprocess.processor.saleorder;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import com.kingdee.eas.scm.util.array.ArrayUtil;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Set;

public class SOWriteBack4ReserseUnAuditProcessor
extends AbstractBusinessProcessor {
    private static final long serialVersionUID = 107115959272614264L;

    public SOWriteBack4ReserseUnAuditProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public SOWriteBack4ReserseUnAuditProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public SOWriteBack4ReserseUnAuditProcessor(ProcessorConstructParam param) {
        super(param);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectValue objVal = null;
        IObjectCollection objCol = batchResults.getObjCollection();
        IObjectPK[] pks = batchResults.getToDoPkArray();
        if (pks == null || pks.length == 0) {
            return;
        }
        Set flowSet = SCMServerUtils.getHasBizFlowValueBillID((Context)this.ctx, (String)"T_SD_SaleOrderEntry", (IObjectPK[])pks);
        int size = objCol.size();
        for (int i = 0; i < size; ++i) {
            objVal = objCol.getObject(i);
            if (flowSet != null && flowSet.contains(objVal.get("id").toString())) continue;
            this.writeBack(objVal);
        }
    }

    private void writeBack(IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            return;
        }
        SaleOrderInfo info = (SaleOrderInfo)model;
        String id = info.getId().toString();
        Connection con = null;
        Statement statement = null;
        Statement batchStatement = null;
        ResultSet checkSet = null;
        try {
            con = this.getConnection(this.ctx);
            statement = con.createStatement();
            batchStatement = con.createStatement();
            ResultSet rs = statement.executeQuery("select FID, FISREVERSE from T_SD_SaleOrder where fid in('" + id + "')");
            StringBuffer pksReverse = new StringBuffer();
            int jj = 0;
            while (rs.next()) {
                String fid = rs.getString("FID");
                boolean fisreverse = rs.getBoolean("FISREVERSE");
                if (!fisreverse) continue;
                if (jj > 0) {
                    pksReverse.append(",");
                }
                pksReverse.append("'").append(fid).append("'");
                ++jj;
            }
            if (pksReverse.length() > 0) {
                this.writeSourceBillForSaleOrderByReverseBillUnAudit(this.ctx, pksReverse.toString());
                this.writeSourceBillForSaleContractByReverseBillUnAudit(this.ctx, pksReverse.toString());
            }
        }
        catch (SQLException er) {
            try {
                throw new BOSException("sql Execute Error :", (Throwable)er);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(checkSet);
                SQLUtils.cleanup(statement, (Connection)con);
                SQLUtils.cleanup(batchStatement, (Connection)con);
                SQLUtils.cleanup((Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup(checkSet);
        SQLUtils.cleanup((Statement)statement, (Connection)con);
        SQLUtils.cleanup((Statement)batchStatement, (Connection)con);
        SQLUtils.cleanup((Connection)con);
    }

    protected Connection getConnection(Context ctx) throws SQLDataException {
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeSourceBillForSaleOrderByReverseBillUnAudit(Context ctx, String params) throws SQLException, BOSException {
        Connection con = null;
        Statement selectStmt = null;
        PreparedStatement updatePstmt = null;
        Statement stmt = null;
        ResultSet rs = null;
        StringBuffer selectSql = new StringBuffer(500);
        selectSql.append("select soe.FUnitID, soe.FQty, soe.FBaseQty, soe2.FID, soe2.FUnitID as FUnitID2,");
        selectSql.append(" soe2.FTotalReversedQty, soe2.FTotalReversedBaseQty, ");
        selectSql.append(" soe2.FTotalUnIssueQty, soe2.FTotalUnIssueBaseQty, soe2.FTotalUnShipBaseQty, ");
        selectSql.append(" soe2.FTotalUnReturnBaseQty, soe2.FAssociateQty, soe2.FUnOrderedQty, soe2.FIsBySaleOrder, mu.FBaseConvsRate ");
        selectSql.append(" from T_SD_SaleOrderEntry soe ");
        selectSql.append(" inner join T_SD_SaleOrderEntry soe2 on soe2.FID = soe.FSourceBillEntryId ");
        selectSql.append(" left outer join T_BD_MultiMeasureUnit mu on mu.FMaterialID = soe2.FMaterialID ");
        selectSql.append(" and mu.FMeasureUnitID = soe2.FUnitID ");
        selectSql.append(" where soe.FParentID in(").append(params).append(")");
        StringBuffer updateSql = new StringBuffer(300);
        updateSql.append("update T_SD_SaleOrderEntry set ");
        updateSql.append(" FTotalReversedQty = ?, FTotalReversedBaseQty = ?, FTotalUnIssueQty = ?, FTotalUnIssueBaseQty = ?, ");
        updateSql.append(" FTotalUnShipBaseQty = ?, FTotalUnReturnBaseQty = ?, FAssociateQty = ?, FUnOrderedQty = ? ");
        updateSql.append(" where FID = ?");
        ArrayList<String> arrList = new ArrayList<String>();
        try {
            con = this.getConnection(ctx);
            selectStmt = con.createStatement();
            updatePstmt = con.prepareStatement(updateSql.toString());
            rs = selectStmt.executeQuery(selectSql.toString());
            if (rs.next()) {
                do {
                    String currUnitID = rs.getString("FUnitID");
                    BigDecimal currQty = SCMUtils.effectualNumeric((BigDecimal)rs.getBigDecimal("FQty")).abs();
                    BigDecimal currBaseQty = SCMUtils.effectualNumeric((BigDecimal)rs.getBigDecimal("FBaseQty")).abs();
                    String fid = rs.getString("FID");
                    arrList.add(fid);
                    String unitID = rs.getString("FUnitID2");
                    BigDecimal totalReversedQty = rs.getBigDecimal("FTotalReversedQty");
                    BigDecimal totalReversedBaseQty = rs.getBigDecimal("FTotalReversedBaseQty");
                    BigDecimal totalUnIssueQty = rs.getBigDecimal("FTotalUnIssueQty");
                    BigDecimal totalUnIssueBaseQty = rs.getBigDecimal("FTotalUnIssueBaseQty");
                    BigDecimal totalUnShipBaseQty = rs.getBigDecimal("FTotalUnShipBaseQty");
                    BigDecimal totalUnReturnBaseQty = rs.getBigDecimal("FTotalUnReturnBaseQty");
                    BigDecimal associateQty = rs.getBigDecimal("FAssociateQty");
                    BigDecimal unOrderedQty = rs.getBigDecimal("FUnOrderedQty");
                    boolean isBySaleOrder = rs.getBoolean("FIsBySaleOrder");
                    BigDecimal baseConvsRate = rs.getBigDecimal("FBaseConvsRate");
                    if (baseConvsRate == null) {
                        baseConvsRate = BigDecimal.ONE;
                    }
                    if (currUnitID != null && !currUnitID.equals(unitID)) {
                        currQty = currBaseQty.divide(baseConvsRate, currQty.scale(), 4);
                    }
                    totalReversedQty = SCMUtils.effectualNumeric((BigDecimal)totalReversedQty).subtract(currQty);
                    totalReversedBaseQty = SCMUtils.effectualNumeric((BigDecimal)totalReversedBaseQty).subtract(currBaseQty);
                    totalUnIssueQty = SCMUtils.effectualNumeric((BigDecimal)totalUnIssueQty).add(currQty);
                    totalUnIssueBaseQty = SCMUtils.effectualNumeric((BigDecimal)totalUnIssueBaseQty).add(currBaseQty);
                    totalUnShipBaseQty = SCMUtils.effectualNumeric((BigDecimal)totalUnShipBaseQty).add(currBaseQty);
                    totalUnReturnBaseQty = SCMUtils.effectualNumeric((BigDecimal)totalUnReturnBaseQty).add(currBaseQty);
                    associateQty = SCMUtils.effectualNumeric((BigDecimal)associateQty).add(currBaseQty);
                    if (isBySaleOrder) {
                        unOrderedQty = SCMUtils.effectualNumeric((BigDecimal)unOrderedQty).add(currQty);
                    }
                    updatePstmt.setBigDecimal(1, totalReversedQty);
                    updatePstmt.setBigDecimal(2, totalReversedBaseQty);
                    updatePstmt.setBigDecimal(3, totalUnIssueQty);
                    updatePstmt.setBigDecimal(4, totalUnIssueBaseQty);
                    updatePstmt.setBigDecimal(5, totalUnShipBaseQty);
                    updatePstmt.setBigDecimal(6, totalUnReturnBaseQty);
                    updatePstmt.setBigDecimal(7, associateQty);
                    updatePstmt.setBigDecimal(8, unOrderedQty);
                    updatePstmt.setString(9, fid);
                    updatePstmt.addBatch();
                } while (rs.next());
                updatePstmt.executeBatch();
                stmt = con.createStatement();
                String ids = ArrayUtil.getStringFromArr((Object[])arrList.toArray());
                String updateSql2 = new StringBuffer().append("update T_SD_SaleOrderEntry set FBaseStatus = 4, FReason = null ").append(" where FBaseStatus = 7 and FID in(").append(ids).append(")").append(" and (((case when FTotalIssueQty>FTotalShippingQty then FTotalIssueQty else FTotalShippingQty end) + FTotalReversedQty) < FQty) ").toString();
                stmt.addBatch(updateSql2);
                String updateSql3 = new StringBuffer().append("update T_SD_SaleOrder set FBaseStatus = 4 ").append(" where FBaseStatus = 7 and FID in(select FParentID from T_SD_SaleOrderEntry where FBaseStatus = 4 and FID in(").append(ids).append("))").toString();
                stmt.addBatch(updateSql3);
                stmt.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLException(e.getMessage());
                catch (SQLDataException e2) {
                    throw new SQLException(e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup(stmt);
                SQLUtils.cleanup(updatePstmt);
                SQLUtils.cleanup((Statement)selectStmt);
                SQLUtils.cleanup((Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup(stmt);
        SQLUtils.cleanup((Statement)updatePstmt);
        SQLUtils.cleanup((Statement)selectStmt);
        SQLUtils.cleanup((Connection)con);
    }

    private void writeSourceBillForSaleContractByReverseBillUnAudit(Context ctx, String params) throws SQLException, BOSException {
        Connection con = null;
        Statement selectStmt = null;
        PreparedStatement updatePstmt = null;
        Statement stmt = null;
        ResultSet rs = null;
        String selectSql = new StringBuffer().append("select soe.FUnitID, soe.FQty, soe.FBaseQty, soe.FTaxAmount, sce.FID, sce.FUnitID as FUnitID2, sce.FTotalOrderedQty, sce.FTotalOrderedAmt, mu.FBaseConvsRate ").append(" from T_SD_SaleOrderEntry soe ").append(" inner join T_SD_SaleOrderEntry soe2 on soe2.FID = soe.FSourceBillEntryId ").append(" inner join T_SD_SaleContractEntry sce on sce.FID = soe2.FSourceBillEntryId ").append(" left outer join T_BD_MultiMeasureUnit mu on mu.FMaterialID = sce.FMaterialID and mu.FMeasureUnitID = sce.FUnitID ").append(" where soe.FParentID in(").append(params).append(")").toString();
        String updateSql = new StringBuffer().append("update T_SD_SaleContractEntry set FTotalOrderedQty = ?, FTotalOrderedAmt = ? where FID = ?").toString();
        ArrayList<String> arrList = new ArrayList<String>();
        try {
            con = this.getConnection(ctx);
            selectStmt = con.createStatement();
            updatePstmt = con.prepareStatement(updateSql);
            rs = selectStmt.executeQuery(selectSql);
            if (rs.next()) {
                do {
                    String currUnitID = rs.getString("FUnitID");
                    BigDecimal currQty = SCMUtils.effectualNumeric((BigDecimal)rs.getBigDecimal("FQty")).abs();
                    BigDecimal currBaseQty = SCMUtils.effectualNumeric((BigDecimal)rs.getBigDecimal("FBaseQty")).abs();
                    BigDecimal currTaxAmount = SCMUtils.effectualNumeric((BigDecimal)rs.getBigDecimal("FTaxAmount")).abs();
                    String fid = rs.getString("FID");
                    arrList.add(fid);
                    String unitID = rs.getString("FUnitID2");
                    BigDecimal totalOrderedQty = rs.getBigDecimal("FTotalOrderedQty");
                    BigDecimal totalOrderedAmt = rs.getBigDecimal("FTotalOrderedAmt");
                    BigDecimal baseConvsRate = rs.getBigDecimal("FBaseConvsRate");
                    if (baseConvsRate == null) {
                        baseConvsRate = BigDecimal.ONE;
                    }
                    if (currUnitID != null && !currUnitID.equals(unitID)) {
                        currQty = currBaseQty.divide(baseConvsRate, currQty.scale(), 4);
                    }
                    totalOrderedQty = SCMUtils.effectualNumeric((BigDecimal)totalOrderedQty).add(currQty);
                    totalOrderedAmt = SCMUtils.effectualNumeric((BigDecimal)totalOrderedAmt).add(currTaxAmount);
                    updatePstmt.setBigDecimal(1, totalOrderedQty);
                    updatePstmt.setBigDecimal(2, totalOrderedAmt);
                    updatePstmt.setString(3, fid);
                    updatePstmt.addBatch();
                } while (rs.next());
                updatePstmt.executeBatch();
                stmt = con.createStatement();
                String ids = ArrayUtil.getStringFromArr((Object[])arrList.toArray());
                String updateSql2 = new StringBuffer().append("update T_SD_SaleContractEntry set FBaseStatus = 7, FReason = null ").append(" where FBaseStatus = 4 and FQuantityUnCtrl = 0 and FQty <> 0 and FTotalOrderedQty >= FQty and FID in(").append(ids).append(")").toString();
                stmt.addBatch(updateSql2);
                String updateSql3 = new StringBuffer().append("update T_SD_SaleContract set FBaseStatus = 7 ").append(" where FBaseStatus = 4 and FID in(select FParentID from T_SD_SalecontractEntry where FBaseStatus = 7 and FID in(").append(ids).append("))").append(" and FID not in(select FParentID from T_SD_SalecontractEntry where FBaseStatus <> 7 and FParentID in( ").append(" select FParentID from T_SD_SalecontractEntry where FBaseStatus = 7 and FID in(").append(ids).append(")))").toString();
                stmt.addBatch(updateSql3);
                stmt.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLException(e.getMessage());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup(selectStmt);
                SQLUtils.cleanup(updatePstmt);
                SQLUtils.cleanup(stmt);
                SQLUtils.cleanup((Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((Statement)selectStmt);
        SQLUtils.cleanup((Statement)updatePstmt);
        SQLUtils.cleanup(stmt);
        SQLUtils.cleanup((Connection)con);
    }
}

