/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.app.bizprocess.processor.saleorder;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.planning.IReqPlanSaleOrderFacade;
import com.kingdee.eas.mm.planning.ReqPlanSaleOrderFacadeFactory;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.SDSMBillBaseInfo;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.sd.channel.app.WriteBackNetOrderHandleFactory;
import com.kingdee.eas.scm.sd.sale.SaleContractFactory;
import com.kingdee.eas.scm.sd.sale.SaleContractInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderCollection;
import com.kingdee.eas.scm.sd.sale.SaleOrderFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import com.kingdee.eas.scm.sd.sale.app.bizprocess.processor.saleorder.SOrderWriteBackSContract;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SOWriteBack4UnAuditProcessor
extends AbstractBusinessProcessor {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sd.sale.app.bizprocess.processor.saleorder.SOWriteBack4UnAuditProcessor");
    private static final long serialVersionUID = 1626481810724016057L;

    public SOWriteBack4UnAuditProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public SOWriteBack4UnAuditProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public SOWriteBack4UnAuditProcessor(ProcessorConstructParam param) {
        super(param);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        int i;
        int size;
        IObjectValue objVal = null;
        IObjectCollection objCol = batchResults.getObjCollection();
        IObjectPK[] pks = batchResults.getToDoPkArray();
        if (pks == null || pks.length == 0) {
            return;
        }
        Set flowSet = SCMServerUtils.getHasBizFlowValueBillID((Context)this.ctx, (String)"T_SD_SaleOrderEntry", (IObjectPK[])pks);
        int size2 = objCol.size();
        for (int i2 = 0; i2 < size2; ++i2) {
            objVal = objCol.getObject(i2);
            if (flowSet != null && flowSet.contains(objVal.get("id").toString())) continue;
            this.writeBack(objVal);
        }
        ArrayList<String> idList = new ArrayList<String>();
        if (flowSet != null && flowSet.size() > 0) {
            size = pks.length;
            for (i = 0; i < size; ++i) {
                if (flowSet.contains(pks[i].toString())) continue;
                idList.add(pks[i].toString());
            }
        }
        if (idList.size() > 0) {
            pks = null;
            pks = new IObjectPK[idList.size()];
            size = idList.size();
            for (i = 0; i < size; ++i) {
                pks[i] = new ObjectUuidPK(idList.get(i).toString());
            }
        }
        if (pks != null && pks.length > 0) {
            this.writeBackNetOrder(pks);
        }
        this.handleReqPlan(batchResults);
    }

    protected Connection getConnection(Context ctx) throws SQLDataException {
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
    }

    private void writeBackNetOrder(IObjectPK[] pks) throws BOSException, EASBizException {
        if (BatchActionEnum.UNAUDIT.equals((Object)this.batchAction)) {
            if (pks.length == 0) {
                return;
            }
            if (this.isNeedToReWriteNetOrder(this.ctx, pks)) {
                WriteBackNetOrderHandleFactory.headHandle((Context)this.ctx, (String)this.getBOSType().toString(), (BizActionEnum)BizActionEnum.UNAUDIT, (IObjectPK[])pks);
            }
            WriteBackNetOrderHandleFactory.headHandleB2C((Context)this.ctx, (String)this.getBOSType().toString(), (BizActionEnum)BizActionEnum.UNAUDIT, (IObjectPK[])pks);
        }
    }

    private boolean isNeedToReWriteNetOrder(Context ctx, IObjectPK[] pks) throws BOSException {
        if (pks == null || pks.length == 0) {
            return false;
        }
        boolean flag = false;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT head.FID FROM T_SD_SALEORDER head LEFT OUTER JOIN T_SD_SALEORDERENTRY entries ");
        sql.append(" ON head.FID = entries.FPARENTID ");
        sql.append(" WHERE head.FID IN (");
        int length = pks.length;
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                sql.append(",");
            }
            sql.append("'").append(pks[i].toString()).append("'");
        }
        sql.append(")");
        sql.append(" AND entries.FNETORDERBILLID IS NOT NULL");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rowSet != null && rowSet.next()) {
                flag = true;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            flag = false;
        }
        return flag;
    }

    protected BOSObjectType getBOSType() {
        return new BOSObjectType("C48A423A");
    }

    private void writeBack(IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            return;
        }
        SaleOrderInfo info = (SaleOrderInfo)model;
        String id = info.getId().toString();
        Connection con = null;
        Statement statement = null;
        Statement batchStatement = null;
        ResultSet checkSet = null;
        try {
            con = this.getConnection(this.ctx);
            statement = con.createStatement();
            batchStatement = con.createStatement();
            ResultSet rs = statement.executeQuery("select FID, FISREVERSE from T_SD_SaleOrder where fid in('" + id + "')");
            StringBuffer pksNormal = new StringBuffer();
            int ii = 0;
            while (rs.next()) {
                String fid = rs.getString("FID");
                boolean fisreverse = rs.getBoolean("FISREVERSE");
                if (fisreverse) continue;
                if (ii > 0) {
                    pksNormal.append(",");
                }
                pksNormal.append("'").append(fid).append("'");
                ++ii;
            }
            if (pksNormal.length() > 0) {
                SaleOrderCollection socNormal = SaleOrderFactory.getLocalInstance((Context)this.ctx).getSaleOrderCollection(" where id in (" + pksNormal.toString() + ")");
                SOrderWriteBackSContract.writeSourceBillForSaleContract(this.ctx, "'" + id + "'", "-");
                this.updateSourceBillState(this.ctx, socNormal);
            }
        }
        catch (SQLException er) {
            try {
                throw new BOSException("sql Execute Error :", (Throwable)er);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(checkSet);
                SQLUtils.cleanup(statement, (Connection)con);
                SQLUtils.cleanup(batchStatement, (Connection)con);
                SQLUtils.cleanup((Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup(checkSet);
        SQLUtils.cleanup((Statement)statement, (Connection)con);
        SQLUtils.cleanup((Statement)batchStatement, (Connection)con);
        SQLUtils.cleanup((Connection)con);
    }

    private void updateSourceBillState(Context ctx, SaleOrderCollection soc) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("baseStatus"));
        sic.add(new SelectorItemInfo("entries.id"));
        sic.add(new SelectorItemInfo("entries.baseStatus"));
        sic.add(new SelectorItemInfo("entries.totalOrderedQty"));
        sic.add(new SelectorItemInfo("entries.qty"));
        sic.add(new SelectorItemInfo("entries.reason"));
        int cont = soc.size();
        for (int i = 0; i < cont; ++i) {
            SaleOrderInfo info = soc.get(i);
            if (info.getSourceBillType() == null || !info.getSourceBillType().getId().toString().equals("DEZBNUYZRM6ieHZ5GGlRc0Y+1VI=")) continue;
            for (String srcBotpBillID : SCMServerUtils.getSrcBotpBills((Context)ctx, (String)info.getId().toString(), (String)info.getBOSType().toString())) {
                SaleContractInfo srcInfo = null;
                if (srcBotpBillID == null) continue;
                srcInfo = SaleContractFactory.getLocalInstance((Context)ctx).getSaleContractInfo((IObjectPK)new ObjectUuidPK(srcBotpBillID), sic);
                if (srcInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.BLOCKED)) {
                    throw new SCMBillException(SCMBillException.HASBLOCKED_CANNOTUNAUDIT, new Object[]{info.getNumber()});
                }
                boolean containAuditEntry = false;
                int size = srcInfo.getEntries().size();
                for (int index = 0; index < size; ++index) {
                    if (!srcInfo.getEntries().get(index).getBaseStatus().equals((Object)EntryBaseStatusEnum.CLOSED)) continue;
                    BigDecimal totalOrderedQty = srcInfo.getEntries().get(index).getTotalOrderedQty();
                    BigDecimal qty = srcInfo.getEntries().get(index).getQty();
                    if (totalOrderedQty == null || totalOrderedQty.compareTo(qty) != -1 || SCMConstant.BIGDECIMAL_ZERO.compareTo(qty) == 0) continue;
                    srcInfo.getEntries().get(index).setBaseStatus(EntryBaseStatusEnum.AUDITED);
                    srcInfo.getEntries().get(index).setReason(null);
                    containAuditEntry = true;
                }
                if (!containAuditEntry) continue;
                srcInfo.setBaseStatus(BillBaseStatusEnum.AUDITED);
                SaleContractFactory.getLocalInstance((Context)ctx).updatePartial((SDSMBillBaseInfo)srcInfo, sic);
            }
        }
    }

    private void handleReqPlan(BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectPK[] pks = batchResults.getToDoPkArray();
        IReqPlanSaleOrderFacade iReqPlanSaleOrderFacade = ReqPlanSaleOrderFacadeFactory.getLocalInstance((Context)this.ctx);
        if (BatchActionEnum.AUDIT.equals((Object)this.batchAction)) {
            Object info = null;
            ArrayList<String> listAduit = new ArrayList<String>();
            ArrayList<String> listAlter = new ArrayList<String>();
            Map statusAlterMap = new HashMap();
            if (this.ctx.get((Object)"statusAlterMap") != null) {
                statusAlterMap = (Map)this.ctx.get((Object)"statusAlterMap");
            }
            String id = "";
            BillBaseStatusEnum baseStatus = null;
            for (int i = 0; i < pks.length; ++i) {
                id = pks[i].toString();
                if (statusAlterMap != null) {
                    baseStatus = (BillBaseStatusEnum)statusAlterMap.get(id);
                }
                if (baseStatus != null && BillBaseStatusEnum.ALTERING.equals((Object)baseStatus)) {
                    listAlter.add(id);
                    continue;
                }
                listAduit.add(id);
            }
            if (listAduit != null && listAduit.size() > 0) {
                iReqPlanSaleOrderFacade.requireFromSaleOrder(listAduit, BizActionEnum.AUDIT);
            }
            if (listAlter != null && listAlter.size() > 0) {
                iReqPlanSaleOrderFacade.requireFromSaleOrder(listAlter, BizActionEnum.ALTER);
            }
            this.ctx.put((Object)"statusAlterMap", null);
        } else if (BatchActionEnum.UNAUDIT.equals((Object)this.batchAction)) {
            Object info = null;
            ArrayList<String> listUnAduit = new ArrayList<String>();
            for (int i = 0; i < pks.length; ++i) {
                listUnAduit.add(pks[i].toString());
            }
            if (listUnAduit != null && listUnAduit.size() > 0) {
                iReqPlanSaleOrderFacade.requireFromSaleOrder(listUnAduit, BizActionEnum.UNAUDIT);
            }
        }
    }
}

