/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.app.bizprocess.processor.saleorder;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.im.inv.StockReqEntryFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import com.kingdee.eas.scm.util.array.ArrayUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class SOWriteBackStockReq4UnAuditProcessor
extends AbstractBusinessProcessor {
    private static final long serialVersionUID = -8417496356156935635L;

    public SOWriteBackStockReq4UnAuditProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public SOWriteBackStockReq4UnAuditProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public SOWriteBackStockReq4UnAuditProcessor(ProcessorConstructParam param) {
        super(param);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectValue objVal = null;
        IObjectCollection objCol = batchResults.getObjCollection();
        IObjectPK[] pks = batchResults.getToDoPkArray();
        if (pks == null || pks.length == 0) {
            return;
        }
        Set flowSet = SCMServerUtils.getHasBizFlowValueBillID((Context)this.ctx, (String)"T_SD_SaleOrderEntry", (IObjectPK[])pks);
        int size = objCol.size();
        for (int i = 0; i < size; ++i) {
            objVal = objCol.getObject(i);
            if (flowSet != null && flowSet.contains(objVal.get("id").toString())) continue;
            this.writeBack(objVal);
        }
    }

    private void writeBack(IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            return;
        }
        SaleOrderInfo info = (SaleOrderInfo)model;
        String id = info.getId().toString();
        this.writeBackToWantReq(this.ctx, new String[]{id}, BizActionEnum.UNAUDIT);
        this.clearInnerDealPrice(this.ctx, new String[]{id});
    }

    protected Connection getConnection(Context ctx) throws SQLDataException {
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
    }

    private void writeBackToWantReq(Context ctx, String[] pks, BizActionEnum enums) throws BOSException, EASBizException {
        int length = pks.length;
        StringBuffer currentIds = new StringBuffer("");
        for (int i = 0; i < length; ++i) {
            if (i == length - 1) {
                currentIds.append("'").append(pks[i].toString()).append("'");
                continue;
            }
            currentIds.append("'").append(pks[i].toString()).append("'").append(",");
        }
        StringBuffer paramQuestionMark = new StringBuffer();
        Object[] curIdArray = new String[length];
        for (int i = 0; i < length; ++i) {
            paramQuestionMark.append(i == 0 ? "?" : ",?");
            curIdArray[i] = pks[i].toString();
        }
        try {
            StringBuffer sqlbuffer = new StringBuffer();
            sqlbuffer.append(" select ").append(" FSourceBillId, FSourceBillEntryID").append(" from t_sd_saleorderentry ").append(" where fparentid in (").append(paramQuestionMark.toString()).append(")").append(" and FSourceBillTypeId = '").append("MmEE6VBsR0KaUDQmebwhP0Y+1VI=").append("' ").append(" group by FSourceBillId, FSourceBillEntryID ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlbuffer.toString(), (Object[])curIdArray);
            ArrayList<String> list = new ArrayList<String>();
            ArrayList<String> srcEntryIDList = new ArrayList<String>();
            while (rs.next()) {
                list.add(rs.getString(1));
                srcEntryIDList.add(rs.getString(2));
            }
            if (list.size() > 0) {
                String[] srcIdArr = new String[list.size()];
                list.toArray(srcIdArr);
            }
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
    }

    private void howCloseSourceBill(List srcEntryIDList, Context ctx, BizActionEnum enums) throws EASBizException, BOSException {
        boolean isAudit = true;
        if (enums.equals((Object)BizActionEnum.UNAUDIT)) {
            isAudit = false;
        }
        if (srcEntryIDList == null || srcEntryIDList.size() == 0) {
            return;
        }
        if (isAudit) {
            StockReqEntryFactory.getLocalInstance((Context)ctx).autoClose(srcEntryIDList);
        } else {
            StockReqEntryFactory.getLocalInstance((Context)ctx).autoUnClose(srcEntryIDList);
        }
    }

    private void clearInnerDealPrice(Context ctx, String[] pks) throws BOSException {
        Connection con = null;
        Statement statement = null;
        StringBuffer str = new StringBuffer();
        try {
            con = this.getConnection(ctx);
            statement = con.createStatement();
            String params = ArrayUtil.getStringFromArr((Object[])pks);
            str.append(" delete ").append(" T_SD_SaleInnerDealPrice ").append(" where FSaleOrderId in(").append(params).append(")");
            statement.executeUpdate(str.toString());
        }
        catch (SQLException er) {
            try {
                throw new BOSException("sql Execute Error :", (Throwable)er);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)con);
                SQLUtils.cleanup((Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)con);
        SQLUtils.cleanup((Connection)con);
    }
}

