/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.app.bizprocess.processor.saleorder;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.ProcessorExecutionMode;
import com.kingdee.eas.dynbusiness.ProcessorExecutionModeEnum;
import com.kingdee.eas.dynbusiness.TransactionModeEnum;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.credit.app.processor.CreditUpdateHelper;
import com.kingdee.eas.scm.im.inv.InvUpdateException;
import com.kingdee.eas.scm.sd.sale.ISaleContractEntry;
import com.kingdee.eas.scm.sd.sale.ISaleOrder;
import com.kingdee.eas.scm.sd.sale.ISaleOrderEntry;
import com.kingdee.eas.scm.sd.sale.OrderException;
import com.kingdee.eas.scm.sd.sale.SaleContractEntryCollection;
import com.kingdee.eas.scm.sd.sale.SaleContractEntryFactory;
import com.kingdee.eas.scm.sd.sale.SaleContractEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryCollection;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import com.kingdee.eas.scm.sd.sale.app.bizprocess.processor.SaleBizDataCheckProcessor;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class SaleOrderBizDataPreCheckProcessor
extends SaleBizDataCheckProcessor {
    private static final long serialVersionUID = 1L;
    private static final BigDecimal ZERO = new BigDecimal("0.00");

    public String getServerResource(String key) {
        return SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)key, (Context)this.ctx);
    }

    public SaleOrderBizDataPreCheckProcessor(ExecuteContext executeContext, ProcessorExecutionModeEnum executeMode, Conditions conditions, TransactionModeEnum transactionMode) {
        super(executeContext, executeMode, conditions, transactionMode);
    }

    public SaleOrderBizDataPreCheckProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    @Override
    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectCollection collection = batchResults.getObjCollection();
        if (collection == null) {
            return;
        }
        SaleOrderInfo info = null;
        boolean isFromGui = false;
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            IObjectValue vo = collection.getObject(i);
            if (vo == null) continue;
            info = (SaleOrderInfo)vo;
            if (i == 0 && info.get("isFromGui") == null) {
                isFromGui = true;
                info.remove("isFromGui");
            }
            if (this.batchAction.equals((Object)BatchActionEnum.SAVE)) {
                this.checkHeadForSave(info);
                this.checkSave(info);
            }
            if (this.batchAction.equals((Object)BatchActionEnum.SUBMIT)) {
                if (!isFromGui) {
                    this.checkHeadForSubmit(info);
                    this.checkEntry(info);
                }
                this.checkReverse((IObjectValue)info);
                this.checkBizDate(info);
                if (null != info.getId()) {
                    ObjectUuidPK pk = new ObjectUuidPK(info.getId().toString());
                    IRowSet rs = CreditUpdateHelper.getPreUpdateData((Context)this.ctx, (Object[])new Object[]{pk});
                    info.put("CreditUpdateData", (Object)rs);
                }
            }
            if (!this.batchAction.equals((Object)BatchActionEnum.AUDIT)) continue;
        }
    }

    private void checkHeadForSave(SaleOrderInfo info) throws BOSException, EASBizException {
        if (info.getBaseStatus().getValue() != 0 && info.getBaseStatus().getValue() != 1) {
            throw new OrderException(OrderException.ORDER_ONLYTEMP_CANBE_SAVE);
        }
    }

    private void checkSave(SaleOrderInfo saleOrderInfo) throws BOSException, EASBizException {
        if (saleOrderInfo.getBaseStatus().getValue() != 0 && saleOrderInfo.getBaseStatus().getValue() != 1) {
            throw new OrderException(OrderException.ORDER_ONLYTEMP_CANBE_SAVE);
        }
    }

    private void checkHeadForSubmit(SaleOrderInfo info) throws BOSException, EASBizException {
        if (info.getBaseStatus().getValue() != 0 && info.getBaseStatus().getValue() != 1 && info.getBaseStatus().getValue() != 2) {
            throw new OrderException(OrderException.ORDER_CANNOT_UPDATE, (Object[])new String[]{info.getBaseStatus().toString()});
        }
        if (info.getBizDate() == null) {
            throw new OrderException(OrderException.FIELD_CANNOT_EMPTY, (Object[])new String[]{this.getServerResource("ORDER_FIELD_ORDERDATE")});
        }
        if (info.getOrderCustomer() == null) {
            throw new OrderException(OrderException.FIELD_CANNOT_EMPTY, (Object[])new String[]{this.getServerResource("POST_FIELD_ORDERCUSTOMER")});
        }
        if (info.getBizType() == null) {
            throw new OrderException(OrderException.FIELD_CANNOT_EMPTY, (Object[])new String[]{this.getServerResource("ORDER_FIELD_TRANSATIONTYPE")});
        }
        if ("d8e80652-0111-1000-e000-04c5c0a812202407435C".equals(info.getBizType().getId().toString())) {
            if (info.getPurchaseOrgUnit() == null) {
                throw new OrderException(OrderException.FIELD_CANNOT_EMPTY, (Object[])new String[]{this.getServerResource("ORDER_FIELD_SALEORGUNIT")});
            }
            if (info.getDirectSupplier() == null) {
                throw new OrderException(OrderException.FIELD_CANNOT_EMPTY, (Object[])new String[]{this.getServerResource("ORDER_FIELD_DIRECTSUPPLIER")});
            }
        }
        if (info.getDeliveryType() == null) {
            throw new OrderException(OrderException.FIELD_CANNOT_EMPTY, (Object[])new String[]{this.getServerResource("ORDER_FIELD_DELIVERYTYPE")});
        }
        if (info.getCurrency() == null) {
            throw new OrderException(OrderException.FIELD_CANNOT_EMPTY, (Object[])new String[]{this.getServerResource("ORDER_FIELD_CURRENCY")});
        }
        if (info.getExchangeRate() == null) {
            throw new OrderException(OrderException.FIELD_CANNOT_EMPTY, (Object[])new String[]{this.getServerResource("ORDER_FIELD_EXCHANGERATE")});
        }
        if (info.getPaymentType() == null) {
            throw new BOSException(this.getServerResource("SALEINV_NEEDPAYTYPE"));
        }
        if (info.getSaleOrgUnit() == null) {
            throw new OrderException(OrderException.FIELD_CANNOT_EMPTY, (Object[])new String[]{this.getServerResource("ORDER_FIELD_SALEORGUNIT")});
        }
        if (info.getSalePerson() == null) {
            throw new OrderException(OrderException.FIELD_CANNOT_EMPTY, (Object[])new String[]{this.getServerResource("ORDER_FIELD_SALEPERSON")});
        }
        if (info.getCompanyOrgUnit() == null) {
            throw new BOSException(this.getServerResource("SALEINV_NEEDCOMORG"));
        }
        if (info.getExchangeRate() == null || info.getExchangeRate().compareTo(new BigDecimal("0.00000001")) < 0) {
            throw new OrderException(OrderException.EXCHANGE_RATE_NOT_ZERO);
        }
        if (info.isIsCentralBalance()) {
            if (info.getStorageOrgUnit() == null) {
                throw new OrderException(OrderException.FIELD_CANNOT_EMPTY, (Object[])new String[]{this.getServerResource("ORDER_FIELD_STORAGEORGUNIT")});
            }
            if (info.getWarehouse() == null) {
                throw new OrderException(OrderException.FIELD_CANNOT_EMPTY, (Object[])new String[]{this.getServerResource("POST_FIELD_POSTWAREHOUSE")});
            }
        }
        if (info.isIsSquareBalance()) {
            if (info.getBalanceCompanyOrgUnit() == null) {
                throw new OrderException(OrderException.FIELD_CANNOT_EMPTY, (Object[])new String[]{this.getServerResource("BALANCE_COMPANYORGUNIT")});
            }
            if (info.getBalanceSaleOrgUnit() == null) {
                throw new OrderException(OrderException.FIELD_CANNOT_EMPTY, (Object[])new String[]{this.getServerResource("BALANCE_SALEORGUNIT")});
            }
            if (info.getBalanceStorageOrgUnit() == null) {
                throw new OrderException(OrderException.FIELD_CANNOT_EMPTY, (Object[])new String[]{this.getServerResource("BALANCE_STORAGEORGUNIT")});
            }
            if (info.getBalanceWarehouse() == null) {
                throw new OrderException(OrderException.FIELD_CANNOT_EMPTY, (Object[])new String[]{this.getServerResource("BALANCE_WAREHOUSE")});
            }
        }
    }

    private boolean checkReverse(IObjectValue model) throws BOSException, EASBizException {
        SaleOrderInfo saleOrderInfo = (SaleOrderInfo)model;
        if (!saleOrderInfo.isIsReverse()) {
            return false;
        }
        ISaleOrder iSaleOrder = SaleOrderFactory.getLocalInstance((Context)this.ctx);
        SaleOrderInfo srcSaleOrderInfo = null;
        if (saleOrderInfo.getSourceBillType() != null && saleOrderInfo.getSourceBillType().getId().toString().equals("510b6503-0105-1000-e000-0113c0a812fd463ED552") && saleOrderInfo.getSourceBillId() != null && (srcSaleOrderInfo = iSaleOrder.getSaleOrderInfo((IObjectPK)new ObjectUuidPK(saleOrderInfo.getSourceBillId()))).getBaseStatus() != null && srcSaleOrderInfo.getBaseStatus().getValue() != 4) {
            throw new OrderException(OrderException.ORDER_CANNOT_REVERSE);
        }
        SaleOrderEntryCollection soeCollection = saleOrderInfo.getEntries();
        SaleOrderEntryInfo soEntryInfo = null;
        HashSet<String> soEntryIDSet = new HashSet<String>();
        HashMap<String, BigDecimal> reverseEntryMap = new HashMap<String, BigDecimal>();
        int num = soeCollection.size();
        for (int i = 0; i < num; ++i) {
            soEntryInfo = soeCollection.get(i);
            if (soEntryInfo.getSourceBillType() == null || !soEntryInfo.getSourceBillType().getId().toString().equals("510b6503-0105-1000-e000-0113c0a812fd463ED552") || soEntryInfo.getSourceBillEntryId() == null) continue;
            soEntryIDSet.add(soEntryInfo.getSourceBillEntryId());
            reverseEntryMap.put(soEntryInfo.getSourceBillEntryId(), soEntryInfo.getQty());
        }
        if (soEntryIDSet.size() > 0) {
            SaleOrderEntryInfo srcSOEntryInfo = null;
            HashSet<String> saleContractEntryIDSet = new HashSet<String>();
            ISaleOrderEntry iSaleOrderEntry = SaleOrderEntryFactory.getLocalInstance((Context)this.ctx);
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection selectorColl = view.getSelector();
            selectorColl.add(new SelectorItemInfo("id"));
            selectorColl.add(new SelectorItemInfo("baseStatus"));
            selectorColl.add(new SelectorItemInfo("isLocked"));
            selectorColl.add(new SelectorItemInfo("sourceBillType"));
            selectorColl.add(new SelectorItemInfo("sourceBillEntryId"));
            selectorColl.add(new SelectorItemInfo("qty"));
            selectorColl.add(new SelectorItemInfo("totalReversedQty"));
            selectorColl.add(new SelectorItemInfo("totalShippingQty"));
            selectorColl.add(new SelectorItemInfo("totalIssueQty"));
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", soEntryIDSet, CompareType.INCLUDE));
            SorterItemInfo sort = new SorterItemInfo();
            sort.setPropertyName("seq");
            sort.setSortType(SortType.ASCEND);
            SorterItemCollection sorterItemCollection = new SorterItemCollection();
            sorterItemCollection.add(sort);
            view.setSorter(sorterItemCollection);
            view.setFilter(filterInfo);
            SaleOrderEntryCollection saleOrderColl = iSaleOrderEntry.getSaleOrderEntryCollection(view);
            int size = saleOrderColl.size();
            for (int i = 0; i < size; ++i) {
                BigDecimal totalIssueQty;
                srcSOEntryInfo = saleOrderColl.get(i);
                if (srcSOEntryInfo.getBaseStatus() != null && srcSOEntryInfo.getBaseStatus().getValue() != 4) {
                    throw new OrderException(OrderException.ORDER_SRC_ENTRY_CANNOT_REVERSE, (Object[])new String[]{String.valueOf(i + 1)});
                }
                if (srcSOEntryInfo.isIsLocked()) {
                    throw new OrderException(OrderException.ORDER_SRC_ENTRY_LOCKED_CANNOT_REVERSE, (Object[])new String[]{String.valueOf(i + 1)});
                }
                if (srcSOEntryInfo.getSourceBillType() != null && srcSOEntryInfo.getSourceBillType().getId().toString().equals("DEZBNUYZRM6ieHZ5GGlRc0Y+1VI=") && srcSOEntryInfo.getSourceBillEntryId() != null) {
                    saleContractEntryIDSet.add(srcSOEntryInfo.getSourceBillEntryId());
                }
                BigDecimal reverseQty = ((BigDecimal)reverseEntryMap.get(srcSOEntryInfo.getId().toString())).abs();
                BigDecimal qty = SCMUtils.effectualNumeric((BigDecimal)srcSOEntryInfo.getQty());
                BigDecimal totalReversedQty = SCMUtils.effectualNumeric((BigDecimal)srcSOEntryInfo.getTotalReversedQty());
                BigDecimal totalShippingQty = SCMUtils.effectualNumeric((BigDecimal)srcSOEntryInfo.getTotalShippingQty());
                BigDecimal availReverseQty = totalShippingQty;
                availReverseQty = availReverseQty.compareTo(totalIssueQty = SCMUtils.effectualNumeric((BigDecimal)srcSOEntryInfo.getTotalIssueQty())) > 0 ? availReverseQty : totalIssueQty;
                availReverseQty = qty.subtract(totalReversedQty).subtract(availReverseQty);
                if (reverseQty.compareTo(availReverseQty) <= 0) continue;
                throw new SCMBillException(SCMBillException.REVERSE_QTY_TOO_BIG, (Object[])new String[]{String.valueOf(i + 1)});
            }
            if (saleContractEntryIDSet.size() > 0) {
                SaleContractEntryInfo srcSCEntryInfo = null;
                ISaleContractEntry iSaleContractEntry = SaleContractEntryFactory.getLocalInstance((Context)this.ctx);
                view = new EntityViewInfo();
                view.getSelector().add(new SelectorItemInfo("baseStatus"));
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", saleContractEntryIDSet, CompareType.INCLUDE));
                view.setFilter(filter);
                SaleContractEntryCollection saleContractEntryColl = iSaleContractEntry.getSaleContractEntryCollection(view);
                int size2 = saleContractEntryColl.size();
                for (int j = 0; j < size2; ++j) {
                    srcSCEntryInfo = saleContractEntryColl.get(j);
                    EntryBaseStatusEnum srcSCEntryBaseStatus = srcSCEntryInfo.getBaseStatus();
                    if (srcSCEntryBaseStatus == null || srcSCEntryBaseStatus.getValue() == 4 || srcSCEntryBaseStatus.getValue() == 7) continue;
                    throw new OrderException(OrderException.CANTRACT_SRC_ENTRY_CANNOT_REVERSE, (Object[])new String[]{String.valueOf(j + 1)});
                }
            }
        }
        return true;
    }

    private void checkBizDate(SaleOrderInfo saleOrderInfo) throws BOSException, EASBizException {
        if (saleOrderInfo.getSourceBillType() != null && "510b6503-0105-1000-e000-9113c0a812fd463ED552".equals(saleOrderInfo.getSourceBillType().getId().toString())) {
            StringBuffer checkBizDteSQL = new StringBuffer();
            Date bizDate = saleOrderInfo.getBizDate();
            Calendar ca = Calendar.getInstance();
            ca.setTime(bizDate);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            if (saleOrderInfo.getSourceBillId() != null) {
                checkBizDteSQL.append(" select quotation.FID from T_SD_Quotation quotation ");
                checkBizDteSQL.append(" where ((quotation.FDisibleDate >= to_date('").append(sdf.format(ca.getTime())).append("')");
                ca.add(5, 1);
                checkBizDteSQL.append(" and quotation.FEnabledDate < to_date('").append(sdf.format(ca.getTime())).append("')");
                checkBizDteSQL.append(" ) or quotation.FDisibleDate is null or quotation.FEnabledDate is null)");
                checkBizDteSQL.append(" and quotation.FID = '").append(saleOrderInfo.getSourceBillId().toString()).append("'");
            } else {
                checkBizDteSQL.append(" select saleOrder.FID from T_SD_SaleOrder saleOrder inner join T_SD_Quotation quotation on saleOrder.FSourceBillID = quotation.FID");
                checkBizDteSQL.append(" where ((quotation.FDisibleDate >= to_date('").append(sdf.format(ca.getTime())).append("')");
                ca.add(5, 1);
                checkBizDteSQL.append(" and quotation.FEnabledDate < to_date('").append(sdf.format(ca.getTime())).append("')");
                checkBizDteSQL.append(" ) or quotation.FDisibleDate is null or quotation.FEnabledDate is null)");
                checkBizDteSQL.append(" and saleOrder.FID = '").append(saleOrderInfo.getId().toString()).append("'");
            }
            IRowSet rows = DbUtil.executeQuery((Context)this.ctx, (String)checkBizDteSQL.toString());
            try {
                if (rows == null || !rows.next()) {
                    throw new OrderException(OrderException.ORDER_CANNOT_BIZDATE);
                }
            }
            catch (SQLException e) {
                throw new OrderException(OrderException.ORDER_CANNOT_BIZDATE);
            }
            finally {
                SQLUtils.cleanup((ResultSet)rows);
            }
        }
    }

    protected void showQtyRefCheckError(HashMap errorHs, String tempTable, BatchActionResults batchResults) throws InvUpdateException, BOSException {
        IRowSet rs = null;
        String locName = this.getLocName(this.ctx);
        StringBuffer sb = new StringBuffer();
        String qty_check_order = SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"QTY_CHECK_ORDER", (Context)this.ctx);
        String qty_check_2 = SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"QTY_CHECK_2", (Context)this.ctx);
        String qty_check_3 = SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"QTY_CHECK_3", (Context)this.ctx);
        String qty_check_4 = SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"QTY_CHECK_4", (Context)this.ctx);
        String row = SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"Row", (Context)this.ctx);
        Set keyset = errorHs.keySet();
        Iterator it = keyset.iterator();
        String sqlin = "";
        while (it.hasNext()) {
            sqlin = sqlin + ",'" + (String)it.next() + "'";
        }
        sqlin = sqlin.substring(1);
        try {
            sb.append(" select sc.fnumber as saleContractNumber, d.fparentid as fSaleOrderID,d.fseq as fseq,sce.fseq as fsseq,");
            sb.append(" d.fsourcebillentryid as fsourcebillentryid,a.").append(locName);
            sb.append(" as fmaterialname,c.").append(locName).append(" as fbaseunitname , ");
            sb.append(" b.FBaseConvsRate as FBaseConvsRate,b.FQtyPrecision as FQtyPrecision ");
            sb.append(" from  ").append(tempTable).append(" as d ");
            sb.append(" inner join t_bd_material a on a.fid = d.fmaterialid ");
            sb.append(" inner join t_bd_multimeasureunit b on b.fmaterialid = d.fmaterialid and b.fmeasureunitid = d.fbaseunitid ");
            sb.append(" inner join t_bd_measureunit c on c.fid = d.fbaseunitid ");
            sb.append(" inner join t_sd_salecontractentry sce on sce.fid = d.fsourcebillentryid ");
            sb.append(" inner join t_sd_salecontract sc on sce.fparentid = sc.fid ");
            sb.append(" where d.fsourcebillentryid in (").append(sqlin).append(") order by d.fseq");
            rs = DbUtil.executeQuery((Context)this.ctx, (String)sb.toString());
            String fSaleOrderID = "";
            String fsourcebillentryid = "";
            String fmaterialname = "";
            String fbaseunitname = "";
            Map map = null;
            int fseq = 0;
            while (rs.next()) {
                fsourcebillentryid = rs.getString("fsourcebillentryid");
                if (!errorHs.containsKey(fsourcebillentryid)) continue;
                map = (Map)errorHs.get(fsourcebillentryid);
                BigDecimal cebaseQty = (BigDecimal)map.get("cebaseQty");
                BigDecimal totalOrderedBaseQty = (BigDecimal)map.get("FTotalOrderedQty");
                BigDecimal baseQty = (BigDecimal)map.get("FBaseQty");
                BigDecimal beforeAlterQty = (BigDecimal)map.get("FBeforeAlterQty");
                baseQty = baseQty.subtract(beforeAlterQty).add(totalOrderedBaseQty);
                BigDecimal leftQty = (BigDecimal)map.get("FLeftQty");
                cebaseQty = cebaseQty.setScale(rs.getInt("FQtyPrecision"), 4);
                baseQty = baseQty.setScale(rs.getInt("FQtyPrecision"), 4);
                leftQty = leftQty.abs().setScale(rs.getInt("FQtyPrecision"), 4);
                fSaleOrderID = rs.getString("fSaleOrderID");
                fseq = rs.getInt("fseq");
                fmaterialname = rs.getString("fmaterialname");
                fbaseunitname = rs.getString("fbaseunitname");
                batchResults.addError(fSaleOrderID, qty_check_order + fseq + row + fmaterialname + qty_check_2 + cebaseQty + fbaseunitname + qty_check_3 + baseQty + fbaseunitname + qty_check_4 + leftQty + fbaseunitname);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException("Sql execute exception : " + sb.toString(), (Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
    }

    protected String getLocName(Context ctx) throws BOSException {
        return "FName_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale());
    }

    private void checkEntry(SaleOrderInfo info) throws BOSException, EASBizException {
        SaleOrderEntryInfo entryInfo = null;
        SaleOrderEntryCollection entryCol = null;
        entryCol = info.getEntries();
        int entrySize = entryCol.size();
        if (entrySize == 0) {
            throw new OrderException(OrderException.ENTRY_CANNOT_EMPTY);
        }
        for (int j = 0; j < entrySize; ++j) {
            entryInfo = entryCol.get(j);
            if (entryInfo.getMaterial() == null) {
                throw new OrderException(OrderException.FIELD_CANNOT_EMPTY, (Object[])new String[]{this.getServerResource("ORDER_FIELD_MATERIAL")});
            }
            if (entryInfo.getUnit() == null) {
                throw new OrderException(OrderException.FIELD_CANNOT_EMPTY, (Object[])new String[]{this.getServerResource("POST_FIELD_UNIT")});
            }
            if (entryInfo.getBaseUnit() == null) {
                throw new OrderException(OrderException.FIELD_CANNOT_EMPTY, (Object[])new String[]{this.getServerResource("ORDER_FIELD_BASEUNIT")});
            }
            if (entryInfo.getBaseQty() == null) {
                throw new OrderException(OrderException.FIELD_CANNOT_EMPTY, (Object[])new String[]{this.getServerResource("ORDER_FIELD_BASEUNITQTY")});
            }
            if (info.isIsReverse() ? entryInfo.getQty() == null || entryInfo.getQty() != null && entryInfo.getQty().abs().compareTo(ZERO) <= 0 : entryInfo.getQty() == null || entryInfo.getQty() != null && entryInfo.getQty().compareTo(ZERO) <= 0) {
                throw new OrderException(OrderException.FIELD_CANNOT_EMPTY, (Object[])new String[]{this.getServerResource("ORDER_FIELD_QUANTITY")});
            }
            if (entryInfo.getPrice() == null) {
                throw new OrderException(OrderException.FIELD_CANNOT_EMPTY, (Object[])new String[]{this.getServerResource("POST_FIELD_PRICE")});
            }
            if (!entryInfo.isIsPresent() && entryInfo.getPrice().compareTo(ZERO) < 1) {
                throw new OrderException(OrderException.FIELD_CANNOT_EMPTY, (Object[])new String[]{this.getServerResource("ORDER_FIELD_SALEORGUNIT")});
            }
            if (entryInfo.getTaxPrice() == null) {
                throw new OrderException(OrderException.FIELD_CANNOT_EMPTY, (Object[])new String[]{this.getServerResource("ORDER_FIELD_TAXPRICE")});
            }
            if (entryInfo.getAmount() == null) {
                throw new OrderException(OrderException.FIELD_CANNOT_EMPTY, (Object[])new String[]{this.getServerResource("POST_FIELD_TOTAL")});
            }
            if (entryInfo.getLocalAmount() == null) {
                throw new OrderException(OrderException.FIELD_CANNOT_EMPTY, (Object[])new String[]{this.getServerResource("ORDER_FIELD_LOCALAMOUNT")});
            }
            if (entryInfo.getActualTaxPrice() == null) {
                throw new OrderException(OrderException.FIELD_CANNOT_EMPTY, (Object[])new String[]{this.getServerResource("ORDER_FIELD_DISCOUNTTAXPRICE")});
            }
            if (entryInfo.getTax() == null) {
                throw new OrderException(OrderException.FIELD_CANNOT_EMPTY, (Object[])new String[]{this.getServerResource("ORDER_FIELD_TAXRATE")});
            }
            if (entryInfo.getTaxAmount() == null) {
                throw new OrderException(OrderException.FIELD_CANNOT_EMPTY, (Object[])new String[]{this.getServerResource("ORDER_FIELD_TOTALTAXAMOUNT")});
            }
            if (entryInfo.getSendDate() == null) {
                throw new OrderException(OrderException.FIELD_CANNOT_EMPTY, (Object[])new String[]{this.getServerResource("POST_FIELD_POSTDATE")});
            }
            if (entryInfo.getStorageOrgUnit() == null) {
                throw new OrderException(OrderException.FIELD_CANNOT_EMPTY, (Object[])new String[]{this.getServerResource("ORDER_FIELD_STORAGEORGUNIT")});
            }
            if (entryInfo.getReceiveCustomer() == null) {
                throw new OrderException(OrderException.FIELD_CANNOT_EMPTY, (Object[])new String[]{this.getServerResource("ORDER_FIELD_SALEORGUNIT")});
            }
            if (entryInfo.getPaymentCustomer() == null) {
                throw new OrderException(OrderException.FIELD_CANNOT_EMPTY, (Object[])new String[]{this.getServerResource("ORDER_FIELD_SALEORGUNIT")});
            }
            if (entryInfo.getDeliveryCustomer() != null) continue;
            throw new OrderException(OrderException.FIELD_CANNOT_EMPTY, (Object[])new String[]{this.getServerResource("ORDER_FIELD_SALEORGUNIT")});
        }
    }

    @Override
    public ProcessorExecutionMode supportExecutionMode() throws BOSException {
        return ProcessorExecutionMode.NESTED;
    }
}

