/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.app.bizprocess.processor.saleorder;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerSaleInfoCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerSaleInfoFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerSaleInfoInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomerCompanyInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomerSaleInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.ProcessorExecutionMode;
import com.kingdee.eas.dynbusiness.ProcessorExecutionModeEnum;
import com.kingdee.eas.dynbusiness.TransactionModeEnum;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import com.kingdee.eas.scm.sd.sale.app.bizprocess.processor.SaleCommonDataLoadorProcessor;
import java.util.HashMap;
import java.util.Map;

public class SaleOrderCommonDataLoadorProcessor
extends SaleCommonDataLoadorProcessor {
    private static final long serialVersionUID = 1L;

    public SaleOrderCommonDataLoadorProcessor(ExecuteContext executeContext, ProcessorExecutionModeEnum executeMode, Conditions conditions, TransactionModeEnum transactionMode) {
        super(executeContext, executeMode, conditions, transactionMode);
    }

    public SaleOrderCommonDataLoadorProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    @Override
    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        super.doProcessing(batchResults);
        if (batchResults == null) {
            return;
        }
        IObjectCollection collection = batchResults.getObjCollection();
        if (collection == null || collection.size() <= 0) {
            return;
        }
        IObjectValue vo = collection.getObject(0);
        SaleOrderInfo saleOrderInfo = (SaleOrderInfo)vo;
        if (saleOrderInfo.get("isFromGui") == null) {
            saleOrderInfo.remove("isFromGui");
            return;
        }
        int size = collection.size();
        String[] customerIds = new String[size];
        String[] saleOrgIds = new String[size];
        String[] companyIds = new String[size];
        for (int i = 0; i < size; ++i) {
            IObjectValue vo2 = collection.getObject(i);
            SaleOrderInfo saleOrderInfo2 = (SaleOrderInfo)vo2;
            if (saleOrderInfo2.getOrderCustomer() == null || saleOrderInfo2.getOrderCustomer().getId() == null) continue;
            customerIds[i] = saleOrderInfo2.getOrderCustomer().getId().toString();
            if (saleOrderInfo2.getCompanyOrgUnit() != null && saleOrderInfo2.getCompanyOrgUnit().getId() != null) {
                companyIds[i] = saleOrderInfo2.getCompanyOrgUnit().getId().toString();
            }
            if (saleOrderInfo2.getSaleOrgUnit() == null || saleOrderInfo2.getSaleOrgUnit().getId() == null) continue;
            saleOrgIds[i] = saleOrderInfo2.getSaleOrgUnit().getId().toString();
        }
        Map<String, CustomerCompanyInfoInfo> cusCompanyMap = this.getCustomerCompanyInfo(customerIds, companyIds);
        Map<String, CustomerSaleInfoInfo> cusSaleMap = this.getCustomerSaleInfo(customerIds, saleOrgIds);
        ExecuteContext executeContext = this.getExecuteContext();
        if (executeContext != null) {
            Context context = executeContext.getContext();
            context.put((Object)"cusCompanyMap", cusCompanyMap);
            context.put((Object)"cusSaleMap", cusSaleMap);
        }
    }

    private Map<String, CustomerCompanyInfoInfo> getCustomerCompanyInfo(String[] customerIds, String[] orgIDs) throws BOSException {
        HashMap<String, CustomerCompanyInfoInfo> cusCompany = new HashMap<String, CustomerCompanyInfoInfo>();
        EntityViewInfo view = new EntityViewInfo();
        CustomerCompanyInfoInfo info = null;
        String key = "";
        FilterInfo filter = new FilterInfo();
        StringBuffer sb = new StringBuffer();
        ICustomerCompanyInfo iCustomerCompanyInfo = CustomerCompanyInfoFactory.getLocalInstance((Context)this.ctx);
        if (customerIds != null && orgIDs != null) {
            int size = customerIds.length;
            for (int i = 0; i < size; ++i) {
                if (customerIds[i] == null || orgIDs[i] == null) continue;
                filter.getFilterItems().add(new FilterItemInfo("customer", (Object)customerIds[i], CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit", (Object)orgIDs[i], CompareType.EQUALS));
                if (sb.length() > 0) {
                    sb.append(" OR ");
                }
                sb.append("(#").append(filter.getFilterItems().size() - 2).append(" AND #").append(filter.getFilterItems().size() - 1).append(")");
            }
            if (sb.length() > 0) {
                filter.setMaskString(sb.toString());
                view.setFilter(filter);
                CustomerCompanyInfoCollection coll = iCustomerCompanyInfo.getCustomerCompanyInfoCollection(view);
                if (coll != null) {
                    for (int j = 0; j < coll.size(); ++j) {
                        info = coll.get(j);
                        if (info == null || info.getCompanyOrgUnit() == null || info.getCustomer() == null) continue;
                        key = info.getCustomer().getId().toString() + info.getCompanyOrgUnit().getId().toString();
                        cusCompany.put(key, info);
                    }
                }
            }
        }
        return cusCompany;
    }

    private Map<String, CustomerSaleInfoInfo> getCustomerSaleInfo(String[] customerIds, String[] orgIDs) throws BOSException {
        HashMap<String, CustomerSaleInfoInfo> cusSale = new HashMap<String, CustomerSaleInfoInfo>();
        EntityViewInfo view = new EntityViewInfo();
        CustomerSaleInfoInfo info = null;
        String key = "";
        FilterInfo filter = new FilterInfo();
        StringBuffer sb = new StringBuffer();
        ICustomerSaleInfo iCustomerSaleInfo = CustomerSaleInfoFactory.getLocalInstance((Context)this.ctx);
        if (customerIds != null && orgIDs != null) {
            int size = customerIds.length;
            for (int i = 0; i < size; ++i) {
                if (customerIds[i] == null || orgIDs[i] == null) continue;
                filter.getFilterItems().add(new FilterItemInfo("customer", (Object)customerIds[i], CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("saleOrgUnit", (Object)orgIDs[i], CompareType.EQUALS));
                if (sb.length() > 0) {
                    sb.append(" OR ");
                }
                sb.append("(#").append(filter.getFilterItems().size() - 2).append(" AND #").append(filter.getFilterItems().size() - 1).append(")");
            }
            if (sb.length() > 0) {
                filter.setMaskString(sb.toString());
                view.setFilter(filter);
                CustomerSaleInfoCollection coll = iCustomerSaleInfo.getCustomerSaleInfoCollection(view);
                if (coll != null) {
                    for (int j = 0; j < coll.size(); ++j) {
                        info = coll.get(j);
                        if (info == null || info.getSaleOrgUnit() == null || info.getCustomer() == null) continue;
                        key = info.getCustomer().getId().toString() + info.getSaleOrgUnit().getId().toString();
                        cusSale.put(key, info);
                    }
                }
            }
        }
        return cusSale;
    }

    public ProcessorExecutionMode supportExecutionMode() throws BOSException {
        return ProcessorExecutionMode.NESTED;
    }

    @Override
    protected String getEntryName() {
        return "entries";
    }
}

