/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.app.bizprocess.processor.saleorder;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.ProcessorExecutionMode;
import com.kingdee.eas.dynbusiness.ProcessorExecutionModeEnum;
import com.kingdee.eas.dynbusiness.TransactionModeEnum;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.credit.app.balance.SaleOrderBalanceUpdateProxy;
import com.kingdee.eas.scm.sd.sale.ISaleOrder;
import com.kingdee.eas.scm.sd.sale.SaleOrderFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;

public class SaleOrderCreditUpdateProcessor
extends AbstractBusinessProcessor {
    private static final long serialVersionUID = -4603727342237546534L;

    public SaleOrderCreditUpdateProcessor(ExecuteContext executeContext, ProcessorExecutionModeEnum executeMode, Conditions conditions, TransactionModeEnum transactionMode) {
        super(executeContext, executeMode, conditions, transactionMode);
    }

    public SaleOrderCreditUpdateProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        if (batchResults == null) {
            return;
        }
        IObjectCollection collection = batchResults.getObjCollection();
        if (collection == null || collection.size() <= 0) {
            return;
        }
        for (int i = 0; i < collection.size(); ++i) {
            IObjectValue vo = collection.getObject(i);
            SaleOrderInfo saleOrderInfo = (SaleOrderInfo)vo;
            if (!BatchActionEnum.SUBMIT.equals((Object)this.batchAction) && !BatchActionEnum.AUDIT.equals((Object)this.batchAction) && !BatchActionEnum.UNAUDIT.equals((Object)this.batchAction)) continue;
        }
    }

    public void updateCreditForSubmit(SaleOrderInfo saleOrderInfo) throws BOSException, EASBizException {
        ISaleOrder iSaleOrder = SaleOrderFactory.getLocalInstance((Context)this.ctx);
        SaleOrderInfo oldVersionSO = null;
        if (!this.isAddNew(this.ctx, (IObjectValue)saleOrderInfo)) {
            ObjectUuidPK soPK = new ObjectUuidPK(saleOrderInfo.getId());
            oldVersionSO = iSaleOrder.getSaleOrderInfo((IObjectPK)soPK);
        }
        SaleOrderBalanceUpdateProxy creditUpdater = new SaleOrderBalanceUpdateProxy(this.ctx);
        creditUpdater.updateAtSubmit((IObjectValue)saleOrderInfo, (IObjectValue)oldVersionSO);
    }

    public void updateCreditForAudit(SaleOrderInfo saleOrderInfo) throws BOSException, EASBizException {
    }

    public void updateCreditForUnAudit(SaleOrderInfo saleOrderInfo) throws BOSException, EASBizException {
    }

    protected boolean isAddNew(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        boolean ret = false;
        SCMBillBaseInfo aSCMBillBaseInfo = (SCMBillBaseInfo)model;
        ret = aSCMBillBaseInfo.getId() == null || aSCMBillBaseInfo.getId().toString().trim().length() == 0 || !this.exists(ctx, (IObjectPK)new ObjectUuidPK(aSCMBillBaseInfo.getId()));
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean exists(Context ctx, IObjectPK pk) throws BOSException {
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            boolean bl = this.getDAO(ctx, cn).exists(pk);
            return bl;
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean exists(Context ctx, FilterInfo filter) throws BOSException {
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            boolean bl = this.getDAO(ctx, cn).exists(filter);
            return bl;
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    protected IORMappingDAO getDAO(Context ctx, Connection cn) throws BOSException {
        return ORMappingDAO.getInstance((BOSObjectType)this.bosType, (Context)ctx, (Connection)cn);
    }

    protected Connection getConnection(Context ctx) throws SQLDataException {
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
    }

    public ProcessorExecutionMode supportExecutionMode() throws BOSException {
        return ProcessorExecutionMode.ORDINAL;
    }
}

