/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.app.bizprocess.processor.saleorder;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.ProcessorExecutionModeEnum;
import com.kingdee.eas.dynbusiness.TransactionModeEnum;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.sd.sale.ISaleOrder;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryCollection;
import com.kingdee.eas.scm.sd.sale.SaleOrderFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import com.kingdee.eas.scm.sd.sale.app.bizprocess.processor.SaleDefaultValueProcessor;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import com.kingdee.eas.util.app.DbUtil;
import java.util.Calendar;

public class SaleOrderDefaultValueProcessor
extends SaleDefaultValueProcessor {
    private static final long serialVersionUID = 1L;

    public SaleOrderDefaultValueProcessor(ExecuteContext executeContext, ProcessorExecutionModeEnum executeMode, Conditions conditions, TransactionModeEnum transactionMode) {
        super(executeContext, executeMode, conditions, transactionMode);
    }

    public SaleOrderDefaultValueProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    protected boolean check(BatchActionResults batchResults) throws EASBizException, BOSException {
        return super.check(batchResults);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        super.doProcessing(batchResults);
        if (batchResults == null) {
            return;
        }
        IObjectCollection collection = batchResults.getObjCollection();
        if (collection == null || collection.size() <= 0) {
            return;
        }
        SaleOrderInfo saleOrderInfo = null;
        for (int i = 0; i < collection.size(); ++i) {
            IObjectValue vo = collection.getObject(i);
            saleOrderInfo = (SaleOrderInfo)vo;
            if (BatchActionEnum.SAVE.equals((Object)this.batchAction)) {
                this.defaultValueForSave(saleOrderInfo);
                continue;
            }
            if (!BatchActionEnum.SUBMIT.equals((Object)this.batchAction)) continue;
            this.defaultValueForSubmit(saleOrderInfo);
        }
    }

    private void defaultValueForSave(SaleOrderInfo saleOrderInfo) throws BOSException, EASBizException {
        if (saleOrderInfo.isIsReverse() && this.isAddNew(this.ctx, (IObjectValue)saleOrderInfo)) {
            String srcBillId = saleOrderInfo.getSourceBillId();
            String destBillId = saleOrderInfo.getId().toString();
            String bosType = new ObjectUuidPK(srcBillId).getObjectType().toString();
            SCMServerUtils.traceUpAndDown((Context)this.ctx, (String)srcBillId, (String)destBillId, (String)bosType, (String)bosType);
        }
        if (saleOrderInfo.getBizDate() != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(saleOrderInfo.getBizDate());
            saleOrderInfo.setYear(cal.get(1));
            saleOrderInfo.setPeriod(cal.get(1) * 100 + (cal.get(2) + 1));
        }
    }

    private void defaultValueForSubmit(SaleOrderInfo saleOrderInfo) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(saleOrderInfo.getId());
        if (pk != null) {
            StringBuffer strSQL = new StringBuffer();
            String sp = " \r\n";
            String id = pk.toString();
            strSQL.append("UPDATE T_SD_SaleOrderEntry").append(sp);
            strSQL.append("    SET  FIsBySaleOrder=").append(sp);
            strSQL.append("              (SELECT ISNULL(ms.FIsPurBySale,0) ").append(sp);
            strSQL.append("             FROM T_SD_SaleOrder so, T_BD_MaterialSales ms").append(sp);
            strSQL.append("             WHERE T_SD_SaleOrderEntry.FParentID = so.FID AND ").append(sp);
            strSQL.append("                   T_SD_SaleOrderEntry.FMaterialID = ms.FMaterialID AND ").append(sp);
            strSQL.append("                   so.FSaleOrgUnitID = ms.FOrgUnit AND so.FID = ? )").append(sp);
            strSQL.append("    WHERE (FID IN").append(sp);
            strSQL.append("              (SELECT T_SD_SaleOrderEntry.FID").append(sp);
            strSQL.append("             FROM T_SD_SaleOrderEntry,T_SD_SaleOrder so, T_BD_MaterialSales ms").append(sp);
            strSQL.append("             WHERE T_SD_SaleOrderEntry.FParentID = so.FID AND ").append(sp);
            strSQL.append("                   T_SD_SaleOrderEntry.FMaterialID = ms.FMaterialID AND ").append(sp);
            strSQL.append("                   so.FSaleOrgUnitID = ms.FOrgUnit AND so.FID = ? ))").append(sp);
            DbUtil.execute((Context)this.ctx, (String)strSQL.toString(), (Object[])new Object[]{id, id});
            StringBuffer ids = new StringBuffer();
            if (saleOrderInfo.getBizType() != null) {
                if (saleOrderInfo.getBizType().getNumber() == null) {
                    ISaleOrder iSaleOrder = SaleOrderFactory.getLocalInstance((Context)this.ctx);
                    saleOrderInfo = (SaleOrderInfo)iSaleOrder.getValue((IObjectPK)pk, SCMSelectorFactory.getSaleOrderSelector((boolean)true));
                    if (!saleOrderInfo.getBizType().getNumber().equals("220")) {
                        SaleOrderEntryCollection entries = saleOrderInfo.getEntries();
                        int size = entries.size();
                        for (int i = 0; i < size; ++i) {
                            ids.append("'").append(entries.get(i).getId()).append("',");
                        }
                        if (ids.length() > 0) {
                            ids.deleteCharAt(ids.length() - 1);
                        }
                    }
                } else if (!saleOrderInfo.getBizType().getNumber().equals("220")) {
                    SaleOrderEntryCollection entries = saleOrderInfo.getEntries();
                    int size = entries.size();
                    for (int i = 0; i < size; ++i) {
                        ids.append("'").append(entries.get(i).getId()).append("',");
                    }
                    if (ids.length() > 0) {
                        ids.deleteCharAt(ids.length() - 1);
                    }
                }
            }
            if (ids.length() > 0) {
                strSQL.setLength(0);
                strSQL.append(" update T_SD_SaleOrderEntry set FTotalUnTransferQty = FQty, FTotalUnTransferBaseQty = FBaseQty where FID in (");
                strSQL.append(ids.toString()).append(")");
                DbUtil.execute((Context)this.ctx, (String)strSQL.toString());
            }
            if (!saleOrderInfo.isIsReverse()) {
                strSQL.setLength(0);
                strSQL.append(" update T_SD_SaleOrderEntry set FTotalBaseunProductQty = FBaseQty,FTotalunProductQty = FQty where FParentID = ?");
                DbUtil.execute((Context)this.ctx, (String)strSQL.toString(), (Object[])new Object[]{id});
            }
        }
        if (saleOrderInfo.isIsReverse() && this.isAddNew(this.ctx, (IObjectValue)saleOrderInfo)) {
            String srcBillId = saleOrderInfo.getSourceBillId();
            String destBillId = pk.toString();
            String bosType = new ObjectUuidPK(srcBillId).getObjectType().toString();
            SCMServerUtils.traceUpAndDown((Context)this.ctx, (String)srcBillId, (String)destBillId, (String)bosType, (String)bosType);
        }
        if (saleOrderInfo.getBizDate() != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(saleOrderInfo.getBizDate());
            saleOrderInfo.setYear(cal.get(1));
            saleOrderInfo.setPeriod(cal.get(1) * 100 + (cal.get(2) + 1));
        }
    }

    @Override
    public BillTypeInfo getBillType() {
        BillTypeInfo info = new BillTypeInfo();
        info.setId(BOSUuid.read((String)"510b6503-0105-1000-e000-0113c0a812fd463ED552"));
        info.setNumber("310");
        return info;
    }
}

