/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.app.bizprocess.processor.saleorder;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerSaleInfoInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerSalerCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerSalerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerSalerInfo;
import com.kingdee.eas.basedata.master.material.MaterialSalesInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.IBillType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.dynbusiness.ProcessorExecutionMode;
import com.kingdee.eas.dynbusiness.ProcessorExecutionModeEnum;
import com.kingdee.eas.dynbusiness.TransactionModeEnum;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.calculate.SaleOrderAlgorithm;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sd.sale.SaleOrderArClosedStatusEnum;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryAgent;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryCollection;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import com.kingdee.eas.scm.sd.sale.app.bizprocess.processor.SaleDefaultValueProcessor;
import com.kingdee.eas.scm.util.constant.SCMConstant;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public class SaleOrderPreDefaultValueProcessor
extends SaleDefaultValueProcessor {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(SaleOrderPreDefaultValueProcessor.class);
    private static final BigDecimal ZERO = new BigDecimal("0.00");
    boolean isFromGui = false;

    public SaleOrderPreDefaultValueProcessor(ExecuteContext executeContext, ProcessorExecutionModeEnum executeMode, Conditions conditions, TransactionModeEnum transactionMode) {
        super(executeContext, executeMode, conditions, transactionMode);
    }

    public SaleOrderPreDefaultValueProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    protected boolean check(BatchActionResults batchResults) throws EASBizException, BOSException {
        return super.check(batchResults);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        super.doProcessing(batchResults);
        if (batchResults == null) {
            return;
        }
        IObjectCollection collection = batchResults.getObjCollection();
        if (collection == null || collection != null && collection.size() <= 0) {
            return;
        }
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            IObjectValue vo = collection.getObject(i);
            SaleOrderInfo saleOrderInfo = (SaleOrderInfo)vo;
            this._checkClosed(this.ctx, (IObjectValue)saleOrderInfo, true);
            if (i == 0 && saleOrderInfo.get("isFromGui") == null) {
                this.isFromGui = true;
                saleOrderInfo.remove("isFromGui");
            }
            if (BatchActionEnum.SAVE.equals((Object)this.batchAction)) {
                this.defaultValueForSave(saleOrderInfo);
                continue;
            }
            if (!BatchActionEnum.SUBMIT.equals((Object)this.batchAction)) continue;
            if (!this.isFromGui) {
                this.defaultHeadValue(saleOrderInfo);
                this.defaultEntryValue(saleOrderInfo);
            }
            this.defaultValueForSubmit(saleOrderInfo);
        }
    }

    private void defaultHeadValue(SaleOrderInfo saleOrderInfo) throws BOSException, EASBizException {
        String saleOrgUnitId;
        OrgUnitCollection collection;
        CustomerSalerCollection cscol;
        String key;
        String saleOrgUnitId2;
        OrgUnitCollection collection2;
        ExecuteContext executeContext = this.getExecuteContext();
        Map cusCompanyMap = (Map)executeContext.getContext().get((Object)"cusCompanyMap");
        Map cusSaleMap = (Map)executeContext.getContext().get((Object)"cusSaleMap");
        IOrgUnitRelation iOrgUnit = OrgUnitRelationFactory.getLocalInstance((Context)this.ctx);
        if (saleOrderInfo.getSaleOrgUnit() != null && saleOrderInfo.getCompanyOrgUnit() == null && (collection2 = iOrgUnit.getToUnit(saleOrgUnitId2 = saleOrderInfo.getSaleOrgUnit().getId().toString(), 2, 1)) != null && collection2.size() > 0) {
            String pk = ((CompanyOrgUnitInfo)collection2.get(0)).getId().toString();
            CompanyOrgUnitInfo companyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(pk));
            saleOrderInfo.setCompanyOrgUnit(companyOrgUnitInfo);
        }
        CustomerCompanyInfoInfo cusCompanyInfo = null;
        if (saleOrderInfo.getCurrency() == null) {
            if (saleOrderInfo.getOrderCustomer() != null && saleOrderInfo.getOrderCustomer().getId() != null) {
                String key2 = saleOrderInfo.getOrderCustomer().getId().toString() + saleOrderInfo.getCompanyOrgUnit().getId().toString();
                cusCompanyInfo = (CustomerCompanyInfoInfo)cusCompanyMap.get(key2);
                if (cusCompanyInfo != null) {
                    saleOrderInfo.setCurrency(cusCompanyInfo.getSettlementCurrency());
                }
            } else {
                saleOrderInfo.setCurrency(saleOrderInfo.getCompanyOrgUnit().getBaseCurrency());
            }
        }
        if (saleOrderInfo.getExchangeRate() == null && saleOrderInfo.getCurrency() != null && saleOrderInfo.getCurrency().getId() != null) {
            String currencyId = saleOrderInfo.getCurrency().getId().toString();
            CurrencyInfo currencyInfo = CurrencyFactory.getLocalInstance((Context)this.ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
            ExchangeTableInfo eti = saleOrderInfo.getCompanyOrgUnit().getReportExchangeTable();
            IExchangeRate er = ExchangeRateFactory.getRemoteInstance();
            ObjectUuidPK etpk = new ObjectUuidPK(eti.getId().toString());
            ObjectUuidPK sourcepk = new ObjectUuidPK(saleOrderInfo.getCompanyOrgUnit().getBaseCurrency().getId().toString());
            ObjectUuidPK targetpk = new ObjectUuidPK(currencyInfo.getId().toString());
            BigDecimal rate = er.getExchangeRateConvertValue((IObjectPK)etpk, (IObjectPK)sourcepk, (IObjectPK)targetpk, null);
            saleOrderInfo.setExchangeRate(rate);
        }
        if (saleOrderInfo.getPaymentType() == null) {
            if (cusCompanyInfo != null && cusCompanyInfo.getPaymentType() != null) {
                saleOrderInfo.setPaymentType(cusCompanyInfo.getPaymentType());
            } else {
                PaymentTypeInfo paymentTypeInfo = new PaymentTypeInfo();
                paymentTypeInfo.setId(BOSUuid.read((String)"91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5"));
                saleOrderInfo.setPaymentType(paymentTypeInfo);
            }
        }
        CustomerSaleInfoInfo cusSaleInfo = null;
        if (saleOrderInfo.getCashDiscount() == null && cusCompanyInfo != null && saleOrderInfo.getOrderCustomer() != null && saleOrderInfo.getSaleOrgUnit() != null && (cusSaleInfo = (CustomerSaleInfoInfo)cusSaleMap.get(key = saleOrderInfo.getOrderCustomer().getId().toString() + saleOrderInfo.getSaleOrgUnit().getId().toString())) != null) {
            saleOrderInfo.setCashDiscount(cusSaleInfo.getCashDiscount());
        }
        if (saleOrderInfo.getSalePerson() == null && saleOrderInfo.getOrderCustomer() != null && saleOrderInfo.getSaleOrgUnit() != null && (cusSaleInfo = (CustomerSaleInfoInfo)cusSaleMap.get(key = saleOrderInfo.getOrderCustomer().getId().toString() + saleOrderInfo.getSaleOrgUnit().getId().toString())) != null && cusSaleInfo.getCustomerSaler() != null && cusSaleInfo.getCustomerSaler().size() > 0 && (cscol = cusSaleInfo.getCustomerSaler()).get(0) != null) {
            CustomerSalerInfo csInfo = cscol.get(0);
            csInfo = CustomerSalerFactory.getLocalInstance((Context)this.ctx).getCustomerSalerInfo((IObjectPK)new ObjectUuidPK(csInfo.getId().toString()));
            saleOrderInfo.setSalePerson(csInfo.getPerson());
        }
        if (saleOrderInfo.get("transLeadTime") == null) {
            if (cusSaleInfo == null || cusSaleInfo.getTransAdvanceDay() == null) {
                saleOrderInfo.setTransLeadTime(0);
            } else {
                saleOrderInfo.setTransLeadTime(cusSaleInfo.getTransAdvanceDay().intValue());
            }
        }
        if (saleOrderInfo.getAdminOrgUnit() == null) {
            // empty if block
        }
        saleOrderInfo.setTotalAmount(this.NullToZero(saleOrderInfo.getTotalAmount()));
        saleOrderInfo.setTotalTax(this.NullToZero(saleOrderInfo.getTotalTax()));
        saleOrderInfo.setTotalTaxAmount(this.NullToZero(saleOrderInfo.getTotalTaxAmount()));
        saleOrderInfo.setPrepayment(this.NullToZero(saleOrderInfo.getPrepayment()));
        saleOrderInfo.setPrepaymentRate(this.NullToZero(saleOrderInfo.getPrepaymentRate()));
        saleOrderInfo.setPreReceived(this.NullToZero(saleOrderInfo.getPreReceived()));
        saleOrderInfo.setUnPrereceivedAmount(this.NullToZero(saleOrderInfo.getUnPrereceivedAmount()));
        saleOrderInfo.setBeenPaidPrepayment(this.NullToZero(saleOrderInfo.getBeenPaidPrepayment()));
        if (saleOrderInfo.get("isInTax") == null) {
            saleOrderInfo.setIsInTax(true);
        }
        if (saleOrderInfo.isIsCentralBalance() && saleOrderInfo.getStorageOrgUnit() == null && (collection = iOrgUnit.getToUnit(saleOrgUnitId = saleOrderInfo.getSaleOrgUnit().getId().toString(), 2, 4)) != null && collection.size() > 0) {
            StorageOrgUnitInfo storageOrgUnitInfo = (StorageOrgUnitInfo)collection.get(0);
            saleOrderInfo.setStorageOrgUnit(storageOrgUnitInfo);
        }
        if (saleOrderInfo.getWarehouse() == null && saleOrderInfo.getStorageOrgUnit() != null && saleOrderInfo.getStorageOrgUnit().getId() != null) {
            String storageOrgUnitID = saleOrderInfo.getStorageOrgUnit().getId().toString();
            SaleOrderFactory.getLocalInstance((Context)this.ctx).getDefaultWarehouseByStorage(storageOrgUnitID);
        }
        if (saleOrderInfo.getBizDate() == null) {
            saleOrderInfo.setBizDate(new Date());
        }
        if (saleOrderInfo.getBizDate() != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(saleOrderInfo.getBizDate());
            saleOrderInfo.setYear(cal.get(1));
            saleOrderInfo.setPeriod(cal.get(1) * 100 + (cal.get(2) + 1));
        }
        if (saleOrderInfo.getBillType() == null) {
            BillTypeInfo typeInfo = new BillTypeInfo();
            typeInfo.setId(BOSUuid.read((String)"d8e80652-010e-1000-e000-04c5c0a812202407435C"));
            saleOrderInfo.setBillType(typeInfo);
        }
    }

    private void defaultEntryValue(SaleOrderInfo saleOrderInfo) throws BOSException {
        SaleOrderEntryCollection entries;
        if (saleOrderInfo == null) {
            return;
        }
        ExecuteContext executeContext = this.getExecuteContext();
        Map saleOrgParamsMap = (Map)executeContext.getContext().get((Object)"saleOrgParamsMap");
        Map materialSalesMap = (Map)executeContext.getContext().get((Object)"materialSalesMap");
        Map paramsMap = null;
        String saleOrgUnitId = null;
        if (saleOrderInfo.getSaleOrgUnit() != null && saleOrderInfo.getSaleOrgUnit().getId() != null) {
            saleOrgUnitId = saleOrderInfo.getSaleOrgUnit().getId().toString();
            paramsMap = (Map)saleOrgParamsMap.get(saleOrgUnitId);
        }
        if ((entries = saleOrderInfo.getEntries()) != null) {
            SaleOrderEntryInfo entryInfo = null;
            String materialId = null;
            int size = entries.size();
            for (int i = 0; i < size; ++i) {
                String controlTime;
                entryInfo = entries.get(i);
                if (entryInfo.getMaterial() != null && entryInfo.getMaterial().getId() != null) {
                    materialId = entryInfo.getMaterial().getId().toString();
                }
                MaterialSalesInfo ms = null;
                if (materialSalesMap != null && materialId != null && saleOrgUnitId != null) {
                    ms = (MaterialSalesInfo)materialSalesMap.get(materialId + saleOrgUnitId);
                }
                if (entryInfo.get("isPresent") == null) {
                    entryInfo.setIsPresent(false);
                }
                entryInfo.setBaseQty(this.NullToZero(entryInfo.getBaseQty()));
                entryInfo.setQty(this.NullToZero(entryInfo.getQty()));
                if (entryInfo.getAssistUnit() != null) {
                    entryInfo.setAssistQty(this.NullToZero(entryInfo.getAssistQty()));
                }
                entryInfo.setPrice(this.NullToZero(entryInfo.getPrice()));
                entryInfo.setTaxPrice(this.NullToZero(entryInfo.getTaxPrice()));
                entryInfo.setDiscount(this.NullToZero(entryInfo.getDiscount()));
                entryInfo.setDiscountAmount(this.NullToZero(entryInfo.getDiscountAmount()));
                entryInfo.setLocalAmount(this.NullToZero(entryInfo.getLocalAmount()));
                entryInfo.setActualPrice(this.NullToZero(entryInfo.getActualPrice()));
                entryInfo.setActualTaxPrice(this.NullToZero(entryInfo.getActualTaxPrice()));
                if (paramsMap != null) {
                    String isTaxRateByCus;
                    String string = isTaxRateByCus = paramsMap.get("SALEBILL001") != null ? (String)paramsMap.get("SALEBILL001") : null;
                    if ("true".equals(isTaxRateByCus) && ms != null) {
                        if (ms.getTaxRate() != null && ms.getTaxRate().compareTo(ZERO) > 0) {
                            entryInfo.setTaxRate(ms.getTaxRate());
                        } else {
                            entryInfo.setTaxRate(SCMConstant.DefaultTaxRate);
                        }
                    } else {
                        entryInfo.setTaxRate(SCMConstant.DefaultTaxRate);
                    }
                } else {
                    entryInfo.setTaxRate(SCMConstant.DefaultTaxRate);
                }
                entryInfo.setTaxRate(this.NullToZero(entryInfo.getTaxRate()));
                entryInfo.setTax(this.NullToZero(entryInfo.getTax()));
                entryInfo.setTaxAmount(this.NullToZero(entryInfo.getTaxAmount()));
                if (entryInfo.getSendDate() == null) {
                    entryInfo.setSendDate(new Date());
                }
                if (entryInfo.getDeliveryDate() == null) {
                    entryInfo.setDeliveryDate(entryInfo.getSendDate());
                }
                String controlQty = paramsMap != null ? (String)paramsMap.get("SALEORDER004") : null;
                String string = controlTime = paramsMap != null ? (String)paramsMap.get("SALEORDER004") : null;
                if ("true".equals(controlQty) && ms != null) {
                    entryInfo.setSendOverRate(ms != null ? new BigDecimal(ms.getIssueTopRatio()) : ZERO);
                } else {
                    entryInfo.setSendOverRate(ZERO);
                }
                if ("true".equals(controlQty) && ms != null) {
                    entryInfo.setSendOwingRate(ms != null ? new BigDecimal(ms.getIssueBottomRatio()) : ZERO);
                } else {
                    entryInfo.setSendOwingRate(ZERO);
                }
                if ("true".equals(controlTime) && ms != null) {
                    entryInfo.setSendAdvanceDay(ms != null ? new BigDecimal(ms.getDaydAhead()) : ZERO);
                } else {
                    entryInfo.setSendAdvanceDay(ZERO);
                }
                if ("true".equals(controlTime) && ms != null) {
                    entryInfo.setSendDeferralDay(ms != null ? new BigDecimal(ms.getDaysDelay()) : ZERO);
                } else {
                    entryInfo.setSendDeferralDay(ZERO);
                }
                entryInfo.setTotalIssueQty(this.NullToZero(entryInfo.getTotalIssueQty()));
                entryInfo.setTotalReturnedQty(this.NullToZero(entryInfo.getTotalReturnedQty()));
                entryInfo.setTotalInvoicedQty(this.NullToZero(entryInfo.getTotalInvoicedQty()));
                entryInfo.setTotalShippingQty(this.NullToZero(entryInfo.getTotalShippingQty()));
                entryInfo.setTotalReceivedAmount(this.NullToZero(entryInfo.getTotalReceivedAmount()));
                entryInfo.setTotalIssueBaseQty(this.NullToZero(entryInfo.getTotalIssueBaseQty()));
                entryInfo.setTotalReBaseQty(this.NullToZero(entryInfo.getTotalReBaseQty()));
                entryInfo.setTolInvoidBaseQty(this.NullToZero(entryInfo.getTolInvoidBaseQty()));
                entryInfo.setTotalShipBaseQty(this.NullToZero(entryInfo.getTotalShipBaseQty()));
                entryInfo.setTotalUnReturnBaseQty(this.NullToZero(entryInfo.getTotalUnReturnBaseQty()));
                entryInfo.setTotalUnIssueQty(this.NullToZero(entryInfo.getTotalUnIssueQty()));
                entryInfo.setTotalUnShipBaseQty(this.NullToZero(entryInfo.getTotalUnShipBaseQty()));
                entryInfo.setTotalUnIssueQty(this.NullToZero(entryInfo.getTotalUnIssueQty()));
                entryInfo.setLockQty(this.NullToZero(entryInfo.getLockQty()));
                entryInfo.setLockBaseQty(this.NullToZero(entryInfo.getLockBaseQty()));
                entryInfo.setLockAssistQty(this.NullToZero(entryInfo.getLockAssistQty()));
                entryInfo.setLocalTax(this.NullToZero(entryInfo.getLocalTax()));
                entryInfo.setLocalTaxAmount(this.NullToZero(entryInfo.getLocalTaxAmount()));
                entryInfo.setOrderedQty(this.NullToZero(entryInfo.getOrderedQty()));
                entryInfo.setUnOrderedQty(this.NullToZero(entryInfo.getUnOrderedQty()));
                entryInfo.setPrepaymentRate(this.NullToZero(entryInfo.getPrepaymentRate()));
                entryInfo.setPrepayment(this.NullToZero(entryInfo.getPrepayment()));
                entryInfo.setPreReceived(this.NullToZero(entryInfo.getPreReceived()));
                entryInfo.setUnPrereceivedAmount(this.NullToZero(entryInfo.getUnPrereceivedAmount()));
                entryInfo.setTotalInvoicedAmt(this.NullToZero(entryInfo.getTotalInvoicedAmt()));
                entryInfo.setTotalArAmount(this.NullToZero(entryInfo.getTotalArAmount()));
                if (entryInfo.getStorageOrgUnit() != null && saleOrderInfo.getStorageOrgUnit() != null) {
                    if (entryInfo.getStorageOrgUnit().getId().toString().equals(saleOrderInfo.getStorageOrgUnit().getId().toString())) {
                        entryInfo.setIsBetweenCompanySend(false);
                    } else {
                        entryInfo.setIsBetweenCompanySend(true);
                    }
                }
                entryInfo.setTotalProductQty(this.NullToZero(entryInfo.getTotalProductQty()));
                entryInfo.setTotalBaseProductQty(this.NullToZero(entryInfo.getTotalBaseProductQty()));
                entryInfo.setTotalunProductQty(this.NullToZero(entryInfo.getTotalunProductQty()));
                entryInfo.setTotalBaseunProductQty(this.NullToZero(entryInfo.getTotalBaseunProductQty()));
                entryInfo.setAssCoefficient(this.NullToZero(entryInfo.getAssCoefficient()));
                if (entryInfo.getBaseStatus() != null) continue;
            }
            if (!this.isFromGui) {
                try {
                    new SaleOrderAlgorithm(saleOrderInfo, this.ctx).revalue();
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
    }

    public BigDecimal NullToZero(BigDecimal big) {
        return big == null ? SysConstant.BIGZERO : big;
    }

    private void defaultValueForSave(SaleOrderInfo saleOrderInfo) throws BOSException, EASBizException {
        if (saleOrderInfo == null) {
            return;
        }
        if (!StringUtil.isEmpty((String)saleOrderInfo.getNumber())) {
            saleOrderInfo.setNumber(saleOrderInfo.getNumber().trim());
        }
        if (this.isAddNew(this.ctx, (IObjectValue)saleOrderInfo) && saleOrderInfo.getOrderCustomer() != null && saleOrderInfo.getOrderCustomer().getId() != null && saleOrderInfo.getOrderCustomer().getId().toString().length() > 0) {
            CustomerInfo customerInfo = CustomerFactory.getLocalInstance((Context)this.ctx).getCustomerInfo((IObjectPK)new ObjectUuidPK(saleOrderInfo.getOrderCustomer().getId().toString()), this.getSelectors());
            saleOrderInfo.setOrderCustomer(customerInfo);
        }
        SaleOrderEntryCollection tmpEntries = saleOrderInfo.getEntries();
        SaleOrderEntryInfo entryInfo = null;
        if (tmpEntries.size() == 0) {
            tmpEntries.add((SaleOrderEntryInfo)SaleOrderEntryAgent.create());
        }
        if (saleOrderInfo.getBillType() == null) {
            IBillType iBillType = BillTypeFactory.getLocalInstance((Context)this.ctx);
            BillTypeInfo billTypeInfo = iBillType.getBillTypeInfo((IObjectPK)new ObjectUuidPK("510b6503-0105-1000-e000-0113c0a812fd463ED552"));
            saleOrderInfo.setBillType(billTypeInfo);
        }
        Date tempDate = null;
        Calendar cal = Calendar.getInstance();
        if (saleOrderInfo.getBizDate() != null) {
            cal.setTime(saleOrderInfo.getBizDate());
            saleOrderInfo.setYear(cal.get(1));
            saleOrderInfo.setPeriod(cal.get(1) * 100 + (cal.get(2) + 1));
        }
        int num = tmpEntries.size();
        for (int i = 0; i < num; ++i) {
            entryInfo = tmpEntries.get(i);
            if (entryInfo.getBaseStatus() == null || EntryBaseStatusEnum.TEMPORARILYSAVED == entryInfo.getBaseStatus() || EntryBaseStatusEnum.ADD == entryInfo.getBaseStatus()) {
                entryInfo.setBaseStatus(EntryBaseStatusEnum.TEMPORARILYSAVED);
            }
            entryInfo.setBizDate(saleOrderInfo.getBizDate());
            entryInfo.setSaleOrgUnit(saleOrderInfo.getSaleOrgUnit().getId().toString());
            this.setZero(entryInfo);
            SCMServerUtils.eliminateNULLValue((Context)this.ctx, (IObjectValue)entryInfo);
            tempDate = entryInfo.getSendDate();
            if (tempDate != null) {
                cal.setTime(tempDate);
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                entryInfo.setSendDate(cal.getTime());
            }
            entryInfo.setArClosedStatus(SaleOrderArClosedStatusEnum.NONE);
        }
        SCMServerUtils.eliminateNULLValue((Context)this.ctx, (IObjectValue)saleOrderInfo);
        this.setEntryDefaultValue(this.ctx, (IObjectValue)saleOrderInfo);
    }

    private void defaultValueForSubmit(SaleOrderInfo saleOrderInfo) throws BOSException, EASBizException {
        if (saleOrderInfo == null) {
            return;
        }
        if (!StringUtil.isEmpty((String)saleOrderInfo.getNumber())) {
            saleOrderInfo.setNumber(saleOrderInfo.getNumber().trim());
        }
        if (this.isAddNew(this.ctx, (IObjectValue)saleOrderInfo) && saleOrderInfo.getOrderCustomer() != null && saleOrderInfo.getOrderCustomer().getId() != null && saleOrderInfo.getOrderCustomer().getId().toString().length() > 0) {
            CustomerInfo customerInfo = CustomerFactory.getLocalInstance((Context)this.ctx).getCustomerInfo((IObjectPK)new ObjectUuidPK(saleOrderInfo.getOrderCustomer().getId().toString()), this.getSelectors());
            saleOrderInfo.setOrderCustomer(customerInfo);
        }
        if (saleOrderInfo.getBillType() == null) {
            IBillType iBillType = BillTypeFactory.getLocalInstance((Context)this.ctx);
            BillTypeInfo billTypeInfo = iBillType.getBillTypeInfo((IObjectPK)new ObjectUuidPK("510b6503-0105-1000-e000-0113c0a812fd463ED552"));
            saleOrderInfo.setBillType(billTypeInfo);
        }
        if (saleOrderInfo.isIsReverse() && saleOrderInfo.getSourceBillType() == null) {
            saleOrderInfo.setSourceBillType(saleOrderInfo.getBillType());
        }
        saleOrderInfo.setBizDate(saleOrderInfo.getBizDate());
        saleOrderInfo.setVersion(0);
        saleOrderInfo.setOldID(null);
        if (saleOrderInfo.getBizDate() != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(saleOrderInfo.getBizDate());
            saleOrderInfo.setYear(cal.get(1));
            saleOrderInfo.setPeriod(cal.get(1) * 100 + (cal.get(2) + 1));
        }
        SaleOrderEntryCollection tmpEntries = saleOrderInfo.getEntries();
        SaleOrderEntryInfo soEntryInfo = null;
        int num = tmpEntries.size();
        for (int i = 0; i < num; ++i) {
            soEntryInfo = tmpEntries.get(i);
            if (soEntryInfo.getBaseStatus() == null || EntryBaseStatusEnum.ADD == soEntryInfo.getBaseStatus() || EntryBaseStatusEnum.TEMPORARILYSAVED == soEntryInfo.getBaseStatus() || EntryBaseStatusEnum.SUBMITED == soEntryInfo.getBaseStatus()) {
                soEntryInfo.setBaseStatus(EntryBaseStatusEnum.SUBMITED);
            }
            soEntryInfo.setBizDate(saleOrderInfo.getBizDate());
            soEntryInfo.setSaleOrgUnit(saleOrderInfo.getSaleOrgUnit().getId().toString());
            if (!saleOrderInfo.isIsReverse()) {
                BigDecimal baseQty = SCMUtils.effectualNumeric((BigDecimal)soEntryInfo.getBaseQty());
                BigDecimal Qty = SCMUtils.effectualNumeric((BigDecimal)soEntryInfo.getQty());
                soEntryInfo.setAssociateQty(baseQty);
                soEntryInfo.setTotalUnIssueQty(Qty);
                soEntryInfo.setTotalUnIssueBaseQty(baseQty);
                soEntryInfo.setTotalUnShipBaseQty(baseQty);
                soEntryInfo.setTotalUnReturnBaseQty(baseQty);
                soEntryInfo.setTotalReversedQty(SysConstant.BIGZERO);
                soEntryInfo.setTotalReversedBaseQty(SysConstant.BIGZERO);
                soEntryInfo.setUnPrereceivedAmount(SCMUtils.effectualNumeric((BigDecimal)soEntryInfo.getPrepayment()).subtract(SCMUtils.effectualNumeric((BigDecimal)soEntryInfo.getPreReceived())));
                soEntryInfo.setTotalunProductQty(soEntryInfo.getQty());
                soEntryInfo.setTotalBaseunProductQty(soEntryInfo.getBaseQty());
                soEntryInfo.setTotalSupplyStockQty(SysConstant.BIGZERO);
                soEntryInfo.setTotalCancellingStockQty(SysConstant.BIGZERO);
            } else {
                soEntryInfo.setIsBySaleOrder(false);
                soEntryInfo.setUnOrderedQty(SysConstant.BIGZERO);
                soEntryInfo.setIsLocked(false);
                soEntryInfo.setLockQty(SysConstant.BIGZERO);
                soEntryInfo.setLockBaseQty(SysConstant.BIGZERO);
                soEntryInfo.setAssociateQty(SysConstant.BIGZERO);
                soEntryInfo.setTotalUnIssueQty(SysConstant.BIGZERO);
                soEntryInfo.setTotalUnIssueBaseQty(SysConstant.BIGZERO);
                soEntryInfo.setTotalUnShipBaseQty(SysConstant.BIGZERO);
                soEntryInfo.setTotalUnReturnBaseQty(SysConstant.BIGZERO);
                soEntryInfo.setTotalReversedQty(SysConstant.BIGZERO);
                soEntryInfo.setTotalReversedBaseQty(SysConstant.BIGZERO);
                soEntryInfo.setUnPrereceivedAmount(SysConstant.BIGZERO);
                soEntryInfo.setTotalProductQty(SysConstant.BIGZERO);
                soEntryInfo.setTotalunProductQty(SysConstant.BIGZERO);
                soEntryInfo.setTotalBaseunProductQty(SysConstant.BIGZERO);
                soEntryInfo.setTotalSupplyStockQty(SysConstant.BIGZERO);
                soEntryInfo.setTotalCancellingStockQty(SysConstant.BIGZERO);
            }
            SCMServerUtils.eliminateNULLValue((Context)this.ctx, (IObjectValue)soEntryInfo);
            this.setZero(soEntryInfo);
            soEntryInfo.setVersion(0);
            if (soEntryInfo.getSendOwingRate() == null) {
                soEntryInfo.setSendOwingRate(new BigDecimal("0.00"));
            }
            if (soEntryInfo.getSendOverRate() == null) {
                soEntryInfo.setSendOverRate(new BigDecimal("0.00"));
            }
            soEntryInfo.setArClosedStatus(SaleOrderArClosedStatusEnum.NONE);
        }
        SCMServerUtils.eliminateNULLValue((Context)this.ctx, (IObjectValue)saleOrderInfo);
        this.setEntryDefaultValue(this.ctx, (IObjectValue)saleOrderInfo);
    }

    private void setEntryDefaultValue(Context ctx, IObjectValue model) {
        SaleOrderInfo info = (SaleOrderInfo)model;
        int n = info.getEntries().size();
        for (int i = 0; i < n; ++i) {
            if (info.getEntries().get(i).getCompanyOrgUnit() != null && info.getCompanyOrgUnit() != null) {
                if (info.getEntries().get(i).getCompanyOrgUnit().getId().equals((Object)info.getCompanyOrgUnit().getId())) {
                    info.getEntries().get(i).setIsBetweenCompanySend(false);
                } else {
                    info.getEntries().get(i).setIsBetweenCompanySend(true);
                }
            }
            if (info.getEntries().get(i).isIsBetweenCompanySend() || info.getCompanyOrgUnit() == null || info.getEntries().get(i).getCompanyOrgUnit() != null) continue;
            info.getEntries().get(i).setCompanyOrgUnit(info.getCompanyOrgUnit());
        }
    }

    private void setZero(SaleOrderEntryInfo entry) {
        String[] fields = new String[]{"price", "qty", "baseQty", "discountAmount", "taxAmount", "taxRate", "taxPrice", "discount", "actualPrice", "actualTaxPrice", "sendOverRate", "sendOwingRate", "sendAdvanceDay", "sendDeferralDay", "totalInvoicedAmt", "unPrereceivedAmount", "preReceived", "prepayment", "prepaymentRate", "unOrderedQty", "orderedQty", "localTaxAmount", "localTax", "lockBaseQty", "lockQty", "totalUnIssueQty", "totalUnShipBaseQty", "totalUnIssueBaseQty", "totalUnReturnBaseQty", "totalShipBaseQty", "tolInvoidBaseQty", "totalReBaseQty", "totalIssueBaseQty", "assCoefficient", "totalReceivedAmount", "totalShippingQty", "totalInvoicedQty", "totalProductQty", "totalunProductQty", "totalBaseProductQty", "totalBaseunProductQty"};
        this.setBigDecimalZeros(entry, fields);
    }

    private void setBigDecimalZeros(SaleOrderEntryInfo entry, String[] fields) {
        BigDecimal zero = new BigDecimal("0.00");
        Object[] zeros = new BigDecimal[]{zero};
        int length = fields.length;
        for (int i = 0; i < length; ++i) {
            String getMethodName = "get" + fields[i].substring(0, 1).toUpperCase() + fields[i].substring(1);
            String setMethodName = "set" + fields[i].substring(0, 1).toUpperCase() + fields[i].substring(1);
            try {
                Method getMethod = SaleOrderEntryInfo.class.getMethod(getMethodName, null);
                Method setMethod = SaleOrderEntryInfo.class.getMethod(setMethodName, BigDecimal.class);
                if (getMethod == null || getMethod.invoke((Object)entry, null) != null) continue;
                setMethod.invoke((Object)entry, zeros);
                continue;
            }
            catch (SecurityException e) {
                logger.info((Object)e);
                continue;
            }
            catch (NoSuchMethodException e) {
                logger.info((Object)e);
                continue;
            }
            catch (Exception e) {
                logger.info((Object)e);
            }
        }
    }

    private SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("country.id"));
        sic.add(new SelectorItemInfo("country.name"));
        sic.add(new SelectorItemInfo("country.number"));
        sic.add(new SelectorItemInfo("city.id"));
        sic.add(new SelectorItemInfo("city.name"));
        sic.add(new SelectorItemInfo("city.number"));
        sic.add(new SelectorItemInfo("province.id"));
        sic.add(new SelectorItemInfo("province.name"));
        sic.add(new SelectorItemInfo("province.number"));
        sic.add(new SelectorItemInfo("region.id"));
        sic.add(new SelectorItemInfo("region.name"));
        sic.add(new SelectorItemInfo("region.number"));
        sic.add(new SelectorItemInfo("browseGroup.id"));
        sic.add(new SelectorItemInfo("browseGroup.name"));
        sic.add(new SelectorItemInfo("browseGroup.number"));
        sic.add(new SelectorItemInfo("industry.id"));
        sic.add(new SelectorItemInfo("industry.name"));
        sic.add(new SelectorItemInfo("industry.number"));
        return sic;
    }

    @Override
    public BillTypeInfo getBillType() {
        BillTypeInfo info = new BillTypeInfo();
        info.setId(BOSUuid.read((String)"510b6503-0105-1000-e000-0113c0a812fd463ED552"));
        info.setNumber("310");
        return info;
    }

    public ProcessorExecutionMode supportExecutionMode() throws BOSException {
        return ProcessorExecutionMode.NESTED;
    }

    protected boolean _checkClosed(Context ctx, IObjectValue model, boolean isOk) throws EASBizException, BOSException {
        SaleOrderInfo saleOrderInfo = (SaleOrderInfo)model;
        StringBuffer sql = new StringBuffer();
        sql.append("select fbasestatus from T_SD_SaleOrder where fid = '");
        sql.append(saleOrderInfo.getId());
        sql.append("'");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rowSet.next()) {
                int baseStatus = rowSet.getInt(1);
                if (isOk) {
                    if (baseStatus == 7) {
                        throw new SCMBillException(SCMBillException.CHECKCLOSEDOK, new Object[]{saleOrderInfo.getString("number"), ""});
                    }
                } else if (baseStatus != 7) {
                    throw new SCMBillException(SCMBillException.CHECKCLOSEDNOTOK, new Object[]{saleOrderInfo.getString("number"), ""});
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return true;
    }
}

