/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.app.bizprocess.processor.saleorder;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.dynbusiness.ProcessorExecutionMode;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.framework.report.util.DBUtilx;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryCollection;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class SaleOrderReceivingMatchProcessor
extends AbstractBusinessProcessor {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)SaleOrderReceivingMatchProcessor.class.getName());
    private static final BigDecimal zero = new BigDecimal("0");

    public SaleOrderReceivingMatchProcessor(ProcessorConstructParam param) {
        super(param);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        String saleOrderID = (String)this.getExecuteContext().getApplicationContext().getData("saleOrderID");
        BigDecimal matchedAmount = (BigDecimal)this.getExecuteContext().getApplicationContext().getData("matchedAmount");
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("baseStatus"));
        sic.add(new SelectorItemInfo("beenPaidPrepayment"));
        sic.add(new SelectorItemInfo("isMatched"));
        sic.add(new SelectorItemInfo("entries.id"));
        sic.add(new SelectorItemInfo("entries.unPrereceivedAmount"));
        sic.add(new SelectorItemInfo("entries.prepayment"));
        sic.add(new SelectorItemInfo("entries.preReceived"));
        sic.add(new SelectorItemInfo("entries.baseStatus"));
        SaleOrderInfo saleOrder = (SaleOrderInfo)SaleOrderFactory.getLocalInstance((Context)this.ctx).getValue((IObjectPK)new ObjectUuidPK(saleOrderID), sic);
        SqlParams sp = new SqlParams();
        String sql = "delete from t_cas_receivingmatchentry where fparentid in(select fid from t_cas_receivingmatch where FSaleOrderID=?)";
        sp.addString(saleOrder.getId().toString());
        try {
            DBUtilx.executeUpdate((String)sql, (SqlParams)sp, (Context)this.ctx);
            sql = "delete from t_cas_receivingmatch where FSaleOrderID=?";
            sp.clear();
            sp.addString(saleOrder.getId().toString());
            DBUtilx.executeUpdate((String)sql, (SqlParams)sp, (Context)this.ctx);
        }
        catch (SQLException e) {
            logger.info((Object)("sql is :" + sql), (Throwable)e);
            throw new SQLDataException(e);
        }
        saleOrder.setBeenPaidPrepayment(matchedAmount);
        saleOrder.setIsMatched(true);
        SaleOrderEntryCollection sc = saleOrder.getEntries();
        int n = sc.size();
        for (int i = 0; i < n; ++i) {
            BigDecimal unPrepreceivedAmount;
            SaleOrderEntryInfo saleOrderEntryInfo = sc.get(i);
            BigDecimal bigDecimal = unPrepreceivedAmount = saleOrderEntryInfo.getUnPrereceivedAmount() == null ? SysConstant.BIGZERO : saleOrderEntryInfo.getUnPrereceivedAmount();
            if (matchedAmount.compareTo(unPrepreceivedAmount) > 0) {
                if (i == n - 1) {
                    saleOrderEntryInfo.setPreReceived(matchedAmount);
                    if (saleOrderEntryInfo.getPrepayment() == null || saleOrderEntryInfo.getPreReceived() == null) break;
                    saleOrderEntryInfo.setUnPrereceivedAmount(saleOrderEntryInfo.getPrepayment().subtract(saleOrderEntryInfo.getPreReceived()));
                    break;
                }
            } else {
                unPrepreceivedAmount = unPrepreceivedAmount.subtract(matchedAmount);
                saleOrderEntryInfo.setUnPrereceivedAmount(unPrepreceivedAmount);
                saleOrderEntryInfo.setPreReceived(matchedAmount);
                break;
            }
            saleOrderEntryInfo.setPreReceived(unPrepreceivedAmount);
            saleOrderEntryInfo.setUnPrereceivedAmount(zero);
            matchedAmount = matchedAmount.subtract(unPrepreceivedAmount);
        }
        this.updateSaleOrderInfo(this.ctx, saleOrder);
    }

    private void updateSaleOrderInfo(Context ctx, SaleOrderInfo saleOrderInfo) throws BOSException {
        StringBuffer errorSQL;
        StringBuffer orderEntrySQL;
        StringBuffer orderSQL;
        Statement stmt;
        Connection con;
        block8: {
            con = null;
            stmt = null;
            orderSQL = new StringBuffer();
            orderEntrySQL = new StringBuffer();
            errorSQL = new StringBuffer();
            con = EJBFactory.getConnection((Context)ctx);
            stmt = con.createStatement();
            if (saleOrderInfo != null && saleOrderInfo.getEntries().size() > 0) break block8;
            SQLUtils.cleanup((Statement)stmt, (Connection)con);
            return;
        }
        try {
            orderSQL.append("UPDATE T_SD_SALEORDER SET FbeenPaidPrepayment=").append(saleOrderInfo.getBeenPaidPrepayment()).append(",FisMatched= ").append(saleOrderInfo.isIsMatched() ? 1 : 0);
            if (!saleOrderInfo.isIsMatched() && BillBaseStatusEnum.SUBMITED.equals((Object)saleOrderInfo.getBaseStatus())) {
                orderSQL.append(",FBaseStatus=1");
            }
            orderSQL.append(" WHERE FID = '").append(saleOrderInfo.getId().toString()).append("'");
            stmt.addBatch(orderSQL.toString());
            int size = saleOrderInfo.getEntries().size();
            for (int i = 0; i < size; ++i) {
                orderEntrySQL.append("UPDATE T_SD_SALEORDERENTRY SET FunPrereceivedAmount=").append(saleOrderInfo.getEntries().get(i).getUnPrereceivedAmount()).append(",FpreReceived=").append(saleOrderInfo.getEntries().get(i).getPreReceived());
                if (!saleOrderInfo.isIsMatched() && BillBaseStatusEnum.SUBMITED.equals((Object)saleOrderInfo.getBaseStatus())) {
                    orderEntrySQL.append(",FBaseStatus=1");
                }
                orderEntrySQL.append(" WHERE FParentID='").append(saleOrderInfo.getId().toString()).append("' and FID = '").append(saleOrderInfo.getEntries().get(i).getId().toString()).append("'");
                stmt.addBatch(orderEntrySQL.toString());
                errorSQL.append(orderEntrySQL.toString()).append("\r\n");
                orderEntrySQL.setLength(0);
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                logger.info((Object)("sql is error:" + orderSQL.toString() + errorSQL.toString()), (Throwable)e);
                throw new BOSException("sql is error:" + orderSQL.toString() + errorSQL.toString(), (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)con);
    }

    public ProcessorExecutionMode supportExecutionMode() throws BOSException {
        return null;
    }
}

