/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.app.bizprocess.processor.saleorder;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.ProcessorExecutionMode;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryCollection;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class SaleOrderUnReceivingMatchProcessor
extends AbstractBusinessProcessor {
    private static Logger logger = Logger.getLogger((String)SaleOrderUnReceivingMatchProcessor.class.getName());
    private static final BigDecimal zero = new BigDecimal("0");

    public SaleOrderUnReceivingMatchProcessor(ProcessorConstructParam param) {
        super(param);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        String saleOrderID = (String)this.getExecuteContext().getApplicationContext().getData("saleOrderID");
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("baseStatus"));
        sic.add(new SelectorItemInfo("beenPaidPrepayment"));
        sic.add(new SelectorItemInfo("isMatched"));
        sic.add(new SelectorItemInfo("entries.id"));
        sic.add(new SelectorItemInfo("entries.unPrereceivedAmount"));
        sic.add(new SelectorItemInfo("entries.prepayment"));
        sic.add(new SelectorItemInfo("entries.preReceived"));
        sic.add(new SelectorItemInfo("entries.baseStatus"));
        SaleOrderInfo saleOrder = (SaleOrderInfo)SaleOrderFactory.getLocalInstance((Context)this.ctx).getValue((IObjectPK)new ObjectUuidPK(saleOrderID), sic);
        saleOrder.setBeenPaidPrepayment(zero);
        saleOrder.setIsMatched(false);
        SaleOrderEntryCollection sc = saleOrder.getEntries();
        int n = sc.size();
        for (int i = 0; i < n; ++i) {
            SaleOrderEntryInfo orderEntryInfo = sc.get(i);
            orderEntryInfo.setUnPrereceivedAmount(orderEntryInfo.getPrepayment());
            orderEntryInfo.setPreReceived(zero);
        }
        this.updateSaleOrderInfo(this.ctx, saleOrder);
    }

    private void updateSaleOrderInfo(Context ctx, SaleOrderInfo saleOrderInfo) throws BOSException {
        StringBuffer errorSQL;
        StringBuffer orderEntrySQL;
        StringBuffer orderSQL;
        Statement stmt;
        Connection con;
        block8: {
            con = null;
            stmt = null;
            orderSQL = new StringBuffer();
            orderEntrySQL = new StringBuffer();
            errorSQL = new StringBuffer();
            con = EJBFactory.getConnection((Context)ctx);
            stmt = con.createStatement();
            if (saleOrderInfo != null && saleOrderInfo.getEntries().size() > 0) break block8;
            SQLUtils.cleanup((Statement)stmt, (Connection)con);
            return;
        }
        try {
            orderSQL.append("UPDATE T_SD_SALEORDER SET FbeenPaidPrepayment=").append(saleOrderInfo.getBeenPaidPrepayment()).append(",FisMatched= ").append(saleOrderInfo.isIsMatched() ? 1 : 0);
            if (!saleOrderInfo.isIsMatched() && BillBaseStatusEnum.SUBMITED.equals((Object)saleOrderInfo.getBaseStatus())) {
                orderSQL.append(",FBaseStatus=1");
            }
            orderSQL.append(" WHERE FID = '").append(saleOrderInfo.getId().toString()).append("'");
            stmt.addBatch(orderSQL.toString());
            int size = saleOrderInfo.getEntries().size();
            for (int i = 0; i < size; ++i) {
                orderEntrySQL.append("UPDATE T_SD_SALEORDERENTRY SET FunPrereceivedAmount=").append(saleOrderInfo.getEntries().get(i).getUnPrereceivedAmount()).append(",FpreReceived=").append(saleOrderInfo.getEntries().get(i).getPreReceived());
                if (!saleOrderInfo.isIsMatched() && BillBaseStatusEnum.SUBMITED.equals((Object)saleOrderInfo.getBaseStatus())) {
                    orderEntrySQL.append(",FBaseStatus=1");
                }
                orderEntrySQL.append(" WHERE FParentID='").append(saleOrderInfo.getId().toString()).append("' and FID = '").append(saleOrderInfo.getEntries().get(i).getId().toString()).append("'");
                stmt.addBatch(orderEntrySQL.toString());
                errorSQL.append(orderEntrySQL.toString()).append("\r\n");
                orderEntrySQL.setLength(0);
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                logger.info((Object)("sql is error:" + orderSQL.toString() + errorSQL.toString()), (Throwable)e);
                throw new BOSException("sql is error:" + orderSQL.toString() + errorSQL.toString(), (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)con);
    }

    public ProcessorExecutionMode supportExecutionMode() throws BOSException {
        return null;
    }
}

