/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.app.bizprocess.processor.salereturns;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.ProcessorExecutionModeEnum;
import com.kingdee.eas.dynbusiness.TransactionModeEnum;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.ISaleIssueEntry;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryFactory;
import com.kingdee.eas.scm.im.inv.SaleIssueEntryInfo;
import com.kingdee.eas.scm.sd.sale.ISaleOrderEntry;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleReturnsEntryCollection;
import com.kingdee.eas.scm.sd.sale.SaleReturnsEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleReturnsInfo;
import java.math.BigDecimal;

public class SaleReturns2SI4AuditProcessor
extends AbstractBusinessProcessor {
    public SaleReturns2SI4AuditProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public SaleReturns2SI4AuditProcessor(ExecuteContext executeContext, ProcessorExecutionModeEnum executeMode, Conditions conditions, TransactionModeEnum transactionMode) {
        super(executeContext, executeMode, conditions, transactionMode);
    }

    public SaleReturns2SI4AuditProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectCollection col = batchResults.getObjCollection();
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            IObjectValue model = col.getObject(i);
            this.writebackSI(model);
        }
    }

    private void writebackSI(IObjectValue model) throws BOSException, EASBizException {
        SaleReturnsInfo info = (SaleReturnsInfo)model;
        if (!(!SCMUtils.isBotpBill((SCMBillBaseInfo)info, (String)"50957179-0105-1000-e000-015bc0a812fd463ED552") || SCMServerUtils.isExistsBizFlowField((Context)this.ctx, (String)"T_SD_SALERETURNSENTRY") && SCMServerUtils.isHasBizFlowValue((Context)this.ctx, (String)"T_SD_SALERETURNSENTRY", (String)info.getId().toString()))) {
            this.updateSaleIssueToOrder(this.ctx, (IObjectValue)info);
        }
    }

    protected void updateSaleIssueToOrder(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        BigDecimal zero = new BigDecimal("0.00");
        SaleReturnsInfo returnInfo = (SaleReturnsInfo)info;
        SaleReturnsEntryCollection s = returnInfo.getEntries();
        ISaleIssueEntry iIssueEntry = SaleIssueEntryFactory.getLocalInstance((Context)ctx);
        ISaleOrderEntry iSaleOrderEntry = SaleOrderEntryFactory.getLocalInstance((Context)ctx);
        CoreBaseCollection saleIEntryColl = new CoreBaseCollection();
        CoreBaseCollection saleOEntryColl = new CoreBaseCollection();
        int size = s.size();
        for (int i = 0; i < size; ++i) {
            SaleReturnsEntryInfo sEntryInfo = s.get(i);
            if (sEntryInfo.getSourceBillEntryId() == null) continue;
            BigDecimal returnQty = zero;
            ObjectStringPK issueEntryPK = new ObjectStringPK(sEntryInfo.getSourceBillEntryId().toString());
            SaleIssueEntryInfo issueEntryInfo = iIssueEntry.getSaleIssueEntryInfo((IObjectPK)issueEntryPK);
            if (issueEntryInfo.getSourceBillType() != null && issueEntryInfo.getSourceBillType().getId().toString().equals("510b6503-0105-1000-e000-0113c0a812fd463ED552")) {
                ObjectStringPK orderEntryPK = new ObjectStringPK(issueEntryInfo.getSaleOrderEntry());
                SaleOrderEntryInfo orderEntryInfo = iSaleOrderEntry.getSaleOrderEntryInfo((IObjectPK)orderEntryPK);
                BigDecimal qty = orderEntryInfo.getTotalReturnedQty();
                BigDecimal baseQty = orderEntryInfo.getTotalReBaseQty();
                returnQty = sEntryInfo.getQty();
                if (!sEntryInfo.getUnit().getId().toString().equals(orderEntryInfo.getUnit().getId().toString())) {
                    returnQty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)orderEntryInfo.getMaterial().getId().toString(), (String)orderEntryInfo.getBaseUnit().getId().toString(), (BigDecimal)sEntryInfo.getBaseQty(), (String)orderEntryInfo.getUnit().getId().toString());
                }
                if (qty.compareTo(zero) == 0) {
                    orderEntryInfo.setTotalReturnedQty(returnQty);
                    orderEntryInfo.setTotalReBaseQty(sEntryInfo.getBaseQty());
                } else {
                    orderEntryInfo.setTotalReturnedQty(qty.add(returnQty));
                    orderEntryInfo.setTotalReBaseQty(baseQty.add(sEntryInfo.getBaseQty()));
                }
                saleOEntryColl.add((CoreBaseInfo)orderEntryInfo);
            }
            returnQty = sEntryInfo.getQty();
            if (!issueEntryInfo.getUnit().getId().toString().equals(sEntryInfo.getUnit().getId().toString())) {
                returnQty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)issueEntryInfo.getMaterial().getId().toString(), (String)issueEntryInfo.getBaseUnit().getId().toString(), (BigDecimal)sEntryInfo.getBaseQty(), (String)issueEntryInfo.getUnit().getId().toString());
            }
            issueEntryInfo.setReturnsQty(issueEntryInfo.getReturnsQty().add(returnQty));
            issueEntryInfo.setUnReturnedBaseQty((issueEntryInfo.getUnReturnedBaseQty() == null ? issueEntryInfo.getBaseQty() : issueEntryInfo.getUnReturnedBaseQty()).subtract(sEntryInfo.getBaseQty()).abs());
            saleIEntryColl.add((CoreBaseInfo)issueEntryInfo);
        }
        iSaleOrderEntry.updateBatchData(saleOEntryColl);
        iIssueEntry.updateBatchData(saleIEntryColl);
    }
}

