/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.app.bizprocess.processor.salereturns;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.ProcessorExecutionModeEnum;
import com.kingdee.eas.dynbusiness.TransactionModeEnum;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sd.sale.SaleReturnsEntryCollection;
import com.kingdee.eas.scm.sd.sale.SaleReturnsEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleReturnsInfo;
import com.kingdee.eas.util.app.DbUtil;

public class SaleReturns2SO4AuditProcessor
extends AbstractBusinessProcessor {
    public SaleReturns2SO4AuditProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public SaleReturns2SO4AuditProcessor(ExecuteContext executeContext, ProcessorExecutionModeEnum executeMode, Conditions conditions, TransactionModeEnum transactionMode) {
        super(executeContext, executeMode, conditions, transactionMode);
    }

    public SaleReturns2SO4AuditProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectCollection col = batchResults.getObjCollection();
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            IObjectValue model = col.getObject(i);
            this.writebackSO(model);
        }
    }

    private void writebackSO(IObjectValue model) throws BOSException, EASBizException {
        SaleReturnsInfo info = (SaleReturnsInfo)model;
        if (!(!SCMUtils.isBotpBill((SCMBillBaseInfo)info, (String)"510b6503-0105-1000-e000-0113c0a812fd463ED552") || SCMServerUtils.isExistsBizFlowField((Context)this.ctx, (String)"T_SD_SALERETURNSENTRY") && SCMServerUtils.isHasBizFlowValue((Context)this.ctx, (String)"T_SD_SALERETURNSENTRY", (String)info.getId().toString()))) {
            SaleReturnsEntryCollection entryCol = null;
            StringBuffer entriesId = new StringBuffer();
            StringBuffer entriesSourceBillId = new StringBuffer();
            entryCol = info.getEntries();
            if (entryCol != null) {
                int size = entryCol.size();
                for (int i = 0; i < size; ++i) {
                    SaleReturnsEntryInfo sEntryInfo = entryCol.get(i);
                    if (entriesId.length() > 0) {
                        entriesId.append(",");
                        entriesSourceBillId.append(",");
                    }
                    entriesSourceBillId.append("'").append(sEntryInfo.getSourceBillEntryId()).append("'");
                    entriesId.append("'").append(sEntryInfo.getId().toString()).append("'");
                }
            }
            DbUtil.execute((Context)this.ctx, (String)this.getUpdateOrderEntryWB(entriesId.toString(), entriesSourceBillId.toString()));
        }
    }

    private String getUpdateOrderEntryWB(String entriesId, String entriesSourceBillId) {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_SD_SALEORDERENTRY AS ORDERENTRY SET (FTOTALRETURNEDQTY,FTOTALREBASEQTY,FTOTALUNRETURNBASEQTY) = ");
        sql.append("(SELECT ");
        sql.append("  CASE WHEN SUBORDERENTRY.FUNITID = RETURNENTRY.FUNITID THEN  ");
        sql.append("     CASE WHEN SUBORDERENTRY.FQTY = 0 THEN RETURNENTRY.FQTY ELSE SUBORDERENTRY.FTOTALRETURNEDQTY + RETURNENTRY.FQTY END ");
        sql.append("  ELSE CASE WHEN SUBORDERENTRY.FQTY = 0 THEN RETURNENTRY.FQTY*mmu.FBaseConvsRate/mmu2.FBaseConvsRate ELSE ");
        sql.append("     SUBORDERENTRY.FTOTALRETURNEDQTY + RETURNENTRY.FQTY*mmu.FBaseConvsRate/mmu2.FBaseConvsRate END ");
        sql.append("  END, ");
        sql.append("  CASE WHEN SUBORDERENTRY.FQTY = 0 THEN RETURNENTRY.FBASEQTY ELSE SUBORDERENTRY.FTOTALREBASEQTY + RETURNENTRY.FBASEQTY END,");
        sql.append("  CASE WHEN SUBORDERENTRY.FUNITID = RETURNENTRY.FUNITID THEN ");
        sql.append("     SUBORDERENTRY.FQTY-RETURNENTRY.FQTY ");
        sql.append("  ELSE ");
        sql.append("     SUBORDERENTRY.FQTY- RETURNENTRY.FQTY*mmu.FBaseConvsRate/mmu2.FBaseConvsRate ");
        sql.append("  END ");
        sql.append("  FROM (SELECT FUNITID, FQTY, FBASEQTY,FSOURCEBILLENTRYID,FMaterialID FROM T_SD_SALERETURNSENTRY WHERE FID IN (").append(entriesId).append(")) AS RETURNENTRY ");
        sql.append("  LEFT JOIN T_SD_SALEORDERENTRY AS SUBORDERENTRY ON SUBORDERENTRY.FID = RETURNENTRY.FSOURCEBILLENTRYID");
        sql.append("  LEFT JOIN T_BD_MultiMeasureUnit mmu ON mmu.FMaterialID=RETURNENTRY.FMaterialID AND mmu.FMeasureUnitID=RETURNENTRY.FUnitID");
        sql.append("  LEFT JOIN T_BD_MultiMeasureUnit mmu2 ON mmu2.FMaterialID=SUBORDERENTRY.FMaterialID AND mmu2.FMeasureUnitID=SUBORDERENTRY.FUnitID");
        sql.append("  WHERE RETURNENTRY.FSOURCEBILLENTRYID = ORDERENTRY.FID) ");
        sql.append("WHERE ORDERENTRY.FID IN (").append(entriesSourceBillId).append(")");
        return sql.toString();
    }
}

