/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.app.bizprocess.processor.salereturns;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.ProcessorExecutionModeEnum;
import com.kingdee.eas.dynbusiness.TransactionModeEnum;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sd.sale.ISaleOrderEntry;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleReturnsEntryCollection;
import com.kingdee.eas.scm.sd.sale.SaleReturnsEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleReturnsFactory;
import com.kingdee.eas.scm.sd.sale.SaleReturnsInfo;
import java.math.BigDecimal;

public class SaleReturns2SO4UnAuditProcessor
extends AbstractBusinessProcessor {
    public SaleReturns2SO4UnAuditProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public SaleReturns2SO4UnAuditProcessor(ExecuteContext executeContext, ProcessorExecutionModeEnum executeMode, Conditions conditions, TransactionModeEnum transactionMode) {
        super(executeContext, executeMode, conditions, transactionMode);
    }

    public SaleReturns2SO4UnAuditProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectCollection col = batchResults.getObjCollection();
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            IObjectValue model = col.getObject(i);
            this.writebackSO(model);
        }
    }

    private void writebackSO(IObjectValue model) throws BOSException, EASBizException {
        SaleReturnsInfo info = (SaleReturnsInfo)model;
        String id = info.getId().toString();
        if (!(!SCMUtils.isBotpBill((SCMBillBaseInfo)info, (String)"510b6503-0105-1000-e000-0113c0a812fd463ED552") || SCMServerUtils.isExistsBizFlowField((Context)this.ctx, (String)"T_SD_SALERETURNSENTRY") && SCMServerUtils.isHasBizFlowValue((Context)this.ctx, (String)"T_SD_SALERETURNSENTRY", (String)id))) {
            BigDecimal negateQty;
            BigDecimal negateBaseQty;
            int j;
            int size = info.getEntries().size();
            for (j = 0; j < size; ++j) {
                negateBaseQty = info.getEntries().get(j).getBaseQty().negate();
                info.getEntries().get(j).setBaseQty(negateBaseQty);
                negateQty = info.getEntries().get(j).getQty().negate();
                info.getEntries().get(j).setQty(negateQty);
            }
            SaleReturnsFactory.getLocalInstance((Context)this.ctx).update((IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
            this.updateOrder(this.ctx, (IObjectValue)info);
            size = info.getEntries().size();
            for (j = 0; j < size; ++j) {
                negateBaseQty = info.getEntries().get(j).getBaseQty().negate();
                info.getEntries().get(j).setBaseQty(negateBaseQty);
                negateQty = info.getEntries().get(j).getQty().negate();
                info.getEntries().get(j).setQty(negateQty);
            }
            SaleReturnsFactory.getLocalInstance((Context)this.ctx).update((IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
        }
    }

    protected void updateOrder(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        BigDecimal zero = new BigDecimal("0.00");
        SaleReturnsInfo returnInfo = (SaleReturnsInfo)info;
        SaleReturnsEntryCollection s = returnInfo.getEntries();
        ISaleOrderEntry iSaleOrderEntry = SaleOrderEntryFactory.getLocalInstance((Context)ctx);
        int size = s.size();
        for (int i = 0; i < size; ++i) {
            SaleReturnsEntryInfo sEntryInfo = s.get(i);
            if (sEntryInfo.getSourceBillEntryId() == null) continue;
            ObjectStringPK orderEntryPK = new ObjectStringPK(sEntryInfo.getSourceBillEntryId().toString());
            SaleOrderEntryInfo orderEntryInfo = iSaleOrderEntry.getSaleOrderEntryInfo((IObjectPK)orderEntryPK);
            BigDecimal qty = orderEntryInfo.getTotalReturnedQty();
            BigDecimal baseQty = orderEntryInfo.getTotalReBaseQty();
            BigDecimal returnQty = sEntryInfo.getQty();
            if (!sEntryInfo.getUnit().getId().toString().equals(orderEntryInfo.getUnit().getId().toString())) {
                returnQty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)orderEntryInfo.getMaterial().getId().toString(), (String)orderEntryInfo.getBaseUnit().getId().toString(), (BigDecimal)sEntryInfo.getBaseQty(), (String)orderEntryInfo.getUnit().getId().toString());
            }
            if (qty.compareTo(zero) == 0) {
                orderEntryInfo.setTotalReturnedQty(returnQty);
                orderEntryInfo.setTotalReBaseQty(sEntryInfo.getBaseQty());
                orderEntryInfo.setTotalUnReturnBaseQty(orderEntryInfo.getQty().subtract(returnQty));
            } else {
                orderEntryInfo.setTotalReturnedQty(qty.add(returnQty));
                orderEntryInfo.setTotalReBaseQty(baseQty.add(sEntryInfo.getBaseQty()));
                orderEntryInfo.setTotalUnReturnBaseQty(orderEntryInfo.getQty().subtract(returnQty));
            }
            iSaleOrderEntry.update((IObjectPK)orderEntryPK, (CoreBaseInfo)orderEntryInfo);
        }
    }
}

