/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.app.bizprocess.processor.salereturns;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.IBillType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.ProcessorExecutionModeEnum;
import com.kingdee.eas.dynbusiness.TransactionModeEnum;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.app.bizprocess.processor.SCMDefaultValueProcessor;
import com.kingdee.eas.scm.sd.sale.SaleReturnsEntryCollection;
import com.kingdee.eas.scm.sd.sale.SaleReturnsEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleReturnsInfo;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.log4j.Logger;

public class SaleReturnsDefaultValueProcessor
extends SCMDefaultValueProcessor {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sd.sale.app.bizprocess.processor.salereturns.SaleReturnsDefaultValueProcessor");

    public SaleReturnsDefaultValueProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public SaleReturnsDefaultValueProcessor(ExecuteContext executeContext, ProcessorExecutionModeEnum executeMode, Conditions conditions, TransactionModeEnum transactionMode) {
        super(executeContext, executeMode, conditions, transactionMode);
    }

    public SaleReturnsDefaultValueProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    protected BillTypeInfo getBillType() {
        BillTypeInfo info = new BillTypeInfo();
        info.setId(BOSUuid.read((String)"50957179-0105-1000-e008-8152c0a812fd463ED552"));
        info.setNumber("350");
        return info;
    }

    protected CompanyOrgUnitInfo getCompanyOrgUnit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SaleReturnsInfo sr = (SaleReturnsInfo)model;
        return sr.getCompanyOrgUnit();
    }

    protected String getEntryName() {
        return "entries";
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        block4: {
            IObjectValue model;
            IObjectCollection collection;
            block3: {
                super.doProcessing(batchResults);
                collection = batchResults.getObjCollection();
                if (CollectionUtil.isEmpty((IObjectCollection)collection)) {
                    return;
                }
                model = null;
                if (!BatchActionEnum.SAVE.equals((Object)this.batchAction)) break block3;
                int size = collection.size();
                for (int i = 0; i < size; ++i) {
                    model = collection.getObject(i);
                    this.saveDefaultValue(model);
                }
                break block4;
            }
            if (!BatchActionEnum.SUBMIT.equals((Object)this.batchAction)) break block4;
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                model = collection.getObject(i);
                this.submitDefaultValue(model);
            }
        }
    }

    private void saveDefaultValue(IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            return;
        }
        SaleReturnsInfo info = (SaleReturnsInfo)model;
        SaleReturnsEntryCollection entryInfos = info.getEntries();
        SaleReturnsEntryInfo entry = null;
        int num = entryInfos.size();
        for (int i = 0; i < num; ++i) {
            entry = entryInfos.get(i);
            if (entry.getBaseStatus() == null || EntryBaseStatusEnum.ADD.equals((Object)entry.getBaseStatus()) || EntryBaseStatusEnum.TEMPORARILYSAVED.equals((Object)entry.getBaseStatus())) {
                entry.setBaseStatus(EntryBaseStatusEnum.TEMPORARILYSAVED);
            }
            this.setZero(entry);
        }
        if (info.getBizDate() == null) {
            info.setBizDate(new Date(System.currentTimeMillis()));
        }
    }

    private void submitDefaultValue(IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            return;
        }
        SaleReturnsInfo info = (SaleReturnsInfo)model;
        if (info.getBillType() == null) {
            IBillType iBillType = BillTypeFactory.getLocalInstance((Context)this.ctx);
            BillTypeInfo billTypeInfo = iBillType.getBillTypeInfo((IObjectPK)new ObjectUuidPK("50957179-0105-1000-e008-8152c0a812fd463ED552"));
            info.setBillType(billTypeInfo);
        }
        SaleReturnsEntryCollection entryInfos = info.getEntries();
        SaleReturnsEntryInfo entry = null;
        int num = entryInfos.size();
        for (int i = 0; i < num; ++i) {
            entry = entryInfos.get(i);
            if (entry.getBaseStatus() == null || EntryBaseStatusEnum.ADD.equals((Object)entry.getBaseStatus()) || EntryBaseStatusEnum.TEMPORARILYSAVED.equals((Object)entry.getBaseStatus())) {
                entry.setBaseStatus(EntryBaseStatusEnum.SUBMITED);
            }
            this.setZero(entry);
        }
        if (info.getBizDate() == null) {
            info.setBizDate(new Date(System.currentTimeMillis()));
        }
        if (info.getPaymentType() == null) {
            PaymentTypeInfo paymentTypeInfo = new PaymentTypeInfo();
            paymentTypeInfo.setId(BOSUuid.read((String)"91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5"));
            info.setPaymentType(paymentTypeInfo);
        }
    }

    private void setZero(SaleReturnsEntryInfo entry) {
        String[] fields = new String[]{"qty", "price", "taxPrice", "amount", "taxRate", "tax", "taxAmount", "returnsQty", "remainingQty", "invoicedQty", "invoicePrice", "localAmount", "baseQty", "returnsBaseQty", "remainingBaseQty", "invoicedBaseQty", "associateQty", "localTax", "localTaxAmount", "totalReturnAmt", "totalInvoicedAmt", "assCoefficient", "cheapRate", "planDeliveryQty", "planDeliveryBaseQty"};
        this.setBigDecimalZerosIfThisFieldIsNull(entry, fields);
    }

    private void setBigDecimalZerosIfThisFieldIsNull(SaleReturnsEntryInfo entry, String[] fields) {
        BigDecimal zero = new BigDecimal("0.00");
        Object[] zeros = new BigDecimal[]{zero};
        int length = fields.length;
        for (int i = 0; i < length; ++i) {
            String getMethodName = "get" + fields[i].substring(0, 1).toUpperCase() + fields[i].substring(1);
            String setMethodName = "set" + fields[i].substring(0, 1).toUpperCase() + fields[i].substring(1);
            try {
                Method getMethod = SaleReturnsEntryInfo.class.getMethod(getMethodName, null);
                Method setMethod = SaleReturnsEntryInfo.class.getMethod(setMethodName, BigDecimal.class);
                if (getMethod == null || getMethod.invoke((Object)entry, null) != null) continue;
                setMethod.invoke((Object)entry, zeros);
                continue;
            }
            catch (SecurityException e) {
                logger.error((Object)e);
                continue;
            }
            catch (NoSuchMethodException e) {
                logger.error((Object)e);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }
}

