/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.app.bizprocess.processor.salereturns;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.scm.sd.sale.IPriceParam;
import com.kingdee.eas.basedata.scm.sd.sale.IPriceProvider;
import com.kingdee.eas.basedata.scm.sd.sale.PriceCondition;
import com.kingdee.eas.basedata.scm.sd.sale.PriceParamException;
import com.kingdee.eas.basedata.scm.sd.sale.PriceParamFactory;
import com.kingdee.eas.basedata.scm.sd.sale.PriceParamInfo;
import com.kingdee.eas.basedata.scm.sd.sale.PricePolicyException;
import com.kingdee.eas.basedata.scm.sd.sale.PriceProviderFactory;
import com.kingdee.eas.basedata.scm.sd.sale.SalePriceTO;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.ProcessorExecutionModeEnum;
import com.kingdee.eas.dynbusiness.TransactionModeEnum;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.app.SCMGroupServerUtils;
import com.kingdee.eas.scm.common.app.bizprocess.util.SCMBizProcessorUtil;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.sd.sale.ISaleInnerDealPrice;
import com.kingdee.eas.scm.sd.sale.SaleInnerDealPriceFactory;
import com.kingdee.eas.scm.sd.sale.SaleInnerDealPriceInfo;
import com.kingdee.eas.scm.sd.sale.SaleReturnsInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;

public class SaleReturnsInnerDealPrice4SubmitProcessor
extends AbstractBusinessProcessor {
    public SaleReturnsInnerDealPrice4SubmitProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public SaleReturnsInnerDealPrice4SubmitProcessor(ExecuteContext executeContext, ProcessorExecutionModeEnum executeMode, Conditions conditions, TransactionModeEnum transactionMode) {
        super(executeContext, executeMode, conditions, transactionMode);
    }

    public SaleReturnsInnerDealPrice4SubmitProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectCollection col = batchResults.getObjCollection();
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            IObjectValue model = col.getObject(i);
            this.dealInnerPrice(model);
        }
    }

    private void dealInnerPrice(IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            return;
        }
        SaleReturnsInfo info = (SaleReturnsInfo)model;
        if (info.getId() == null) {
            return;
        }
        this.clearInnerDealPrice(this.ctx, info.getId().toString());
        this.caculateInnerDealPrice(this.ctx, info.getId().toString());
    }

    private void clearInnerDealPrice(Context ctx, String pk) throws BOSException {
        Connection con = null;
        Statement statement = null;
        StringBuffer str = new StringBuffer();
        try {
            con = SCMBizProcessorUtil.getConnection((Context)ctx);
            statement = con.createStatement();
            str.append(" delete ").append(" T_SD_SaleReturnInnerDealPrice ").append(" where FSaleRetrunId ='").append(pk).append("'");
            statement.executeUpdate(str.toString());
        }
        catch (SQLException er) {
            try {
                throw new BOSException("sql Execute Error :", (Throwable)er);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)con);
                SQLUtils.cleanup((Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)con);
        SQLUtils.cleanup((Connection)con);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void caculateInnerDealPrice(Context ctx, String id) throws BOSException, EASBizException {
        Connection con = null;
        Statement statement = null;
        IRowSet verifyResult = null;
        IRowSet centralBalanceResult = null;
        IRowSet squareBalanceResult1 = null;
        IRowSet squareBalanceResult2 = null;
        try {
            con = SCMBizProcessorUtil.getConnection((Context)ctx);
            statement = con.createStatement();
            StringBuffer sql = new StringBuffer();
            sql.append("select sr.Fid from T_SD_SaleReturns sr ").append(" inner join T_SD_SaleReturnsEntry se on se.FParentID = sr.FID ").append(" where sr.FID ='").append(id).append("' and sr.FIsCentralBalance = 1 and sr.FIsSquareBalance = 1 and se.FIsBetweenCompanySend = 1 ");
            String verifySQL = sql.toString();
            sql.setLength(0);
            sql.append("select sr.Fid from T_SD_SaleReturns sr ").append(" inner join T_SD_SaleReturnsEntry se on se.FParentID = sr.FID ").append(" where sr.FID ='").append(id).append("' and sr.FIsCentralBalance = 1 and sr.FIsSquareBalance = 0 and se.FIsBetweenCompanySend = 1 ");
            String verifyCentralSQL = sql.toString();
            sql.setLength(0);
            sql.append("select sr.fid id,sr.fsourcebilltypeid sourcebilltypeid,sr.FBizDate bizDate,se.fid entryid,sr.FSaleOrgUnitID saleOrgUntiID,se.FCompanyOrgUnitID companyOrgUntiID,sr.FCurrencyID currencyid,se.FMaterialID materialid,se.FUnitID unitid,se.FBaseUnitID baseUnitID,se.FAssistPropertyID assistProperyID,cus.fid customerid,se.FQty qty,se.FTaxRate taxrate,se.FCheapRate secheaprate,se.FPrice price,-1 discounttype,0.0000 discount,se.FTaxRate actualprice,se.FTaxPrice actualtaxprice,se.FTaxPrice taxprice,se.fsourcebillid sourcebillid,se.fsourcebillentryid sourcebillentryid ,material.FPricePrecision priceprecision ,mi.FCheapRate cheapRate ,ms.FCheapRate scheapRate,com.FBASECURRENCYID basecurrency").append("  from T_SD_SaleReturns sr ").append(" inner join T_SD_SaleReturnsEntry se on se.FParentID = sr.FID ").append(" inner join T_ORG_COMPANY  com on sr.FCompanyOrgUnitID = com.fid ").append(" inner join T_BD_Customer cus on cus.FInternalCompanyID = sr.FCompanyOrgUnitID  and cus.fusedstatus = 1").append(" inner join T_BD_Material material on se.FMaterialID = material.FID ").append(" inner join T_BD_MaterialInventory mi on se.FMaterialID = mi.FMaterialID and se.FStorageOrgUnitID = mi.FOrgUnit").append(" left join T_BD_MaterialSales ms on se.FMaterialID = ms.FMaterialID and sr.FSaleOrgUnitID = ms.FOrgUnit").append(" where sr.FID ='").append(id).append("' and sr.FIsCentralBalance = 1 and se.FIsBetweenCompanySend = 1 ");
            String centralBalanceSQL = sql.toString();
            sql.setLength(0);
            sql.append("select sr.fid id,se.fid entryid,sr.FBizDate bizDate,sr.FSaleOrgUnitID saleOrgUntiID,se.FCompanyOrgUnitID companyOrgUntiID,sr.FCurrencyID currencyid,se.FMaterialID materialid,se.FUnitID unitid,se.FBaseUnitID baseUnitID,se.FAssistPropertyID assistProperyID,cus.fid customerid,se.FQty qty,se.FTaxRate taxrate,se.FPrice price,-1 discounttype,0.0000 discount,se.FTaxRate actualprice,se.FTaxPrice actualtaxprice,se.FTaxPrice taxprice ,material.FPricePrecision priceprecision ,mi.FCheapRate cheapRate,com.FBASECURRENCYID basecurrency ").append("  from T_SD_SaleReturns sr ").append(" inner join T_SD_SaleReturnsEntry se on se.FParentID = sr.FID ").append(" inner join T_ORG_COMPANY  com on sr.FCOMPANYORGUNITID = com.fid ").append(" inner join T_BD_Customer cus on cus.FInternalCompanyID = sr.FBalanceCompanyOrgUnitID  and cus.fusedstatus = 1").append(" inner join T_BD_Material material on se.FMaterialID = material.FID ").append(" inner join T_BD_MaterialInventory mi on se.FMaterialID = mi.FMaterialID and se.FStorageOrgUnitID = mi.FOrgUnit").append(" where sr.FID ='").append(id).append("' and sr.FIsCentralBalance = 1 and sr.FIsSquareBalance = 1 and se.FIsBetweenCompanySend = 1 ");
            String squareBalanceSQL1 = sql.toString();
            sql.setLength(0);
            sql.append("select sr.fid id,se.fid entryid,sr.FBizDate bizDate,sr.FSaleOrgUnitID saleOrgUntiID,sr.FBalanceCompanyOrgUnitID companyOrgUntiID,sr.FCurrencyID currencyid,se.FMaterialID materialid,se.FUnitID unitid,se.FBaseUnitID baseUnitID,se.FAssistPropertyID assistProperyID,cus.fid customerid,se.FQty qty,se.FTaxRate taxrate,se.FPrice price,-1 discounttype,0.0000 discount,se.FTaxRate actualprice,se.FTaxPrice actualtaxprice,se.FTaxPrice taxprice ,material.FPricePrecision priceprecision ,mi.FCheapRate cheapRate,com.FBASECURRENCYID basecurrency ").append("  from T_SD_SaleReturns sr ").append(" inner join T_SD_SaleReturnsEntry se on se.FParentID = sr.FID ").append(" inner join T_ORG_COMPANY  com on sr.FCOMPANYORGUNITID = com.fid ").append(" inner join T_BD_Customer cus on cus.FInternalCompanyID = sr.FCompanyOrgUnitID  and cus.fusedstatus = 1").append(" inner join T_BD_Material material on se.FMaterialID = material.FID ").append(" inner join T_BD_MaterialInventory mi on se.FMaterialID = mi.FMaterialID and se.FStorageOrgUnitID = mi.FOrgUnit").append(" where sr.FID ='").append(id).append("' and sr.FIsCentralBalance = 1 and sr.FIsSquareBalance = 1 and se.FIsBetweenCompanySend = 1 ");
            String squareBalanceSQL2 = sql.toString();
            DbUtil.execute((Context)ctx, (String)(" delete from T_SD_SaleReturnInnerDealPrice where FSaleRetrunID ='" + id + "'"));
            verifyResult = DbUtil.executeQuery((Context)ctx, (String)verifySQL.toString());
            if (verifyResult.next()) {
                squareBalanceResult1 = DbUtil.executeQuery((Context)ctx, (String)squareBalanceSQL1);
                this.processSaleReturnInnerDealPrice(ctx, (ResultSet)squareBalanceResult1, true);
                squareBalanceResult2 = DbUtil.executeQuery((Context)ctx, (String)squareBalanceSQL2);
                this.processSaleReturnInnerDealPrice(ctx, (ResultSet)squareBalanceResult2, true);
            }
            if ((verifyResult = DbUtil.executeQuery((Context)ctx, (String)verifyCentralSQL)).next()) {
                centralBalanceResult = DbUtil.executeQuery((Context)ctx, (String)centralBalanceSQL);
                this.processSaleReturnInnerDealPrice(ctx, (ResultSet)centralBalanceResult, false);
            }
        }
        catch (SQLException er) {
            try {
                throw new BOSException("sql Execute Error :", (Throwable)er);
                catch (BOSException e) {
                    throw new BOSException((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(verifyResult);
                SQLUtils.cleanup(centralBalanceResult);
                SQLUtils.cleanup(squareBalanceResult1);
                SQLUtils.cleanup(squareBalanceResult2);
                SQLUtils.cleanup((Statement)statement, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)verifyResult);
        SQLUtils.cleanup((ResultSet)centralBalanceResult);
        SQLUtils.cleanup((ResultSet)squareBalanceResult1);
        SQLUtils.cleanup((ResultSet)squareBalanceResult2);
        SQLUtils.cleanup((Statement)statement, (Connection)con);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processSaleReturnInnerDealPrice(Context ctx, ResultSet result, boolean flag) throws BOSException, EASBizException {
        Connection con = null;
        Statement batchStatement = null;
        Statement paramStatement = null;
        try {
            con = SCMBizProcessorUtil.getConnection((Context)ctx);
            batchStatement = con.createStatement();
            paramStatement = con.createStatement();
            CustomerInfo customerInfo = new CustomerInfo();
            MaterialInfo materialInfo = new MaterialInfo();
            CurrencyInfo currencyInfo = new CurrencyInfo();
            CompanyOrgUnitInfo companyOrgInfo = new CompanyOrgUnitInfo();
            MeasureUnitInfo baseUnitInfo = new MeasureUnitInfo();
            SaleOrgUnitInfo saleOrgInfo = new SaleOrgUnitInfo();
            PriceCondition priceCondition = new PriceCondition();
            IPriceProvider iProvider = PriceProviderFactory.getLocalInstance((Context)ctx);
            IPriceParam iPriceParam = PriceParamFactory.getLocalInstance((Context)ctx);
            Calendar cal = Calendar.getInstance();
            Timestamp ts = new Timestamp(cal.getTimeInMillis());
            StringBuffer insertStr = new StringBuffer();
            BigDecimal HUNDRED_NUM = new BigDecimal("100");
            BigDecimal ONE_NUM = new BigDecimal("1.0");
            BigDecimal DEFAULT_NUM = new BigDecimal("0.0");
            boolean isControlSaleInnerPrice = false;
            int resultCount = 0;
            while (result.next()) {
                block52: {
                    BigDecimal price;
                    BigDecimal actualPrice;
                    BigDecimal actualTaxPrice;
                    BigDecimal taxrate;
                    BigDecimal discountValue;
                    BigDecimal dPriceValue;
                    block53: {
                        String sourceBillTypeID;
                        if (!flag && !StringUtil.isEmptyString((String)(sourceBillTypeID = result.getString("sourcebilltypeid"))) && "510b6503-0105-1000-e000-0113c0a812fd463ED552".equalsIgnoreCase(sourceBillTypeID)) {
                            this.fatchSourceEntryInnerDealPrice(ctx, result);
                            continue;
                        }
                        int precision = result.getInt("priceprecision");
                        customerInfo.setId(BOSUuid.read((String)result.getString("customerid")));
                        priceCondition.setCustomerInfo(customerInfo);
                        materialInfo.setId(BOSUuid.read((String)result.getString("materialid")));
                        baseUnitInfo.setId(BOSUuid.read((String)result.getString("baseUnitID")));
                        materialInfo.setBaseUnit(baseUnitInfo);
                        priceCondition.setMaterialInfo(materialInfo);
                        priceCondition.setMeasureUnit(result.getString("unitid"));
                        companyOrgInfo.setId(BOSUuid.read((String)result.getString("companyOrgUntiID")));
                        priceCondition.setCompanyOrg(companyOrgInfo);
                        saleOrgInfo.setId(BOSUuid.read((String)result.getString("saleOrgUntiID")));
                        priceCondition.setSaleOrg(saleOrgInfo);
                        priceCondition.setOrderQty(result.getBigDecimal("qty"));
                        currencyInfo.setId(BOSUuid.read((String)result.getString("basecurrency")));
                        priceCondition.setCurrencyInfo(currencyInfo);
                        priceCondition.setCurDate(result.getDate("bizDate") != null ? result.getDate("bizDate") : ts);
                        priceCondition.setPriceTypeID("00000000-0000-0000-0000-0000000000036A61CE8D");
                        if (!StringUtils.isEmpty((String)result.getString("assistProperyID"))) {
                            AsstAttrValueInfo asstAttrValueInfo = new AsstAttrValueInfo();
                            asstAttrValueInfo.setId(BOSUuid.read((String)result.getString("assistProperyID")));
                            priceCondition.setAssiProperty(asstAttrValueInfo);
                        }
                        List[] priceLists = iProvider.getPrices(new PriceCondition[]{priceCondition});
                        insertStr.delete(0, insertStr.length());
                        insertStr.append(" insert T_SD_SaleReturnInnerDealPrice(FID,FSaleRetrunID,FSaleRetrunEntryID,FCompanyOrgUnitID,FPrice,FDiscountMode,FDiscount,FActualPrice ,FTaxRate,FTaxPrice,FActualTaxPrice)");
                        dPriceValue = DEFAULT_NUM.setScale(precision, 4);
                        discountValue = DEFAULT_NUM.setScale(precision, 4);
                        taxrate = DEFAULT_NUM.setScale(precision, 4);
                        actualTaxPrice = DEFAULT_NUM.setScale(precision, 4);
                        actualPrice = DEFAULT_NUM.setScale(precision, 4);
                        price = DEFAULT_NUM.setScale(precision, 4);
                        BigDecimal cheapRate = DEFAULT_NUM.setScale(precision, 4);
                        insertStr.append(" values(newbosid('").append("21AFFF6B'),'" + result.getString("id") + "','" + result.getString("entryid") + "'");
                        if (flag) {
                            insertStr.append(",'" + result.getString("companyOrgUntiID") + "'");
                        } else {
                            insertStr.append(",''");
                        }
                        if (resultCount == 0) {
                            ++resultCount;
                            PriceParamInfo parameter = iPriceParam.getParameterInfo(result.getString("saleOrgUntiID"));
                            isControlSaleInnerPrice = parameter.getBoolValue("PricePa023");
                        }
                        if (isControlSaleInnerPrice && !flag) {
                            int priceprecision2 = result.getInt("priceprecision");
                            discountValue = result.getBigDecimal("discount").unscaledValue().intValue() == 0 ? DEFAULT_NUM : result.getBigDecimal("discount");
                            taxrate = result.getBigDecimal("taxrate").unscaledValue().intValue() == 0 ? DEFAULT_NUM : result.getBigDecimal("taxrate");
                            cheapRate = result.getBigDecimal("secheaprate");
                            if (result.getBigDecimal("taxprice").unscaledValue().intValue() == 0) {
                                price = DEFAULT_NUM;
                            } else {
                                price = result.getBigDecimal("taxprice");
                                if (cheapRate.unscaledValue().intValue() != 0 && (price = price.multiply(ONE_NUM.subtract(cheapRate.divide(HUNDRED_NUM, priceprecision2, 4)))).unscaledValue().intValue() == 0) {
                                    price = DEFAULT_NUM;
                                }
                            }
                            if (result.getBigDecimal("actualtaxprice").unscaledValue().intValue() == 0) {
                                actualTaxPrice = DEFAULT_NUM;
                            } else {
                                actualTaxPrice = result.getBigDecimal("actualtaxprice");
                                if (cheapRate.unscaledValue().intValue() != 0 && (actualTaxPrice = actualTaxPrice.multiply(ONE_NUM.subtract(cheapRate.divide(HUNDRED_NUM, priceprecision2, 4)))).unscaledValue().intValue() == 0) {
                                    actualTaxPrice = DEFAULT_NUM;
                                }
                            }
                            dPriceValue = price.divide(ONE_NUM.add(taxrate.divide(HUNDRED_NUM, priceprecision2, 4)), priceprecision2, 4);
                            if (dPriceValue.unscaledValue().intValue() == 0) {
                                dPriceValue = DEFAULT_NUM;
                            }
                            actualPrice = dPriceValue;
                            insertStr.append("," + dPriceValue.toPlainString() + "," + result.getInt("discounttype") + "," + discountValue.toPlainString()).append("," + actualPrice.toPlainString() + "," + taxrate.toPlainString() + "," + price.toPlainString()).append("," + actualTaxPrice.toPlainString() + ")");
                            batchStatement.addBatch(insertStr.toString());
                            continue;
                        }
                        PriceParamInfo priceparamInfo = null;
                        SalePriceTO priceTo = null;
                        if (priceLists != null && priceLists.length > 0 && priceLists[0] != null) {
                            List priceToList = priceLists[0];
                            priceTo = (SalePriceTO)priceToList.get(0);
                        }
                        if (priceTo == null) break block53;
                        int priceprecision = result.getInt("priceprecision");
                        if (priceTo.priceType != null && priceTo.priceType.equals("basePrice")) {
                            BigDecimal transferRate;
                            OrgUnitCollection orgUnitCollection = SCMGroupServerUtils.getOrgsByRelation((Context)ctx, (OrgType)OrgType.Company, (OrgType)OrgType.Sale, (String)priceCondition.getCompanyOrg().getId().toString());
                            int c = orgUnitCollection.size();
                            for (int i = 0; i < c; ++i) {
                                String cuid = orgUnitCollection.get(i).getId().toString();
                                PriceParamInfo tempInfo = iPriceParam.getParameter(cuid);
                                if (!tempInfo.isStartPriceDiscountM()) continue;
                                priceparamInfo = tempInfo;
                                break;
                            }
                            BigDecimal bigDecimal = dPriceValue = priceTo.price != null ? priceTo.price : SCMConstant.BIGDECIMAL_ZERO;
                            if (dPriceValue.unscaledValue().intValue() == 0) {
                                dPriceValue = DEFAULT_NUM;
                            }
                            String discountMode = priceTo.discountMode != null ? String.valueOf(priceTo.discountMode) : "0";
                            BigDecimal bigDecimal2 = discountValue = priceTo.discountValue != null ? priceTo.discountValue : DEFAULT_NUM;
                            if (discountValue.unscaledValue().intValue() == 0) {
                                discountValue = DEFAULT_NUM;
                            }
                            if (result.getBigDecimal("taxrate").unscaledValue().intValue() != 0) {
                                taxrate = result.getBigDecimal("taxrate");
                            }
                            BigDecimal transferTaxRate = taxrate.divide(HUNDRED_NUM, 10, 4).add(ONE_NUM);
                            if (priceparamInfo != null && priceparamInfo.isContainTax()) {
                                price = dPriceValue.divide(transferTaxRate, priceprecision, 4);
                                if (discountMode.equals("0")) {
                                    transferRate = HUNDRED_NUM.subtract(discountValue).divide(HUNDRED_NUM, 10, 4);
                                    actualPrice = price.multiply(transferRate).setScale(priceprecision, 4);
                                    actualTaxPrice = dPriceValue.multiply(transferRate).setScale(priceprecision, 4);
                                } else if (discountMode.equals("1")) {
                                    actualPrice = price.subtract(discountValue.divide(transferTaxRate, priceprecision, 4));
                                    actualTaxPrice = dPriceValue.subtract(discountValue.divide(transferTaxRate, priceprecision, 4));
                                } else {
                                    actualPrice = price;
                                    actualTaxPrice = dPriceValue;
                                }
                                insertStr.append("," + price.toPlainString() + "," + discountMode + "," + discountValue.toPlainString()).append("," + actualPrice.toPlainString() + "," + taxrate.toPlainString() + "," + dPriceValue.toPlainString()).append("," + actualTaxPrice.toPlainString() + ")");
                                break block52;
                            } else {
                                price = dPriceValue.multiply(transferTaxRate).setScale(priceprecision, 4);
                                if (discountMode.equals("0")) {
                                    transferRate = HUNDRED_NUM.subtract(discountValue).divide(HUNDRED_NUM, 10, 4);
                                    actualPrice = dPriceValue.multiply(transferRate).setScale(priceprecision, 4);
                                    actualTaxPrice = price.multiply(transferRate).setScale(priceprecision, 4);
                                } else if (discountMode.equals("1")) {
                                    actualPrice = dPriceValue.subtract(discountValue.divide(transferTaxRate, priceprecision, 4));
                                    actualTaxPrice = price.subtract(discountValue.divide(transferTaxRate, priceprecision, 4));
                                } else {
                                    actualPrice = dPriceValue;
                                    actualTaxPrice = price;
                                }
                                insertStr.append("," + dPriceValue.toPlainString() + "," + discountMode + "," + discountValue.toPlainString()).append("," + actualPrice.toPlainString() + "," + taxrate.toPlainString() + "," + price.toPlainString()).append("," + actualTaxPrice.toPlainString() + ")");
                            }
                            break block52;
                        } else {
                            BigDecimal transferRate2;
                            priceparamInfo = iPriceParam.getParameter(priceTo.saleOrgUniID);
                            BigDecimal bigDecimal = dPriceValue = priceTo.price != null ? priceTo.price : SCMConstant.BIGDECIMAL_ZERO;
                            if (dPriceValue.unscaledValue().intValue() == 0) {
                                dPriceValue = DEFAULT_NUM;
                            }
                            String discountMode = String.valueOf(priceTo.discountMode);
                            BigDecimal bigDecimal3 = discountValue = priceTo.discountValue != null ? priceTo.discountValue : DEFAULT_NUM;
                            if (discountValue.unscaledValue().intValue() == 0) {
                                discountValue = DEFAULT_NUM;
                            }
                            if (result.getBigDecimal("taxrate").unscaledValue().intValue() != 0) {
                                taxrate = result.getBigDecimal("taxrate");
                            }
                            BigDecimal transferTaxRate = taxrate.divide(HUNDRED_NUM, 10, 4).add(ONE_NUM);
                            if (priceparamInfo.isContainTax()) {
                                price = dPriceValue.divide(transferTaxRate, priceprecision, 4);
                                if (discountMode.equals("0")) {
                                    transferRate2 = HUNDRED_NUM.subtract(discountValue).divide(HUNDRED_NUM, 10, 4);
                                    actualPrice = price.multiply(transferRate2).setScale(priceprecision, 4);
                                    actualTaxPrice = dPriceValue.multiply(transferRate2).setScale(priceprecision, 4);
                                } else if (discountMode.equals("1")) {
                                    actualPrice = price.subtract(discountValue.divide(transferTaxRate, priceprecision, 4));
                                    actualTaxPrice = dPriceValue.subtract(discountValue.divide(transferTaxRate, priceprecision, 4));
                                } else {
                                    actualPrice = price;
                                    actualTaxPrice = dPriceValue;
                                }
                                insertStr.append("," + price.toPlainString() + "," + discountMode + "," + discountValue.toPlainString()).append("," + actualPrice.toPlainString() + "," + taxrate.toPlainString() + "," + dPriceValue).append("," + actualTaxPrice.toPlainString() + ")");
                                break block52;
                            } else {
                                price = dPriceValue.multiply(transferTaxRate).setScale(priceprecision, 4);
                                if (discountMode.equals("0")) {
                                    transferRate2 = HUNDRED_NUM.subtract(discountValue).divide(HUNDRED_NUM, 10, 4);
                                    actualPrice = dPriceValue.multiply(transferRate2).setScale(priceprecision, 4);
                                    actualTaxPrice = price.multiply(transferRate2).setScale(priceprecision, 4);
                                } else if (discountMode.equals("1")) {
                                    actualPrice = dPriceValue.subtract(discountValue.divide(transferTaxRate, priceprecision, 4));
                                    actualTaxPrice = price.subtract(discountValue.divide(transferTaxRate, priceprecision, 4));
                                } else {
                                    actualPrice = dPriceValue;
                                    actualTaxPrice = price;
                                }
                                insertStr.append("," + dPriceValue.toPlainString() + "," + discountMode + "," + discountValue.toPlainString()).append("," + actualPrice.toPlainString() + "," + taxrate.toPlainString() + "," + price.toPlainString()).append("," + actualTaxPrice.toPlainString() + ")");
                            }
                        }
                        break block52;
                    }
                    dPriceValue = result.getBigDecimal("price").unscaledValue().intValue() == 0 ? DEFAULT_NUM : result.getBigDecimal("price");
                    discountValue = result.getBigDecimal("discount").unscaledValue().intValue() == 0 ? DEFAULT_NUM : result.getBigDecimal("discount");
                    actualPrice = result.getBigDecimal("actualprice").unscaledValue().intValue() == 0 ? DEFAULT_NUM : result.getBigDecimal("actualprice");
                    taxrate = result.getBigDecimal("taxrate").unscaledValue().intValue() == 0 ? DEFAULT_NUM : result.getBigDecimal("taxrate");
                    price = result.getBigDecimal("taxprice").unscaledValue().intValue() == 0 ? DEFAULT_NUM : result.getBigDecimal("taxprice");
                    actualTaxPrice = result.getBigDecimal("actualtaxprice").unscaledValue().intValue() == 0 ? DEFAULT_NUM : result.getBigDecimal("actualtaxprice");
                    insertStr.append("," + dPriceValue.toPlainString() + "," + result.getInt("discounttype") + "," + discountValue.toPlainString()).append("," + actualPrice.toPlainString() + "," + taxrate.toPlainString() + "," + price.toPlainString()).append("," + actualTaxPrice.toPlainString() + ")");
                }
                batchStatement.addBatch(insertStr.toString());
            }
            batchStatement.executeBatch();
        }
        catch (SQLException er) {
            try {
                throw new BOSException("sql Execute Error :", (Throwable)er);
                catch (PricePolicyException e) {
                    throw new BOSException((Throwable)e);
                }
                catch (BOSException e) {
                    throw new BOSException((Throwable)e);
                }
                catch (PriceParamException e) {
                    throw new BOSException((Throwable)e);
                }
                catch (EASBizException e) {
                    throw new BOSException((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(batchStatement, (Connection)con);
                SQLUtils.cleanup(paramStatement, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)batchStatement, (Connection)con);
        SQLUtils.cleanup((Statement)paramStatement, (Connection)con);
    }

    private void fatchSourceEntryInnerDealPrice(Context ctx, ResultSet result) throws BOSException, EASBizException {
        BigDecimal DEFAULT_NUM = new BigDecimal("0");
        try {
            String sourceBillEntryID = result.getString("sourcebillentryid");
            String sourceBillID = result.getString("sourcebillid");
            ISaleInnerDealPrice iPriceFactory = SaleInnerDealPriceFactory.getLocalInstance((Context)ctx);
            SaleInnerDealPriceInfo saleInnerDealPriceInfo = iPriceFactory.getInnerDealPrice(sourceBillID, sourceBillEntryID);
            if (saleInnerDealPriceInfo == null) {
                return;
            }
            BigDecimal price = saleInnerDealPriceInfo.getPrice();
            BigDecimal discount = saleInnerDealPriceInfo.getDiscount();
            BigDecimal actualPrice = saleInnerDealPriceInfo.getActualPrice();
            BigDecimal taxRate = saleInnerDealPriceInfo.getTaxRate();
            BigDecimal taxPrice = saleInnerDealPriceInfo.getTaxPrice();
            BigDecimal actualTaxPrice = saleInnerDealPriceInfo.getActualTaxPrice();
            int discountMode = saleInnerDealPriceInfo.getDiscountMode().getValue();
            if (price.compareTo(DEFAULT_NUM) == 0) {
                price = DEFAULT_NUM;
            }
            if (discount.compareTo(DEFAULT_NUM) == 0) {
                discount = DEFAULT_NUM;
            }
            if (actualPrice.compareTo(DEFAULT_NUM) == 0) {
                actualPrice = DEFAULT_NUM;
            }
            if (taxRate.compareTo(DEFAULT_NUM) == 0) {
                taxRate = DEFAULT_NUM;
            }
            if (taxPrice.compareTo(DEFAULT_NUM) == 0) {
                taxPrice = DEFAULT_NUM;
            }
            if (actualTaxPrice.compareTo(DEFAULT_NUM) == 0) {
                actualTaxPrice = DEFAULT_NUM;
            }
            StringBuffer insertStr = new StringBuffer();
            insertStr.append(" insert T_SD_SaleReturnInnerDealPrice(FID,FSaleRetrunID,FSaleRetrunEntryID,FCompanyOrgUnitID,FPrice,FDiscountMode,FDiscount,FActualPrice ,FTaxRate,FTaxPrice,FActualTaxPrice)");
            insertStr.append(" values(newbosid('").append("21AFFF6B'),'" + result.getString("id") + "','" + result.getString("entryid") + "',");
            insertStr.append("'',");
            insertStr.append(price + "," + discountMode + "," + discount + "," + actualPrice + "," + taxRate + "," + taxPrice + "," + actualTaxPrice).append(")");
            DbUtil.execute((Context)ctx, (String)insertStr.toString());
        }
        catch (SQLException e) {
            throw new BOSException("sql Execute Error :", (Throwable)e);
        }
    }
}

