/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.app.bizprocess.processor.salereturns;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.ProcessorExecutionModeEnum;
import com.kingdee.eas.dynbusiness.TransactionModeEnum;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.sd.sale.SaleReturnsEntryCollection;
import com.kingdee.eas.scm.sd.sale.SaleReturnsEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleReturnsException;
import com.kingdee.eas.scm.sd.sale.SaleReturnsFactory;
import com.kingdee.eas.scm.sd.sale.SaleReturnsInfo;
import java.sql.Timestamp;

public class SaleReturnsUpdateData4AuditProcessor
extends AbstractBusinessProcessor {
    public SaleReturnsUpdateData4AuditProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public SaleReturnsUpdateData4AuditProcessor(ExecuteContext executeContext, ProcessorExecutionModeEnum executeMode, Conditions conditions, TransactionModeEnum transactionMode) {
        super(executeContext, executeMode, conditions, transactionMode);
    }

    public SaleReturnsUpdateData4AuditProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectCollection col = batchResults.getObjCollection();
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            IObjectValue model = col.getObject(i);
            this.updateData(model);
        }
    }

    private void updateData(IObjectValue model) throws BOSException, EASBizException {
        SaleReturnsInfo info = (SaleReturnsInfo)model;
        UserInfo user = (UserInfo)this.ctx.get((Object)"UserInfo");
        SaleReturnsEntryCollection entryCol = null;
        if (info.getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED)) {
            info.setBaseStatus(BillBaseStatusEnum.AUDITED);
            info.setAuditor(user);
            info.setAuditTime(new Timestamp(System.currentTimeMillis()));
            entryCol = info.getEntries();
            if (entryCol != null) {
                int size = entryCol.size();
                for (int j = 0; j < size; ++j) {
                    SaleReturnsEntryInfo entryInfo = entryCol.get(j);
                    entryInfo.setBaseStatus(EntryBaseStatusEnum.AUDITED);
                    if (entryInfo.getCoreBillId() != null && !"7eD9TwIyTMmt7ELiDSC65CQHQ1w=".equals(info.getBizType()) && !entryInfo.getCoreBillId().toString().equals(info.getId().toString())) continue;
                    entryInfo.setCoreBillType(info.getBillType());
                    entryInfo.setCoreBillId(info.getId().toString());
                    entryInfo.setCoreBillNumber(info.getNumber());
                    entryInfo.setCoreBillEntryId(entryInfo.getId().toString());
                    entryInfo.setCoreBillEntrySeq(entryInfo.getSeq());
                }
            }
        } else {
            throw new SaleReturnsException(SaleReturnsException.STATECANNOTAUDIT);
        }
        SaleReturnsFactory.getLocalInstance((Context)this.ctx).update((IObjectPK)new ObjectUuidPK(info.getId().toString()), (CoreBaseInfo)info);
    }
}

