/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.sm.pur.SettlementRouteCollection;
import com.kingdee.eas.scm.sm.pur.SettlementRouteEntryCollection;
import com.kingdee.eas.scm.sm.pur.SettlementRouteEntryInfo;
import com.kingdee.eas.scm.sm.pur.SettlementRouteFactory;
import com.kingdee.eas.scm.sm.pur.SettlementRouteInfo;
import java.util.HashMap;

public class SettlementSteps {
    private String orderID;
    private SettlementRouteInfo routeInfo;
    private HashMap settlementSteps;
    private HashMap ordersSettlementStepsMap;

    public HashMap getOrdersSettlementStepsMap() {
        return this.ordersSettlementStepsMap;
    }

    public SettlementSteps(Context ctx, String purOrderID) throws EASBizException, BOSException {
        this.orderID = purOrderID;
        this.routeInfo = SettlementRouteFactory.getLocalInstance(ctx).getRouteByOrderId(purOrderID);
        if (this.routeInfo != null) {
            this.buildSettlementSteps();
        }
    }

    public SettlementSteps(Context ctx, String[] orderIds) throws EASBizException, BOSException {
        SettlementRouteCollection settlementRouteCollection = SettlementRouteFactory.getLocalInstance(ctx).getRouteByOrderIds(orderIds);
        int size = 0;
        if (settlementRouteCollection != null) {
            this.ordersSettlementStepsMap = new HashMap();
            size = settlementRouteCollection.size();
        }
        for (int i = 0; i < size; ++i) {
            this.routeInfo = settlementRouteCollection.get(i);
            this.orderID = this.routeInfo.getPurOrder().getId().toString();
            if (this.routeInfo == null) continue;
            this.buildSettlementSteps();
            this.ordersSettlementStepsMap.put(this.orderID, this.settlementSteps);
        }
    }

    public void initSettlementSteps(String orderid, HashMap initSteps) {
        this.orderID = orderid;
        this.settlementSteps = initSteps;
    }

    public HashMap getSettlementSteps() {
        return this.settlementSteps;
    }

    public int getStepCount() {
        if (this.settlementSteps == null) {
            return 0;
        }
        return this.settlementSteps.size();
    }

    public SimpleSettlementStep getFirstStep() {
        if (this.settlementSteps == null) {
            return null;
        }
        String key = this.orderID + 1;
        return (SimpleSettlementStep)this.settlementSteps.get(key);
    }

    public SimpleSettlementStep getLastStep() {
        if (this.settlementSteps == null) {
            return null;
        }
        String key = this.orderID + this.settlementSteps.size();
        return (SimpleSettlementStep)this.settlementSteps.get(key);
    }

    public SimpleSettlementStep getSettlementStepByLevel(int level) {
        if (this.settlementSteps == null) {
            return null;
        }
        String key = this.orderID + level;
        return (SimpleSettlementStep)this.settlementSteps.get(key);
    }

    private void buildSettlementSteps() {
        SettlementRouteEntryCollection settlementNodeCollection = this.routeInfo.getEntries();
        int size = (settlementNodeCollection = this.orderByLevel(settlementNodeCollection)).size();
        if (size < 2) {
            return;
        }
        this.settlementSteps = new HashMap();
        for (int i = 1; i < size; ++i) {
            SimpleSettlementStep simpleSettlementStep = new SimpleSettlementStep(settlementNodeCollection.get(i - 1), settlementNodeCollection.get(i), i);
            this.settlementSteps.put(this.orderID + i, simpleSettlementStep);
        }
    }

    private SettlementRouteEntryCollection orderByLevel(SettlementRouteEntryCollection settlementNodeCollection) {
        int[] newIndexes = new int[settlementNodeCollection.size()];
        int i = 0;
        int length = settlementNodeCollection.size();
        while (i < length) {
            SettlementRouteEntryInfo settlementRouteEntryInfo = settlementNodeCollection.get(i);
            newIndexes[settlementRouteEntryInfo.getLevel() - 1] = i++;
        }
        SettlementRouteEntryCollection oc = new SettlementRouteEntryCollection();
        for (int i2 = 0; i2 < newIndexes.length; ++i2) {
            oc.appendObject(settlementNodeCollection.getObject(newIndexes[i2]));
        }
        return oc;
    }

    public class SimpleSettlementStep {
        public static final String ARNODE = "ARNODE";
        public static final String APNODE = "APNODE";
        private HashMap settlementStep = new HashMap();
        private int level;
        private boolean isLastStep = false;

        public SimpleSettlementStep(SettlementRouteEntryInfo ar, SettlementRouteEntryInfo ap, int i) {
            this.settlementStep.put(ARNODE, ar);
            this.settlementStep.put(APNODE, ap);
            if (ap != null) {
                this.isLastStep = ap.isIsLeaf();
            }
            this.level = i;
        }

        public int getLevel() {
            return this.level;
        }

        public HashMap getSettlementStep() {
            return this.settlementStep;
        }

        public boolean isLastStep() {
            return this.isLastStep;
        }

        public SettlementRouteEntryInfo getArInfo() {
            if (this.settlementStep == null) {
                return null;
            }
            return (SettlementRouteEntryInfo)this.settlementStep.get(ARNODE);
        }

        public SettlementRouteEntryInfo getApInfo() {
            if (this.settlementStep == null) {
                return null;
            }
            return (SettlementRouteEntryInfo)this.settlementStep.get(APNODE);
        }

        public SimpleSettlementStep getNextStep() {
            if (SettlementSteps.this.settlementSteps == null) {
                return null;
            }
            return (SimpleSettlementStep)SettlementSteps.this.settlementSteps.get(SettlementSteps.this.orderID + (this.level + 1));
        }

        public SimpleSettlementStep getPreviousStep() {
            if (SettlementSteps.this.settlementSteps == null) {
                return null;
            }
            return (SimpleSettlementStep)SettlementSteps.this.settlementSteps.get(SettlementSteps.this.orderID + (this.level - 1));
        }
    }
}

