/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.sql.util.UUTN;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.sm.pur.app.AbstractPurBusinessImpl;
import com.kingdee.eas.scm.sm.pur.util.SQLUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExchangeRateImpl
extends AbstractPurBusinessImpl<Map<String, Integer>> {
    public ExchangeRateImpl(Context ctx, Object param) {
        super(ctx, param);
    }

    @Override
    protected String getBusinessName() throws EASBizException, BOSException {
        return "exchangeRate service";
    }

    @Override
    protected Map<String, Integer> execute() throws EASBizException, BOSException {
        Map<String, Integer> map = null;
        String paramTable = this.createParamTable();
        String resultTable = this.createResultTable();
        try {
            this.insertParam(paramTable);
            this.getTempResult(paramTable, resultTable);
            map = this.getResult(resultTable);
        }
        catch (BOSException e) {
            throw e;
        }
        finally {
            this.releaseTempTable(this.ctx, paramTable);
            this.releaseTempTable(this.ctx, resultTable);
        }
        return map;
    }

    private void insertParam(String tableName) throws BOSException {
        Object[] params = (Object[])this.getParam();
        String companyOrgUnitId = (String)params[0];
        String baseCurrencyId = (String)params[1];
        List currencyIds = (List)params[2];
        String sql = "insert into " + tableName + " (FID, FCompanyOrgUnitId, FBaseCurrencyId, FCurrencyId) \n values (?, ?, ?, ?) ";
        ArrayList<Object[]> sqlParams = new ArrayList<Object[]>();
        for (int i = 0; i < currencyIds.size(); ++i) {
            ArrayList<String> param = new ArrayList<String>();
            param.add(BOSUuid.create((BOSObjectType)new BOSObjectType("12345678")).toString());
            param.add(companyOrgUnitId);
            param.add(baseCurrencyId);
            param.add((String)currencyIds.get(i));
            sqlParams.add(param.toArray());
        }
        SQLUtil.executeBatch(this.ctx, sql.toString(), sqlParams);
    }

    private void getTempResult(String paramTable, String resultTable) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into ").append(resultTable);
        sql.append(" \n (KSQL_SEQ, FID, FCurrencyId, FExchangeRateId, FPrecision) \n");
        sql.append("select newbosid('12345678'), t.FCurrencyId, t3.FID, t2.FPrecision \n");
        sql.append("from ").append(paramTable).append(" t \n");
        sql.append("inner join t_Org_Company t1 on t.FCompanyOrgUnitId = t1.FID \n");
        sql.append("inner join t_bd_exchangeaux t2 on t1.FBaseExgTableId = t2.FExchangeTableId \n");
        sql.append("  and t.FBaseCurrencyId = t2.FTargetCurrencyId  \n");
        sql.append("  and t.FCurrencyId = t2.FSourceCurrencyId \n");
        sql.append("inner join t_bd_exchangerate t3 on t2.FID = t3.FExchangeAuxId \n");
        sql.append("order by t.FCurrencyId asc, t3.FAvailTime desc ");
        DbUtil.execute((Context)this.ctx, (String)sql.toString());
    }

    private Map<String, Integer> getResult(String resultTable) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select FCurrencyId, FPrecision \n");
        sql.append("from ").append(resultTable).append(" \n");
        sql.append("where fid in ( \n");
        sql.append("  select t.FID from ").append(resultTable).append(" t, ").append(resultTable).append(" t1 \n");
        sql.append("  where t.FCurrencyId = t1.FCurrencyId and t.KSQL_SEQ >= t1.KSQL_SEQ \n");
        sql.append("  group by t.FCurrencyId, t.FID having count(*) = 1 \n");
        sql.append(")");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        try {
            while (rs.next()) {
                map.put(rs.getString("FCurrencyId"), rs.getInt("FPrecision"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    private String createParamTable() throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("create table paramTable ( \n");
        sql.append("FID varchar(44) not null, \n");
        sql.append("FCompanyOrgUnitId varchar(44), \n");
        sql.append("FBaseCurrencyId varchar(44), \n");
        sql.append("FCurrencyId varchar(44), \n");
        sql.append("CONSTRAINT ");
        sql.append(new UUTN("ZC").toString());
        sql.append(" PRIMARY KEY (FID) ) ");
        String table = null;
        try {
            table = TempTablePool.getInstance((Context)this.ctx).createTempTable(sql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            this.releaseTempTable(this.ctx, table);
        }
        return table;
    }

    private String createResultTable() throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("create table resultTable ( \n");
        sql.append("KSQL_SEQ INT IDENTITY (1, 1), \n");
        sql.append("FID varchar(44) not null, \n");
        sql.append("FCurrencyId varchar(44), \n");
        sql.append("FExchangeRateId varchar(44), \n");
        sql.append("FPrecision int not null default 0, \n");
        sql.append("CONSTRAINT ");
        sql.append(new UUTN("ZC").toString());
        sql.append(" PRIMARY KEY (FID) ) ");
        String table = null;
        try {
            table = TempTablePool.getInstance((Context)this.ctx).createTempTable(sql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            this.releaseTempTable(this.ctx, table);
        }
        return table;
    }

    public void releaseTempTable(Context ctx, String tempTable) {
        if (tempTable != null) {
            TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
        }
    }
}

