/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.sm.pur.PurContractEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurContractEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurContractFactory;
import com.kingdee.eas.scm.sm.pur.PurContractInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import com.kingdee.eas.scm.sm.pur.app.AbstractPur4budgetFacadeControllerBean;
import com.kingdee.eas.scm.sm.pur.app.PurContractEntryType;
import com.kingdee.eas.scm.sm.pur.app.PurContractType;
import com.kingdee.eas.scm.sm.pur.app.PurObjectEntryType;
import com.kingdee.eas.scm.sm.pur.app.PurObjectType;
import com.kingdee.eas.scm.sm.pur.app.PurOrderEntryType;
import com.kingdee.eas.scm.sm.pur.app.PurOrderType;
import com.kingdee.eas.util.ResourceBase;
import java.util.Locale;
import org.apache.log4j.Logger;

public class Pur4budgetFacadeControllerBean
extends AbstractPur4budgetFacadeControllerBean {
    private static final long serialVersionUID = 6477191766490661120L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sm.pur.app.Pur4budgetFacadeControllerBean");
    private static final String SM_API_001 = "SM_API_001";
    private static final String SM_API_002 = "SM_API_002";
    private static final String RES_PATCH = "com.kingdee.eas.scm.sm.api.Pur4budgetResource";

    @Override
    protected PurObjectType _getPurObjectType(Context ctx, BOSObjectType type, IObjectPK destObjPK, boolean flag) throws BOSException, EASBizException {
        PurOrderType ptype = null;
        if (type.equals((Object)new PurOrderInfo().getBOSType())) {
            logger.debug((Object)"Pur4budgetFacadeControllerBean getPurOrderType");
            ptype = this.getPurOrderType(ctx, destObjPK, flag);
        }
        if (type.equals((Object)new PurContractInfo().getBOSType())) {
            logger.debug((Object)"Pur4budgetFacadeControllerBean getPurContractType");
            ptype = this.getPurContractType(ctx, destObjPK, flag);
        }
        return ptype;
    }

    protected PurOrderType getPurOrderType(Context ctx, IObjectPK destObjPK, boolean flag) throws BOSException, EASBizException {
        PurOrderType ptype = null;
        PurOrderInfo billInfo = PurOrderFactory.getLocalInstance(ctx).getPurOrderInfo(destObjPK, this.getSelector4PurOrder());
        if (this.confirmCondition4PurOrder(flag, billInfo)) {
            ptype = new PurOrderType(this.getBillName(ctx, SM_API_001));
            PurOrderEntryCollection entryColl = billInfo.getEntries();
            PurOrderEntryInfo entryInfo = null;
            if (entryColl != null && entryColl.size() > 0) {
                for (int j = 0; j < entryColl.size(); ++j) {
                    entryInfo = entryColl.get(j);
                    PurOrderEntryType poet = new PurOrderEntryType();
                    poet.setId(entryInfo.getId().toString());
                    poet.setSourceBillEntryId(entryInfo.getSourceBillEntryId());
                    poet.setSourceBillId(entryInfo.getSourceBillId());
                    poet.setAmount(entryInfo.getAmount());
                    ptype.addEntry((PurObjectEntryType)poet);
                }
            }
        }
        return ptype;
    }

    protected PurContractType getPurContractType(Context ctx, IObjectPK destObjPK, boolean flag) throws BOSException, EASBizException {
        PurContractType ptype = null;
        PurContractInfo billInfo = PurContractFactory.getLocalInstance(ctx).getPurContractInfo(destObjPK, this.getSelector4PurContract());
        if (this.confirmCondition4PurContract(flag, billInfo)) {
            ptype = new PurContractType(this.getBillName(ctx, SM_API_002));
            PurContractEntryCollection entryColl = billInfo.getEntries();
            PurContractEntryInfo entryInfo = null;
            if (entryColl != null && entryColl.size() > 0) {
                for (int j = 0; j < entryColl.size(); ++j) {
                    entryInfo = entryColl.get(j);
                    PurContractEntryType pcet = new PurContractEntryType();
                    pcet.setId(entryInfo.getId().toString());
                    pcet.setSourceBillEntryId(entryInfo.getSourceBillEntryId());
                    pcet.setSourceBillId(entryInfo.getSourceBillId());
                    pcet.setAmount(entryInfo.getAmount());
                    ptype.addEntry((PurObjectEntryType)pcet);
                }
            }
        }
        return ptype;
    }

    protected boolean confirmCondition4PurOrder(boolean flag, PurOrderInfo billInfo) {
        return flag || billInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED) || billInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED);
    }

    protected boolean confirmCondition4PurContract(boolean flag, PurContractInfo billInfo) {
        return flag || billInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED) || billInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED);
    }

    protected SelectorItemCollection getSelector4PurOrder() {
        return this.getCommonSelector();
    }

    protected SelectorItemCollection getSelector4PurContract() {
        return this.getCommonSelector();
    }

    protected SelectorItemCollection getCommonSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("baseStatus"));
        sic.add(new SelectorItemInfo("entries.id"));
        sic.add(new SelectorItemInfo("entries.sourceBillId"));
        sic.add(new SelectorItemInfo("entries.sourceBillEntryId"));
        sic.add(new SelectorItemInfo("entries.amount"));
        return sic;
    }

    protected String getBillName(Context ctx, String resourceName) {
        String strTemp = ResourceBase.getString((String)RES_PATCH, (String)resourceName, (Locale)ctx.getOriginLocale());
        if (strTemp.equals("Missing Resource")) {
            return "Missing Resource{" + resourceName + "}";
        }
        return strTemp;
    }
}

