/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.util.ViewParseUtils;
import com.kingdee.bos.sql.dom.expr.SqlExpr;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CashDiscountCollection;
import com.kingdee.eas.basedata.assistant.CashDiscountFactory;
import com.kingdee.eas.basedata.assistant.CashDiscountInfo;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.ICashDiscount;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.IPayCondition;
import com.kingdee.eas.basedata.assistant.ISettlementType;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PayConditionCollection;
import com.kingdee.eas.basedata.assistant.PayConditionFactory;
import com.kingdee.eas.basedata.assistant.PayConditionInfo;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeCollection;
import com.kingdee.eas.basedata.assistant.SettlementTypeFactory;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.IMaterialGroup;
import com.kingdee.eas.basedata.master.material.ManufactureStrategyInfo;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialGroupFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.DeliveryTypeCollection;
import com.kingdee.eas.basedata.scm.common.DeliveryTypeFactory;
import com.kingdee.eas.basedata.scm.common.DeliveryTypeInfo;
import com.kingdee.eas.basedata.scm.common.IDeliveryType;
import com.kingdee.eas.basedata.scm.common.IRowType;
import com.kingdee.eas.basedata.scm.common.RequestOrgTypeEnum;
import com.kingdee.eas.basedata.scm.common.RowBizTypeFactory;
import com.kingdee.eas.basedata.scm.common.RowTypeCollection;
import com.kingdee.eas.basedata.scm.common.RowTypeFactory;
import com.kingdee.eas.basedata.scm.common.RowTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.IWarehouse;
import com.kingdee.eas.basedata.scm.im.inv.SOAccreditWHCollection;
import com.kingdee.eas.basedata.scm.im.inv.SOAccreditWHFactory;
import com.kingdee.eas.basedata.scm.im.inv.SOAccreditWHInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseCollection;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.basedata.scm.sd.sale.ContraceCollection;
import com.kingdee.eas.basedata.scm.sd.sale.ContraceFactory;
import com.kingdee.eas.basedata.scm.sd.sale.ContraceInfo;
import com.kingdee.eas.basedata.scm.sd.sale.ContraceTreeFactory;
import com.kingdee.eas.basedata.scm.sd.sale.ContraceTreeInfo;
import com.kingdee.eas.basedata.scm.sd.sale.IContrace;
import com.kingdee.eas.basedata.scm.sm.pur.PurchaseGroupInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.ProjectCarCollection;
import com.kingdee.eas.mm.project.ProjectCarInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.app.SCMDataImport;
import com.kingdee.eas.scm.common.util.CalculateUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.scm.im.inv.app.ImportDataCache;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.sm.pur.AbstractPurContractInfo;
import com.kingdee.eas.scm.sm.pur.PurContractEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurContractEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurContractFactory;
import com.kingdee.eas.scm.sm.pur.PurContractInfo;
import com.kingdee.eas.scm.sm.pur.PurContractTermCollection;
import com.kingdee.eas.scm.sm.pur.PurContractTermInfo;
import com.kingdee.eas.scm.sm.pur.app.FilterSqlUtils;
import com.kingdee.eas.scm.sm.pur.util.PurUtil;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PurContractDataImport
extends SCMDataImport {
    String[] BIGDECIMAL_FIELDS = new String[]{"FExchangeRate", "FPrepayRate", "FPrepayAmount"};
    String[] BIGDECIMAL_OBJ = new String[]{"exchangeRate", "prepayRate", "prepayAmount"};
    String[] STRING_FIELDS = new String[]{"FDescription", "FDeliveryAddress", "FSignedAddress"};
    String[] STRING_OBJS = new String[]{"description", "deliveryAddress", "signedAddress"};
    String[] DATE_FIELDS = new String[]{"FBizDate", "FEffectedDate"};
    String[] DATE_OBJS = new String[]{"bizDate", "effectedDate"};
    String[] BOOLEAN_FIELDS = new String[]{"FIsInTax"};
    String[] BOOLEAN_OBJS = new String[]{"isInTax"};
    Map paramMap = new HashMap();
    String[] INTEGER_FIELDS = new String[0];
    String[] INTEGER_OBJS = new String[0];
    String[] BIGDECIMAL_FIELDS_EN = new String[]{"FEntries_assistQty", "FEntries_discount", "FEntries_qty", "FEntries_taxRate", "FEntries_amount", "FEntries_actualTaxPrice", "FEntries_tax", "FEntries_taxAmount", "FEntries_discountAmount", "FEntries_receiveOverRate", "FEntries_receiveOwingRate", "FExchangeRate", "FEntries_taxRate", "FEntries_receiveAdvanceDays", "FEntries_receiveDeferralDays", "FEntries_localTax", "FEntries_localTaxAmount", "FEntries_localAmount"};
    String[] BIGDECIMAL_OBJ_EN = new String[]{"assistQty", "discount", "qty", "taxRate", "amount", "actualTaxPrice", "tax", "taxAmount", "discountAmount", "receiveOverRate", "receiveOwingRate", "exchangeRate", "taxRate", "receiveAdvanceDays", "receiveDeferralDays", "localTax", "localTaxAmount", "localAmount"};
    String[] STRING_FIELDS_EN = new String[]{"FEntries_remark", "FEntries_materialName"};
    String[] STRING_OBJS_EN = new String[]{"remark", "materialName"};
    String[] DATE_FIELDS_EN = new String[]{"FEntries_deliveryDate", "FEntries_consignDate"};
    String[] DATE_OBJS_EN = new String[]{"deliveryDate", "consignDate"};
    Map<String, ContraceTreeInfo> contraceTreeInfoMap = new HashMap<String, ContraceTreeInfo>();
    String[] BOOLEAN_FIELDS_EN = new String[]{"FEntries_isPresent", "FEntries_qualityUnCtrl", "FEntries_timeUnCtrl"};
    String[] BOOLEAN_OBJS_EN = new String[]{"isPresent", "qualityUnCtrl", "timeUnCtrl"};
    private BigDecimal zero = new BigDecimal("0.0");
    private BigDecimal totalTaxAmt = new BigDecimal("0.0");
    private int discountRatePrePrecision = 6;
    ImportDataCache dataPool = new ImportDataCache();
    private static final String RESOURCE = "com.kingdee.eas.scm.sm.pur.PurImportExportResource";
    private Map<String, RowTypeInfo> rowTypeMap = new HashMap<String, RowTypeInfo>();
    private Map<String, AdminOrgUnitInfo> adminOrgMap = new HashMap<String, AdminOrgUnitInfo>();
    private Map<String, CurrencyInfo> currencyMap = new HashMap<String, CurrencyInfo>();
    private Map<String, CurrencyInfo> basecurrencyMap = new HashMap<String, CurrencyInfo>();
    private Map<String, CompanyOrgUnitInfo> companyMap = new HashMap<String, CompanyOrgUnitInfo>();
    private Map<String, CompanyOrgUnitInfo> companyBystorageMap = new HashMap<String, CompanyOrgUnitInfo>();
    private Map<String, SettlementTypeInfo> settlementTypeMap = new HashMap<String, SettlementTypeInfo>();
    private Map<String, DeliveryTypeInfo> deliveryTypeMap = new HashMap<String, DeliveryTypeInfo>();
    private Map<String, PayConditionInfo> payConditionMap = new HashMap<String, PayConditionInfo>();
    private Map<String, CashDiscountInfo> cashDiscountMap = new HashMap<String, CashDiscountInfo>();
    private Map<String, PurContractInfo> purContracetMap = new HashMap<String, PurContractInfo>();
    private Map<String, WarehouseInfo> warehouseMap = new HashMap<String, WarehouseInfo>();
    Map<String, String> numberMap = new HashMap<String, String>();
    private static Logger logger = Logger.getLogger(PurContractDataImport.class);
    private static final BigDecimal hundred = BigDecimal.valueOf(100L);

    public ContraceTreeInfo getContraceTreeInfo(String propertyName) {
        return this.contraceTreeInfoMap.get(propertyName);
    }

    public void setContraceTreeInfo(String key, ContraceTreeInfo info) {
        this.contraceTreeInfoMap.put(key, info);
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return PurContractFactory.getLocalInstance(ctx);
        }
        catch (BOSException bex) {
            throw new TaskExternalException("", (Throwable)bex);
        }
    }

    private Object getData(String key, Map lineData) {
        return ((DataToken)lineData.get((Object)key)).data;
    }

    public CoreBaseInfo transmit(Map hsData, Context ctx) throws TaskExternalException {
        TaskExternalException tex = new TaskExternalException("");
        AbstractPurContractInfo purContractInfo = null;
        for (int i = 0; i < hsData.size(); ++i) {
            Map lineData = (Map)hsData.get(new Integer(i));
            if (i == 0) {
                try {
                    purContractInfo = this.transmitHead(lineData, ctx);
                    this.afterBuildHead(ctx, (SCMBillBaseInfo)purContractInfo, lineData);
                    this.doContractTerms((PurContractInfo)purContractInfo, ctx);
                }
                catch (TaskExternalException e) {
                    tex.addEntryErrorReason(i, e.getMessage());
                    this.recycleNumber(ctx, (SCMBillBaseInfo)purContractInfo);
                    break;
                }
                if (purContractInfo == null) {
                    return null;
                }
            }
            PurContractEntryCollection entryCollection = purContractInfo.getEntries();
            PurContractEntryInfo entryInfo = new PurContractEntryInfo();
            entryInfo.setParent((PurContractInfo)purContractInfo);
            try {
                this.handleEntry((PurContractInfo)purContractInfo, entryInfo, lineData, ctx);
            }
            catch (TaskExternalException e) {
                tex.addEntryErrorReason(i, e.getMessage());
                if (tex.getEntryErrorReasons().size() != 1) continue;
                this.recycleNumber(ctx, (SCMBillBaseInfo)purContractInfo);
                continue;
            }
            entryCollection.add(entryInfo);
            this.calEntry((PurContractInfo)purContractInfo, entryInfo);
            entryInfo.setBaseStatus(EntryBaseStatusEnum.TEMPORARILYSAVED);
        }
        if (tex.getEntryErrorReasons().size() > 0) {
            throw tex;
        }
        if (purContractInfo != null) {
            this.checkPrepaymentValid((PurContractInfo)purContractInfo, ctx);
        }
        return purContractInfo;
    }

    private void doContractTerms(PurContractInfo purContractInfo, Context ctx) throws TaskExternalException {
        ContraceTreeInfo info = purContractInfo.getContractType();
        if (info != null) {
            PurContractTermCollection coll = purContractInfo.getTerms();
            if (info != null) {
                try {
                    IContrace contrace = ContraceFactory.getLocalInstance((Context)ctx);
                    EntityViewInfo ev = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    String treeId = info.getId().toString();
                    filter.getFilterItems().add(new FilterItemInfo("treeid", (Object)treeId, CompareType.EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("FStart", (Object)true, CompareType.EQUALS));
                    filter.setMaskString("#0 and #1 ");
                    ev.setFilter(filter);
                    SorterItemCollection sic = ev.getSorter();
                    sic.add(new SorterItemInfo("fseq"));
                    ContraceCollection contraceCollection = contrace.getContraceCollection(ev);
                    ContraceInfo contraceInfo = null;
                    PurContractTermInfo purContractTermInfo = null;
                    int num = contraceCollection.size();
                    for (int i = 0; i < num; ++i) {
                        contraceInfo = (ContraceInfo)contraceCollection.getObject(i);
                        purContractTermInfo = new PurContractTermInfo();
                        purContractTermInfo.setTermContent(contraceInfo.getName());
                        purContractTermInfo.setParent(purContractInfo);
                        coll.add(purContractTermInfo);
                    }
                }
                catch (BOSException e) {
                    throw new TaskExternalException(e.getMessage());
                }
            }
        }
    }

    private void checkPrepaymentValid(PurContractInfo purContractInfo, Context ctx) throws TaskExternalException {
        BigDecimal prepayment = purContractInfo.getPrepayAmount();
        BigDecimal prepaymentRate = purContractInfo.getPrepayRate();
        BigDecimal calPrepayment = BigDecimal.ZERO;
        int currencyPrecision = 2;
        if (purContractInfo.getCurrency() != null) {
            currencyPrecision = purContractInfo.getCurrency().getPrecision();
        }
        if ((calPrepayment = this.totalTaxAmt.multiply(prepaymentRate.multiply(new BigDecimal("0.01"))).setScale(currencyPrecision, 4)).compareTo(prepayment) != 0) {
            BigDecimal rate = BigDecimal.ZERO;
            if (this.totalTaxAmt != null && this.totalTaxAmt.compareTo(BigDecimal.ZERO) > 0) {
                rate = prepayment.divide(this.totalTaxAmt, 4, 1).multiply(new BigDecimal("100")).setScale(2);
            }
            this.totalTaxAmt = BigDecimal.ZERO;
            if (prepaymentRate.compareTo(rate) != 0) {
                this.fail(ctx, "PrepaymentInvalid", new String[]{purContractInfo.getNumber(), prepaymentRate.toString(), rate.toString()});
            }
        }
        this.totalTaxAmt = BigDecimal.ZERO;
    }

    private PurContractInfo transmitHead(Map lineData, Context ctx) throws TaskExternalException {
        PurContractInfo purContractInfo = new PurContractInfo();
        try {
            this.discountRatePrePrecision = Integer.parseInt(ParamManager.getParamValue((Context)ctx, null, (String)"DISCOUNTRATEPRECISION"));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        this.doDecimalFields(ctx, lineData, purContractInfo);
        this.doDateFields(ctx, lineData, purContractInfo);
        this.doBooleanFields(ctx, lineData, purContractInfo);
        this.doStringFields(lineData, purContractInfo);
        this.doIntegerFields(lineData, purContractInfo);
        try {
            this.doPurchaseOrgUnit(purContractInfo, lineData, ctx);
            this.doBiztype(ctx, lineData, purContractInfo);
            this.doPurchaseGroup(ctx, lineData, purContractInfo);
            this.doPurchasePerson(ctx, lineData, purContractInfo);
            this.doSupplier(ctx, lineData, purContractInfo);
            this.doAdminOrgUnit(ctx, lineData, purContractInfo);
            CurrencyInfo localCurrency = this.getLocalCurrency(ctx, purContractInfo);
            this.doCurrcency(ctx, lineData, purContractInfo, localCurrency);
            this.doExchangeRate(ctx, lineData, purContractInfo, localCurrency);
            this.doSettlementType(ctx, lineData, purContractInfo);
            this.doPaymentType(ctx, lineData, purContractInfo);
            this.doDeliveryType(ctx, lineData, purContractInfo);
            this.doPaymentCondition(ctx, lineData, purContractInfo);
            this.doCashDiscount(ctx, lineData, purContractInfo);
            this.doContractType(lineData, ctx, purContractInfo);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage());
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage());
        }
        this.doHeaderDefaultValue(lineData, purContractInfo);
        return purContractInfo;
    }

    public void doContractType(Map lineData, Context ctx, PurContractInfo purContractInfo) throws TaskExternalException {
        Object data = ((DataToken)lineData.get((Object)"FContractType_number")).data;
        if (data != null) {
            String str = data.toString();
            if (str != null && str.length() > 0) {
                ContraceTreeInfo info = this.getContractType(ctx, "number", str);
                purContractInfo.setContractType(info);
            } else {
                throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"CONTRACTTYPE_NOT_NULL", (Context)ctx));
            }
        }
    }

    private void doSupplier(Context ctx, Map lineData, PurContractInfo purContractInfo) throws TaskExternalException {
        Object data = ((DataToken)lineData.get((Object)"FSupplier_number")).data;
        if (null == data || StringUtils.isEmpty((String)data.toString())) {
            this.fail(ctx, "supplierNumberNotNull");
        }
        SupplierInfo suppLierInfo = this.getSupplier(ctx, "number", data);
        this.checkSupplierEnableThrow(ctx, suppLierInfo, data.toString());
        purContractInfo.setSupplier(suppLierInfo);
    }

    protected ContraceTreeInfo getContractType(Context ctx, String propertyName, Object data) throws TaskExternalException {
        CoreBaseCollection coll;
        String key = data.toString().trim();
        ContraceTreeInfo contraceTreeInfo = this.getContraceTreeInfo(key);
        if (contraceTreeInfo != null) {
            return contraceTreeInfo;
        }
        EntityViewInfo view = this.getFilter(key);
        view.setSelector(this.getSelector());
        try {
            coll = ContraceTreeFactory.getLocalInstance((Context)ctx).getCollection(view);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        if (coll == null || coll.size() <= 0 || coll.get(0) == null) {
            throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.sale.SaleUIResource", (String)"CONTRACTTYPE_NOT_NULL", (Context)ctx));
        }
        contraceTreeInfo = (ContraceTreeInfo)coll.get(0);
        this.setContraceTreeInfo(key, contraceTreeInfo);
        return contraceTreeInfo;
    }

    private void doHeaderDefaultValue(Map lineData, PurContractInfo purContractInfo) {
        purContractInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        purContractInfo.setCU(purContractInfo.getPurOrgUnit().getCU());
        BillTypeInfo billtype = new BillTypeInfo();
        billtype.setId(BOSUuid.read((String)"510b6503-0105-1000-e000-010bc0a813fd463ED552"));
        purContractInfo.setBillType(billtype);
    }

    private void doPurchasePerson(Context ctx, Map lineData, PurContractInfo purContractInfo) throws TaskExternalException {
        PurchaseGroupInfo purGourpInfo = purContractInfo.getPurGroup();
        Object data = ((DataToken)lineData.get((Object)"FPurPerson_number")).data;
        PersonInfo purchasePerson = this.getPurchasePerson(ctx, "number", purGourpInfo, data);
        purContractInfo.setPurPerson(purchasePerson);
    }

    private PurchaseGroupInfo doPurchaseGroup(Context ctx, Map lineData, PurContractInfo purContractInfo) throws TaskExternalException {
        Object data = ((DataToken)lineData.get((Object)"FPurGroup_number")).data;
        PurchaseOrgUnitInfo purchaseOrgUnitInfo = purContractInfo.getPurOrgUnit();
        PurchaseGroupInfo purGroupInfo = this.getPurchaseGroup(ctx, "number", purchaseOrgUnitInfo, data, false);
        if (!this.isEmpty(data) && purGroupInfo == null) {
            this.fail(ctx, "PUR_GROUP_NOT_EXISTE_BY_PUR_ORG", new String[]{purchaseOrgUnitInfo.getNumber(), data.toString()});
        }
        purContractInfo.setPurGroup(purGroupInfo);
        return purGroupInfo;
    }

    private void doBiztype(Context ctx, Map lineData, PurContractInfo purContractInfo) throws TaskExternalException {
        Object data = ((DataToken)lineData.get((Object)"FBizType_number")).data;
        BizTypeInfo bizType = this.getBizType(ctx, "510b6503-0105-1000-e000-010bc0a812fd463ED552", "number", data);
        purContractInfo.setBizType(bizType);
    }

    private void doCashDiscount(Context ctx, Map lineData, PurContractInfo purContractInfo) throws BOSException, TaskExternalException {
        Object data = ((DataToken)lineData.get((Object)"FCashDiscount_number")).data;
        if (data != null && !StringUtil.isEmpty((String)data.toString())) {
            String str = data.toString();
            if (this.cashDiscountMap.containsKey(str)) {
                purContractInfo.setCashDiscount(this.cashDiscountMap.get(str));
            } else {
                ICashDiscount iCashDiscount = CashDiscountFactory.getLocalInstance((Context)ctx);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                CashDiscountCollection collection = iCashDiscount.getCashDiscountCollection(this.getFilter(data.toString().trim(), sic));
                if (collection != null && collection.size() > 0) {
                    CashDiscountInfo info = collection.get(0);
                    if (info != null) {
                        purContractInfo.setCashDiscount(info);
                        this.cashDiscountMap.put(str, info);
                    }
                } else {
                    throw new TaskExternalException(str + " " + SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)"CashDiscountNotExists", (Context)ctx));
                }
            }
        }
    }

    private void doPaymentCondition(Context ctx, Map lineData, PurContractInfo purContractInfo) throws BOSException, TaskExternalException {
        Object data = ((DataToken)lineData.get((Object)"FPaymentCondition_number")).data;
        if (data != null && !StringUtil.isEmpty((String)data.toString())) {
            String str = data.toString();
            if (this.payConditionMap.containsKey(str)) {
                purContractInfo.setPaymentCondition(this.payConditionMap.get(str));
                purContractInfo.setPrepayRate(this.payConditionMap.get(str).getPrepayRate());
            } else {
                IPayCondition iPayCondition = PayConditionFactory.getLocalInstance((Context)ctx);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("prepayRate"));
                PayConditionCollection collection = iPayCondition.getPayConditionCollection(this.getFilter(data.toString().trim(), sic));
                if (collection != null && collection.size() > 0) {
                    PayConditionInfo info = collection.get(0);
                    if (info != null) {
                        purContractInfo.setPaymentCondition(info);
                        if (info.getPrepayRate() != null) {
                            purContractInfo.setPrepayRate(info.getPrepayRate());
                            this.payConditionMap.put(str, info);
                        }
                    }
                } else {
                    throw new TaskExternalException(str + " " + SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)"PaymentConditionNotExists", (Context)ctx));
                }
            }
        }
    }

    private void doPaymentType(Context ctx, Map lineData, PurContractInfo purContractInfo) throws TaskExternalException {
        Object data = ((DataToken)lineData.get((Object)"FPaymentType_number")).data;
        if (data != null && !StringUtil.isEmpty((String)data.toString())) {
            PaymentTypeInfo info = this.getPaymentType(ctx, "number", data, null);
            if (null == info) {
                throw new TaskExternalException(data.toString() + " " + SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)"PaymentTypeNotExists", (Context)ctx));
            }
            purContractInfo.setPaymentType(info);
        } else {
            this.fail(ctx, "paymentTypeNotNull");
        }
    }

    private void doDeliveryType(Context ctx, Map lineData, PurContractInfo purContractInfo) throws TaskExternalException, BOSException {
        Object data = ((DataToken)lineData.get((Object)"FDeliveryType_number")).data;
        if (data != null && !StringUtil.isEmpty((String)data.toString())) {
            String str = data.toString();
            if (this.deliveryTypeMap.containsKey(str)) {
                purContractInfo.setDeliveryType(this.deliveryTypeMap.get(str));
            } else {
                IDeliveryType deliveryType = DeliveryTypeFactory.getLocalInstance((Context)ctx);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                DeliveryTypeCollection collection = deliveryType.getDeliveryTypeCollection(this.getFilter(str.trim(), sic));
                if (collection != null && collection.size() > 0) {
                    DeliveryTypeInfo info = collection.get(0);
                    if (info != null) {
                        purContractInfo.setDeliveryType(info);
                        this.deliveryTypeMap.put(str, info);
                    }
                } else {
                    throw new TaskExternalException(str + " " + SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)"DeliveryTypeNotExists", (Context)ctx));
                }
            }
        }
    }

    private void doSettlementType(Context ctx, Map lineData, PurContractInfo purContractInfo) throws BOSException, TaskExternalException {
        Object data = ((DataToken)lineData.get((Object)"FSettlementType_number")).data;
        if (data != null && !StringUtil.isEmpty((String)data.toString())) {
            String str = data.toString();
            if (this.settlementTypeMap.containsKey(str)) {
                purContractInfo.setSettlementType(this.settlementTypeMap.get(str));
            } else {
                ISettlementType isettlementType = SettlementTypeFactory.getLocalInstance((Context)ctx);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                SettlementTypeCollection collection = isettlementType.getSettlementTypeCollection(this.getFilter(str.trim(), sic));
                if (collection != null && collection.size() > 0) {
                    SettlementTypeInfo info = collection.get(0);
                    if (info != null) {
                        purContractInfo.setSettlementType(info);
                        this.settlementTypeMap.put(str, info);
                    }
                } else {
                    throw new TaskExternalException(str + " " + SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)"SettlementTypeNotExists", (Context)ctx));
                }
            }
        }
    }

    private void doExchangeRate(Context ctx, Map lineData, PurContractInfo purContractInfo, CurrencyInfo localCurrency) throws TaskExternalException, EASBizException, BOSException {
        String str = ((DataToken)lineData.get((Object)"FExchangeRate")).data.toString();
        if (purContractInfo.getCurrency().getId().toString().equals(localCurrency.getId().toString())) {
            purContractInfo.setExchangeRate(BigDecimal.ONE);
        } else {
            try {
                if (StringUtil.isEmpty((String)str) || new BigDecimal(str).compareTo(BigDecimal.ZERO) == 0) {
                    throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)"ExchangeRateNotExists", (Context)ctx));
                }
                ExchangeRateInfo exchangeRateInfo = this.getExchangeRate(ctx, purContractInfo.getCompanyOrgUnit(), (IObjectPK)new ObjectUuidPK(localCurrency.getId().toString()), (IObjectPK)new ObjectUuidPK(purContractInfo.getCurrency().getId().toString()));
                int precision = purContractInfo.getCurrency().getPrecision();
                if (exchangeRateInfo != null) {
                    purContractInfo.setConvertMode(exchangeRateInfo.getConvertMode());
                    precision = exchangeRateInfo.getPrecision();
                }
                purContractInfo.setExchangeRate(new BigDecimal(str).setScale(precision, RoundingMode.HALF_UP));
            }
            catch (NumberFormatException e) {
                this.fail(ctx, "invalidBigDecimalFormat");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doCurrcency(Context ctx, Map lineData, PurContractInfo purContractInfo, CurrencyInfo localCurrency) throws BOSException, TaskExternalException {
        Object data = ((DataToken)lineData.get((Object)"FCurrency_number")).data;
        if (data != null && !StringUtil.isEmpty((String)data.toString())) {
            String str = data.toString();
            if (str != null && str.length() > 0) {
                if (this.currencyMap.containsKey(str)) {
                    purContractInfo.setCurrency(this.currencyMap.get(str));
                    return;
                } else {
                    ICurrency icurrency = CurrencyFactory.getLocalInstance((Context)ctx);
                    CurrencyCollection collection = icurrency.getCurrencyCollection(this.getFilter(data.toString().trim()));
                    if (collection == null || collection.size() <= 0) throw new TaskExternalException(str + " " + SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)"CurrencyNotExists", (Context)ctx));
                    CurrencyInfo info = collection.get(0);
                    if (info == null) return;
                    purContractInfo.setCurrency(info);
                    this.currencyMap.put(str, info);
                }
                return;
            } else {
                purContractInfo.setCurrency(localCurrency);
                purContractInfo.setExchangeRate(BigDecimal.ONE);
            }
            return;
        } else {
            purContractInfo.setCurrency(localCurrency);
            purContractInfo.setExchangeRate(BigDecimal.ONE);
        }
    }

    private CurrencyInfo getLocalCurrency(Context ctx, PurContractInfo purContractInfo) throws BOSException {
        CurrencyInfo localCurrency = null;
        CompanyOrgUnitInfo comInfo = null;
        PurchaseOrgUnitInfo purInfo = purContractInfo.getPurOrgUnit();
        if (purInfo != null) {
            if (this.basecurrencyMap.containsKey(purInfo.getId().toString())) {
                localCurrency = this.basecurrencyMap.get(purInfo.getId().toString());
                comInfo = this.companyMap.get(purInfo.getId().toString());
                purContractInfo.setCompanyOrgUnit(comInfo);
            } else {
                EntityViewInfo ev = new EntityViewInfo();
                FilterInfo fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("fromUnit.id", (Object)purInfo.getId().toString()));
                fi.getFilterItems().add(new FilterItemInfo("typeRelation.fromType", (Object)3));
                fi.getFilterItems().add(new FilterItemInfo("typeRelation.toType", (Object)1));
                ev.setFilter(fi);
                IOrgUnitRelation iRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
                OrgUnitRelationCollection relationCol = iRelation.getOrgUnitRelationCollection(ev);
                if (relationCol != null && relationCol.size() > 0) {
                    String toUnitId = relationCol.get(0).getToUnit().getId().toString();
                    ev = new EntityViewInfo();
                    fi = new FilterInfo();
                    fi.getFilterItems().add(new FilterItemInfo("id", (Object)toUnitId));
                    SelectorItemCollection si = new SelectorItemCollection();
                    si.add(new SelectorItemInfo("id"));
                    si.add(new SelectorItemInfo("baseCurrency.*"));
                    ev.setFilter(fi);
                    ev.setSelector(si);
                    ICompanyOrgUnit icom = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
                    CompanyOrgUnitCollection comCol = icom.getCompanyOrgUnitCollection(ev);
                    if (comCol != null && comCol.size() > 0) {
                        comInfo = comCol.get(0);
                        localCurrency = comInfo.getBaseCurrency();
                        this.basecurrencyMap.put(purInfo.getId().toString(), localCurrency);
                        this.companyMap.put(purInfo.getId().toString(), comInfo);
                        purContractInfo.setCompanyOrgUnit(comInfo);
                    }
                }
            }
        }
        return localCurrency;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doAdminOrgUnit(Context ctx, Map lineData, PurContractInfo purContractInfo) throws BOSException, EASBizException, TaskExternalException {
        Object data = ((DataToken)lineData.get((Object)"FAdminOrgUnit_number")).data;
        AdminOrgUnitInfo adminOrgUnitInfo = null;
        if (purContractInfo.getPurPerson() != null) {
            if (!this.paramMap.containsValue("PURORDER001")) {
                this.paramMap = ParamControlFactory.getLocalInstance((Context)ctx).getParamHashMap(new String[]{"PURORDER001"}, purContractInfo.getPurOrgUnit().getId().toString());
            }
            if (this.isIntPurParam("PURORDER001", 0, 0, this.paramMap)) {
                if (!this.adminOrgMap.containsKey(purContractInfo.getPurPerson().getId().toString())) {
                    IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
                    adminOrgUnitInfo = iPerson.getPrimaryAdminOrgUnit(purContractInfo.getPurPerson().getId());
                    this.adminOrgMap.put(purContractInfo.getPurPerson().getId().toString(), adminOrgUnitInfo);
                }
                adminOrgUnitInfo = this.adminOrgMap.get(purContractInfo.getPurPerson().getId().toString());
                purContractInfo.setAdminOrgUnit(adminOrgUnitInfo);
            } else {
                purContractInfo.setAdminOrgUnit(null);
                if (!this.adminOrgMap.containsKey(purContractInfo.getPurOrgUnit().getId().toString() + data)) {
                    IOrgUnitRelation iour = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
                    OrgUnitCollection ioc = iour.getToUnit(purContractInfo.getPurOrgUnit().getId().toString(), 3, 0);
                    if (ioc != null && ioc.size() > 0) {
                        adminOrgUnitInfo = (AdminOrgUnitInfo)ioc.get(0);
                        for (int i = 0; i < ioc.size(); ++i) {
                            if (!ioc.get(i).getNumber().toString().equals(data)) continue;
                            adminOrgUnitInfo = (AdminOrgUnitInfo)ioc.get(i);
                            break;
                        }
                    }
                    this.adminOrgMap.put(purContractInfo.getPurOrgUnit().getId().toString() + data, adminOrgUnitInfo);
                }
                adminOrgUnitInfo = this.adminOrgMap.get(purContractInfo.getPurOrgUnit().getId().toString() + data);
                purContractInfo.setAdminOrgUnit(adminOrgUnitInfo);
            }
        }
        if (data == null || StringUtil.isEmpty((String)data.toString()) || purContractInfo.getAdminOrgUnit() != null) return;
        String str = data.toString();
        if (this.adminOrgMap.containsKey(str)) {
            purContractInfo.setAdminOrgUnit(this.adminOrgMap.get(str));
            return;
        } else {
            IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
            OrgUnitCollection orgUnitCollection = iOrgUnitRelation.getToUnit(purContractInfo.getPurOrgUnit().getId().toString(), 3, 0);
            HashSet<String> orgIdSet = new HashSet<String>();
            if (orgUnitCollection == null || orgUnitCollection.size() <= 0) throw new TaskExternalException(str + " " + SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)"purRelationAdmin", (Context)ctx));
            for (int i = 0; i < orgUnitCollection.size(); ++i) {
                orgIdSet.add(orgUnitCollection.get(i).getId().toString());
            }
            IAdminOrgUnit iadminOrgUnit = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
            AdminOrgUnitCollection collection = iadminOrgUnit.getAdminOrgUnitCollection(this.getFilterForAdmin(data.toString().trim(), orgIdSet));
            if (collection == null || collection.size() <= 0) throw new TaskExternalException(str + " " + SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)"AdminOrgUnitNotExists", (Context)ctx));
            AdminOrgUnitInfo info = collection.get(0);
            if (info == null) return;
            purContractInfo.setAdminOrgUnit(info);
            this.adminOrgMap.put(str, info);
        }
    }

    private void doIntegerFields(Map lineData, PurContractInfo purContractInfo) {
        for (int i = 0; i < this.INTEGER_FIELDS.length; ++i) {
            Object o = ((DataToken)lineData.get((Object)this.INTEGER_FIELDS[i])).data;
            if (o == null || o.toString().equals("")) continue;
            Integer value = new Integer(o.toString());
            purContractInfo.setInt(this.INTEGER_OBJS[i], value);
        }
    }

    private void doStringFields(Map lineData, PurContractInfo purContractInfo) {
        for (int i = 0; i < this.STRING_FIELDS.length; ++i) {
            Object o = ((DataToken)lineData.get((Object)this.STRING_FIELDS[i])).data;
            if (o == null) continue;
            String value = o.toString();
            if (value.length() > 255) {
                value = value.substring(0, 255);
            }
            purContractInfo.setString(this.STRING_OBJS[i], value);
        }
    }

    private void doBooleanFields(Context ctx, Map lineData, PurContractInfo purContractInfo) throws TaskExternalException {
        for (int i = 0; i < this.BOOLEAN_FIELDS.length; ++i) {
            String value;
            Object o = ((DataToken)lineData.get((Object)this.BOOLEAN_FIELDS[i])).data;
            if (o == null || o.toString().trim().length() <= 0 || (value = o.toString()) == null) continue;
            purContractInfo.setBoolean(this.BOOLEAN_OBJS[i], this.getBooleanValue(value, this.BOOLEAN_OBJS[i], ctx));
        }
    }

    private void doDecimalFields(Context ctx, Map lineData, PurContractInfo purContractInfo) throws TaskExternalException {
        Object o = null;
        for (int i = 0; i < this.BIGDECIMAL_FIELDS.length; ++i) {
            try {
                o = ((DataToken)lineData.get((Object)this.BIGDECIMAL_FIELDS[i])).data;
                if (o != null && o.toString().trim().length() > 0) {
                    BigDecimal value = new BigDecimal(o.toString());
                    if (this.BIGDECIMAL_FIELDS[i].equalsIgnoreCase("FPrepayRate")) {
                        this.checkRateValid(ctx, value, "prepaymentRate");
                    }
                    if (value == null) continue;
                    purContractInfo.setBigDecimal(this.BIGDECIMAL_OBJ[i], value);
                    continue;
                }
                purContractInfo.setBigDecimal(this.BIGDECIMAL_OBJ[i], BigDecimal.ZERO);
                continue;
            }
            catch (NumberFormatException nex) {
                logger.error((Object)nex);
                throw new TaskExternalException(this.BIGDECIMAL_OBJ[i] + " " + SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)"numberFormatError", (Context)ctx));
            }
        }
    }

    private void doDateFields(Context ctx, Map lineData, PurContractInfo purContractInfo) throws TaskExternalException {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        for (int i = 0; i < this.DATE_FIELDS.length; ++i) {
            Date value;
            Object o = ((DataToken)lineData.get((Object)this.DATE_FIELDS[i])).data;
            if (o != null && o.toString().length() > 0) {
                try {
                    o = df.parse(o.toString());
                }
                catch (ParseException pex) {
                    logger.error((Object)pex);
                    this.fail(ctx, "InvalidDateFormat");
                }
                if (o == null || !(o instanceof Date)) continue;
                value = (Date)o;
                if (value != null) {
                    purContractInfo.setDate(this.DATE_OBJS[i], value);
                }
                if (!"FEffectedDate".equals(this.DATE_FIELDS[i]) || value.compareTo(purContractInfo.getBizDate()) >= 0) continue;
                this.fail(ctx, "BIZDATE_AFTER_EFFECTEDDATE");
                continue;
            }
            if ("bizDate".equals(this.DATE_OBJS[i])) {
                this.fail(ctx, "orderDateNotNull");
            }
            value = new Date();
            purContractInfo.setDate(this.DATE_OBJS[i], value);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doPurchaseOrgUnit(PurContractInfo purContractInfo, Map lineData, Context ctx) throws TaskExternalException, BOSException {
        Object souData = ((DataToken)lineData.get((Object)"FPurOrgUnit_number")).data;
        if (souData == null) throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)"PURQUOTATION_PUSCHORIG_NOTNULL", (Context)ctx));
        if (souData.toString().trim().length() <= 0) throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)"PURQUOTATION_PUSCHORIG_NOTNULL", (Context)ctx));
        PurchaseOrgUnitInfo info = this.getPurchaseOrgUnit(ctx, "number", souData);
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String userInfoID = null;
        if (userInfo != null) {
            userInfoID = userInfo.getId().toString();
        }
        try {
            if (userInfoID != null) {
                PermissionFactory.getLocalInstance((Context)ctx).checkFunctionPermission((IObjectPK)new ObjectUuidPK(userInfoID), (IObjectPK)new ObjectUuidPK(info.getId().toString()), "purcontract_addnew");
            }
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage());
        }
        purContractInfo.setPurOrgUnit(info);
    }

    private void handleEntry(PurContractInfo purContractInfo, PurContractEntryInfo entryInfo, Map lineData, Context ctx) throws TaskExternalException {
        this.doEntryDateFields(entryInfo, lineData, ctx);
        this.doEntryBooleanFields(entryInfo, lineData, ctx);
        this.doEntryStringFields(entryInfo, lineData);
        try {
            this.doPiceFields(purContractInfo, entryInfo, lineData, ctx);
            this.doRowType(purContractInfo, entryInfo, lineData, ctx);
            this.doStorageOrgUnit(entryInfo, lineData, ctx);
            this.doMaterialGroupOrMaterial(purContractInfo, entryInfo, lineData, ctx);
            this.doUnit(entryInfo, lineData, ctx);
            this.doEntryDecimalFields(entryInfo, lineData, ctx);
            this.doAssitProperty(entryInfo, lineData, ctx);
            this.doBaseUnitAndBaseQty(entryInfo, ctx);
            this.doEntryAdminOrg(purContractInfo, entryInfo, lineData, ctx);
            this.doWarehouse(entryInfo, lineData, ctx);
            this.doProjectNumber(entryInfo, lineData, ctx);
            this.doTrackNumber(entryInfo, lineData, ctx);
        }
        catch (EASBizException ex) {
            throw new TaskExternalException(ex.getMessage());
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage());
        }
    }

    private void doTrackNumber(PurContractEntryInfo entryInfo, Map lineData, Context ctx) throws BOSException, TaskExternalException {
        String str;
        Object data = ((DataToken)lineData.get((Object)"FEntries$trackNumber_number")).data;
        if (data != null && entryInfo.getReceiveType() != null && "10".equals(entryInfo.getReceiveType().getValue()) && (str = data.toString()) != null && str.length() > 0 && entryInfo.getStorageOrgUnit() != null) {
            TrackNumberInfo info = this.getTrackNumber(ctx, data, entryInfo.getStorageOrgUnit().getCU());
            if (entryInfo.getProject() != null) {
                ProjectCarCollection pjc = entryInfo.getProject().getCarNumberRange();
                if (pjc != null) {
                    boolean isFound = false;
                    int size = pjc.size();
                    for (int i = 0; i < size; ++i) {
                        String tr_proj;
                        ProjectCarInfo pci = pjc.get(i);
                        if (pci.getTrackNumber() == null || !(tr_proj = pci.getTrackNumber().getId().toString()).equals(info.getId().toString())) continue;
                        entryInfo.setTrackNumber(info);
                        isFound = true;
                        break;
                    }
                    if (!isFound) {
                        this.fail(ctx, "trackNumberNotInProject");
                    }
                }
            } else {
                entryInfo.setTrackNumber(info);
            }
        }
    }

    private void doProjectNumber(PurContractEntryInfo entryInfo, Map lineData, Context ctx) throws BOSException, TaskExternalException {
        String str;
        Object data = ((DataToken)lineData.get((Object)"FEntries$project_number")).data;
        if (data != null && entryInfo.getReceiveType() != null && "10".equals(entryInfo.getReceiveType().getValue()) && (str = data.toString()) != null && str.length() > 0 && entryInfo.getMaterial() != null && entryInfo.getStorageOrgUnit() != null) {
            ProjectInfo pro = this.getProject(ctx, data, entryInfo.getStorageOrgUnit().getCU());
            MaterialPlanInfo mpInfo = this.getMaterialPlan(ctx, entryInfo.getMaterial(), entryInfo.getStorageOrgUnit(), null, null);
            if (mpInfo != null) {
                HashSet<String> set = new HashSet<String>();
                set.add("MTS10");
                set.add("MTS11");
                set.add("MTS20");
                set.add("ETO10");
                set.add("ETO20");
                ManufactureStrategyInfo strategy = mpInfo.getManufactureStrategy();
                if (strategy == null || set.contains(strategy.getNumber())) {
                    entryInfo.setProject(pro);
                }
            } else {
                entryInfo.setProject(pro);
            }
        }
    }

    private void doWarehouse(PurContractEntryInfo entryInfo, Map lineData, Context ctx) throws BOSException, TaskExternalException {
        String str;
        Object data;
        MaterialInfo material = entryInfo.getMaterial();
        StorageOrgUnitInfo receiveOrgInfo = entryInfo.getStorageOrgUnit();
        if (material != null && receiveOrgInfo != null && (data = ((DataToken)lineData.get((Object)"FEntries$warehouse_number")).data) != null && !StringUtil.isEmpty((String)data.toString()) && (str = data.toString()) != null && str.length() > 0) {
            if (!this.warehouseMap.containsKey(receiveOrgInfo.getId().toString() + str)) {
                EntityViewInfo accreditEV = new EntityViewInfo();
                FilterInfo accreditF = new FilterInfo();
                SelectorItemCollection accreditSic = new SelectorItemCollection();
                accreditF.getFilterItems().add(new FilterItemInfo("storageOrg", (Object)receiveOrgInfo.getId().toString(), CompareType.EQUALS));
                accreditF.getFilterItems().add(new FilterItemInfo("status", (Object)1, CompareType.EQUALS));
                accreditSic.add(new SelectorItemInfo("warehouse"));
                accreditEV.setSelector(accreditSic);
                accreditEV.setFilter(accreditF);
                SOAccreditWHCollection isoCol = SOAccreditWHFactory.getLocalInstance((Context)ctx).getSOAccreditWHCollection(accreditEV);
                HashSet<String> warehouseIdSet = new HashSet<String>();
                SOAccreditWHInfo sOAccreditWHInfo = null;
                for (int i = 0; i < isoCol.size(); ++i) {
                    sOAccreditWHInfo = isoCol.get(i);
                    if (null == sOAccreditWHInfo || null == sOAccreditWHInfo.getWarehouse()) continue;
                    warehouseIdSet.add(sOAccreditWHInfo.getWarehouse());
                }
                EntityViewInfo ev = this.getFilter(data.toString().trim());
                FilterInfo f = ev.getFilter();
                f.getFilterItems().add(new FilterItemInfo("id", warehouseIdSet, CompareType.INCLUDE));
                f.getFilterItems().add(new FilterItemInfo("whState", (Object)"1", CompareType.EQUALS));
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                ev.setSelector(sic);
                IWarehouse iHouse = WarehouseFactory.getLocalInstance((Context)ctx);
                WarehouseCollection collection = iHouse.getWarehouseCollection(ev);
                if (collection != null && collection.size() > 0) {
                    WarehouseInfo info = collection.get(0);
                    if (info != null) {
                        this.warehouseMap.put(receiveOrgInfo.getId().toString() + str, info);
                    }
                } else {
                    this.fail(ctx, "WarehouseNotExistOrInvalid");
                }
            }
            entryInfo.setWarehouse(this.warehouseMap.get(receiveOrgInfo.getId().toString() + str));
        }
    }

    private void doEntryAdminOrg(PurContractInfo purContractInfo, PurContractEntryInfo entryInfo, Map lineData, Context ctx) throws BOSException, TaskExternalException {
        PurchaseOrgUnitInfo purOrg;
        RowTypeInfo rowType = entryInfo.getRowType();
        if (rowType != null && rowType.getRequestOrgType().equals((Object)RequestOrgTypeEnum.ADMINORGUNIT) && (purOrg = purContractInfo.getPurOrgUnit()) != null) {
            Object data = ((DataToken)lineData.get((Object)"FEntries$adminOrgUnit_number")).data;
            if (data != null && !StringUtil.isEmpty((String)data.toString())) {
                AdminOrgUnitInfo info = this.getAdminOrgUnit(ctx, "number", data);
                EntityViewInfo ev = new EntityViewInfo();
                FilterInfo fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("fromUnit.id", (Object)info.getId().toString()));
                fi.getFilterItems().add(new FilterItemInfo("toUnit.id", (Object)purOrg.getId().toString()));
                fi.getFilterItems().add(new FilterItemInfo("typeRelation.fromType", (Object)0));
                fi.getFilterItems().add(new FilterItemInfo("typeRelation.toType", (Object)3));
                ev.setFilter(fi);
                IOrgUnitRelation iRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
                OrgUnitRelationCollection relationCol = iRelation.getOrgUnitRelationCollection(ev);
                if (relationCol != null && relationCol.size() > 0) {
                    entryInfo.setAdminOrgUnit(info);
                } else {
                    this.fail(ctx, "AdminOrgNotDelegatePurOrg");
                }
            } else {
                this.fail(ctx, "adminOrgUnitNotNull");
            }
        }
    }

    private void doBaseUnitAndBaseQty(PurContractEntryInfo entryInfo, Context ctx) throws BOSException, EASBizException, TaskExternalException {
        if (entryInfo.getRowType() != null && entryInfo.getRowType().isIsHasMaterialNumber()) {
            if (entryInfo.getMaterial() != null && entryInfo.getMaterial().getBaseUnit().getId() != null) {
                entryInfo.setBaseUnit(entryInfo.getMaterial().getBaseUnit());
                if (entryInfo.getUnit() != null && entryInfo.getQty() != null) {
                    BigDecimal baseUnitQty = this.getExchangePrecisionQty(ctx, entryInfo.getMaterial().getId().toString(), entryInfo.getUnit(), entryInfo.getBaseUnit(), entryInfo.getQty());
                    entryInfo.setBaseQty(baseUnitQty);
                    MultiMeasureUnitInfo multiUnifInfo = this.getMultiMeasureUnitInfo(ctx, entryInfo.getMaterial().getId().toString(), entryInfo.getUnit().getId().toString());
                    BigDecimal qty = entryInfo.getQty().setScale(multiUnifInfo.getQtyPrecision(), 4);
                    entryInfo.setQty(qty);
                }
            } else if (entryInfo.getMaterialGroup() != null) {
                if (entryInfo.getUnit() != null) {
                    entryInfo.setBaseUnit(entryInfo.getUnit());
                }
                if (entryInfo.getQty() != null) {
                    entryInfo.setBaseQty(entryInfo.getQty());
                }
            }
        } else {
            if (entryInfo.getUnit() != null) {
                entryInfo.setBaseUnit(entryInfo.getUnit());
            }
            if (entryInfo.getQty() != null) {
                entryInfo.setBaseQty(entryInfo.getQty());
            }
        }
    }

    private void doAssitProperty(PurContractEntryInfo entryInfo, Map lineData, Context ctx) throws TaskExternalException {
        Object data;
        MaterialInfo material = entryInfo.getMaterial();
        if (material != null && material.getAssistAttr() != null && (data = ((DataToken)lineData.get((Object)"FEntries$assistProperty_number")).data) != null) {
            AsstAttrValueInfo info = this.getAsstAttr(ctx, data, material.getAssistAttr());
            entryInfo.setAssistProperty(info);
        }
    }

    private void doStorageOrgUnit(PurContractEntryInfo entryInfo, Map lineData, Context ctx) throws BOSException, TaskExternalException {
        Object data = ((DataToken)lineData.get((Object)"FEntries$storageOrgUnit_number")).data;
        if (entryInfo.getReceiveType() != null && "10".equals(entryInfo.getReceiveType().getValue()) && data != null && !StringUtil.isEmpty((String)data.toString())) {
            String str = data.toString();
            StorageOrgUnitInfo info = this.getStorageOrgUnit(ctx, "number", data);
            entryInfo.setStorageOrgUnit(info);
        }
    }

    private CompanyOrgUnitInfo getCompanyInfoByStorage(PurContractEntryInfo entryInfo, Context ctx, String str, StorageOrgUnitInfo info) throws BOSException {
        if (this.companyBystorageMap.containsKey(str)) {
            return this.companyBystorageMap.get(str);
        }
        if (info != null) {
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("fromUnit.id", (Object)info.getId().toString()));
            fi.getFilterItems().add(new FilterItemInfo("typeRelation.fromType", (Object)4));
            fi.getFilterItems().add(new FilterItemInfo("typeRelation.toType", (Object)1));
            ev.setFilter(fi);
            IOrgUnitRelation iRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
            OrgUnitRelationCollection relationCol = iRelation.getOrgUnitRelationCollection(ev);
            if (relationCol != null && relationCol.size() > 0) {
                String toUnitId = relationCol.get(0).getToUnit().getId().toString();
                ICompanyOrgUnit icom = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
                CompanyOrgUnitCollection comCol = icom.getCompanyOrgUnitCollection("where id = '" + toUnitId + "'");
                if (comCol != null && comCol.size() > 0) {
                    this.companyBystorageMap.put(str, comCol.get(0));
                    return comCol.get(0);
                }
            }
        }
        return null;
    }

    private void doUnit(PurContractEntryInfo entryInfo, Map lineData, Context ctx) throws TaskExternalException, BOSException {
        Object data = ((DataToken)lineData.get((Object)"FEntries$unit_number")).data;
        if (null != data && !StringUtils.isEmpty((String)data.toString())) {
            MaterialInfo material = entryInfo.getMaterial();
            MeasureUnitInfo unitInfo = null;
            if (entryInfo.getMaterial() != null) {
                unitInfo = this.getMeasureUnit(ctx, data, material);
                entryInfo.setUnit(unitInfo);
            } else if (entryInfo.getMaterialName() != null) {
                unitInfo = this.getMeasureUnitByNumber(ctx, data.toString());
                entryInfo.setUnit(unitInfo);
            }
        } else {
            this.fail(ctx, "unitNotNull");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private MaterialInfo doMaterialInfo(PurContractInfo purContractInfo, PurContractEntryInfo entryInfo, Map lineData, Context ctx) throws BOSException, TaskExternalException {
        MaterialInfo material = null;
        RowTypeInfo rowType = entryInfo.getRowType();
        if (rowType == null) return material;
        if (rowType.isIsHasMaterialNumber()) {
            Object data = ((DataToken)lineData.get((Object)"FEntries$material_number")).data;
            if (data == null || StringUtil.isEmpty((String)data.toString())) throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)"MATERIAL_NULL", (Context)ctx));
            String str = data.toString().trim();
            if (str == null || str.length() <= 0) return material;
            material = this.getMaterial(ctx, "number", str, new OrgUnitInfo[]{purContractInfo.getCompanyOrgUnit(), purContractInfo.getPurOrgUnit(), entryInfo.getStorageOrgUnit()});
            if (null != material && !UsedStatusEnum.APPROVED.equals((Object)material.getStatus())) {
                throw new TaskExternalException(PurUtil.getServerResource("com.kingdee.eas.scm.sm.pur.PurBizResource", "MATERIAL_NOT_APPROVED", new String[]{str}, ctx));
            }
            entryInfo.setMaterial(material);
            if (null == material) return material;
            entryInfo.setMaterialName(material.getName());
            entryInfo.setNoNumMaterialModel(material.getModel());
            entryInfo.setAssistUnit(material.getAssistUnit());
            return material;
        } else {
            String materialName = ((DataToken)lineData.get((Object)"FEntries_materialName")).data.toString().trim();
            if (StringUtil.isEmpty((String)materialName)) {
                this.fail(ctx, "materialNameNotNull");
            }
            String model = ((DataToken)lineData.get((Object)"FEntries_noNumMaterialModel")).data.toString().trim();
            entryInfo.setMaterialName(materialName);
            entryInfo.setNoNumMaterialModel(model);
        }
        return material;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doRowType(PurContractInfo purContractInfo, PurContractEntryInfo entryInfo, Map lineData, Context ctx) throws BOSException, TaskExternalException {
        Object data = ((DataToken)lineData.get((Object)"FEntries$rowType_number")).data;
        if (data == null || "".equals(data)) throw new TaskExternalException(" " + SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)"RowTypeNotExists", (Context)ctx));
        String str = data.toString();
        if (this.rowTypeMap.containsKey(str)) {
            entryInfo.setRowType(this.rowTypeMap.get(str));
            entryInfo.setReceiveType(this.rowTypeMap.get(str).getDestinationType());
            return;
        } else {
            RowTypeCollection collection;
            IRowType iRowType = RowTypeFactory.getLocalInstance((Context)ctx);
            String bizTypeid = null;
            if (purContractInfo.getBizType() != null) {
                bizTypeid = purContractInfo.getBizType().getId().toString();
            }
            if ((collection = iRowType.getRowTypeCollection(this.getFilter(data.toString().trim()))) == null || collection.size() <= 0) throw new TaskExternalException(str + " " + SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)"RowTypeNotExists", (Context)ctx));
            RowTypeInfo info = collection.get(0);
            if (info == null || bizTypeid == null) return;
            if (!this.checkRowType(ctx, bizTypeid, info.getId().toString())) {
                throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)"BizTypeNotRelationRowType", (Context)ctx));
            }
            entryInfo.setRowType(info);
            entryInfo.setReceiveType(info.getDestinationType());
            this.rowTypeMap.put(str, info);
        }
    }

    private void doPiceFields(PurContractInfo purContractInfo, PurContractEntryInfo entryInfo, Map lineData, Context ctx) throws TaskExternalException {
        BigDecimal zero = BigDecimal.ZERO;
        boolean isPresent = entryInfo.isIsPresent();
        BigDecimal taxRate = zero;
        boolean isInTax = purContractInfo.isIsInTax();
        boolean isvmi = false;
        BizTypeInfo bizTypeInfo = purContractInfo.getBizType();
        try {
            String taxRateStr = ((DataToken)lineData.get((Object)"FEntries_taxRate")).data.toString();
            if (StringUtil.isEmpty((String)taxRateStr)) {
                taxRateStr = "0";
            }
            if ((taxRate = this.getUnPercentedRate(taxRateStr)).compareTo(zero) < 0) {
                this.fail(ctx, "taxRateCannotNegative");
            }
            if (isPresent) {
                entryInfo.setPrice(zero);
                entryInfo.setTaxPrice(zero);
                entryInfo.setTaxRate(zero);
                entryInfo.setAmount(zero);
                entryInfo.setTaxAmount(zero);
                entryInfo.setDiscountAmount(zero);
                entryInfo.setDiscount(zero);
            } else {
                BigDecimal price;
                BigDecimal taxPrice;
                if (isInTax) {
                    String taxPriceStr = ((DataToken)lineData.get((Object)"FEntries_taxPrice")).data.toString();
                    if (StringUtil.isEmpty((String)taxPriceStr)) {
                        taxPriceStr = "0.0";
                    }
                    if ((taxPrice = new BigDecimal(taxPriceStr)).compareTo(zero) < 0) {
                        this.fail(ctx, "taxPriceCannotNegative");
                    }
                    price = taxPrice.multiply(BigDecimal.ONE.subtract(taxRate));
                } else {
                    String priceStr = ((DataToken)lineData.get((Object)"FEntries_price")).data.toString();
                    if (StringUtil.isEmpty((String)priceStr) && isvmi) {
                        priceStr = "0.0";
                    }
                    if ((price = new BigDecimal(priceStr)).compareTo(zero) < 0) {
                        this.fail(ctx, "priceCannotNegative");
                    }
                    taxPrice = price.multiply(BigDecimal.ONE.add(taxRate));
                }
                entryInfo.setPrice(price);
                entryInfo.setTaxPrice(taxPrice);
                entryInfo.setTaxRate(new BigDecimal(taxRateStr));
            }
        }
        catch (NumberFormatException e) {
            this.fail(ctx, "invalidBigDecimalFormat");
        }
    }

    private void doEntryStringFields(PurContractEntryInfo entryInfo, Map lineData) {
        for (int i = 0; i < this.STRING_FIELDS_EN.length; ++i) {
            Object o = ((DataToken)lineData.get((Object)this.STRING_FIELDS_EN[i])).data;
            if (o == null) continue;
            String value = o.toString();
            if (value.length() > 255) {
                value = value.substring(0, 255);
            }
            entryInfo.setString(this.STRING_OBJS_EN[i], value);
        }
    }

    private void doEntryBooleanFields(PurContractEntryInfo entryInfo, Map lineData, Context ctx) throws TaskExternalException {
        for (int i = 0; i < this.BOOLEAN_FIELDS_EN.length; ++i) {
            String value;
            Object o = ((DataToken)lineData.get((Object)this.BOOLEAN_FIELDS_EN[i])).data;
            if (o == null || o.toString().trim().length() <= 0 || (value = o.toString()) == null) continue;
            entryInfo.setBoolean(this.BOOLEAN_OBJS_EN[i], this.getBooleanValue(value, this.BOOLEAN_OBJS_EN[i], ctx));
        }
    }

    private void doEntryDateFields(PurContractEntryInfo entryInfo, Map lineData, Context ctx) throws TaskExternalException {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        for (int i = 0; i < this.DATE_FIELDS_EN.length; ++i) {
            Date value;
            Object o = ((DataToken)lineData.get((Object)this.DATE_FIELDS_EN[i])).data;
            if ("FEntries_deliveryDate".equals(this.DATE_FIELDS_EN[i]) && (null == o || StringUtils.isEmpty((String)o.toString()))) {
                this.fail(ctx, "DeliveryDateNotNull");
            }
            if (o == null || o.toString().length() <= 0) continue;
            try {
                o = df.parse(o.toString());
            }
            catch (ParseException pex) {
                logger.error((Object)pex);
                this.fail(ctx, "InvalidDateFormat");
            }
            if (o == null || !(o instanceof Date) || (value = (Date)o) == null) continue;
            entryInfo.setDate(this.DATE_OBJS_EN[i], value);
        }
    }

    private BigDecimal doEntryDecimalFields(PurContractEntryInfo entryInfo, Map lineData, Context ctx) throws TaskExternalException {
        BigDecimal zero = BigDecimal.ZERO;
        for (int i = 0; i < this.BIGDECIMAL_FIELDS_EN.length; ++i) {
            try {
                RowTypeInfo rowType;
                BigDecimal value;
                Object o = ((DataToken)lineData.get((Object)this.BIGDECIMAL_FIELDS_EN[i])).data;
                if (o == null || o.toString().trim().length() <= 0 || (value = new BigDecimal(o.toString())) == null) continue;
                if ("FEntries_discount".equalsIgnoreCase(this.BIGDECIMAL_FIELDS_EN[i])) {
                    this.checkRateValid(ctx, value, "DiscountRate");
                }
                if ("FEntries_taxRate".equalsIgnoreCase(this.BIGDECIMAL_FIELDS_EN[i])) {
                    this.checkRateValid(ctx, value, "TaxRate");
                }
                if ("FEntries_receiveOwingRate".equalsIgnoreCase(this.BIGDECIMAL_FIELDS_EN[i])) {
                    this.checkRateValid(ctx, value, "receiveOwingRate");
                }
                entryInfo.setBigDecimal(this.BIGDECIMAL_OBJ_EN[i], value);
                if ("baseQty".equals(this.BIGDECIMAL_OBJ_EN[i])) {
                    entryInfo.setBigDecimal("totalUnReceiveBaseQty", value);
                }
                if ("qty".equals(this.BIGDECIMAL_OBJ_EN[i])) {
                    entryInfo.setBigDecimal("totalUnReceiveQty", value);
                }
                if ((rowType = entryInfo.getRowType()) == null) continue;
                if (rowType.isIsHasMaterialNumber()) {
                    if (!"FEntries_assistQty".equals(this.BIGDECIMAL_FIELDS_EN[i]) || entryInfo.getMaterial() != null && null != entryInfo.getMaterial().getAssistUnit()) continue;
                    entryInfo.setAssistQty(zero);
                    continue;
                }
                entryInfo.setAssistQty(zero);
                continue;
            }
            catch (NumberFormatException nex) {
                logger.error((Object)nex);
                this.fail(ctx, "invalidBigDecimalFormat");
            }
        }
        return zero;
    }

    private EntityViewInfo getFilter(String number, SelectorItemCollection sic) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (sic != null) {
            viewInfo.setSelector(sic);
        }
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        return viewInfo;
    }

    private EntityViewInfo getFilterByName(String name, String purchaseGroupid) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.number", (Object)name, CompareType.EQUALS));
        if (purchaseGroupid != null) {
            filter.getFilterItems().add(new FilterItemInfo("purGroup.id", (Object)purchaseGroupid, CompareType.EQUALS));
        }
        viewInfo.setFilter(filter);
        return viewInfo;
    }

    private boolean checkRowType(Context ctx, String bizType, String rowType) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        viewInfo.setSelector(sic);
        filterInfo.getFilterItems().add(new FilterItemInfo("bizType.id", (Object)bizType, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("rowType.id", (Object)rowType, CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        CoreBaseCollection bizTypeCollection = RowBizTypeFactory.getLocalInstance((Context)ctx).getCollection(viewInfo);
        return !bizTypeCollection.isEmpty() && bizTypeCollection.size() > 0;
    }

    private boolean getBooleanValue(String value, String key, Context ctx) throws TaskExternalException {
        return (value = value.trim()).equals(PurUtil.getServerResource("com.kingdee.eas.scm.sm.pur.PurUIResource", "yes", ctx)) || value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("1");
    }

    private String getBooleanText(Context ctx, boolean value) {
        if (value) {
            return PurUtil.getServerResource("com.kingdee.eas.scm.sm.pur.PurUIResource", "yes", ctx);
        }
        return PurUtil.getServerResource("com.kingdee.eas.scm.sm.pur.PurUIResource", "not", ctx);
    }

    private UserInfo getUserFromNumber(IUser iuser, String number) throws BOSException {
        UserCollection users;
        UserInfo userInfo = null;
        if (number != null && number.trim().length() > 0 && (users = iuser.getUserCollection("where number='" + number + "'")) != null && users.size() > 0) {
            userInfo = users.get(0);
        }
        return userInfo;
    }

    private void calEntry(PurContractInfo purContractInfo, PurContractEntryInfo entryInfo) {
        boolean isInTax = purContractInfo.isIsInTax();
        if (isInTax) {
            entryInfo.setTaxPrice(entryInfo.getTaxPrice().setScale(this.getPricePre(entryInfo), 4));
            this.calEntryPriceByTaxPrice(purContractInfo, entryInfo);
            this.calEntryTotalTaxAmount(purContractInfo, entryInfo);
            this.calEntryTax(purContractInfo, entryInfo);
            this.calEntryAmount(purContractInfo, entryInfo);
            this.calEntryActualPrice(purContractInfo, entryInfo);
            this.calEntryActualTaxPrice(purContractInfo, entryInfo);
            this.calEntryDiscountAmount(purContractInfo, entryInfo);
        } else {
            entryInfo.setPrice(entryInfo.getPrice().setScale(this.getPricePre(entryInfo), 4));
            this.calEntryTaxPricebyPrice(purContractInfo, entryInfo);
            this.calEntryDiscountAmount(purContractInfo, entryInfo);
            this.calEntryAmount(purContractInfo, entryInfo);
            this.calEntryActualPrice(purContractInfo, entryInfo);
            this.calEntryTax(purContractInfo, entryInfo);
            this.calEntryTotalTaxAmount(purContractInfo, entryInfo);
            this.calEntryActualTaxPrice(purContractInfo, entryInfo);
        }
        this.calEntryLocalValue(purContractInfo, entryInfo);
        this.calTotalAmount(purContractInfo);
        this.calTotalTax(purContractInfo);
        this.calTotalTaxAmount(purContractInfo);
        this.calTotalValue(purContractInfo);
        this.calPreAmount(purContractInfo);
    }

    public void calTotalValue(PurContractInfo purContractInfo) {
        BigDecimal localTotalAmount = new BigDecimal("0.00");
        BigDecimal localTotalTaxAmount = new BigDecimal("0.00");
        BigDecimal localTotalTax = new BigDecimal("0.00");
        int count = purContractInfo.getEntries().size();
        for (int index = 0; index < count; ++index) {
            if (purContractInfo.getEntries().get(index).getAmount() != null) {
                localTotalAmount = localTotalAmount.add(purContractInfo.getEntries().get(index).getAmount());
            }
            if (purContractInfo.getEntries().get(index).getTaxAmount() != null) {
                localTotalTaxAmount = localTotalTaxAmount.add(purContractInfo.getEntries().get(index).getTaxAmount());
            }
            if (purContractInfo.getEntries().get(index).getTax() == null) continue;
            localTotalTax = localTotalTax.add(purContractInfo.getEntries().get(index).getTax());
        }
        purContractInfo.setLocalTotalAmount(localTotalAmount);
        purContractInfo.setLocalTotalTaxAmount(localTotalTaxAmount);
        purContractInfo.setLocalTotalTax(localTotalTax);
    }

    public void calEntryLocalValue(PurContractInfo purContractInfo, PurContractEntryInfo entryInfo) {
        BigDecimal entryLocalAmount = new BigDecimal("0.00");
        BigDecimal entryLocalTax = new BigDecimal("0.00");
        BigDecimal entryLocalTaxAmount = new BigDecimal("0.00");
        int currencyPrecision = 2;
        if (purContractInfo.getCurrency() != null) {
            currencyPrecision = purContractInfo.getCurrency().getPrecision();
        }
        BigDecimal amount = entryInfo.getAmount();
        BigDecimal tax = entryInfo.getTax();
        BigDecimal taxAmount = entryInfo.getTaxAmount();
        BigDecimal exchangeRate = purContractInfo.getExchangeRate();
        ConvertModeEnum convertMode = purContractInfo.getConvertMode();
        if (amount != null && SysConstant.BIGZERO.compareTo(exchangeRate) != 0) {
            if (convertMode != null && convertMode == ConvertModeEnum.DIRECTEXCHANGERATE) {
                entryLocalAmount = amount.multiply(exchangeRate).setScale(currencyPrecision, 4);
                entryLocalTax = tax.multiply(exchangeRate).setScale(currencyPrecision, 4);
                entryLocalTaxAmount = taxAmount.multiply(exchangeRate).setScale(currencyPrecision, 4);
            } else if (SysConstant.BIGZERO.compareTo(exchangeRate) != 0) {
                entryLocalAmount = amount.divide(exchangeRate, currencyPrecision, 4);
                entryLocalTax = tax.divide(exchangeRate, currencyPrecision, 4);
                entryLocalTaxAmount = taxAmount.divide(exchangeRate, currencyPrecision, 4);
            }
        }
        entryInfo.setLocalAmount(entryLocalAmount);
        entryInfo.setLocalTax(entryLocalTax);
        entryInfo.setLocalTaxAmount(entryLocalTaxAmount);
    }

    public void calTotalAmount(PurContractInfo purContractInfo) {
        BigDecimal totalAmount = new BigDecimal("0.00");
        int count = purContractInfo.getEntries().size();
        for (int index = 0; index < count; ++index) {
            if (purContractInfo.getEntries().get(index).getAmount() == null) continue;
            totalAmount = totalAmount.add(purContractInfo.getEntries().get(index).getAmount());
        }
        purContractInfo.setTotalAmount(totalAmount);
    }

    public void calTotalTax(PurContractInfo purContractInfo) {
        BigDecimal totalTax = new BigDecimal("0.00");
        int count = purContractInfo.getEntries().size();
        for (int index = 0; index < count; ++index) {
            if (purContractInfo.getEntries().get(index).getTax() == null) continue;
            totalTax = totalTax.add(purContractInfo.getEntries().get(index).getTax());
        }
        purContractInfo.setTotalTax(totalTax);
    }

    public void calTotalTaxAmount(PurContractInfo purContractInfo) {
        BigDecimal totalTaxAmount = new BigDecimal("0.00");
        int count = purContractInfo.getEntries().size();
        for (int index = 0; index < count; ++index) {
            if (purContractInfo.getEntries().get(index).getTaxAmount() == null) continue;
            totalTaxAmount = totalTaxAmount.add(purContractInfo.getEntries().get(index).getTaxAmount());
        }
        purContractInfo.setTotalTaxAmount(totalTaxAmount);
        this.totalTaxAmt = totalTaxAmount;
    }

    public void calEntryTaxPricebyPrice(PurContractInfo purContractInfo, PurContractEntryInfo entryInfo) {
        BigDecimal price = entryInfo.getPrice();
        BigDecimal taxRate = entryInfo.getTaxRate();
        int materialPricePrecision = 2;
        if (entryInfo.getMaterial() != null) {
            materialPricePrecision = entryInfo.getMaterial().getPricePrecision();
        }
        BigDecimal taxPrice = CalculateUtils.calTaxPrice((BigDecimal)price, (BigDecimal)taxRate, (int)materialPricePrecision);
        entryInfo.setTaxPrice(taxPrice);
    }

    private void calEntryPriceByTaxPrice(PurContractInfo purContractInfo, PurContractEntryInfo entryInfo) {
        boolean isInTax = purContractInfo.isIsInTax();
        BigDecimal price = entryInfo.getPrice();
        BigDecimal taxPrice = entryInfo.getTaxPrice();
        BigDecimal taxRate = entryInfo.getTaxRate();
        int materialPricePrecision = 4;
        if (entryInfo.getMaterial() != null) {
            materialPricePrecision = entryInfo.getMaterial().getPricePrecision();
        } else if (entryInfo.getRowType() != null) {
            materialPricePrecision = entryInfo.getRowType().getPrecision();
        }
        if (isInTax) {
            price = CalculateUtils.calPrice((BigDecimal)taxPrice, (BigDecimal)taxRate, (int)materialPricePrecision);
        }
        entryInfo.setPrice(price);
    }

    private int getPricePre(PurContractEntryInfo entryInfo) {
        int materialPricePrecision = 4;
        if (entryInfo.getMaterial() != null) {
            materialPricePrecision = entryInfo.getMaterial().getPricePrecision();
        } else if (entryInfo.getRowType() != null) {
            materialPricePrecision = entryInfo.getRowType().getPrecision();
        }
        return materialPricePrecision;
    }

    private void calEntryTotalTaxAmount(PurContractInfo purContractInfo, PurContractEntryInfo entryInfo) {
        boolean isInTax = purContractInfo.isIsInTax();
        BigDecimal taxPrice = entryInfo.getTaxPrice();
        int currencyPrecision = 2;
        if (purContractInfo.getCurrency() != null) {
            currencyPrecision = purContractInfo.getCurrency().getPrecision();
        }
        if (isInTax) {
            BigDecimal discount = entryInfo.getDiscount();
            BigDecimal qty = entryInfo.getQty();
            BigDecimal actualPrice = null;
            qty = qty == null ? this.zero : qty;
            taxPrice = taxPrice == null ? this.zero : taxPrice;
            discount = discount == null ? this.zero : discount;
            BigDecimal one = new BigDecimal("1.0");
            BigDecimal oneHundred = new BigDecimal("100.0");
            BigDecimal discountAmount = new BigDecimal("0.00");
            if (taxPrice != null && discount != null && qty != null) {
                discountAmount = taxPrice.multiply(qty).multiply(discount).divide(oneHundred, 10, 4);
                actualPrice = taxPrice.multiply(qty).subtract(discountAmount).divide(one, currencyPrecision, 4);
                entryInfo.setTaxAmount(actualPrice);
            }
        } else {
            BigDecimal amount = entryInfo.getAmount();
            if (amount == null) {
                amount = SysConstant.BIGZERO;
            }
            BigDecimal tax = entryInfo.getTax();
            BigDecimal totalTaxAmount = SysConstant.BIGZERO;
            if (tax != null) {
                totalTaxAmount = amount.add(tax);
            }
            entryInfo.setTaxAmount(totalTaxAmount);
        }
    }

    public void calEntryTax(PurContractInfo purContractInfo, PurContractEntryInfo entryInfo) {
        boolean isInTax = purContractInfo.isIsInTax();
        BigDecimal taxAmount = new BigDecimal("0.00");
        BigDecimal taxRate = new BigDecimal("0.00");
        int currencyPrecision = 2;
        if (purContractInfo.getCurrency() != null) {
            currencyPrecision = purContractInfo.getCurrency().getPrecision();
        }
        if (isInTax) {
            BigDecimal one = new BigDecimal("1.0");
            if (entryInfo.getTaxAmount() != null) {
                taxAmount = entryInfo.getTaxAmount();
            }
            if (entryInfo.getTaxRate() != null) {
                taxRate = entryInfo.getTaxRate();
            }
            BigDecimal tax = SysConstant.BIGZERO;
            BigDecimal oneHundred = new BigDecimal("100.0");
            if (taxAmount != null && taxRate != null) {
                taxRate = taxRate.divide(oneHundred, 10, 4);
                tax = taxAmount.divide(taxRate.add(one), 10, 4).multiply(taxRate);
                tax = tax.setScale(currencyPrecision, 4);
            }
            entryInfo.setTax(tax);
        } else {
            BigDecimal tax;
            BigDecimal amount = entryInfo.getAmount();
            if (amount == null) {
                amount = SysConstant.BIGZERO;
            }
            if (entryInfo.getTaxRate() != null) {
                taxRate = entryInfo.getTaxRate();
            }
            if ((tax = CalculateUtils.calTax((BigDecimal)amount, (BigDecimal)taxRate, (int)currencyPrecision)) != null) {
                entryInfo.setTax(tax);
            } else {
                entryInfo.setTax(SysConstant.BIGZERO);
            }
        }
    }

    public void calEntryAmount(PurContractInfo purContractInfo, PurContractEntryInfo entryInfo) {
        boolean isInTax = purContractInfo.isIsInTax();
        int currencyPrecision = 2;
        if (purContractInfo.getCurrency() != null) {
            currencyPrecision = purContractInfo.getCurrency().getPrecision();
        }
        if (isInTax) {
            BigDecimal taxAmount = entryInfo.getTaxAmount();
            BigDecimal tax = entryInfo.getTax();
            entryInfo.setAmount(SysConstant.BIGZERO);
            if (taxAmount != null && tax != null) {
                BigDecimal actualTaxPrice = taxAmount.subtract(tax);
                actualTaxPrice = actualTaxPrice.setScale(currencyPrecision, 4);
                entryInfo.setAmount(actualTaxPrice);
            }
        } else {
            BigDecimal price = entryInfo.getPrice();
            BigDecimal discount = entryInfo.getDiscount();
            BigDecimal qty = entryInfo.getQty();
            BigDecimal actualPrice = null;
            discount = discount == null ? this.zero : discount;
            BigDecimal one = new BigDecimal("1.0");
            BigDecimal oneHundred = new BigDecimal("100.0");
            if (price != null && discount != null) {
                actualPrice = price.multiply(one.subtract(discount.divide(oneHundred, 10, 4)));
            }
            BigDecimal amount = CalculateUtils.calAmount((BigDecimal)qty, actualPrice, (int)currencyPrecision);
            entryInfo.setAmount(amount);
        }
    }

    public void calEntryActualPrice(PurContractInfo purContractInfo, PurContractEntryInfo entryInfo) {
        int materialPricePrecision = 2;
        if (entryInfo.getMaterial() != null) {
            materialPricePrecision = entryInfo.getMaterial().getPricePrecision();
        }
        BigDecimal amount = entryInfo.getAmount();
        BigDecimal qty = entryInfo.getQty();
        entryInfo.setActualPrice(SysConstant.BIGZERO);
        if (amount != null && qty != null && qty.compareTo(this.zero) > 0) {
            BigDecimal actualTaxPrice = amount.divide(qty, materialPricePrecision, 4);
            entryInfo.setActualPrice(actualTaxPrice);
        }
    }

    public void calEntryActualTaxPrice(PurContractInfo purContractInfo, PurContractEntryInfo entryInfo) {
        int materialPricePrecision = 2;
        if (entryInfo.getMaterial() != null) {
            materialPricePrecision = entryInfo.getMaterial().getPricePrecision();
        }
        BigDecimal taxAmount = entryInfo.getTaxAmount();
        BigDecimal qty = entryInfo.getQty();
        BigDecimal actualTaxPrice = SysConstant.BIGZERO;
        if (taxAmount != null && qty != null && qty.compareTo(this.zero) > 0) {
            actualTaxPrice = taxAmount.divide(qty, materialPricePrecision, 4);
        }
        entryInfo.setActualTaxPrice(actualTaxPrice);
    }

    public void calEntryDiscountAmount(PurContractInfo purContractInfo, PurContractEntryInfo entryInfo) {
        BigDecimal discount = entryInfo.getDiscount();
        BigDecimal qty = entryInfo.getQty();
        BigDecimal taxPrice = entryInfo.getTaxPrice();
        taxPrice = taxPrice == null ? this.zero : taxPrice;
        BigDecimal hundred = new BigDecimal("100");
        int currencyPrecision = 2;
        if (purContractInfo.getCurrency() != null) {
            currencyPrecision = purContractInfo.getCurrency().getPrecision();
        }
        if (qty == null) {
            entryInfo.setDiscountAmount(null);
            return;
        }
        if (entryInfo.getDiscount() != null && entryInfo.getDiscount().compareTo(this.zero) > 0 && taxPrice.compareTo(this.zero) > 0) {
            BigDecimal discountAmount = CalculateUtils.calDiscountAmountByPercent((BigDecimal)discount, (BigDecimal)qty, (BigDecimal)taxPrice, (int)currencyPrecision);
            entryInfo.setDiscountAmount(discountAmount);
            if (entryInfo.getDiscount().compareTo(new BigDecimal("100.00")) > 0) {
                entryInfo.setDiscount(new BigDecimal("100.00"));
                entryInfo.setDiscountAmount(entryInfo.getQty().multiply(taxPrice).setScale(currencyPrecision, RoundingMode.HALF_UP));
            }
        } else if (entryInfo.getDiscountAmount() != null && entryInfo.getDiscountAmount().compareTo(this.zero) > 0 && taxPrice.compareTo(this.zero) > 0) {
            BigDecimal discountRate = entryInfo.getDiscountAmount().divide(entryInfo.getQty().multiply(taxPrice), this.discountRatePrePrecision, 4).multiply(hundred);
            entryInfo.setDiscount(discountRate);
            if (discountRate.compareTo(new BigDecimal("100.00")) > 0) {
                entryInfo.setDiscount(new BigDecimal("100.00"));
                entryInfo.setDiscountAmount(entryInfo.getQty().multiply(taxPrice).setScale(currencyPrecision, RoundingMode.HALF_UP));
            }
        }
    }

    private EntityViewInfo getFilterForAdmin(String number, Set orgIdSet) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)orgIdSet, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        return viewInfo;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.scm.sm.pur.app.PurContractExportQuery";
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = null;
        try {
            result = new Hashtable();
            this.putTable(result, "FNumber", rs.getString("number"));
            this.putTable(result, "FBizDate", rs.getString("bizDate"));
            this.putTable(result, "FEffectedDate", rs.getString("effectedDate"));
            this.putTable(result, "FBizType_number", rs.getString("bizType.number"));
            this.putTable(result, "FSupplier_number", rs.getString("supplier.number"));
            this.putTable(result, "FSignedAddress", rs.getString("signedAddress"));
            this.putTable(result, "FContractType_number", rs.getString("contractType.number"));
            this.putTable(result, "FIsInTax", this.getBooleanText(ctx, rs.getBoolean("isInTax")));
            this.putTable(result, "FPurOrgUnit_number", rs.getString("purOrgUnit.number"));
            this.putTable(result, "FDeliveryType_number", rs.getString("deliveryType.number"));
            this.putTable(result, "FDeliveryAddress", rs.getString("deliveryAddress"));
            this.putTable(result, "FCurrency_number", rs.getString("currency.number"));
            this.putTable(result, "FExchangeRate", rs.getString("exchangeRate"));
            this.putTable(result, "FPaymentType_number", rs.getString("paymentType.number"));
            this.putTable(result, "FPaymentCondition_number", rs.getString("paymentCondition.number"));
            this.putTable(result, "FSettlementType_number", rs.getString("settlementType.number"));
            this.putTable(result, "FCashDiscount_number", rs.getString("cashDiscount.number"));
            this.putTable(result, "FPrepayRate", rs.getBigDecimal("prepayRate"));
            this.putTable(result, "FPrepayAmount", rs.getString("prepayAmount"));
            this.putTable(result, "FAdminOrgUnit_number", rs.getString("adminOrgUnit.number"));
            this.putTable(result, "FPurGroup_number", rs.getString("purGroup.number"));
            this.putTable(result, "FPurPerson_number", rs.getString("purPerson.number"));
            this.putTable(result, "FDescription", rs.getString("description"));
            this.putTable(result, "FEntries$rowType_number", rs.getString("rowType.number"));
            this.putTable(result, "FEntries$materialGroup_number", rs.getString("materialGroup.number"));
            this.putTable(result, "FEntries$material_number", rs.getString("material.number"));
            this.putTable(result, "FEntries_materialName", rs.getString("material.name"));
            this.putTable(result, "FEntries_noNumMaterialModel", rs.getString("material.model"));
            this.putTable(result, "FEntries$assistProperty_number", rs.getString("assistProperty.number"));
            this.putTable(result, "FEntries_isPresent", this.getBooleanText(ctx, rs.getBoolean("entries.isPresent")));
            this.putTable(result, "FEntries$unit_number", rs.getString("unit.number"));
            this.putTable(result, "FEntries$assistUnit_number", rs.getString("assistUnit.number"));
            this.putTable(result, "FEntries_qty", rs.getString("entries.qty"));
            this.putTable(result, "FEntries_assistQty", rs.getString("entries.assistQty"));
            this.putTable(result, "FEntries$storageOrgUnit_number", rs.getString("storageOrgUnit.number"));
            this.putTable(result, "FEntries$adminOrgUnit_number", rs.getString("adminOrgUnit.number"));
            this.putTable(result, "FEntries_deliveryDate", rs.getString("entries.deliveryDate"));
            this.putTable(result, "FEntries_consignDate", rs.getString("entries.consignDate"));
            this.putTable(result, "FEntries_price", rs.getString("entries.price"));
            this.putTable(result, "FEntries_discountType", rs.getBigDecimal("entries.discountType"));
            this.putTable(result, "FEntries_discount", rs.getBigDecimal("entries.discount"));
            this.putTable(result, "FEntries_discountAmount", rs.getBigDecimal("entries.discountAmount"));
            this.putTable(result, "FEntries_taxRate", rs.getBigDecimal("entries.taxRate"));
            this.putTable(result, "FEntries_taxPrice", rs.getString("entries.taxPrice"));
            this.putTable(result, "FEntries_actualTaxPrice", rs.getString("entries.actualTaxPrice"));
            this.putTable(result, "FEntries_amount", rs.getString("entries.amount"));
            this.putTable(result, "FEntries_localAmount", rs.getString("entries.localAmount"));
            this.putTable(result, "FEntries_tax", rs.getString("entries.tax"));
            this.putTable(result, "FEntries_taxAmount", rs.getString("entries.taxAmount"));
            this.putTable(result, "FEntries_localTax", rs.getString("entries.localTax"));
            this.putTable(result, "FEntries_localTaxAmount", rs.getString("entries.localTaxAmount"));
            this.putTable(result, "FEntries$project_number", rs.getString("project.number"));
            this.putTable(result, "FEntries$trackNumber_number", rs.getString("trackNumber.number"));
            this.putTable(result, "FEntries_qualityUnCtrl", this.getBooleanText(ctx, rs.getBoolean("entries.qualityUnCtrl")));
            this.putTable(result, "FEntries_timeUnCtrl", this.getBooleanText(ctx, rs.getBoolean("entries.timeUnCtrl")));
            this.putTable(result, "FEntries_receiveAdvanceDays", rs.getString("entries.receiveAdvanceDays"));
            this.putTable(result, "FEntries_receiveDeferralDays", rs.getString("entries.receiveDeferralDays"));
            this.putTable(result, "FEntries_receiveOverRate", rs.getBigDecimal("entries.receiveOverRate"));
            this.putTable(result, "FEntries_receiveOwingRate", rs.getBigDecimal("entries.receiveOwingRate"));
            this.putTable(result, "FEntries$warehouse_number", rs.getString("warehouse.number"));
            this.putTable(result, "FEntries$qcStandard_number", rs.getString("qcStandard.number"));
            this.putTable(result, "FEntries$qualityOrg_number", rs.getString("qualityOrg.number"));
            this.putTable(result, "FEntries_remark", rs.getString("entries.remark"));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage());
        }
        return result;
    }

    private void putTable(Hashtable htable, Object key, Object value) {
        DataImportTools.putToHashtable((Hashtable)htable, (Object)key, (Object)value);
    }

    private String getMessage(Context ctx, String key) {
        return PurUtil.getServerResource(RESOURCE, key, ctx);
    }

    private String getMessage(Context ctx, String key, String[] params) {
        return PurUtil.getServerResource(RESOURCE, key, params, ctx);
    }

    private void fail(Context ctx, String key) throws TaskExternalException {
        throw new TaskExternalException(this.getMessage(ctx, key));
    }

    private void fail(Context ctx, String key, String[] params) throws TaskExternalException {
        throw new TaskExternalException(this.getMessage(ctx, key, params));
    }

    private void checkRateValid(Context ctx, BigDecimal val, String key) throws TaskExternalException {
        if (val.compareTo(BigDecimal.ZERO) < 0 || val.compareTo(hundred) > 0) {
            this.fail(ctx, "invalidRateData", new String[]{this.getMessage(ctx, key)});
        }
    }

    private BigDecimal getUnPercentedRate(String str) {
        BigDecimal val = new BigDecimal(str);
        return val.divide(hundred, 2, 4);
    }

    public boolean isSameBlock(Hashtable firstData, Hashtable currentData) {
        DataToken fndt = (DataToken)firstData.get("FNumber");
        String firstNumber = (String)fndt.data;
        DataToken ctdt = (DataToken)currentData.get("FNumber");
        String currentFnumber = (String)ctdt.data;
        if (firstData != null && currentData != null && firstNumber.equals(currentFnumber)) {
            return true;
        }
        return firstData != null && currentData != null && (currentFnumber == null || currentFnumber.length() == 0);
    }

    public int getSubmitType() {
        return 1;
    }

    public boolean isIntPurParam(String key, int defaultValue, int trueValue, Map<String, String> paramMap) {
        String strPurParam = paramMap.get(key);
        if (strPurParam != null && strPurParam.trim().length() != 0) {
            int value = Integer.parseInt(strPurParam);
            return value == trueValue;
        }
        return defaultValue == trueValue;
    }

    public ExchangeRateInfo getExchangeRate(Context ctx, CompanyOrgUnitInfo companyOrgUnitInfo, IObjectPK sourceCurrPK, IObjectPK destCurrPK) throws EASBizException, BOSException {
        if (destCurrPK == null) {
            destCurrPK = sourceCurrPK;
        }
        ExchangeTableInfo exchangeTableInfo = companyOrgUnitInfo.getBaseExchangeTable();
        ObjectUuidPK excTablepk = null;
        if (exchangeTableInfo == null) {
            return null;
        }
        excTablepk = new ObjectUuidPK(exchangeTableInfo.getId());
        ExchangeRateInfo exchangeRateInfo = null;
        exchangeRateInfo = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getCurrentExchangeRate((IObjectPK)excTablepk, sourceCurrPK, destCurrPK);
        return exchangeRateInfo;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo oldFilterInfo = (FilterInfo)this.getContextParameter("filter");
        String filterItmesStr = (String)this.getContextMap().get("filterItems");
        if (filterItmesStr != null) {
            FilterInfo filterInfo = null;
            SqlExpr sqlExpr = null;
            try {
                if (filterItmesStr.contains("{\"subject\"")) {
                    String filterItems = FilterSqlUtils.getFilterItems(ctx, filterItmesStr);
                    filterInfo = new FilterInfo(filterItems);
                } else {
                    sqlExpr = ViewParseUtils.parseFilterExpr((String)filterItmesStr);
                    filterInfo = new FilterInfo(sqlExpr);
                }
                if (oldFilterInfo != null) {
                    try {
                        filterInfo.mergeFilter(oldFilterInfo, "and");
                    }
                    catch (BOSException e) {
                        e.printStackTrace();
                    }
                }
                return filterInfo;
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        } else {
            Object parameter;
            FilterInfo filterInfo = new FilterInfo();
            CtrlUnitInfo cuInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            if (cuInfo == null) {
                return filterInfo;
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("CU.id", (Object)cuInfo.getId().toString(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"11111111-1111-1111-1111-111111111111CCE7AED4", CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"00000000-0000-0000-0000-000000000000CCE7AED4", CompareType.EQUALS));
            filterInfo.setMaskString("#0 or #1 or #2");
            if (oldFilterInfo != null) {
                try {
                    filterInfo.mergeFilter(oldFilterInfo, "and");
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            }
            if ((parameter = this.getContextParameter("entries.id")) == null) {
                return filterInfo;
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("entries.id", parameter, CompareType.INCLUDE));
            return filterInfo;
        }
        return null;
    }

    private EntityViewInfo getbizTypeFilter(String number, SelectorItemCollection sic) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (sic != null) {
            viewInfo.setSelector(sic);
        }
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)"select FBizTypeID from T_SCM_BillBizType where FBillTypeID ='510b6503-0105-1000-e000-010bc0a812fd463ED552'", CompareType.INNER));
        viewInfo.setFilter(filter);
        return viewInfo;
    }

    private void loadMaterialOtherInfo(Context ctx, PurContractInfo purContractInfo, PurContractEntryInfo entryInfo) throws BOSException, TaskExternalException {
        CompanyOrgUnitInfo cou = purContractInfo.getCompanyOrgUnit();
        PurchaseOrgUnitInfo sou = purContractInfo.getPurOrgUnit();
        if (sou == null || cou == null) {
            return;
        }
        String mID = entryInfo.getMaterial().getId().toString();
        String compayID = cou.getId().toString();
        String ckey = mID + compayID;
        if (this.dataPool.getMaterialCompanyInfoInfo(ckey) == null) {
            Map cmap = InvServerUtils.getMatCompanyInfoCollection((Context)ctx, (String[])new String[]{mID}, (String[])new String[]{compayID});
            if (cmap != null && cmap.size() > 0) {
                MaterialCompanyInfoInfo cInfo = (MaterialCompanyInfoInfo)cmap.get(ckey);
                this.dataPool.setMaterialCompanyInfoInfo(ckey, cInfo);
            } else {
                throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)"MATERIAL_COMPANY_NOT_NULL", (Context)ctx));
            }
        }
        String invID = sou.getId().toString();
        String invKey = mID + invID;
        if (this.dataPool.getMaterialPurchaseInfoMap(invKey) == null) {
            Map purMap = PurUtil.getMatPurchasingInfoCollection(ctx, new String[]{mID}, new String[]{invID});
            if (purMap != null && purMap.size() > 0) {
                MaterialPurchasingInfo invInfo = (MaterialPurchasingInfo)purMap.get(invKey);
                this.dataPool.setMaterialPurchaseInfoMap(invKey, invInfo);
            } else {
                throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)"MATERIAL_STORAGE_NOT_NULL", (Context)ctx));
            }
        }
    }

    public void calPreAmount(PurContractInfo purContractInfo) {
        BigDecimal prepaymentRate = purContractInfo.getPrepayRate();
        int currencyPrecision = 2;
        if (purContractInfo.getCurrency() != null) {
            currencyPrecision = purContractInfo.getCurrency().getPrecision();
        }
        if (purContractInfo.getEntries().size() > 0) {
            BigDecimal entryTotalPrePayment = SysConstant.BIGZERO;
            BigDecimal temp = BigDecimal.ZERO;
            int maxValueRow = 0;
            int count = purContractInfo.getEntries().size();
            for (int index = 0; index < count; ++index) {
                PurContractEntryInfo entryInfo = purContractInfo.getEntries().get(index);
                BigDecimal taxAmount = entryInfo.getTaxAmount();
                BigDecimal entryPrePayment = CalculateUtils.calPrepayment((BigDecimal)taxAmount, (BigDecimal)prepaymentRate, (int)currencyPrecision);
                BigDecimal preReceived = entryInfo.getPreReceived();
                preReceived = preReceived == null ? SysConstant.BIGZERO : preReceived;
                BigDecimal unPreReceived = SCMUtils.effectualNumeric((BigDecimal)entryPrePayment).subtract(SCMUtils.effectualNumeric((BigDecimal)preReceived));
                entryInfo.setPrepayment(entryPrePayment);
                entryInfo.setPreReceived(preReceived);
                entryInfo.setUnPrereceivedAm(unPreReceived);
                entryTotalPrePayment = entryTotalPrePayment.add(SCMUtils.effectualNumeric((BigDecimal)entryPrePayment));
                if (temp.compareTo(entryPrePayment) >= 0) continue;
                temp = entryPrePayment;
                maxValueRow = index;
            }
            BigDecimal prepayment = purContractInfo.getPrepayAmount();
            if (prepayment.compareTo(entryTotalPrePayment) != 0) {
                purContractInfo.getEntries().get(maxValueRow).setPrepayment(temp.subtract(entryTotalPrePayment.subtract(prepayment)));
                purContractInfo.getEntries().get(maxValueRow).setUnPrereceivedAm(temp.subtract(entryTotalPrePayment.subtract(prepayment)));
            }
        }
    }

    public String getImportPermissionItem() {
        return "purcontract_addnew";
    }

    private MaterialGroupInfo doMaterialGroup(PurContractInfo purContractInfo, PurContractEntryInfo entryInfo, Map lineData, Context ctx) throws BOSException, TaskExternalException {
        String str;
        Object data;
        MaterialGroupInfo materialGroupInfo = null;
        RowTypeInfo rowType = entryInfo.getRowType();
        if (rowType != null && rowType.isIsHasMaterialNumber() && (data = ((DataToken)lineData.get((Object)"FEntries$materialGroup_number")).data) != null && !StringUtil.isEmpty((String)data.toString()) && (str = data.toString().trim()) != null && str.length() > 0) {
            IMaterialGroup iMaterialGroup = MaterialGroupFactory.getLocalInstance((Context)ctx);
            CoreBaseCollection collection = iMaterialGroup.getCollection("where number='" + str + "'");
            if (!CollectionUtil.isEmpty((AbstractObjectCollection)collection) && collection.get(0) != null) {
                materialGroupInfo = (MaterialGroupInfo)collection.get(0);
            } else {
                this.fail(ctx, "matGroupNotExist");
            }
            entryInfo.setMaterialGroup(materialGroupInfo);
        }
        return materialGroupInfo;
    }

    private void doMaterialGroupOrMaterial(PurContractInfo purContractInfo, PurContractEntryInfo entryInfo, Map lineData, Context ctx) throws BOSException, TaskExternalException {
        boolean isNeedMat;
        Object materialGroup = ((DataToken)lineData.get((Object)"FEntries$materialGroup_number")).data;
        Object material = ((DataToken)lineData.get((Object)"FEntries$material_number")).data;
        RowTypeInfo rowType = entryInfo.getRowType();
        boolean bl = isNeedMat = rowType != null && rowType.isIsHasMaterialNumber();
        if (isNeedMat && materialGroup != null && !StringUtil.isEmpty((String)materialGroup.toString()) && material != null && !StringUtil.isEmpty((String)material.toString())) {
            throw new TaskExternalException(this.getMessage(ctx, "mat_matGroup_is_not_null"));
        }
        if ((materialGroup == null || StringUtil.isEmpty((String)materialGroup.toString())) && (material == null || StringUtil.isEmpty((String)material.toString())) && isNeedMat) {
            throw new TaskExternalException(this.getMessage(ctx, "mat_matGroup_is_null"));
        }
        if (materialGroup != null && !StringUtil.isEmpty((String)materialGroup.toString())) {
            this.doMaterialGroup(purContractInfo, entryInfo, lineData, ctx);
        }
        if (!isNeedMat || material != null && !StringUtil.isEmpty((String)material.toString())) {
            this.doMaterialInfo(purContractInfo, entryInfo, lineData, ctx);
        }
    }
}

