/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.basedata.assistant.AddressFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.assistant.PaymentTypeFactory;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeCollection;
import com.kingdee.eas.basedata.assistant.SettlementTypeFactory;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.framework.CUIDGetterFacadeFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillBizTypeCollection;
import com.kingdee.eas.basedata.scm.common.BillBizTypeFactory;
import com.kingdee.eas.basedata.scm.common.BillBizTypeInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeCollection;
import com.kingdee.eas.basedata.scm.common.BizTypeFactory;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.DeliveryTypeFactory;
import com.kingdee.eas.basedata.scm.common.DeliveryTypeInfo;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.basedata.scm.common.IRowType;
import com.kingdee.eas.basedata.scm.common.RowTypeFactory;
import com.kingdee.eas.basedata.scm.common.RowTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.scm.basedatautil.master.OrgUnitUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.ISCMBillCommonFacade;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.SCMGroupFacadeFactory;
import com.kingdee.eas.scm.common.loadmass.SCMBizDataVO;
import com.kingdee.eas.scm.common.util.OrgUtils;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.common.util.SCMUtil;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.scm.sm.pur.ChangeWayEnum;
import com.kingdee.eas.scm.sm.pur.PurContractEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurContractEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurContractFactory;
import com.kingdee.eas.scm.sm.pur.PurContractInfo;
import com.kingdee.eas.scm.sm.pur.PurContractPaymentCollection;
import com.kingdee.eas.scm.sm.pur.PurContractPaymentInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderException;
import com.kingdee.eas.scm.sm.pur.app.AbstractPurContractWebFacadeControllerBean;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.scm.util.constant.OprtStateConstant;
import com.kingdee.eas.util.app.ContextUtil;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class PurContractWebFacadeControllerBean
extends AbstractPurContractWebFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sm.pur.app.PurContractWebFacadeControllerBean");
    private Map parametersMap = null;
    public static final String KEY_ENDDATE = "endDate";
    public static final String KEY_STARTDATE = "startDate";
    public boolean isCopy = false;
    private CurrencyInfo m_baseCurrInfo = null;
    private static final BigDecimal ONE = SCMConstant.BIGDECIMAL_ONE;
    private static final BigDecimal ZERO = SCMConstant.BIGDECIMAL_ZERO;
    private Map<String, OrgUnitInfo> defaultDelegatedOrgMap = new HashMap<String, OrgUnitInfo>();
    RowTypeInfo rowType = null;

    protected Map _handleBillByCopy(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        PurContractPaymentCollection payEntries;
        HashMap map = new HashMap();
        PurContractInfo purContractInfo = (PurContractInfo)info;
        com.kingdee.eas.scm.util.SCMUtil.checkSupplierEnable((Context)ctx, (IObjectValue)info);
        PermissionFactory.getLocalInstance((Context)ctx).checkFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(purContractInfo.getPurOrgUnit().getId().toString()), "purcontract_addnew");
        purContractInfo.setChangeType(ChangeWayEnum.nullType);
        PurContractEntryCollection entries = purContractInfo.getEntries();
        if (entries != null) {
            int len = entries.size();
            for (int i = 0; i < len; ++i) {
                PurContractEntryInfo entryInfo = entries.get(i);
                entryInfo.setBaseStatus(EntryBaseStatusEnum.ADD);
                entryInfo.setReason(null);
                entryInfo.setTotalOrderAmount(null);
                entryInfo.setTotalOrderQty(null);
                entryInfo.setTotalPaidAmount(null);
                entryInfo.setTotalReqPayAmt(new BigDecimal("0.00"));
            }
        }
        if ((payEntries = purContractInfo.getPaymentPlan()) != null) {
            if (payEntries.size() > 0) {
                if (payEntries.size() > 1) {
                    payEntries.clear();
                    PurContractPaymentInfo itemsInfo = new PurContractPaymentInfo();
                    payEntries.add(itemsInfo);
                }
                PurContractPaymentInfo paymentInfo = payEntries.get(0);
                paymentInfo.setLocalPayAmount(null);
                paymentInfo.setPayAmount(null);
                paymentInfo.setPayDate(null);
                paymentInfo.setRemark(null);
            } else {
                PurContractPaymentInfo itemsInfo = new PurContractPaymentInfo();
                payEntries.add(itemsInfo);
            }
        }
        Timestamp date = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getServerDate();
        purContractInfo.setBizDate(date);
        Date eDate = new Date();
        eDate.setDate(date.getDate());
        eDate.setMonth(eDate.getMonth() + 1);
        purContractInfo.setEffectedDate(PurContractWebFacadeControllerBean.getEndDate(eDate));
        purContractInfo.setCreateTime(new Timestamp(((Date)date).getTime()));
        purContractInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        purContractInfo.setBaseStatus(BillBaseStatusEnum.ADD);
        purContractInfo.setModifier(null);
        purContractInfo.setModificationTime(null);
        purContractInfo.setAuditor(null);
        purContractInfo.setAuditTime(null);
        purContractInfo.setLastUpdateUser(null);
        purContractInfo.setLastUpdateTime(null);
        this.isCopy = true;
        return map;
    }

    public IObjectValue createNewData(Context context, IObjectValue model) throws BOSException, EASBizException {
        PurchaseOrgUnitInfo purchaseOrgUnitInfo;
        PurContractInfo info = (PurContractInfo)model;
        if (null != info.getPurOrgUnit() && null != info.getPurOrgUnit().getId().toString()) {
            this.parametersMap = this.batchGetParamValue(context, info.getPurOrgUnit().getId().toString(), info);
        }
        info.setCU(ContextUtil.getCurrentCtrlUnit((Context)context));
        info.setBaseStatus(BillBaseStatusEnum.ADD);
        Calendar calender = Calendar.getInstance();
        Timestamp currentDate = new Timestamp(calender.getTimeInMillis());
        info.setBizDate(currentDate);
        calender.add(2, 1);
        info.setEffectedDate(PurContractWebFacadeControllerBean.getEndDate(calender.getTime()));
        SettlementTypeInfo staticSettlementTypeInfo = this.getSettlementType(context);
        info.setSettlementType(staticSettlementTypeInfo);
        if (null != info.getPurOrgUnit() && (purchaseOrgUnitInfo = info.getPurOrgUnit()).isIsBizUnit()) {
            info.setCompanyOrgUnit(OrgUnitUtil.getCompanyOrgFromPurchaseOrg((Context)context, (PurchaseOrgUnitInfo)purchaseOrgUnitInfo));
            if (!this.isAdminOrgUnitByPerson() && !this.isCopy) {
                info.setAdminOrgUnit(this.getAdminOrgUnit(context, (OrgUnitInfo)purchaseOrgUnitInfo));
            }
        }
        this.m_baseCurrInfo = this.getBaseCurrencyByCou(context, info.getCompanyOrgUnit());
        info.setCurrency(this.m_baseCurrInfo);
        info.setExchangeRate(ONE);
        info.setIsInTax(true);
        info.setPurAdvanceDays(SysConstant.BIGZERO);
        info.setCreator(ContextUtil.getCurrentUserInfo((Context)context));
        info.setCreateTime(currentDate);
        BizTypeInfo bizTypeInfo = BizTypeFactory.getLocalInstance((Context)context).getBizTypeInfo((IObjectPK)new ObjectUuidPK("d8e80652-0106-1000-e000-04c5c0a812202407435C"));
        info.setBizType(bizTypeInfo);
        BillTypeInfo billTypeInfo = BillTypeFactory.getLocalInstance((Context)context).getBillTypeInfo((IObjectPK)new ObjectUuidPK("510b6503-0105-1000-e000-010bc0a813fd463ED552"));
        info.setBillType(billTypeInfo);
        DeliveryTypeInfo deliveryTypeInfo = DeliveryTypeFactory.getLocalInstance((Context)context).getDeliveryTypeInfo((IObjectPK)new ObjectUuidPK("51eb893e-0105-1000-e000-0c00c0a8123362E9EE3F"));
        info.setDeliveryType(deliveryTypeInfo);
        PaymentTypeInfo paymentTypeInfo = PaymentTypeFactory.getLocalInstance((Context)context).getPaymentTypeInfo((IObjectPK)new ObjectUuidPK("2fa35444-5a23-43fb-99ee-6d4fa5f260da6BCA0AB5"));
        info.setPaymentType(paymentTypeInfo);
        if (!this.isBizTypeValid(context, (IObjectValue)info, "510b6503-0105-1000-e000-010bc0a813fd463ED552", bizTypeInfo).booleanValue()) {
            info.setBizType(null);
        }
        if (info.getEntries() != null) {
            PurContractEntryInfo entry = null;
            for (int i = 0; i < 5; ++i) {
                entry = (PurContractEntryInfo)this.createNewDetailData(context, (IObjectValue)info);
                info.getEntries().add(entry);
            }
        }
        if (info.getPaymentPlan() != null) {
            PurContractPaymentInfo paymentInfo = new PurContractPaymentInfo();
            info.getPaymentPlan().add(paymentInfo);
        }
        return info;
    }

    public SettlementTypeInfo getSettlementType(Context ctx) throws BOSException {
        SettlementTypeInfo staticSettlementTypeInfo = null;
        SettlementTypeInfo cashSettlementTypeInfo = null;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("isDefault"));
        sic.add(new SelectorItemInfo("deletedStatus"));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)1));
        view.setSelector(sic);
        view.setFilter(filter);
        SettlementTypeCollection settlementTypeCollection = SettlementTypeFactory.getLocalInstance((Context)ctx).getSettlementTypeCollection(view);
        if (settlementTypeCollection.size() > 0) {
            SettlementTypeInfo settlementTypeInfo = null;
            for (int j = 0; j < settlementTypeCollection.size(); ++j) {
                settlementTypeInfo = settlementTypeCollection.get(j);
                if (settlementTypeInfo.isIsDefault()) {
                    staticSettlementTypeInfo = settlementTypeInfo;
                    break;
                }
                if (!"e09a62cd-00fd-1000-e000-0b32c0a8100dE96B2B8E".equals(settlementTypeInfo.getId().toString())) continue;
                cashSettlementTypeInfo = settlementTypeInfo;
            }
        }
        if (staticSettlementTypeInfo == null) {
            staticSettlementTypeInfo = cashSettlementTypeInfo;
        }
        return staticSettlementTypeInfo;
    }

    public IObjectValue createNewDetailData(Context context, IObjectValue model) throws BOSException, EASBizException {
        PurContractEntryInfo entryInfo = new PurContractEntryInfo();
        Date today = PurContractWebFacadeControllerBean.getServerDate();
        entryInfo.setConsignDate(today);
        entryInfo.setDeliveryDate(PurContractWebFacadeControllerBean.addDate(today, 2, 1));
        entryInfo.setQty(SysConstant.BIGZERO);
        entryInfo.setTaxRate(ZERO);
        entryInfo.setBaseStatus(EntryBaseStatusEnum.ADD);
        entryInfo.setQualityUnCtrl(true);
        entryInfo.setTimeUnCtrl(true);
        entryInfo.setAmountUnCtrl(true);
        entryInfo.setTotalReqPayAmt(ZERO);
        entryInfo.setIsPresent(false);
        entryInfo.setDiscountType(DiscountModeEnum.PERCENT);
        OrgUnitInfo storageOrg = this.getDefaultDelegatedOrg(context, this.getDefaultMainBizOrg(context), 4);
        if (storageOrg != null) {
            entryInfo.setStorageOrgUnit((StorageOrgUnitInfo)storageOrg);
        }
        if (null == this.rowType) {
            IRowType irowtype = RowTypeFactory.getLocalInstance((Context)context);
            this.rowType = irowtype.getRowTypeInfo((IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-0000000000017C7DC4A3"));
        }
        if (this.rowType != null) {
            entryInfo.setRowType(this.rowType);
            entryInfo.setReceiveType(this.rowType.getDestinationType());
        }
        return entryInfo;
    }

    protected Map _getInitData(Context ctx, IObjectValue model, String oprtState) throws BOSException, EASBizException {
        HashMap<String, Object> initData = new HashMap<String, Object>();
        PurContractInfo info = (PurContractInfo)model;
        if (info.getPurOrgUnit() == null) {
            return initData;
        }
        String orgId = info.getPurOrgUnit().getId().toString();
        CompanyOrgUnitInfo cou = OrgUnitUtil.getCompanyOrgFromPurchaseOrg((Context)ctx, (PurchaseOrgUnitInfo)info.getPurOrgUnit());
        initData.put("cou", cou);
        initData.put("baseCurrency", this.getBaseCurrencyByCou(ctx, cou));
        info.setCU(info.getPurOrgUnit().getCU());
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        CodingRuleInfo ruleInfo = iCodingRuleManager.getCodingRule((IObjectValue)new PurContractInfo(), info.getPurOrgUnit().getId().toString());
        if (ruleInfo != null) {
            initData.put("numberIsEdit", ruleInfo.isIsModifiable());
            if (info.getSourceBillType() != null && info.getBaseStatus().equals((Object)BillBaseStatusEnum.ADD) && ruleInfo.isIsAddView()) {
                initData.put("addNewNumber", iCodingRuleManager.getNumber(model, info.getPurOrgUnit().getId().toString()));
            }
        }
        Map paramMap = this.batchGetParamValue(ctx, info.getPurOrgUnit().getId().toString(), info);
        initData.put("params", paramMap);
        Date today = PurContractWebFacadeControllerBean.getServerDate();
        if (null == this.rowType) {
            IRowType irowtype = RowTypeFactory.getLocalInstance((Context)ctx);
            this.rowType = irowtype.getRowTypeInfo((IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-0000000000017C7DC4A3"));
        }
        if (this.rowType != null) {
            initData.put("defRowType", this.rowType);
            initData.put("defReceiveType", this.rowType.getDestinationType());
        }
        OrgUnitInfo delStorageOrg = this.getDefaultDelegatedOrg(ctx, (OrgUnitInfo)info.getPurOrgUnit(), 4);
        initData.put("defConsignDate", today);
        initData.put("defDeliveryDate", PurContractWebFacadeControllerBean.addDate(today, 2, 1));
        initData.put("defBaseStatus", EntryBaseStatusEnum.ADD);
        initData.put("purOrgFilter", this.getPurOrgFilter(ctx));
        initData.put("delStorageOrg", delStorageOrg);
        initData.put("delDiscountType", DiscountModeEnum.PERCENT);
        initData.put("projectF7Filter", this.getProjectF7Filter(ctx, orgId));
        initData.put("paymentConditionF7Filter", this.getPaymentConditionFilter(cou.getId().toString()));
        initData.put("trackNumberF7Filter", this.gettrackNumberF7Filter(ctx, orgId));
        initData.put("deliveryaddrF7Filter", this.getDeliverAddF7Filter(ctx, orgId));
        DeliveryTypeInfo deliveryType = DeliveryTypeFactory.getRemoteInstance().getDeliveryTypeInfo("select * where number = 'SEND'");
        initData.put("delDeliveryType", deliveryType);
        initData.put("bizTypeF7Filter", "billType.number = '260' and status=1");
        String paymentTypeF7Filter = "id ='2fa35444-5a23-43fb-99ee-6d4fa5f260da6BCA0AB5' or id = '40b75328-7f57-463f-8d19-280574ef24bf6BCA0AB5'";
        initData.put("paymentTypeF7Filter", paymentTypeF7Filter);
        OrgUnitCollection adminOrgUnitCollection = this.getOrgUnitColl(ctx, orgId, OrgType.Purchase, OrgType.Admin);
        initData.put("adminOrgF7Filter", "id in " + this.getOrgFilterStr(ctx, adminOrgUnitCollection));
        OrgUnitCollection requestOrgUnitCollection = this.getOrgUnitColl(ctx, orgId, OrgType.Purchase, OrgType.Storage);
        initData.put("storageOrgF7Filter", "id in " + this.getOrgFilterStr(ctx, requestOrgUnitCollection));
        OrgUnitCollection qualityOrgUnitCollection = this.getOrgUnitColl(ctx, orgId, OrgType.Purchase, OrgType.Quality);
        initData.put("qualityF7Filter", "id in " + this.getOrgFilterStr(ctx, qualityOrgUnitCollection));
        SettlementTypeInfo staticSettlementTypeInfo = this.getSettlementType(ctx);
        initData.put("defaultStaticSettlementType", staticSettlementTypeInfo);
        return initData;
    }

    protected Map _handleMainOrgChange(Context ctx, String mainOrgId) throws BOSException, EASBizException {
        HashMap<String, Object> responseMap = new HashMap<String, Object>();
        PurchaseOrgUnitInfo pou = PurchaseOrgUnitFactory.getLocalInstance((Context)ctx).getPurchaseOrgUnitInfo((IObjectPK)new ObjectUuidPK(mainOrgId));
        CompanyOrgUnitInfo cou = OrgUnitUtil.getCompanyOrgFromPurchaseOrg((Context)ctx, (PurchaseOrgUnitInfo)pou);
        responseMap.put("cou", cou);
        if (cou == null) {
            return responseMap;
        }
        String bizOrgCuId = CUIDGetterFacadeFactory.getLocalInstance((Context)ctx).getCUID(mainOrgId);
        responseMap.put("bizOrgCUID", bizOrgCuId);
        responseMap.put("baseCurrency", this.getBaseCurrencyByCou(ctx, cou));
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        CodingRuleInfo ruleInfo = iCodingRuleManager.getCodingRule((IObjectValue)new PurContractInfo(), pou.getId().toString());
        if (ruleInfo != null) {
            responseMap.put("numberIsEdit", ruleInfo.isIsModifiable());
            responseMap.put("isIsAddView", ruleInfo.isIsAddView());
            responseMap.put("addNewNumber", iCodingRuleManager.getNumber((IObjectValue)new PurContractInfo(), pou.getId().toString()));
        }
        Map paramMap = this.batchGetParamValue(ctx, mainOrgId, null);
        responseMap.put("params", paramMap);
        responseMap.put("projectF7Filter", this.getProjectF7Filter(ctx, mainOrgId));
        responseMap.put("trackNumberF7Filter", this.gettrackNumberF7Filter(ctx, mainOrgId));
        responseMap.put("deliveryaddrF7Filter", this.getDeliverAddF7Filter(ctx, mainOrgId));
        OrgUnitInfo delStorageOrg = this.getDefaultDelegatedOrg(ctx, (OrgUnitInfo)pou, 4);
        responseMap.put("delStorageOrg", delStorageOrg);
        OrgUnitCollection adminOrgUnitCollection = this.getOrgUnitColl(ctx, mainOrgId, OrgType.Purchase, OrgType.Admin);
        if (adminOrgUnitCollection != null && adminOrgUnitCollection.size() > 0) {
            responseMap.put("adminOrgF7Filter", "id in " + this.getOrgFilterStr(ctx, adminOrgUnitCollection));
        } else {
            responseMap.put("adminOrgF7Filter", "id in ('xxxxxxxx') ");
        }
        OrgUnitCollection requestOrgUnitCollection = this.getOrgUnitColl(ctx, mainOrgId, OrgType.Purchase, OrgType.Storage);
        if (requestOrgUnitCollection != null && requestOrgUnitCollection.size() > 0) {
            responseMap.put("storageOrgF7Filter", "id in " + this.getOrgFilterStr(ctx, requestOrgUnitCollection));
        } else {
            responseMap.put("storageOrgF7Filter", "id in ('xxxxxxxx') ");
        }
        OrgUnitCollection qualityOrgUnitCollection = this.getOrgUnitColl(ctx, mainOrgId, OrgType.Purchase, OrgType.Quality);
        if (qualityOrgUnitCollection != null && qualityOrgUnitCollection.size() > 0) {
            responseMap.put("qualityF7Filter", "id in " + this.getOrgFilterStr(ctx, qualityOrgUnitCollection));
        } else {
            responseMap.put("qualityF7Filter", "id in ('xxxxxxxx') ");
        }
        if (null == this.rowType) {
            IRowType irowtype = RowTypeFactory.getLocalInstance((Context)ctx);
            this.rowType = irowtype.getRowTypeInfo((IObjectPK)new ObjectUuidPK("00000000-0000-0000-0000-0000000000017C7DC4A3"));
        }
        if (this.rowType != null) {
            responseMap.put("defRowType", this.rowType);
            responseMap.put("defReceiveType", this.rowType.getDestinationType());
        }
        return responseMap;
    }

    public String getMainOrgUnitName() {
        return "purOrgUnit";
    }

    public OrgType getMainOrgType() {
        return OrgType.Purchase;
    }

    public String getPermissionItem() {
        return "purcontract_addnew";
    }

    private OrgUnitCollection getOrgUnitColl(Context ctx, String orgId, OrgType formOrgType, OrgType toOrgType) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)orgId)) {
            return null;
        }
        IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection orgUnitCollection = null;
        orgUnitCollection = toOrgType.equals((Object)OrgType.Storage) ? iOrgUnitRelation.getFromUnit(orgId, formOrgType.getValue(), toOrgType.getValue()) : iOrgUnitRelation.getToUnit(orgId, formOrgType.getValue(), toOrgType.getValue());
        if (orgUnitCollection != null && orgUnitCollection.size() > 0 && (toOrgType.equals((Object)OrgType.Storage) || toOrgType.equals((Object)OrgType.Admin))) {
            OrgUnitCollection orgColl = new OrgUnitCollection();
            OrgUnitInfo orgUnitInfo = null;
            StorageOrgUnitInfo storageOrgInfo = null;
            AdminOrgUnitInfo adminOrgInfo = null;
            int size = orgUnitCollection.size();
            for (int i = 0; i < size; ++i) {
                orgUnitInfo = orgUnitCollection.get(i);
                if (toOrgType.equals((Object)OrgType.Storage) && orgUnitInfo.isIsStorageOrgUnit()) {
                    storageOrgInfo = (StorageOrgUnitInfo)orgUnitInfo;
                    if (storageOrgInfo.isIsSealUp()) continue;
                    orgColl.add(orgUnitInfo);
                    continue;
                }
                if (!toOrgType.equals((Object)OrgType.Admin) || !orgUnitInfo.isIsAdminOrgUnit() || (adminOrgInfo = (AdminOrgUnitInfo)orgUnitInfo).isIsSealUp()) continue;
                orgColl.add(orgUnitInfo);
            }
            return orgColl;
        }
        return orgUnitCollection;
    }

    public boolean isAdminOrgUnitByPerson() throws EASBizException, BOSException {
        int value = this.getIntPurParameter("PURORDER001", 0);
        return value == 0;
    }

    public int getIntPurParameter(String key, int defaultValue) {
        int param = defaultValue;
        String strPurParam = this.getCacheParameter(key);
        if (strPurParam != null && strPurParam.trim().length() != 0) {
            param = Integer.valueOf(strPurParam);
        }
        return param;
    }

    private OrgUnitInfo getDefaultDelegatedOrg(Context ctx, OrgUnitInfo mainOrg, int orgType) throws EASBizException, BOSException {
        OrgUnitCollection orgCol2 = null;
        if (orgType == 4 && (this.getMainOrgType().equals((Object)OrgType.Purchase) || this.getMainOrgType().equals((Object)OrgType.Sale))) {
            OrgUnitCollection orgCol;
            int count;
            StorageOrgUnitInfo storageInfo = null;
            boolean isInStorageF7 = false;
            boolean isCurrentStorageInStorageF7 = false;
            StorageOrgUnitInfo storageInfo2 = null;
            PurchaseOrgUnitInfo purchaseInfo = null;
            SaleOrgUnitInfo saleInfo = null;
            HashSet<String> idSet = new HashSet<String>();
            OrgUnitInfo orgInfo = null;
            if (orgInfo == null && mainOrg != null) {
                orgInfo = mainOrg;
            }
            if (orgInfo == null) {
                orgInfo = ContextUtil.getCurrentOrgUnit((Context)ctx, (OrgType)OrgType.getEnum((int)orgType));
            }
            IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
            if (OrgType.Purchase.equals((Object)this.getMainOrgType()) && (purchaseInfo = (PurchaseOrgUnitInfo)this.getDefaultMainBizOrg(ctx)) != null && this.defaultDelegatedOrgMap.containsKey(purchaseInfo.getId().toString())) {
                return this.defaultDelegatedOrgMap.get(purchaseInfo.getId().toString()) == null ? (OrgUnitInfo)ctx.get((Object)orgType) : this.defaultDelegatedOrgMap.get(purchaseInfo.getId().toString());
            }
            if (OrgType.Sale.equals((Object)this.getMainOrgType()) && (saleInfo = (SaleOrgUnitInfo)this.getDefaultMainBizOrg(ctx)) != null && this.defaultDelegatedOrgMap.containsKey(saleInfo.getId().toString())) {
                return this.defaultDelegatedOrgMap.get(saleInfo.getId().toString()) == null ? (OrgUnitInfo)ctx.get((Object)orgType) : this.defaultDelegatedOrgMap.get(saleInfo.getId().toString());
            }
            if (purchaseInfo != null) {
                orgCol2 = iUnitRel.getFromUnit(purchaseInfo.getId().toString(), 3, 4);
                OrgUtils.getSortData((OrgUnitCollection)orgCol2);
                for (count = 0; count < orgCol2.size(); ++count) {
                    if (orgCol2.get(count) == null) continue;
                    idSet.add(orgCol2.get(count).getId().toString());
                }
                if (orgInfo != null && orgInfo.isIsStorageOrgUnit() && orgInfo.getBoolean("isBizUnit")) {
                    isCurrentStorageInStorageF7 = idSet.contains(orgInfo.getId().toString());
                    ObjectUuidPK pk = new ObjectUuidPK(orgInfo.getId());
                    storageInfo2 = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitInfo((IObjectPK)pk);
                    if (isCurrentStorageInStorageF7) {
                        this.defaultDelegatedOrgMap.put(purchaseInfo.getId().toString(), (OrgUnitInfo)storageInfo2);
                        return storageInfo2;
                    }
                }
                orgCol = iUnitRel.getToUnit(purchaseInfo.getId().toString(), 3, 4);
                OrgUtils.getSortData((OrgUnitCollection)orgCol);
                if (orgCol.size() > 0) {
                    for (int i = 0; i < orgCol.size(); ++i) {
                        if (!orgCol.get(i).getId().toString().equals(mainOrg.getId().toString())) continue;
                        storageInfo = (StorageOrgUnitInfo)orgCol.get(i);
                        break;
                    }
                    if (storageInfo == null) {
                        storageInfo = (StorageOrgUnitInfo)orgCol.get(0);
                    }
                }
                if (storageInfo != null) {
                    isInStorageF7 = idSet.contains(storageInfo.getId().toString());
                }
            }
            if (saleInfo != null) {
                orgCol2 = iUnitRel.getFromUnit(saleInfo.getId().toString(), 2, 4);
                OrgUtils.getSortData((OrgUnitCollection)orgCol2);
                for (count = 0; count < orgCol2.size(); ++count) {
                    if (orgCol2.get(count) == null) continue;
                    idSet.add(orgCol2.get(count).getId().toString());
                }
                if (orgInfo != null && orgInfo.isIsStorageOrgUnit() && orgInfo.getBoolean("isBizUnit") && (isCurrentStorageInStorageF7 = idSet.contains(orgInfo.getId().toString()))) {
                    ObjectUuidPK pk = new ObjectUuidPK(orgInfo.getId());
                    storageInfo2 = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitInfo((IObjectPK)pk);
                    this.defaultDelegatedOrgMap.put(saleInfo.getId().toString(), (OrgUnitInfo)storageInfo2);
                    return storageInfo2;
                }
                orgCol = iUnitRel.getToUnit(saleInfo.getId().toString(), 2, 4);
                OrgUtils.getSortData((OrgUnitCollection)orgCol);
                storageInfo = (StorageOrgUnitInfo)orgCol.get(0);
                if (storageInfo != null) {
                    isInStorageF7 = idSet.contains(storageInfo.getId().toString());
                }
            }
            if (storageInfo != null && isInStorageF7) {
                if (saleInfo != null) {
                    this.defaultDelegatedOrgMap.put(saleInfo.getId().toString(), (OrgUnitInfo)storageInfo);
                }
                if (purchaseInfo != null) {
                    this.defaultDelegatedOrgMap.put(purchaseInfo.getId().toString(), (OrgUnitInfo)storageInfo);
                }
                return storageInfo;
            }
            if (saleInfo != null) {
                this.defaultDelegatedOrgMap.put(saleInfo.getId().toString(), null);
            }
            if (purchaseInfo != null) {
                this.defaultDelegatedOrgMap.put(purchaseInfo.getId().toString(), null);
            }
        }
        if (!CollectionUtil.isEmpty(orgCol2)) {
            return orgCol2.get(0);
        }
        return null;
    }

    protected final String getCacheParameter(String parameter) {
        return (String)this.parametersMap.get(parameter);
    }

    public boolean isParam(String paramNumber, boolean defaultValue) throws EASBizException, BOSException {
        boolean paramValue = defaultValue;
        String strParamValue = this.getCacheParameter(paramNumber);
        if ("true".equalsIgnoreCase(strParamValue)) {
            paramValue = true;
        } else if ("false".equalsIgnoreCase(strParamValue)) {
            paramValue = false;
        }
        return paramValue;
    }

    private Map batchGetParamValue(Context ctx, String purId, PurContractInfo info) throws EASBizException, BOSException {
        PurchaseOrgUnitInfo pur = new PurchaseOrgUnitInfo();
        pur.setId(BOSUuid.read((String)purId));
        SCMBizDataVO vo = new SCMBizDataVO(OrgType.Purchase, (OrgUnitInfo)pur, 19, UserFactory.getLocalInstance((Context)ctx).getUserInfo(ctx.getCaller()), null);
        vo.setParameters(new String[]{"PURSUP001", "PURORDER004", "PURSUP004", "PURSUP009", "PURORDERALTER2", "REPURORDERALTER2", "PURAGRE001", "PURSUP008", "PURORDER002", "PURFIELD001", "PURJICHU001", "PURORDER001", "PURSUP007", "PURORDER100", "PURORDER003"});
        vo.setBOSType("78B50853");
        vo.setFirstLoading(true);
        SCMBizDataVO bizDataVO = SCMGroupFacadeFactory.getLocalInstance((Context)ctx).loadSCMBizDataVO(vo);
        HashMap paramMap = bizDataVO.getParametersMap();
        if (null != info && null != paramMap) {
            boolean botpBillAllowAddEntry = SCMUtil.getBotpBillAllowAddEntry((Context)ctx, (SCMBillBaseInfo)info, (OrgType)this.getMainOrgType(), (BOSUuid)info.getPurOrgUnit().getId());
            paramMap.put("botpBillAllowAddEntry", botpBillAllowAddEntry);
        }
        return paramMap;
    }

    protected Boolean isBizTypeValid(Context ctx, IObjectValue model, String billTypeID, BizTypeInfo bizTypeInfo) throws BOSException {
        return this.isBizTypeValid(ctx, model, billTypeID, bizTypeInfo, true);
    }

    public Boolean isBizTypeValid(Context ctx, IObjectValue model, String billTypeID, BizTypeInfo bizTypeInfo, boolean isAddNew) throws BOSException {
        int i;
        int size;
        FilterInfo filter = new FilterInfo();
        if (!StringUtil.isEmpty((String)billTypeID)) {
            filter.getFilterItems().add(new FilterItemInfo("billType.id", (Object)billTypeID, CompareType.EQUALS));
        }
        if (isAddNew) {
            filter.getFilterItems().add(new FilterItemInfo("selfmade", (Object)1, CompareType.EQUALS));
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        BillBizTypeCollection col = BillBizTypeFactory.getLocalInstance((Context)ctx).getBillBizTypeCollection(view);
        StringBuffer ids = new StringBuffer();
        if (!CollectionUtil.isEmpty((AbstractObjectCollection)col)) {
            BillBizTypeInfo info = null;
            size = col.size();
            for (i = 0; i < size; ++i) {
                info = (BillBizTypeInfo)col.getObject(i);
                ids.append(info.getBizType().getId().toString()).append(",");
            }
            if (ids.length() > 0) {
                ids.deleteCharAt(ids.length() - 1);
            }
        }
        if (ids.length() > 0) {
            view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids.toString(), CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("status", (Object)1));
            view.setFilter(filter);
            BizTypeCollection bizCol = BizTypeFactory.getLocalInstance((Context)ctx).getBizTypeCollection(view);
            size = bizCol.size();
            for (i = 0; i < size; ++i) {
                if (!bizCol.get(i).getId().toString().equals(bizTypeInfo.getId().toString())) continue;
                return true;
            }
        }
        return false;
    }

    public static Date addDate(Date curDate, int dateField, int delta) {
        Calendar calender = Calendar.getInstance();
        if (curDate != null) {
            calender.setTime(curDate);
        }
        calender.add(dateField, delta);
        return calender.getTime();
    }

    public static Date getEndDate(Date d) {
        if (d == null) {
            d = PurContractWebFacadeControllerBean.getServerDate();
        }
        return PurContractWebFacadeControllerBean.getFilterDate(d, KEY_ENDDATE);
    }

    public static Timestamp getFilterDate(Date d, String s) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(d);
        if (s.equalsIgnoreCase(KEY_STARTDATE)) {
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        } else if (s.equalsIgnoreCase(KEY_ENDDATE)) {
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
        }
        return new Timestamp(calendar.getTimeInMillis());
    }

    public static Date getServerDate() {
        return PurContractWebFacadeControllerBean.getServerTimestamp();
    }

    public static Timestamp getServerTimestamp() {
        try {
            ISCMBillCommonFacade iSCMBillCommonFacade = SCMBillCommonFacadeFactory.getRemoteInstance();
            return iSCMBillCommonFacade.getServerDate();
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    private String getPurOrgFilter(Context ctx) throws BOSException, EASBizException {
        IPermission iPerm = PermissionFactory.getLocalInstance((Context)ctx);
        FullOrgUnitCollection fullOrgColl = iPerm.getAuthorizedOrg(ctx.getCaller(), OrgType.Purchase, null, "purcontract_addnew");
        OrgUnitCollection purOrgColl = new OrgUnitCollection();
        for (int i = 0; i < fullOrgColl.size(); ++i) {
            purOrgColl.add((OrgUnitInfo)fullOrgColl.get(i));
        }
        return this.getOrgFilterStr(ctx, purOrgColl);
    }

    private AdminOrgUnitInfo getAdminOrgUnit(Context ctx, OrgUnitInfo org) throws BOSException, EASBizException {
        IOrgUnitRelation iour = OrgUnitRelationFactory.getRemoteInstance();
        OrgUnitCollection ioc = iour.getToUnit(((PurchaseOrgUnitInfo)org).getId().toString(), 3, 0);
        if (ioc.size() >= 1) {
            return (AdminOrgUnitInfo)ioc.get(0);
        }
        return null;
    }

    public String getDeliverAddF7Filter(Context ctx, String orgid) throws EASBizException, BOSException {
        FilterInfo filterInfo = null;
        FullOrgUnitInfo orgInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgid));
        String cuid = orgInfo.getCU().getId().toString();
        filterInfo = AddressFactory.getLocalInstance((Context)ctx).getDatabaseDFilter((IObjectPK)new ObjectUuidPK(cuid), "id", "CU.id");
        if (filterInfo == null) {
            filterInfo = new FilterInfo();
        }
        return filterInfo.toString();
    }

    public String gettrackNumberF7Filter(Context ctx, String orgid) throws EASBizException, BOSException {
        FilterInfo filterInfo = null;
        FullOrgUnitInfo orgInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgid));
        String cuid = orgInfo.getCU().getId().toString();
        filterInfo = TrackNumberFactory.getLocalInstance((Context)ctx).getDatabaseDFilter((IObjectPK)new ObjectUuidPK(cuid), "id", "CU.id");
        if (filterInfo == null) {
            filterInfo = new FilterInfo();
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)10, CompareType.EQUALS));
        return filterInfo.toString();
    }

    public String getProjectF7Filter(Context ctx, String orgid) throws EASBizException, BOSException {
        FilterInfo filterInfo = null;
        FullOrgUnitInfo orgInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgid));
        String cuid = orgInfo.getCU().getId().toString();
        filterInfo = ProjectFactory.getLocalInstance((Context)ctx).getDatabaseDFilter((IObjectPK)new ObjectUuidPK(cuid), "id", "CU.id");
        if (filterInfo == null) {
            filterInfo = new FilterInfo();
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)4, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("isTemplate", (Object)false, CompareType.EQUALS));
        return filterInfo.toString();
    }

    public String getPaymentConditionFilter(String companyID) {
        if (companyID == null) {
            return null;
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("createOrg.id", (Object)companyID, CompareType.EQUALS));
        StringBuffer sb = new StringBuffer();
        sb.append(" select FPayConditionID from T_BD_PayConditionReference ");
        sb.append("where (FAssignCompanyID = '");
        sb.append(companyID);
        sb.append("') ");
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)sb.toString(), CompareType.INNER));
        filterInfo.setMaskString("#0 OR #1");
        return filterInfo.toString();
    }

    protected Map _handleBillByOprtState(Context ctx, String billId, String oprtState) throws BOSException, EASBizException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (OprtStateConstant.VIEW.equalsIgnoreCase(oprtState)) {
            ExchangeRateInfo tempexrateinfo;
            PurContractInfo info = this.getPurContractInfo(ctx, billId);
            CompanyOrgUnitInfo company = this.getCompanyByPurchaseOrgUnit(ctx, (OrgUnitInfo)info.getPurOrgUnit());
            CurrencyInfo currencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(company.getBaseCurrency().getId()));
            map.put("baseCurrency", currencyInfo);
            if (null != info.getCurrency() && (tempexrateinfo = this.getExchange(company.getId().toString(), info.getCurrency().getId().toString(), currencyInfo.getId().toString())) != null) {
                map.put("exchangerateprecision", tempexrateinfo.getExchangeAux().getPrecision());
            }
        }
        return map;
    }

    public PurContractInfo getPurContractInfo(Context ctx, String billID) throws EASBizException, BOSException {
        return PurContractFactory.getLocalInstance(ctx).getPurContractInfo((IObjectPK)new ObjectUuidPK(billID));
    }

    private CompanyOrgUnitInfo getCompanyByPurchaseOrgUnit(Context ctx, OrgUnitInfo purInfo) throws BOSException {
        if (purInfo != null) {
            OrgUnitCollection orgUnitCollection = null;
            CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
            try {
                IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
                orgUnitCollection = iOrgUnitRelation.getToUnit(purInfo.getId().toString(), 3, 1);
                if (orgUnitCollection.size() > 0) {
                    company = (CompanyOrgUnitInfo)orgUnitCollection.get(0);
                }
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            return company;
        }
        return null;
    }

    private ExchangeRateInfo getExchange(String orgid, String srcCurrid, String destCurrid) throws EASBizException, BOSException {
        CompanyOrgUnitInfo ficompanyOrgInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgid));
        if (!destCurrid.equals(srcCurrid)) {
            ObjectUuidPK excTablepk = null;
            ObjectUuidPK sourceCurrPK = null;
            ObjectUuidPK destCurrPK = null;
            ExchangeTableInfo baseExchangeTableInfo = ficompanyOrgInfo.getBaseExchangeTable();
            if (baseExchangeTableInfo == null) {
                CompanyOrgUnitInfo icomUnit = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(ficompanyOrgInfo.getId()));
                baseExchangeTableInfo = icomUnit.getBaseExchangeTable();
            }
            if (baseExchangeTableInfo == null) {
                throw new PurOrderException(PurOrderException.EXCHANGETABLENULL);
            }
            excTablepk = new ObjectUuidPK(baseExchangeTableInfo.getId());
            sourceCurrPK = new ObjectUuidPK(srcCurrid);
            destCurrPK = new ObjectUuidPK(destCurrid);
            IExchangeRate iexchangRate = ExchangeRateFactory.getRemoteInstance();
            ExchangeRateInfo tempexrateinfo = iexchangRate.getExchangeRate((IObjectPK)excTablepk, (IObjectPK)sourceCurrPK, (IObjectPK)destCurrPK, Calendar.getInstance().getTime());
            return tempexrateinfo;
        }
        return null;
    }
}

