/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.scm.common.ExpenseItemFactory;
import com.kingdee.eas.basedata.scm.common.ExpenseItemInfo;
import com.kingdee.eas.basedata.scm.common.IExpenseItem;
import com.kingdee.eas.basedata.scm.common.IReasonCode;
import com.kingdee.eas.basedata.scm.common.ReasonCodeCollection;
import com.kingdee.eas.basedata.scm.common.ReasonCodeFactory;
import com.kingdee.eas.basedata.scm.common.ReasonCodeInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.common.SettlementStateEnum;
import com.kingdee.eas.scm.sm.pur.IPurExpenseInvoice;
import com.kingdee.eas.scm.sm.pur.PurExpenseInvoiceCollection;
import com.kingdee.eas.scm.sm.pur.PurExpenseInvoiceEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurExpenseInvoiceEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurExpenseInvoiceEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurExpenseInvoiceFactory;
import com.kingdee.eas.scm.sm.pur.PurExpenseInvoiceInfo;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import java.math.BigDecimal;
import java.util.Hashtable;
import java.util.List;

public class PurExpenseInvoiceEntryDataImport
extends AbstractDataTransmission {
    String[] BIGDECIMAL_FIELDS = new String[]{"FQty", "FPrice", "FAmount", "FLocalAmount", "FTaxRate", "FTax", "FLocalTax", "FNonTaxAmount", "FLocalNonTaxAmount"};
    String[] BIGDECIMAL_OBJ = new String[]{"qty", "price", "amount", "localAmount", "taxRate", "tax", "localTax", "nonTaxAmount", "localNonTaxAmount"};
    String[] STRING_FIELDS = new String[]{"FRemark"};
    String[] STRING_OBJS = new String[]{"remark"};
    String[] ENUM_FIELDS = new String[]{"FSettlementStatus"};
    String[] ENUM_OBJS = new String[]{"settlementStatus"};
    String[] INTEGER_FIELDS = new String[]{"FSeq"};
    String[] INTEGER_OBJS = new String[]{"seq"};

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return PurExpenseInvoiceEntryFactory.getLocalInstance(ctx);
        }
        catch (BOSException bex) {
            throw new TaskExternalException("", (Throwable)bex);
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        ICoreBase ipurExpenseInvoiceEntry = this.getController(ctx);
        try {
            if (coreBaseInfo.getId() == null || !ipurExpenseInvoiceEntry.exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
                ipurExpenseInvoiceEntry.addnew(coreBaseInfo);
            } else {
                ipurExpenseInvoiceEntry.update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        Object value;
        Object o;
        int i;
        PurExpenseInvoiceEntryInfo entryInfo;
        block17: {
            entryInfo = new PurExpenseInvoiceEntryInfo();
            try {
                Object data = ((DataToken)hsData.get((Object)"FPurExpenseInvoiceID")).data;
                if (data != null) {
                    String str = data.toString();
                    if (str != null && str.trim().length() > 0) {
                        IPurExpenseInvoice ipurExpenseInvoice = PurExpenseInvoiceFactory.getLocalInstance(ctx);
                        PurExpenseInvoiceCollection collection = ipurExpenseInvoice.getPurExpenseInvoiceCollection("where number ='" + str + "'");
                        if (collection == null || collection.size() == 0) {
                            throw new TaskExternalException("the PurInvoice  not found in database!!!!");
                        }
                        PurExpenseInvoiceInfo purExpenseInvoiceInfo = collection.get(0);
                        PurExpenseInvoiceEntryCollection entryCollection = purExpenseInvoiceInfo.getEntries();
                        entryInfo.setParent(purExpenseInvoiceInfo);
                        if (entryCollection != null && entryCollection.size() > 0) {
                            entryInfo.setSeq(this.getMaxRowNum(entryCollection));
                        } else {
                            entryInfo.setSeq(1);
                        }
                    }
                    break block17;
                }
                throw new TaskExternalException("FPurReturnsID  not found!");
            }
            catch (BOSException bex) {
                Logger.error((Throwable)bex);
                throw new TaskExternalException("process purReturnsid  error!");
            }
        }
        for (i = 0; i < this.BIGDECIMAL_FIELDS.length; ++i) {
            try {
                o = ((DataToken)hsData.get((Object)this.BIGDECIMAL_FIELDS[i])).data;
                if (o == null || o.toString().trim().length() <= 0 || (value = new BigDecimal(o.toString())) == null) continue;
                entryInfo.setBigDecimal(this.BIGDECIMAL_OBJ[i], (BigDecimal)value);
                continue;
            }
            catch (NumberFormatException nex) {
                Logger.error((Throwable)nex);
                throw new TaskExternalException(this.BIGDECIMAL_OBJ[i] + " format error, it must be a number!!!");
            }
        }
        for (i = 0; i < this.STRING_FIELDS.length; ++i) {
            o = ((DataToken)hsData.get((Object)this.STRING_FIELDS[i])).data;
            if (o == null) continue;
            value = o.toString();
            entryInfo.setString(this.STRING_OBJS[i], (String)value);
        }
        Object data = ((DataToken)hsData.get((Object)"FSettlementStatus")).data;
        String value2 = null;
        if (data != null && (value2 = data.toString()) != null) {
            entryInfo.setSettlementStatus(this.getSettlementStateValue(value2));
        }
        try {
            IMeasureUnit iunit;
            IExpenseItem iExpenseItem;
            ReasonCodeInfo info;
            IReasonCode iReasonCode;
            ReasonCodeCollection collection;
            data = ((DataToken)hsData.get((Object)"FReasonCodeID")).data;
            String str = null;
            if (data != null && (str = data.toString()) != null && str.length() > 0 && (collection = (iReasonCode = ReasonCodeFactory.getLocalInstance((Context)ctx)).getReasonCodeCollection("where number='" + str + "'")) != null && collection.size() > 0 && (info = collection.get(0)) != null) {
                entryInfo.setReasonCode(info);
            }
            if ((data = ((DataToken)hsData.get((Object)"FExpenseItemID")).data) != null && (str = data.toString()) != null && str.length() > 0 && (collection = (iExpenseItem = ExpenseItemFactory.getLocalInstance((Context)ctx)).getExpenseItemCollection("where number='" + str + "'")) != null && collection.size() > 0 && (info = collection.get(0)) != null) {
                entryInfo.setExpenseItem((ExpenseItemInfo)info);
            }
            if ((data = ((DataToken)hsData.get((Object)"FMeasureUnitID")).data) != null && (str = data.toString()) != null && str.trim().length() > 0 && (collection = (iunit = MeasureUnitFactory.getLocalInstance((Context)ctx)).getMeasureUnitCollection("where number='" + str + "'")) != null && collection.size() > 0 && (info = collection.get(0)) != null) {
                entryInfo.setMeasureUnit((MeasureUnitInfo)info);
            }
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
        return entryInfo;
    }

    private int getMaxRowNum(PurExpenseInvoiceEntryCollection entryCollection) {
        int max = 0;
        int temp = 0;
        int num = entryCollection.size();
        for (int i = 0; i < num; ++i) {
            PurExpenseInvoiceEntryInfo info = entryCollection.get(i);
            if (info == null || (temp = info.getSeq()) <= max) continue;
            max = temp;
        }
        return max;
    }

    private SettlementStateEnum getSettlementStateValue(String value) {
        SettlementStateEnum unsettled = SettlementStateEnum.UNSETTLED;
        if (value != null) {
            value = value.trim();
            List EnumList = SettlementStateEnum.getEnumList();
            int num = EnumList.size();
            for (int i = 0; i < num; ++i) {
                SettlementStateEnum enums = (SettlementStateEnum)EnumList.get(i);
                String enumValue = String.valueOf(enums.getValue());
                String enumName = enums.getName();
                String enumAlias = enums.getAlias();
                if (!enumValue.equalsIgnoreCase(value) && !enumName.equalsIgnoreCase(value) && !enumAlias.equalsIgnoreCase(value)) continue;
                unsettled = enums;
                break;
            }
        }
        return unsettled;
    }
}

