/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.server.QueryDataAccessFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.UseStatusEnum;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.basedata.scm.sd.sale.IPriceParam;
import com.kingdee.eas.basedata.scm.sd.sale.IPriceProvider;
import com.kingdee.eas.basedata.scm.sd.sale.PriceCondition;
import com.kingdee.eas.basedata.scm.sd.sale.PriceParamException;
import com.kingdee.eas.basedata.scm.sd.sale.PriceParamFactory;
import com.kingdee.eas.basedata.scm.sd.sale.PriceParamInfo;
import com.kingdee.eas.basedata.scm.sd.sale.PricePolicyException;
import com.kingdee.eas.basedata.scm.sd.sale.PriceProviderFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.app.SCMGroupServerUtils;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.im.inv.TransferRule2Collection;
import com.kingdee.eas.scm.im.inv.TransferRule2Factory;
import com.kingdee.eas.scm.im.inv.TransferRule2Info;
import com.kingdee.eas.scm.sm.pur.PurInnerDealPriceCollection;
import com.kingdee.eas.scm.sm.pur.PurInnerDealPriceInfo;
import com.kingdee.eas.scm.sm.pur.SettlementRouteEntryInfo;
import com.kingdee.eas.scm.sm.pur.SettlementSteps;
import com.kingdee.eas.scm.sm.pur.app.AbstractPurInnerDealPriceControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PurInnerDealPriceControllerBean
extends AbstractPurInnerDealPriceControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sm.pur.app.PurInnerDealPriceControllerBean");
    private static BigDecimal DEFAULT_NUM = new BigDecimal("0");
    private static BigDecimal ONE_NUM = new BigDecimal("1");

    @Override
    protected IObjectValue _getInnerDealPrice(Context ctx, String purorderid, String purorderentryid) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("purOrder.id", (Object)purorderid, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("purOrderEntry.id", (Object)purorderentryid, CompareType.EQUALS));
        view.setFilter(filter);
        PurInnerDealPriceCollection collection = this.getPurInnerDealPriceCollection(ctx, view);
        if (collection.size() > 0) {
            return collection.get(0);
        }
        return null;
    }

    @Override
    protected IObjectCollection _getInnerDealPrice(Context ctx, String orderID) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("purOrder.id", (Object)orderID, CompareType.EQUALS));
        view.setFilter(filter);
        return this.getPurInnerDealPriceCollection(ctx, view);
    }

    @Override
    protected IObjectCollection _getInnerDealPrice(Context ctx, String[] orderIDs) throws BOSException, EASBizException {
        if (orderIDs == null || orderIDs.length < 1) {
            return null;
        }
        int length = orderIDs.length;
        StringBuffer sqlStr = new StringBuffer("where purOrder.id in (");
        sqlStr.append("'");
        sqlStr.append(orderIDs[0]);
        sqlStr.append("'");
        for (int i = 1; i < length; ++i) {
            sqlStr.append(", '");
            sqlStr.append(orderIDs[i]);
            sqlStr.append("'");
        }
        sqlStr.append(")");
        return this.getPurInnerDealPriceCollection(ctx, sqlStr.toString());
    }

    @Override
    protected IObjectValue _getInnerDealPrice(Context ctx, String orderID, String orderEntryID, String routeID, String routeNodeID) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("purOrder.id", (Object)orderID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("purOrderEntry.id", (Object)orderEntryID, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("routeEntry.id", (Object)routeNodeID, CompareType.EQUALS));
        view.setFilter(filter);
        PurInnerDealPriceCollection purInnerDealPriceCollection = this.getPurInnerDealPriceCollection(ctx, view);
        if (purInnerDealPriceCollection != null && purInnerDealPriceCollection.size() != 0) {
            return purInnerDealPriceCollection.get(0);
        }
        return null;
    }

    @Override
    protected IObjectCollection _getInnerDealPrice(Context ctx, String[] orderEntryIDs, String routeNodeID) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("purOrderEntry.id", (Object)this.convertStringArrayToString(orderEntryIDs), CompareType.INCLUDE));
        if (routeNodeID != null) {
            filter.getFilterItems().add(new FilterItemInfo("routeEntry.id", (Object)routeNodeID, CompareType.EQUALS));
        }
        view.setFilter(filter);
        return this.getPurInnerDealPriceCollection(ctx, view);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _caculateInnerDealPrice(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        Connection con = null;
        Statement statement = null;
        try {
            con = this.getConnection(ctx);
            statement = con.createStatement();
            StringBuffer sql = new StringBuffer();
            String params = this.convertToString(pks);
            sql.append("select distinct po.fid id,pe.fid entryid,po.FPurchaseOrgUnitID purOrgUntiID,");
            sql.append("po.FCompanyOrgUnitID companyOrgUntiID,po.FCurrencyID currencyid,");
            sql.append("pe.FMaterialID materialid,pe.FUnitID unitid,pe.FBaseUnitID baseunitid,pe.FAssistPropertyID assistProperyID,");
            sql.append("cus.fid customerid,pe.FQty qty,pe.FTaxRate taxrate,pe.FPrice price,0 discounttype,");
            sql.append("pe.FDiscountRate discount,pe.FActualPrice actualprice,pe.FActualTaxPrice actualtaxprice,");
            sql.append("pe.FTaxPrice taxprice,material.FPricePrecision priceprecision,");
            sql.append("po.FStorageOrgUnitID issuestorageorgunitid,pe.FStorageOrgUnitID recievestorageorgunitid,");
            sql.append("po.CFSettlementRelation settlementRelation,");
            sql.append("case when po.CFSettlementRelation=3 then  po.CFSETTLEDPRO1ID \n");
            sql.append("when po.CFSettlementRelation=4 then po.CFSETTLEDPRO2ID \n");
            sql.append("else po.CFSETTLEDPROID end as settlementProgram \n");
            sql.append(" from T_SM_PurOrder po ");
            sql.append(" inner join T_SM_PurOrderEntry pe on pe.FParentID = po.FID ");
            sql.append(" inner join T_BD_Customer cus on cus.FInternalCompanyID = pe.FCompanyOrgUnitID ");
            sql.append(" inner join T_BD_Material material on pe.FMaterialID = material.FID ");
            sql.append(" where po.FID in(");
            sql.append(params);
            sql.append(") and po.FIsCentralBalance = 1 and pe.FIsBetweenCompanyRec = 1 ");
            statement.executeUpdate(" delete T_SM_PurInnerDealPrice where FPurOrderID in(" + params + ")");
            ResultSet result = statement.executeQuery(sql.toString());
            this.insertPurInnerDealPrice(ctx, con, result, pks);
        }
        catch (SQLException er) {
            try {
                throw new BOSException("sql Execute Error :", (Throwable)er);
                catch (PricePolicyException e) {
                    throw new BOSException((Throwable)e);
                }
                catch (BOSException e) {
                    throw new BOSException((Throwable)e);
                }
                catch (PriceParamException e) {
                    throw new BOSException((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)con);
                SQLUtils.cleanup((Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)con);
        SQLUtils.cleanup((Connection)con);
    }

    private void insertPurInnerDealPrice(Context ctx, Connection con, ResultSet result, IObjectPK[] pks) throws SQLException, BOSException, EASBizException {
        Statement batchStatement = con.createStatement();
        IPriceProvider iProvider = PriceProviderFactory.getLocalInstance((Context)ctx);
        IPriceParam iPriceParam = PriceParamFactory.getLocalInstance((Context)ctx);
        PriceCondition priceCondition = new PriceCondition();
        CustomerInfo customerInfo = new CustomerInfo();
        MaterialInfo materialInfo = new MaterialInfo();
        CurrencyInfo currencyInfo = new CurrencyInfo();
        CompanyOrgUnitInfo companyOrgInfo = new CompanyOrgUnitInfo();
        Calendar cal = Calendar.getInstance();
        Timestamp ts = new Timestamp(cal.getTimeInMillis());
        String customerID = null;
        String companyOrgID = null;
        priceCondition.setCustomerInfo(customerInfo);
        priceCondition.setMaterialInfo(materialInfo);
        priceCondition.setCompanyOrg(companyOrgInfo);
        priceCondition.setCurrencyInfo(currencyInfo);
        priceCondition.setCurDate((Date)ts);
        priceCondition.setPriceTypeID("00000000-0000-0000-0000-0000000000036A61CE8D");
        StringBuffer insertStr = new StringBuffer();
        String insertSql = " insert T_SM_PurInnerDealPrice(FID,FPurOrderID,FPurOrderEntryID,FUnitID,FBaseUnitID,FPrice,FDiscountMode,FDiscount,FActuralPrice ,FTaxRate,FTaxPrice,FActualTaxPrice,FSettlementRouteID,FRouteEntryID) values(newbosid('6C5E091B'),";
        BigDecimal addRate = DEFAULT_NUM;
        HashMap orderSettlementStepsMap = new HashMap();
        HashMap<String, String> customsMap = new HashMap<String, String>();
        SettlementSteps settlementSteps = new SettlementSteps(ctx, this.convertToStringArray(pks));
        orderSettlementStepsMap = settlementSteps.getOrdersSettlementStepsMap();
        SettlementSteps.SimpleSettlementStep simpleSettlement = null;
        SettlementRouteEntryInfo settlementRouteEntryInfo = null;
        while (result.next()) {
            int steps;
            String orgUnitID = result.getString("purOrgUntiID");
            if (null == result.getObject("settlementRelation") || result.getInt("settlementRelation") <= 2) {
                TransferRule2Info ruleInfo;
                boolean isStartParam = this.isStartInnerPricePoly(ctx, orgUnitID);
                boolean isCostAdd = false;
                String recieveStorageId = result.getString("recievestorageorgunitid");
                String issueStorageId = result.getString("issuestorageorgunitid");
                if (isStartParam && (ruleInfo = this.getTransferRule(ctx, issueStorageId, recieveStorageId)) != null) {
                    isCostAdd = ruleInfo.isIssueIsCostBalance();
                    addRate = ruleInfo.getIssueCostRate();
                }
                insertStr.delete(0, insertStr.length());
                insertStr.append(insertSql);
                insertStr.append("'");
                insertStr.append(result.getString("id") + "','" + result.getString("entryid") + "'");
                insertStr.append(",'" + result.getString("unitid") + "'");
                insertStr.append(",'" + result.getString("baseunitid") + "'");
                if (isStartParam && isCostAdd) {
                    this.caculateInnerDealPriceByCostAdd(addRate, result, insertStr);
                } else {
                    priceCondition.getCustomerInfo().setId(BOSUuid.read((String)result.getString("customerid")));
                    priceCondition.getCompanyOrg().setId(BOSUuid.read((String)result.getString("companyOrgUntiID")));
                    priceCondition.getMaterialInfo().setId(BOSUuid.read((String)result.getString("materialid")));
                    priceCondition.setMeasureUnit(result.getString("unitid"));
                    priceCondition.setOrderQty(result.getBigDecimal("qty"));
                    priceCondition.getCurrencyInfo().setId(BOSUuid.read((String)result.getString("currencyid")));
                    this.caculateInnerDealPriceByPolicy(ctx, result, priceCondition, iProvider, iPriceParam, insertStr);
                }
                if (null == result.getObject("settlementProgram")) {
                    insertStr.append(",null,null )");
                } else {
                    int steps2;
                    settlementSteps.initSettlementSteps(result.getString("id"), (HashMap)orderSettlementStepsMap.get(result.getString("id")));
                    if (settlementSteps == null) {
                        settlementSteps = new SettlementSteps(ctx, result.getString("id"));
                        orderSettlementStepsMap.put(result.getString("id"), settlementSteps);
                    }
                    if ((steps2 = settlementSteps.getStepCount()) == 0) continue;
                    simpleSettlement = settlementSteps.getFirstStep();
                    settlementRouteEntryInfo = simpleSettlement.getArInfo();
                    insertStr.append(",'").append(settlementRouteEntryInfo.getParent().getId().toString());
                    insertStr.append("','").append(settlementRouteEntryInfo.getId().toString()).append("')");
                }
                batchStatement.addBatch(insertStr.toString());
                continue;
            }
            settlementSteps.initSettlementSteps(result.getString("id"), (HashMap)orderSettlementStepsMap.get(result.getString("id")));
            if (settlementSteps == null) {
                settlementSteps = new SettlementSteps(ctx, result.getString("id"));
                orderSettlementStepsMap.put(result.getString("id"), settlementSteps);
            }
            if ((steps = settlementSteps.getStepCount()) == 0) continue;
            priceCondition.getMaterialInfo().setId(BOSUuid.read((String)result.getString("materialid")));
            priceCondition.setMeasureUnit(result.getString("unitid"));
            priceCondition.setOrderQty(result.getBigDecimal("qty"));
            priceCondition.getCurrencyInfo().setId(BOSUuid.read((String)result.getString("currencyid")));
            for (int i = 1; i <= steps; ++i) {
                insertStr.delete(0, insertStr.length());
                insertStr.append(insertSql);
                insertStr.append("'");
                insertStr.append(result.getString("id") + "','" + result.getString("entryid") + "'");
                insertStr.append(",'" + result.getString("unitid") + "'");
                insertStr.append(",'" + result.getString("baseunitid") + "'");
                simpleSettlement = settlementSteps.getSettlementStepByLevel(i);
                settlementRouteEntryInfo = simpleSettlement.getApInfo();
                companyOrgID = settlementRouteEntryInfo.getCompanyOrgUnit().getId().toString();
                customerID = customsMap.get(companyOrgID) != null ? (String)customsMap.get(companyOrgID) : this.getInnerCustomerInfo(ctx, settlementRouteEntryInfo.getCompanyOrgUnit().getId().toString());
                customsMap.put(companyOrgID, customerID);
                priceCondition.getCustomerInfo().setId(BOSUuid.read((String)customerID));
                settlementRouteEntryInfo = simpleSettlement.getArInfo();
                companyOrgInfo = settlementRouteEntryInfo.getCompanyOrgUnit();
                priceCondition.getCompanyOrg().setId(companyOrgInfo.getId());
                this.caculateInnerDealPriceByPolicy(ctx, result, priceCondition, iProvider, iPriceParam, insertStr);
                insertStr.append(",'").append(settlementRouteEntryInfo.getParent().getId().toString());
                insertStr.append("','").append(settlementRouteEntryInfo.getId().toString()).append("')");
                batchStatement.addBatch(insertStr.toString());
            }
        }
        batchStatement.executeBatch();
    }

    private void caculateInnerDealPriceByCostAdd(BigDecimal addRate, ResultSet result, StringBuffer insertStr) throws SQLException {
        int precision = result.getInt("priceprecision");
        BigDecimal actualPrice = DEFAULT_NUM.setScale(precision, 4);
        BigDecimal price = DEFAULT_NUM.setScale(precision, 4);
        addRate = addRate.multiply(new BigDecimal("0.01"));
        actualPrice = result.getBigDecimal("actualprice");
        BigDecimal orderTaxRate = result.getBigDecimal("taxrate");
        if (orderTaxRate.unscaledValue().intValue() == 0) {
            orderTaxRate = DEFAULT_NUM;
        }
        BigDecimal taxPrice = DEFAULT_NUM.setScale(precision, 4);
        price = actualPrice.multiply(addRate.add(ONE_NUM)).setScale(precision, 4);
        taxPrice = actualPrice.multiply(orderTaxRate.multiply(new BigDecimal("0.01")).add(ONE_NUM));
        taxPrice = taxPrice.multiply(addRate.add(ONE_NUM)).setScale(precision, 4);
        insertStr.append(",").append(price);
        insertStr.append(",").append(0);
        insertStr.append(",0");
        insertStr.append(",").append(price);
        insertStr.append(",").append(orderTaxRate);
        insertStr.append(",").append(taxPrice);
        insertStr.append(",").append(taxPrice);
    }

    private void caculateInnerDealPriceByPolicy(Context ctx, ResultSet result, PriceCondition priceCondition, IPriceProvider iProvider, IPriceParam iPriceParam, StringBuffer insertStr) throws SQLException, BOSException, EASBizException {
        PriceParamInfo priceparamInfo = null;
        Map resultMap = iProvider.calculatePrice(priceCondition);
        if (resultMap.isEmpty()) {
            this.buildInnerPriceInsertStrByOrder(result, insertStr);
        } else {
            if (resultMap.get("keypriceType") != null && resultMap.get("keypriceType").toString().equals("basePrice")) {
                OrgUnitCollection orgUnitCollection = SCMGroupServerUtils.getOrgsByRelation((Context)ctx, (OrgType)OrgType.Company, (OrgType)OrgType.Sale, (String)priceCondition.getCompanyOrg().getId().toString());
                int c = orgUnitCollection.size();
                for (int i = 0; i < c; ++i) {
                    String cuid = orgUnitCollection.get(i).getId().toString();
                    PriceParamInfo tempInfo = iPriceParam.getParameter(cuid);
                    if (!tempInfo.isStartPriceDiscountM()) continue;
                    priceparamInfo = tempInfo;
                    break;
                }
            } else {
                priceparamInfo = iPriceParam.getParameter(resultMap.get("saleorgunit").toString());
            }
            this.buildInnerPriceInsertStrByPolicy(result, insertStr, priceparamInfo, resultMap);
        }
    }

    private void buildInnerPriceInsertStrByPolicy(ResultSet result, StringBuffer insertStr, PriceParamInfo priceparamInfo, Map resultMap) throws SQLException {
        BigDecimal HUNDRED_NUM = new BigDecimal("100");
        int precision = result.getInt("priceprecision");
        BigDecimal dPriceValue = DEFAULT_NUM.setScale(precision, 4);
        BigDecimal price = DEFAULT_NUM.setScale(precision, 4);
        BigDecimal discountValue = DEFAULT_NUM.setScale(precision, 4);
        BigDecimal taxrate = DEFAULT_NUM.setScale(precision, 4);
        BigDecimal actualTaxPrice = DEFAULT_NUM.setScale(precision, 4);
        BigDecimal actualPrice = DEFAULT_NUM.setScale(precision, 4);
        String priceValue = (String)resultMap.get("keyprice");
        dPriceValue = new BigDecimal(priceValue).setScale(precision, 4);
        if (dPriceValue.unscaledValue().intValue() == 0) {
            dPriceValue = DEFAULT_NUM;
        }
        String discountMode = (String)resultMap.get("keydiscountmode");
        String discount = (String)resultMap.get("keydiscountvalue");
        discountValue = new BigDecimal(discount);
        if (discountValue.unscaledValue().intValue() == 0) {
            discountValue = DEFAULT_NUM;
        }
        taxrate = result.getBigDecimal("taxrate").unscaledValue().intValue() == 0 ? DEFAULT_NUM : result.getBigDecimal("taxrate");
        BigDecimal transferTaxRate = taxrate.divide(HUNDRED_NUM, 10, 4).add(ONE_NUM);
        if (discountMode.equals("1")) {
            discountMode = "0";
            discountValue = discountValue.divide(dPriceValue, dPriceValue.scale(), 4).multiply(HUNDRED_NUM).setScale(dPriceValue.scale(), 4);
        }
        if (priceparamInfo != null && priceparamInfo.isContainTax()) {
            price = dPriceValue.divide(transferTaxRate, dPriceValue.scale(), 4);
            if (discountMode.equals("0")) {
                BigDecimal transferRate = HUNDRED_NUM.subtract(discountValue).divide(HUNDRED_NUM, 10, 4);
                actualPrice = price.multiply(transferRate).setScale(price.scale(), 4);
                actualTaxPrice = dPriceValue.multiply(transferRate).setScale(dPriceValue.scale(), 4);
            } else {
                actualPrice = price;
                actualTaxPrice = dPriceValue;
            }
            insertStr.append("," + price + "," + discountMode + "," + discountValue).append("," + actualPrice + "," + taxrate + "," + dPriceValue).append("," + actualTaxPrice);
        } else {
            price = dPriceValue.multiply(transferTaxRate).setScale(dPriceValue.scale(), 4);
            if (discountMode.equals("0")) {
                BigDecimal transferRate = HUNDRED_NUM.subtract(discountValue).divide(HUNDRED_NUM, 10, 4);
                actualPrice = dPriceValue.multiply(transferRate).setScale(dPriceValue.scale(), 4);
                actualTaxPrice = price.multiply(transferRate).setScale(price.scale(), 4);
            } else {
                actualPrice = dPriceValue;
                actualTaxPrice = price;
            }
            insertStr.append("," + dPriceValue + "," + discountMode + "," + discountValue).append("," + actualPrice + "," + taxrate + "," + price).append("," + actualTaxPrice);
        }
    }

    private void buildInnerPriceInsertStrByOrder(ResultSet result, StringBuffer insertStr) throws SQLException {
        int precision = result.getInt("priceprecision");
        BigDecimal dPriceValue = DEFAULT_NUM.setScale(precision, 4);
        BigDecimal price = DEFAULT_NUM.setScale(precision, 4);
        BigDecimal discountValue = DEFAULT_NUM.setScale(precision, 4);
        BigDecimal taxrate = DEFAULT_NUM.setScale(precision, 4);
        BigDecimal actualTaxPrice = DEFAULT_NUM.setScale(precision, 4);
        BigDecimal actualPrice = DEFAULT_NUM.setScale(precision, 4);
        dPriceValue = result.getBigDecimal("price").unscaledValue().intValue() == 0 ? DEFAULT_NUM : result.getBigDecimal("price");
        discountValue = result.getBigDecimal("discount").unscaledValue().intValue() == 0 ? DEFAULT_NUM : result.getBigDecimal("discount");
        actualPrice = result.getBigDecimal("actualprice").unscaledValue().intValue() == 0 ? DEFAULT_NUM : result.getBigDecimal("actualprice");
        taxrate = result.getBigDecimal("taxrate").unscaledValue().intValue() == 0 ? DEFAULT_NUM : result.getBigDecimal("taxrate");
        price = result.getBigDecimal("taxprice").unscaledValue().intValue() == 0 ? DEFAULT_NUM : result.getBigDecimal("taxprice");
        actualTaxPrice = result.getBigDecimal("actualtaxprice").unscaledValue().intValue() == 0 ? DEFAULT_NUM : result.getBigDecimal("actualtaxprice");
        insertStr.append("," + dPriceValue + "," + result.getInt("discounttype") + "," + discountValue).append("," + actualPrice + "," + taxrate + "," + price).append("," + actualTaxPrice);
    }

    private String convertToString(Object[] objs) {
        if (objs == null || objs.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int count = objs.length;
        for (int i = 0; i < count; ++i) {
            if (objs[i] == null) continue;
            if (i > 0) {
                sb.append(",");
            }
            sb.append("'");
            sb.append(objs[i].toString());
            sb.append("'");
        }
        return sb.toString();
    }

    private String convertStringArrayToString(String[] objs) {
        if (objs == null || objs.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int count = objs.length;
        for (int i = 0; i < count; ++i) {
            if (objs[i] == null) continue;
            if (i > 0) {
                sb.append(",");
            }
            sb.append("'");
            sb.append(objs[i]);
            sb.append("'");
        }
        return sb.toString();
    }

    private String[] convertToStringArray(Object[] objs) {
        if (objs == null || objs.length == 0) {
            return null;
        }
        HashSet<String> idset = new HashSet<String>();
        int count = objs.length;
        for (int i = 0; i < count; ++i) {
            if (objs[i] == null) continue;
            idset.add(objs[i].toString());
        }
        return idset.toArray(new String[idset.size()]);
    }

    private boolean isStartInnerPricePoly(Context ctx, String orgUnitID) {
        boolean isParamValue = false;
        try {
            String paramValue;
            IParamControl paramControl = ParamControlFactory.getLocalInstance((Context)ctx);
            ObjectUuidPK orgUnitPK = null;
            if (orgUnitID != null) {
                orgUnitPK = new ObjectUuidPK(orgUnitID);
            }
            if ((paramValue = paramControl.getParamValue(orgUnitPK, "PURORDER102")) != null) {
                isParamValue = "true".equalsIgnoreCase(paramValue);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isParamValue;
    }

    private TransferRule2Info getTransferRule(Context ctx, String issueStorageId, String receiveStorageId) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        evi.setFilter(fi);
        fi.appendFilterItem("supplyRelation.issueStorageOrgUnit", (Object)issueStorageId);
        fi.appendFilterItem("supplyRelation.receiveStorageOrgUnit", (Object)receiveStorageId);
        fi.appendFilterItem("status", (Object)UseStatusEnum.ACTIVE);
        evi.getSelector().add("id");
        evi.getSelector().add("issueCostRate");
        evi.getSelector().add("issueIsCostBalance");
        evi.getSelector().add("issueSaleOrgUnit");
        TransferRule2Collection tr2Col = TransferRule2Factory.getLocalInstance((Context)ctx).getTransferRule2Collection(evi);
        if (tr2Col != null && tr2Col.size() > 0) {
            return tr2Col.get(0);
        }
        return null;
    }

    private String getInnerCustomerInfo(Context ctx, String companyOrgUnitId) throws EASBizException, BOSException {
        IObjectPK[] pkList = CustomerFactory.getLocalInstance((Context)ctx).getPKList("where internalCompany.id = '" + companyOrgUnitId + "'");
        if (pkList != null && pkList.length > 0) {
            return pkList[0].toString();
        }
        return null;
    }

    @Override
    protected void _batchSave(Context ctx, IObjectCollection objColl) throws BOSException, EASBizException {
        PurInnerDealPriceInfo info = null;
        ArrayList<String> sqls = new ArrayList<String>();
        StringBuilder sql = new StringBuilder();
        HashSet<String> numberSet = new HashSet<String>();
        int size = objColl.size();
        for (int i = 0; i < size; ++i) {
            info = (PurInnerDealPriceInfo)objColl.getObject(i);
            sql.setLength(0);
            sql.append("update T_SM_PurInnerDealPrice set ");
            sql.append(" fprice = ").append(SCMServerUtils.toPlainString((BigDecimal)info.getPrice())).append(",");
            sql.append(" ftaxprice = ").append(SCMServerUtils.toPlainString((BigDecimal)info.getTaxPrice())).append(",");
            sql.append(" ftaxrate = ").append(SCMServerUtils.toPlainString((BigDecimal)info.getTaxRate())).append(",");
            sql.append(" fdiscount = ").append(SCMServerUtils.toPlainString((BigDecimal)info.getDiscount())).append(",");
            if (info.getSupStorageOrg() == null) {
                sql.append(" FSupStorageOrgID = '',");
            } else {
                sql.append(" FSupStorageOrgID = '").append(info.getSupStorageOrg().getId().toString()).append("',");
            }
            if (info.getSupWareHouse() == null) {
                sql.append(" FSupWareHouseID = '',");
            } else {
                sql.append(" FSupWareHouseID = '").append(info.getSupWareHouse().getId().toString()).append("',");
            }
            if (info.getRecStorageOrg() == null) {
                sql.append(" FRecStorageOrgID = '',");
            } else {
                sql.append(" FRecStorageOrgID = '").append(info.getRecStorageOrg().getId().toString()).append("',");
            }
            if (info.getRecWareHouse() == null) {
                sql.append(" FRecWareHouseID = ''");
            } else {
                sql.append(" FRecWareHouseID = '").append(info.getRecWareHouse().getId().toString()).append("'");
            }
            sql.append(" where fid = '").append(info.getId().toString()).append("'");
            sqls.add(sql.toString());
            if (info.getPurOrder() == null || StringUtils.isEmpty((String)info.getPurOrder().getNumber())) continue;
            numberSet.add(info.getPurOrder().getNumber());
        }
        com.kingdee.eas.base.core.util.DbUtil.executeBatch((Context)ctx, sqls);
        this.writeLogs(ctx, numberSet);
    }

    private void writeLogs(Context ctx, Set<String> numberSet) {
        if (numberSet == null || numberSet.size() == 0) {
            return;
        }
        String number = "";
        Iterator<String> iterator = numberSet.iterator();
        while (iterator.hasNext()) {
            number = iterator.next().toString();
            IObjectPK pklog = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)new BOSObjectType("3171BFAD"), null, (String)number, (String)"purInnerDealPrice_edit");
            LogUtil.afterLog((Context)ctx, (IObjectPK)pklog);
        }
    }

    @Override
    protected IObjectCollection _getInnerDealPrice(Context ctx, Set orderEntryIds, String companyType, String companyId) throws BOSException, EASBizException {
        if (orderEntryIds == null || orderEntryIds.size() == 0 || StringUtils.isEmpty((String)companyId) || StringUtils.isEmpty((String)companyType)) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("purOrderEntry.id", (Object)orderEntryIds, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo(companyType, (Object)companyId));
        view.setFilter(filter);
        view.setSelector(this.getPurInnerDealPriceSelector());
        return this.getPurInnerDealPriceCollection(ctx, view);
    }

    private SelectorItemCollection getPurInnerDealPriceSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("price"));
        sic.add(new SelectorItemInfo("discountMode"));
        sic.add(new SelectorItemInfo("discount"));
        sic.add(new SelectorItemInfo("taxRate"));
        sic.add(new SelectorItemInfo("taxPrice"));
        sic.add(new SelectorItemInfo("exchangeRate"));
        sic.add(new SelectorItemInfo("purOrder.id"));
        sic.add(new SelectorItemInfo("purOrderEntry.id"));
        sic.add(new SelectorItemInfo("unit.id"));
        sic.add(new SelectorItemInfo("baseUnit.id"));
        sic.add(new SelectorItemInfo("recCompanyOrg.id"));
        sic.add(new SelectorItemInfo("recStorageOrg.id"));
        sic.add(new SelectorItemInfo("supCompanyOrg.id"));
        sic.add(new SelectorItemInfo("supStorageOrg.id"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("saleOrgUnit.id"));
        return sic;
    }

    @Override
    protected List<Object> _getInnerPriceForWeb(Context ctx, String entryIds, String id) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (StringUtils.isEmpty((String)entryIds) && !StringUtils.isEmpty((String)id)) {
            filter.getFilterItems().add(new FilterItemInfo("purOrder.id", (Object)id));
        } else {
            String[] ids = entryIds.split(",");
            HashSet<String> entryIdSet = new HashSet<String>();
            int size = ids.length;
            for (int i = 0; i < size; ++i) {
                entryIdSet.add(ids[i]);
            }
            filter.getFilterItems().add(new FilterItemInfo("purOrderEntry.id", entryIdSet, CompareType.INCLUDE));
        }
        view.setFilter(filter);
        MetaDataPK queryPK = MetaDataPK.create((String)"com.kingdee.eas.scm.sm.pur.app", (String)"PurInnerDealPriceQuery");
        String sql = QueryDataAccessFactory.getRemoteInstance().getQuerySql((IMetaDataPK)queryPK, view);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rs == null || rs.size() == 0) {
            return null;
        }
        HashMap<String, Object> objMap = null;
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            StorageOrgUnitInfo storageOrgUnitInfo = null;
            WarehouseInfo wareHouseInfo = null;
            while (rs.next()) {
                objMap = new HashMap<String, Object>();
                objMap.put("billId", rs.getString("ID"));
                objMap.put("number", rs.getString("PURORDER.NUMBER"));
                objMap.put("seq", rs.getInt("PURORDERENTRY.SEQ"));
                objMap.put("rowType", rs.getString("ROWTYPE.NAME"));
                objMap.put("material", rs.getString("MATERIAL.NUMBER"));
                objMap.put("materialName", rs.getString("MATERIAL.NAME"));
                objMap.put("unit", rs.getString("UNIT.NAME"));
                objMap.put("assistProperty", rs.getString("ASSISTPROPERTY.NAME"));
                objMap.put("price", rs.getBigDecimal("PRICE"));
                objMap.put("discount", rs.getBigDecimal("DISCOUNT"));
                objMap.put("taxRate", rs.getBigDecimal("TAXRATE"));
                objMap.put("taxPrice", rs.getBigDecimal("TAXPRICE"));
                objMap.put("supCompanyOrg", rs.getString("SUPCOMPANYORG.NAME"));
                objMap.put("supProfitCenter", rs.getString("SUPPROFITCENTER.NAME"));
                objMap.put("supStorageOrg", rs.getString("SUPSTORAGEORG.NAME"));
                objMap.put("supWareHouse", rs.getString("SUPWAREHOUSE.NAME"));
                objMap.put("recCompanyOrg", rs.getString("RECCOMPANYORG.NAME"));
                objMap.put("recProfitCenter", rs.getString("RECPROFITCENTER.NAME"));
                if (!StringUtils.isEmpty((String)rs.getString("RECSTORAGEORG.ID"))) {
                    storageOrgUnitInfo = new StorageOrgUnitInfo();
                    storageOrgUnitInfo.setId(BOSUuid.read((String)rs.getString("RECSTORAGEORG.ID")));
                    storageOrgUnitInfo.setNumber(rs.getString("RECSTORAGEORG.NUMBER"));
                    storageOrgUnitInfo.setName(rs.getString("RECSTORAGEORG.NAME"));
                } else {
                    storageOrgUnitInfo = null;
                }
                objMap.put("recStorageOrg", storageOrgUnitInfo);
                if (!StringUtils.isEmpty((String)rs.getString("RECWAREHOUSE.ID"))) {
                    wareHouseInfo = new WarehouseInfo();
                    wareHouseInfo.setId(BOSUuid.read((String)rs.getString("RECWAREHOUSE.ID")));
                    wareHouseInfo.setNumber(rs.getString("RECWAREHOUSE.NUMBER"));
                    wareHouseInfo.setName(rs.getString("RECWAREHOUSE.NAME"));
                } else {
                    wareHouseInfo = null;
                }
                objMap.put("recWareHouse", wareHouseInfo);
                objMap.put("settlementRule", rs.getString("SETTLEMENTRULE.NAME"));
                objMap.put("currency", rs.getString("CURRENCY.NAME"));
                if (rs.getBigDecimal("EXCHANGERATE").compareTo(BigDecimal.ONE) == 0) {
                    objMap.put("exchangeRate", BigDecimal.ONE);
                } else {
                    objMap.put("exchangeRate", rs.getBigDecimal("EXCHANGERATE").doubleValue());
                }
                objMap.put("orderId", rs.getString("PURORDER.ID"));
                objMap.put("orderEntryId", rs.getString("PURORDERENTRY.ID"));
                objMap.put("supCompanyOrgId", rs.getString("SUPCOMPANYORG.ID"));
                objMap.put("supStorageOrgId", rs.getString("SUPSTORAGEORG.ID"));
                objMap.put("supWareHouseId", rs.getString("SUPWAREHOUSE.ID"));
                objMap.put("recCompanyOrgId", rs.getString("RECCOMPANYORG.ID"));
                objMap.put("recStorageOrgId", rs.getString("RECSTORAGEORG.ID"));
                objMap.put("recWareHouseId", rs.getString("RECWAREHOUSE.ID"));
                objMap.put("status", rs.getInt("BASESTATUS"));
                objMap.put("pricePrecision", rs.getInt("PRICEPRECISION"));
                objMap.put("purchaseOrgUnitId", rs.getString("PURCHASEORGUNIT.ID"));
                list.add(objMap);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return list;
    }
}

