/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.ejb.BizController;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.ReasonCodeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.adv.chain.app.BusinessChainExecutorFactory;
import com.kingdee.eas.dynbusiness.adv.chain.app.IBusinessChainExecutor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ParamEntryExecuteContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.app.bizprocess.util.SCMBizProcessorUtil;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sm.pur.PurOrderChangeEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderChangeEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderChangeException;
import com.kingdee.eas.scm.sm.pur.PurOrderChangeFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderChangeInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import com.kingdee.eas.scm.sm.pur.PurReqException;
import com.kingdee.eas.scm.sm.pur.PurRequestFactory;
import com.kingdee.eas.scm.sm.pur.PurRequestInfo;
import com.kingdee.eas.scm.sm.pur.app.AbstractPurOrderChangeControllerBean;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import com.kingdee.eas.scm.util.SCMUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.BaseException;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class PurOrderChangeControllerBean
extends AbstractPurOrderChangeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sm.pur.app.PurOrderChangeControllerBean");
    private static final BigDecimal BIGZERO = new BigDecimal("0.00");

    protected String getBillTypeId() {
        return "uH2EQ39zT1yvvG7D+kbkk0Y+1VI=";
    }

    protected IObjectValue _createNewData(Context ctx, boolean isUseAgent) throws BOSException, EASBizException {
        PurOrderChangeInfo purOrderChangeInfo = new PurOrderChangeInfo();
        Date now = new Date();
        purOrderChangeInfo.setBizDate(now);
        purOrderChangeInfo.setCreateTime(new Timestamp(now.getTime()));
        BizTypeInfo staticBizTypeInfo = new BizTypeInfo();
        staticBizTypeInfo.setId(BOSUuid.read((String)"d8e80652-0106-1000-e000-04c5c0a812202407435C"));
        staticBizTypeInfo.setNumber("110");
        staticBizTypeInfo.setName(this.getServerResource("PURCHASEORG", ctx));
        purOrderChangeInfo.setBizType(staticBizTypeInfo);
        BillTypeInfo billTypeInfo = new BillTypeInfo();
        billTypeInfo.setId(BOSUuid.read((String)this.getBillTypeId()));
        billTypeInfo.setName(this.getServerResource("PURORDERCHANGE", ctx));
        billTypeInfo.setNumber("225");
        purOrderChangeInfo.setBillType(billTypeInfo);
        Calendar cal = Calendar.getInstance();
        Date curDate = cal.getTime();
        Timestamp ts = new Timestamp(cal.getTimeInMillis());
        purOrderChangeInfo.setCreateTime(ts);
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        purOrderChangeInfo.setCreator(userInfo);
        return purOrderChangeInfo;
    }

    public String getServerResource(String key, Context ctx) {
        return SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)key, (Context)ctx);
    }

    protected BatchActionResults batchExecute(Context ctx, BatchExecuteParamsEntry[] entries, BatchActionEnum batchActionEnum) throws EASBizException, BOSException {
        IBusinessChainExecutor executor = BusinessChainExecutorFactory.getBusinessChainExecutor();
        ParamEntryExecuteContext executeContext = new ParamEntryExecuteContext(ctx, this.getBOSType(), batchActionEnum, (BizController)this, entries);
        executeContext.setBillTypeID(this.getBillTypeId());
        BatchActionResults batchResults = executor.batchExecute((ExecuteContext)executeContext);
        if (batchResults == null) {
            batchResults = super.batchExecute(ctx, entries, batchActionEnum);
        }
        return batchResults;
    }

    public void batchExecute(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException, EASBizException {
        super.batchExecute(ctx, batchAction, batchResults);
    }

    public BatchActionResults batchSubmitRelations(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return super.batchSubmitRelations(ctx, entries);
    }

    public BatchActionResults batchSubmitOrSave(Context ctx, BatchExecuteParamsEntry[] entries, BatchActionEnum batchAction) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, batchAction);
    }

    protected void _submit(Context ctx, String id) throws BOSException, EASBizException {
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[1];
        Class[] parameterTypes = new Class[]{IObjectValue.class};
        PurOrderChangeInfo info = this.getPurOrderChangeInfo(ctx, (IObjectPK)new ObjectUuidPK(id), this.getSelector());
        entries[0] = new BatchExecuteParamsEntry(parameterTypes, new Object[]{info});
        this.batchExecute(ctx, entries, BatchActionEnum.SUBMIT);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (ctx.get((Object)"CONTEXT_KEY_CALLBACK_4_DAO") != null) {
            return super.submitWithoutBusiness(ctx, model);
        }
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class})};
        entries[0].add((Object)model);
        this.batchSubmitRelations(ctx, entries);
        return new ObjectUuidPK(((SCMBillBaseInfo)model).getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IObjectPK[] pks = new IObjectPK[]{pk};
        PurOrderChangeInfo model = PurOrderChangeFactory.getLocalInstance(ctx).getPurOrderChangeInfo(pk, this.getSelector());
        if (model.getBaseStatus() != BillBaseStatusEnum.SUBMITED) {
            throw new PurOrderChangeException(PurOrderChangeException.NO_SUBMIT_NO_AUDIT);
        }
        this.passAudit(ctx, pk, (CoreBillBaseInfo)model);
        PurOrderChangeEntryInfo entry = null;
        HashSet<String> purorderIDSet = new HashSet<String>();
        for (int i = 0; i < model.getEntries().size(); ++i) {
            entry = model.getEntries().get(i);
            purorderIDSet.add(entry.getPurOrder().getId().toString());
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo tmpFilter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo("sourceBillId"));
        tmpFilter.getFilterItems().add(new FilterItemInfo("parent.id", purorderIDSet, CompareType.INCLUDE));
        evi.setFilter(tmpFilter);
        evi.setSelector(sic);
        PurOrderEntryCollection orderEntrys = PurOrderEntryFactory.getLocalInstance(ctx).getPurOrderEntryCollection(evi);
        PurOrderEntryInfo orderEntry = null;
        HashSet<String> purrequestIdSet = new HashSet<String>();
        for (int i = 0; i < orderEntrys.size(); ++i) {
            orderEntry = orderEntrys.get(i);
            if (null == orderEntry.getSourceBillId()) continue;
            purrequestIdSet.add(orderEntry.getSourceBillId());
        }
        Connection con = null;
        PreparedStatement updateOrderChangeStatement = null;
        PreparedStatement updateRequestChangeStatement = null;
        if (null != purorderIDSet && purorderIDSet.size() > 0) {
            con = this.getConnection(ctx);
            String updateOrderChangeSql = "update T_SM_PurOrder set FChangeType = ? where Fid = ?";
            try {
                updateOrderChangeStatement = con.prepareStatement(updateOrderChangeSql);
                for (String orderid : purorderIDSet) {
                    updateOrderChangeStatement.setInt(1, 2);
                    updateOrderChangeStatement.setString(2, orderid);
                    updateOrderChangeStatement.addBatch();
                }
                updateOrderChangeStatement.executeBatch();
            }
            catch (SQLException sQLException) {
            }
            finally {
                SQLUtils.cleanup((Statement)updateOrderChangeStatement, (Connection)con);
                SQLUtils.cleanup((Connection)con);
            }
        }
        if (null != purrequestIdSet && purrequestIdSet.size() > 0) {
            con = this.getConnection(ctx);
            String updateRequestChangeSql = "update T_SM_PurRequest set FChangeType = ? where Fid = ?";
            try {
                updateRequestChangeStatement = con.prepareStatement(updateRequestChangeSql);
                for (String requestId : purorderIDSet) {
                    updateRequestChangeStatement.setInt(1, 2);
                    updateRequestChangeStatement.setString(2, requestId);
                    updateRequestChangeStatement.addBatch();
                }
                updateRequestChangeStatement.executeBatch();
            }
            catch (SQLException sQLException) {
            }
            finally {
                SQLUtils.cleanup((Statement)updateRequestChangeStatement, (Connection)con);
                SQLUtils.cleanup((Connection)con);
            }
        }
    }

    private BigDecimal getCommomBaseQty(PurOrderEntryInfo purOrderEntryInfo, BigDecimal approvalQty) throws EASBizException, BOSException {
        return SCMUtils.getExchangeQtyForClient((String)purOrderEntryInfo.getMaterial().getId().toString(), (MeasureUnitInfo)purOrderEntryInfo.getUnit(), (MeasureUnitInfo)purOrderEntryInfo.getBaseUnit(), (BigDecimal)approvalQty);
    }

    protected void _audit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        this.batchExecute(ctx, pks, BatchActionEnum.AUDIT);
    }

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class}, new Object[]{model})};
        this.batchExecute(ctx, entries, BatchActionEnum.AUDIT);
    }

    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[1];
        PurOrderChangeInfo info = this.getPurOrderChangeInfo(ctx, pk, this.getSelector());
        entries[0] = new BatchExecuteParamsEntry(new Class[]{IObjectValue.class}, new Object[]{info});
        this.batchExecute(ctx, entries, BatchActionEnum.UNAUDIT);
    }

    protected void _unAudit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        this.batchExecute(ctx, pks, BatchActionEnum.UNAUDIT);
    }

    public void _handleAfterTransform(Context ctx, String action, IObjectCollection collection) throws EASBizException, BOSException {
        super._handleAfterTransform(ctx, action, collection);
    }

    @Override
    protected void _cancel(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PurOrderChangeInfo info = (PurOrderChangeInfo)this.getValue(ctx, pk);
        this.checkBeforeCancel(ctx, info);
        this.passCancellation(ctx, info, null);
    }

    @Override
    protected void _cancelWithReason(Context ctx, IObjectPK pk, String reason) throws BOSException, EASBizException {
        PurOrderChangeInfo info = (PurOrderChangeInfo)this.getValue(ctx, pk);
        this.checkBeforeCancel(ctx, info);
        this.passCancellation(ctx, info, reason);
    }

    @Override
    protected void _cancelWithReason(Context ctx, IObjectPK pk, IObjectValue reason) throws BOSException, EASBizException {
        PurOrderChangeInfo info = (PurOrderChangeInfo)this.getValue(ctx, pk);
        this.checkBeforeCancel(ctx, info);
        this.passCancellation(ctx, info, reason);
    }

    @Override
    protected void _cancelWithReason(Context ctx, IObjectPK[] pks, String[] reasons) throws BOSException, EASBizException {
        int num = pks.length;
        for (int i = 0; i < num; ++i) {
            this._cancelWithReason(ctx, pks[i], reasons[0]);
        }
    }

    @Override
    protected void _cancelWithReason(Context ctx, IObjectPK[] pks, IObjectValue[] reasons) throws BOSException, EASBizException {
        int num = pks.length;
        for (int i = 0; i < num; ++i) {
            this._cancelWithReason(ctx, pks[i], reasons[0]);
        }
    }

    private void checkBeforeCancel(Context ctx, PurOrderChangeInfo info) throws BOSException, EASBizException {
        if (info == null) {
            return;
        }
        if (info.getBaseStatus() != null) {
            if (info.getBaseStatus().getValue() == 3) {
                throw new PurReqException(PurReqException.CANCEL_IS_CANCEL);
            }
            if (info.getBaseStatus().getValue() == 4) {
                throw new PurReqException(PurReqException.CANCEL_IS_AUDIT);
            }
            if (info.getBaseStatus().getValue() == 7) {
                throw new PurReqException(PurReqException.CANCEL_IS_CLOSED);
            }
        }
    }

    protected void passCancellation(Context ctx, PurOrderChangeInfo info, Object reason) throws BOSException, EASBizException {
        String setReason = null;
        if (reason instanceof ReasonCodeInfo) {
            setReason = ((ReasonCodeInfo)reason).getName(ctx.getLocale());
        } else if (reason instanceof String) {
            setReason = reason.toString();
        }
        info.setBaseStatus(BillBaseStatusEnum.DELETED);
        if (info.getEntries() != null) {
            PurOrderChangeEntryCollection entries = info.getEntries();
            int len = entries.size();
            for (int i = 0; i < len; ++i) {
                entries.get(i).setBaseStatus(EntryBaseStatusEnum.DELETED);
                entries.get(i).setReason(setReason);
            }
        }
        super._update(ctx, (IObjectPK)new ObjectUuidPK(info.getId().toString()), (IObjectValue)info);
    }

    @Override
    protected boolean _isExistOrderStatusAudit(Context ctx, String ids) throws EASBizException, BOSException {
        Connection con = null;
        Statement destRateStatement = null;
        ResultSet destRateSet = null;
        con = SCMBizProcessorUtil.getConnection((Context)ctx);
        try {
            destRateStatement = con.createStatement();
            String sql = "SELECT COUNT(*) FROM T_SM_purOrderentry where FSOURCEBILLENTRYID in (" + ids + ") and FBASESTATUS =4";
            destRateSet = destRateStatement.executeQuery(sql);
            destRateSet.next();
            if (destRateSet.getInt(1) <= 0) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
    }

    @Override
    protected void _handleWriteForOrder(Context ctx, IObjectCollection col, Map purReqEntryID, Map purReqId, Map purReqNumber) throws EASBizException, BOSException {
        int i;
        HashMap<Integer, String> srcObjectIDMap = new HashMap<Integer, String>();
        HashMap<Integer, String> destObjectIDMap = new HashMap<Integer, String>();
        BillTypeInfo billTypeInfo = new BillTypeInfo();
        billTypeInfo.setId(BOSUuid.read((String)this.getBillTypeId()));
        billTypeInfo.setName(this.getServerResource("PURORDERCHANGE", ctx));
        billTypeInfo.setNumber("225");
        for (i = 0; i < col.size(); ++i) {
            PurOrderChangeInfo colInfo = (PurOrderChangeInfo)col.getObject(i);
            PurOrderChangeInfo newInfo = new PurOrderChangeInfo();
            PurOrderChangeEntryCollection infoCol = colInfo.getEntries();
            newInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
            newInfo.setCreator(colInfo.getCreator());
            newInfo.setCreateTime(colInfo.getCreateTime());
            newInfo.setBillType(billTypeInfo);
            newInfo.setBizDate(colInfo.getBizDate());
            newInfo.setChangeType(colInfo.getChangeType());
            if (null != colInfo.getAlterrationReason() && !colInfo.getAlterrationReason().equalsIgnoreCase("")) {
                newInfo.setAlterrationReason(colInfo.getAlterrationReason());
            } else if (null != colInfo.getSourceBillId() && !colInfo.getSourceBillId().equalsIgnoreCase("")) {
                String number = purReqNumber.get(colInfo.getSourceBillId()).toString();
                newInfo.setAlterrationReason(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)"BOTP_SOURCE_REQCHANGE", (Locale)ctx.getOriginLocale()), number));
            }
            newInfo.setPurchaseOrgUnit(colInfo.getPurchaseOrgUnit());
            newInfo.setPurRequest(colInfo.getPurRequest());
            newInfo.setSourceBillId(colInfo.getSourceBillId());
            newInfo.setSourceBillType(colInfo.getSourceBillType());
            this.updateOrderQty(ctx, infoCol, purReqEntryID, purReqId, colInfo, newInfo);
            this.save(ctx, (CoreBaseInfo)newInfo);
            srcObjectIDMap.put(i, newInfo.getEntries().get(0).getSourceBillId().toString());
            destObjectIDMap.put(i, newInfo.getId().toString());
        }
        for (i = 0; i < col.size(); ++i) {
            BOTRelationInfo info = null;
            info = new BOTRelationInfo();
            info.setSrcObjectID(srcObjectIDMap.get(i).toString());
            info.setSrcEntityID("4075F47E");
            info.setDestEntityID("96B889BD");
            info.setDestObjectID(destObjectIDMap.get(i).toString());
            info.setOperatorID(ctx.getUserName());
            info.setBOTMappingID("EZIPpMwGTqmq1WRazje6eQRRIsQ=");
            info.setType(0);
            info.setIsEffected(true);
            info.setDate(new Date());
            BOTRelationFactory.getLocalInstance((Context)ctx).addnew(info);
        }
    }

    private void updateOrderQty(Context ctx, PurOrderChangeEntryCollection infoCol, Map purReqEntryID, Map purReqId, PurOrderChangeInfo colInfo, PurOrderChangeInfo newInfo) throws EASBizException, BOSException {
        for (int i = 0; i < infoCol.size(); ++i) {
            PurOrderChangeEntryInfo infoEntry = infoCol.get(i);
            String purReqEntryIdStr = purReqEntryID.get(infoEntry.getSourceBillEntryId()).toString();
            String purReqIdStr = purReqId.get(purReqEntryIdStr).toString();
            if (!BOSUuid.isValid((String)purReqEntryIdStr, (boolean)true)) continue;
            Connection con = null;
            Statement destRateStatement = null;
            con = SCMBizProcessorUtil.getConnection((Context)ctx);
            try {
                destRateStatement = con.createStatement();
                String sql = "SELECT FPARENTID  FROM  T_SM_purOrderEntry where  FSOURCEBILLENTRYID ='" + purReqEntryIdStr + "'";
                StringBuffer parentIdBuffer = new StringBuffer();
                ResultSet orderRateSet = destRateStatement.executeQuery(sql);
                String parentId = null;
                while (orderRateSet.next()) {
                    parentId = orderRateSet.getString(1);
                }
                if (!BOSUuid.isValid(parentId, (boolean)true)) continue;
                if (null != parentId) {
                    if (parentIdBuffer.length() != 0) {
                        parentIdBuffer.append(",");
                    }
                    parentIdBuffer.append("'");
                    parentIdBuffer.append(parentId);
                    parentIdBuffer.append("'");
                }
                if (parentIdBuffer.toString() == null) {
                    parentIdBuffer.append("''");
                }
                String orderIdSql = "SELECT FID  FROM T_SM_purOrder where FBASESTATUS = 4 and Fid in (" + parentIdBuffer + ") order by FAUDITTIME desc";
                StringBuffer orderIdBuffer = new StringBuffer();
                ResultSet orderIdRateSet = destRateStatement.executeQuery(orderIdSql);
                while (orderIdRateSet.next()) {
                    if (orderIdBuffer.length() != 0) {
                        orderIdBuffer.append(",");
                    }
                    orderIdBuffer.append(orderIdRateSet.getString(1));
                }
                if (parentIdBuffer.toString() == null) {
                    orderIdBuffer.append("''");
                }
                List<PurOrderEntryInfo> entryList = this.getPurOrderEntryCol(ctx, purReqEntryIdStr.toString(), orderIdBuffer.toString());
                BigDecimal changeBaseQty = infoEntry.getChangeBaseQty();
                if (changeBaseQty == null) {
                    changeBaseQty = new BigDecimal("0.00");
                }
                for (int j = 0; j < entryList.size(); ++j) {
                    PurOrderEntryInfo entry = entryList.get(j);
                    BigDecimal qty = entry.getQty();
                    BigDecimal totalReceiveQty = entry.getTotalReceiveQty();
                    BigDecimal totalReceiptQty = entry.getTotalReceiptQty();
                    BigDecimal totalReturnedQty = entry.getTotalReturnedQty();
                    BigDecimal totalSupplyStockQty = entry.getTotalSupplyStockQty();
                    BigDecimal allowChangeQty = BIGZERO;
                    allowChangeQty = qty.compareTo(totalReceiveQty) < 0 ? BIGZERO : (totalReceiveQty.compareTo(totalReceiptQty.add(totalSupplyStockQty).subtract(totalReturnedQty)) < 0 ? qty.subtract(totalReceiptQty.add(totalSupplyStockQty).subtract(totalReturnedQty)) : qty.subtract(totalReceiveQty));
                    String materialID = entry.getMaterial().getId().toString();
                    String unitID = entry.getUnit().getId().toString();
                    String baseUnitID = entry.getBaseUnit().getId().toString();
                    PurOrderChangeEntryInfo purOrderChangeEntryInfo = new PurOrderChangeEntryInfo();
                    purOrderChangeEntryInfo.setBaseStatus(EntryBaseStatusEnum.TEMPORARILYSAVED);
                    PurOrderInfo purOrderInfo = entry.getParent();
                    purOrderChangeEntryInfo.setSourceBillEntryId(infoEntry.getSourceBillEntryId());
                    purOrderChangeEntryInfo.setSourceBillId(infoEntry.getSourceBillId());
                    purOrderChangeEntryInfo.setPurOrder(purOrderInfo);
                    purOrderChangeEntryInfo.setPurOrderEntry(entry);
                    purOrderChangeEntryInfo.setParent(newInfo);
                    purOrderChangeEntryInfo.setApprovalQty(entry.getQty());
                    purOrderChangeEntryInfo.setBaseQty(this.getBaseUnitQty(ctx, materialID, unitID, baseUnitID, qty));
                    purOrderChangeEntryInfo.setMaterial(entry.getMaterial());
                    purOrderChangeEntryInfo.setBaseUnit(entry.getBaseUnit());
                    purOrderChangeEntryInfo.setUnit(entry.getUnit());
                    purOrderChangeEntryInfo.setOriginDeliver(entry.getDeliveryDate());
                    purOrderChangeEntryInfo.setDeliverTime(this.calChangeDeliverTime(infoEntry, entry));
                    purOrderChangeEntryInfo.setChangeDays(infoEntry.getChangeDays());
                    if (changeBaseQty.compareTo(BIGZERO) > 0) {
                        if (changeBaseQty.compareTo(allowChangeQty) > 0) {
                            purOrderChangeEntryInfo.setChangeQty(allowChangeQty);
                            purOrderChangeEntryInfo.setChangeBaseQty(this.getBaseUnitQty(ctx, materialID, unitID, baseUnitID, allowChangeQty));
                            changeBaseQty = changeBaseQty.subtract(this.getBaseUnitQty(ctx, materialID, unitID, baseUnitID, allowChangeQty));
                        } else {
                            if (changeBaseQty.compareTo(BIGZERO) == 0) continue;
                            purOrderChangeEntryInfo.setChangeQty(this.getBaseUnitQty(ctx, materialID, unitID, baseUnitID, changeBaseQty));
                            purOrderChangeEntryInfo.setChangeBaseQty(changeBaseQty);
                            changeBaseQty = BIGZERO;
                        }
                    } else if (changeBaseQty.add(allowChangeQty).compareTo(BIGZERO) < 0) {
                        purOrderChangeEntryInfo.setChangeQty(BIGZERO.subtract(allowChangeQty));
                        purOrderChangeEntryInfo.setChangeBaseQty(this.getBaseUnitQty(ctx, materialID, unitID, baseUnitID, BIGZERO.subtract(allowChangeQty)));
                        changeBaseQty = changeBaseQty.add(this.getBaseUnitQty(ctx, materialID, unitID, baseUnitID, allowChangeQty));
                    } else {
                        if (changeBaseQty.compareTo(BIGZERO) == 0) continue;
                        purOrderChangeEntryInfo.setChangeQty(this.getBaseUnitQty(ctx, materialID, unitID, baseUnitID, changeBaseQty));
                        purOrderChangeEntryInfo.setChangeBaseQty(changeBaseQty);
                        changeBaseQty = BIGZERO;
                    }
                    PurRequestInfo purReqInfo = PurRequestFactory.getLocalInstance(ctx).getPurRequestInfo((IObjectPK)new ObjectUuidPK(purReqIdStr));
                    newInfo.setPurRequest(purReqInfo);
                    newInfo.getEntries().add(purOrderChangeEntryInfo);
                }
                continue;
            }
            catch (Exception e) {
                throw new BOSException(e.getMessage());
            }
            finally {
                SQLUtils.cleanup((Connection)con);
            }
        }
    }

    private Date calChangeDeliverTime(PurOrderChangeEntryInfo infoEntry, PurOrderEntryInfo entry) throws BOSException {
        if (null == infoEntry.getChangeDays()) {
            return entry.getDeliveryDate();
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Date originDeliver = entry.getDeliveryDate();
        Date deliverTime = new Date();
        int changeDays = infoEntry.getChangeDays().intValue();
        Calendar ca = Calendar.getInstance();
        ca.setTime(originDeliver);
        ca.add(5, changeDays);
        deliverTime = ca.getTime();
        return deliverTime;
    }

    private List<PurOrderEntryInfo> getPurOrderEntryCol(Context ctx, String purReqEntryIdStr, String parentIds) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo tmpFilter = new FilterInfo();
        tmpFilter.getFilterItems().add(new FilterItemInfo("sourceBillEntryId", (Object)purReqEntryIdStr, CompareType.INCLUDE));
        tmpFilter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)parentIds, CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo("parent.number"));
        sic.add(new SelectorItemInfo("purRequestID"));
        sic.add(new SelectorItemInfo("baseUnit.name"));
        sic.add(new SelectorItemInfo("baseUnit.qtyPrecision"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add(new SelectorItemInfo("project.id"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("trackNo.number"));
        sic.add(new SelectorItemInfo("trackNo.id"));
        sic.add(new SelectorItemInfo("trackNo.name"));
        sic.add(new SelectorItemInfo("rowType.id"));
        sic.add(new SelectorItemInfo("rowType.isHasMaterialNumber"));
        sic.add(new SelectorItemInfo("parent.purchaseGroup.number"));
        sic.add(new SelectorItemInfo("parent.purchaseGroup.id"));
        sic.add(new SelectorItemInfo("parent.purchaseGroup.name"));
        sic.add(new SelectorItemInfo("parent.purchasePerson.number"));
        sic.add(new SelectorItemInfo("parent.purchasePerson.id"));
        sic.add(new SelectorItemInfo("parent.purchasePerson.name"));
        sic.add(new SelectorItemInfo("parent.supplier.number"));
        sic.add(new SelectorItemInfo("parent.supplier.id"));
        sic.add(new SelectorItemInfo("parent.supplier.name"));
        sic.add(new SelectorItemInfo("price"));
        sic.add(new SelectorItemInfo("deliveryDate"));
        sic.add(new SelectorItemInfo("baseQty"));
        sic.add(new SelectorItemInfo("qty"));
        sic.add(new SelectorItemInfo("material.number"));
        sic.add(new SelectorItemInfo("material.name"));
        sic.add(new SelectorItemInfo("material.model"));
        sic.add(new SelectorItemInfo("unit.name"));
        sic.add(new SelectorItemInfo("unit.qtyPrecision"));
        sic.add(new SelectorItemInfo("seq"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("totalReceiveQty"));
        sic.add(new SelectorItemInfo("totalReceiptQty"));
        sic.add(new SelectorItemInfo("totalReturnedQty"));
        sic.add(new SelectorItemInfo("totalSupplyStockQty"));
        sic.add(new SelectorItemInfo("materialName"));
        sic.add(new SelectorItemInfo("sourceBillType.name"));
        sic.add(new SelectorItemInfo("sourceBillType.id"));
        sic.add(new SelectorItemInfo("sourceBillType.number"));
        sic.add(new SelectorItemInfo("sourceBillEntrySeq"));
        view.setSelector(sic);
        view.setFilter(tmpFilter);
        PurOrderEntryCollection col = PurOrderEntryFactory.getLocalInstance(ctx).getPurOrderEntryCollection(view);
        HashMap entryMap = new HashMap();
        ArrayList<PurOrderEntryInfo> entryList = new ArrayList<PurOrderEntryInfo>();
        for (int i = 0; i < col.size(); ++i) {
            entryList.add(col.get(i));
        }
        return entryList;
    }

    private BigDecimal getBaseUnitQty(Context ctx, String materialID, String unitID, String baseUnitID, BigDecimal qty) throws EASBizException, BOSException {
        MeasureUnitInfo unit = new MeasureUnitInfo();
        MeasureUnitInfo baseUnit = new MeasureUnitInfo();
        unit.setId(BOSUuid.read((String)unitID));
        baseUnit.setId(BOSUuid.read((String)baseUnitID));
        return SCMUtil.getExchangeQtyForClient((Context)ctx, (String)materialID, (MeasureUnitInfo)baseUnit, (MeasureUnitInfo)unit, (BigDecimal)qty);
    }

    protected String getBatchMethodName(Context ctx, String name) throws BaseException {
        if (ctx.get((Object)"CONTEXT_KEY_ISBATCHACTION") == null || Boolean.FALSE.equals(ctx.get((Object)"CONTEXT_KEY_ISBATCHACTION"))) {
            return null;
        }
        return "batch" + name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    protected SelectorItemCollection getSelector(boolean isNeedEntrySelector) {
        return SCMSelectorFactory.getPurOrderChangeSelector((boolean)isNeedEntrySelector);
    }
}

